/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTask;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.cpp.CPPTestCase;
import com.jetbrains.cidr.cpp.execution.build.tasks.CLionInstallTaskImpl;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTaskImpl;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;

public abstract class CPPProjectFixture<BUILD_CONFIGURATION_TYPE>
extends CidrProjectFixture<BUILD_CONFIGURATION_TYPE> {
    protected boolean myShouldCheckProjectErrors;

    public CPPProjectFixture(@NotNull CidrTestDataFixture testDataFixture) {
        if (testDataFixture == null) {
            CPPProjectFixture.$$$reportNull$$$0(0);
        }
        super(testDataFixture);
        this.myShouldCheckProjectErrors = true;
    }

    @Override
    public void collectAllowedRoots(@NotNull List<? super String> roots) {
        if (roots == null) {
            CPPProjectFixture.$$$reportNull$$$0(1);
        }
        super.collectAllowedRoots(roots);
        CPPProjectFixture.collectAllowedRootsBase(roots);
    }

    public static void collectAllowedRootsBase(@NotNull List<? super String> roots) {
        if (roots == null) {
            CPPProjectFixture.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isMac) {
            String xcode = null;
            try {
                xcode = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xcode-select", "-print-path"}));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (xcode != null) {
                roots.add(xcode);
                try {
                    roots.add(new File(xcode).getCanonicalPath());
                }
                catch (IOException e) {
                    CPPProjectFixture.fail((String)e.getMessage());
                }
            }
            Collections.addAll(roots, "/System/Library/Frameworks", "/Library");
            Collections.addAll(roots, "/opt/local/include/", "/opt/local/lib/");
            Collections.addAll(roots, "/usr/local/Cellar");
        }
        if (SystemInfo.isUnix || SystemInfo.isMac) {
            Collections.addAll(roots, "/usr/lib", "/usr/include", "/usr/local/lib", "/usr/local/include", "/usr/local/cuda/include", "/usr/local/cuda/targets/x86_64-linux/include", "/usr/local/cuda-10.2/include", "/usr/local/cuda-10.2/targets/x86_64-linux/include", "/opt/rh/devtoolset-2/root/usr/lib", "/opt/rh/devtoolset-2/root/usr/include");
        }
        if (SystemInfo.isWindows) {
            Cygwin cygwin;
            ArrayList<String> basePaths = new ArrayList<String>();
            MinGW mingw = CPPTestCase.getTestMinGW();
            if (mingw != null) {
                basePaths.add(mingw.getHomePath());
                if (mingw.isMinGW64()) {
                    basePaths.add(mingw.getGCCHomePath());
                } else {
                    basePaths.add(mingw.getSubFilePath("mingw32"));
                }
            }
            if ((cygwin = CPPTestCase.getTestCygwin()) != null) {
                basePaths.add(cygwin.getHomePath());
            }
            for (String each : basePaths) {
                roots.add(each + "/lib");
                roots.add(each + "/usr");
                roots.add(each + "/include");
            }
        }
    }

    @Override
    public void closeProjectAndCleanup() {
        super.closeProjectAndCleanup();
        if (SystemInfo.isWindows) {
            try {
                for (WinProcess process : WinProcess.all()) {
                    try {
                        String commandLine = process.getCommandLine();
                        if (StringUtil.containsIgnoreCase((String)commandLine, (String)"java")) continue;
                        for (String each : Arrays.asList("mingw", "cygwin", "cmake.exe", "gcc.exe", "g++.exe", "collect2.exe", "ld.exe", "cc1.exe", "cc1plus")) {
                            if (!StringUtil.containsIgnoreCase((String)commandLine, (String)each)) continue;
                            process.killRecursively();
                        }
                    }
                    catch (WinpException winpException) {}
                }
            }
            catch (WinpException winpException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void checkProjectOpenedCorrectly() {
        super.checkProjectOpenedCorrectly();
        if (this.myShouldCheckProjectErrors) {
            this.checkCPPProjectOpenedCorrectly();
        }
    }

    protected abstract void checkCPPProjectOpenedCorrectly();

    public void setShouldCheckProjectErrors(boolean value) {
        this.myShouldCheckProjectErrors = value;
    }

    @NotNull
    public Collection<VirtualFile> getWorkspaceSourceVirtualFiles() {
        if (!this.isProjectOpened()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                CPPProjectFixture.$$$reportNull$$$0(3);
            }
            return list;
        }
        Project project2 = this.getProject();
        Collection collection = OCWorkspace.getInstance((Project)project2).getConfigurations().stream().flatMap(it -> it.getSources().stream()).collect(Collectors.toSet());
        if (collection == null) {
            CPPProjectFixture.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<File> getWorkspaceSystemLibraryRoots() {
        Collection collection = this.getWorkspaceSearchPaths().filter(it -> !it.isFrameworksSearchPath() && it.getKind().isSystem()).map(it -> new File(it.getPath())).collect(Collectors.toList());
        if (collection == null) {
            CPPProjectFixture.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public Collection<File> getWorkspaceUserLibraryRoots() {
        Collection collection = this.getWorkspaceSearchPaths().filter(it -> !it.isFrameworksSearchPath() && it.getKind().isUser()).map(it -> new File(it.getPath())).collect(Collectors.toList());
        if (collection == null) {
            CPPProjectFixture.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private Stream<HeadersSearchPath> getWorkspaceSearchPaths() {
        if (!this.isProjectOpened()) {
            return Stream.empty();
        }
        Project project2 = this.getProject();
        return OCWorkspace.getInstance((Project)project2).getConfigurations().stream().flatMap(it -> it.getAllCompilerSettings()).flatMap(it -> it.getHeadersSearchPaths().stream());
    }

    public void assertWorkspaceSourceFiles(String ... expectedRelativePaths) {
        this.assertFiles(this.getWorkspaceSourceVirtualFiles(), expectedRelativePaths);
    }

    public void assertSearchScopeProjectVirtualFiles(String ... expectedRelativePaths) {
        Collection explicitFiles = (Collection)ReadAction.compute(() -> OCSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)this.getProject()));
        this.assertFiles((Collection<VirtualFile>)explicitFiles, expectedRelativePaths);
    }

    public Pair<Boolean, String> compileFiles(VirtualFile ... files) throws Exception {
        if (files == null) {
            CPPProjectFixture.$$$reportNull$$$0(7);
        }
        return this.executeProjectTask((manager, callback) -> manager.compile(files).onProcessed(callback));
    }

    public Pair<Boolean, String> buildConfiguration(CidrBuildConfiguration ... configurations) throws Exception {
        if (configurations == null) {
            CPPProjectFixture.$$$reportNull$$$0(8);
        }
        return this.executeProjectTask((manager, callback) -> manager.build((ProjectModelBuildableElement[])configurations).onProcessed(callback));
    }

    public Pair<Boolean, String> rebuildConfiguration(CidrBuildConfiguration ... configurations) throws Exception {
        if (configurations == null) {
            CPPProjectFixture.$$$reportNull$$$0(9);
        }
        return this.executeProjectTask((manager, callback) -> manager.rebuild((ProjectModelBuildableElement[])configurations).onProcessed(callback));
    }

    public Pair<Boolean, String> cleanConfiguration(@NotNull CidrBuildConfiguration configuration2) throws Exception {
        if (configuration2 == null) {
            CPPProjectFixture.$$$reportNull$$$0(10);
        }
        return this.executeProjectTasks(new ProjectTask[]{new CidrCleanTaskImpl(configuration2)});
    }

    public Pair<Boolean, String> installConfiguration(@NotNull CidrBuildConfiguration configuration2) throws Exception {
        if (configuration2 == null) {
            CPPProjectFixture.$$$reportNull$$$0(11);
        }
        return this.executeProjectTasks(new ProjectTask[]{new CLionInstallTaskImpl(configuration2)});
    }

    public Pair<Boolean, String> buildModule(@NotNull Module module) throws Exception {
        if (module == null) {
            CPPProjectFixture.$$$reportNull$$$0(12);
        }
        return this.executeProjectTask((manager, callback) -> manager.build(new Module[]{module}).onProcessed(callback));
    }

    public Pair<Boolean, String> rebuildModule(@NotNull Module module) throws Exception {
        if (module == null) {
            CPPProjectFixture.$$$reportNull$$$0(13);
        }
        return this.executeProjectTask((manager, callback) -> manager.rebuild(new Module[]{module}).onProcessed(callback));
    }

    @Override
    @NotNull
    public OCCompilerKind getCompilerType() {
        if (SystemInfo.isWindows) {
            switch (CPPTestCase.getTestCPPEnvironment().getToolSet().getKind()) {
                case MSVC: {
                    MSVCCompilerKind mSVCCompilerKind = MSVCCompilerKind.INSTANCE;
                    if (mSVCCompilerKind == null) {
                        CPPProjectFixture.$$$reportNull$$$0(14);
                    }
                    return mSVCCompilerKind;
                }
                case MINGW: 
                case CYGWIN: 
                case WSL: {
                    GCCCompilerKind gCCCompilerKind = GCCCompilerKind.INSTANCE;
                    if (gCCCompilerKind == null) {
                        CPPProjectFixture.$$$reportNull$$$0(15);
                    }
                    return gCCCompilerKind;
                }
            }
        }
        OCCompilerKind oCCompilerKind = super.getCompilerType();
        if (oCCompilerKind == null) {
            CPPProjectFixture.$$$reportNull$$$0(16);
        }
        return oCCompilerKind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFixture";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/CPPProjectFixture";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/CPPProjectFixture";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaceSourceVirtualFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaceSystemLibraryRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaceUserLibraryRoots";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectAllowedRoots";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectAllowedRootsBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compileFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rebuildConfiguration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cleanConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "installConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildModule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rebuildModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

