/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrDebugProjectMarkup;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerTestCase;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.execution.debugger.DebuggerDriverKind;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public abstract class CidrDebuggerDriverThreadsTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>>
extends CidrDebuggerTestCase<PROJECT_FIXTURE, EXECUTION_FIXTURE, DEBUGGING_FIXTURE, CidrDebugProjectMarkup> {
    public CidrDebuggerDriverThreadsTestCase(DebuggerDriverKind backend, String fixtureProjectFileRelativePath) {
        super(backend, CidrDebugProjectMarkup.TARGET_FOR_THREADS, new CidrTestProjectDescription(fixtureProjectFileRelativePath));
    }

    @Override
    @NotNull
    protected CidrDebugProjectMarkup createProjectMarkup(@NotNull VirtualFile projectDir) {
        if (projectDir == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(0);
        }
        return new CidrDebugProjectMarkup(projectDir);
    }

    @Test
    public void testCollectingThreads() throws Exception {
        BlockingQueue events = this.startDriverAndLaunch("fork_2_threads", CidrDebuggingFixture.DriverEvent.Kind.anyOf(CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, CidrDebuggingFixture.DriverEvent.Kind.INTERRUPTED), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_NOT_STARTED), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_STARTED), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_EXITED));
        DebuggerDriver.StopPlace stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_NOT_STARTED);
        List notStartedThreads = this.myDriver.getThreads();
        CidrDebuggerDriverThreadsTestCase.assertContainsElements(notStartedThreads, stopPlace.thread);
        this.myDriver.resume();
        stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_STARTED);
        List actualThreads = this.myDriver.getThreads();
        CidrDebuggerDriverThreadsTestCase.assertContainsElements(actualThreads, stopPlace.thread);
        String forkedFuncNameRegex = "forked_thread_func";
        List<LLThread> startedThreads = this.filterTargetThreads(actualThreads, "forked_thread_func");
        if (2 != startedThreads.size()) {
            String status = this.dumpThreadsStatus(actualThreads);
            CidrDebuggerDriverThreadsTestCase.fail((String)String.format("Expected 2 forked threads, detected: %d\nStatus:\n%s", startedThreads.size(), status));
        }
        this.myDriver.resume();
        stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREADS_EXITED);
        actualThreads = this.myDriver.getThreads();
        CidrDebuggerDriverThreadsTestCase.assertContainsElements(actualThreads, stopPlace.thread);
        List<LLThread> exitedThreads = this.filterTargetThreads(actualThreads, "forked_thread_func");
        if (0 != exitedThreads.size()) {
            String status = this.dumpThreadsStatus(actualThreads);
            CidrDebuggerDriverThreadsTestCase.fail((String)String.format("Expected 2 forked threads, detected: %d\nStatus:\n%s", startedThreads.size(), status));
        }
    }

    @Test
    public void testBreakpointInsideThread() throws Exception {
        BlockingQueue events = this.startDriverAndLaunch("fork_thread", CidrDebuggingFixture.DriverEvent.Kind.anyOf(CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, CidrDebuggingFixture.DriverEvent.Kind.INTERRUPTED), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER));
        DebuggerDriver.StopPlace stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER);
        CidrDebuggingFixture.assertUnorderedLLValues(this.myDriver.getVariables(stopPlace.thread.getId(), stopPlace.frame.getIndex()), "thread_param", "local");
    }

    @Test
    public void testCollectedThreads() throws Exception {
        int i;
        int nrTotalForkedThreads = 3;
        BlockingQueue events = this.startDriverAndLaunch("fork_3_threads_chain", CidrDebuggingFixture.DriverEvent.Kind.anyOf(CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, CidrDebuggingFixture.DriverEvent.Kind.INTERRUPTED), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_MAIN), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_ENTERED), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_EXITED));
        DebuggerDriver.StopPlace stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_MAIN);
        CidrDebuggerDriverThreadsTestCase.assertMatches(stopPlace.thread.getDisplayName(), "^Thread-" + this.mainThreadID() + "\\b.*$");
        CidrDebuggerDriverThreadsTestCase.assertEquals((String)"STOPPED", (String)stopPlace.thread.getState());
        List baseThreads = this.myDriver.getThreads();
        int lastBaseThreadId = baseThreads.size() + this.mainThreadID() - 1;
        CidrDebuggerDriverThreadsTestCase.assertContainsElements(baseThreads, stopPlace.thread);
        CidrDebuggerDriverThreadsTestCase.assertEquals((long)this.mainThreadID(), (long)stopPlace.thread.getId());
        this.myDriver.resume();
        for (i = 1; i <= 3; ++i) {
            stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
            this.doCheckForkedThreads(stopPlace, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_ENTERED, baseThreads, lastBaseThreadId, i);
            this.myDriver.resume();
        }
        for (i = 3; i >= 1; --i) {
            stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
            this.doCheckForkedThreads(stopPlace, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_CHAIN_EXITED, baseThreads, lastBaseThreadId, i);
            this.myDriver.resume();
        }
        CidrDebuggingFixture.assertNoMoreEvents(events, 300L);
    }

    private void doCheckForkedThreads(@NotNull DebuggerDriver.StopPlace stopPlace, int line, @NotNull List<LLThread> baseThreads, int lastBaseThreadId, int nrForkedThreads) throws ExecutionException, DebuggerCommandException {
        if (stopPlace == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(1);
        }
        if (baseThreads == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(2);
        }
        this.assertFrame(stopPlace.frame, (Integer)0, this.getExpectedSourceFilePath(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS), (Integer)line);
        CidrDebuggerDriverThreadsTestCase.assertMatches(stopPlace.thread.getDisplayName(), "^Thread-" + (lastBaseThreadId + nrForkedThreads) + "\\b.*$");
        List allThreads = this.myDriver.getThreads();
        List<LLThread> forkedThreads = this.filterTargetThreads(allThreads, "fork_thread_chain");
        if (nrForkedThreads != forkedThreads.size()) {
            String status = this.dumpThreadsStatus(allThreads);
            CidrDebuggerDriverThreadsTestCase.fail((String)String.format("Expected %d forked threads, detected: %d\nStatus:\n%s", nrForkedThreads, forkedThreads.size(), status));
        }
        CidrDebuggerDriverThreadsTestCase.assertContainsElements(forkedThreads, stopPlace.thread);
        CidrDebuggerDriverThreadsTestCase.assertDoesntContain(baseThreads, stopPlace.thread);
        ArrayList newThreads = new ArrayList(allThreads);
        newThreads.removeAll(baseThreads);
        CidrDebuggerDriverThreadsTestCase.assertSameElements(forkedThreads, newThreads);
        CidrDebuggerDriverThreadsTestCase.assertTrue(((long)nrForkedThreads <= stopPlace.thread.getId() ? 1 : 0) != 0);
        for (LLThread thread : forkedThreads) {
            CidrDebuggerDriverThreadsTestCase.assertMatches(thread.getDisplayName(), "^Thread-\\d+\\b.*$");
            CidrDebuggerDriverThreadsTestCase.assertEquals((String)"STOPPED", (String)thread.getState());
        }
        CidrDebuggerDriverThreadsTestCase.assertSize(nrForkedThreads, forkedThreads);
    }

    @Test
    public void testCollectingThreadFrames() throws Exception {
        BlockingQueue events = this.startDriverAndLaunch("fork_thread", CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER));
        DebuggerDriver.StopPlace stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        CidrDebuggerDriverThreadsTestCase.assertNotNull((Object)CidrDebuggerDriverThreadsTestCase.findFrame(this.myDriver.getFrames((long)stopPlace.thread.getId(), (int)0, (int)100).list, "forked_thread_func"));
        this.checkAndGetMainThreadAndFrame(stopPlace);
    }

    @Test
    public void testCollectingThreadVariables() throws Exception {
        BlockingQueue events = this.startDriverAndLaunch("fork_thread", CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER));
        DebuggerDriver.StopPlace stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        CidrDebuggingFixture.assertUnorderedLLValues(this.myDriver.getVariables(stopPlace.thread.getId(), stopPlace.frame.getIndex()), "thread_param", "local");
        Pair<LLThread, LLFrame> main = this.fetchDataFromMainThread(stopPlace);
        CidrDebuggingFixture.assertUnorderedLLValues(this.myDriver.getVariables(((LLThread)main.first).getId(), ((LLFrame)main.second).getIndex()), "argc", "argv", "i");
    }

    @Test
    public void testSteppingInsideStoppedThread() throws Exception {
        BlockingQueue events = this.startDriverAndLaunch("fork_thread", CidrDebuggingFixture.DriverEvent.Kind.anyOf(CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, CidrDebuggingFixture.DriverEvent.Kind.INTERRUPTED), CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER));
        DebuggerDriver.StopPlace stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        this.fetchDataFromMainThread(stopPlace);
        this.myDriver.stepOut();
        long originalThreadId = stopPlace.thread.getId();
        stopPlace = ((CidrDebuggingFixture.DriverSuspendEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.INTERRUPTED)).stopPlace;
        CidrDebuggerDriverThreadsTestCase.assertEquals((long)originalThreadId, (long)stopPlace.thread.getId());
    }

    @Test
    public void testEvaluateOnCorrectThread() throws Exception {
        Pattern consolePattern = Pattern.compile(".*\\$\\d = \\d.*", 32);
        BlockingQueue events = this.startDriverAndLaunch("fork_thread", CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT, CidrDebuggerDriverThreadsTestCase.withBreakpoint(((CidrDebugProjectMarkup)this.myProjectMarkup).FILE_THREADS, ((CidrDebugProjectMarkup)this.myProjectMarkup).LINE_THREAD_FUNC_INNER));
        DebuggerDriver.StopPlace stopPlace = ((CidrDebuggingFixture.DriverCodepointEvent)CidrDebuggingFixture.waitForEvent(events, CidrDebuggingFixture.DriverEvent.Kind.BREAKPOINT)).stopPlace;
        BlockingQueue<String> outputLines = this.spyOnOutputLines();
        Pair<LLThread, LLFrame> main = this.fetchDataFromMainThread(stopPlace);
        this.myDriver.executeConsoleCommand("print local");
        CidrDebuggingFixture.waitOrDrainUntilLine(outputLines, consolePattern, 1000);
        this.myDriver.executeConsoleCommand(stopPlace.thread.getId(), stopPlace.frame.getIndex(), "print local");
        CidrDebuggingFixture.waitOrDrainUntilLine(outputLines, consolePattern, 1000);
        this.myDriver.executeConsoleCommand(((LLThread)main.first).getId(), ((LLFrame)main.second).getIndex(), "print argc");
        CidrDebuggingFixture.waitOrDrainUntilLine(outputLines, consolePattern, 1000);
        this.myDriver.executeConsoleCommand("print local");
        CidrDebuggingFixture.waitOrDrainUntilLine(outputLines, consolePattern, 1000);
    }

    private Pair<LLThread, LLFrame> fetchDataFromMainThread(DebuggerDriver.StopPlace stopPlace) throws ExecutionException, DebuggerCommandException {
        Pair<LLThread, LLFrame> threadAndFrame = this.checkAndGetMainThreadAndFrame(stopPlace);
        LLThread otherThread = (LLThread)threadAndFrame.first;
        this.myDriver.getVariables(otherThread.getId(), ((LLFrame)threadAndFrame.second).getIndex());
        return threadAndFrame;
    }

    @NotNull
    private Pair<LLThread, LLFrame> checkAndGetMainThreadAndFrame(DebuggerDriver.StopPlace stopPlace) throws ExecutionException, DebuggerCommandException {
        LLFrame cloneFrame = null;
        LLThread cloneThread = null;
        List threads = this.myDriver.getThreads();
        for (LLThread thread : threads) {
            if (thread.getId() == stopPlace.thread.getId()) continue;
            List frames = this.myDriver.getFrames((long)thread.getId(), (int)0, (int)100).list;
            LLFrame frame = CidrDebuggerDriverThreadsTestCase.findFrame(frames, "main_threads");
            if (frame != null) {
                Pair pair = Pair.create((Object)thread, (Object)frame);
                if (pair == null) {
                    CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(3);
                }
                return pair;
            }
            if (!SystemInfo.isLinux || this.myBackend != DebuggerDriverKind.LLDB || cloneFrame != null) continue;
            cloneFrame = CidrDebuggerDriverThreadsTestCase.findFrame(frames, "(__)?clone");
            cloneThread = thread;
        }
        if (cloneFrame != null) {
            Pair pair = Pair.create(cloneThread, cloneFrame);
            if (pair == null) {
                CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(4);
            }
            return pair;
        }
        CidrDebuggerDriverThreadsTestCase.fail((String)("Main thread not found among " + threads));
        Pair pair = Pair.empty();
        if (pair == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(5);
        }
        return pair;
    }

    @Nullable
    private static LLFrame findFrame(@NotNull List<LLFrame> frames, @RegExp String functionName) {
        if (frames == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(6);
        }
        return (LLFrame)ContainerUtil.find(frames, it -> it.getFunction().matches(".*" + functionName + ".*"));
    }

    @NotNull
    private List<LLThread> filterTargetThreads(@NotNull List<LLThread> threads, @RegExp @NotNull String funcName) throws ExecutionException, DebuggerCommandException {
        if (threads == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(7);
        }
        if (funcName == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(8);
        }
        ArrayList<LLThread> targetThreads = new ArrayList<LLThread>();
        for (LLThread thread : threads) {
            if (CidrDebuggerDriverThreadsTestCase.findFrame(this.myDriver.getFrames((long)thread.getId(), (int)0, (int)100).list, funcName) == null) continue;
            targetThreads.add(thread);
        }
        ArrayList<LLThread> arrayList = targetThreads;
        if (arrayList == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private String dumpThreadsStatus(@NotNull List<LLThread> threads) throws ExecutionException, DebuggerCommandException {
        if (threads == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(10);
        }
        StringBuilder threadsState = new StringBuilder();
        for (LLThread thread : threads) {
            threadsState.append(thread.toString());
            threadsState.append(" : ");
            DebuggerDriver.ResultList frames = this.myDriver.getFrames(thread.getId(), 0, 20);
            threadsState.append(frames.list.toString());
            if (frames.hasMore) {
                threadsState.append("...");
            }
            threadsState.append("\n");
        }
        String string = threadsState.toString();
        if (string == null) {
            CidrDebuggerDriverThreadsTestCase.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseThreads";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerDriverThreadsTestCase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threads";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerDriverThreadsTestCase";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAndGetMainThreadAndFrame";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterTargetThreads";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpThreadsStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProjectMarkup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCheckForkedThreads";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFrame";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterTargetThreads";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dumpThreadsStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

