/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.fixtures.OCMockWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class OCMockProjectReader {
    public static final String EXTENSION = "yaml";

    public static void read(@NotNull File projectFile, @NotNull OCMockWorkspace mockWorkspace) {
        if (projectFile == null) {
            OCMockProjectReader.$$$reportNull$$$0(0);
        }
        if (mockWorkspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(1);
        }
        OCWorkspace.ModifiableModel model = mockWorkspace.getDelegate().getModifiableModel(mockWorkspace.getClientKey(), true);
        try {
            OCMockProjectReader.doRead(projectFile, mockWorkspace, model);
            model.preCommit();
            WriteAction.run(() -> ((OCWorkspace.ModifiableModel)model).commit());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            model.dispose();
        }
    }

    private static void doRead(@NotNull File projectFile, @NotNull OCMockWorkspace mockWorkspace, @NotNull OCWorkspace.ModifiableModel workspaceModel) throws IOException {
        Yaml yaml;
        Object object;
        if (projectFile == null) {
            OCMockProjectReader.$$$reportNull$$$0(2);
        }
        if (mockWorkspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(3);
        }
        if (workspaceModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(4);
        }
        if ((object = (yaml = new Yaml()).load(FileUtil.loadFile((File)projectFile, (Charset)StandardCharsets.UTF_8))) == null) {
            return;
        }
        if (!(object instanceof Map)) {
            throw new RuntimeException("Unexpected project format " + object);
        }
        File baseDir = projectFile.getParentFile();
        LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(baseDir), false, true, null);
        VirtualFile virtualFileDir = LocalFileSystem.getInstance().findFileByIoFile(baseDir);
        if (virtualFileDir == null) {
            throw new RuntimeException("Basedir not found " + baseDir);
        }
        Map projectEntriesMap = (Map)object;
        Object projectAttribute = projectEntriesMap.get("project");
        if (projectAttribute instanceof Map && Boolean.FALSE.equals(((Map)projectAttribute).get("content_root_as_source_folder"))) {
            mockWorkspace.setContentRootAsSourceFolder(false);
        }
        OCMockProjectReader.readGeneratedSources(mockWorkspace, virtualFileDir, projectEntriesMap);
        Collection<Object> profiles = Collections.singletonList(null);
        Object profilesAttribute = projectEntriesMap.get("profiles");
        if (profilesAttribute instanceof List) {
            profiles = (Collection)profilesAttribute;
        }
        for (String string : profiles) {
            if (!projectEntriesMap.containsKey("configs")) {
                OCResolveConfiguration.ModifiableModel config = OCMockProjectReader.addConfiguration(workspaceModel, "default", string);
                OCMockWorkspace.CompilerSettingsData compilerSettings = OCMockProjectReader.readConfigOptions(config, virtualFileDir, projectEntriesMap);
                OCMockProjectReader.readFiles(mockWorkspace, config, compilerSettings, virtualFileDir, projectEntriesMap);
                return;
            }
            Object configs = projectEntriesMap.get("configs");
            if (configs == null) {
                return;
            }
            for (Object eachConfig : (List)configs) {
                boolean inlinedFiles;
                Set entries = ((Map)eachConfig).entrySet();
                Iterator iterator = entries.iterator();
                Map.Entry header = iterator.next();
                String configId = (String)header.getKey();
                OCResolveConfiguration.ModifiableModel configModel = OCMockProjectReader.addConfiguration(workspaceModel, configId, string);
                LinkedHashMap configMap = new LinkedHashMap();
                while (iterator.hasNext()) {
                    Map.Entry next = iterator.next();
                    configMap.put((String)next.getKey(), next.getValue());
                }
                OCMockWorkspace.CompilerSettingsData compilerSettings = OCMockProjectReader.readConfigOptions(configModel, virtualFileDir, configMap);
                boolean bl = inlinedFiles = header.getValue() != null;
                if (inlinedFiles) {
                    OCMockProjectReader.readFiles(mockWorkspace, configModel, compilerSettings, virtualFileDir, Collections.singletonMap("files", header.getValue()));
                }
                if (!OCMockProjectReader.readFiles(mockWorkspace, configModel, compilerSettings, virtualFileDir, configMap) || !inlinedFiles) continue;
                throw new RuntimeException("Config " + configModel.getUniqueId() + " has conflicting files sections");
            }
        }
    }

    @NotNull
    private static OCResolveConfiguration.ModifiableModel addConfiguration(@NotNull OCWorkspace.ModifiableModel workspaceModel, @NotNull String configName, @Nullable String profile) {
        if (workspaceModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(5);
        }
        if (configName == null) {
            OCMockProjectReader.$$$reportNull$$$0(6);
        }
        String configId = profile == null ? configName : configName + " [" + profile + "]";
        OCResolveConfiguration.ModifiableModel modifiableModel = workspaceModel.addConfiguration(configId, configName, profile == null ? null : new OCVariant(profile));
        if (modifiableModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(7);
        }
        return modifiableModel;
    }

    @NotNull
    private static OCMockWorkspace.CompilerSettingsData readConfigOptions(@NotNull OCResolveConfiguration.ModifiableModel configModel, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        if (configModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(8);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(9);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(10);
        }
        OCCompilerSettings.ModifiableModel defaultSettingsModel = configModel.getDefaultCompilerSettings();
        OCMockProjectReader.readSearchPaths(defaultSettingsModel, baseDir, map);
        OCMockProjectReader.readPCHOptions(defaultSettingsModel, baseDir, map);
        String compilerKind = (String)map.get("compiler");
        if (compilerKind != null) {
            boolean compiledFound = false;
            for (OCCompilerKind oCCompilerKind : OCCompilerKind.values()) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)oCCompilerKind.getDisplayName(), (CharSequence)compilerKind)) continue;
                defaultSettingsModel.setCompiler(oCCompilerKind, null, null);
                compiledFound = true;
                break;
            }
            if (!compiledFound) {
                throw new RuntimeException("Unknown compiler: " + compilerKind);
            }
        }
        OCMockWorkspace.CompilerSettingsData settings = OCMockProjectReader.getCompilerSettings(baseDir, map);
        for (OCCompilerKind oCCompilerKind : CLanguageKind.values()) {
            OCMockWorkspace.applyDefinesAndFeatures((OCLanguageKind)oCCompilerKind, configModel.getLanguageCompilerSettings((OCLanguageKind)oCCompilerKind), settings);
        }
        OCMockWorkspace.CompilerSettingsData compilerSettingsData = settings;
        if (compilerSettingsData == null) {
            OCMockProjectReader.$$$reportNull$$$0(11);
        }
        return compilerSettingsData;
    }

    @NotNull
    private static OCMockWorkspace.CompilerSettingsData getCompilerSettings(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(12);
        }
        return new OCMockWorkspace.CompilerSettingsData(OCMockProjectReader.getDefines(map), OCMockProjectReader.getFeatures(map), OCMockProjectReader.getCompilerSwitches(baseDir, map));
    }

    @Nullable
    private static Map<OCCompilerFeatures.Type<?>, ?> getFeatures(@Nullable Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object features = map.get("features");
        if (features == null) {
            return null;
        }
        assert (features instanceof Map) : "unexpected type for 'features', should be a map";
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry eachEntry : ((Map)features).entrySet()) {
            String featureName = (String)eachEntry.getKey();
            if (OCCompilerFeatures.LANGUAGE_STANDARD.toString().equals(featureName)) {
                String value = (String)eachEntry.getValue();
                try {
                    OCLanguageStandard standard = OCLanguageStandard.valueOf((String)value);
                    result.put(OCCompilerFeatures.LANGUAGE_STANDARD, standard);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Unknown or unsupported language standard: " + value);
                }
            }
            try {
                OCCompilerFeatures.Feature feature = OCCompilerFeatures.Feature.valueOf((String)featureName);
                result.put(feature, (Boolean)eachEntry.getValue());
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unknown or unsupported compiler feature: " + featureName);
            }
        }
        return result;
    }

    @Nullable
    private static List<String> getDefines(@Nullable Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        Object defines = map.get("defines");
        if (defines == null) {
            return null;
        }
        assert (defines instanceof Map) : "unexpected type for 'defines', should be a map";
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry eachEntry : ((Map)defines).entrySet()) {
            String define = "#define " + (String)eachEntry.getKey();
            if (eachEntry.getValue() != null) {
                define = define + " " + eachEntry.getValue();
            }
            result.add(define);
        }
        return result;
    }

    @Nullable
    private static CidrCompilerSwitches getCompilerSwitches(@NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(13);
        }
        if (map == null) {
            return null;
        }
        Object compilerOptions = map.get("compilerArgs");
        if (compilerOptions == null) {
            return null;
        }
        ArrayList<String> options = new ArrayList<String>();
        if (compilerOptions instanceof String) {
            options.add(OCMockProjectReader.replaceMacros(baseDir, (String)compilerOptions));
        } else {
            options.addAll(ContainerUtil.map((Collection)((List)compilerOptions), opt -> OCMockProjectReader.replaceMacros(baseDir, opt)));
        }
        return new CidrCompilerSwitches(options);
    }

    private static void readPCHOptions(@NotNull OCCompilerSettings.ModifiableModel settingsModel, @NotNull VirtualFile baseDir, @Nullable Map<String, ?> map) {
        if (settingsModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(14);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(15);
        }
        if (map == null) {
            return;
        }
        Object args = map.get("pch");
        if (args == null) {
            return;
        }
        ArrayList<VirtualFile> pchFiles = new ArrayList<VirtualFile>(1);
        if (args instanceof String) {
            VirtualFile file2 = VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{(String)args});
            if (OCLog.LOG.assertTrue(file2 != null, (Object)("cannot find PCH file: " + args))) {
                pchFiles.add(file2);
            }
        } else {
            for (String arg : (List)args) {
                VirtualFile file3 = VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{arg});
                if (!OCLog.LOG.assertTrue(file3 != null, (Object)("cannot find PCH file: " + arg))) continue;
                pchFiles.add(file3);
            }
        }
        settingsModel.setImplicitIncludes(pchFiles);
    }

    private static void readSearchPaths(@NotNull OCCompilerSettings.ModifiableModel settingsModel, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        Object files;
        if (settingsModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(16);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(17);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(18);
        }
        if ((files = map.get("headers_paths")) == null) {
            return;
        }
        if (files instanceof List) {
            File baseDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
            ArrayList<HeadersSearchPath> paths = new ArrayList<HeadersSearchPath>();
            for (Object eachEntry : (List)files) {
                String eachPath;
                boolean isRecursive = false;
                HeadersSearchPath.Kind kind = HeadersSearchPath.Kind.SYSTEM;
                boolean isFrameworks = false;
                boolean ensureExists = true;
                if (eachEntry instanceof String) {
                    eachPath = (String)eachEntry;
                } else {
                    Map entryMap = (Map)eachEntry;
                    if (entryMap.size() != 1) {
                        throw new RuntimeException("Unexpected entry in headers_paths: " + eachEntry);
                    }
                    Map.Entry item = entryMap.entrySet().iterator().next();
                    eachPath = (String)item.getKey();
                    Map attributes = (Map)item.getValue();
                    isRecursive = Boolean.TRUE.equals(attributes.get("recursive"));
                    kind = HeadersSearchPath.Kind.fromBoolean((boolean)Boolean.TRUE.equals(attributes.get("user")));
                    isFrameworks = Boolean.TRUE.equals(attributes.get("frameworks"));
                    ensureExists = !Boolean.FALSE.equals(attributes.get("ensureExists"));
                }
                VirtualFile file2 = FileUtil.isAbsolute((String)eachPath) ? VfsUtil.findFile((Path)Paths.get(eachPath, new String[0]), (boolean)false) : baseDir.findFileByRelativePath(eachPath);
                if (ensureExists && file2 == null) {
                    throw new RuntimeException("Headers path " + eachPath + " not found in " + baseDir);
                }
                File path = file2 != null ? VfsUtilCore.virtualToIoFile((VirtualFile)file2) : new File(baseDirPath, eachPath);
                paths.add(new HeadersSearchPath(path, isRecursive, kind, isFrameworks));
            }
            settingsModel.setHeadersSearchPaths(paths);
        }
    }

    private static boolean readGeneratedSources(@NotNull OCMockWorkspace workspace, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        if (workspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(19);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(20);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(21);
        }
        return OCMockProjectReader.addFiles(baseDir, map.get("generated_sources"), (baseDirFile, eachRoot, fileAttrs) -> {
            if (!ContainerUtil.isEmpty((Map)fileAttrs)) {
                throw new NotImplementedError("No attributes are currently supported for generated_sources");
            }
            workspace.addGeneratedSourceFile(eachRoot);
            return true;
        });
    }

    private static boolean readFiles(@NotNull OCMockWorkspace workspace, @NotNull OCResolveConfiguration.ModifiableModel configModel, @NotNull OCMockWorkspace.CompilerSettingsData configCompilerSettings, @NotNull VirtualFile baseDir, @NotNull Map<String, ?> map) {
        if (workspace == null) {
            OCMockProjectReader.$$$reportNull$$$0(22);
        }
        if (configModel == null) {
            OCMockProjectReader.$$$reportNull$$$0(23);
        }
        if (configCompilerSettings == null) {
            OCMockProjectReader.$$$reportNull$$$0(24);
        }
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(25);
        }
        if (map == null) {
            OCMockProjectReader.$$$reportNull$$$0(26);
        }
        return OCMockProjectReader.addFiles(baseDir, map.get("files"), (baseDirFile, eachFile, fileAttributes) -> {
            OCLanguageKind langKind;
            if (eachFile.isDirectory()) {
                return false;
            }
            OCLanguageKind forcedKind = null;
            if (fileAttributes != null) {
                forcedKind = OCMockProjectReader.languageById((String)fileAttributes.get("language"));
            }
            if ((langKind = workspace.addSourceFile(eachFile, forcedKind, configModel)) != null) {
                OCCompilerSettings.ModifiableModel settingsModel = configModel.getSourceCompilerSettings(eachFile);
                assert (settingsModel != null) : "Settings model could not be retrieved";
                if (fileAttributes != null) {
                    OCMockProjectReader.readSearchPaths(settingsModel, baseDirFile, fileAttributes);
                    OCMockProjectReader.readPCHOptions(settingsModel, baseDirFile, fileAttributes);
                }
                OCMockWorkspace.CompilerSettingsData fileCompilerSettings = OCMockProjectReader.getCompilerSettings(baseDir, fileAttributes);
                OCMockWorkspace.CompilerSettingsData mergedSettings = new OCMockWorkspace.CompilerSettingsData(fileCompilerSettings.defines != null ? fileCompilerSettings.defines : configCompilerSettings.defines, fileCompilerSettings.features != null ? fileCompilerSettings.features : configCompilerSettings.features, fileCompilerSettings.switches != null ? fileCompilerSettings.switches : configCompilerSettings.switches);
                OCMockWorkspace.applyDefinesAndFeatures(langKind, settingsModel, mergedSettings);
            }
            return true;
        });
    }

    private static OCLanguageKind languageById(@Nullable String id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case "c": {
                return CLanguageKind.C;
            }
            case "c++": {
                return CLanguageKind.CPP;
            }
            case "objc": {
                return CLanguageKind.OBJ_C;
            }
            case "objc++": {
                return CLanguageKind.OBJ_CPP;
            }
        }
        return null;
    }

    private static boolean addFiles(@NotNull VirtualFile baseDir, @Nullable Object files, @NotNull FileConsumer consumer) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(27);
        }
        if (consumer == null) {
            OCMockProjectReader.$$$reportNull$$$0(28);
        }
        if (files == null) {
            return false;
        }
        if (files instanceof List) {
            for (Object eachFileEntry : (List)files) {
                if (eachFileEntry instanceof Map) {
                    OCMockProjectReader.addFile(baseDir, (Map)eachFileEntry, consumer);
                    continue;
                }
                if (!(eachFileEntry instanceof String)) continue;
                OCMockProjectReader.addFile(baseDir, (String)eachFileEntry, null, consumer);
            }
        } else if (files instanceof String) {
            OCMockProjectReader.addFile(baseDir, (String)files, null, consumer);
        } else if (files instanceof Map) {
            OCMockProjectReader.addFile(baseDir, (Map)files, consumer);
        }
        return true;
    }

    private static void addFile(@NotNull VirtualFile baseDir, @NotNull Map<String, Map<String, Object>> entryMap, @NotNull FileConsumer consumer) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(29);
        }
        if (entryMap == null) {
            OCMockProjectReader.$$$reportNull$$$0(30);
        }
        if (consumer == null) {
            OCMockProjectReader.$$$reportNull$$$0(31);
        }
        if (entryMap.size() != 1) {
            throw new RuntimeException("Unexpected entry in files: " + entryMap);
        }
        Map.Entry<String, Map<String, Object>> item = entryMap.entrySet().iterator().next();
        String eachFile = item.getKey();
        Map<String, Object> attributes = item.getValue();
        OCMockProjectReader.addFile(baseDir, eachFile, attributes, consumer);
    }

    private static void addFile(@NotNull VirtualFile baseDir, @NotNull String fileName, @Nullable Map<String, Object> fileAttrs, @NotNull FileConsumer consumer) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(32);
        }
        if (fileName == null) {
            OCMockProjectReader.$$$reportNull$$$0(33);
        }
        if (consumer == null) {
            OCMockProjectReader.$$$reportNull$$$0(34);
        }
        boolean[] found2 = new boolean[]{false};
        while (fileName.startsWith("../")) {
            fileName = fileName.substring(3);
            if ((baseDir = baseDir.getParent()) != null) continue;
            throw new RuntimeException(fileName + " not found, relative path is invalid");
        }
        String pattern = FileUtil.convertAntToRegexp((String)fileName);
        VirtualFile baseDirFile = baseDir;
        VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)baseDir, eachFile -> {
            String relative = VfsUtilCore.getRelativePath((VirtualFile)eachFile, (VirtualFile)baseDirFile, (char)'/');
            assert (relative != null) : "Relative path could not be determined";
            if (relative.matches(pattern) && !FileUtilRt.extensionEquals((String)relative, (String)EXTENSION) && consumer.addFile(baseDirFile, (VirtualFile)eachFile, fileAttrs)) {
                found2[0] = true;
            }
            return true;
        });
        if (!found2[0]) {
            throw new RuntimeException(fileName + " not found in " + baseDir);
        }
    }

    @NotNull
    private static String replaceMacros(@NotNull VirtualFile baseDir, @NotNull String option) {
        if (baseDir == null) {
            OCMockProjectReader.$$$reportNull$$$0(35);
        }
        if (option == null) {
            OCMockProjectReader.$$$reportNull$$$0(36);
        }
        if (option.contains("${BASE_DIR}")) {
            String string = option.replaceAll("\\$\\{BASE_DIR}", baseDir.getPath());
            if (string == null) {
                OCMockProjectReader.$$$reportNull$$$0(37);
            }
            return string;
        }
        String string = option;
        if (string == null) {
            OCMockProjectReader.$$$reportNull$$$0(38);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mockWorkspace";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspaceModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 7: 
            case 11: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/fixtures/OCMockProjectReader";
                break;
            }
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configModel";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 10: 
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsModel";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configCompilerSettings";
                break;
            }
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryMap";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/fixtures/OCMockProjectReader";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readConfigOptions";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addConfiguration";
                break;
            }
            case 7: 
            case 11: 
            case 37: 
            case 38: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readConfigOptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSwitches";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readPCHOptions";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readSearchPaths";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readGeneratedSources";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readFiles";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "replaceMacros";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface FileConsumer {
        public boolean addFile(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @Nullable Map<String, Object> var3);
    }
}

