/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.cpp.cmake.CMakeProjectFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cmake.CMakeCodeInsightFixtureAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCodeInsightFixture
extends CidrCodeInsightFixture {
    public CMakeCodeInsightFixture(@NotNull CMakeProjectFixture projectFixture) {
        if (projectFixture == null) {
            CMakeCodeInsightFixture.$$$reportNull$$$0(0);
        }
        super(projectFixture, new CMakeCodeInsightFixtureAdapter(projectFixture));
    }

    public CMakeCodeInsightFixture(@NotNull CMakeProjectFixture projectFixture, @Nullable String testFilesPath, @Nullable String testFilesExtension) {
        if (projectFixture == null) {
            CMakeCodeInsightFixture.$$$reportNull$$$0(1);
        }
        super(projectFixture, new CMakeCodeInsightFixtureAdapter(projectFixture), testFilesPath, testFilesExtension);
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        if (symbolsKind == null) {
            CMakeCodeInsightFixture.$$$reportNull$$$0(2);
        }
        return symbolsKind;
    }

    public void assertCMakeFormatAfterEnter(String before2, String after2) {
        this.assertCMakeFormatAfterTypedString(before2, after2, "\n");
    }

    public void assertCMakeFormatAfterBackspace(String before2, String after2) {
        this.assertCMakeFormatAfterTypedString(before2, after2, "\b");
    }

    public void assertCMakeFormatAfterTypedString(String before2, String after2, String typed) {
        before2 = StringGroovyMethods.stripMargin((String)before2);
        after2 = StringGroovyMethods.stripMargin((String)after2);
        try {
            this.configureByText(before2, "input.cmake");
            this.getFixture().type(typed);
            this.checkResult(after2);
        }
        catch (Exception e) {
            System.err.print(DebugUtil.psiToString((PsiElement)this.getFile(), (boolean)true));
            throw new RuntimeException(e);
        }
    }

    public void assertCMakeAfterReformat(@NotNull String input, @NotNull String output) {
        if (input == null) {
            CMakeCodeInsightFixture.$$$reportNull$$$0(3);
        }
        if (output == null) {
            CMakeCodeInsightFixture.$$$reportNull$$$0(4);
        }
        input = StringGroovyMethods.stripMargin((String)input);
        output = StringGroovyMethods.stripMargin((String)output);
        this.configureByText(input, "input.cmake");
        TextRange selection = this.getSelection();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> CodeStyleManager.getInstance((Project)this.getProject()).reformatText(this.getFile(), selection.getStartOffset(), selection.getEndOffset()));
        this.checkResult(output);
    }

    public void assertCMakeAutoPopup(String text, String typedText, boolean shouldPopup) {
        this.configureByText(text, "input.cmake");
        this.assertAutoPopup(typedText, shouldPopup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFixture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/CMakeCodeInsightFixture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/CMakeCodeInsightFixture";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertCMakeAfterReformat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

