/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentIcons;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.PropertyProvider;
import com.jetbrains.plugins.webDeployment.ui.WebServerToolWindowPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class WebServerToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final DeploymentNotifier.ToolWindowIdProvider SERVER_BROWSER_TOOLWINDOW_ID_PROVIDER = new DeploymentNotifier.ToolWindowIdProvider("Remote Host", WDBundle.messagePointer("toolwindow.stripe.Remote_Host", new Object[0]));
    @NonNls
    private static final String STATE_KEY = "WebServerToolWindowFactoryState";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(1);
        }
        WebServerToolWindowFactory.doCreateToolWindowContent(project, toolWindow);
    }

    private static void doCreateToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(2);
        }
        if (toolWindow == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(3);
        }
        toolWindow.setAvailable(true);
        WebServerToolWindowFactory.setAvailable(project, true);
        WebServerToolWindowPanel component = new WebServerToolWindowPanel(project, toolWindow);
        component.installGearActions((ToolWindowEx)toolWindow);
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)component), "", false);
        content.setHelpId("reference.tool.window.remote.host");
        toolWindow.getContentManager().addContent(content);
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(4);
        }
        return Boolean.valueOf(WebServerToolWindowFactory.getAvailabilityStateProvider(project).readValue());
    }

    private static PropertyProvider getAvailabilityStateProvider(@NotNull Project project) {
        if (project == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(5);
        }
        boolean defaultValue = GroupedServersConfigManager.getInstance(project).getFlattenedServers().stream().anyMatch(server -> server.needsTransfer());
        return new PropertyProvider(project, STATE_KEY, String.valueOf(defaultValue));
    }

    public static void setAvailable(Project project, boolean available) {
        WebServerToolWindowFactory.getAvailabilityStateProvider(project).saveValue(String.valueOf(available));
    }

    @NotNull
    public static ToolWindow getWebServerToolWindow(@NotNull Project project) {
        ToolWindowManager manager;
        ToolWindow toolWindow;
        if (project == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(6);
        }
        if ((toolWindow = (manager = ToolWindowManager.getInstance((Project)project)).getToolWindow(SERVER_BROWSER_TOOLWINDOW_ID_PROVIDER.getId())) == null) {
            RegisterToolWindowTask task = new RegisterToolWindowTask(SERVER_BROWSER_TOOLWINDOW_ID_PROVIDER.getId(), ToolWindowAnchor.RIGHT, null, true, true, true, true, (ToolWindowFactory)new WebServerToolWindowFactory(), WebDeploymentIcons.WebServerToolWindow, null);
            toolWindow = manager.registerToolWindow(task);
            WebServerToolWindowFactory.doCreateToolWindowContent(project, toolWindow);
        }
        toolWindow.setAvailable(true);
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            WebServerToolWindowFactory.$$$reportNull$$$0(7);
        }
        return toolWindow2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebServerToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCreateToolWindowContent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailabilityStateProvider";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getWebServerToolWindow";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

