/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.foundation;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.sun.jna.Pointer;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacUtil {
    private static final Logger LOG = Logger.getInstance(MacUtil.class);
    private static final String MAC_NATIVE_WINDOW_SHOWING = "MAC_NATIVE_WINDOW_SHOWING";

    private MacUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ID findWindowForTitle(@Nullable String title) {
        ID focusedWindow;
        block5: {
            if (title == null || title.isEmpty()) {
                return null;
            }
            ID pool = Foundation.invoke("NSAutoreleasePool", "new", new Object[0]);
            focusedWindow = null;
            try {
                String titleString;
                ID window;
                ID windowTitle;
                ID sharedApplication = Foundation.invoke("NSApplication", "sharedApplication", new Object[0]);
                ID windows = Foundation.invoke(sharedApplication, "windows", new Object[0]);
                ID windowEnumerator = Foundation.invoke(windows, "objectEnumerator", new Object[0]);
                do {
                    if (!ID.NIL.equals((Object)(window = Foundation.invoke(windowEnumerator, "nextObject", new Object[0])))) continue;
                    break block5;
                } while (ID.NIL.equals((Object)(windowTitle = Foundation.invoke(window, "title", new Object[0]))) || !Objects.equals(titleString = Foundation.toStringViaUTF8(windowTitle), title));
                focusedWindow = window;
            }
            finally {
                Foundation.invoke(pool, "release", new Object[0]);
            }
        }
        return focusedWindow;
    }

    public static synchronized void startModal(JComponent component, String key) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = component.getToolkit().getSystemEventQueue();
                while (component.getClientProperty(key) == Boolean.TRUE) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    LOG.debug("Unable to dispatch: " + event);
                }
            } else {
                assert (false) : "Should be called from Event-Dispatch Thread only!";
                while (component.getClientProperty(key) == Boolean.TRUE) {
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static synchronized void startModal(JComponent component) {
        MacUtil.startModal(component, MAC_NATIVE_WINDOW_SHOWING);
    }

    public static boolean isFullKeyboardAccessEnabled() {
        if (!SystemInfoRt.isMac) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean();
        Foundation.executeOnMainThread(true, true, () -> result.set(Foundation.invoke(Foundation.invoke("NSApplication", "sharedApplication", new Object[0]), "isFullKeyboardAccessEnabled", new Object[0]).booleanValue()));
        return result.get();
    }

    public static void adjustFocusTraversal(@NotNull Disposable disposable) {
        if (disposable == null) {
            MacUtil.$$$reportNull$$$0(0);
        }
        if (!SystemInfoRt.isMac) {
            return;
        }
        final AWTEventListener listener2 = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof KeyEvent && ((KeyEvent)event).getKeyCode() == 9 && !(event.getSource() instanceof JTextComponent) && !(event.getSource() instanceof JList) && !MacUtil.isFullKeyboardAccessEnabled()) {
                    ((KeyEvent)event).consume();
                }
            }
        };
        Disposer.register(disposable, new Disposable(){

            @Override
            public void dispose() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener2);
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 8L);
    }

    @NotNull
    public static ID getWindowFromJavaWindow(@Nullable Window w) {
        if (w == null) {
            ID iD = ID.NIL;
            if (iD == null) {
                MacUtil.$$$reportNull$$$0(1);
            }
            return iD;
        }
        if (SystemInfo.isJetBrainsJvm) {
            try {
                Object cPlatformWindow = MacUtil.getPlatformWindow(w);
                if (cPlatformWindow != null) {
                    Field ptr = cPlatformWindow.getClass().getSuperclass().getDeclaredField("ptr");
                    ptr.setAccessible(true);
                    return new ID(ptr.getLong(cPlatformWindow));
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LOG.debug(e);
            }
        }
        ID iD = ID.NIL;
        if (iD == null) {
            MacUtil.$$$reportNull$$$0(2);
        }
        return iD;
    }

    @Nullable
    public static Object getPlatformWindow(@NotNull Window w) {
        if (w == null) {
            MacUtil.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isJetBrainsJvm) {
            try {
                Class<?> cWindowPeerClass;
                Method getPlatformWindowMethod;
                Object cPlatformWindow;
                Class<?> awtAccessor = Class.forName("sun.awt.AWTAccessor");
                Object componentAccessor = awtAccessor.getMethod("getComponentAccessor", new Class[0]).invoke(null, new Object[0]);
                Method getPeer = componentAccessor.getClass().getMethod("getPeer", Component.class);
                getPeer.setAccessible(true);
                Object peer = getPeer.invoke(componentAccessor, w);
                if (peer != null && (cPlatformWindow = (getPlatformWindowMethod = (cWindowPeerClass = peer.getClass()).getDeclaredMethod("getPlatformWindow", new Class[0])).invoke(peer, new Object[0])) != null) {
                    return cPlatformWindow;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.debug(e);
            }
        }
        return null;
    }

    public static ID findWindowFromJavaWindow(Window w) {
        ID window;
        if (Registry.is("skip.untitled.windows.for.mac.messages") && !ID.NIL.equals((Object)(window = MacUtil.getWindowFromJavaWindow(w)))) {
            return window;
        }
        return MacUtil.findWindowForTitle(MacUtil.getWindowTitle(w));
    }

    @Nullable
    public static String getWindowTitle(Window documentRoot) {
        String windowTitle = null;
        if (documentRoot instanceof Frame) {
            windowTitle = ((Frame)documentRoot).getTitle();
        } else if (documentRoot instanceof Dialog) {
            windowTitle = ((Dialog)documentRoot).getTitle();
        }
        return windowTitle;
    }

    @NotNull
    public static Runnable wakeUpNeo(@NotNull Object reason) {
        if (reason == null) {
            MacUtil.$$$reportNull$$$0(4);
        }
        return new ActivityImpl(reason);
    }

    @NotNull
    public static Color colorFromNative(ID color) {
        ID colorSpace = Foundation.invoke("NSColorSpace", "genericRGBColorSpace", new Object[0]);
        ID colorInSpace = Foundation.invoke(color, "colorUsingColorSpace:", new Object[]{colorSpace});
        long red = Foundation.invoke(colorInSpace, "redComponent", new Object[0]).longValue();
        long green = Foundation.invoke(colorInSpace, "greenComponent", new Object[0]).longValue();
        long blue = Foundation.invoke(colorInSpace, "blueComponent", new Object[0]).longValue();
        long alpha = Foundation.invoke(colorInSpace, "alphaComponent", new Object[0]).longValue();
        double realAlpha = alpha != 0L && (int)(alpha >> 52 & 0x7FFL) == 0 ? 1.0 : Double.longBitsToDouble(alpha);
        return new Color((float)Double.longBitsToDouble(red), (float)Double.longBitsToDouble(green), (float)Double.longBitsToDouble(blue), (float)realAlpha);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "w";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/foundation/MacUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowFromJavaWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustFocusTraversal";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wakeUpNeo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ActivityImpl
    extends AtomicReference<ID>
    implements Runnable {
        private static final ID processInfoCls = Foundation.getObjcClass("NSProcessInfo");
        private static final Pointer processInfoSel = Foundation.createSelector("processInfo");
        private static final Pointer beginActivityWithOptionsReasonSel = Foundation.createSelector("beginActivityWithOptions:reason:");
        private static final Pointer endActivitySel = Foundation.createSelector("endActivity:");
        private static final Pointer retainSel = Foundation.createSelector("retain");
        private static final Pointer releaseSel = Foundation.createSelector("release");

        private ActivityImpl(@NotNull Object reason) {
            if (reason == null) {
                ActivityImpl.$$$reportNull$$$0(0);
            }
            super(ActivityImpl.begin(reason));
        }

        @Override
        public void run() {
            ActivityImpl.end(this.getAndSet(null));
        }

        private static ID getProcessInfo() {
            return Foundation.invoke(processInfoCls, processInfoSel, new Object[0]);
        }

        private static ID begin(@NotNull Object reason) {
            if (reason == null) {
                ActivityImpl.$$$reportNull$$$0(1);
            }
            return Foundation.invoke(Foundation.invoke(ActivityImpl.getProcessInfo(), beginActivityWithOptionsReasonSel, new Object[]{0xEFFFFFL, Foundation.nsString(reason.toString())}), retainSel, new Object[0]);
        }

        private static void end(@Nullable ID activityToken) {
            if (activityToken == null) {
                return;
            }
            Foundation.invoke(ActivityImpl.getProcessInfo(), endActivitySel, new Object[]{activityToken});
            Foundation.invoke(activityToken, releaseSel, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "reason";
            objectArray2[1] = "com/intellij/ui/mac/foundation/MacUtil$ActivityImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "begin";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class NSActivityOptions {
        private static final long idleSystemSleepDisabled = 0x100000L;
        private static final long userInitiated = 0xFFFFFFL;
        private static final long userInitiatedAllowingIdleSystemSleep = 0xEFFFFFL;
        private static final long latencyCritical = 0xFF00000000L;

        private NSActivityOptions() {
        }
    }
}

