/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.SoftHashMap;
import com.intellij.util.containers.SoftKeySoftValueHashMap;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.containers.WeakKeySoftValueHashMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class CollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(HashingStrategy<? super K> strategy) {
        return new ConcurrentWeakHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> ConcurrentMap<String, V> createConcurrentWeakCaseInsensitiveMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.caseInsensitive());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        return new ConcurrentWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        return new ConcurrentSoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        return CollectionFactory.createWeakMap(4, 0.8f, HashingStrategy.canonical());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(0);
        }
        return new WeakHashMap(initialCapacity, loadFactor, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeySoftValueMap() {
        return new WeakKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakKeyWeakValueMap() {
        return new WeakKeyWeakValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        return new SoftKeySoftValueHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static <K, V> Map<K, V> createWeakIdentityMap(int initialCapacity, float loadFactor) {
        return CollectionFactory.createWeakMap(initialCapacity, loadFactor, HashingStrategy.identity());
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(HashingStrategy<? super K> strategy) {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueIdentityMap() {
        return new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.identity());
    }

    @Contract(value="_,_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel, HashingStrategy<? super K> hashingStrategy) {
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        return CollectionFactory.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), HashingStrategy.canonical());
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(1);
        }
        return new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet<CharSequence>(expectedSize, loadFactor, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(List<? extends CharSequence> items) {
        return new ObjectOpenCustomHashSet<CharSequence>(items, FastUtilHashingStrategies.getCharSequenceStrategy(true));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize) {
        return new ObjectOpenCustomHashSet<CharSequence>(expectedSize, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive) {
        return new ObjectOpenCustomHashSet<CharSequence>(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(int capacity, float loadFactory, boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(capacity, loadFactory, FastUtilHashingStrategies.getCharSequenceStrategy(caseSensitive));
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet<String>(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet(@NotNull Collection<String> items) {
        if (items == null) {
            CollectionFactory.$$$reportNull$$$0(2);
        }
        return new ObjectOpenCustomHashSet<String>(items, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(int expectedSize) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap(@NotNull Map<String, V> source) {
        if (source == null) {
            CollectionFactory.$$$reportNull$$$0(3);
        }
        return new Object2ObjectOpenCustomHashMap<String, V>(source, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    static <K, V> ConcurrentMap<K, V> createConcurrentSoftKeySoftValueIdentityMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentSoftKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.identity());
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashSet() : CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize) {
        return CollectionFactory.createFilePathSet(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashSet(expectedSize) : new ObjectOpenCustomHashSet<String>(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths, boolean isFileSystemCaseSensitive) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(4);
        }
        return isFileSystemCaseSensitive ? new HashSet<String>(paths) : new ObjectOpenCustomHashSet<String>(paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(String @NotNull [] paths, boolean isFileSystemCaseSensitive) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(5);
        }
        return isFileSystemCaseSensitive ? new HashSet<String>(Arrays.asList(paths)) : new ObjectOpenCustomHashSet<String>(paths, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(6);
        }
        return CollectionFactory.createFilePathSet(paths, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? new HashMap() : CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize) {
        return CollectionFactory.createFilePathMap(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize, boolean isFileSystemCaseSensitive) {
        return isFileSystemCaseSensitive ? new HashMap(expectedSize) : new Object2ObjectOpenCustomHashMap(expectedSize, FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet() {
        return SystemInfoRt.isFileSystemCaseSensitive ? CollectionFactory.createSmallMemoryFootprintLinkedSet() : new ObjectLinkedOpenCustomHashSet<String>(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @NotNull
    public static <V> Map<String, V> createFilePathLinkedMap() {
        return SystemInfoRt.isFileSystemCaseSensitive ? CollectionFactory.createSmallMemoryFootprintLinkedMap() : new Object2ObjectLinkedOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintLinkedMap() {
        return new Object2ObjectLinkedOpenHashMap();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap() {
        return new Object2ObjectOpenHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected) {
        return new Object2ObjectOpenHashMap(expected);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(@NotNull Map<? extends K, ? extends V> map2) {
        if (map2 == null) {
            CollectionFactory.$$$reportNull$$$0(7);
        }
        return new Object2ObjectOpenHashMap<K, V>(map2);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSmallMemoryFootprintMap(int expected, float loadFactor) {
        return new Object2ObjectOpenHashMap(expected, loadFactor);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintLinkedSet() {
        return new ObjectLinkedOpenHashSet();
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet() {
        return new ObjectOpenHashSet();
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(int expected) {
        return new ObjectOpenHashSet(expected);
    }

    @Contract(value="_-> new", pure=true)
    @NotNull
    public static <K> Set<K> createSmallMemoryFootprintSet(@NotNull Collection<? extends K> collection) {
        if (collection == null) {
            CollectionFactory.$$$reportNull$$$0(8);
        }
        return new ObjectOpenHashSet<K>(collection);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        return new SoftHashMap(4);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    static <K, V> Map<K, V> createSoftMap(@NotNull HashingStrategy<? super K> strategy) {
        if (strategy == null) {
            CollectionFactory.$$$reportNull$$$0(9);
        }
        return new SoftHashMap(strategy);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap() {
        return new ConcurrentSoftHashMap();
    }

    @Contract(value="_,_,_,_-> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            CollectionFactory.$$$reportNull$$$0(10);
        }
        return new ConcurrentSoftHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public static void trimMap(@NotNull Map<?, ?> map2) {
        if (map2 == null) {
            CollectionFactory.$$$reportNull$$$0(11);
        }
        if (map2 instanceof Object2ObjectOpenHashMap) {
            ((Object2ObjectOpenHashMap)map2).trim();
        } else if (map2 instanceof Object2ObjectOpenCustomHashMap) {
            ((Object2ObjectOpenCustomHashMap)map2).trim();
        }
    }

    public static void trimSet(@NotNull Set<?> set) {
        if (set == null) {
            CollectionFactory.$$$reportNull$$$0(12);
        }
        if (set instanceof ObjectOpenHashSet) {
            ((ObjectOpenHashSet)set).trim();
        } else if (set instanceof ObjectOpenCustomHashSet) {
            ((ObjectOpenCustomHashSet)set).trim();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/CollectionFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createWeakMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createCaseInsensitiveStringMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createFilePathSet";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintMap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createSmallMemoryFootprintSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createSoftMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createConcurrentSoftMap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "trimMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "trimSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

