/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiPredicate;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Compressor
implements Closeable {
    @Nullable
    private @Nullable BiPredicate<? super String, ? super @Nullable File> myFilter;
    @Nullable
    private @Nullable BiPredicate<? super String, ? super @Nullable Path> nioFilter;

    public Compressor filter(@Nullable @Nullable BiPredicate<? super String, ? super @Nullable File> filter2) {
        this.myFilter = filter2;
        return this;
    }

    public Compressor nioFilter(@Nullable @Nullable BiPredicate<? super String, ? super @Nullable Path> filter2) {
        this.nioFilter = filter2;
        return this;
    }

    public final void addFile(@NotNull String entryName, @NotNull File file) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(1);
        }
        if (this.accepts(entryName, file)) {
            try (FileInputStream source = new FileInputStream(file);){
                this.writeFileEntry(entryName, source, file.length(), file.lastModified());
            }
        }
    }

    public final void addFile(@NotNull String entryName, @NotNull Path file) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(2);
        }
        if (file == null) {
            Compressor.$$$reportNull$$$0(3);
        }
        if (this.nioFilter == null || this.nioFilter.test(entryName, file)) {
            try (InputStream source = Files.newInputStream(file, new OpenOption[0]);){
                BasicFileAttributes attributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                this.writeFileEntry(entryName, source, attributes.size(), attributes.lastModifiedTime().toMillis());
            }
        }
    }

    public final void addFile(@NotNull String entryName, byte @NotNull [] content) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(4);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(5);
        }
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, byte @NotNull [] content, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(6);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(7);
        }
        if (this.accepts(entryName = Compressor.entryName(entryName), null)) {
            this.writeFileEntry(entryName, new ByteArrayInputStream(content), content.length, Compressor.timestamp(timestamp));
        }
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(8);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(9);
        }
        this.addFile(entryName, content, -1L);
    }

    public final void addFile(@NotNull String entryName, @NotNull InputStream content, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(10);
        }
        if (content == null) {
            Compressor.$$$reportNull$$$0(11);
        }
        if (this.accepts(entryName = Compressor.entryName(entryName), null)) {
            this.writeFileEntry(entryName, content, -1L, Compressor.timestamp(timestamp));
        }
    }

    public final void addDirectory(@NotNull String entryName) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(12);
        }
        this.addDirectory(entryName, -1L);
    }

    public final void addDirectory(@NotNull String entryName, long timestamp) throws IOException {
        if (entryName == null) {
            Compressor.$$$reportNull$$$0(13);
        }
        if (this.accepts(entryName = Compressor.entryName(entryName), null)) {
            this.writeDirectoryEntry(entryName, Compressor.timestamp(timestamp));
        }
    }

    public final void addDirectory(@NotNull File directory) throws IOException {
        if (directory == null) {
            Compressor.$$$reportNull$$$0(14);
        }
        this.addRecursively("", directory);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull File directory) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(15);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(16);
        }
        this.addRecursively(Compressor.entryName(prefix), directory);
    }

    public final void addDirectory(@NotNull String prefix, @NotNull Path directory) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(17);
        }
        if (directory == null) {
            Compressor.$$$reportNull$$$0(18);
        }
        this.addRecursively(Compressor.entryName(prefix), directory);
    }

    protected Compressor() {
    }

    private static String entryName(String name) {
        String entryName = StringUtil.trimLeading(StringUtil.trimTrailing(name.replace('\\', '/'), '/'), '/');
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("Invalid entry name: " + name);
        }
        return entryName;
    }

    private static long timestamp(long timestamp) {
        return timestamp == -1L ? System.currentTimeMillis() : timestamp;
    }

    private boolean accepts(String entryName, @Nullable File file) {
        if (this.myFilter == null) {
            return file != null || this.nioFilter == null || this.nioFilter.test(entryName, null);
        }
        return this.myFilter.test(entryName, file);
    }

    private void addRecursively(String prefix, File directory) throws IOException {
        File[] children;
        if (!this.accepts(prefix, directory)) {
            return;
        }
        if (!prefix.isEmpty()) {
            this.writeDirectoryEntry(prefix, directory.lastModified());
        }
        if ((children = directory.listFiles()) != null) {
            for (File child : children) {
                String name;
                String string = name = prefix.isEmpty() ? child.getName() : prefix + '/' + child.getName();
                if (child.isDirectory()) {
                    this.addRecursively(name, child);
                    continue;
                }
                this.addFile(name, child);
            }
        }
    }

    private void addRecursively(@NotNull String prefix, @NotNull Path dir) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(19);
        }
        if (dir == null) {
            Compressor.$$$reportNull$$$0(20);
        }
        if (this.nioFilter == null || this.nioFilter.test(prefix, dir)) {
            this.addRecursively(prefix, dir, Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]));
        }
    }

    private void addRecursively(@NotNull String prefix, @NotNull Path dir, @NotNull BasicFileAttributes dirAttributes) throws IOException {
        if (prefix == null) {
            Compressor.$$$reportNull$$$0(21);
        }
        if (dir == null) {
            Compressor.$$$reportNull$$$0(22);
        }
        if (dirAttributes == null) {
            Compressor.$$$reportNull$$$0(23);
        }
        if (!prefix.isEmpty()) {
            this.writeDirectoryEntry(prefix, dirAttributes.lastModifiedTime().toMillis());
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path child : stream) {
                String name;
                String string = name = prefix.isEmpty() ? child.getFileName().toString() : prefix + '/' + child.getFileName().toString();
                if (this.nioFilter != null && !this.nioFilter.test(name, dir)) continue;
                BasicFileAttributes attributes = Files.readAttributes(child, BasicFileAttributes.class, new LinkOption[0]);
                if (attributes.isDirectory()) {
                    this.addRecursively(name, child, attributes);
                    continue;
                }
                InputStream source = Files.newInputStream(child, new OpenOption[0]);
                try {
                    this.writeFileEntry(name, source, attributes.size(), attributes.lastModifiedTime().toMillis());
                }
                finally {
                    if (source == null) continue;
                    source.close();
                }
            }
        }
    }

    protected abstract void writeDirectoryEntry(String var1, long var2) throws IOException;

    protected abstract void writeFileEntry(String var1, InputStream var2, long var3, long var5) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirAttributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/Compressor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirectory";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "addRecursively";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Jar
    extends Zip {
        public Jar(@NotNull File file) throws IOException {
            if (file == null) {
                Jar.$$$reportNull$$$0(0);
            }
            super(new JarOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
        }

        public final void addManifest(@NotNull Manifest manifest) throws IOException {
            if (manifest == null) {
                Jar.$$$reportNull$$$0(1);
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            manifest.write(buffer);
            this.addFile("META-INF/MANIFEST.MF", buffer.toByteArray());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manifest";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/io/Compressor$Jar";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addManifest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Zip
    extends Compressor {
        private final ZipOutputStream myStream;

        public Zip(@NotNull File file) throws FileNotFoundException {
            if (file == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this(new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
        }

        public Zip(@NotNull OutputStream stream) {
            if (stream == null) {
                Zip.$$$reportNull$$$0(1);
            }
            this(new ZipOutputStream(stream));
        }

        public Zip withLevel(int compressionLevel) {
            this.myStream.setLevel(compressionLevel);
            return this;
        }

        protected Zip(ZipOutputStream stream) {
            this.myStream = stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            ZipEntry e = new ZipEntry(name + '/');
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            this.myStream.closeEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp) throws IOException {
            ZipEntry e = new ZipEntry(name);
            if (length == 0L) {
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
            }
            e.setTime(timestamp);
            this.myStream.putNextEntry(e);
            FileUtilRt.copy(source, this.myStream);
            this.myStream.closeEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Compressor$Zip";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Tar
    extends Compressor {
        private final TarArchiveOutputStream myStream;

        public Tar(@NotNull File file, @NotNull Compression compression) throws IOException {
            if (file == null) {
                Tar.$$$reportNull$$$0(0);
            }
            if (compression == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this(new FileOutputStream(file), compression);
        }

        public Tar(@NotNull OutputStream stream, @NotNull Compression compression) throws IOException {
            if (stream == null) {
                Tar.$$$reportNull$$$0(2);
            }
            if (compression == null) {
                Tar.$$$reportNull$$$0(3);
            }
            this.myStream = new TarArchiveOutputStream(Tar.compressedStream(stream, compression));
            this.myStream.setLongFileMode(3);
        }

        private static OutputStream compressedStream(OutputStream stream, Compression compression) throws IOException {
            if (compression == Compression.GZIP) {
                return new GzipCompressorOutputStream(stream);
            }
            if (compression == Compression.BZIP2) {
                return new BZip2CompressorOutputStream(stream);
            }
            return stream;
        }

        @Override
        protected void writeDirectoryEntry(String name, long timestamp) throws IOException {
            TarArchiveEntry e = new TarArchiveEntry(name + '/');
            e.setModTime(timestamp);
            this.myStream.putArchiveEntry((ArchiveEntry)e);
            this.myStream.closeArchiveEntry();
        }

        @Override
        protected void writeFileEntry(String name, InputStream source, long length, long timestamp) throws IOException {
            TarArchiveEntry e = new TarArchiveEntry(name);
            e.setSize(length);
            e.setModTime(timestamp);
            this.myStream.putArchiveEntry((ArchiveEntry)e);
            FileUtilRt.copy(source, (OutputStream)this.myStream);
            this.myStream.closeArchiveEntry();
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Compressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum Compression {
            GZIP,
            BZIP2,
            NONE;

        }
    }
}

