/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.ResourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarLoader
extends Loader {
    private static final Map.Entry<Loader.Attribute, Attributes.Name>[] PACKAGE_FIELDS = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Loader.Attribute, Attributes.Name>(Loader.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), new AbstractMap.SimpleImmutableEntry<Loader.Attribute, Attributes.Name>(Loader.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), new AbstractMap.SimpleImmutableEntry<Loader.Attribute, Attributes.Name>(Loader.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), new AbstractMap.SimpleImmutableEntry<Loader.Attribute, Attributes.Name>(Loader.Attribute.CLASS_PATH, Attributes.Name.CLASS_PATH), new AbstractMap.SimpleImmutableEntry<Loader.Attribute, Attributes.Name>(Loader.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), new AbstractMap.SimpleImmutableEntry<Loader.Attribute, Attributes.Name>(Loader.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), new AbstractMap.SimpleImmutableEntry<Loader.Attribute, Attributes.Name>(Loader.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR)};
    protected final ClassPath configuration;
    final URL url;
    protected final ResourceFile zipFile;
    private volatile Map<Loader.Attribute, String> attributes;

    JarLoader(@NotNull Path file, @NotNull ClassPath configuration, @NotNull ResourceFile zipFile) throws IOException {
        if (file == null) {
            JarLoader.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            JarLoader.$$$reportNull$$$0(1);
        }
        if (zipFile == null) {
            JarLoader.$$$reportNull$$$0(2);
        }
        super(file);
        this.configuration = configuration;
        this.zipFile = zipFile;
        this.url = new URL("jar", "", -1, JarLoader.fileToUri(file) + "!/");
    }

    @Override
    public final Map<Loader.Attribute, String> getAttributes() throws IOException {
        return this.loadManifestAttributes(this.zipFile);
    }

    @Override
    @Nullable
    final Class<?> findClass(@NotNull String fileName, String className, @NotNull ClassPath.ClassDataConsumer classConsumer) throws IOException {
        if (fileName == null) {
            JarLoader.$$$reportNull$$$0(3);
        }
        if (classConsumer == null) {
            JarLoader.$$$reportNull$$$0(4);
        }
        return this.zipFile.findClass(fileName, className, this, classConsumer);
    }

    @NotNull
    public static URI fileToUri(@NotNull Path file) {
        String path;
        if (file == null) {
            JarLoader.$$$reportNull$$$0(5);
        }
        if (!(path = file.toString().replace(File.separatorChar, '/')).startsWith("/")) {
            path = '/' + path;
        } else if (path.startsWith("//")) {
            path = "//" + path;
        }
        try {
            return new URI("file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path, e);
        }
    }

    @Nullable
    final String getClassPathManifestAttribute() throws IOException {
        return this.loadManifestAttributes(this.zipFile).get((Object)Loader.Attribute.CLASS_PATH);
    }

    @NotNull
    private static Map<Loader.Attribute, String> getAttributes(@NotNull Attributes attributes) {
        if (attributes == null) {
            JarLoader.$$$reportNull$$$0(6);
        }
        if (attributes.isEmpty()) {
            Map<Loader.Attribute, String> map2 = Collections.emptyMap();
            if (map2 == null) {
                JarLoader.$$$reportNull$$$0(7);
            }
            return map2;
        }
        EnumMap<Loader.Attribute, String> map3 = null;
        for (Map.Entry<Loader.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
            String value = attributes.getValue(p.getValue());
            if (value == null) continue;
            if (map3 == null) {
                map3 = new EnumMap<Loader.Attribute, String>(Loader.Attribute.class);
            }
            map3.put(p.getKey(), value);
        }
        Map<Loader.Attribute, String> map4 = map3 == null ? Collections.emptyMap() : map3;
        if (map4 == null) {
            JarLoader.$$$reportNull$$$0(8);
        }
        return map4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Map<Loader.Attribute, String> loadManifestAttributes(@NotNull ResourceFile resourceFile) throws IOException {
        void var2_6;
        Map<Loader.Attribute, String> map2;
        if (resourceFile == null) {
            JarLoader.$$$reportNull$$$0(9);
        }
        if ((map2 = this.attributes) != null) {
            Map<Loader.Attribute, String> map3 = map2;
            if (map3 == null) {
                JarLoader.$$$reportNull$$$0(10);
            }
            return map3;
        }
        JarLoader jarLoader = this;
        synchronized (jarLoader) {
            Map<Loader.Attribute, String> map4 = this.attributes;
            if (map4 != null) {
                Map<Loader.Attribute, String> map5 = map4;
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl13 : MonitorExitStatement: MONITOREXIT : var3_7
                if (map5 == null) {
                    JarLoader.$$$reportNull$$$0(11);
                }
                return map5;
            }
            Map<Loader.Attribute, String> map6 = this.configuration.getManifestData(this.path);
            if (map6 == null) {
                Attributes manifestAttributes = resourceFile.loadManifestAttributes();
                Map<Loader.Attribute, String> map7 = manifestAttributes == null ? Collections.emptyMap() : JarLoader.getAttributes(manifestAttributes);
                this.configuration.cacheManifestData(this.path, map7);
            }
            this.attributes = var2_6;
        }
        void v2 = var2_6;
        if (v2 == null) {
            JarLoader.$$$reportNull$$$0(12);
        }
        return v2;
    }

    @Override
    @NotNull
    public final ClasspathCache.IndexRegistrar buildData() throws IOException {
        ClasspathCache.IndexRegistrar indexRegistrar = this.zipFile.buildClassPathCacheData();
        if (indexRegistrar == null) {
            JarLoader.$$$reportNull$$$0(13);
        }
        return indexRegistrar;
    }

    @Override
    @Nullable
    final Resource getResource(@NotNull String name) {
        if (name == null) {
            JarLoader.$$$reportNull$$$0(14);
        }
        try {
            return this.zipFile.getResource(name, this);
        }
        catch (IOException e) {
            this.error("url: " + this.path, e);
            return null;
        }
    }

    @Override
    void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer) throws IOException {
        if (dir == null) {
            JarLoader.$$$reportNull$$$0(15);
        }
        if (fileNameFilter == null) {
            JarLoader.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            JarLoader.$$$reportNull$$$0(17);
        }
        this.zipFile.processResources(dir, fileNameFilter, consumer);
    }

    protected final void error(@NotNull String message, @NotNull Throwable t) {
        if (message == null) {
            JarLoader.$$$reportNull$$$0(18);
        }
        if (t == null) {
            JarLoader.$$$reportNull$$$0(19);
        }
        LoggerRt logger = LoggerRt.getInstance(JarLoader.class);
        if (this.configuration.errorOnMissingJar) {
            logger.error(message, t);
        } else {
            logger.warn(message, t);
        }
    }

    public final String toString() {
        return "JarLoader [" + this.path + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classConsumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/JarLoader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/JarLoader";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadManifestAttributes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fileToUri";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadManifestAttributes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

