/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.integratedBinaryPacking;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;

public final class LongBitPacker {
    public static int compressIntegrated(long[] in, int startIndex, int endIndex, long[] out, long initValue) {
        long mBits7;
        long initOffset7;
        long mBits6;
        long initOffset6;
        long mBits5;
        long initOffset5;
        long mBits4;
        long initOffset4;
        long mBits3;
        long initOffset3;
        long mBits2;
        long initOffset2;
        long mBits1;
        int tmpOutPos = 0;
        while (startIndex + 448 < endIndex) {
            mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
            initOffset2 = in[startIndex + 63];
            mBits2 = LongBitPacker.maxDiffBits(initOffset2, in, startIndex + 64);
            initOffset3 = in[startIndex + 127];
            mBits3 = LongBitPacker.maxDiffBits(initOffset3, in, startIndex + 128);
            initOffset4 = in[startIndex + 191];
            mBits4 = LongBitPacker.maxDiffBits(initOffset4, in, startIndex + 192);
            initOffset5 = in[startIndex + 255];
            mBits5 = LongBitPacker.maxDiffBits(initOffset5, in, startIndex + 256);
            initOffset6 = in[startIndex + 319];
            mBits6 = LongBitPacker.maxDiffBits(initOffset6, in, startIndex + 320);
            initOffset7 = in[startIndex + 383];
            mBits7 = LongBitPacker.maxDiffBits(initOffset7, in, startIndex + 384);
            long initOffset8 = in[startIndex + 447];
            long mBits8 = LongBitPacker.maxDiffBits(initOffset8, in, startIndex + 448);
            out[tmpOutPos++] = mBits1 << 56 | mBits2 << 48 | mBits3 << 40 | mBits4 << 32 | mBits5 << 24 | mBits6 << 16 | mBits7 << 8 | mBits8;
            LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
            tmpOutPos = (int)((long)tmpOutPos + mBits1);
            LongBitPacker.pack(initOffset2, in, startIndex + 64, out, tmpOutPos, mBits2);
            tmpOutPos = (int)((long)tmpOutPos + mBits2);
            LongBitPacker.pack(initOffset3, in, startIndex + 128, out, tmpOutPos, mBits3);
            tmpOutPos = (int)((long)tmpOutPos + mBits3);
            LongBitPacker.pack(initOffset4, in, startIndex + 192, out, tmpOutPos, mBits4);
            tmpOutPos = (int)((long)tmpOutPos + mBits4);
            LongBitPacker.pack(initOffset5, in, startIndex + 256, out, tmpOutPos, mBits5);
            tmpOutPos = (int)((long)tmpOutPos + mBits5);
            LongBitPacker.pack(initOffset6, in, startIndex + 320, out, tmpOutPos, mBits6);
            tmpOutPos = (int)((long)tmpOutPos + mBits6);
            LongBitPacker.pack(initOffset7, in, startIndex + 384, out, tmpOutPos, mBits7);
            tmpOutPos = (int)((long)tmpOutPos + mBits7);
            LongBitPacker.pack(initOffset8, in, startIndex + 448, out, tmpOutPos, mBits8);
            tmpOutPos = (int)((long)tmpOutPos + mBits8);
            initValue = in[startIndex + 511];
            startIndex += 512;
        }
        switch (endIndex - startIndex) {
            case 64: {
                mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
                out[tmpOutPos++] = mBits1;
                LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                return tmpOutPos + (int)mBits1;
            }
            case 128: {
                mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 63];
                mBits2 = LongBitPacker.maxDiffBits(initOffset2, in, startIndex + 64);
                out[tmpOutPos++] = mBits1 << 8 | mBits2;
                LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                tmpOutPos = (int)((long)tmpOutPos + mBits1);
                LongBitPacker.pack(initOffset2, in, startIndex + 64, out, tmpOutPos, mBits2);
                return tmpOutPos + (int)mBits2;
            }
            case 192: {
                mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 63];
                mBits2 = LongBitPacker.maxDiffBits(initOffset2, in, startIndex + 64);
                initOffset3 = in[startIndex + 127];
                mBits3 = LongBitPacker.maxDiffBits(initOffset3, in, startIndex + 128);
                out[tmpOutPos++] = mBits1 << 16 | mBits2 << 8 | mBits3;
                LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                tmpOutPos = (int)((long)tmpOutPos + mBits1);
                LongBitPacker.pack(initOffset2, in, startIndex + 64, out, tmpOutPos, mBits2);
                tmpOutPos = (int)((long)tmpOutPos + mBits2);
                LongBitPacker.pack(initOffset3, in, startIndex + 128, out, tmpOutPos, mBits3);
                return tmpOutPos + (int)mBits3;
            }
            case 256: {
                mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 63];
                mBits2 = LongBitPacker.maxDiffBits(initOffset2, in, startIndex + 64);
                initOffset3 = in[startIndex + 127];
                mBits3 = LongBitPacker.maxDiffBits(initOffset3, in, startIndex + 128);
                initOffset4 = in[startIndex + 191];
                mBits4 = LongBitPacker.maxDiffBits(initOffset4, in, startIndex + 192);
                out[tmpOutPos++] = mBits1 << 24 | mBits2 << 16 | mBits3 << 8 | mBits4;
                LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                tmpOutPos = (int)((long)tmpOutPos + mBits1);
                LongBitPacker.pack(initOffset2, in, startIndex + 64, out, tmpOutPos, mBits2);
                tmpOutPos = (int)((long)tmpOutPos + mBits2);
                LongBitPacker.pack(initOffset3, in, startIndex + 128, out, tmpOutPos, mBits3);
                tmpOutPos = (int)((long)tmpOutPos + mBits3);
                LongBitPacker.pack(initOffset4, in, startIndex + 192, out, tmpOutPos, mBits4);
                return tmpOutPos + (int)mBits4;
            }
            case 320: {
                mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 63];
                mBits2 = LongBitPacker.maxDiffBits(initOffset2, in, startIndex + 64);
                initOffset3 = in[startIndex + 127];
                mBits3 = LongBitPacker.maxDiffBits(initOffset3, in, startIndex + 128);
                initOffset4 = in[startIndex + 191];
                mBits4 = LongBitPacker.maxDiffBits(initOffset4, in, startIndex + 192);
                initOffset5 = in[startIndex + 255];
                mBits5 = LongBitPacker.maxDiffBits(initOffset5, in, startIndex + 256);
                out[tmpOutPos++] = mBits1 << 32 | mBits2 << 24 | mBits3 << 16 | mBits4 << 8 | mBits5;
                LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                tmpOutPos = (int)((long)tmpOutPos + mBits1);
                LongBitPacker.pack(initOffset2, in, startIndex + 64, out, tmpOutPos, mBits2);
                tmpOutPos = (int)((long)tmpOutPos + mBits2);
                LongBitPacker.pack(initOffset3, in, startIndex + 128, out, tmpOutPos, mBits3);
                tmpOutPos = (int)((long)tmpOutPos + mBits3);
                LongBitPacker.pack(initOffset4, in, startIndex + 192, out, tmpOutPos, mBits4);
                tmpOutPos = (int)((long)tmpOutPos + mBits4);
                LongBitPacker.pack(initOffset5, in, startIndex + 256, out, tmpOutPos, mBits5);
                return tmpOutPos + (int)mBits5;
            }
            case 384: {
                mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 63];
                mBits2 = LongBitPacker.maxDiffBits(initOffset2, in, startIndex + 64);
                initOffset3 = in[startIndex + 127];
                mBits3 = LongBitPacker.maxDiffBits(initOffset3, in, startIndex + 128);
                initOffset4 = in[startIndex + 191];
                mBits4 = LongBitPacker.maxDiffBits(initOffset4, in, startIndex + 192);
                initOffset5 = in[startIndex + 255];
                mBits5 = LongBitPacker.maxDiffBits(initOffset5, in, startIndex + 256);
                initOffset6 = in[startIndex + 319];
                mBits6 = LongBitPacker.maxDiffBits(initOffset6, in, startIndex + 320);
                out[tmpOutPos++] = mBits1 << 40 | mBits2 << 32 | mBits3 << 24 | mBits4 << 16 | mBits5 << 8 | mBits6;
                LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                tmpOutPos = (int)((long)tmpOutPos + mBits1);
                LongBitPacker.pack(initOffset2, in, startIndex + 64, out, tmpOutPos, mBits2);
                tmpOutPos = (int)((long)tmpOutPos + mBits2);
                LongBitPacker.pack(initOffset3, in, startIndex + 128, out, tmpOutPos, mBits3);
                tmpOutPos = (int)((long)tmpOutPos + mBits3);
                LongBitPacker.pack(initOffset4, in, startIndex + 192, out, tmpOutPos, mBits4);
                tmpOutPos = (int)((long)tmpOutPos + mBits4);
                LongBitPacker.pack(initOffset5, in, startIndex + 256, out, tmpOutPos, mBits5);
                tmpOutPos = (int)((long)tmpOutPos + mBits5);
                LongBitPacker.pack(initOffset6, in, startIndex + 320, out, tmpOutPos, mBits6);
                return tmpOutPos + (int)mBits6;
            }
            case 448: {
                mBits1 = LongBitPacker.maxDiffBits(initValue, in, startIndex);
                initOffset2 = in[startIndex + 63];
                mBits2 = LongBitPacker.maxDiffBits(initOffset2, in, startIndex + 64);
                initOffset3 = in[startIndex + 127];
                mBits3 = LongBitPacker.maxDiffBits(initOffset3, in, startIndex + 128);
                initOffset4 = in[startIndex + 191];
                mBits4 = LongBitPacker.maxDiffBits(initOffset4, in, startIndex + 192);
                initOffset5 = in[startIndex + 255];
                mBits5 = LongBitPacker.maxDiffBits(initOffset5, in, startIndex + 256);
                initOffset6 = in[startIndex + 319];
                mBits6 = LongBitPacker.maxDiffBits(initOffset6, in, startIndex + 320);
                initOffset7 = in[startIndex + 383];
                mBits7 = LongBitPacker.maxDiffBits(initOffset7, in, startIndex + 384);
                out[tmpOutPos++] = mBits1 << 48 | mBits2 << 40 | mBits3 << 32 | mBits4 << 24 | mBits5 << 16 | mBits6 << 8 | mBits7;
                LongBitPacker.pack(initValue, in, startIndex, out, tmpOutPos, mBits1);
                tmpOutPos = (int)((long)tmpOutPos + mBits1);
                LongBitPacker.pack(initOffset2, in, startIndex + 64, out, tmpOutPos, mBits2);
                tmpOutPos = (int)((long)tmpOutPos + mBits2);
                LongBitPacker.pack(initOffset3, in, startIndex + 128, out, tmpOutPos, mBits3);
                tmpOutPos = (int)((long)tmpOutPos + mBits3);
                LongBitPacker.pack(initOffset4, in, startIndex + 192, out, tmpOutPos, mBits4);
                tmpOutPos = (int)((long)tmpOutPos + mBits4);
                LongBitPacker.pack(initOffset5, in, startIndex + 256, out, tmpOutPos, mBits5);
                tmpOutPos = (int)((long)tmpOutPos + mBits5);
                LongBitPacker.pack(initOffset6, in, startIndex + 320, out, tmpOutPos, mBits6);
                tmpOutPos = (int)((long)tmpOutPos + mBits6);
                LongBitPacker.pack(initOffset7, in, startIndex + 384, out, tmpOutPos, mBits7);
                return tmpOutPos + (int)mBits7;
            }
            case 0: {
                return tmpOutPos;
            }
        }
        throw new IllegalStateException();
    }

    public static void decompressIntegrated(long[] in, int startIndex, long[] out, int outPosition, int outEndIndex, long initValue) {
        long mBits7;
        long mBits6;
        long mBits5;
        long mBits4;
        long mBits3;
        long mBits2;
        long mBits1;
        assert (outEndIndex != 0);
        int index = startIndex;
        int s = outPosition;
        while (s + 511 < outEndIndex) {
            mBits1 = in[index] >>> 56;
            mBits2 = in[index] >>> 48 & 0xFFL;
            mBits3 = in[index] >>> 40 & 0xFFL;
            mBits4 = in[index] >>> 32 & 0xFFL;
            mBits5 = in[index] >>> 24 & 0xFFL;
            mBits6 = in[index] >>> 16 & 0xFFL;
            mBits7 = in[index] >>> 8 & 0xFFL;
            long mBits8 = in[index] & 0xFFL;
            LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
            index = (int)((long)index + mBits1);
            initValue = out[s + 63];
            LongBitPacker.unpack(initValue, in, index, out, s + 64, mBits2);
            index = (int)((long)index + mBits2);
            initValue = out[s + 127];
            LongBitPacker.unpack(initValue, in, index, out, s + 128, mBits3);
            index = (int)((long)index + mBits3);
            initValue = out[s + 191];
            LongBitPacker.unpack(initValue, in, index, out, s + 192, mBits4);
            index = (int)((long)index + mBits4);
            initValue = out[s + 255];
            LongBitPacker.unpack(initValue, in, index, out, s + 256, mBits5);
            index = (int)((long)index + mBits5);
            initValue = out[s + 319];
            LongBitPacker.unpack(initValue, in, index, out, s + 320, mBits6);
            index = (int)((long)index + mBits6);
            initValue = out[s + 383];
            LongBitPacker.unpack(initValue, in, index, out, s + 384, mBits7);
            index = (int)((long)index + mBits7);
            initValue = out[s + 447];
            LongBitPacker.unpack(initValue, in, index, out, s + 448, mBits8);
            index = (int)((long)index + mBits8);
            initValue = out[s + 511];
            s += 512;
        }
        switch (outEndIndex - s) {
            case 64: {
                mBits1 = in[index] & 0xFFL;
                LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                break;
            }
            case 128: {
                mBits1 = in[index] >>> 8;
                mBits2 = in[index] & 0xFFL;
                LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                index = (int)((long)index + mBits1);
                initValue = out[s + 63];
                LongBitPacker.unpack(initValue, in, index, out, s + 64, mBits2);
                break;
            }
            case 192: {
                mBits1 = in[index] >>> 16;
                mBits2 = in[index] >>> 8 & 0xFFL;
                mBits3 = in[index] & 0xFFL;
                LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                index = (int)((long)index + mBits1);
                initValue = out[s + 63];
                LongBitPacker.unpack(initValue, in, index, out, s + 64, mBits2);
                index = (int)((long)index + mBits2);
                initValue = out[s + 127];
                LongBitPacker.unpack(initValue, in, index, out, s + 128, mBits3);
                break;
            }
            case 256: {
                mBits1 = in[index] >>> 24;
                mBits2 = in[index] >>> 16 & 0xFFL;
                mBits3 = in[index] >>> 8 & 0xFFL;
                mBits4 = in[index] & 0xFFL;
                LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                index = (int)((long)index + mBits1);
                initValue = out[s + 63];
                LongBitPacker.unpack(initValue, in, index, out, s + 64, mBits2);
                index = (int)((long)index + mBits2);
                initValue = out[s + 127];
                LongBitPacker.unpack(initValue, in, index, out, s + 128, mBits3);
                index = (int)((long)index + mBits3);
                initValue = out[s + 191];
                LongBitPacker.unpack(initValue, in, index, out, s + 192, mBits4);
                break;
            }
            case 320: {
                mBits1 = in[index] >>> 32;
                mBits2 = in[index] >>> 24 & 0xFFL;
                mBits3 = in[index] >>> 16 & 0xFFL;
                mBits4 = in[index] >>> 8 & 0xFFL;
                mBits5 = in[index] & 0xFFL;
                LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                index = (int)((long)index + mBits1);
                initValue = out[s + 63];
                LongBitPacker.unpack(initValue, in, index, out, s + 64, mBits2);
                index = (int)((long)index + mBits2);
                initValue = out[s + 127];
                LongBitPacker.unpack(initValue, in, index, out, s + 128, mBits3);
                index = (int)((long)index + mBits3);
                initValue = out[s + 191];
                LongBitPacker.unpack(initValue, in, index, out, s + 192, mBits4);
                index = (int)((long)index + mBits4);
                initValue = out[s + 255];
                LongBitPacker.unpack(initValue, in, index, out, s + 256, mBits5);
                break;
            }
            case 384: {
                mBits1 = in[index] >>> 40;
                mBits2 = in[index] >>> 32 & 0xFFL;
                mBits3 = in[index] >>> 24 & 0xFFL;
                mBits4 = in[index] >>> 16 & 0xFFL;
                mBits5 = in[index] >>> 8 & 0xFFL;
                mBits6 = in[index] & 0xFFL;
                LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                index = (int)((long)index + mBits1);
                initValue = out[s + 63];
                LongBitPacker.unpack(initValue, in, index, out, s + 64, mBits2);
                index = (int)((long)index + mBits2);
                initValue = out[s + 127];
                LongBitPacker.unpack(initValue, in, index, out, s + 128, mBits3);
                index = (int)((long)index + mBits3);
                initValue = out[s + 191];
                LongBitPacker.unpack(initValue, in, index, out, s + 192, mBits4);
                index = (int)((long)index + mBits4);
                initValue = out[s + 255];
                LongBitPacker.unpack(initValue, in, index, out, s + 256, mBits5);
                index = (int)((long)index + mBits5);
                initValue = out[s + 319];
                LongBitPacker.unpack(initValue, in, index, out, s + 320, mBits6);
                break;
            }
            case 448: {
                mBits1 = in[index] >>> 48;
                mBits2 = in[index] >>> 40 & 0xFFL;
                mBits3 = in[index] >>> 32 & 0xFFL;
                mBits4 = in[index] >>> 24 & 0xFFL;
                mBits5 = in[index] >>> 16 & 0xFFL;
                mBits6 = in[index] >>> 8 & 0xFFL;
                mBits7 = in[index] & 0xFFL;
                LongBitPacker.unpack(initValue, in, ++index, out, s, mBits1);
                index = (int)((long)index + mBits1);
                initValue = out[s + 63];
                LongBitPacker.unpack(initValue, in, index, out, s + 64, mBits2);
                index = (int)((long)index + mBits2);
                initValue = out[s + 127];
                LongBitPacker.unpack(initValue, in, index, out, s + 128, mBits3);
                index = (int)((long)index + mBits3);
                initValue = out[s + 191];
                LongBitPacker.unpack(initValue, in, index, out, s + 192, mBits4);
                index = (int)((long)index + mBits4);
                initValue = out[s + 255];
                LongBitPacker.unpack(initValue, in, index, out, s + 256, mBits5);
                index = (int)((long)index + mBits5);
                initValue = out[s + 319];
                LongBitPacker.unpack(initValue, in, index, out, s + 320, mBits6);
                index = (int)((long)index + mBits6);
                initValue = out[s + 383];
                LongBitPacker.unpack(initValue, in, index, out, s + 384, mBits7);
            }
        }
    }

    public static void writeVar(ByteBuf buf, long value) {
        if (value >>> 7 == 0L) {
            buf.writeByte((byte)value);
        } else if (value >>> 14 == 0L) {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7));
        } else if (value >>> 21 == 0L) {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14));
        } else if (value >>> 28 == 0L) {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14 | 0x80L));
            buf.writeByte((byte)(value >>> 21));
        } else if (value >>> 35 == 0L) {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14 | 0x80L));
            buf.writeByte((byte)(value >>> 21 | 0x80L));
            buf.writeByte((byte)(value >>> 28));
        } else if (value >>> 42 == 0L) {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14 | 0x80L));
            buf.writeByte((byte)(value >>> 21 | 0x80L));
            buf.writeByte((byte)(value >>> 28 | 0x80L));
            buf.writeByte((byte)(value >>> 35));
        } else if (value >>> 49 == 0L) {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14 | 0x80L));
            buf.writeByte((byte)(value >>> 21 | 0x80L));
            buf.writeByte((byte)(value >>> 28 | 0x80L));
            buf.writeByte((byte)(value >>> 35 | 0x80L));
            buf.writeByte((byte)(value >>> 42));
        } else if (value >>> 56 == 0L) {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14 | 0x80L));
            buf.writeByte((byte)(value >>> 21 | 0x80L));
            buf.writeByte((byte)(value >>> 28 | 0x80L));
            buf.writeByte((byte)(value >>> 35 | 0x80L));
            buf.writeByte((byte)(value >>> 42 | 0x80L));
            buf.writeByte((byte)(value >>> 49));
        } else {
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14 | 0x80L));
            buf.writeByte((byte)(value >>> 21 | 0x80L));
            buf.writeByte((byte)(value >>> 28 | 0x80L));
            buf.writeByte((byte)(value >>> 35 | 0x80L));
            buf.writeByte((byte)(value >>> 42 | 0x80L));
            buf.writeByte((byte)(value >>> 49 | 0x80L));
            buf.writeByte((byte)(value >>> 56));
        }
    }

    public static long readVar(ByteBuf buf) {
        byte aByte = buf.readByte();
        long value = aByte & 0x7F;
        if ((aByte & 0x80) != 0) {
            aByte = buf.readByte();
            value |= (long)((aByte & 0x7F) << 7);
            if ((aByte & 0x80) != 0) {
                aByte = buf.readByte();
                value |= (long)((aByte & 0x7F) << 14);
                if ((aByte & 0x80) != 0) {
                    aByte = buf.readByte();
                    value |= (long)((aByte & 0x7F) << 21);
                    if ((aByte & 0x80) != 0) {
                        aByte = buf.readByte();
                        value |= (long)(aByte & 0x7F) << 28;
                        if ((aByte & 0x80) != 0) {
                            aByte = buf.readByte();
                            value |= (long)(aByte & 0x7F) << 35;
                            if ((aByte & 0x80) != 0) {
                                aByte = buf.readByte();
                                value |= (long)(aByte & 0x7F) << 42;
                                if ((aByte & 0x80) != 0) {
                                    aByte = buf.readByte();
                                    value |= (long)(aByte & 0x7F) << 49;
                                    if ((aByte & 0x80) != 0) {
                                        value |= (long)buf.readByte() << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return value;
    }

    public static void compressVariable(long[] in, int startIndex, int endIndex, ByteBuf buf) {
        long initValue = 0L;
        for (int index = startIndex; index < endIndex; ++index) {
            long value = in[index] - initValue;
            initValue = in[index];
            if (value >>> 7 == 0L) {
                buf.writeByte((byte)value);
                continue;
            }
            if (value >>> 14 == 0L) {
                buf.writeByte((byte)(value & 0x7FL | 0x80L));
                buf.writeByte((byte)(value >>> 7));
                continue;
            }
            if (value >>> 21 == 0L) {
                buf.writeByte((byte)(value & 0x7FL | 0x80L));
                buf.writeByte((byte)(value >>> 7 | 0x80L));
                buf.writeByte((byte)(value >>> 14));
                continue;
            }
            if (value >>> 28 == 0L) {
                buf.writeByte((byte)(value & 0x7FL | 0x80L));
                buf.writeByte((byte)(value >>> 7 | 0x80L));
                buf.writeByte((byte)(value >>> 14 | 0x80L));
                buf.writeByte((byte)(value >>> 21));
                continue;
            }
            if (value >>> 35 == 0L) {
                buf.writeByte((byte)(value & 0x7FL | 0x80L));
                buf.writeByte((byte)(value >>> 7 | 0x80L));
                buf.writeByte((byte)(value >>> 14 | 0x80L));
                buf.writeByte((byte)(value >>> 21 | 0x80L));
                buf.writeByte((byte)(value >>> 28));
                continue;
            }
            if (value >>> 42 == 0L) {
                buf.writeByte((byte)(value & 0x7FL | 0x80L));
                buf.writeByte((byte)(value >>> 7 | 0x80L));
                buf.writeByte((byte)(value >>> 14 | 0x80L));
                buf.writeByte((byte)(value >>> 21 | 0x80L));
                buf.writeByte((byte)(value >>> 28 | 0x80L));
                buf.writeByte((byte)(value >>> 35));
                continue;
            }
            if (value >>> 49 == 0L) {
                buf.writeByte((byte)(value & 0x7FL | 0x80L));
                buf.writeByte((byte)(value >>> 7 | 0x80L));
                buf.writeByte((byte)(value >>> 14 | 0x80L));
                buf.writeByte((byte)(value >>> 21 | 0x80L));
                buf.writeByte((byte)(value >>> 28 | 0x80L));
                buf.writeByte((byte)(value >>> 35 | 0x80L));
                buf.writeByte((byte)(value >>> 42));
                continue;
            }
            if (value >>> 56 == 0L) {
                buf.writeByte((byte)(value & 0x7FL | 0x80L));
                buf.writeByte((byte)(value >>> 7 | 0x80L));
                buf.writeByte((byte)(value >>> 14 | 0x80L));
                buf.writeByte((byte)(value >>> 21 | 0x80L));
                buf.writeByte((byte)(value >>> 28 | 0x80L));
                buf.writeByte((byte)(value >>> 35 | 0x80L));
                buf.writeByte((byte)(value >>> 42 | 0x80L));
                buf.writeByte((byte)(value >>> 49));
                continue;
            }
            buf.writeByte((byte)(value & 0x7FL | 0x80L));
            buf.writeByte((byte)(value >>> 7 | 0x80L));
            buf.writeByte((byte)(value >>> 14 | 0x80L));
            buf.writeByte((byte)(value >>> 21 | 0x80L));
            buf.writeByte((byte)(value >>> 28 | 0x80L));
            buf.writeByte((byte)(value >>> 35 | 0x80L));
            buf.writeByte((byte)(value >>> 42 | 0x80L));
            buf.writeByte((byte)(value >>> 49 | 0x80L));
            buf.writeByte((byte)(value >>> 56));
        }
    }

    public static void decompressVariable(ByteBuf buf, long[] out, int endIndex) {
        long initValue = 0L;
        int index = 0;
        while (index < endIndex) {
            byte aByte = buf.readByte();
            long value = aByte & 0x7F;
            if ((aByte & 0x80) != 0) {
                aByte = buf.readByte();
                value |= (long)((aByte & 0x7F) << 7);
                if ((aByte & 0x80) != 0) {
                    aByte = buf.readByte();
                    value |= (long)((aByte & 0x7F) << 14);
                    if ((aByte & 0x80) != 0) {
                        aByte = buf.readByte();
                        value |= (long)((aByte & 0x7F) << 21);
                        if ((aByte & 0x80) != 0) {
                            aByte = buf.readByte();
                            value |= (long)(aByte & 0x7F) << 28;
                            if ((aByte & 0x80) != 0) {
                                aByte = buf.readByte();
                                value |= (long)(aByte & 0x7F) << 35;
                                if ((aByte & 0x80) != 0) {
                                    aByte = buf.readByte();
                                    value |= (long)(aByte & 0x7F) << 42;
                                    if ((aByte & 0x80) != 0) {
                                        aByte = buf.readByte();
                                        value |= (long)(aByte & 0x7F) << 49;
                                        if ((aByte & 0x80) != 0) {
                                            value |= (long)buf.readByte() << 56;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            out[index++] = initValue += value;
        }
    }

    private static int maxDiffBits(long initValue, long[] in, int position) {
        long mask = in[position] - initValue;
        for (int i = position + 1; i < position + 64; ++i) {
            mask |= in[i] - in[i - 1];
        }
        return 64 - Long.numberOfLeadingZeros(mask);
    }

    private static void pack(long initValue, long[] in, int inPos, long[] out, int outPos, long bitCount) {
        switch ((byte)bitCount) {
            case 0: {
                break;
            }
            case 1: {
                LongBitPacker.pack1(initValue, in, inPos, out, outPos);
                break;
            }
            case 2: {
                LongBitPacker.pack2(initValue, in, inPos, out, outPos);
                break;
            }
            case 3: {
                LongBitPacker.pack3(initValue, in, inPos, out, outPos);
                break;
            }
            case 4: {
                LongBitPacker.pack4(initValue, in, inPos, out, outPos);
                break;
            }
            case 5: {
                LongBitPacker.pack5(initValue, in, inPos, out, outPos);
                break;
            }
            case 6: {
                LongBitPacker.pack6(initValue, in, inPos, out, outPos);
                break;
            }
            case 7: {
                LongBitPacker.pack7(initValue, in, inPos, out, outPos);
                break;
            }
            case 8: {
                LongBitPacker.pack8(initValue, in, inPos, out, outPos);
                break;
            }
            case 9: {
                LongBitPacker.pack9(initValue, in, inPos, out, outPos);
                break;
            }
            case 10: {
                LongBitPacker.pack10(initValue, in, inPos, out, outPos);
                break;
            }
            case 11: {
                LongBitPacker.pack11(initValue, in, inPos, out, outPos);
                break;
            }
            case 12: {
                LongBitPacker.pack12(initValue, in, inPos, out, outPos);
                break;
            }
            case 13: {
                LongBitPacker.pack13(initValue, in, inPos, out, outPos);
                break;
            }
            case 14: {
                LongBitPacker.pack14(initValue, in, inPos, out, outPos);
                break;
            }
            case 15: {
                LongBitPacker.pack15(initValue, in, inPos, out, outPos);
                break;
            }
            case 16: {
                LongBitPacker.pack16(initValue, in, inPos, out, outPos);
                break;
            }
            case 17: {
                LongBitPacker.pack17(initValue, in, inPos, out, outPos);
                break;
            }
            case 18: {
                LongBitPacker.pack18(initValue, in, inPos, out, outPos);
                break;
            }
            case 19: {
                LongBitPacker.pack19(initValue, in, inPos, out, outPos);
                break;
            }
            case 20: {
                LongBitPacker.pack20(initValue, in, inPos, out, outPos);
                break;
            }
            case 21: {
                LongBitPacker.pack21(initValue, in, inPos, out, outPos);
                break;
            }
            case 22: {
                LongBitPacker.pack22(initValue, in, inPos, out, outPos);
                break;
            }
            case 23: {
                LongBitPacker.pack23(initValue, in, inPos, out, outPos);
                break;
            }
            case 24: {
                LongBitPacker.pack24(initValue, in, inPos, out, outPos);
                break;
            }
            case 25: {
                LongBitPacker.pack25(initValue, in, inPos, out, outPos);
                break;
            }
            case 26: {
                LongBitPacker.pack26(initValue, in, inPos, out, outPos);
                break;
            }
            case 27: {
                LongBitPacker.pack27(initValue, in, inPos, out, outPos);
                break;
            }
            case 28: {
                LongBitPacker.pack28(initValue, in, inPos, out, outPos);
                break;
            }
            case 29: {
                LongBitPacker.pack29(initValue, in, inPos, out, outPos);
                break;
            }
            case 30: {
                LongBitPacker.pack30(initValue, in, inPos, out, outPos);
                break;
            }
            case 31: {
                LongBitPacker.pack31(initValue, in, inPos, out, outPos);
                break;
            }
            case 32: {
                LongBitPacker.pack32(initValue, in, inPos, out, outPos);
                break;
            }
            case 33: {
                LongBitPacker.pack33(initValue, in, inPos, out, outPos);
                break;
            }
            case 34: {
                LongBitPacker.pack34(initValue, in, inPos, out, outPos);
                break;
            }
            case 35: {
                LongBitPacker.pack35(initValue, in, inPos, out, outPos);
                break;
            }
            case 36: {
                LongBitPacker.pack36(initValue, in, inPos, out, outPos);
                break;
            }
            case 37: {
                LongBitPacker.pack37(initValue, in, inPos, out, outPos);
                break;
            }
            case 38: {
                LongBitPacker.pack38(initValue, in, inPos, out, outPos);
                break;
            }
            case 39: {
                LongBitPacker.pack39(initValue, in, inPos, out, outPos);
                break;
            }
            case 40: {
                LongBitPacker.pack40(initValue, in, inPos, out, outPos);
                break;
            }
            case 41: {
                LongBitPacker.pack41(initValue, in, inPos, out, outPos);
                break;
            }
            case 42: {
                LongBitPacker.pack42(initValue, in, inPos, out, outPos);
                break;
            }
            case 43: {
                LongBitPacker.pack43(initValue, in, inPos, out, outPos);
                break;
            }
            case 44: {
                LongBitPacker.pack44(initValue, in, inPos, out, outPos);
                break;
            }
            case 45: {
                LongBitPacker.pack45(initValue, in, inPos, out, outPos);
                break;
            }
            case 46: {
                LongBitPacker.pack46(initValue, in, inPos, out, outPos);
                break;
            }
            case 47: {
                LongBitPacker.pack47(initValue, in, inPos, out, outPos);
                break;
            }
            case 48: {
                LongBitPacker.pack48(initValue, in, inPos, out, outPos);
                break;
            }
            case 49: {
                LongBitPacker.pack49(initValue, in, inPos, out, outPos);
                break;
            }
            case 50: {
                LongBitPacker.pack50(initValue, in, inPos, out, outPos);
                break;
            }
            case 51: {
                LongBitPacker.pack51(initValue, in, inPos, out, outPos);
                break;
            }
            case 52: {
                LongBitPacker.pack52(initValue, in, inPos, out, outPos);
                break;
            }
            case 53: {
                LongBitPacker.pack53(initValue, in, inPos, out, outPos);
                break;
            }
            case 54: {
                LongBitPacker.pack54(initValue, in, inPos, out, outPos);
                break;
            }
            case 55: {
                LongBitPacker.pack55(initValue, in, inPos, out, outPos);
                break;
            }
            case 56: {
                LongBitPacker.pack56(initValue, in, inPos, out, outPos);
                break;
            }
            case 57: {
                LongBitPacker.pack57(initValue, in, inPos, out, outPos);
                break;
            }
            case 58: {
                LongBitPacker.pack58(initValue, in, inPos, out, outPos);
                break;
            }
            case 59: {
                LongBitPacker.pack59(initValue, in, inPos, out, outPos);
                break;
            }
            case 60: {
                LongBitPacker.pack60(initValue, in, inPos, out, outPos);
                break;
            }
            case 61: {
                LongBitPacker.pack61(initValue, in, inPos, out, outPos);
                break;
            }
            case 62: {
                LongBitPacker.pack62(initValue, in, inPos, out, outPos);
                break;
            }
            case 63: {
                LongBitPacker.pack63(initValue, in, inPos, out, outPos);
                break;
            }
            case 64: {
                System.arraycopy(in, inPos, out, outPos, 64);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bit width: " + bitCount);
            }
        }
    }

    private static void unpack(long initValue, long[] in, int inPos, long[] out, int outPos, long bitCount) {
        switch ((byte)bitCount) {
            case 0: {
                Arrays.fill(out, outPos, outPos + 64, initValue);
                break;
            }
            case 1: {
                LongBitPacker.unpack1(initValue, in, inPos, out, outPos);
                break;
            }
            case 2: {
                LongBitPacker.unpack2(initValue, in, inPos, out, outPos);
                break;
            }
            case 3: {
                LongBitPacker.unpack3(initValue, in, inPos, out, outPos);
                break;
            }
            case 4: {
                LongBitPacker.unpack4(initValue, in, inPos, out, outPos);
                break;
            }
            case 5: {
                LongBitPacker.unpack5(initValue, in, inPos, out, outPos);
                break;
            }
            case 6: {
                LongBitPacker.unpack6(initValue, in, inPos, out, outPos);
                break;
            }
            case 7: {
                LongBitPacker.unpack7(initValue, in, inPos, out, outPos);
                break;
            }
            case 8: {
                LongBitPacker.unpack8(initValue, in, inPos, out, outPos);
                break;
            }
            case 9: {
                LongBitPacker.unpack9(initValue, in, inPos, out, outPos);
                break;
            }
            case 10: {
                LongBitPacker.unpack10(initValue, in, inPos, out, outPos);
                break;
            }
            case 11: {
                LongBitPacker.unpack11(initValue, in, inPos, out, outPos);
                break;
            }
            case 12: {
                LongBitPacker.unpack12(initValue, in, inPos, out, outPos);
                break;
            }
            case 13: {
                LongBitPacker.unpack13(initValue, in, inPos, out, outPos);
                break;
            }
            case 14: {
                LongBitPacker.unpack14(initValue, in, inPos, out, outPos);
                break;
            }
            case 15: {
                LongBitPacker.unpack15(initValue, in, inPos, out, outPos);
                break;
            }
            case 16: {
                LongBitPacker.unpack16(initValue, in, inPos, out, outPos);
                break;
            }
            case 17: {
                LongBitPacker.unpack17(initValue, in, inPos, out, outPos);
                break;
            }
            case 18: {
                LongBitPacker.unpack18(initValue, in, inPos, out, outPos);
                break;
            }
            case 19: {
                LongBitPacker.unpack19(initValue, in, inPos, out, outPos);
                break;
            }
            case 20: {
                LongBitPacker.unpack20(initValue, in, inPos, out, outPos);
                break;
            }
            case 21: {
                LongBitPacker.unpack21(initValue, in, inPos, out, outPos);
                break;
            }
            case 22: {
                LongBitPacker.unpack22(initValue, in, inPos, out, outPos);
                break;
            }
            case 23: {
                LongBitPacker.unpack23(initValue, in, inPos, out, outPos);
                break;
            }
            case 24: {
                LongBitPacker.unpack24(initValue, in, inPos, out, outPos);
                break;
            }
            case 25: {
                LongBitPacker.unpack25(initValue, in, inPos, out, outPos);
                break;
            }
            case 26: {
                LongBitPacker.unpack26(initValue, in, inPos, out, outPos);
                break;
            }
            case 27: {
                LongBitPacker.unpack27(initValue, in, inPos, out, outPos);
                break;
            }
            case 28: {
                LongBitPacker.unpack28(initValue, in, inPos, out, outPos);
                break;
            }
            case 29: {
                LongBitPacker.unpack29(initValue, in, inPos, out, outPos);
                break;
            }
            case 30: {
                LongBitPacker.unpack30(initValue, in, inPos, out, outPos);
                break;
            }
            case 31: {
                LongBitPacker.unpack31(initValue, in, inPos, out, outPos);
                break;
            }
            case 32: {
                LongBitPacker.unpack32(initValue, in, inPos, out, outPos);
                break;
            }
            case 33: {
                LongBitPacker.unpack33(initValue, in, inPos, out, outPos);
                break;
            }
            case 34: {
                LongBitPacker.unpack34(initValue, in, inPos, out, outPos);
                break;
            }
            case 35: {
                LongBitPacker.unpack35(initValue, in, inPos, out, outPos);
                break;
            }
            case 36: {
                LongBitPacker.unpack36(initValue, in, inPos, out, outPos);
                break;
            }
            case 37: {
                LongBitPacker.unpack37(initValue, in, inPos, out, outPos);
                break;
            }
            case 38: {
                LongBitPacker.unpack38(initValue, in, inPos, out, outPos);
                break;
            }
            case 39: {
                LongBitPacker.unpack39(initValue, in, inPos, out, outPos);
                break;
            }
            case 40: {
                LongBitPacker.unpack40(initValue, in, inPos, out, outPos);
                break;
            }
            case 41: {
                LongBitPacker.unpack41(initValue, in, inPos, out, outPos);
                break;
            }
            case 42: {
                LongBitPacker.unpack42(initValue, in, inPos, out, outPos);
                break;
            }
            case 43: {
                LongBitPacker.unpack43(initValue, in, inPos, out, outPos);
                break;
            }
            case 44: {
                LongBitPacker.unpack44(initValue, in, inPos, out, outPos);
                break;
            }
            case 45: {
                LongBitPacker.unpack45(initValue, in, inPos, out, outPos);
                break;
            }
            case 46: {
                LongBitPacker.unpack46(initValue, in, inPos, out, outPos);
                break;
            }
            case 47: {
                LongBitPacker.unpack47(initValue, in, inPos, out, outPos);
                break;
            }
            case 48: {
                LongBitPacker.unpack48(initValue, in, inPos, out, outPos);
                break;
            }
            case 49: {
                LongBitPacker.unpack49(initValue, in, inPos, out, outPos);
                break;
            }
            case 50: {
                LongBitPacker.unpack50(initValue, in, inPos, out, outPos);
                break;
            }
            case 51: {
                LongBitPacker.unpack51(initValue, in, inPos, out, outPos);
                break;
            }
            case 52: {
                LongBitPacker.unpack52(initValue, in, inPos, out, outPos);
                break;
            }
            case 53: {
                LongBitPacker.unpack53(initValue, in, inPos, out, outPos);
                break;
            }
            case 54: {
                LongBitPacker.unpack54(initValue, in, inPos, out, outPos);
                break;
            }
            case 55: {
                LongBitPacker.unpack55(initValue, in, inPos, out, outPos);
                break;
            }
            case 56: {
                LongBitPacker.unpack56(initValue, in, inPos, out, outPos);
                break;
            }
            case 57: {
                LongBitPacker.unpack57(initValue, in, inPos, out, outPos);
                break;
            }
            case 58: {
                LongBitPacker.unpack58(initValue, in, inPos, out, outPos);
                break;
            }
            case 59: {
                LongBitPacker.unpack59(initValue, in, inPos, out, outPos);
                break;
            }
            case 60: {
                LongBitPacker.unpack60(initValue, in, inPos, out, outPos);
                break;
            }
            case 61: {
                LongBitPacker.unpack61(initValue, in, inPos, out, outPos);
                break;
            }
            case 62: {
                LongBitPacker.unpack62(initValue, in, inPos, out, outPos);
                break;
            }
            case 63: {
                LongBitPacker.unpack63(initValue, in, inPos, out, outPos);
                break;
            }
            case 64: {
                System.arraycopy(in, inPos, out, outPos, 64);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported bit width: " + bitCount);
            }
        }
    }

    private static void pack1(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 1 | in[inPos + 2] - in[inPos + 1] << 2 | in[inPos + 3] - in[inPos + 2] << 3 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 5 | in[inPos + 6] - in[inPos + 5] << 6 | in[inPos + 7] - in[inPos + 6] << 7 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 9 | in[inPos + 10] - in[inPos + 9] << 10 | in[inPos + 11] - in[inPos + 10] << 11 | in[inPos + 12] - in[inPos + 11] << 12 | in[inPos + 13] - in[inPos + 12] << 13 | in[inPos + 14] - in[inPos + 13] << 14 | in[inPos + 15] - in[inPos + 14] << 15 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 17 | in[inPos + 18] - in[inPos + 17] << 18 | in[inPos + 19] - in[inPos + 18] << 19 | in[inPos + 20] - in[inPos + 19] << 20 | in[inPos + 21] - in[inPos + 20] << 21 | in[inPos + 22] - in[inPos + 21] << 22 | in[inPos + 23] - in[inPos + 22] << 23 | in[inPos + 24] - in[inPos + 23] << 24 | in[inPos + 25] - in[inPos + 24] << 25 | in[inPos + 26] - in[inPos + 25] << 26 | in[inPos + 27] - in[inPos + 26] << 27 | in[inPos + 28] - in[inPos + 27] << 28 | in[inPos + 29] - in[inPos + 28] << 29 | in[inPos + 30] - in[inPos + 29] << 30 | in[inPos + 31] - in[inPos + 30] << 31 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 33 | in[inPos + 34] - in[inPos + 33] << 34 | in[inPos + 35] - in[inPos + 34] << 35 | in[inPos + 36] - in[inPos + 35] << 36 | in[inPos + 37] - in[inPos + 36] << 37 | in[inPos + 38] - in[inPos + 37] << 38 | in[inPos + 39] - in[inPos + 38] << 39 | in[inPos + 40] - in[inPos + 39] << 40 | in[inPos + 41] - in[inPos + 40] << 41 | in[inPos + 42] - in[inPos + 41] << 42 | in[inPos + 43] - in[inPos + 42] << 43 | in[inPos + 44] - in[inPos + 43] << 44 | in[inPos + 45] - in[inPos + 44] << 45 | in[inPos + 46] - in[inPos + 45] << 46 | in[inPos + 47] - in[inPos + 46] << 47 | in[inPos + 48] - in[inPos + 47] << 48 | in[inPos + 49] - in[inPos + 48] << 49 | in[inPos + 50] - in[inPos + 49] << 50 | in[inPos + 51] - in[inPos + 50] << 51 | in[inPos + 52] - in[inPos + 51] << 52 | in[inPos + 53] - in[inPos + 52] << 53 | in[inPos + 54] - in[inPos + 53] << 54 | in[inPos + 55] - in[inPos + 54] << 55 | in[inPos + 56] - in[inPos + 55] << 56 | in[inPos + 57] - in[inPos + 56] << 57 | in[inPos + 58] - in[inPos + 57] << 58 | in[inPos + 59] - in[inPos + 58] << 59 | in[inPos + 60] - in[inPos + 59] << 60 | in[inPos + 61] - in[inPos + 60] << 61 | in[inPos + 62] - in[inPos + 61] << 62 | in[inPos + 63] - in[inPos + 62] << 63;
    }

    private static void unpack1(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 1L) + initValue;
        out[outPos + 1] = (in[inPos] >>> 1 & 1L) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 2 & 1L) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 3 & 1L) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 4 & 1L) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 5 & 1L) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 6 & 1L) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 7 & 1L) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 8 & 1L) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 9 & 1L) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 10 & 1L) + out[outPos + 9];
        out[outPos + 11] = (in[inPos] >>> 11 & 1L) + out[outPos + 10];
        out[outPos + 12] = (in[inPos] >>> 12 & 1L) + out[outPos + 11];
        out[outPos + 13] = (in[inPos] >>> 13 & 1L) + out[outPos + 12];
        out[outPos + 14] = (in[inPos] >>> 14 & 1L) + out[outPos + 13];
        out[outPos + 15] = (in[inPos] >>> 15 & 1L) + out[outPos + 14];
        out[outPos + 16] = (in[inPos] >>> 16 & 1L) + out[outPos + 15];
        out[outPos + 17] = (in[inPos] >>> 17 & 1L) + out[outPos + 16];
        out[outPos + 18] = (in[inPos] >>> 18 & 1L) + out[outPos + 17];
        out[outPos + 19] = (in[inPos] >>> 19 & 1L) + out[outPos + 18];
        out[outPos + 20] = (in[inPos] >>> 20 & 1L) + out[outPos + 19];
        out[outPos + 21] = (in[inPos] >>> 21 & 1L) + out[outPos + 20];
        out[outPos + 22] = (in[inPos] >>> 22 & 1L) + out[outPos + 21];
        out[outPos + 23] = (in[inPos] >>> 23 & 1L) + out[outPos + 22];
        out[outPos + 24] = (in[inPos] >>> 24 & 1L) + out[outPos + 23];
        out[outPos + 25] = (in[inPos] >>> 25 & 1L) + out[outPos + 24];
        out[outPos + 26] = (in[inPos] >>> 26 & 1L) + out[outPos + 25];
        out[outPos + 27] = (in[inPos] >>> 27 & 1L) + out[outPos + 26];
        out[outPos + 28] = (in[inPos] >>> 28 & 1L) + out[outPos + 27];
        out[outPos + 29] = (in[inPos] >>> 29 & 1L) + out[outPos + 28];
        out[outPos + 30] = (in[inPos] >>> 30 & 1L) + out[outPos + 29];
        out[outPos + 31] = (in[inPos] >>> 31 & 1L) + out[outPos + 30];
        out[outPos + 32] = (in[inPos] >>> 32 & 1L) + out[outPos + 31];
        out[outPos + 33] = (in[inPos] >>> 33 & 1L) + out[outPos + 32];
        out[outPos + 34] = (in[inPos] >>> 34 & 1L) + out[outPos + 33];
        out[outPos + 35] = (in[inPos] >>> 35 & 1L) + out[outPos + 34];
        out[outPos + 36] = (in[inPos] >>> 36 & 1L) + out[outPos + 35];
        out[outPos + 37] = (in[inPos] >>> 37 & 1L) + out[outPos + 36];
        out[outPos + 38] = (in[inPos] >>> 38 & 1L) + out[outPos + 37];
        out[outPos + 39] = (in[inPos] >>> 39 & 1L) + out[outPos + 38];
        out[outPos + 40] = (in[inPos] >>> 40 & 1L) + out[outPos + 39];
        out[outPos + 41] = (in[inPos] >>> 41 & 1L) + out[outPos + 40];
        out[outPos + 42] = (in[inPos] >>> 42 & 1L) + out[outPos + 41];
        out[outPos + 43] = (in[inPos] >>> 43 & 1L) + out[outPos + 42];
        out[outPos + 44] = (in[inPos] >>> 44 & 1L) + out[outPos + 43];
        out[outPos + 45] = (in[inPos] >>> 45 & 1L) + out[outPos + 44];
        out[outPos + 46] = (in[inPos] >>> 46 & 1L) + out[outPos + 45];
        out[outPos + 47] = (in[inPos] >>> 47 & 1L) + out[outPos + 46];
        out[outPos + 48] = (in[inPos] >>> 48 & 1L) + out[outPos + 47];
        out[outPos + 49] = (in[inPos] >>> 49 & 1L) + out[outPos + 48];
        out[outPos + 50] = (in[inPos] >>> 50 & 1L) + out[outPos + 49];
        out[outPos + 51] = (in[inPos] >>> 51 & 1L) + out[outPos + 50];
        out[outPos + 52] = (in[inPos] >>> 52 & 1L) + out[outPos + 51];
        out[outPos + 53] = (in[inPos] >>> 53 & 1L) + out[outPos + 52];
        out[outPos + 54] = (in[inPos] >>> 54 & 1L) + out[outPos + 53];
        out[outPos + 55] = (in[inPos] >>> 55 & 1L) + out[outPos + 54];
        out[outPos + 56] = (in[inPos] >>> 56 & 1L) + out[outPos + 55];
        out[outPos + 57] = (in[inPos] >>> 57 & 1L) + out[outPos + 56];
        out[outPos + 58] = (in[inPos] >>> 58 & 1L) + out[outPos + 57];
        out[outPos + 59] = (in[inPos] >>> 59 & 1L) + out[outPos + 58];
        out[outPos + 60] = (in[inPos] >>> 60 & 1L) + out[outPos + 59];
        out[outPos + 61] = (in[inPos] >>> 61 & 1L) + out[outPos + 60];
        out[outPos + 62] = (in[inPos] >>> 62 & 1L) + out[outPos + 61];
        out[outPos + 63] = (in[inPos] >>> 63) + out[outPos + 62];
    }

    private static void pack2(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 2 | in[inPos + 2] - in[inPos + 1] << 4 | in[inPos + 3] - in[inPos + 2] << 6 | in[inPos + 4] - in[inPos + 3] << 8 | in[inPos + 5] - in[inPos + 4] << 10 | in[inPos + 6] - in[inPos + 5] << 12 | in[inPos + 7] - in[inPos + 6] << 14 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 18 | in[inPos + 10] - in[inPos + 9] << 20 | in[inPos + 11] - in[inPos + 10] << 22 | in[inPos + 12] - in[inPos + 11] << 24 | in[inPos + 13] - in[inPos + 12] << 26 | in[inPos + 14] - in[inPos + 13] << 28 | in[inPos + 15] - in[inPos + 14] << 30 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 34 | in[inPos + 18] - in[inPos + 17] << 36 | in[inPos + 19] - in[inPos + 18] << 38 | in[inPos + 20] - in[inPos + 19] << 40 | in[inPos + 21] - in[inPos + 20] << 42 | in[inPos + 22] - in[inPos + 21] << 44 | in[inPos + 23] - in[inPos + 22] << 46 | in[inPos + 24] - in[inPos + 23] << 48 | in[inPos + 25] - in[inPos + 24] << 50 | in[inPos + 26] - in[inPos + 25] << 52 | in[inPos + 27] - in[inPos + 26] << 54 | in[inPos + 28] - in[inPos + 27] << 56 | in[inPos + 29] - in[inPos + 28] << 58 | in[inPos + 30] - in[inPos + 29] << 60 | in[inPos + 31] - in[inPos + 30] << 62;
        out[outPos + 1] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 2 | in[inPos + 34] - in[inPos + 33] << 4 | in[inPos + 35] - in[inPos + 34] << 6 | in[inPos + 36] - in[inPos + 35] << 8 | in[inPos + 37] - in[inPos + 36] << 10 | in[inPos + 38] - in[inPos + 37] << 12 | in[inPos + 39] - in[inPos + 38] << 14 | in[inPos + 40] - in[inPos + 39] << 16 | in[inPos + 41] - in[inPos + 40] << 18 | in[inPos + 42] - in[inPos + 41] << 20 | in[inPos + 43] - in[inPos + 42] << 22 | in[inPos + 44] - in[inPos + 43] << 24 | in[inPos + 45] - in[inPos + 44] << 26 | in[inPos + 46] - in[inPos + 45] << 28 | in[inPos + 47] - in[inPos + 46] << 30 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 34 | in[inPos + 50] - in[inPos + 49] << 36 | in[inPos + 51] - in[inPos + 50] << 38 | in[inPos + 52] - in[inPos + 51] << 40 | in[inPos + 53] - in[inPos + 52] << 42 | in[inPos + 54] - in[inPos + 53] << 44 | in[inPos + 55] - in[inPos + 54] << 46 | in[inPos + 56] - in[inPos + 55] << 48 | in[inPos + 57] - in[inPos + 56] << 50 | in[inPos + 58] - in[inPos + 57] << 52 | in[inPos + 59] - in[inPos + 58] << 54 | in[inPos + 60] - in[inPos + 59] << 56 | in[inPos + 61] - in[inPos + 60] << 58 | in[inPos + 62] - in[inPos + 61] << 60 | in[inPos + 63] - in[inPos + 62] << 62;
    }

    private static void unpack2(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 3L) + initValue;
        out[outPos + 1] = (in[inPos] >>> 2 & 3L) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 4 & 3L) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 6 & 3L) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 8 & 3L) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 10 & 3L) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 12 & 3L) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 14 & 3L) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 16 & 3L) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 18 & 3L) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 20 & 3L) + out[outPos + 9];
        out[outPos + 11] = (in[inPos] >>> 22 & 3L) + out[outPos + 10];
        out[outPos + 12] = (in[inPos] >>> 24 & 3L) + out[outPos + 11];
        out[outPos + 13] = (in[inPos] >>> 26 & 3L) + out[outPos + 12];
        out[outPos + 14] = (in[inPos] >>> 28 & 3L) + out[outPos + 13];
        out[outPos + 15] = (in[inPos] >>> 30 & 3L) + out[outPos + 14];
        out[outPos + 16] = (in[inPos] >>> 32 & 3L) + out[outPos + 15];
        out[outPos + 17] = (in[inPos] >>> 34 & 3L) + out[outPos + 16];
        out[outPos + 18] = (in[inPos] >>> 36 & 3L) + out[outPos + 17];
        out[outPos + 19] = (in[inPos] >>> 38 & 3L) + out[outPos + 18];
        out[outPos + 20] = (in[inPos] >>> 40 & 3L) + out[outPos + 19];
        out[outPos + 21] = (in[inPos] >>> 42 & 3L) + out[outPos + 20];
        out[outPos + 22] = (in[inPos] >>> 44 & 3L) + out[outPos + 21];
        out[outPos + 23] = (in[inPos] >>> 46 & 3L) + out[outPos + 22];
        out[outPos + 24] = (in[inPos] >>> 48 & 3L) + out[outPos + 23];
        out[outPos + 25] = (in[inPos] >>> 50 & 3L) + out[outPos + 24];
        out[outPos + 26] = (in[inPos] >>> 52 & 3L) + out[outPos + 25];
        out[outPos + 27] = (in[inPos] >>> 54 & 3L) + out[outPos + 26];
        out[outPos + 28] = (in[inPos] >>> 56 & 3L) + out[outPos + 27];
        out[outPos + 29] = (in[inPos] >>> 58 & 3L) + out[outPos + 28];
        out[outPos + 30] = (in[inPos] >>> 60 & 3L) + out[outPos + 29];
        out[outPos + 31] = (in[inPos] >>> 62) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 1] & 3L) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 1] >>> 2 & 3L) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 1] >>> 4 & 3L) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 1] >>> 6 & 3L) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 1] >>> 8 & 3L) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 1] >>> 10 & 3L) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 1] >>> 12 & 3L) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 1] >>> 14 & 3L) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 1] >>> 16 & 3L) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 1] >>> 18 & 3L) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 1] >>> 20 & 3L) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 1] >>> 22 & 3L) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 1] >>> 24 & 3L) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 1] >>> 26 & 3L) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 1] >>> 28 & 3L) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 1] >>> 30 & 3L) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 1] >>> 32 & 3L) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 1] >>> 34 & 3L) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 1] >>> 36 & 3L) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 1] >>> 38 & 3L) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 1] >>> 40 & 3L) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 1] >>> 42 & 3L) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 1] >>> 44 & 3L) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 1] >>> 46 & 3L) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 1] >>> 48 & 3L) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 1] >>> 50 & 3L) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 1] >>> 52 & 3L) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 1] >>> 54 & 3L) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 1] >>> 56 & 3L) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 1] >>> 58 & 3L) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 1] >>> 60 & 3L) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 1] >>> 62) + out[outPos + 62];
    }

    private static void pack3(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 3 | in[inPos + 2] - in[inPos + 1] << 6 | in[inPos + 3] - in[inPos + 2] << 9 | in[inPos + 4] - in[inPos + 3] << 12 | in[inPos + 5] - in[inPos + 4] << 15 | in[inPos + 6] - in[inPos + 5] << 18 | in[inPos + 7] - in[inPos + 6] << 21 | in[inPos + 8] - in[inPos + 7] << 24 | in[inPos + 9] - in[inPos + 8] << 27 | in[inPos + 10] - in[inPos + 9] << 30 | in[inPos + 11] - in[inPos + 10] << 33 | in[inPos + 12] - in[inPos + 11] << 36 | in[inPos + 13] - in[inPos + 12] << 39 | in[inPos + 14] - in[inPos + 13] << 42 | in[inPos + 15] - in[inPos + 14] << 45 | in[inPos + 16] - in[inPos + 15] << 48 | in[inPos + 17] - in[inPos + 16] << 51 | in[inPos + 18] - in[inPos + 17] << 54 | in[inPos + 19] - in[inPos + 18] << 57 | in[inPos + 20] - in[inPos + 19] << 60 | in[inPos + 21] - in[inPos + 20] << 63;
        out[outPos + 1] = in[inPos + 21] - in[inPos + 20] >>> 1 | in[inPos + 22] - in[inPos + 21] << 2 | in[inPos + 23] - in[inPos + 22] << 5 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 11 | in[inPos + 26] - in[inPos + 25] << 14 | in[inPos + 27] - in[inPos + 26] << 17 | in[inPos + 28] - in[inPos + 27] << 20 | in[inPos + 29] - in[inPos + 28] << 23 | in[inPos + 30] - in[inPos + 29] << 26 | in[inPos + 31] - in[inPos + 30] << 29 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 35 | in[inPos + 34] - in[inPos + 33] << 38 | in[inPos + 35] - in[inPos + 34] << 41 | in[inPos + 36] - in[inPos + 35] << 44 | in[inPos + 37] - in[inPos + 36] << 47 | in[inPos + 38] - in[inPos + 37] << 50 | in[inPos + 39] - in[inPos + 38] << 53 | in[inPos + 40] - in[inPos + 39] << 56 | in[inPos + 41] - in[inPos + 40] << 59 | in[inPos + 42] - in[inPos + 41] << 62;
        out[outPos + 2] = in[inPos + 42] - in[inPos + 41] >>> 2 | in[inPos + 43] - in[inPos + 42] << 1 | in[inPos + 44] - in[inPos + 43] << 4 | in[inPos + 45] - in[inPos + 44] << 7 | in[inPos + 46] - in[inPos + 45] << 10 | in[inPos + 47] - in[inPos + 46] << 13 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 19 | in[inPos + 50] - in[inPos + 49] << 22 | in[inPos + 51] - in[inPos + 50] << 25 | in[inPos + 52] - in[inPos + 51] << 28 | in[inPos + 53] - in[inPos + 52] << 31 | in[inPos + 54] - in[inPos + 53] << 34 | in[inPos + 55] - in[inPos + 54] << 37 | in[inPos + 56] - in[inPos + 55] << 40 | in[inPos + 57] - in[inPos + 56] << 43 | in[inPos + 58] - in[inPos + 57] << 46 | in[inPos + 59] - in[inPos + 58] << 49 | in[inPos + 60] - in[inPos + 59] << 52 | in[inPos + 61] - in[inPos + 60] << 55 | in[inPos + 62] - in[inPos + 61] << 58 | in[inPos + 63] - in[inPos + 62] << 61;
    }

    private static void unpack3(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 7L) + initValue;
        out[outPos + 1] = (in[inPos] >>> 3 & 7L) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 6 & 7L) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 9 & 7L) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 12 & 7L) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 15 & 7L) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 18 & 7L) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 21 & 7L) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 24 & 7L) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 27 & 7L) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 30 & 7L) + out[outPos + 9];
        out[outPos + 11] = (in[inPos] >>> 33 & 7L) + out[outPos + 10];
        out[outPos + 12] = (in[inPos] >>> 36 & 7L) + out[outPos + 11];
        out[outPos + 13] = (in[inPos] >>> 39 & 7L) + out[outPos + 12];
        out[outPos + 14] = (in[inPos] >>> 42 & 7L) + out[outPos + 13];
        out[outPos + 15] = (in[inPos] >>> 45 & 7L) + out[outPos + 14];
        out[outPos + 16] = (in[inPos] >>> 48 & 7L) + out[outPos + 15];
        out[outPos + 17] = (in[inPos] >>> 51 & 7L) + out[outPos + 16];
        out[outPos + 18] = (in[inPos] >>> 54 & 7L) + out[outPos + 17];
        out[outPos + 19] = (in[inPos] >>> 57 & 7L) + out[outPos + 18];
        out[outPos + 20] = (in[inPos] >>> 60 & 7L) + out[outPos + 19];
        out[outPos + 21] = (in[inPos] >>> 63 | (in[inPos + 1] & 3L) << 1) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 1] >>> 2 & 7L) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 1] >>> 5 & 7L) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 1] >>> 8 & 7L) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 1] >>> 11 & 7L) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 1] >>> 14 & 7L) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 1] >>> 17 & 7L) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 1] >>> 20 & 7L) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 1] >>> 23 & 7L) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 1] >>> 26 & 7L) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 1] >>> 29 & 7L) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 1] >>> 32 & 7L) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 1] >>> 35 & 7L) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 1] >>> 38 & 7L) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 1] >>> 41 & 7L) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 1] >>> 44 & 7L) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 1] >>> 47 & 7L) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 1] >>> 50 & 7L) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 1] >>> 53 & 7L) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 1] >>> 56 & 7L) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 1] >>> 59 & 7L) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 1L) << 2) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 2] >>> 1 & 7L) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 2] >>> 4 & 7L) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 2] >>> 7 & 7L) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 2] >>> 10 & 7L) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 2] >>> 13 & 7L) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 2] >>> 16 & 7L) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 2] >>> 19 & 7L) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 2] >>> 22 & 7L) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 2] >>> 25 & 7L) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 2] >>> 28 & 7L) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 2] >>> 31 & 7L) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 2] >>> 34 & 7L) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 2] >>> 37 & 7L) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 2] >>> 40 & 7L) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 2] >>> 43 & 7L) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 2] >>> 46 & 7L) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 2] >>> 49 & 7L) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 2] >>> 52 & 7L) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 2] >>> 55 & 7L) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 2] >>> 58 & 7L) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 2] >>> 61) + out[outPos + 62];
    }

    private static void pack4(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 4 | in[inPos + 2] - in[inPos + 1] << 8 | in[inPos + 3] - in[inPos + 2] << 12 | in[inPos + 4] - in[inPos + 3] << 16 | in[inPos + 5] - in[inPos + 4] << 20 | in[inPos + 6] - in[inPos + 5] << 24 | in[inPos + 7] - in[inPos + 6] << 28 | in[inPos + 8] - in[inPos + 7] << 32 | in[inPos + 9] - in[inPos + 8] << 36 | in[inPos + 10] - in[inPos + 9] << 40 | in[inPos + 11] - in[inPos + 10] << 44 | in[inPos + 12] - in[inPos + 11] << 48 | in[inPos + 13] - in[inPos + 12] << 52 | in[inPos + 14] - in[inPos + 13] << 56 | in[inPos + 15] - in[inPos + 14] << 60;
        out[outPos + 1] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 4 | in[inPos + 18] - in[inPos + 17] << 8 | in[inPos + 19] - in[inPos + 18] << 12 | in[inPos + 20] - in[inPos + 19] << 16 | in[inPos + 21] - in[inPos + 20] << 20 | in[inPos + 22] - in[inPos + 21] << 24 | in[inPos + 23] - in[inPos + 22] << 28 | in[inPos + 24] - in[inPos + 23] << 32 | in[inPos + 25] - in[inPos + 24] << 36 | in[inPos + 26] - in[inPos + 25] << 40 | in[inPos + 27] - in[inPos + 26] << 44 | in[inPos + 28] - in[inPos + 27] << 48 | in[inPos + 29] - in[inPos + 28] << 52 | in[inPos + 30] - in[inPos + 29] << 56 | in[inPos + 31] - in[inPos + 30] << 60;
        out[outPos + 2] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 4 | in[inPos + 34] - in[inPos + 33] << 8 | in[inPos + 35] - in[inPos + 34] << 12 | in[inPos + 36] - in[inPos + 35] << 16 | in[inPos + 37] - in[inPos + 36] << 20 | in[inPos + 38] - in[inPos + 37] << 24 | in[inPos + 39] - in[inPos + 38] << 28 | in[inPos + 40] - in[inPos + 39] << 32 | in[inPos + 41] - in[inPos + 40] << 36 | in[inPos + 42] - in[inPos + 41] << 40 | in[inPos + 43] - in[inPos + 42] << 44 | in[inPos + 44] - in[inPos + 43] << 48 | in[inPos + 45] - in[inPos + 44] << 52 | in[inPos + 46] - in[inPos + 45] << 56 | in[inPos + 47] - in[inPos + 46] << 60;
        out[outPos + 3] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 4 | in[inPos + 50] - in[inPos + 49] << 8 | in[inPos + 51] - in[inPos + 50] << 12 | in[inPos + 52] - in[inPos + 51] << 16 | in[inPos + 53] - in[inPos + 52] << 20 | in[inPos + 54] - in[inPos + 53] << 24 | in[inPos + 55] - in[inPos + 54] << 28 | in[inPos + 56] - in[inPos + 55] << 32 | in[inPos + 57] - in[inPos + 56] << 36 | in[inPos + 58] - in[inPos + 57] << 40 | in[inPos + 59] - in[inPos + 58] << 44 | in[inPos + 60] - in[inPos + 59] << 48 | in[inPos + 61] - in[inPos + 60] << 52 | in[inPos + 62] - in[inPos + 61] << 56 | in[inPos + 63] - in[inPos + 62] << 60;
    }

    private static void unpack4(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 4 & 0xFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 8 & 0xFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 12 & 0xFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 16 & 0xFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 20 & 0xFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 24 & 0xFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 28 & 0xFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 32 & 0xFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 36 & 0xFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 40 & 0xFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos] >>> 44 & 0xFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos] >>> 48 & 0xFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos] >>> 52 & 0xFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos] >>> 56 & 0xFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos] >>> 60) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 1] & 0xFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 1] >>> 4 & 0xFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 1] >>> 8 & 0xFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 1] >>> 12 & 0xFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 1] >>> 16 & 0xFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 1] >>> 20 & 0xFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 1] >>> 24 & 0xFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 1] >>> 28 & 0xFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 1] >>> 32 & 0xFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 1] >>> 36 & 0xFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 1] >>> 40 & 0xFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 1] >>> 44 & 0xFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 1] >>> 48 & 0xFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 1] >>> 52 & 0xFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 1] >>> 56 & 0xFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 1] >>> 60) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 2] & 0xFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 2] >>> 4 & 0xFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 2] >>> 8 & 0xFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 2] >>> 12 & 0xFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 2] >>> 16 & 0xFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 2] >>> 20 & 0xFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 2] >>> 24 & 0xFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 2] >>> 28 & 0xFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 2] >>> 32 & 0xFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 2] >>> 36 & 0xFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 2] >>> 40 & 0xFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 2] >>> 44 & 0xFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 2] >>> 48 & 0xFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 2] >>> 52 & 0xFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 2] >>> 56 & 0xFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 2] >>> 60) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 3] & 0xFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 3] >>> 4 & 0xFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 3] >>> 8 & 0xFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 3] >>> 12 & 0xFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 3] >>> 16 & 0xFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 3] >>> 20 & 0xFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 3] >>> 24 & 0xFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 3] >>> 28 & 0xFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 3] >>> 32 & 0xFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 3] >>> 36 & 0xFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 3] >>> 40 & 0xFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 3] >>> 44 & 0xFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 3] >>> 48 & 0xFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 3] >>> 52 & 0xFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 3] >>> 56 & 0xFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 3] >>> 60) + out[outPos + 62];
    }

    private static void pack5(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 5 | in[inPos + 2] - in[inPos + 1] << 10 | in[inPos + 3] - in[inPos + 2] << 15 | in[inPos + 4] - in[inPos + 3] << 20 | in[inPos + 5] - in[inPos + 4] << 25 | in[inPos + 6] - in[inPos + 5] << 30 | in[inPos + 7] - in[inPos + 6] << 35 | in[inPos + 8] - in[inPos + 7] << 40 | in[inPos + 9] - in[inPos + 8] << 45 | in[inPos + 10] - in[inPos + 9] << 50 | in[inPos + 11] - in[inPos + 10] << 55 | in[inPos + 12] - in[inPos + 11] << 60;
        out[outPos + 1] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 1 | in[inPos + 14] - in[inPos + 13] << 6 | in[inPos + 15] - in[inPos + 14] << 11 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 21 | in[inPos + 18] - in[inPos + 17] << 26 | in[inPos + 19] - in[inPos + 18] << 31 | in[inPos + 20] - in[inPos + 19] << 36 | in[inPos + 21] - in[inPos + 20] << 41 | in[inPos + 22] - in[inPos + 21] << 46 | in[inPos + 23] - in[inPos + 22] << 51 | in[inPos + 24] - in[inPos + 23] << 56 | in[inPos + 25] - in[inPos + 24] << 61;
        out[outPos + 2] = in[inPos + 25] - in[inPos + 24] >>> 3 | in[inPos + 26] - in[inPos + 25] << 2 | in[inPos + 27] - in[inPos + 26] << 7 | in[inPos + 28] - in[inPos + 27] << 12 | in[inPos + 29] - in[inPos + 28] << 17 | in[inPos + 30] - in[inPos + 29] << 22 | in[inPos + 31] - in[inPos + 30] << 27 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 37 | in[inPos + 34] - in[inPos + 33] << 42 | in[inPos + 35] - in[inPos + 34] << 47 | in[inPos + 36] - in[inPos + 35] << 52 | in[inPos + 37] - in[inPos + 36] << 57 | in[inPos + 38] - in[inPos + 37] << 62;
        out[outPos + 3] = in[inPos + 38] - in[inPos + 37] >>> 2 | in[inPos + 39] - in[inPos + 38] << 3 | in[inPos + 40] - in[inPos + 39] << 8 | in[inPos + 41] - in[inPos + 40] << 13 | in[inPos + 42] - in[inPos + 41] << 18 | in[inPos + 43] - in[inPos + 42] << 23 | in[inPos + 44] - in[inPos + 43] << 28 | in[inPos + 45] - in[inPos + 44] << 33 | in[inPos + 46] - in[inPos + 45] << 38 | in[inPos + 47] - in[inPos + 46] << 43 | in[inPos + 48] - in[inPos + 47] << 48 | in[inPos + 49] - in[inPos + 48] << 53 | in[inPos + 50] - in[inPos + 49] << 58 | in[inPos + 51] - in[inPos + 50] << 63;
        out[outPos + 4] = in[inPos + 51] - in[inPos + 50] >>> 1 | in[inPos + 52] - in[inPos + 51] << 4 | in[inPos + 53] - in[inPos + 52] << 9 | in[inPos + 54] - in[inPos + 53] << 14 | in[inPos + 55] - in[inPos + 54] << 19 | in[inPos + 56] - in[inPos + 55] << 24 | in[inPos + 57] - in[inPos + 56] << 29 | in[inPos + 58] - in[inPos + 57] << 34 | in[inPos + 59] - in[inPos + 58] << 39 | in[inPos + 60] - in[inPos + 59] << 44 | in[inPos + 61] - in[inPos + 60] << 49 | in[inPos + 62] - in[inPos + 61] << 54 | in[inPos + 63] - in[inPos + 62] << 59;
    }

    private static void unpack5(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 5 & 0x1FL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 10 & 0x1FL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 15 & 0x1FL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 20 & 0x1FL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 25 & 0x1FL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 30 & 0x1FL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 35 & 0x1FL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 40 & 0x1FL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 45 & 0x1FL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 50 & 0x1FL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos] >>> 55 & 0x1FL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos] >>> 60 | (in[inPos + 1] & 1L) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 1] >>> 1 & 0x1FL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 1] >>> 6 & 0x1FL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 1] >>> 11 & 0x1FL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 1] >>> 16 & 0x1FL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 1] >>> 21 & 0x1FL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 1] >>> 26 & 0x1FL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 1] >>> 31 & 0x1FL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 1] >>> 36 & 0x1FL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 1] >>> 41 & 0x1FL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 1] >>> 46 & 0x1FL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 1] >>> 51 & 0x1FL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 1] >>> 56 & 0x1FL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 1] >>> 61 | (in[inPos + 2] & 3L) << 3) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 2] >>> 2 & 0x1FL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 2] >>> 7 & 0x1FL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 2] >>> 12 & 0x1FL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 2] >>> 17 & 0x1FL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 2] >>> 22 & 0x1FL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 2] >>> 27 & 0x1FL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 2] >>> 32 & 0x1FL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 2] >>> 37 & 0x1FL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 2] >>> 42 & 0x1FL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 2] >>> 47 & 0x1FL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 2] >>> 52 & 0x1FL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 2] >>> 57 & 0x1FL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 2] >>> 62 | (in[inPos + 3] & 7L) << 2) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 3] >>> 3 & 0x1FL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 3] >>> 8 & 0x1FL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 3] >>> 13 & 0x1FL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 3] >>> 18 & 0x1FL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 3] >>> 23 & 0x1FL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 3] >>> 28 & 0x1FL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 3] >>> 33 & 0x1FL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 3] >>> 38 & 0x1FL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 3] >>> 43 & 0x1FL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 3] >>> 48 & 0x1FL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 3] >>> 53 & 0x1FL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 3] >>> 58 & 0x1FL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 3] >>> 63 | (in[inPos + 4] & 0xFL) << 1) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 4] >>> 4 & 0x1FL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 4] >>> 9 & 0x1FL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 4] >>> 14 & 0x1FL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 4] >>> 19 & 0x1FL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 4] >>> 24 & 0x1FL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 4] >>> 29 & 0x1FL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 4] >>> 34 & 0x1FL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 4] >>> 39 & 0x1FL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 4] >>> 44 & 0x1FL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 4] >>> 49 & 0x1FL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 4] >>> 54 & 0x1FL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 4] >>> 59) + out[outPos + 62];
    }

    private static void pack6(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 6 | in[inPos + 2] - in[inPos + 1] << 12 | in[inPos + 3] - in[inPos + 2] << 18 | in[inPos + 4] - in[inPos + 3] << 24 | in[inPos + 5] - in[inPos + 4] << 30 | in[inPos + 6] - in[inPos + 5] << 36 | in[inPos + 7] - in[inPos + 6] << 42 | in[inPos + 8] - in[inPos + 7] << 48 | in[inPos + 9] - in[inPos + 8] << 54 | in[inPos + 10] - in[inPos + 9] << 60;
        out[outPos + 1] = in[inPos + 10] - in[inPos + 9] >>> 4 | in[inPos + 11] - in[inPos + 10] << 2 | in[inPos + 12] - in[inPos + 11] << 8 | in[inPos + 13] - in[inPos + 12] << 14 | in[inPos + 14] - in[inPos + 13] << 20 | in[inPos + 15] - in[inPos + 14] << 26 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 38 | in[inPos + 18] - in[inPos + 17] << 44 | in[inPos + 19] - in[inPos + 18] << 50 | in[inPos + 20] - in[inPos + 19] << 56 | in[inPos + 21] - in[inPos + 20] << 62;
        out[outPos + 2] = in[inPos + 21] - in[inPos + 20] >>> 2 | in[inPos + 22] - in[inPos + 21] << 4 | in[inPos + 23] - in[inPos + 22] << 10 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 22 | in[inPos + 26] - in[inPos + 25] << 28 | in[inPos + 27] - in[inPos + 26] << 34 | in[inPos + 28] - in[inPos + 27] << 40 | in[inPos + 29] - in[inPos + 28] << 46 | in[inPos + 30] - in[inPos + 29] << 52 | in[inPos + 31] - in[inPos + 30] << 58;
        out[outPos + 3] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 6 | in[inPos + 34] - in[inPos + 33] << 12 | in[inPos + 35] - in[inPos + 34] << 18 | in[inPos + 36] - in[inPos + 35] << 24 | in[inPos + 37] - in[inPos + 36] << 30 | in[inPos + 38] - in[inPos + 37] << 36 | in[inPos + 39] - in[inPos + 38] << 42 | in[inPos + 40] - in[inPos + 39] << 48 | in[inPos + 41] - in[inPos + 40] << 54 | in[inPos + 42] - in[inPos + 41] << 60;
        out[outPos + 4] = in[inPos + 42] - in[inPos + 41] >>> 4 | in[inPos + 43] - in[inPos + 42] << 2 | in[inPos + 44] - in[inPos + 43] << 8 | in[inPos + 45] - in[inPos + 44] << 14 | in[inPos + 46] - in[inPos + 45] << 20 | in[inPos + 47] - in[inPos + 46] << 26 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 38 | in[inPos + 50] - in[inPos + 49] << 44 | in[inPos + 51] - in[inPos + 50] << 50 | in[inPos + 52] - in[inPos + 51] << 56 | in[inPos + 53] - in[inPos + 52] << 62;
        out[outPos + 5] = in[inPos + 53] - in[inPos + 52] >>> 2 | in[inPos + 54] - in[inPos + 53] << 4 | in[inPos + 55] - in[inPos + 54] << 10 | in[inPos + 56] - in[inPos + 55] << 16 | in[inPos + 57] - in[inPos + 56] << 22 | in[inPos + 58] - in[inPos + 57] << 28 | in[inPos + 59] - in[inPos + 58] << 34 | in[inPos + 60] - in[inPos + 59] << 40 | in[inPos + 61] - in[inPos + 60] << 46 | in[inPos + 62] - in[inPos + 61] << 52 | in[inPos + 63] - in[inPos + 62] << 58;
    }

    private static void unpack6(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 6 & 0x3FL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 12 & 0x3FL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 18 & 0x3FL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 24 & 0x3FL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 30 & 0x3FL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 36 & 0x3FL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 42 & 0x3FL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 48 & 0x3FL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 54 & 0x3FL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos] >>> 60 | (in[inPos + 1] & 3L) << 4) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 2 & 0x3FL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 8 & 0x3FL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 1] >>> 14 & 0x3FL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 1] >>> 20 & 0x3FL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 1] >>> 26 & 0x3FL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 1] >>> 32 & 0x3FL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 1] >>> 38 & 0x3FL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 1] >>> 44 & 0x3FL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 1] >>> 50 & 0x3FL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 1] >>> 56 & 0x3FL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0xFL) << 2) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 2] >>> 4 & 0x3FL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 2] >>> 10 & 0x3FL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 2] >>> 16 & 0x3FL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 2] >>> 22 & 0x3FL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 2] >>> 28 & 0x3FL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 2] >>> 34 & 0x3FL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 2] >>> 40 & 0x3FL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 2] >>> 46 & 0x3FL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 2] >>> 52 & 0x3FL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 2] >>> 58) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 3] & 0x3FL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 3] >>> 6 & 0x3FL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 3] >>> 12 & 0x3FL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 3] >>> 18 & 0x3FL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 3] >>> 24 & 0x3FL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 3] >>> 30 & 0x3FL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 3] >>> 36 & 0x3FL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 3] >>> 42 & 0x3FL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 3] >>> 48 & 0x3FL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 3] >>> 54 & 0x3FL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 3L) << 4) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 4] >>> 2 & 0x3FL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 4] >>> 8 & 0x3FL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 4] >>> 14 & 0x3FL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 4] >>> 20 & 0x3FL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 4] >>> 26 & 0x3FL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 4] >>> 32 & 0x3FL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 4] >>> 38 & 0x3FL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 4] >>> 44 & 0x3FL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 4] >>> 50 & 0x3FL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 4] >>> 56 & 0x3FL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 4] >>> 62 | (in[inPos + 5] & 0xFL) << 2) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 5] >>> 4 & 0x3FL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 5] >>> 10 & 0x3FL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 5] >>> 16 & 0x3FL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 5] >>> 22 & 0x3FL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 5] >>> 28 & 0x3FL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 5] >>> 34 & 0x3FL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 5] >>> 40 & 0x3FL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 5] >>> 46 & 0x3FL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 5] >>> 52 & 0x3FL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 5] >>> 58) + out[outPos + 62];
    }

    private static void pack7(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 7 | in[inPos + 2] - in[inPos + 1] << 14 | in[inPos + 3] - in[inPos + 2] << 21 | in[inPos + 4] - in[inPos + 3] << 28 | in[inPos + 5] - in[inPos + 4] << 35 | in[inPos + 6] - in[inPos + 5] << 42 | in[inPos + 7] - in[inPos + 6] << 49 | in[inPos + 8] - in[inPos + 7] << 56 | in[inPos + 9] - in[inPos + 8] << 63;
        out[outPos + 1] = in[inPos + 9] - in[inPos + 8] >>> 1 | in[inPos + 10] - in[inPos + 9] << 6 | in[inPos + 11] - in[inPos + 10] << 13 | in[inPos + 12] - in[inPos + 11] << 20 | in[inPos + 13] - in[inPos + 12] << 27 | in[inPos + 14] - in[inPos + 13] << 34 | in[inPos + 15] - in[inPos + 14] << 41 | in[inPos + 16] - in[inPos + 15] << 48 | in[inPos + 17] - in[inPos + 16] << 55 | in[inPos + 18] - in[inPos + 17] << 62;
        out[outPos + 2] = in[inPos + 18] - in[inPos + 17] >>> 2 | in[inPos + 19] - in[inPos + 18] << 5 | in[inPos + 20] - in[inPos + 19] << 12 | in[inPos + 21] - in[inPos + 20] << 19 | in[inPos + 22] - in[inPos + 21] << 26 | in[inPos + 23] - in[inPos + 22] << 33 | in[inPos + 24] - in[inPos + 23] << 40 | in[inPos + 25] - in[inPos + 24] << 47 | in[inPos + 26] - in[inPos + 25] << 54 | in[inPos + 27] - in[inPos + 26] << 61;
        out[outPos + 3] = in[inPos + 27] - in[inPos + 26] >>> 3 | in[inPos + 28] - in[inPos + 27] << 4 | in[inPos + 29] - in[inPos + 28] << 11 | in[inPos + 30] - in[inPos + 29] << 18 | in[inPos + 31] - in[inPos + 30] << 25 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 39 | in[inPos + 34] - in[inPos + 33] << 46 | in[inPos + 35] - in[inPos + 34] << 53 | in[inPos + 36] - in[inPos + 35] << 60;
        out[outPos + 4] = in[inPos + 36] - in[inPos + 35] >>> 4 | in[inPos + 37] - in[inPos + 36] << 3 | in[inPos + 38] - in[inPos + 37] << 10 | in[inPos + 39] - in[inPos + 38] << 17 | in[inPos + 40] - in[inPos + 39] << 24 | in[inPos + 41] - in[inPos + 40] << 31 | in[inPos + 42] - in[inPos + 41] << 38 | in[inPos + 43] - in[inPos + 42] << 45 | in[inPos + 44] - in[inPos + 43] << 52 | in[inPos + 45] - in[inPos + 44] << 59;
        out[outPos + 5] = in[inPos + 45] - in[inPos + 44] >>> 5 | in[inPos + 46] - in[inPos + 45] << 2 | in[inPos + 47] - in[inPos + 46] << 9 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 23 | in[inPos + 50] - in[inPos + 49] << 30 | in[inPos + 51] - in[inPos + 50] << 37 | in[inPos + 52] - in[inPos + 51] << 44 | in[inPos + 53] - in[inPos + 52] << 51 | in[inPos + 54] - in[inPos + 53] << 58;
        out[outPos + 6] = in[inPos + 54] - in[inPos + 53] >>> 6 | in[inPos + 55] - in[inPos + 54] << 1 | in[inPos + 56] - in[inPos + 55] << 8 | in[inPos + 57] - in[inPos + 56] << 15 | in[inPos + 58] - in[inPos + 57] << 22 | in[inPos + 59] - in[inPos + 58] << 29 | in[inPos + 60] - in[inPos + 59] << 36 | in[inPos + 61] - in[inPos + 60] << 43 | in[inPos + 62] - in[inPos + 61] << 50 | in[inPos + 63] - in[inPos + 62] << 57;
    }

    private static void unpack7(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 7 & 0x7FL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 14 & 0x7FL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 21 & 0x7FL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 28 & 0x7FL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 35 & 0x7FL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 42 & 0x7FL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 49 & 0x7FL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos] >>> 56 & 0x7FL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos] >>> 63 | (in[inPos + 1] & 0x3FL) << 1) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 6 & 0x7FL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 13 & 0x7FL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 20 & 0x7FL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 1] >>> 27 & 0x7FL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 1] >>> 34 & 0x7FL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 1] >>> 41 & 0x7FL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 1] >>> 48 & 0x7FL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 1] >>> 55 & 0x7FL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0x1FL) << 2) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 2] >>> 5 & 0x7FL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 2] >>> 12 & 0x7FL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 2] >>> 19 & 0x7FL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 2] >>> 26 & 0x7FL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 2] >>> 33 & 0x7FL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 2] >>> 40 & 0x7FL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 2] >>> 47 & 0x7FL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 2] >>> 54 & 0x7FL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 2] >>> 61 | (in[inPos + 3] & 0xFL) << 3) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 3] >>> 4 & 0x7FL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 3] >>> 11 & 0x7FL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 3] >>> 18 & 0x7FL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 3] >>> 25 & 0x7FL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 3] >>> 32 & 0x7FL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 3] >>> 39 & 0x7FL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 3] >>> 46 & 0x7FL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 3] >>> 53 & 0x7FL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 7L) << 4) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 4] >>> 3 & 0x7FL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 4] >>> 10 & 0x7FL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 4] >>> 17 & 0x7FL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 4] >>> 24 & 0x7FL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 4] >>> 31 & 0x7FL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 4] >>> 38 & 0x7FL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 4] >>> 45 & 0x7FL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 4] >>> 52 & 0x7FL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 4] >>> 59 | (in[inPos + 5] & 3L) << 5) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 5] >>> 2 & 0x7FL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 5] >>> 9 & 0x7FL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 5] >>> 16 & 0x7FL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 5] >>> 23 & 0x7FL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 5] >>> 30 & 0x7FL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 5] >>> 37 & 0x7FL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 5] >>> 44 & 0x7FL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 5] >>> 51 & 0x7FL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 1L) << 6) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 6] >>> 1 & 0x7FL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 6] >>> 8 & 0x7FL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 6] >>> 15 & 0x7FL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 6] >>> 22 & 0x7FL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 6] >>> 29 & 0x7FL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 6] >>> 36 & 0x7FL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 6] >>> 43 & 0x7FL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 6] >>> 50 & 0x7FL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 6] >>> 57) + out[outPos + 62];
    }

    private static void pack8(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 8 | in[inPos + 2] - in[inPos + 1] << 16 | in[inPos + 3] - in[inPos + 2] << 24 | in[inPos + 4] - in[inPos + 3] << 32 | in[inPos + 5] - in[inPos + 4] << 40 | in[inPos + 6] - in[inPos + 5] << 48 | in[inPos + 7] - in[inPos + 6] << 56;
        out[outPos + 1] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 8 | in[inPos + 10] - in[inPos + 9] << 16 | in[inPos + 11] - in[inPos + 10] << 24 | in[inPos + 12] - in[inPos + 11] << 32 | in[inPos + 13] - in[inPos + 12] << 40 | in[inPos + 14] - in[inPos + 13] << 48 | in[inPos + 15] - in[inPos + 14] << 56;
        out[outPos + 2] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 8 | in[inPos + 18] - in[inPos + 17] << 16 | in[inPos + 19] - in[inPos + 18] << 24 | in[inPos + 20] - in[inPos + 19] << 32 | in[inPos + 21] - in[inPos + 20] << 40 | in[inPos + 22] - in[inPos + 21] << 48 | in[inPos + 23] - in[inPos + 22] << 56;
        out[outPos + 3] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 8 | in[inPos + 26] - in[inPos + 25] << 16 | in[inPos + 27] - in[inPos + 26] << 24 | in[inPos + 28] - in[inPos + 27] << 32 | in[inPos + 29] - in[inPos + 28] << 40 | in[inPos + 30] - in[inPos + 29] << 48 | in[inPos + 31] - in[inPos + 30] << 56;
        out[outPos + 4] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 8 | in[inPos + 34] - in[inPos + 33] << 16 | in[inPos + 35] - in[inPos + 34] << 24 | in[inPos + 36] - in[inPos + 35] << 32 | in[inPos + 37] - in[inPos + 36] << 40 | in[inPos + 38] - in[inPos + 37] << 48 | in[inPos + 39] - in[inPos + 38] << 56;
        out[outPos + 5] = in[inPos + 40] - in[inPos + 39] | in[inPos + 41] - in[inPos + 40] << 8 | in[inPos + 42] - in[inPos + 41] << 16 | in[inPos + 43] - in[inPos + 42] << 24 | in[inPos + 44] - in[inPos + 43] << 32 | in[inPos + 45] - in[inPos + 44] << 40 | in[inPos + 46] - in[inPos + 45] << 48 | in[inPos + 47] - in[inPos + 46] << 56;
        out[outPos + 6] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 8 | in[inPos + 50] - in[inPos + 49] << 16 | in[inPos + 51] - in[inPos + 50] << 24 | in[inPos + 52] - in[inPos + 51] << 32 | in[inPos + 53] - in[inPos + 52] << 40 | in[inPos + 54] - in[inPos + 53] << 48 | in[inPos + 55] - in[inPos + 54] << 56;
        out[outPos + 7] = in[inPos + 56] - in[inPos + 55] | in[inPos + 57] - in[inPos + 56] << 8 | in[inPos + 58] - in[inPos + 57] << 16 | in[inPos + 59] - in[inPos + 58] << 24 | in[inPos + 60] - in[inPos + 59] << 32 | in[inPos + 61] - in[inPos + 60] << 40 | in[inPos + 62] - in[inPos + 61] << 48 | in[inPos + 63] - in[inPos + 62] << 56;
    }

    private static void unpack8(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 8 & 0xFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 16 & 0xFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 24 & 0xFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 32 & 0xFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 40 & 0xFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 48 & 0xFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 56) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] & 0xFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 8 & 0xFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 16 & 0xFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 24 & 0xFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 32 & 0xFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 1] >>> 40 & 0xFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 1] >>> 48 & 0xFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 1] >>> 56) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 2] & 0xFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 2] >>> 8 & 0xFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 2] >>> 16 & 0xFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 2] >>> 24 & 0xFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 2] >>> 32 & 0xFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 2] >>> 40 & 0xFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 2] >>> 48 & 0xFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 2] >>> 56) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 3] & 0xFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 3] >>> 8 & 0xFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 3] >>> 16 & 0xFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 3] >>> 24 & 0xFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 3] >>> 32 & 0xFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 3] >>> 40 & 0xFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 3] >>> 48 & 0xFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 3] >>> 56) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 4] & 0xFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 4] >>> 8 & 0xFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 4] >>> 16 & 0xFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 4] >>> 24 & 0xFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 4] >>> 32 & 0xFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 4] >>> 40 & 0xFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 4] >>> 48 & 0xFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 4] >>> 56) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 5] & 0xFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 5] >>> 8 & 0xFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 5] >>> 16 & 0xFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 5] >>> 24 & 0xFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 5] >>> 32 & 0xFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 5] >>> 40 & 0xFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 5] >>> 48 & 0xFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 5] >>> 56) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 6] & 0xFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 6] >>> 8 & 0xFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 6] >>> 16 & 0xFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 6] >>> 24 & 0xFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 6] >>> 32 & 0xFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 6] >>> 40 & 0xFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 6] >>> 48 & 0xFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 6] >>> 56) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 7] & 0xFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 7] >>> 8 & 0xFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 7] >>> 16 & 0xFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 7] >>> 24 & 0xFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 7] >>> 32 & 0xFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 7] >>> 40 & 0xFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 7] >>> 48 & 0xFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 7] >>> 56) + out[outPos + 62];
    }

    private static void pack9(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 9 | in[inPos + 2] - in[inPos + 1] << 18 | in[inPos + 3] - in[inPos + 2] << 27 | in[inPos + 4] - in[inPos + 3] << 36 | in[inPos + 5] - in[inPos + 4] << 45 | in[inPos + 6] - in[inPos + 5] << 54 | in[inPos + 7] - in[inPos + 6] << 63;
        out[outPos + 1] = in[inPos + 7] - in[inPos + 6] >>> 1 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 17 | in[inPos + 10] - in[inPos + 9] << 26 | in[inPos + 11] - in[inPos + 10] << 35 | in[inPos + 12] - in[inPos + 11] << 44 | in[inPos + 13] - in[inPos + 12] << 53 | in[inPos + 14] - in[inPos + 13] << 62;
        out[outPos + 2] = in[inPos + 14] - in[inPos + 13] >>> 2 | in[inPos + 15] - in[inPos + 14] << 7 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 25 | in[inPos + 18] - in[inPos + 17] << 34 | in[inPos + 19] - in[inPos + 18] << 43 | in[inPos + 20] - in[inPos + 19] << 52 | in[inPos + 21] - in[inPos + 20] << 61;
        out[outPos + 3] = in[inPos + 21] - in[inPos + 20] >>> 3 | in[inPos + 22] - in[inPos + 21] << 6 | in[inPos + 23] - in[inPos + 22] << 15 | in[inPos + 24] - in[inPos + 23] << 24 | in[inPos + 25] - in[inPos + 24] << 33 | in[inPos + 26] - in[inPos + 25] << 42 | in[inPos + 27] - in[inPos + 26] << 51 | in[inPos + 28] - in[inPos + 27] << 60;
        out[outPos + 4] = in[inPos + 28] - in[inPos + 27] >>> 4 | in[inPos + 29] - in[inPos + 28] << 5 | in[inPos + 30] - in[inPos + 29] << 14 | in[inPos + 31] - in[inPos + 30] << 23 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 41 | in[inPos + 34] - in[inPos + 33] << 50 | in[inPos + 35] - in[inPos + 34] << 59;
        out[outPos + 5] = in[inPos + 35] - in[inPos + 34] >>> 5 | in[inPos + 36] - in[inPos + 35] << 4 | in[inPos + 37] - in[inPos + 36] << 13 | in[inPos + 38] - in[inPos + 37] << 22 | in[inPos + 39] - in[inPos + 38] << 31 | in[inPos + 40] - in[inPos + 39] << 40 | in[inPos + 41] - in[inPos + 40] << 49 | in[inPos + 42] - in[inPos + 41] << 58;
        out[outPos + 6] = in[inPos + 42] - in[inPos + 41] >>> 6 | in[inPos + 43] - in[inPos + 42] << 3 | in[inPos + 44] - in[inPos + 43] << 12 | in[inPos + 45] - in[inPos + 44] << 21 | in[inPos + 46] - in[inPos + 45] << 30 | in[inPos + 47] - in[inPos + 46] << 39 | in[inPos + 48] - in[inPos + 47] << 48 | in[inPos + 49] - in[inPos + 48] << 57;
        out[outPos + 7] = in[inPos + 49] - in[inPos + 48] >>> 7 | in[inPos + 50] - in[inPos + 49] << 2 | in[inPos + 51] - in[inPos + 50] << 11 | in[inPos + 52] - in[inPos + 51] << 20 | in[inPos + 53] - in[inPos + 52] << 29 | in[inPos + 54] - in[inPos + 53] << 38 | in[inPos + 55] - in[inPos + 54] << 47 | in[inPos + 56] - in[inPos + 55] << 56;
        out[outPos + 8] = in[inPos + 56] - in[inPos + 55] >>> 8 | in[inPos + 57] - in[inPos + 56] << 1 | in[inPos + 58] - in[inPos + 57] << 10 | in[inPos + 59] - in[inPos + 58] << 19 | in[inPos + 60] - in[inPos + 59] << 28 | in[inPos + 61] - in[inPos + 60] << 37 | in[inPos + 62] - in[inPos + 61] << 46 | in[inPos + 63] - in[inPos + 62] << 55;
    }

    private static void unpack9(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 9 & 0x1FFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 18 & 0x1FFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 27 & 0x1FFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 36 & 0x1FFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 45 & 0x1FFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 54 & 0x1FFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos] >>> 63 | (in[inPos + 1] & 0xFFL) << 1) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 8 & 0x1FFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 17 & 0x1FFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 26 & 0x1FFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 35 & 0x1FFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 44 & 0x1FFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 1] >>> 53 & 0x1FFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0x7FL) << 2) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 2] >>> 7 & 0x1FFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 2] >>> 16 & 0x1FFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 2] >>> 25 & 0x1FFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 2] >>> 34 & 0x1FFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 2] >>> 43 & 0x1FFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 2] >>> 52 & 0x1FFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 2] >>> 61 | (in[inPos + 3] & 0x3FL) << 3) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 3] >>> 6 & 0x1FFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 3] >>> 15 & 0x1FFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 3] >>> 24 & 0x1FFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 3] >>> 33 & 0x1FFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 3] >>> 42 & 0x1FFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 3] >>> 51 & 0x1FFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0x1FL) << 4) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 4] >>> 5 & 0x1FFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 4] >>> 14 & 0x1FFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 4] >>> 23 & 0x1FFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 4] >>> 32 & 0x1FFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 4] >>> 41 & 0x1FFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 4] >>> 50 & 0x1FFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 4] >>> 59 | (in[inPos + 5] & 0xFL) << 5) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 5] >>> 4 & 0x1FFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 5] >>> 13 & 0x1FFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 5] >>> 22 & 0x1FFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 5] >>> 31 & 0x1FFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 5] >>> 40 & 0x1FFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 5] >>> 49 & 0x1FFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 7L) << 6) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 6] >>> 3 & 0x1FFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 6] >>> 12 & 0x1FFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 6] >>> 21 & 0x1FFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 6] >>> 30 & 0x1FFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 6] >>> 39 & 0x1FFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 6] >>> 48 & 0x1FFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 6] >>> 57 | (in[inPos + 7] & 3L) << 7) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 7] >>> 2 & 0x1FFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 7] >>> 11 & 0x1FFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 7] >>> 20 & 0x1FFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 7] >>> 29 & 0x1FFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 7] >>> 38 & 0x1FFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 7] >>> 47 & 0x1FFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 1L) << 8) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 8] >>> 1 & 0x1FFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 8] >>> 10 & 0x1FFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 8] >>> 19 & 0x1FFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 8] >>> 28 & 0x1FFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 8] >>> 37 & 0x1FFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 8] >>> 46 & 0x1FFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 8] >>> 55) + out[outPos + 62];
    }

    private static void pack10(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 10 | in[inPos + 2] - in[inPos + 1] << 20 | in[inPos + 3] - in[inPos + 2] << 30 | in[inPos + 4] - in[inPos + 3] << 40 | in[inPos + 5] - in[inPos + 4] << 50 | in[inPos + 6] - in[inPos + 5] << 60;
        out[outPos + 1] = in[inPos + 6] - in[inPos + 5] >>> 4 | in[inPos + 7] - in[inPos + 6] << 6 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 26 | in[inPos + 10] - in[inPos + 9] << 36 | in[inPos + 11] - in[inPos + 10] << 46 | in[inPos + 12] - in[inPos + 11] << 56;
        out[outPos + 2] = in[inPos + 12] - in[inPos + 11] >>> 8 | in[inPos + 13] - in[inPos + 12] << 2 | in[inPos + 14] - in[inPos + 13] << 12 | in[inPos + 15] - in[inPos + 14] << 22 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 42 | in[inPos + 18] - in[inPos + 17] << 52 | in[inPos + 19] - in[inPos + 18] << 62;
        out[outPos + 3] = in[inPos + 19] - in[inPos + 18] >>> 2 | in[inPos + 20] - in[inPos + 19] << 8 | in[inPos + 21] - in[inPos + 20] << 18 | in[inPos + 22] - in[inPos + 21] << 28 | in[inPos + 23] - in[inPos + 22] << 38 | in[inPos + 24] - in[inPos + 23] << 48 | in[inPos + 25] - in[inPos + 24] << 58;
        out[outPos + 4] = in[inPos + 25] - in[inPos + 24] >>> 6 | in[inPos + 26] - in[inPos + 25] << 4 | in[inPos + 27] - in[inPos + 26] << 14 | in[inPos + 28] - in[inPos + 27] << 24 | in[inPos + 29] - in[inPos + 28] << 34 | in[inPos + 30] - in[inPos + 29] << 44 | in[inPos + 31] - in[inPos + 30] << 54;
        out[outPos + 5] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 10 | in[inPos + 34] - in[inPos + 33] << 20 | in[inPos + 35] - in[inPos + 34] << 30 | in[inPos + 36] - in[inPos + 35] << 40 | in[inPos + 37] - in[inPos + 36] << 50 | in[inPos + 38] - in[inPos + 37] << 60;
        out[outPos + 6] = in[inPos + 38] - in[inPos + 37] >>> 4 | in[inPos + 39] - in[inPos + 38] << 6 | in[inPos + 40] - in[inPos + 39] << 16 | in[inPos + 41] - in[inPos + 40] << 26 | in[inPos + 42] - in[inPos + 41] << 36 | in[inPos + 43] - in[inPos + 42] << 46 | in[inPos + 44] - in[inPos + 43] << 56;
        out[outPos + 7] = in[inPos + 44] - in[inPos + 43] >>> 8 | in[inPos + 45] - in[inPos + 44] << 2 | in[inPos + 46] - in[inPos + 45] << 12 | in[inPos + 47] - in[inPos + 46] << 22 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 42 | in[inPos + 50] - in[inPos + 49] << 52 | in[inPos + 51] - in[inPos + 50] << 62;
        out[outPos + 8] = in[inPos + 51] - in[inPos + 50] >>> 2 | in[inPos + 52] - in[inPos + 51] << 8 | in[inPos + 53] - in[inPos + 52] << 18 | in[inPos + 54] - in[inPos + 53] << 28 | in[inPos + 55] - in[inPos + 54] << 38 | in[inPos + 56] - in[inPos + 55] << 48 | in[inPos + 57] - in[inPos + 56] << 58;
        out[outPos + 9] = in[inPos + 57] - in[inPos + 56] >>> 6 | in[inPos + 58] - in[inPos + 57] << 4 | in[inPos + 59] - in[inPos + 58] << 14 | in[inPos + 60] - in[inPos + 59] << 24 | in[inPos + 61] - in[inPos + 60] << 34 | in[inPos + 62] - in[inPos + 61] << 44 | in[inPos + 63] - in[inPos + 62] << 54;
    }

    private static void unpack10(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 10 & 0x3FFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 20 & 0x3FFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 30 & 0x3FFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 40 & 0x3FFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 50 & 0x3FFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos] >>> 60 | (in[inPos + 1] & 0x3FL) << 4) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 6 & 0x3FFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 16 & 0x3FFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 26 & 0x3FFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 36 & 0x3FFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 46 & 0x3FFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 3L) << 8) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 2 & 0x3FFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 2] >>> 12 & 0x3FFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 2] >>> 22 & 0x3FFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 2] >>> 32 & 0x3FFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 2] >>> 42 & 0x3FFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 2] >>> 52 & 0x3FFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 2] >>> 62 | (in[inPos + 3] & 0xFFL) << 2) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 3] >>> 8 & 0x3FFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 3] >>> 18 & 0x3FFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 3] >>> 28 & 0x3FFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 3] >>> 38 & 0x3FFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 3] >>> 48 & 0x3FFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 3] >>> 58 | (in[inPos + 4] & 0xFL) << 6) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 4] >>> 4 & 0x3FFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 4] >>> 14 & 0x3FFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 4] >>> 24 & 0x3FFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 4] >>> 34 & 0x3FFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 4] >>> 44 & 0x3FFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 4] >>> 54) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 5] & 0x3FFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 5] >>> 10 & 0x3FFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 5] >>> 20 & 0x3FFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 5] >>> 30 & 0x3FFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 5] >>> 40 & 0x3FFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 5] >>> 50 & 0x3FFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 5] >>> 60 | (in[inPos + 6] & 0x3FL) << 4) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 6] >>> 6 & 0x3FFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 6] >>> 16 & 0x3FFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 6] >>> 26 & 0x3FFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 6] >>> 36 & 0x3FFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 6] >>> 46 & 0x3FFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 6] >>> 56 | (in[inPos + 7] & 3L) << 8) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 7] >>> 2 & 0x3FFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 7] >>> 12 & 0x3FFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 7] >>> 22 & 0x3FFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 7] >>> 32 & 0x3FFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 7] >>> 42 & 0x3FFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 7] >>> 52 & 0x3FFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 7] >>> 62 | (in[inPos + 8] & 0xFFL) << 2) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 8] >>> 8 & 0x3FFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 8] >>> 18 & 0x3FFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 8] >>> 28 & 0x3FFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 8] >>> 38 & 0x3FFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 8] >>> 48 & 0x3FFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 8] >>> 58 | (in[inPos + 9] & 0xFL) << 6) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 9] >>> 4 & 0x3FFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 9] >>> 14 & 0x3FFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 9] >>> 24 & 0x3FFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 9] >>> 34 & 0x3FFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 9] >>> 44 & 0x3FFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 9] >>> 54) + out[outPos + 62];
    }

    private static void pack11(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 11 | in[inPos + 2] - in[inPos + 1] << 22 | in[inPos + 3] - in[inPos + 2] << 33 | in[inPos + 4] - in[inPos + 3] << 44 | in[inPos + 5] - in[inPos + 4] << 55;
        out[outPos + 1] = in[inPos + 5] - in[inPos + 4] >>> 9 | in[inPos + 6] - in[inPos + 5] << 2 | in[inPos + 7] - in[inPos + 6] << 13 | in[inPos + 8] - in[inPos + 7] << 24 | in[inPos + 9] - in[inPos + 8] << 35 | in[inPos + 10] - in[inPos + 9] << 46 | in[inPos + 11] - in[inPos + 10] << 57;
        out[outPos + 2] = in[inPos + 11] - in[inPos + 10] >>> 7 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 15 | in[inPos + 14] - in[inPos + 13] << 26 | in[inPos + 15] - in[inPos + 14] << 37 | in[inPos + 16] - in[inPos + 15] << 48 | in[inPos + 17] - in[inPos + 16] << 59;
        out[outPos + 3] = in[inPos + 17] - in[inPos + 16] >>> 5 | in[inPos + 18] - in[inPos + 17] << 6 | in[inPos + 19] - in[inPos + 18] << 17 | in[inPos + 20] - in[inPos + 19] << 28 | in[inPos + 21] - in[inPos + 20] << 39 | in[inPos + 22] - in[inPos + 21] << 50 | in[inPos + 23] - in[inPos + 22] << 61;
        out[outPos + 4] = in[inPos + 23] - in[inPos + 22] >>> 3 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 19 | in[inPos + 26] - in[inPos + 25] << 30 | in[inPos + 27] - in[inPos + 26] << 41 | in[inPos + 28] - in[inPos + 27] << 52 | in[inPos + 29] - in[inPos + 28] << 63;
        out[outPos + 5] = in[inPos + 29] - in[inPos + 28] >>> 1 | in[inPos + 30] - in[inPos + 29] << 10 | in[inPos + 31] - in[inPos + 30] << 21 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 43 | in[inPos + 34] - in[inPos + 33] << 54;
        out[outPos + 6] = in[inPos + 34] - in[inPos + 33] >>> 10 | in[inPos + 35] - in[inPos + 34] << 1 | in[inPos + 36] - in[inPos + 35] << 12 | in[inPos + 37] - in[inPos + 36] << 23 | in[inPos + 38] - in[inPos + 37] << 34 | in[inPos + 39] - in[inPos + 38] << 45 | in[inPos + 40] - in[inPos + 39] << 56;
        out[outPos + 7] = in[inPos + 40] - in[inPos + 39] >>> 8 | in[inPos + 41] - in[inPos + 40] << 3 | in[inPos + 42] - in[inPos + 41] << 14 | in[inPos + 43] - in[inPos + 42] << 25 | in[inPos + 44] - in[inPos + 43] << 36 | in[inPos + 45] - in[inPos + 44] << 47 | in[inPos + 46] - in[inPos + 45] << 58;
        out[outPos + 8] = in[inPos + 46] - in[inPos + 45] >>> 6 | in[inPos + 47] - in[inPos + 46] << 5 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 27 | in[inPos + 50] - in[inPos + 49] << 38 | in[inPos + 51] - in[inPos + 50] << 49 | in[inPos + 52] - in[inPos + 51] << 60;
        out[outPos + 9] = in[inPos + 52] - in[inPos + 51] >>> 4 | in[inPos + 53] - in[inPos + 52] << 7 | in[inPos + 54] - in[inPos + 53] << 18 | in[inPos + 55] - in[inPos + 54] << 29 | in[inPos + 56] - in[inPos + 55] << 40 | in[inPos + 57] - in[inPos + 56] << 51 | in[inPos + 58] - in[inPos + 57] << 62;
        out[outPos + 10] = in[inPos + 58] - in[inPos + 57] >>> 2 | in[inPos + 59] - in[inPos + 58] << 9 | in[inPos + 60] - in[inPos + 59] << 20 | in[inPos + 61] - in[inPos + 60] << 31 | in[inPos + 62] - in[inPos + 61] << 42 | in[inPos + 63] - in[inPos + 62] << 53;
    }

    private static void unpack11(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 11 & 0x7FFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 22 & 0x7FFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 33 & 0x7FFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 44 & 0x7FFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 55 | (in[inPos + 1] & 3L) << 9) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 2 & 0x7FFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 13 & 0x7FFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 24 & 0x7FFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 35 & 0x7FFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 46 & 0x7FFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 1] >>> 57 | (in[inPos + 2] & 0xFL) << 7) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 2] >>> 4 & 0x7FFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 15 & 0x7FFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 2] >>> 26 & 0x7FFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 2] >>> 37 & 0x7FFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 2] >>> 48 & 0x7FFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 2] >>> 59 | (in[inPos + 3] & 0x3FL) << 5) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 3] >>> 6 & 0x7FFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 3] >>> 17 & 0x7FFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 3] >>> 28 & 0x7FFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 3] >>> 39 & 0x7FFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 3] >>> 50 & 0x7FFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 3] >>> 61 | (in[inPos + 4] & 0xFFL) << 3) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 4] >>> 8 & 0x7FFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 4] >>> 19 & 0x7FFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 4] >>> 30 & 0x7FFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 4] >>> 41 & 0x7FFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 4] >>> 52 & 0x7FFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 4] >>> 63 | (in[inPos + 5] & 0x3FFL) << 1) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 5] >>> 10 & 0x7FFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 5] >>> 21 & 0x7FFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 5] >>> 32 & 0x7FFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 5] >>> 43 & 0x7FFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 5] >>> 54 | (in[inPos + 6] & 1L) << 10) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 6] >>> 1 & 0x7FFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 6] >>> 12 & 0x7FFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 6] >>> 23 & 0x7FFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 6] >>> 34 & 0x7FFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 6] >>> 45 & 0x7FFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 6] >>> 56 | (in[inPos + 7] & 7L) << 8) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 7] >>> 3 & 0x7FFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 7] >>> 14 & 0x7FFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 7] >>> 25 & 0x7FFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 7] >>> 36 & 0x7FFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 7] >>> 47 & 0x7FFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 7] >>> 58 | (in[inPos + 8] & 0x1FL) << 6) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 8] >>> 5 & 0x7FFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 8] >>> 16 & 0x7FFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 8] >>> 27 & 0x7FFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 8] >>> 38 & 0x7FFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 8] >>> 49 & 0x7FFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 8] >>> 60 | (in[inPos + 9] & 0x7FL) << 4) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 9] >>> 7 & 0x7FFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 9] >>> 18 & 0x7FFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 9] >>> 29 & 0x7FFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 9] >>> 40 & 0x7FFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 9] >>> 51 & 0x7FFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 9] >>> 62 | (in[inPos + 10] & 0x1FFL) << 2) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 10] >>> 9 & 0x7FFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 10] >>> 20 & 0x7FFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 10] >>> 31 & 0x7FFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 10] >>> 42 & 0x7FFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 10] >>> 53) + out[outPos + 62];
    }

    private static void pack12(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 12 | in[inPos + 2] - in[inPos + 1] << 24 | in[inPos + 3] - in[inPos + 2] << 36 | in[inPos + 4] - in[inPos + 3] << 48 | in[inPos + 5] - in[inPos + 4] << 60;
        out[outPos + 1] = in[inPos + 5] - in[inPos + 4] >>> 4 | in[inPos + 6] - in[inPos + 5] << 8 | in[inPos + 7] - in[inPos + 6] << 20 | in[inPos + 8] - in[inPos + 7] << 32 | in[inPos + 9] - in[inPos + 8] << 44 | in[inPos + 10] - in[inPos + 9] << 56;
        out[outPos + 2] = in[inPos + 10] - in[inPos + 9] >>> 8 | in[inPos + 11] - in[inPos + 10] << 4 | in[inPos + 12] - in[inPos + 11] << 16 | in[inPos + 13] - in[inPos + 12] << 28 | in[inPos + 14] - in[inPos + 13] << 40 | in[inPos + 15] - in[inPos + 14] << 52;
        out[outPos + 3] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 12 | in[inPos + 18] - in[inPos + 17] << 24 | in[inPos + 19] - in[inPos + 18] << 36 | in[inPos + 20] - in[inPos + 19] << 48 | in[inPos + 21] - in[inPos + 20] << 60;
        out[outPos + 4] = in[inPos + 21] - in[inPos + 20] >>> 4 | in[inPos + 22] - in[inPos + 21] << 8 | in[inPos + 23] - in[inPos + 22] << 20 | in[inPos + 24] - in[inPos + 23] << 32 | in[inPos + 25] - in[inPos + 24] << 44 | in[inPos + 26] - in[inPos + 25] << 56;
        out[outPos + 5] = in[inPos + 26] - in[inPos + 25] >>> 8 | in[inPos + 27] - in[inPos + 26] << 4 | in[inPos + 28] - in[inPos + 27] << 16 | in[inPos + 29] - in[inPos + 28] << 28 | in[inPos + 30] - in[inPos + 29] << 40 | in[inPos + 31] - in[inPos + 30] << 52;
        out[outPos + 6] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 12 | in[inPos + 34] - in[inPos + 33] << 24 | in[inPos + 35] - in[inPos + 34] << 36 | in[inPos + 36] - in[inPos + 35] << 48 | in[inPos + 37] - in[inPos + 36] << 60;
        out[outPos + 7] = in[inPos + 37] - in[inPos + 36] >>> 4 | in[inPos + 38] - in[inPos + 37] << 8 | in[inPos + 39] - in[inPos + 38] << 20 | in[inPos + 40] - in[inPos + 39] << 32 | in[inPos + 41] - in[inPos + 40] << 44 | in[inPos + 42] - in[inPos + 41] << 56;
        out[outPos + 8] = in[inPos + 42] - in[inPos + 41] >>> 8 | in[inPos + 43] - in[inPos + 42] << 4 | in[inPos + 44] - in[inPos + 43] << 16 | in[inPos + 45] - in[inPos + 44] << 28 | in[inPos + 46] - in[inPos + 45] << 40 | in[inPos + 47] - in[inPos + 46] << 52;
        out[outPos + 9] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 12 | in[inPos + 50] - in[inPos + 49] << 24 | in[inPos + 51] - in[inPos + 50] << 36 | in[inPos + 52] - in[inPos + 51] << 48 | in[inPos + 53] - in[inPos + 52] << 60;
        out[outPos + 10] = in[inPos + 53] - in[inPos + 52] >>> 4 | in[inPos + 54] - in[inPos + 53] << 8 | in[inPos + 55] - in[inPos + 54] << 20 | in[inPos + 56] - in[inPos + 55] << 32 | in[inPos + 57] - in[inPos + 56] << 44 | in[inPos + 58] - in[inPos + 57] << 56;
        out[outPos + 11] = in[inPos + 58] - in[inPos + 57] >>> 8 | in[inPos + 59] - in[inPos + 58] << 4 | in[inPos + 60] - in[inPos + 59] << 16 | in[inPos + 61] - in[inPos + 60] << 28 | in[inPos + 62] - in[inPos + 61] << 40 | in[inPos + 63] - in[inPos + 62] << 52;
    }

    private static void unpack12(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 12 & 0xFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 24 & 0xFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 36 & 0xFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 48 & 0xFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos] >>> 60 | (in[inPos + 1] & 0xFFL) << 4) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 8 & 0xFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 20 & 0xFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 32 & 0xFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 44 & 0xFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 0xFL) << 8) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 4 & 0xFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 2] >>> 16 & 0xFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 28 & 0xFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 2] >>> 40 & 0xFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 2] >>> 52) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 3] & 0xFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 3] >>> 12 & 0xFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 3] >>> 24 & 0xFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 3] >>> 36 & 0xFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 3] >>> 48 & 0xFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0xFFL) << 4) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 4] >>> 8 & 0xFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 4] >>> 20 & 0xFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 4] >>> 32 & 0xFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 4] >>> 44 & 0xFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 4] >>> 56 | (in[inPos + 5] & 0xFL) << 8) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 5] >>> 4 & 0xFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 5] >>> 16 & 0xFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 5] >>> 28 & 0xFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 5] >>> 40 & 0xFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 5] >>> 52) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 6] & 0xFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 6] >>> 12 & 0xFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 6] >>> 24 & 0xFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 6] >>> 36 & 0xFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 6] >>> 48 & 0xFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 6] >>> 60 | (in[inPos + 7] & 0xFFL) << 4) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 7] >>> 8 & 0xFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 7] >>> 20 & 0xFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 7] >>> 32 & 0xFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 7] >>> 44 & 0xFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0xFL) << 8) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 8] >>> 4 & 0xFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 8] >>> 16 & 0xFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 8] >>> 28 & 0xFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 8] >>> 40 & 0xFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 8] >>> 52) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 9] & 0xFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 9] >>> 12 & 0xFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 9] >>> 24 & 0xFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 9] >>> 36 & 0xFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 9] >>> 48 & 0xFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 9] >>> 60 | (in[inPos + 10] & 0xFFL) << 4) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 10] >>> 8 & 0xFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 10] >>> 20 & 0xFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 10] >>> 32 & 0xFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 10] >>> 44 & 0xFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 10] >>> 56 | (in[inPos + 11] & 0xFL) << 8) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 11] >>> 4 & 0xFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 11] >>> 16 & 0xFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 11] >>> 28 & 0xFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 11] >>> 40 & 0xFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 11] >>> 52) + out[outPos + 62];
    }

    private static void pack13(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 13 | in[inPos + 2] - in[inPos + 1] << 26 | in[inPos + 3] - in[inPos + 2] << 39 | in[inPos + 4] - in[inPos + 3] << 52;
        out[outPos + 1] = in[inPos + 4] - in[inPos + 3] >>> 12 | in[inPos + 5] - in[inPos + 4] << 1 | in[inPos + 6] - in[inPos + 5] << 14 | in[inPos + 7] - in[inPos + 6] << 27 | in[inPos + 8] - in[inPos + 7] << 40 | in[inPos + 9] - in[inPos + 8] << 53;
        out[outPos + 2] = in[inPos + 9] - in[inPos + 8] >>> 11 | in[inPos + 10] - in[inPos + 9] << 2 | in[inPos + 11] - in[inPos + 10] << 15 | in[inPos + 12] - in[inPos + 11] << 28 | in[inPos + 13] - in[inPos + 12] << 41 | in[inPos + 14] - in[inPos + 13] << 54;
        out[outPos + 3] = in[inPos + 14] - in[inPos + 13] >>> 10 | in[inPos + 15] - in[inPos + 14] << 3 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 29 | in[inPos + 18] - in[inPos + 17] << 42 | in[inPos + 19] - in[inPos + 18] << 55;
        out[outPos + 4] = in[inPos + 19] - in[inPos + 18] >>> 9 | in[inPos + 20] - in[inPos + 19] << 4 | in[inPos + 21] - in[inPos + 20] << 17 | in[inPos + 22] - in[inPos + 21] << 30 | in[inPos + 23] - in[inPos + 22] << 43 | in[inPos + 24] - in[inPos + 23] << 56;
        out[outPos + 5] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 5 | in[inPos + 26] - in[inPos + 25] << 18 | in[inPos + 27] - in[inPos + 26] << 31 | in[inPos + 28] - in[inPos + 27] << 44 | in[inPos + 29] - in[inPos + 28] << 57;
        out[outPos + 6] = in[inPos + 29] - in[inPos + 28] >>> 7 | in[inPos + 30] - in[inPos + 29] << 6 | in[inPos + 31] - in[inPos + 30] << 19 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 45 | in[inPos + 34] - in[inPos + 33] << 58;
        out[outPos + 7] = in[inPos + 34] - in[inPos + 33] >>> 6 | in[inPos + 35] - in[inPos + 34] << 7 | in[inPos + 36] - in[inPos + 35] << 20 | in[inPos + 37] - in[inPos + 36] << 33 | in[inPos + 38] - in[inPos + 37] << 46 | in[inPos + 39] - in[inPos + 38] << 59;
        out[outPos + 8] = in[inPos + 39] - in[inPos + 38] >>> 5 | in[inPos + 40] - in[inPos + 39] << 8 | in[inPos + 41] - in[inPos + 40] << 21 | in[inPos + 42] - in[inPos + 41] << 34 | in[inPos + 43] - in[inPos + 42] << 47 | in[inPos + 44] - in[inPos + 43] << 60;
        out[outPos + 9] = in[inPos + 44] - in[inPos + 43] >>> 4 | in[inPos + 45] - in[inPos + 44] << 9 | in[inPos + 46] - in[inPos + 45] << 22 | in[inPos + 47] - in[inPos + 46] << 35 | in[inPos + 48] - in[inPos + 47] << 48 | in[inPos + 49] - in[inPos + 48] << 61;
        out[outPos + 10] = in[inPos + 49] - in[inPos + 48] >>> 3 | in[inPos + 50] - in[inPos + 49] << 10 | in[inPos + 51] - in[inPos + 50] << 23 | in[inPos + 52] - in[inPos + 51] << 36 | in[inPos + 53] - in[inPos + 52] << 49 | in[inPos + 54] - in[inPos + 53] << 62;
        out[outPos + 11] = in[inPos + 54] - in[inPos + 53] >>> 2 | in[inPos + 55] - in[inPos + 54] << 11 | in[inPos + 56] - in[inPos + 55] << 24 | in[inPos + 57] - in[inPos + 56] << 37 | in[inPos + 58] - in[inPos + 57] << 50 | in[inPos + 59] - in[inPos + 58] << 63;
        out[outPos + 12] = in[inPos + 59] - in[inPos + 58] >>> 1 | in[inPos + 60] - in[inPos + 59] << 12 | in[inPos + 61] - in[inPos + 60] << 25 | in[inPos + 62] - in[inPos + 61] << 38 | in[inPos + 63] - in[inPos + 62] << 51;
    }

    private static void unpack13(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 13 & 0x1FFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 26 & 0x1FFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 39 & 0x1FFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 52 | (in[inPos + 1] & 1L) << 12) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 1 & 0x1FFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 14 & 0x1FFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 27 & 0x1FFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 40 & 0x1FFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 53 | (in[inPos + 2] & 3L) << 11) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 2 & 0x1FFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 15 & 0x1FFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 2] >>> 28 & 0x1FFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 41 & 0x1FFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 2] >>> 54 | (in[inPos + 3] & 7L) << 10) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 3] >>> 3 & 0x1FFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 3] >>> 16 & 0x1FFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 3] >>> 29 & 0x1FFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 3] >>> 42 & 0x1FFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 3] >>> 55 | (in[inPos + 4] & 0xFL) << 9) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 4] >>> 4 & 0x1FFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 4] >>> 17 & 0x1FFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 4] >>> 30 & 0x1FFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 4] >>> 43 & 0x1FFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 4] >>> 56 | (in[inPos + 5] & 0x1FL) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 5] >>> 5 & 0x1FFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 5] >>> 18 & 0x1FFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 5] >>> 31 & 0x1FFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 5] >>> 44 & 0x1FFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 5] >>> 57 | (in[inPos + 6] & 0x3FL) << 7) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 6] >>> 6 & 0x1FFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 6] >>> 19 & 0x1FFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 6] >>> 32 & 0x1FFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 6] >>> 45 & 0x1FFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 6] >>> 58 | (in[inPos + 7] & 0x7FL) << 6) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 7] >>> 7 & 0x1FFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 7] >>> 20 & 0x1FFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 7] >>> 33 & 0x1FFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 7] >>> 46 & 0x1FFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 7] >>> 59 | (in[inPos + 8] & 0xFFL) << 5) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 8] >>> 8 & 0x1FFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 8] >>> 21 & 0x1FFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 8] >>> 34 & 0x1FFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 8] >>> 47 & 0x1FFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 8] >>> 60 | (in[inPos + 9] & 0x1FFL) << 4) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 9] >>> 9 & 0x1FFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 9] >>> 22 & 0x1FFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 9] >>> 35 & 0x1FFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 9] >>> 48 & 0x1FFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 9] >>> 61 | (in[inPos + 10] & 0x3FFL) << 3) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 10] >>> 10 & 0x1FFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 10] >>> 23 & 0x1FFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 10] >>> 36 & 0x1FFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 10] >>> 49 & 0x1FFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 10] >>> 62 | (in[inPos + 11] & 0x7FFL) << 2) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 11] >>> 11 & 0x1FFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 11] >>> 24 & 0x1FFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 11] >>> 37 & 0x1FFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 11] >>> 50 & 0x1FFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 11] >>> 63 | (in[inPos + 12] & 0xFFFL) << 1) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 12] >>> 12 & 0x1FFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 12] >>> 25 & 0x1FFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 12] >>> 38 & 0x1FFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 12] >>> 51) + out[outPos + 62];
    }

    private static void pack14(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 14 | in[inPos + 2] - in[inPos + 1] << 28 | in[inPos + 3] - in[inPos + 2] << 42 | in[inPos + 4] - in[inPos + 3] << 56;
        out[outPos + 1] = in[inPos + 4] - in[inPos + 3] >>> 8 | in[inPos + 5] - in[inPos + 4] << 6 | in[inPos + 6] - in[inPos + 5] << 20 | in[inPos + 7] - in[inPos + 6] << 34 | in[inPos + 8] - in[inPos + 7] << 48 | in[inPos + 9] - in[inPos + 8] << 62;
        out[outPos + 2] = in[inPos + 9] - in[inPos + 8] >>> 2 | in[inPos + 10] - in[inPos + 9] << 12 | in[inPos + 11] - in[inPos + 10] << 26 | in[inPos + 12] - in[inPos + 11] << 40 | in[inPos + 13] - in[inPos + 12] << 54;
        out[outPos + 3] = in[inPos + 13] - in[inPos + 12] >>> 10 | in[inPos + 14] - in[inPos + 13] << 4 | in[inPos + 15] - in[inPos + 14] << 18 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 46 | in[inPos + 18] - in[inPos + 17] << 60;
        out[outPos + 4] = in[inPos + 18] - in[inPos + 17] >>> 4 | in[inPos + 19] - in[inPos + 18] << 10 | in[inPos + 20] - in[inPos + 19] << 24 | in[inPos + 21] - in[inPos + 20] << 38 | in[inPos + 22] - in[inPos + 21] << 52;
        out[outPos + 5] = in[inPos + 22] - in[inPos + 21] >>> 12 | in[inPos + 23] - in[inPos + 22] << 2 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 30 | in[inPos + 26] - in[inPos + 25] << 44 | in[inPos + 27] - in[inPos + 26] << 58;
        out[outPos + 6] = in[inPos + 27] - in[inPos + 26] >>> 6 | in[inPos + 28] - in[inPos + 27] << 8 | in[inPos + 29] - in[inPos + 28] << 22 | in[inPos + 30] - in[inPos + 29] << 36 | in[inPos + 31] - in[inPos + 30] << 50;
        out[outPos + 7] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 14 | in[inPos + 34] - in[inPos + 33] << 28 | in[inPos + 35] - in[inPos + 34] << 42 | in[inPos + 36] - in[inPos + 35] << 56;
        out[outPos + 8] = in[inPos + 36] - in[inPos + 35] >>> 8 | in[inPos + 37] - in[inPos + 36] << 6 | in[inPos + 38] - in[inPos + 37] << 20 | in[inPos + 39] - in[inPos + 38] << 34 | in[inPos + 40] - in[inPos + 39] << 48 | in[inPos + 41] - in[inPos + 40] << 62;
        out[outPos + 9] = in[inPos + 41] - in[inPos + 40] >>> 2 | in[inPos + 42] - in[inPos + 41] << 12 | in[inPos + 43] - in[inPos + 42] << 26 | in[inPos + 44] - in[inPos + 43] << 40 | in[inPos + 45] - in[inPos + 44] << 54;
        out[outPos + 10] = in[inPos + 45] - in[inPos + 44] >>> 10 | in[inPos + 46] - in[inPos + 45] << 4 | in[inPos + 47] - in[inPos + 46] << 18 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 46 | in[inPos + 50] - in[inPos + 49] << 60;
        out[outPos + 11] = in[inPos + 50] - in[inPos + 49] >>> 4 | in[inPos + 51] - in[inPos + 50] << 10 | in[inPos + 52] - in[inPos + 51] << 24 | in[inPos + 53] - in[inPos + 52] << 38 | in[inPos + 54] - in[inPos + 53] << 52;
        out[outPos + 12] = in[inPos + 54] - in[inPos + 53] >>> 12 | in[inPos + 55] - in[inPos + 54] << 2 | in[inPos + 56] - in[inPos + 55] << 16 | in[inPos + 57] - in[inPos + 56] << 30 | in[inPos + 58] - in[inPos + 57] << 44 | in[inPos + 59] - in[inPos + 58] << 58;
        out[outPos + 13] = in[inPos + 59] - in[inPos + 58] >>> 6 | in[inPos + 60] - in[inPos + 59] << 8 | in[inPos + 61] - in[inPos + 60] << 22 | in[inPos + 62] - in[inPos + 61] << 36 | in[inPos + 63] - in[inPos + 62] << 50;
    }

    private static void unpack14(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 14 & 0x3FFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 28 & 0x3FFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 42 & 0x3FFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 56 | (in[inPos + 1] & 0x3FL) << 8) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 6 & 0x3FFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 20 & 0x3FFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 34 & 0x3FFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 48 & 0x3FFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0xFFFL) << 2) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 12 & 0x3FFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 26 & 0x3FFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 2] >>> 40 & 0x3FFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 2] >>> 54 | (in[inPos + 3] & 0xFL) << 10) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 4 & 0x3FFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 3] >>> 18 & 0x3FFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 3] >>> 32 & 0x3FFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 3] >>> 46 & 0x3FFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0x3FFL) << 4) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 4] >>> 10 & 0x3FFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 4] >>> 24 & 0x3FFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 4] >>> 38 & 0x3FFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 4] >>> 52 | (in[inPos + 5] & 3L) << 12) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 5] >>> 2 & 0x3FFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 5] >>> 16 & 0x3FFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 5] >>> 30 & 0x3FFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 5] >>> 44 & 0x3FFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 0xFFL) << 6) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 6] >>> 8 & 0x3FFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 6] >>> 22 & 0x3FFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 6] >>> 36 & 0x3FFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 6] >>> 50) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 7] & 0x3FFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 7] >>> 14 & 0x3FFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 7] >>> 28 & 0x3FFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 7] >>> 42 & 0x3FFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0x3FL) << 8) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 8] >>> 6 & 0x3FFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 8] >>> 20 & 0x3FFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 8] >>> 34 & 0x3FFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 8] >>> 48 & 0x3FFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 8] >>> 62 | (in[inPos + 9] & 0xFFFL) << 2) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 9] >>> 12 & 0x3FFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 9] >>> 26 & 0x3FFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 9] >>> 40 & 0x3FFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0xFL) << 10) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 10] >>> 4 & 0x3FFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 10] >>> 18 & 0x3FFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 10] >>> 32 & 0x3FFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 10] >>> 46 & 0x3FFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 10] >>> 60 | (in[inPos + 11] & 0x3FFL) << 4) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 11] >>> 10 & 0x3FFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 11] >>> 24 & 0x3FFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 11] >>> 38 & 0x3FFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 3L) << 12) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 12] >>> 2 & 0x3FFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 12] >>> 16 & 0x3FFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 12] >>> 30 & 0x3FFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 12] >>> 44 & 0x3FFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 12] >>> 58 | (in[inPos + 13] & 0xFFL) << 6) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 13] >>> 8 & 0x3FFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 13] >>> 22 & 0x3FFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 13] >>> 36 & 0x3FFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 13] >>> 50) + out[outPos + 62];
    }

    private static void pack15(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 15 | in[inPos + 2] - in[inPos + 1] << 30 | in[inPos + 3] - in[inPos + 2] << 45 | in[inPos + 4] - in[inPos + 3] << 60;
        out[outPos + 1] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 11 | in[inPos + 6] - in[inPos + 5] << 26 | in[inPos + 7] - in[inPos + 6] << 41 | in[inPos + 8] - in[inPos + 7] << 56;
        out[outPos + 2] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 7 | in[inPos + 10] - in[inPos + 9] << 22 | in[inPos + 11] - in[inPos + 10] << 37 | in[inPos + 12] - in[inPos + 11] << 52;
        out[outPos + 3] = in[inPos + 12] - in[inPos + 11] >>> 12 | in[inPos + 13] - in[inPos + 12] << 3 | in[inPos + 14] - in[inPos + 13] << 18 | in[inPos + 15] - in[inPos + 14] << 33 | in[inPos + 16] - in[inPos + 15] << 48 | in[inPos + 17] - in[inPos + 16] << 63;
        out[outPos + 4] = in[inPos + 17] - in[inPos + 16] >>> 1 | in[inPos + 18] - in[inPos + 17] << 14 | in[inPos + 19] - in[inPos + 18] << 29 | in[inPos + 20] - in[inPos + 19] << 44 | in[inPos + 21] - in[inPos + 20] << 59;
        out[outPos + 5] = in[inPos + 21] - in[inPos + 20] >>> 5 | in[inPos + 22] - in[inPos + 21] << 10 | in[inPos + 23] - in[inPos + 22] << 25 | in[inPos + 24] - in[inPos + 23] << 40 | in[inPos + 25] - in[inPos + 24] << 55;
        out[outPos + 6] = in[inPos + 25] - in[inPos + 24] >>> 9 | in[inPos + 26] - in[inPos + 25] << 6 | in[inPos + 27] - in[inPos + 26] << 21 | in[inPos + 28] - in[inPos + 27] << 36 | in[inPos + 29] - in[inPos + 28] << 51;
        out[outPos + 7] = in[inPos + 29] - in[inPos + 28] >>> 13 | in[inPos + 30] - in[inPos + 29] << 2 | in[inPos + 31] - in[inPos + 30] << 17 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 47 | in[inPos + 34] - in[inPos + 33] << 62;
        out[outPos + 8] = in[inPos + 34] - in[inPos + 33] >>> 2 | in[inPos + 35] - in[inPos + 34] << 13 | in[inPos + 36] - in[inPos + 35] << 28 | in[inPos + 37] - in[inPos + 36] << 43 | in[inPos + 38] - in[inPos + 37] << 58;
        out[outPos + 9] = in[inPos + 38] - in[inPos + 37] >>> 6 | in[inPos + 39] - in[inPos + 38] << 9 | in[inPos + 40] - in[inPos + 39] << 24 | in[inPos + 41] - in[inPos + 40] << 39 | in[inPos + 42] - in[inPos + 41] << 54;
        out[outPos + 10] = in[inPos + 42] - in[inPos + 41] >>> 10 | in[inPos + 43] - in[inPos + 42] << 5 | in[inPos + 44] - in[inPos + 43] << 20 | in[inPos + 45] - in[inPos + 44] << 35 | in[inPos + 46] - in[inPos + 45] << 50;
        out[outPos + 11] = in[inPos + 46] - in[inPos + 45] >>> 14 | in[inPos + 47] - in[inPos + 46] << 1 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 31 | in[inPos + 50] - in[inPos + 49] << 46 | in[inPos + 51] - in[inPos + 50] << 61;
        out[outPos + 12] = in[inPos + 51] - in[inPos + 50] >>> 3 | in[inPos + 52] - in[inPos + 51] << 12 | in[inPos + 53] - in[inPos + 52] << 27 | in[inPos + 54] - in[inPos + 53] << 42 | in[inPos + 55] - in[inPos + 54] << 57;
        out[outPos + 13] = in[inPos + 55] - in[inPos + 54] >>> 7 | in[inPos + 56] - in[inPos + 55] << 8 | in[inPos + 57] - in[inPos + 56] << 23 | in[inPos + 58] - in[inPos + 57] << 38 | in[inPos + 59] - in[inPos + 58] << 53;
        out[outPos + 14] = in[inPos + 59] - in[inPos + 58] >>> 11 | in[inPos + 60] - in[inPos + 59] << 4 | in[inPos + 61] - in[inPos + 60] << 19 | in[inPos + 62] - in[inPos + 61] << 34 | in[inPos + 63] - in[inPos + 62] << 49;
    }

    private static void unpack15(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 15 & 0x7FFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 30 & 0x7FFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 45 & 0x7FFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos] >>> 60 | (in[inPos + 1] & 0x7FFL) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 11 & 0x7FFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 26 & 0x7FFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 41 & 0x7FFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 0x7FL) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 7 & 0x7FFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 22 & 0x7FFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 37 & 0x7FFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 2] >>> 52 | (in[inPos + 3] & 7L) << 12) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 3] >>> 3 & 0x7FFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 18 & 0x7FFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 3] >>> 33 & 0x7FFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 3] >>> 48 & 0x7FFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 3] >>> 63 | (in[inPos + 4] & 0x3FFFL) << 1) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 4] >>> 14 & 0x7FFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 4] >>> 29 & 0x7FFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 4] >>> 44 & 0x7FFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 4] >>> 59 | (in[inPos + 5] & 0x3FFL) << 5) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 5] >>> 10 & 0x7FFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 5] >>> 25 & 0x7FFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 5] >>> 40 & 0x7FFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 5] >>> 55 | (in[inPos + 6] & 0x3FL) << 9) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 6] >>> 6 & 0x7FFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 6] >>> 21 & 0x7FFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 6] >>> 36 & 0x7FFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 6] >>> 51 | (in[inPos + 7] & 3L) << 13) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 7] >>> 2 & 0x7FFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 7] >>> 17 & 0x7FFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 7] >>> 32 & 0x7FFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 7] >>> 47 & 0x7FFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 7] >>> 62 | (in[inPos + 8] & 0x1FFFL) << 2) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 8] >>> 13 & 0x7FFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 8] >>> 28 & 0x7FFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 8] >>> 43 & 0x7FFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 8] >>> 58 | (in[inPos + 9] & 0x1FFL) << 6) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 9] >>> 9 & 0x7FFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 9] >>> 24 & 0x7FFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 9] >>> 39 & 0x7FFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0x1FL) << 10) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 10] >>> 5 & 0x7FFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 10] >>> 20 & 0x7FFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 10] >>> 35 & 0x7FFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 10] >>> 50 | (in[inPos + 11] & 1L) << 14) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 11] >>> 1 & 0x7FFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 11] >>> 16 & 0x7FFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 11] >>> 31 & 0x7FFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 11] >>> 46 & 0x7FFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 11] >>> 61 | (in[inPos + 12] & 0xFFFL) << 3) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 12] >>> 12 & 0x7FFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 12] >>> 27 & 0x7FFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 12] >>> 42 & 0x7FFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 12] >>> 57 | (in[inPos + 13] & 0xFFL) << 7) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 13] >>> 8 & 0x7FFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 13] >>> 23 & 0x7FFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 13] >>> 38 & 0x7FFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 13] >>> 53 | (in[inPos + 14] & 0xFL) << 11) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 14] >>> 4 & 0x7FFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 14] >>> 19 & 0x7FFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 14] >>> 34 & 0x7FFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 14] >>> 49) + out[outPos + 62];
    }

    private static void pack16(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 16 | in[inPos + 2] - in[inPos + 1] << 32 | in[inPos + 3] - in[inPos + 2] << 48;
        out[outPos + 1] = in[inPos + 4] - in[inPos + 3] | in[inPos + 5] - in[inPos + 4] << 16 | in[inPos + 6] - in[inPos + 5] << 32 | in[inPos + 7] - in[inPos + 6] << 48;
        out[outPos + 2] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 16 | in[inPos + 10] - in[inPos + 9] << 32 | in[inPos + 11] - in[inPos + 10] << 48;
        out[outPos + 3] = in[inPos + 12] - in[inPos + 11] | in[inPos + 13] - in[inPos + 12] << 16 | in[inPos + 14] - in[inPos + 13] << 32 | in[inPos + 15] - in[inPos + 14] << 48;
        out[outPos + 4] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 16 | in[inPos + 18] - in[inPos + 17] << 32 | in[inPos + 19] - in[inPos + 18] << 48;
        out[outPos + 5] = in[inPos + 20] - in[inPos + 19] | in[inPos + 21] - in[inPos + 20] << 16 | in[inPos + 22] - in[inPos + 21] << 32 | in[inPos + 23] - in[inPos + 22] << 48;
        out[outPos + 6] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 16 | in[inPos + 26] - in[inPos + 25] << 32 | in[inPos + 27] - in[inPos + 26] << 48;
        out[outPos + 7] = in[inPos + 28] - in[inPos + 27] | in[inPos + 29] - in[inPos + 28] << 16 | in[inPos + 30] - in[inPos + 29] << 32 | in[inPos + 31] - in[inPos + 30] << 48;
        out[outPos + 8] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 16 | in[inPos + 34] - in[inPos + 33] << 32 | in[inPos + 35] - in[inPos + 34] << 48;
        out[outPos + 9] = in[inPos + 36] - in[inPos + 35] | in[inPos + 37] - in[inPos + 36] << 16 | in[inPos + 38] - in[inPos + 37] << 32 | in[inPos + 39] - in[inPos + 38] << 48;
        out[outPos + 10] = in[inPos + 40] - in[inPos + 39] | in[inPos + 41] - in[inPos + 40] << 16 | in[inPos + 42] - in[inPos + 41] << 32 | in[inPos + 43] - in[inPos + 42] << 48;
        out[outPos + 11] = in[inPos + 44] - in[inPos + 43] | in[inPos + 45] - in[inPos + 44] << 16 | in[inPos + 46] - in[inPos + 45] << 32 | in[inPos + 47] - in[inPos + 46] << 48;
        out[outPos + 12] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 16 | in[inPos + 50] - in[inPos + 49] << 32 | in[inPos + 51] - in[inPos + 50] << 48;
        out[outPos + 13] = in[inPos + 52] - in[inPos + 51] | in[inPos + 53] - in[inPos + 52] << 16 | in[inPos + 54] - in[inPos + 53] << 32 | in[inPos + 55] - in[inPos + 54] << 48;
        out[outPos + 14] = in[inPos + 56] - in[inPos + 55] | in[inPos + 57] - in[inPos + 56] << 16 | in[inPos + 58] - in[inPos + 57] << 32 | in[inPos + 59] - in[inPos + 58] << 48;
        out[outPos + 15] = in[inPos + 60] - in[inPos + 59] | in[inPos + 61] - in[inPos + 60] << 16 | in[inPos + 62] - in[inPos + 61] << 32 | in[inPos + 63] - in[inPos + 62] << 48;
    }

    private static void unpack16(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 16 & 0xFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 32 & 0xFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 48) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] & 0xFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 16 & 0xFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 32 & 0xFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 48) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] & 0xFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 16 & 0xFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 32 & 0xFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 48) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] & 0xFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 3] >>> 16 & 0xFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 32 & 0xFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 3] >>> 48) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 4] & 0xFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 4] >>> 16 & 0xFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 4] >>> 32 & 0xFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 4] >>> 48) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 5] & 0xFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 5] >>> 16 & 0xFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 5] >>> 32 & 0xFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 5] >>> 48) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 6] & 0xFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 6] >>> 16 & 0xFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 6] >>> 32 & 0xFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 6] >>> 48) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 7] & 0xFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 7] >>> 16 & 0xFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 7] >>> 32 & 0xFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 7] >>> 48) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 8] & 0xFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 8] >>> 16 & 0xFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 8] >>> 32 & 0xFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 8] >>> 48) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 9] & 0xFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 9] >>> 16 & 0xFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 9] >>> 32 & 0xFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 9] >>> 48) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 10] & 0xFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 10] >>> 16 & 0xFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 10] >>> 32 & 0xFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 10] >>> 48) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 11] & 0xFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 11] >>> 16 & 0xFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 11] >>> 32 & 0xFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 11] >>> 48) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 12] & 0xFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 12] >>> 16 & 0xFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 12] >>> 32 & 0xFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 12] >>> 48) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 13] & 0xFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 13] >>> 16 & 0xFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 13] >>> 32 & 0xFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 13] >>> 48) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 14] & 0xFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 14] >>> 16 & 0xFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 14] >>> 32 & 0xFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 14] >>> 48) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 15] & 0xFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 15] >>> 16 & 0xFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 15] >>> 32 & 0xFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 15] >>> 48) + out[outPos + 62];
    }

    private static void pack17(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 17 | in[inPos + 2] - in[inPos + 1] << 34 | in[inPos + 3] - in[inPos + 2] << 51;
        out[outPos + 1] = in[inPos + 3] - in[inPos + 2] >>> 13 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 21 | in[inPos + 6] - in[inPos + 5] << 38 | in[inPos + 7] - in[inPos + 6] << 55;
        out[outPos + 2] = in[inPos + 7] - in[inPos + 6] >>> 9 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 25 | in[inPos + 10] - in[inPos + 9] << 42 | in[inPos + 11] - in[inPos + 10] << 59;
        out[outPos + 3] = in[inPos + 11] - in[inPos + 10] >>> 5 | in[inPos + 12] - in[inPos + 11] << 12 | in[inPos + 13] - in[inPos + 12] << 29 | in[inPos + 14] - in[inPos + 13] << 46 | in[inPos + 15] - in[inPos + 14] << 63;
        out[outPos + 4] = in[inPos + 15] - in[inPos + 14] >>> 1 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 33 | in[inPos + 18] - in[inPos + 17] << 50;
        out[outPos + 5] = in[inPos + 18] - in[inPos + 17] >>> 14 | in[inPos + 19] - in[inPos + 18] << 3 | in[inPos + 20] - in[inPos + 19] << 20 | in[inPos + 21] - in[inPos + 20] << 37 | in[inPos + 22] - in[inPos + 21] << 54;
        out[outPos + 6] = in[inPos + 22] - in[inPos + 21] >>> 10 | in[inPos + 23] - in[inPos + 22] << 7 | in[inPos + 24] - in[inPos + 23] << 24 | in[inPos + 25] - in[inPos + 24] << 41 | in[inPos + 26] - in[inPos + 25] << 58;
        out[outPos + 7] = in[inPos + 26] - in[inPos + 25] >>> 6 | in[inPos + 27] - in[inPos + 26] << 11 | in[inPos + 28] - in[inPos + 27] << 28 | in[inPos + 29] - in[inPos + 28] << 45 | in[inPos + 30] - in[inPos + 29] << 62;
        out[outPos + 8] = in[inPos + 30] - in[inPos + 29] >>> 2 | in[inPos + 31] - in[inPos + 30] << 15 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 49;
        out[outPos + 9] = in[inPos + 33] - in[inPos + 32] >>> 15 | in[inPos + 34] - in[inPos + 33] << 2 | in[inPos + 35] - in[inPos + 34] << 19 | in[inPos + 36] - in[inPos + 35] << 36 | in[inPos + 37] - in[inPos + 36] << 53;
        out[outPos + 10] = in[inPos + 37] - in[inPos + 36] >>> 11 | in[inPos + 38] - in[inPos + 37] << 6 | in[inPos + 39] - in[inPos + 38] << 23 | in[inPos + 40] - in[inPos + 39] << 40 | in[inPos + 41] - in[inPos + 40] << 57;
        out[outPos + 11] = in[inPos + 41] - in[inPos + 40] >>> 7 | in[inPos + 42] - in[inPos + 41] << 10 | in[inPos + 43] - in[inPos + 42] << 27 | in[inPos + 44] - in[inPos + 43] << 44 | in[inPos + 45] - in[inPos + 44] << 61;
        out[outPos + 12] = in[inPos + 45] - in[inPos + 44] >>> 3 | in[inPos + 46] - in[inPos + 45] << 14 | in[inPos + 47] - in[inPos + 46] << 31 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 13] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 1 | in[inPos + 50] - in[inPos + 49] << 18 | in[inPos + 51] - in[inPos + 50] << 35 | in[inPos + 52] - in[inPos + 51] << 52;
        out[outPos + 14] = in[inPos + 52] - in[inPos + 51] >>> 12 | in[inPos + 53] - in[inPos + 52] << 5 | in[inPos + 54] - in[inPos + 53] << 22 | in[inPos + 55] - in[inPos + 54] << 39 | in[inPos + 56] - in[inPos + 55] << 56;
        out[outPos + 15] = in[inPos + 56] - in[inPos + 55] >>> 8 | in[inPos + 57] - in[inPos + 56] << 9 | in[inPos + 58] - in[inPos + 57] << 26 | in[inPos + 59] - in[inPos + 58] << 43 | in[inPos + 60] - in[inPos + 59] << 60;
        out[outPos + 16] = in[inPos + 60] - in[inPos + 59] >>> 4 | in[inPos + 61] - in[inPos + 60] << 13 | in[inPos + 62] - in[inPos + 61] << 30 | in[inPos + 63] - in[inPos + 62] << 47;
    }

    private static void unpack17(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 17 & 0x1FFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 34 & 0x1FFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 51 | (in[inPos + 1] & 0xFL) << 13) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 4 & 0x1FFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 21 & 0x1FFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 38 & 0x1FFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 55 | (in[inPos + 2] & 0xFFL) << 9) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 8 & 0x1FFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 25 & 0x1FFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 42 & 0x1FFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 2] >>> 59 | (in[inPos + 3] & 0xFFFL) << 5) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] >>> 12 & 0x1FFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 3] >>> 29 & 0x1FFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 46 & 0x1FFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 3] >>> 63 | (in[inPos + 4] & 0xFFFFL) << 1) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 4] >>> 16 & 0x1FFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 4] >>> 33 & 0x1FFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 4] >>> 50 | (in[inPos + 5] & 7L) << 14) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 5] >>> 3 & 0x1FFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 5] >>> 20 & 0x1FFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 5] >>> 37 & 0x1FFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 5] >>> 54 | (in[inPos + 6] & 0x7FL) << 10) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 6] >>> 7 & 0x1FFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 6] >>> 24 & 0x1FFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 6] >>> 41 & 0x1FFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 6] >>> 58 | (in[inPos + 7] & 0x7FFL) << 6) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 7] >>> 11 & 0x1FFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 7] >>> 28 & 0x1FFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 7] >>> 45 & 0x1FFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 7] >>> 62 | (in[inPos + 8] & 0x7FFFL) << 2) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 8] >>> 15 & 0x1FFFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 8] >>> 32 & 0x1FFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 8] >>> 49 | (in[inPos + 9] & 3L) << 15) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 9] >>> 2 & 0x1FFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 9] >>> 19 & 0x1FFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 9] >>> 36 & 0x1FFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 9] >>> 53 | (in[inPos + 10] & 0x3FL) << 11) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 10] >>> 6 & 0x1FFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 10] >>> 23 & 0x1FFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 10] >>> 40 & 0x1FFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 10] >>> 57 | (in[inPos + 11] & 0x3FFL) << 7) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 11] >>> 10 & 0x1FFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 11] >>> 27 & 0x1FFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 11] >>> 44 & 0x1FFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 11] >>> 61 | (in[inPos + 12] & 0x3FFFL) << 3) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 12] >>> 14 & 0x1FFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 12] >>> 31 & 0x1FFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 12] >>> 48 | (in[inPos + 13] & 1L) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 13] >>> 1 & 0x1FFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 13] >>> 18 & 0x1FFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 13] >>> 35 & 0x1FFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 13] >>> 52 | (in[inPos + 14] & 0x1FL) << 12) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 14] >>> 5 & 0x1FFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 14] >>> 22 & 0x1FFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 14] >>> 39 & 0x1FFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 14] >>> 56 | (in[inPos + 15] & 0x1FFL) << 8) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 15] >>> 9 & 0x1FFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 15] >>> 26 & 0x1FFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 15] >>> 43 & 0x1FFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 15] >>> 60 | (in[inPos + 16] & 0x1FFFL) << 4) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 16] >>> 13 & 0x1FFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 16] >>> 30 & 0x1FFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 16] >>> 47) + out[outPos + 62];
    }

    private static void pack18(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 18 | in[inPos + 2] - in[inPos + 1] << 36 | in[inPos + 3] - in[inPos + 2] << 54;
        out[outPos + 1] = in[inPos + 3] - in[inPos + 2] >>> 10 | in[inPos + 4] - in[inPos + 3] << 8 | in[inPos + 5] - in[inPos + 4] << 26 | in[inPos + 6] - in[inPos + 5] << 44 | in[inPos + 7] - in[inPos + 6] << 62;
        out[outPos + 2] = in[inPos + 7] - in[inPos + 6] >>> 2 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 34 | in[inPos + 10] - in[inPos + 9] << 52;
        out[outPos + 3] = in[inPos + 10] - in[inPos + 9] >>> 12 | in[inPos + 11] - in[inPos + 10] << 6 | in[inPos + 12] - in[inPos + 11] << 24 | in[inPos + 13] - in[inPos + 12] << 42 | in[inPos + 14] - in[inPos + 13] << 60;
        out[outPos + 4] = in[inPos + 14] - in[inPos + 13] >>> 4 | in[inPos + 15] - in[inPos + 14] << 14 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 50;
        out[outPos + 5] = in[inPos + 17] - in[inPos + 16] >>> 14 | in[inPos + 18] - in[inPos + 17] << 4 | in[inPos + 19] - in[inPos + 18] << 22 | in[inPos + 20] - in[inPos + 19] << 40 | in[inPos + 21] - in[inPos + 20] << 58;
        out[outPos + 6] = in[inPos + 21] - in[inPos + 20] >>> 6 | in[inPos + 22] - in[inPos + 21] << 12 | in[inPos + 23] - in[inPos + 22] << 30 | in[inPos + 24] - in[inPos + 23] << 48;
        out[outPos + 7] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 2 | in[inPos + 26] - in[inPos + 25] << 20 | in[inPos + 27] - in[inPos + 26] << 38 | in[inPos + 28] - in[inPos + 27] << 56;
        out[outPos + 8] = in[inPos + 28] - in[inPos + 27] >>> 8 | in[inPos + 29] - in[inPos + 28] << 10 | in[inPos + 30] - in[inPos + 29] << 28 | in[inPos + 31] - in[inPos + 30] << 46;
        out[outPos + 9] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 18 | in[inPos + 34] - in[inPos + 33] << 36 | in[inPos + 35] - in[inPos + 34] << 54;
        out[outPos + 10] = in[inPos + 35] - in[inPos + 34] >>> 10 | in[inPos + 36] - in[inPos + 35] << 8 | in[inPos + 37] - in[inPos + 36] << 26 | in[inPos + 38] - in[inPos + 37] << 44 | in[inPos + 39] - in[inPos + 38] << 62;
        out[outPos + 11] = in[inPos + 39] - in[inPos + 38] >>> 2 | in[inPos + 40] - in[inPos + 39] << 16 | in[inPos + 41] - in[inPos + 40] << 34 | in[inPos + 42] - in[inPos + 41] << 52;
        out[outPos + 12] = in[inPos + 42] - in[inPos + 41] >>> 12 | in[inPos + 43] - in[inPos + 42] << 6 | in[inPos + 44] - in[inPos + 43] << 24 | in[inPos + 45] - in[inPos + 44] << 42 | in[inPos + 46] - in[inPos + 45] << 60;
        out[outPos + 13] = in[inPos + 46] - in[inPos + 45] >>> 4 | in[inPos + 47] - in[inPos + 46] << 14 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 50;
        out[outPos + 14] = in[inPos + 49] - in[inPos + 48] >>> 14 | in[inPos + 50] - in[inPos + 49] << 4 | in[inPos + 51] - in[inPos + 50] << 22 | in[inPos + 52] - in[inPos + 51] << 40 | in[inPos + 53] - in[inPos + 52] << 58;
        out[outPos + 15] = in[inPos + 53] - in[inPos + 52] >>> 6 | in[inPos + 54] - in[inPos + 53] << 12 | in[inPos + 55] - in[inPos + 54] << 30 | in[inPos + 56] - in[inPos + 55] << 48;
        out[outPos + 16] = in[inPos + 56] - in[inPos + 55] >>> 16 | in[inPos + 57] - in[inPos + 56] << 2 | in[inPos + 58] - in[inPos + 57] << 20 | in[inPos + 59] - in[inPos + 58] << 38 | in[inPos + 60] - in[inPos + 59] << 56;
        out[outPos + 17] = in[inPos + 60] - in[inPos + 59] >>> 8 | in[inPos + 61] - in[inPos + 60] << 10 | in[inPos + 62] - in[inPos + 61] << 28 | in[inPos + 63] - in[inPos + 62] << 46;
    }

    private static void unpack18(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 18 & 0x3FFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 36 & 0x3FFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 54 | (in[inPos + 1] & 0xFFL) << 10) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 8 & 0x3FFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 26 & 0x3FFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 44 & 0x3FFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0xFFFFL) << 2) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 16 & 0x3FFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 34 & 0x3FFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 52 | (in[inPos + 3] & 0x3FL) << 12) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 6 & 0x3FFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] >>> 24 & 0x3FFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 3] >>> 42 & 0x3FFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0x3FFFL) << 4) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 4] >>> 14 & 0x3FFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 4] >>> 32 & 0x3FFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 4] >>> 50 | (in[inPos + 5] & 0xFL) << 14) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 5] >>> 4 & 0x3FFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 5] >>> 22 & 0x3FFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 5] >>> 40 & 0x3FFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 0xFFFL) << 6) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 6] >>> 12 & 0x3FFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 6] >>> 30 & 0x3FFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 6] >>> 48 | (in[inPos + 7] & 3L) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 7] >>> 2 & 0x3FFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 7] >>> 20 & 0x3FFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 7] >>> 38 & 0x3FFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0x3FFL) << 8) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 8] >>> 10 & 0x3FFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 8] >>> 28 & 0x3FFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 8] >>> 46) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 9] & 0x3FFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 9] >>> 18 & 0x3FFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 9] >>> 36 & 0x3FFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0xFFL) << 10) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 10] >>> 8 & 0x3FFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 10] >>> 26 & 0x3FFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 10] >>> 44 & 0x3FFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 10] >>> 62 | (in[inPos + 11] & 0xFFFFL) << 2) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 11] >>> 16 & 0x3FFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 11] >>> 34 & 0x3FFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0x3FL) << 12) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 12] >>> 6 & 0x3FFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 12] >>> 24 & 0x3FFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 12] >>> 42 & 0x3FFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 12] >>> 60 | (in[inPos + 13] & 0x3FFFL) << 4) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 13] >>> 14 & 0x3FFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 13] >>> 32 & 0x3FFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 13] >>> 50 | (in[inPos + 14] & 0xFL) << 14) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 14] >>> 4 & 0x3FFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 14] >>> 22 & 0x3FFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 14] >>> 40 & 0x3FFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 14] >>> 58 | (in[inPos + 15] & 0xFFFL) << 6) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 15] >>> 12 & 0x3FFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 15] >>> 30 & 0x3FFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 3L) << 16) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 16] >>> 2 & 0x3FFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 16] >>> 20 & 0x3FFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 16] >>> 38 & 0x3FFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0x3FFL) << 8) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 17] >>> 10 & 0x3FFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 17] >>> 28 & 0x3FFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 17] >>> 46) + out[outPos + 62];
    }

    private static void pack19(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 19 | in[inPos + 2] - in[inPos + 1] << 38 | in[inPos + 3] - in[inPos + 2] << 57;
        out[outPos + 1] = in[inPos + 3] - in[inPos + 2] >>> 7 | in[inPos + 4] - in[inPos + 3] << 12 | in[inPos + 5] - in[inPos + 4] << 31 | in[inPos + 6] - in[inPos + 5] << 50;
        out[outPos + 2] = in[inPos + 6] - in[inPos + 5] >>> 14 | in[inPos + 7] - in[inPos + 6] << 5 | in[inPos + 8] - in[inPos + 7] << 24 | in[inPos + 9] - in[inPos + 8] << 43 | in[inPos + 10] - in[inPos + 9] << 62;
        out[outPos + 3] = in[inPos + 10] - in[inPos + 9] >>> 2 | in[inPos + 11] - in[inPos + 10] << 17 | in[inPos + 12] - in[inPos + 11] << 36 | in[inPos + 13] - in[inPos + 12] << 55;
        out[outPos + 4] = in[inPos + 13] - in[inPos + 12] >>> 9 | in[inPos + 14] - in[inPos + 13] << 10 | in[inPos + 15] - in[inPos + 14] << 29 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 5] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 3 | in[inPos + 18] - in[inPos + 17] << 22 | in[inPos + 19] - in[inPos + 18] << 41 | in[inPos + 20] - in[inPos + 19] << 60;
        out[outPos + 6] = in[inPos + 20] - in[inPos + 19] >>> 4 | in[inPos + 21] - in[inPos + 20] << 15 | in[inPos + 22] - in[inPos + 21] << 34 | in[inPos + 23] - in[inPos + 22] << 53;
        out[outPos + 7] = in[inPos + 23] - in[inPos + 22] >>> 11 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 27 | in[inPos + 26] - in[inPos + 25] << 46;
        out[outPos + 8] = in[inPos + 26] - in[inPos + 25] >>> 18 | in[inPos + 27] - in[inPos + 26] << 1 | in[inPos + 28] - in[inPos + 27] << 20 | in[inPos + 29] - in[inPos + 28] << 39 | in[inPos + 30] - in[inPos + 29] << 58;
        out[outPos + 9] = in[inPos + 30] - in[inPos + 29] >>> 6 | in[inPos + 31] - in[inPos + 30] << 13 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 51;
        out[outPos + 10] = in[inPos + 33] - in[inPos + 32] >>> 13 | in[inPos + 34] - in[inPos + 33] << 6 | in[inPos + 35] - in[inPos + 34] << 25 | in[inPos + 36] - in[inPos + 35] << 44 | in[inPos + 37] - in[inPos + 36] << 63;
        out[outPos + 11] = in[inPos + 37] - in[inPos + 36] >>> 1 | in[inPos + 38] - in[inPos + 37] << 18 | in[inPos + 39] - in[inPos + 38] << 37 | in[inPos + 40] - in[inPos + 39] << 56;
        out[outPos + 12] = in[inPos + 40] - in[inPos + 39] >>> 8 | in[inPos + 41] - in[inPos + 40] << 11 | in[inPos + 42] - in[inPos + 41] << 30 | in[inPos + 43] - in[inPos + 42] << 49;
        out[outPos + 13] = in[inPos + 43] - in[inPos + 42] >>> 15 | in[inPos + 44] - in[inPos + 43] << 4 | in[inPos + 45] - in[inPos + 44] << 23 | in[inPos + 46] - in[inPos + 45] << 42 | in[inPos + 47] - in[inPos + 46] << 61;
        out[outPos + 14] = in[inPos + 47] - in[inPos + 46] >>> 3 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 35 | in[inPos + 50] - in[inPos + 49] << 54;
        out[outPos + 15] = in[inPos + 50] - in[inPos + 49] >>> 10 | in[inPos + 51] - in[inPos + 50] << 9 | in[inPos + 52] - in[inPos + 51] << 28 | in[inPos + 53] - in[inPos + 52] << 47;
        out[outPos + 16] = in[inPos + 53] - in[inPos + 52] >>> 17 | in[inPos + 54] - in[inPos + 53] << 2 | in[inPos + 55] - in[inPos + 54] << 21 | in[inPos + 56] - in[inPos + 55] << 40 | in[inPos + 57] - in[inPos + 56] << 59;
        out[outPos + 17] = in[inPos + 57] - in[inPos + 56] >>> 5 | in[inPos + 58] - in[inPos + 57] << 14 | in[inPos + 59] - in[inPos + 58] << 33 | in[inPos + 60] - in[inPos + 59] << 52;
        out[outPos + 18] = in[inPos + 60] - in[inPos + 59] >>> 12 | in[inPos + 61] - in[inPos + 60] << 7 | in[inPos + 62] - in[inPos + 61] << 26 | in[inPos + 63] - in[inPos + 62] << 45;
    }

    private static void unpack19(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 19 & 0x7FFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 38 & 0x7FFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 57 | (in[inPos + 1] & 0xFFFL) << 7) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 12 & 0x7FFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 31 & 0x7FFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 50 | (in[inPos + 2] & 0x1FL) << 14) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 5 & 0x7FFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 24 & 0x7FFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 43 & 0x7FFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 2] >>> 62 | (in[inPos + 3] & 0x1FFFFL) << 2) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 17 & 0x7FFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] >>> 36 & 0x7FFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 3] >>> 55 | (in[inPos + 4] & 0x3FFL) << 9) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 4] >>> 10 & 0x7FFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 4] >>> 29 & 0x7FFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 4] >>> 48 | (in[inPos + 5] & 7L) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 5] >>> 3 & 0x7FFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 5] >>> 22 & 0x7FFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 5] >>> 41 & 0x7FFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 5] >>> 60 | (in[inPos + 6] & 0x7FFFL) << 4) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 6] >>> 15 & 0x7FFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 6] >>> 34 & 0x7FFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 6] >>> 53 | (in[inPos + 7] & 0xFFL) << 11) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 7] >>> 8 & 0x7FFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 7] >>> 27 & 0x7FFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 7] >>> 46 | (in[inPos + 8] & 1L) << 18) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 8] >>> 1 & 0x7FFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 8] >>> 20 & 0x7FFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 8] >>> 39 & 0x7FFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 8] >>> 58 | (in[inPos + 9] & 0x1FFFL) << 6) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 9] >>> 13 & 0x7FFFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 9] >>> 32 & 0x7FFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 9] >>> 51 | (in[inPos + 10] & 0x3FL) << 13) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 10] >>> 6 & 0x7FFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 10] >>> 25 & 0x7FFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 10] >>> 44 & 0x7FFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 10] >>> 63 | (in[inPos + 11] & 0x3FFFFL) << 1) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 11] >>> 18 & 0x7FFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 11] >>> 37 & 0x7FFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 11] >>> 56 | (in[inPos + 12] & 0x7FFL) << 8) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 12] >>> 11 & 0x7FFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 12] >>> 30 & 0x7FFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 12] >>> 49 | (in[inPos + 13] & 0xFL) << 15) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 13] >>> 4 & 0x7FFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 13] >>> 23 & 0x7FFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 13] >>> 42 & 0x7FFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 13] >>> 61 | (in[inPos + 14] & 0xFFFFL) << 3) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 14] >>> 16 & 0x7FFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 14] >>> 35 & 0x7FFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 14] >>> 54 | (in[inPos + 15] & 0x1FFL) << 10) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 15] >>> 9 & 0x7FFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 15] >>> 28 & 0x7FFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 15] >>> 47 | (in[inPos + 16] & 3L) << 17) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 16] >>> 2 & 0x7FFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 16] >>> 21 & 0x7FFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 16] >>> 40 & 0x7FFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 16] >>> 59 | (in[inPos + 17] & 0x3FFFL) << 5) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 17] >>> 14 & 0x7FFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 17] >>> 33 & 0x7FFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 17] >>> 52 | (in[inPos + 18] & 0x7FL) << 12) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 18] >>> 7 & 0x7FFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 18] >>> 26 & 0x7FFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 18] >>> 45) + out[outPos + 62];
    }

    private static void pack20(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 20 | in[inPos + 2] - in[inPos + 1] << 40 | in[inPos + 3] - in[inPos + 2] << 60;
        out[outPos + 1] = in[inPos + 3] - in[inPos + 2] >>> 4 | in[inPos + 4] - in[inPos + 3] << 16 | in[inPos + 5] - in[inPos + 4] << 36 | in[inPos + 6] - in[inPos + 5] << 56;
        out[outPos + 2] = in[inPos + 6] - in[inPos + 5] >>> 8 | in[inPos + 7] - in[inPos + 6] << 12 | in[inPos + 8] - in[inPos + 7] << 32 | in[inPos + 9] - in[inPos + 8] << 52;
        out[outPos + 3] = in[inPos + 9] - in[inPos + 8] >>> 12 | in[inPos + 10] - in[inPos + 9] << 8 | in[inPos + 11] - in[inPos + 10] << 28 | in[inPos + 12] - in[inPos + 11] << 48;
        out[outPos + 4] = in[inPos + 12] - in[inPos + 11] >>> 16 | in[inPos + 13] - in[inPos + 12] << 4 | in[inPos + 14] - in[inPos + 13] << 24 | in[inPos + 15] - in[inPos + 14] << 44;
        out[outPos + 5] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 20 | in[inPos + 18] - in[inPos + 17] << 40 | in[inPos + 19] - in[inPos + 18] << 60;
        out[outPos + 6] = in[inPos + 19] - in[inPos + 18] >>> 4 | in[inPos + 20] - in[inPos + 19] << 16 | in[inPos + 21] - in[inPos + 20] << 36 | in[inPos + 22] - in[inPos + 21] << 56;
        out[outPos + 7] = in[inPos + 22] - in[inPos + 21] >>> 8 | in[inPos + 23] - in[inPos + 22] << 12 | in[inPos + 24] - in[inPos + 23] << 32 | in[inPos + 25] - in[inPos + 24] << 52;
        out[outPos + 8] = in[inPos + 25] - in[inPos + 24] >>> 12 | in[inPos + 26] - in[inPos + 25] << 8 | in[inPos + 27] - in[inPos + 26] << 28 | in[inPos + 28] - in[inPos + 27] << 48;
        out[outPos + 9] = in[inPos + 28] - in[inPos + 27] >>> 16 | in[inPos + 29] - in[inPos + 28] << 4 | in[inPos + 30] - in[inPos + 29] << 24 | in[inPos + 31] - in[inPos + 30] << 44;
        out[outPos + 10] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 20 | in[inPos + 34] - in[inPos + 33] << 40 | in[inPos + 35] - in[inPos + 34] << 60;
        out[outPos + 11] = in[inPos + 35] - in[inPos + 34] >>> 4 | in[inPos + 36] - in[inPos + 35] << 16 | in[inPos + 37] - in[inPos + 36] << 36 | in[inPos + 38] - in[inPos + 37] << 56;
        out[outPos + 12] = in[inPos + 38] - in[inPos + 37] >>> 8 | in[inPos + 39] - in[inPos + 38] << 12 | in[inPos + 40] - in[inPos + 39] << 32 | in[inPos + 41] - in[inPos + 40] << 52;
        out[outPos + 13] = in[inPos + 41] - in[inPos + 40] >>> 12 | in[inPos + 42] - in[inPos + 41] << 8 | in[inPos + 43] - in[inPos + 42] << 28 | in[inPos + 44] - in[inPos + 43] << 48;
        out[outPos + 14] = in[inPos + 44] - in[inPos + 43] >>> 16 | in[inPos + 45] - in[inPos + 44] << 4 | in[inPos + 46] - in[inPos + 45] << 24 | in[inPos + 47] - in[inPos + 46] << 44;
        out[outPos + 15] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 20 | in[inPos + 50] - in[inPos + 49] << 40 | in[inPos + 51] - in[inPos + 50] << 60;
        out[outPos + 16] = in[inPos + 51] - in[inPos + 50] >>> 4 | in[inPos + 52] - in[inPos + 51] << 16 | in[inPos + 53] - in[inPos + 52] << 36 | in[inPos + 54] - in[inPos + 53] << 56;
        out[outPos + 17] = in[inPos + 54] - in[inPos + 53] >>> 8 | in[inPos + 55] - in[inPos + 54] << 12 | in[inPos + 56] - in[inPos + 55] << 32 | in[inPos + 57] - in[inPos + 56] << 52;
        out[outPos + 18] = in[inPos + 57] - in[inPos + 56] >>> 12 | in[inPos + 58] - in[inPos + 57] << 8 | in[inPos + 59] - in[inPos + 58] << 28 | in[inPos + 60] - in[inPos + 59] << 48;
        out[outPos + 19] = in[inPos + 60] - in[inPos + 59] >>> 16 | in[inPos + 61] - in[inPos + 60] << 4 | in[inPos + 62] - in[inPos + 61] << 24 | in[inPos + 63] - in[inPos + 62] << 44;
    }

    private static void unpack20(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 20 & 0xFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 40 & 0xFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 60 | (in[inPos + 1] & 0xFFFFL) << 4) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 16 & 0xFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 36 & 0xFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 0xFFFL) << 8) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 12 & 0xFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 32 & 0xFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 52 | (in[inPos + 3] & 0xFFL) << 12) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 8 & 0xFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 28 & 0xFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] >>> 48 | (in[inPos + 4] & 0xFL) << 16) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 4 & 0xFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 4] >>> 24 & 0xFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 4] >>> 44) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 5] & 0xFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 5] >>> 20 & 0xFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 5] >>> 40 & 0xFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 5] >>> 60 | (in[inPos + 6] & 0xFFFFL) << 4) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 6] >>> 16 & 0xFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 6] >>> 36 & 0xFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 6] >>> 56 | (in[inPos + 7] & 0xFFFL) << 8) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 7] >>> 12 & 0xFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 7] >>> 32 & 0xFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 7] >>> 52 | (in[inPos + 8] & 0xFFL) << 12) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 8] >>> 8 & 0xFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 8] >>> 28 & 0xFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 8] >>> 48 | (in[inPos + 9] & 0xFL) << 16) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 9] >>> 4 & 0xFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 9] >>> 24 & 0xFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 9] >>> 44) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 10] & 0xFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 10] >>> 20 & 0xFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 10] >>> 40 & 0xFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 10] >>> 60 | (in[inPos + 11] & 0xFFFFL) << 4) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 11] >>> 16 & 0xFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 11] >>> 36 & 0xFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 11] >>> 56 | (in[inPos + 12] & 0xFFFL) << 8) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 12] >>> 12 & 0xFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 12] >>> 32 & 0xFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 12] >>> 52 | (in[inPos + 13] & 0xFFL) << 12) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 13] >>> 8 & 0xFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 13] >>> 28 & 0xFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 13] >>> 48 | (in[inPos + 14] & 0xFL) << 16) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 14] >>> 4 & 0xFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 14] >>> 24 & 0xFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 14] >>> 44) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 15] & 0xFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 15] >>> 20 & 0xFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 15] >>> 40 & 0xFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 15] >>> 60 | (in[inPos + 16] & 0xFFFFL) << 4) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 16] >>> 16 & 0xFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 16] >>> 36 & 0xFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0xFFFL) << 8) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 17] >>> 12 & 0xFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 17] >>> 32 & 0xFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 17] >>> 52 | (in[inPos + 18] & 0xFFL) << 12) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 18] >>> 8 & 0xFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 18] >>> 28 & 0xFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0xFL) << 16) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 19] >>> 4 & 0xFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 19] >>> 24 & 0xFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 19] >>> 44) + out[outPos + 62];
    }

    private static void pack21(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 21 | in[inPos + 2] - in[inPos + 1] << 42 | in[inPos + 3] - in[inPos + 2] << 63;
        out[outPos + 1] = in[inPos + 3] - in[inPos + 2] >>> 1 | in[inPos + 4] - in[inPos + 3] << 20 | in[inPos + 5] - in[inPos + 4] << 41 | in[inPos + 6] - in[inPos + 5] << 62;
        out[outPos + 2] = in[inPos + 6] - in[inPos + 5] >>> 2 | in[inPos + 7] - in[inPos + 6] << 19 | in[inPos + 8] - in[inPos + 7] << 40 | in[inPos + 9] - in[inPos + 8] << 61;
        out[outPos + 3] = in[inPos + 9] - in[inPos + 8] >>> 3 | in[inPos + 10] - in[inPos + 9] << 18 | in[inPos + 11] - in[inPos + 10] << 39 | in[inPos + 12] - in[inPos + 11] << 60;
        out[outPos + 4] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 17 | in[inPos + 14] - in[inPos + 13] << 38 | in[inPos + 15] - in[inPos + 14] << 59;
        out[outPos + 5] = in[inPos + 15] - in[inPos + 14] >>> 5 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 37 | in[inPos + 18] - in[inPos + 17] << 58;
        out[outPos + 6] = in[inPos + 18] - in[inPos + 17] >>> 6 | in[inPos + 19] - in[inPos + 18] << 15 | in[inPos + 20] - in[inPos + 19] << 36 | in[inPos + 21] - in[inPos + 20] << 57;
        out[outPos + 7] = in[inPos + 21] - in[inPos + 20] >>> 7 | in[inPos + 22] - in[inPos + 21] << 14 | in[inPos + 23] - in[inPos + 22] << 35 | in[inPos + 24] - in[inPos + 23] << 56;
        out[outPos + 8] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 13 | in[inPos + 26] - in[inPos + 25] << 34 | in[inPos + 27] - in[inPos + 26] << 55;
        out[outPos + 9] = in[inPos + 27] - in[inPos + 26] >>> 9 | in[inPos + 28] - in[inPos + 27] << 12 | in[inPos + 29] - in[inPos + 28] << 33 | in[inPos + 30] - in[inPos + 29] << 54;
        out[outPos + 10] = in[inPos + 30] - in[inPos + 29] >>> 10 | in[inPos + 31] - in[inPos + 30] << 11 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 53;
        out[outPos + 11] = in[inPos + 33] - in[inPos + 32] >>> 11 | in[inPos + 34] - in[inPos + 33] << 10 | in[inPos + 35] - in[inPos + 34] << 31 | in[inPos + 36] - in[inPos + 35] << 52;
        out[outPos + 12] = in[inPos + 36] - in[inPos + 35] >>> 12 | in[inPos + 37] - in[inPos + 36] << 9 | in[inPos + 38] - in[inPos + 37] << 30 | in[inPos + 39] - in[inPos + 38] << 51;
        out[outPos + 13] = in[inPos + 39] - in[inPos + 38] >>> 13 | in[inPos + 40] - in[inPos + 39] << 8 | in[inPos + 41] - in[inPos + 40] << 29 | in[inPos + 42] - in[inPos + 41] << 50;
        out[outPos + 14] = in[inPos + 42] - in[inPos + 41] >>> 14 | in[inPos + 43] - in[inPos + 42] << 7 | in[inPos + 44] - in[inPos + 43] << 28 | in[inPos + 45] - in[inPos + 44] << 49;
        out[outPos + 15] = in[inPos + 45] - in[inPos + 44] >>> 15 | in[inPos + 46] - in[inPos + 45] << 6 | in[inPos + 47] - in[inPos + 46] << 27 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 16] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 5 | in[inPos + 50] - in[inPos + 49] << 26 | in[inPos + 51] - in[inPos + 50] << 47;
        out[outPos + 17] = in[inPos + 51] - in[inPos + 50] >>> 17 | in[inPos + 52] - in[inPos + 51] << 4 | in[inPos + 53] - in[inPos + 52] << 25 | in[inPos + 54] - in[inPos + 53] << 46;
        out[outPos + 18] = in[inPos + 54] - in[inPos + 53] >>> 18 | in[inPos + 55] - in[inPos + 54] << 3 | in[inPos + 56] - in[inPos + 55] << 24 | in[inPos + 57] - in[inPos + 56] << 45;
        out[outPos + 19] = in[inPos + 57] - in[inPos + 56] >>> 19 | in[inPos + 58] - in[inPos + 57] << 2 | in[inPos + 59] - in[inPos + 58] << 23 | in[inPos + 60] - in[inPos + 59] << 44;
        out[outPos + 20] = in[inPos + 60] - in[inPos + 59] >>> 20 | in[inPos + 61] - in[inPos + 60] << 1 | in[inPos + 62] - in[inPos + 61] << 22 | in[inPos + 63] - in[inPos + 62] << 43;
    }

    private static void unpack21(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 21 & 0x1FFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 42 & 0x1FFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos] >>> 63 | (in[inPos + 1] & 0xFFFFFL) << 1) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 20 & 0x1FFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 41 & 0x1FFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0x7FFFFL) << 2) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 19 & 0x1FFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 40 & 0x1FFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 2] >>> 61 | (in[inPos + 3] & 0x3FFFFL) << 3) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 18 & 0x1FFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 39 & 0x1FFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0x1FFFFL) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 17 & 0x1FFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 4] >>> 38 & 0x1FFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 4] >>> 59 | (in[inPos + 5] & 0xFFFFL) << 5) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 5] >>> 16 & 0x1FFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 5] >>> 37 & 0x1FFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 0x7FFFL) << 6) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 6] >>> 15 & 0x1FFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 6] >>> 36 & 0x1FFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 6] >>> 57 | (in[inPos + 7] & 0x3FFFL) << 7) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 7] >>> 14 & 0x1FFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 7] >>> 35 & 0x1FFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0x1FFFL) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 8] >>> 13 & 0x1FFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 8] >>> 34 & 0x1FFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 8] >>> 55 | (in[inPos + 9] & 0xFFFL) << 9) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 9] >>> 12 & 0x1FFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 9] >>> 33 & 0x1FFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0x7FFL) << 10) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 10] >>> 11 & 0x1FFFFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 10] >>> 32 & 0x1FFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 10] >>> 53 | (in[inPos + 11] & 0x3FFL) << 11) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 11] >>> 10 & 0x1FFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 11] >>> 31 & 0x1FFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0x1FFL) << 12) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 12] >>> 9 & 0x1FFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 12] >>> 30 & 0x1FFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 12] >>> 51 | (in[inPos + 13] & 0xFFL) << 13) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 13] >>> 8 & 0x1FFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 13] >>> 29 & 0x1FFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 13] >>> 50 | (in[inPos + 14] & 0x7FL) << 14) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 14] >>> 7 & 0x1FFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 14] >>> 28 & 0x1FFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 14] >>> 49 | (in[inPos + 15] & 0x3FL) << 15) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 15] >>> 6 & 0x1FFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 15] >>> 27 & 0x1FFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0x1FL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 16] >>> 5 & 0x1FFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 16] >>> 26 & 0x1FFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 16] >>> 47 | (in[inPos + 17] & 0xFL) << 17) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 17] >>> 4 & 0x1FFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 17] >>> 25 & 0x1FFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 17] >>> 46 | (in[inPos + 18] & 7L) << 18) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 18] >>> 3 & 0x1FFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 18] >>> 24 & 0x1FFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 18] >>> 45 | (in[inPos + 19] & 3L) << 19) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 19] >>> 2 & 0x1FFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 19] >>> 23 & 0x1FFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 1L) << 20) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 20] >>> 1 & 0x1FFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 20] >>> 22 & 0x1FFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 20] >>> 43) + out[outPos + 62];
    }

    private static void pack22(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 22 | in[inPos + 2] - in[inPos + 1] << 44;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 20 | in[inPos + 3] - in[inPos + 2] << 2 | in[inPos + 4] - in[inPos + 3] << 24 | in[inPos + 5] - in[inPos + 4] << 46;
        out[outPos + 2] = in[inPos + 5] - in[inPos + 4] >>> 18 | in[inPos + 6] - in[inPos + 5] << 4 | in[inPos + 7] - in[inPos + 6] << 26 | in[inPos + 8] - in[inPos + 7] << 48;
        out[outPos + 3] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 6 | in[inPos + 10] - in[inPos + 9] << 28 | in[inPos + 11] - in[inPos + 10] << 50;
        out[outPos + 4] = in[inPos + 11] - in[inPos + 10] >>> 14 | in[inPos + 12] - in[inPos + 11] << 8 | in[inPos + 13] - in[inPos + 12] << 30 | in[inPos + 14] - in[inPos + 13] << 52;
        out[outPos + 5] = in[inPos + 14] - in[inPos + 13] >>> 12 | in[inPos + 15] - in[inPos + 14] << 10 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 54;
        out[outPos + 6] = in[inPos + 17] - in[inPos + 16] >>> 10 | in[inPos + 18] - in[inPos + 17] << 12 | in[inPos + 19] - in[inPos + 18] << 34 | in[inPos + 20] - in[inPos + 19] << 56;
        out[outPos + 7] = in[inPos + 20] - in[inPos + 19] >>> 8 | in[inPos + 21] - in[inPos + 20] << 14 | in[inPos + 22] - in[inPos + 21] << 36 | in[inPos + 23] - in[inPos + 22] << 58;
        out[outPos + 8] = in[inPos + 23] - in[inPos + 22] >>> 6 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 38 | in[inPos + 26] - in[inPos + 25] << 60;
        out[outPos + 9] = in[inPos + 26] - in[inPos + 25] >>> 4 | in[inPos + 27] - in[inPos + 26] << 18 | in[inPos + 28] - in[inPos + 27] << 40 | in[inPos + 29] - in[inPos + 28] << 62;
        out[outPos + 10] = in[inPos + 29] - in[inPos + 28] >>> 2 | in[inPos + 30] - in[inPos + 29] << 20 | in[inPos + 31] - in[inPos + 30] << 42;
        out[outPos + 11] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 22 | in[inPos + 34] - in[inPos + 33] << 44;
        out[outPos + 12] = in[inPos + 34] - in[inPos + 33] >>> 20 | in[inPos + 35] - in[inPos + 34] << 2 | in[inPos + 36] - in[inPos + 35] << 24 | in[inPos + 37] - in[inPos + 36] << 46;
        out[outPos + 13] = in[inPos + 37] - in[inPos + 36] >>> 18 | in[inPos + 38] - in[inPos + 37] << 4 | in[inPos + 39] - in[inPos + 38] << 26 | in[inPos + 40] - in[inPos + 39] << 48;
        out[outPos + 14] = in[inPos + 40] - in[inPos + 39] >>> 16 | in[inPos + 41] - in[inPos + 40] << 6 | in[inPos + 42] - in[inPos + 41] << 28 | in[inPos + 43] - in[inPos + 42] << 50;
        out[outPos + 15] = in[inPos + 43] - in[inPos + 42] >>> 14 | in[inPos + 44] - in[inPos + 43] << 8 | in[inPos + 45] - in[inPos + 44] << 30 | in[inPos + 46] - in[inPos + 45] << 52;
        out[outPos + 16] = in[inPos + 46] - in[inPos + 45] >>> 12 | in[inPos + 47] - in[inPos + 46] << 10 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 54;
        out[outPos + 17] = in[inPos + 49] - in[inPos + 48] >>> 10 | in[inPos + 50] - in[inPos + 49] << 12 | in[inPos + 51] - in[inPos + 50] << 34 | in[inPos + 52] - in[inPos + 51] << 56;
        out[outPos + 18] = in[inPos + 52] - in[inPos + 51] >>> 8 | in[inPos + 53] - in[inPos + 52] << 14 | in[inPos + 54] - in[inPos + 53] << 36 | in[inPos + 55] - in[inPos + 54] << 58;
        out[outPos + 19] = in[inPos + 55] - in[inPos + 54] >>> 6 | in[inPos + 56] - in[inPos + 55] << 16 | in[inPos + 57] - in[inPos + 56] << 38 | in[inPos + 58] - in[inPos + 57] << 60;
        out[outPos + 20] = in[inPos + 58] - in[inPos + 57] >>> 4 | in[inPos + 59] - in[inPos + 58] << 18 | in[inPos + 60] - in[inPos + 59] << 40 | in[inPos + 61] - in[inPos + 60] << 62;
        out[outPos + 21] = in[inPos + 61] - in[inPos + 60] >>> 2 | in[inPos + 62] - in[inPos + 61] << 20 | in[inPos + 63] - in[inPos + 62] << 42;
    }

    private static void unpack22(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 22 & 0x3FFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 44 | (in[inPos + 1] & 3L) << 20) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 2 & 0x3FFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 24 & 0x3FFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 46 | (in[inPos + 2] & 0xFL) << 18) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 4 & 0x3FFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 26 & 0x3FFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 48 | (in[inPos + 3] & 0x3FL) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 6 & 0x3FFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 28 & 0x3FFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 50 | (in[inPos + 4] & 0xFFL) << 14) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 8 & 0x3FFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 30 & 0x3FFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 4] >>> 52 | (in[inPos + 5] & 0x3FFL) << 12) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 5] >>> 10 & 0x3FFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 5] >>> 32 & 0x3FFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 5] >>> 54 | (in[inPos + 6] & 0xFFFL) << 10) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 6] >>> 12 & 0x3FFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 6] >>> 34 & 0x3FFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 6] >>> 56 | (in[inPos + 7] & 0x3FFFL) << 8) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 7] >>> 14 & 0x3FFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 7] >>> 36 & 0x3FFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 7] >>> 58 | (in[inPos + 8] & 0xFFFFL) << 6) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 8] >>> 16 & 0x3FFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 8] >>> 38 & 0x3FFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 8] >>> 60 | (in[inPos + 9] & 0x3FFFFL) << 4) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 9] >>> 18 & 0x3FFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 9] >>> 40 & 0x3FFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 9] >>> 62 | (in[inPos + 10] & 0xFFFFFL) << 2) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 10] >>> 20 & 0x3FFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 10] >>> 42) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 11] & 0x3FFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 11] >>> 22 & 0x3FFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 11] >>> 44 | (in[inPos + 12] & 3L) << 20) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 12] >>> 2 & 0x3FFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 12] >>> 24 & 0x3FFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 12] >>> 46 | (in[inPos + 13] & 0xFL) << 18) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 13] >>> 4 & 0x3FFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 13] >>> 26 & 0x3FFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 13] >>> 48 | (in[inPos + 14] & 0x3FL) << 16) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 14] >>> 6 & 0x3FFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 14] >>> 28 & 0x3FFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 14] >>> 50 | (in[inPos + 15] & 0xFFL) << 14) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 15] >>> 8 & 0x3FFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 15] >>> 30 & 0x3FFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 15] >>> 52 | (in[inPos + 16] & 0x3FFL) << 12) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 16] >>> 10 & 0x3FFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 16] >>> 32 & 0x3FFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 16] >>> 54 | (in[inPos + 17] & 0xFFFL) << 10) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 17] >>> 12 & 0x3FFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 17] >>> 34 & 0x3FFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 17] >>> 56 | (in[inPos + 18] & 0x3FFFL) << 8) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 18] >>> 14 & 0x3FFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 18] >>> 36 & 0x3FFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 18] >>> 58 | (in[inPos + 19] & 0xFFFFL) << 6) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 19] >>> 16 & 0x3FFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 19] >>> 38 & 0x3FFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 19] >>> 60 | (in[inPos + 20] & 0x3FFFFL) << 4) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 20] >>> 18 & 0x3FFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 20] >>> 40 & 0x3FFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 20] >>> 62 | (in[inPos + 21] & 0xFFFFFL) << 2) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 21] >>> 20 & 0x3FFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 21] >>> 42) + out[outPos + 62];
    }

    private static void pack23(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 23 | in[inPos + 2] - in[inPos + 1] << 46;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 18 | in[inPos + 3] - in[inPos + 2] << 5 | in[inPos + 4] - in[inPos + 3] << 28 | in[inPos + 5] - in[inPos + 4] << 51;
        out[outPos + 2] = in[inPos + 5] - in[inPos + 4] >>> 13 | in[inPos + 6] - in[inPos + 5] << 10 | in[inPos + 7] - in[inPos + 6] << 33 | in[inPos + 8] - in[inPos + 7] << 56;
        out[outPos + 3] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 15 | in[inPos + 10] - in[inPos + 9] << 38 | in[inPos + 11] - in[inPos + 10] << 61;
        out[outPos + 4] = in[inPos + 11] - in[inPos + 10] >>> 3 | in[inPos + 12] - in[inPos + 11] << 20 | in[inPos + 13] - in[inPos + 12] << 43;
        out[outPos + 5] = in[inPos + 13] - in[inPos + 12] >>> 21 | in[inPos + 14] - in[inPos + 13] << 2 | in[inPos + 15] - in[inPos + 14] << 25 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 6] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 7 | in[inPos + 18] - in[inPos + 17] << 30 | in[inPos + 19] - in[inPos + 18] << 53;
        out[outPos + 7] = in[inPos + 19] - in[inPos + 18] >>> 11 | in[inPos + 20] - in[inPos + 19] << 12 | in[inPos + 21] - in[inPos + 20] << 35 | in[inPos + 22] - in[inPos + 21] << 58;
        out[outPos + 8] = in[inPos + 22] - in[inPos + 21] >>> 6 | in[inPos + 23] - in[inPos + 22] << 17 | in[inPos + 24] - in[inPos + 23] << 40 | in[inPos + 25] - in[inPos + 24] << 63;
        out[outPos + 9] = in[inPos + 25] - in[inPos + 24] >>> 1 | in[inPos + 26] - in[inPos + 25] << 22 | in[inPos + 27] - in[inPos + 26] << 45;
        out[outPos + 10] = in[inPos + 27] - in[inPos + 26] >>> 19 | in[inPos + 28] - in[inPos + 27] << 4 | in[inPos + 29] - in[inPos + 28] << 27 | in[inPos + 30] - in[inPos + 29] << 50;
        out[outPos + 11] = in[inPos + 30] - in[inPos + 29] >>> 14 | in[inPos + 31] - in[inPos + 30] << 9 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 55;
        out[outPos + 12] = in[inPos + 33] - in[inPos + 32] >>> 9 | in[inPos + 34] - in[inPos + 33] << 14 | in[inPos + 35] - in[inPos + 34] << 37 | in[inPos + 36] - in[inPos + 35] << 60;
        out[outPos + 13] = in[inPos + 36] - in[inPos + 35] >>> 4 | in[inPos + 37] - in[inPos + 36] << 19 | in[inPos + 38] - in[inPos + 37] << 42;
        out[outPos + 14] = in[inPos + 38] - in[inPos + 37] >>> 22 | in[inPos + 39] - in[inPos + 38] << 1 | in[inPos + 40] - in[inPos + 39] << 24 | in[inPos + 41] - in[inPos + 40] << 47;
        out[outPos + 15] = in[inPos + 41] - in[inPos + 40] >>> 17 | in[inPos + 42] - in[inPos + 41] << 6 | in[inPos + 43] - in[inPos + 42] << 29 | in[inPos + 44] - in[inPos + 43] << 52;
        out[outPos + 16] = in[inPos + 44] - in[inPos + 43] >>> 12 | in[inPos + 45] - in[inPos + 44] << 11 | in[inPos + 46] - in[inPos + 45] << 34 | in[inPos + 47] - in[inPos + 46] << 57;
        out[outPos + 17] = in[inPos + 47] - in[inPos + 46] >>> 7 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 39 | in[inPos + 50] - in[inPos + 49] << 62;
        out[outPos + 18] = in[inPos + 50] - in[inPos + 49] >>> 2 | in[inPos + 51] - in[inPos + 50] << 21 | in[inPos + 52] - in[inPos + 51] << 44;
        out[outPos + 19] = in[inPos + 52] - in[inPos + 51] >>> 20 | in[inPos + 53] - in[inPos + 52] << 3 | in[inPos + 54] - in[inPos + 53] << 26 | in[inPos + 55] - in[inPos + 54] << 49;
        out[outPos + 20] = in[inPos + 55] - in[inPos + 54] >>> 15 | in[inPos + 56] - in[inPos + 55] << 8 | in[inPos + 57] - in[inPos + 56] << 31 | in[inPos + 58] - in[inPos + 57] << 54;
        out[outPos + 21] = in[inPos + 58] - in[inPos + 57] >>> 10 | in[inPos + 59] - in[inPos + 58] << 13 | in[inPos + 60] - in[inPos + 59] << 36 | in[inPos + 61] - in[inPos + 60] << 59;
        out[outPos + 22] = in[inPos + 61] - in[inPos + 60] >>> 5 | in[inPos + 62] - in[inPos + 61] << 18 | in[inPos + 63] - in[inPos + 62] << 41;
    }

    private static void unpack23(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 23 & 0x7FFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 46 | (in[inPos + 1] & 0x1FL) << 18) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 5 & 0x7FFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 28 & 0x7FFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 51 | (in[inPos + 2] & 0x3FFL) << 13) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 10 & 0x7FFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 33 & 0x7FFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 2] >>> 56 | (in[inPos + 3] & 0x7FFFL) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 15 & 0x7FFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 38 & 0x7FFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 3] >>> 61 | (in[inPos + 4] & 0xFFFFFL) << 3) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 20 & 0x7FFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 43 | (in[inPos + 5] & 3L) << 21) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 5] >>> 2 & 0x7FFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 5] >>> 25 & 0x7FFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 5] >>> 48 | (in[inPos + 6] & 0x7FL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 6] >>> 7 & 0x7FFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 6] >>> 30 & 0x7FFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 6] >>> 53 | (in[inPos + 7] & 0xFFFL) << 11) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 7] >>> 12 & 0x7FFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 7] >>> 35 & 0x7FFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 7] >>> 58 | (in[inPos + 8] & 0x1FFFFL) << 6) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 8] >>> 17 & 0x7FFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 8] >>> 40 & 0x7FFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 8] >>> 63 | (in[inPos + 9] & 0x3FFFFFL) << 1) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 9] >>> 22 & 0x7FFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 9] >>> 45 | (in[inPos + 10] & 0xFL) << 19) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 10] >>> 4 & 0x7FFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 10] >>> 27 & 0x7FFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 10] >>> 50 | (in[inPos + 11] & 0x1FFL) << 14) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 11] >>> 9 & 0x7FFFFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 11] >>> 32 & 0x7FFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 11] >>> 55 | (in[inPos + 12] & 0x3FFFL) << 9) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 12] >>> 14 & 0x7FFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 12] >>> 37 & 0x7FFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 12] >>> 60 | (in[inPos + 13] & 0x7FFFFL) << 4) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 13] >>> 19 & 0x7FFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 13] >>> 42 | (in[inPos + 14] & 1L) << 22) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 14] >>> 1 & 0x7FFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 14] >>> 24 & 0x7FFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 14] >>> 47 | (in[inPos + 15] & 0x3FL) << 17) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 15] >>> 6 & 0x7FFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 15] >>> 29 & 0x7FFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 15] >>> 52 | (in[inPos + 16] & 0x7FFL) << 12) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 16] >>> 11 & 0x7FFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 16] >>> 34 & 0x7FFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 16] >>> 57 | (in[inPos + 17] & 0xFFFFL) << 7) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 17] >>> 16 & 0x7FFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 17] >>> 39 & 0x7FFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 17] >>> 62 | (in[inPos + 18] & 0x1FFFFFL) << 2) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 18] >>> 21 & 0x7FFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 18] >>> 44 | (in[inPos + 19] & 7L) << 20) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 19] >>> 3 & 0x7FFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 19] >>> 26 & 0x7FFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 19] >>> 49 | (in[inPos + 20] & 0xFFL) << 15) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 20] >>> 8 & 0x7FFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 20] >>> 31 & 0x7FFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 20] >>> 54 | (in[inPos + 21] & 0x1FFFL) << 10) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 21] >>> 13 & 0x7FFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 21] >>> 36 & 0x7FFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 21] >>> 59 | (in[inPos + 22] & 0x3FFFFL) << 5) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 22] >>> 18 & 0x7FFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 22] >>> 41) + out[outPos + 62];
    }

    private static void pack24(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 24 | in[inPos + 2] - in[inPos + 1] << 48;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 16 | in[inPos + 3] - in[inPos + 2] << 8 | in[inPos + 4] - in[inPos + 3] << 32 | in[inPos + 5] - in[inPos + 4] << 56;
        out[outPos + 2] = in[inPos + 5] - in[inPos + 4] >>> 8 | in[inPos + 6] - in[inPos + 5] << 16 | in[inPos + 7] - in[inPos + 6] << 40;
        out[outPos + 3] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 24 | in[inPos + 10] - in[inPos + 9] << 48;
        out[outPos + 4] = in[inPos + 10] - in[inPos + 9] >>> 16 | in[inPos + 11] - in[inPos + 10] << 8 | in[inPos + 12] - in[inPos + 11] << 32 | in[inPos + 13] - in[inPos + 12] << 56;
        out[outPos + 5] = in[inPos + 13] - in[inPos + 12] >>> 8 | in[inPos + 14] - in[inPos + 13] << 16 | in[inPos + 15] - in[inPos + 14] << 40;
        out[outPos + 6] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 24 | in[inPos + 18] - in[inPos + 17] << 48;
        out[outPos + 7] = in[inPos + 18] - in[inPos + 17] >>> 16 | in[inPos + 19] - in[inPos + 18] << 8 | in[inPos + 20] - in[inPos + 19] << 32 | in[inPos + 21] - in[inPos + 20] << 56;
        out[outPos + 8] = in[inPos + 21] - in[inPos + 20] >>> 8 | in[inPos + 22] - in[inPos + 21] << 16 | in[inPos + 23] - in[inPos + 22] << 40;
        out[outPos + 9] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 24 | in[inPos + 26] - in[inPos + 25] << 48;
        out[outPos + 10] = in[inPos + 26] - in[inPos + 25] >>> 16 | in[inPos + 27] - in[inPos + 26] << 8 | in[inPos + 28] - in[inPos + 27] << 32 | in[inPos + 29] - in[inPos + 28] << 56;
        out[outPos + 11] = in[inPos + 29] - in[inPos + 28] >>> 8 | in[inPos + 30] - in[inPos + 29] << 16 | in[inPos + 31] - in[inPos + 30] << 40;
        out[outPos + 12] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 24 | in[inPos + 34] - in[inPos + 33] << 48;
        out[outPos + 13] = in[inPos + 34] - in[inPos + 33] >>> 16 | in[inPos + 35] - in[inPos + 34] << 8 | in[inPos + 36] - in[inPos + 35] << 32 | in[inPos + 37] - in[inPos + 36] << 56;
        out[outPos + 14] = in[inPos + 37] - in[inPos + 36] >>> 8 | in[inPos + 38] - in[inPos + 37] << 16 | in[inPos + 39] - in[inPos + 38] << 40;
        out[outPos + 15] = in[inPos + 40] - in[inPos + 39] | in[inPos + 41] - in[inPos + 40] << 24 | in[inPos + 42] - in[inPos + 41] << 48;
        out[outPos + 16] = in[inPos + 42] - in[inPos + 41] >>> 16 | in[inPos + 43] - in[inPos + 42] << 8 | in[inPos + 44] - in[inPos + 43] << 32 | in[inPos + 45] - in[inPos + 44] << 56;
        out[outPos + 17] = in[inPos + 45] - in[inPos + 44] >>> 8 | in[inPos + 46] - in[inPos + 45] << 16 | in[inPos + 47] - in[inPos + 46] << 40;
        out[outPos + 18] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 24 | in[inPos + 50] - in[inPos + 49] << 48;
        out[outPos + 19] = in[inPos + 50] - in[inPos + 49] >>> 16 | in[inPos + 51] - in[inPos + 50] << 8 | in[inPos + 52] - in[inPos + 51] << 32 | in[inPos + 53] - in[inPos + 52] << 56;
        out[outPos + 20] = in[inPos + 53] - in[inPos + 52] >>> 8 | in[inPos + 54] - in[inPos + 53] << 16 | in[inPos + 55] - in[inPos + 54] << 40;
        out[outPos + 21] = in[inPos + 56] - in[inPos + 55] | in[inPos + 57] - in[inPos + 56] << 24 | in[inPos + 58] - in[inPos + 57] << 48;
        out[outPos + 22] = in[inPos + 58] - in[inPos + 57] >>> 16 | in[inPos + 59] - in[inPos + 58] << 8 | in[inPos + 60] - in[inPos + 59] << 32 | in[inPos + 61] - in[inPos + 60] << 56;
        out[outPos + 23] = in[inPos + 61] - in[inPos + 60] >>> 8 | in[inPos + 62] - in[inPos + 61] << 16 | in[inPos + 63] - in[inPos + 62] << 40;
    }

    private static void unpack24(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 24 & 0xFFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 48 | (in[inPos + 1] & 0xFFL) << 16) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 8 & 0xFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 32 & 0xFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 0xFFFFL) << 8) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 16 & 0xFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 40) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] & 0xFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 24 & 0xFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 48 | (in[inPos + 4] & 0xFFL) << 16) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 8 & 0xFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 32 & 0xFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 4] >>> 56 | (in[inPos + 5] & 0xFFFFL) << 8) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 5] >>> 16 & 0xFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 5] >>> 40) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 6] & 0xFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 6] >>> 24 & 0xFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 6] >>> 48 | (in[inPos + 7] & 0xFFL) << 16) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 7] >>> 8 & 0xFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 7] >>> 32 & 0xFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0xFFFFL) << 8) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 8] >>> 16 & 0xFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 8] >>> 40) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 9] & 0xFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 9] >>> 24 & 0xFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 9] >>> 48 | (in[inPos + 10] & 0xFFL) << 16) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 10] >>> 8 & 0xFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 10] >>> 32 & 0xFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 10] >>> 56 | (in[inPos + 11] & 0xFFFFL) << 8) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 11] >>> 16 & 0xFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 11] >>> 40) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 12] & 0xFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 12] >>> 24 & 0xFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 12] >>> 48 | (in[inPos + 13] & 0xFFL) << 16) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 13] >>> 8 & 0xFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 13] >>> 32 & 0xFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 13] >>> 56 | (in[inPos + 14] & 0xFFFFL) << 8) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 14] >>> 16 & 0xFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 14] >>> 40) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 15] & 0xFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 15] >>> 24 & 0xFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0xFFL) << 16) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 16] >>> 8 & 0xFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 16] >>> 32 & 0xFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0xFFFFL) << 8) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 17] >>> 16 & 0xFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 17] >>> 40) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 18] & 0xFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 18] >>> 24 & 0xFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0xFFL) << 16) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 19] >>> 8 & 0xFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 19] >>> 32 & 0xFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 19] >>> 56 | (in[inPos + 20] & 0xFFFFL) << 8) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 20] >>> 16 & 0xFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 20] >>> 40) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 21] & 0xFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 21] >>> 24 & 0xFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 21] >>> 48 | (in[inPos + 22] & 0xFFL) << 16) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 22] >>> 8 & 0xFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 22] >>> 32 & 0xFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 22] >>> 56 | (in[inPos + 23] & 0xFFFFL) << 8) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 23] >>> 16 & 0xFFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 23] >>> 40) + out[outPos + 62];
    }

    private static void pack25(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 25 | in[inPos + 2] - in[inPos + 1] << 50;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 14 | in[inPos + 3] - in[inPos + 2] << 11 | in[inPos + 4] - in[inPos + 3] << 36 | in[inPos + 5] - in[inPos + 4] << 61;
        out[outPos + 2] = in[inPos + 5] - in[inPos + 4] >>> 3 | in[inPos + 6] - in[inPos + 5] << 22 | in[inPos + 7] - in[inPos + 6] << 47;
        out[outPos + 3] = in[inPos + 7] - in[inPos + 6] >>> 17 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 33 | in[inPos + 10] - in[inPos + 9] << 58;
        out[outPos + 4] = in[inPos + 10] - in[inPos + 9] >>> 6 | in[inPos + 11] - in[inPos + 10] << 19 | in[inPos + 12] - in[inPos + 11] << 44;
        out[outPos + 5] = in[inPos + 12] - in[inPos + 11] >>> 20 | in[inPos + 13] - in[inPos + 12] << 5 | in[inPos + 14] - in[inPos + 13] << 30 | in[inPos + 15] - in[inPos + 14] << 55;
        out[outPos + 6] = in[inPos + 15] - in[inPos + 14] >>> 9 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 41;
        out[outPos + 7] = in[inPos + 17] - in[inPos + 16] >>> 23 | in[inPos + 18] - in[inPos + 17] << 2 | in[inPos + 19] - in[inPos + 18] << 27 | in[inPos + 20] - in[inPos + 19] << 52;
        out[outPos + 8] = in[inPos + 20] - in[inPos + 19] >>> 12 | in[inPos + 21] - in[inPos + 20] << 13 | in[inPos + 22] - in[inPos + 21] << 38 | in[inPos + 23] - in[inPos + 22] << 63;
        out[outPos + 9] = in[inPos + 23] - in[inPos + 22] >>> 1 | in[inPos + 24] - in[inPos + 23] << 24 | in[inPos + 25] - in[inPos + 24] << 49;
        out[outPos + 10] = in[inPos + 25] - in[inPos + 24] >>> 15 | in[inPos + 26] - in[inPos + 25] << 10 | in[inPos + 27] - in[inPos + 26] << 35 | in[inPos + 28] - in[inPos + 27] << 60;
        out[outPos + 11] = in[inPos + 28] - in[inPos + 27] >>> 4 | in[inPos + 29] - in[inPos + 28] << 21 | in[inPos + 30] - in[inPos + 29] << 46;
        out[outPos + 12] = in[inPos + 30] - in[inPos + 29] >>> 18 | in[inPos + 31] - in[inPos + 30] << 7 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 57;
        out[outPos + 13] = in[inPos + 33] - in[inPos + 32] >>> 7 | in[inPos + 34] - in[inPos + 33] << 18 | in[inPos + 35] - in[inPos + 34] << 43;
        out[outPos + 14] = in[inPos + 35] - in[inPos + 34] >>> 21 | in[inPos + 36] - in[inPos + 35] << 4 | in[inPos + 37] - in[inPos + 36] << 29 | in[inPos + 38] - in[inPos + 37] << 54;
        out[outPos + 15] = in[inPos + 38] - in[inPos + 37] >>> 10 | in[inPos + 39] - in[inPos + 38] << 15 | in[inPos + 40] - in[inPos + 39] << 40;
        out[outPos + 16] = in[inPos + 40] - in[inPos + 39] >>> 24 | in[inPos + 41] - in[inPos + 40] << 1 | in[inPos + 42] - in[inPos + 41] << 26 | in[inPos + 43] - in[inPos + 42] << 51;
        out[outPos + 17] = in[inPos + 43] - in[inPos + 42] >>> 13 | in[inPos + 44] - in[inPos + 43] << 12 | in[inPos + 45] - in[inPos + 44] << 37 | in[inPos + 46] - in[inPos + 45] << 62;
        out[outPos + 18] = in[inPos + 46] - in[inPos + 45] >>> 2 | in[inPos + 47] - in[inPos + 46] << 23 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 19] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 9 | in[inPos + 50] - in[inPos + 49] << 34 | in[inPos + 51] - in[inPos + 50] << 59;
        out[outPos + 20] = in[inPos + 51] - in[inPos + 50] >>> 5 | in[inPos + 52] - in[inPos + 51] << 20 | in[inPos + 53] - in[inPos + 52] << 45;
        out[outPos + 21] = in[inPos + 53] - in[inPos + 52] >>> 19 | in[inPos + 54] - in[inPos + 53] << 6 | in[inPos + 55] - in[inPos + 54] << 31 | in[inPos + 56] - in[inPos + 55] << 56;
        out[outPos + 22] = in[inPos + 56] - in[inPos + 55] >>> 8 | in[inPos + 57] - in[inPos + 56] << 17 | in[inPos + 58] - in[inPos + 57] << 42;
        out[outPos + 23] = in[inPos + 58] - in[inPos + 57] >>> 22 | in[inPos + 59] - in[inPos + 58] << 3 | in[inPos + 60] - in[inPos + 59] << 28 | in[inPos + 61] - in[inPos + 60] << 53;
        out[outPos + 24] = in[inPos + 61] - in[inPos + 60] >>> 11 | in[inPos + 62] - in[inPos + 61] << 14 | in[inPos + 63] - in[inPos + 62] << 39;
    }

    private static void unpack25(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 25 & 0x1FFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 50 | (in[inPos + 1] & 0x7FFL) << 14) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 11 & 0x1FFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 36 & 0x1FFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 1] >>> 61 | (in[inPos + 2] & 0x3FFFFFL) << 3) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 22 & 0x1FFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 47 | (in[inPos + 3] & 0xFFL) << 17) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 8 & 0x1FFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 33 & 0x1FFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 3] >>> 58 | (in[inPos + 4] & 0x7FFFFL) << 6) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 19 & 0x1FFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 44 | (in[inPos + 5] & 0x1FL) << 20) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 5] >>> 5 & 0x1FFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 5] >>> 30 & 0x1FFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 5] >>> 55 | (in[inPos + 6] & 0xFFFFL) << 9) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 6] >>> 16 & 0x1FFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 6] >>> 41 | (in[inPos + 7] & 3L) << 23) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 7] >>> 2 & 0x1FFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 7] >>> 27 & 0x1FFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 7] >>> 52 | (in[inPos + 8] & 0x1FFFL) << 12) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 8] >>> 13 & 0x1FFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 8] >>> 38 & 0x1FFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 8] >>> 63 | (in[inPos + 9] & 0xFFFFFFL) << 1) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 9] >>> 24 & 0x1FFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 9] >>> 49 | (in[inPos + 10] & 0x3FFL) << 15) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 10] >>> 10 & 0x1FFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 10] >>> 35 & 0x1FFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 10] >>> 60 | (in[inPos + 11] & 0x1FFFFFL) << 4) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 11] >>> 21 & 0x1FFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 11] >>> 46 | (in[inPos + 12] & 0x7FL) << 18) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 12] >>> 7 & 0x1FFFFFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 12] >>> 32 & 0x1FFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 12] >>> 57 | (in[inPos + 13] & 0x3FFFFL) << 7) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 13] >>> 18 & 0x1FFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 13] >>> 43 | (in[inPos + 14] & 0xFL) << 21) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 14] >>> 4 & 0x1FFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 14] >>> 29 & 0x1FFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 14] >>> 54 | (in[inPos + 15] & 0x7FFFL) << 10) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 15] >>> 15 & 0x1FFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 15] >>> 40 | (in[inPos + 16] & 1L) << 24) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 16] >>> 1 & 0x1FFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 16] >>> 26 & 0x1FFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 16] >>> 51 | (in[inPos + 17] & 0xFFFL) << 13) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 17] >>> 12 & 0x1FFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 17] >>> 37 & 0x1FFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 17] >>> 62 | (in[inPos + 18] & 0x7FFFFFL) << 2) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 18] >>> 23 & 0x1FFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0x1FFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 19] >>> 9 & 0x1FFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 19] >>> 34 & 0x1FFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 19] >>> 59 | (in[inPos + 20] & 0xFFFFFL) << 5) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 20] >>> 20 & 0x1FFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 20] >>> 45 | (in[inPos + 21] & 0x3FL) << 19) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 21] >>> 6 & 0x1FFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 21] >>> 31 & 0x1FFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 21] >>> 56 | (in[inPos + 22] & 0x1FFFFL) << 8) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 22] >>> 17 & 0x1FFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 22] >>> 42 | (in[inPos + 23] & 7L) << 22) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 23] >>> 3 & 0x1FFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 23] >>> 28 & 0x1FFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 23] >>> 53 | (in[inPos + 24] & 0x3FFFL) << 11) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 24] >>> 14 & 0x1FFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 24] >>> 39) + out[outPos + 62];
    }

    private static void pack26(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 26 | in[inPos + 2] - in[inPos + 1] << 52;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 12 | in[inPos + 3] - in[inPos + 2] << 14 | in[inPos + 4] - in[inPos + 3] << 40;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 24 | in[inPos + 5] - in[inPos + 4] << 2 | in[inPos + 6] - in[inPos + 5] << 28 | in[inPos + 7] - in[inPos + 6] << 54;
        out[outPos + 3] = in[inPos + 7] - in[inPos + 6] >>> 10 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 42;
        out[outPos + 4] = in[inPos + 9] - in[inPos + 8] >>> 22 | in[inPos + 10] - in[inPos + 9] << 4 | in[inPos + 11] - in[inPos + 10] << 30 | in[inPos + 12] - in[inPos + 11] << 56;
        out[outPos + 5] = in[inPos + 12] - in[inPos + 11] >>> 8 | in[inPos + 13] - in[inPos + 12] << 18 | in[inPos + 14] - in[inPos + 13] << 44;
        out[outPos + 6] = in[inPos + 14] - in[inPos + 13] >>> 20 | in[inPos + 15] - in[inPos + 14] << 6 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 58;
        out[outPos + 7] = in[inPos + 17] - in[inPos + 16] >>> 6 | in[inPos + 18] - in[inPos + 17] << 20 | in[inPos + 19] - in[inPos + 18] << 46;
        out[outPos + 8] = in[inPos + 19] - in[inPos + 18] >>> 18 | in[inPos + 20] - in[inPos + 19] << 8 | in[inPos + 21] - in[inPos + 20] << 34 | in[inPos + 22] - in[inPos + 21] << 60;
        out[outPos + 9] = in[inPos + 22] - in[inPos + 21] >>> 4 | in[inPos + 23] - in[inPos + 22] << 22 | in[inPos + 24] - in[inPos + 23] << 48;
        out[outPos + 10] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 10 | in[inPos + 26] - in[inPos + 25] << 36 | in[inPos + 27] - in[inPos + 26] << 62;
        out[outPos + 11] = in[inPos + 27] - in[inPos + 26] >>> 2 | in[inPos + 28] - in[inPos + 27] << 24 | in[inPos + 29] - in[inPos + 28] << 50;
        out[outPos + 12] = in[inPos + 29] - in[inPos + 28] >>> 14 | in[inPos + 30] - in[inPos + 29] << 12 | in[inPos + 31] - in[inPos + 30] << 38;
        out[outPos + 13] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 26 | in[inPos + 34] - in[inPos + 33] << 52;
        out[outPos + 14] = in[inPos + 34] - in[inPos + 33] >>> 12 | in[inPos + 35] - in[inPos + 34] << 14 | in[inPos + 36] - in[inPos + 35] << 40;
        out[outPos + 15] = in[inPos + 36] - in[inPos + 35] >>> 24 | in[inPos + 37] - in[inPos + 36] << 2 | in[inPos + 38] - in[inPos + 37] << 28 | in[inPos + 39] - in[inPos + 38] << 54;
        out[outPos + 16] = in[inPos + 39] - in[inPos + 38] >>> 10 | in[inPos + 40] - in[inPos + 39] << 16 | in[inPos + 41] - in[inPos + 40] << 42;
        out[outPos + 17] = in[inPos + 41] - in[inPos + 40] >>> 22 | in[inPos + 42] - in[inPos + 41] << 4 | in[inPos + 43] - in[inPos + 42] << 30 | in[inPos + 44] - in[inPos + 43] << 56;
        out[outPos + 18] = in[inPos + 44] - in[inPos + 43] >>> 8 | in[inPos + 45] - in[inPos + 44] << 18 | in[inPos + 46] - in[inPos + 45] << 44;
        out[outPos + 19] = in[inPos + 46] - in[inPos + 45] >>> 20 | in[inPos + 47] - in[inPos + 46] << 6 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 58;
        out[outPos + 20] = in[inPos + 49] - in[inPos + 48] >>> 6 | in[inPos + 50] - in[inPos + 49] << 20 | in[inPos + 51] - in[inPos + 50] << 46;
        out[outPos + 21] = in[inPos + 51] - in[inPos + 50] >>> 18 | in[inPos + 52] - in[inPos + 51] << 8 | in[inPos + 53] - in[inPos + 52] << 34 | in[inPos + 54] - in[inPos + 53] << 60;
        out[outPos + 22] = in[inPos + 54] - in[inPos + 53] >>> 4 | in[inPos + 55] - in[inPos + 54] << 22 | in[inPos + 56] - in[inPos + 55] << 48;
        out[outPos + 23] = in[inPos + 56] - in[inPos + 55] >>> 16 | in[inPos + 57] - in[inPos + 56] << 10 | in[inPos + 58] - in[inPos + 57] << 36 | in[inPos + 59] - in[inPos + 58] << 62;
        out[outPos + 24] = in[inPos + 59] - in[inPos + 58] >>> 2 | in[inPos + 60] - in[inPos + 59] << 24 | in[inPos + 61] - in[inPos + 60] << 50;
        out[outPos + 25] = in[inPos + 61] - in[inPos + 60] >>> 14 | in[inPos + 62] - in[inPos + 61] << 12 | in[inPos + 63] - in[inPos + 62] << 38;
    }

    private static void unpack26(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 26 & 0x3FFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 52 | (in[inPos + 1] & 0x3FFFL) << 12) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 14 & 0x3FFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 40 | (in[inPos + 2] & 3L) << 24) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 2 & 0x3FFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 28 & 0x3FFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 54 | (in[inPos + 3] & 0xFFFFL) << 10) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 16 & 0x3FFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 42 | (in[inPos + 4] & 0xFL) << 22) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 4 & 0x3FFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 30 & 0x3FFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 4] >>> 56 | (in[inPos + 5] & 0x3FFFFL) << 8) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 5] >>> 18 & 0x3FFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 5] >>> 44 | (in[inPos + 6] & 0x3FL) << 20) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 6] >>> 6 & 0x3FFFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 6] >>> 32 & 0x3FFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 6] >>> 58 | (in[inPos + 7] & 0xFFFFFL) << 6) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 7] >>> 20 & 0x3FFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 7] >>> 46 | (in[inPos + 8] & 0xFFL) << 18) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 8] >>> 8 & 0x3FFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 8] >>> 34 & 0x3FFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 8] >>> 60 | (in[inPos + 9] & 0x3FFFFFL) << 4) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 9] >>> 22 & 0x3FFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 9] >>> 48 | (in[inPos + 10] & 0x3FFL) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 10] >>> 10 & 0x3FFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 10] >>> 36 & 0x3FFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 10] >>> 62 | (in[inPos + 11] & 0xFFFFFFL) << 2) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 11] >>> 24 & 0x3FFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 11] >>> 50 | (in[inPos + 12] & 0xFFFL) << 14) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 12] >>> 12 & 0x3FFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 12] >>> 38) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 13] & 0x3FFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 13] >>> 26 & 0x3FFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 13] >>> 52 | (in[inPos + 14] & 0x3FFFL) << 12) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 14] >>> 14 & 0x3FFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 14] >>> 40 | (in[inPos + 15] & 3L) << 24) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 15] >>> 2 & 0x3FFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 15] >>> 28 & 0x3FFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 15] >>> 54 | (in[inPos + 16] & 0xFFFFL) << 10) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 16] >>> 16 & 0x3FFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 16] >>> 42 | (in[inPos + 17] & 0xFL) << 22) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 17] >>> 4 & 0x3FFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 17] >>> 30 & 0x3FFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 17] >>> 56 | (in[inPos + 18] & 0x3FFFFL) << 8) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 18] >>> 18 & 0x3FFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 18] >>> 44 | (in[inPos + 19] & 0x3FL) << 20) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 19] >>> 6 & 0x3FFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 19] >>> 32 & 0x3FFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 19] >>> 58 | (in[inPos + 20] & 0xFFFFFL) << 6) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 20] >>> 20 & 0x3FFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 20] >>> 46 | (in[inPos + 21] & 0xFFL) << 18) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 21] >>> 8 & 0x3FFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 21] >>> 34 & 0x3FFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 21] >>> 60 | (in[inPos + 22] & 0x3FFFFFL) << 4) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 22] >>> 22 & 0x3FFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 22] >>> 48 | (in[inPos + 23] & 0x3FFL) << 16) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 23] >>> 10 & 0x3FFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 23] >>> 36 & 0x3FFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 23] >>> 62 | (in[inPos + 24] & 0xFFFFFFL) << 2) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 24] >>> 24 & 0x3FFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 24] >>> 50 | (in[inPos + 25] & 0xFFFL) << 14) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 25] >>> 12 & 0x3FFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 25] >>> 38) + out[outPos + 62];
    }

    private static void pack27(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 27 | in[inPos + 2] - in[inPos + 1] << 54;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 10 | in[inPos + 3] - in[inPos + 2] << 17 | in[inPos + 4] - in[inPos + 3] << 44;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 20 | in[inPos + 5] - in[inPos + 4] << 7 | in[inPos + 6] - in[inPos + 5] << 34 | in[inPos + 7] - in[inPos + 6] << 61;
        out[outPos + 3] = in[inPos + 7] - in[inPos + 6] >>> 3 | in[inPos + 8] - in[inPos + 7] << 24 | in[inPos + 9] - in[inPos + 8] << 51;
        out[outPos + 4] = in[inPos + 9] - in[inPos + 8] >>> 13 | in[inPos + 10] - in[inPos + 9] << 14 | in[inPos + 11] - in[inPos + 10] << 41;
        out[outPos + 5] = in[inPos + 11] - in[inPos + 10] >>> 23 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 31 | in[inPos + 14] - in[inPos + 13] << 58;
        out[outPos + 6] = in[inPos + 14] - in[inPos + 13] >>> 6 | in[inPos + 15] - in[inPos + 14] << 21 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 7] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 11 | in[inPos + 18] - in[inPos + 17] << 38;
        out[outPos + 8] = in[inPos + 18] - in[inPos + 17] >>> 26 | in[inPos + 19] - in[inPos + 18] << 1 | in[inPos + 20] - in[inPos + 19] << 28 | in[inPos + 21] - in[inPos + 20] << 55;
        out[outPos + 9] = in[inPos + 21] - in[inPos + 20] >>> 9 | in[inPos + 22] - in[inPos + 21] << 18 | in[inPos + 23] - in[inPos + 22] << 45;
        out[outPos + 10] = in[inPos + 23] - in[inPos + 22] >>> 19 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 35 | in[inPos + 26] - in[inPos + 25] << 62;
        out[outPos + 11] = in[inPos + 26] - in[inPos + 25] >>> 2 | in[inPos + 27] - in[inPos + 26] << 25 | in[inPos + 28] - in[inPos + 27] << 52;
        out[outPos + 12] = in[inPos + 28] - in[inPos + 27] >>> 12 | in[inPos + 29] - in[inPos + 28] << 15 | in[inPos + 30] - in[inPos + 29] << 42;
        out[outPos + 13] = in[inPos + 30] - in[inPos + 29] >>> 22 | in[inPos + 31] - in[inPos + 30] << 5 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 59;
        out[outPos + 14] = in[inPos + 33] - in[inPos + 32] >>> 5 | in[inPos + 34] - in[inPos + 33] << 22 | in[inPos + 35] - in[inPos + 34] << 49;
        out[outPos + 15] = in[inPos + 35] - in[inPos + 34] >>> 15 | in[inPos + 36] - in[inPos + 35] << 12 | in[inPos + 37] - in[inPos + 36] << 39;
        out[outPos + 16] = in[inPos + 37] - in[inPos + 36] >>> 25 | in[inPos + 38] - in[inPos + 37] << 2 | in[inPos + 39] - in[inPos + 38] << 29 | in[inPos + 40] - in[inPos + 39] << 56;
        out[outPos + 17] = in[inPos + 40] - in[inPos + 39] >>> 8 | in[inPos + 41] - in[inPos + 40] << 19 | in[inPos + 42] - in[inPos + 41] << 46;
        out[outPos + 18] = in[inPos + 42] - in[inPos + 41] >>> 18 | in[inPos + 43] - in[inPos + 42] << 9 | in[inPos + 44] - in[inPos + 43] << 36 | in[inPos + 45] - in[inPos + 44] << 63;
        out[outPos + 19] = in[inPos + 45] - in[inPos + 44] >>> 1 | in[inPos + 46] - in[inPos + 45] << 26 | in[inPos + 47] - in[inPos + 46] << 53;
        out[outPos + 20] = in[inPos + 47] - in[inPos + 46] >>> 11 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 43;
        out[outPos + 21] = in[inPos + 49] - in[inPos + 48] >>> 21 | in[inPos + 50] - in[inPos + 49] << 6 | in[inPos + 51] - in[inPos + 50] << 33 | in[inPos + 52] - in[inPos + 51] << 60;
        out[outPos + 22] = in[inPos + 52] - in[inPos + 51] >>> 4 | in[inPos + 53] - in[inPos + 52] << 23 | in[inPos + 54] - in[inPos + 53] << 50;
        out[outPos + 23] = in[inPos + 54] - in[inPos + 53] >>> 14 | in[inPos + 55] - in[inPos + 54] << 13 | in[inPos + 56] - in[inPos + 55] << 40;
        out[outPos + 24] = in[inPos + 56] - in[inPos + 55] >>> 24 | in[inPos + 57] - in[inPos + 56] << 3 | in[inPos + 58] - in[inPos + 57] << 30 | in[inPos + 59] - in[inPos + 58] << 57;
        out[outPos + 25] = in[inPos + 59] - in[inPos + 58] >>> 7 | in[inPos + 60] - in[inPos + 59] << 20 | in[inPos + 61] - in[inPos + 60] << 47;
        out[outPos + 26] = in[inPos + 61] - in[inPos + 60] >>> 17 | in[inPos + 62] - in[inPos + 61] << 10 | in[inPos + 63] - in[inPos + 62] << 37;
    }

    private static void unpack27(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 27 & 0x7FFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 54 | (in[inPos + 1] & 0x1FFFFL) << 10) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 17 & 0x7FFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 44 | (in[inPos + 2] & 0x7FL) << 20) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 7 & 0x7FFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 34 & 0x7FFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 2] >>> 61 | (in[inPos + 3] & 0xFFFFFFL) << 3) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 24 & 0x7FFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 51 | (in[inPos + 4] & 0x3FFFL) << 13) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 14 & 0x7FFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 41 | (in[inPos + 5] & 0xFL) << 23) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 5] >>> 4 & 0x7FFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 5] >>> 31 & 0x7FFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 0x1FFFFFL) << 6) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 6] >>> 21 & 0x7FFFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 6] >>> 48 | (in[inPos + 7] & 0x7FFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 7] >>> 11 & 0x7FFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 7] >>> 38 | (in[inPos + 8] & 1L) << 26) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 8] >>> 1 & 0x7FFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 8] >>> 28 & 0x7FFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 8] >>> 55 | (in[inPos + 9] & 0x3FFFFL) << 9) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 9] >>> 18 & 0x7FFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 9] >>> 45 | (in[inPos + 10] & 0xFFL) << 19) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 10] >>> 8 & 0x7FFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 10] >>> 35 & 0x7FFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 10] >>> 62 | (in[inPos + 11] & 0x1FFFFFFL) << 2) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 11] >>> 25 & 0x7FFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0x7FFFL) << 12) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 12] >>> 15 & 0x7FFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 12] >>> 42 | (in[inPos + 13] & 0x1FL) << 22) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 13] >>> 5 & 0x7FFFFFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 13] >>> 32 & 0x7FFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 13] >>> 59 | (in[inPos + 14] & 0x3FFFFFL) << 5) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 14] >>> 22 & 0x7FFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 14] >>> 49 | (in[inPos + 15] & 0xFFFL) << 15) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 15] >>> 12 & 0x7FFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 15] >>> 39 | (in[inPos + 16] & 3L) << 25) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 16] >>> 2 & 0x7FFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 16] >>> 29 & 0x7FFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0x7FFFFL) << 8) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 17] >>> 19 & 0x7FFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 17] >>> 46 | (in[inPos + 18] & 0x1FFL) << 18) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 18] >>> 9 & 0x7FFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 18] >>> 36 & 0x7FFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 18] >>> 63 | (in[inPos + 19] & 0x3FFFFFFL) << 1) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 19] >>> 26 & 0x7FFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 19] >>> 53 | (in[inPos + 20] & 0xFFFFL) << 11) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 20] >>> 16 & 0x7FFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 20] >>> 43 | (in[inPos + 21] & 0x3FL) << 21) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 21] >>> 6 & 0x7FFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 21] >>> 33 & 0x7FFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 21] >>> 60 | (in[inPos + 22] & 0x7FFFFFL) << 4) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 22] >>> 23 & 0x7FFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 22] >>> 50 | (in[inPos + 23] & 0x1FFFL) << 14) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 23] >>> 13 & 0x7FFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 23] >>> 40 | (in[inPos + 24] & 7L) << 24) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 24] >>> 3 & 0x7FFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 24] >>> 30 & 0x7FFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 24] >>> 57 | (in[inPos + 25] & 0xFFFFFL) << 7) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 25] >>> 20 & 0x7FFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 25] >>> 47 | (in[inPos + 26] & 0x3FFL) << 17) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 26] >>> 10 & 0x7FFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 26] >>> 37) + out[outPos + 62];
    }

    private static void pack28(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 28 | in[inPos + 2] - in[inPos + 1] << 56;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 8 | in[inPos + 3] - in[inPos + 2] << 20 | in[inPos + 4] - in[inPos + 3] << 48;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 16 | in[inPos + 5] - in[inPos + 4] << 12 | in[inPos + 6] - in[inPos + 5] << 40;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] >>> 24 | in[inPos + 7] - in[inPos + 6] << 4 | in[inPos + 8] - in[inPos + 7] << 32 | in[inPos + 9] - in[inPos + 8] << 60;
        out[outPos + 4] = in[inPos + 9] - in[inPos + 8] >>> 4 | in[inPos + 10] - in[inPos + 9] << 24 | in[inPos + 11] - in[inPos + 10] << 52;
        out[outPos + 5] = in[inPos + 11] - in[inPos + 10] >>> 12 | in[inPos + 12] - in[inPos + 11] << 16 | in[inPos + 13] - in[inPos + 12] << 44;
        out[outPos + 6] = in[inPos + 13] - in[inPos + 12] >>> 20 | in[inPos + 14] - in[inPos + 13] << 8 | in[inPos + 15] - in[inPos + 14] << 36;
        out[outPos + 7] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 28 | in[inPos + 18] - in[inPos + 17] << 56;
        out[outPos + 8] = in[inPos + 18] - in[inPos + 17] >>> 8 | in[inPos + 19] - in[inPos + 18] << 20 | in[inPos + 20] - in[inPos + 19] << 48;
        out[outPos + 9] = in[inPos + 20] - in[inPos + 19] >>> 16 | in[inPos + 21] - in[inPos + 20] << 12 | in[inPos + 22] - in[inPos + 21] << 40;
        out[outPos + 10] = in[inPos + 22] - in[inPos + 21] >>> 24 | in[inPos + 23] - in[inPos + 22] << 4 | in[inPos + 24] - in[inPos + 23] << 32 | in[inPos + 25] - in[inPos + 24] << 60;
        out[outPos + 11] = in[inPos + 25] - in[inPos + 24] >>> 4 | in[inPos + 26] - in[inPos + 25] << 24 | in[inPos + 27] - in[inPos + 26] << 52;
        out[outPos + 12] = in[inPos + 27] - in[inPos + 26] >>> 12 | in[inPos + 28] - in[inPos + 27] << 16 | in[inPos + 29] - in[inPos + 28] << 44;
        out[outPos + 13] = in[inPos + 29] - in[inPos + 28] >>> 20 | in[inPos + 30] - in[inPos + 29] << 8 | in[inPos + 31] - in[inPos + 30] << 36;
        out[outPos + 14] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 28 | in[inPos + 34] - in[inPos + 33] << 56;
        out[outPos + 15] = in[inPos + 34] - in[inPos + 33] >>> 8 | in[inPos + 35] - in[inPos + 34] << 20 | in[inPos + 36] - in[inPos + 35] << 48;
        out[outPos + 16] = in[inPos + 36] - in[inPos + 35] >>> 16 | in[inPos + 37] - in[inPos + 36] << 12 | in[inPos + 38] - in[inPos + 37] << 40;
        out[outPos + 17] = in[inPos + 38] - in[inPos + 37] >>> 24 | in[inPos + 39] - in[inPos + 38] << 4 | in[inPos + 40] - in[inPos + 39] << 32 | in[inPos + 41] - in[inPos + 40] << 60;
        out[outPos + 18] = in[inPos + 41] - in[inPos + 40] >>> 4 | in[inPos + 42] - in[inPos + 41] << 24 | in[inPos + 43] - in[inPos + 42] << 52;
        out[outPos + 19] = in[inPos + 43] - in[inPos + 42] >>> 12 | in[inPos + 44] - in[inPos + 43] << 16 | in[inPos + 45] - in[inPos + 44] << 44;
        out[outPos + 20] = in[inPos + 45] - in[inPos + 44] >>> 20 | in[inPos + 46] - in[inPos + 45] << 8 | in[inPos + 47] - in[inPos + 46] << 36;
        out[outPos + 21] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 28 | in[inPos + 50] - in[inPos + 49] << 56;
        out[outPos + 22] = in[inPos + 50] - in[inPos + 49] >>> 8 | in[inPos + 51] - in[inPos + 50] << 20 | in[inPos + 52] - in[inPos + 51] << 48;
        out[outPos + 23] = in[inPos + 52] - in[inPos + 51] >>> 16 | in[inPos + 53] - in[inPos + 52] << 12 | in[inPos + 54] - in[inPos + 53] << 40;
        out[outPos + 24] = in[inPos + 54] - in[inPos + 53] >>> 24 | in[inPos + 55] - in[inPos + 54] << 4 | in[inPos + 56] - in[inPos + 55] << 32 | in[inPos + 57] - in[inPos + 56] << 60;
        out[outPos + 25] = in[inPos + 57] - in[inPos + 56] >>> 4 | in[inPos + 58] - in[inPos + 57] << 24 | in[inPos + 59] - in[inPos + 58] << 52;
        out[outPos + 26] = in[inPos + 59] - in[inPos + 58] >>> 12 | in[inPos + 60] - in[inPos + 59] << 16 | in[inPos + 61] - in[inPos + 60] << 44;
        out[outPos + 27] = in[inPos + 61] - in[inPos + 60] >>> 20 | in[inPos + 62] - in[inPos + 61] << 8 | in[inPos + 63] - in[inPos + 62] << 36;
    }

    private static void unpack28(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 28 & 0xFFFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 56 | (in[inPos + 1] & 0xFFFFFL) << 8) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 20 & 0xFFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 48 | (in[inPos + 2] & 0xFFFL) << 16) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 12 & 0xFFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 40 | (in[inPos + 3] & 0xFL) << 24) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 4 & 0xFFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 32 & 0xFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0xFFFFFFL) << 4) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 24 & 0xFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 52 | (in[inPos + 5] & 0xFFFFL) << 12) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 5] >>> 16 & 0xFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 5] >>> 44 | (in[inPos + 6] & 0xFFL) << 20) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 6] >>> 8 & 0xFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 6] >>> 36) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 7] & 0xFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 7] >>> 28 & 0xFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0xFFFFFL) << 8) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 8] >>> 20 & 0xFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 8] >>> 48 | (in[inPos + 9] & 0xFFFL) << 16) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 9] >>> 12 & 0xFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 9] >>> 40 | (in[inPos + 10] & 0xFL) << 24) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 10] >>> 4 & 0xFFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 10] >>> 32 & 0xFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 10] >>> 60 | (in[inPos + 11] & 0xFFFFFFL) << 4) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 11] >>> 24 & 0xFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0xFFFFL) << 12) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 12] >>> 16 & 0xFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 12] >>> 44 | (in[inPos + 13] & 0xFFL) << 20) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 13] >>> 8 & 0xFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 13] >>> 36) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 14] & 0xFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 14] >>> 28 & 0xFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 14] >>> 56 | (in[inPos + 15] & 0xFFFFFL) << 8) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 15] >>> 20 & 0xFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0xFFFL) << 16) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 16] >>> 12 & 0xFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 16] >>> 40 | (in[inPos + 17] & 0xFL) << 24) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 17] >>> 4 & 0xFFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 17] >>> 32 & 0xFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 17] >>> 60 | (in[inPos + 18] & 0xFFFFFFL) << 4) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 18] >>> 24 & 0xFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 18] >>> 52 | (in[inPos + 19] & 0xFFFFL) << 12) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 19] >>> 16 & 0xFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0xFFL) << 20) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 20] >>> 8 & 0xFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 20] >>> 36) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 21] & 0xFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 21] >>> 28 & 0xFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 21] >>> 56 | (in[inPos + 22] & 0xFFFFFL) << 8) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 22] >>> 20 & 0xFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 22] >>> 48 | (in[inPos + 23] & 0xFFFL) << 16) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 23] >>> 12 & 0xFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 23] >>> 40 | (in[inPos + 24] & 0xFL) << 24) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 24] >>> 4 & 0xFFFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 24] >>> 32 & 0xFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 24] >>> 60 | (in[inPos + 25] & 0xFFFFFFL) << 4) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 25] >>> 24 & 0xFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 25] >>> 52 | (in[inPos + 26] & 0xFFFFL) << 12) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 26] >>> 16 & 0xFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 26] >>> 44 | (in[inPos + 27] & 0xFFL) << 20) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 27] >>> 8 & 0xFFFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 27] >>> 36) + out[outPos + 62];
    }

    private static void pack29(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 29 | in[inPos + 2] - in[inPos + 1] << 58;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 6 | in[inPos + 3] - in[inPos + 2] << 23 | in[inPos + 4] - in[inPos + 3] << 52;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 12 | in[inPos + 5] - in[inPos + 4] << 17 | in[inPos + 6] - in[inPos + 5] << 46;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] >>> 18 | in[inPos + 7] - in[inPos + 6] << 11 | in[inPos + 8] - in[inPos + 7] << 40;
        out[outPos + 4] = in[inPos + 8] - in[inPos + 7] >>> 24 | in[inPos + 9] - in[inPos + 8] << 5 | in[inPos + 10] - in[inPos + 9] << 34 | in[inPos + 11] - in[inPos + 10] << 63;
        out[outPos + 5] = in[inPos + 11] - in[inPos + 10] >>> 1 | in[inPos + 12] - in[inPos + 11] << 28 | in[inPos + 13] - in[inPos + 12] << 57;
        out[outPos + 6] = in[inPos + 13] - in[inPos + 12] >>> 7 | in[inPos + 14] - in[inPos + 13] << 22 | in[inPos + 15] - in[inPos + 14] << 51;
        out[outPos + 7] = in[inPos + 15] - in[inPos + 14] >>> 13 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 45;
        out[outPos + 8] = in[inPos + 17] - in[inPos + 16] >>> 19 | in[inPos + 18] - in[inPos + 17] << 10 | in[inPos + 19] - in[inPos + 18] << 39;
        out[outPos + 9] = in[inPos + 19] - in[inPos + 18] >>> 25 | in[inPos + 20] - in[inPos + 19] << 4 | in[inPos + 21] - in[inPos + 20] << 33 | in[inPos + 22] - in[inPos + 21] << 62;
        out[outPos + 10] = in[inPos + 22] - in[inPos + 21] >>> 2 | in[inPos + 23] - in[inPos + 22] << 27 | in[inPos + 24] - in[inPos + 23] << 56;
        out[outPos + 11] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 21 | in[inPos + 26] - in[inPos + 25] << 50;
        out[outPos + 12] = in[inPos + 26] - in[inPos + 25] >>> 14 | in[inPos + 27] - in[inPos + 26] << 15 | in[inPos + 28] - in[inPos + 27] << 44;
        out[outPos + 13] = in[inPos + 28] - in[inPos + 27] >>> 20 | in[inPos + 29] - in[inPos + 28] << 9 | in[inPos + 30] - in[inPos + 29] << 38;
        out[outPos + 14] = in[inPos + 30] - in[inPos + 29] >>> 26 | in[inPos + 31] - in[inPos + 30] << 3 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 61;
        out[outPos + 15] = in[inPos + 33] - in[inPos + 32] >>> 3 | in[inPos + 34] - in[inPos + 33] << 26 | in[inPos + 35] - in[inPos + 34] << 55;
        out[outPos + 16] = in[inPos + 35] - in[inPos + 34] >>> 9 | in[inPos + 36] - in[inPos + 35] << 20 | in[inPos + 37] - in[inPos + 36] << 49;
        out[outPos + 17] = in[inPos + 37] - in[inPos + 36] >>> 15 | in[inPos + 38] - in[inPos + 37] << 14 | in[inPos + 39] - in[inPos + 38] << 43;
        out[outPos + 18] = in[inPos + 39] - in[inPos + 38] >>> 21 | in[inPos + 40] - in[inPos + 39] << 8 | in[inPos + 41] - in[inPos + 40] << 37;
        out[outPos + 19] = in[inPos + 41] - in[inPos + 40] >>> 27 | in[inPos + 42] - in[inPos + 41] << 2 | in[inPos + 43] - in[inPos + 42] << 31 | in[inPos + 44] - in[inPos + 43] << 60;
        out[outPos + 20] = in[inPos + 44] - in[inPos + 43] >>> 4 | in[inPos + 45] - in[inPos + 44] << 25 | in[inPos + 46] - in[inPos + 45] << 54;
        out[outPos + 21] = in[inPos + 46] - in[inPos + 45] >>> 10 | in[inPos + 47] - in[inPos + 46] << 19 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 22] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 13 | in[inPos + 50] - in[inPos + 49] << 42;
        out[outPos + 23] = in[inPos + 50] - in[inPos + 49] >>> 22 | in[inPos + 51] - in[inPos + 50] << 7 | in[inPos + 52] - in[inPos + 51] << 36;
        out[outPos + 24] = in[inPos + 52] - in[inPos + 51] >>> 28 | in[inPos + 53] - in[inPos + 52] << 1 | in[inPos + 54] - in[inPos + 53] << 30 | in[inPos + 55] - in[inPos + 54] << 59;
        out[outPos + 25] = in[inPos + 55] - in[inPos + 54] >>> 5 | in[inPos + 56] - in[inPos + 55] << 24 | in[inPos + 57] - in[inPos + 56] << 53;
        out[outPos + 26] = in[inPos + 57] - in[inPos + 56] >>> 11 | in[inPos + 58] - in[inPos + 57] << 18 | in[inPos + 59] - in[inPos + 58] << 47;
        out[outPos + 27] = in[inPos + 59] - in[inPos + 58] >>> 17 | in[inPos + 60] - in[inPos + 59] << 12 | in[inPos + 61] - in[inPos + 60] << 41;
        out[outPos + 28] = in[inPos + 61] - in[inPos + 60] >>> 23 | in[inPos + 62] - in[inPos + 61] << 6 | in[inPos + 63] - in[inPos + 62] << 35;
    }

    private static void unpack29(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 29 & 0x1FFFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 58 | (in[inPos + 1] & 0x7FFFFFL) << 6) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 23 & 0x1FFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 52 | (in[inPos + 2] & 0x1FFFFL) << 12) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 17 & 0x1FFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 46 | (in[inPos + 3] & 0x7FFL) << 18) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 11 & 0x1FFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 40 | (in[inPos + 4] & 0x1FL) << 24) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 5 & 0x1FFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 34 & 0x1FFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 4] >>> 63 | (in[inPos + 5] & 0xFFFFFFFL) << 1) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 5] >>> 28 & 0x1FFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 5] >>> 57 | (in[inPos + 6] & 0x3FFFFFL) << 7) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 6] >>> 22 & 0x1FFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 6] >>> 51 | (in[inPos + 7] & 0xFFFFL) << 13) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 7] >>> 16 & 0x1FFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 7] >>> 45 | (in[inPos + 8] & 0x3FFL) << 19) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 8] >>> 10 & 0x1FFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 8] >>> 39 | (in[inPos + 9] & 0xFL) << 25) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 9] >>> 4 & 0x1FFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 9] >>> 33 & 0x1FFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 9] >>> 62 | (in[inPos + 10] & 0x7FFFFFFL) << 2) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 10] >>> 27 & 0x1FFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 10] >>> 56 | (in[inPos + 11] & 0x1FFFFFL) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 11] >>> 21 & 0x1FFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 11] >>> 50 | (in[inPos + 12] & 0x7FFFL) << 14) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 12] >>> 15 & 0x1FFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 12] >>> 44 | (in[inPos + 13] & 0x1FFL) << 20) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 13] >>> 9 & 0x1FFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 13] >>> 38 | (in[inPos + 14] & 7L) << 26) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 14] >>> 3 & 0x1FFFFFFFL) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 14] >>> 32 & 0x1FFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 14] >>> 61 | (in[inPos + 15] & 0x3FFFFFFL) << 3) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 15] >>> 26 & 0x1FFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 15] >>> 55 | (in[inPos + 16] & 0xFFFFFL) << 9) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 16] >>> 20 & 0x1FFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 16] >>> 49 | (in[inPos + 17] & 0x3FFFL) << 15) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 17] >>> 14 & 0x1FFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 17] >>> 43 | (in[inPos + 18] & 0xFFL) << 21) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 18] >>> 8 & 0x1FFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 18] >>> 37 | (in[inPos + 19] & 3L) << 27) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 19] >>> 2 & 0x1FFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 19] >>> 31 & 0x1FFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 19] >>> 60 | (in[inPos + 20] & 0x1FFFFFFL) << 4) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 20] >>> 25 & 0x1FFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 20] >>> 54 | (in[inPos + 21] & 0x7FFFFL) << 10) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 21] >>> 19 & 0x1FFFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 21] >>> 48 | (in[inPos + 22] & 0x1FFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 22] >>> 13 & 0x1FFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 22] >>> 42 | (in[inPos + 23] & 0x7FL) << 22) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 23] >>> 7 & 0x1FFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 23] >>> 36 | (in[inPos + 24] & 1L) << 28) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 24] >>> 1 & 0x1FFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 24] >>> 30 & 0x1FFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 24] >>> 59 | (in[inPos + 25] & 0xFFFFFFL) << 5) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 25] >>> 24 & 0x1FFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 25] >>> 53 | (in[inPos + 26] & 0x3FFFFL) << 11) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 26] >>> 18 & 0x1FFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 26] >>> 47 | (in[inPos + 27] & 0xFFFL) << 17) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 27] >>> 12 & 0x1FFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 27] >>> 41 | (in[inPos + 28] & 0x3FL) << 23) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 28] >>> 6 & 0x1FFFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 28] >>> 35) + out[outPos + 62];
    }

    private static void pack30(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 30 | in[inPos + 2] - in[inPos + 1] << 60;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 4 | in[inPos + 3] - in[inPos + 2] << 26 | in[inPos + 4] - in[inPos + 3] << 56;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 8 | in[inPos + 5] - in[inPos + 4] << 22 | in[inPos + 6] - in[inPos + 5] << 52;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] >>> 12 | in[inPos + 7] - in[inPos + 6] << 18 | in[inPos + 8] - in[inPos + 7] << 48;
        out[outPos + 4] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 14 | in[inPos + 10] - in[inPos + 9] << 44;
        out[outPos + 5] = in[inPos + 10] - in[inPos + 9] >>> 20 | in[inPos + 11] - in[inPos + 10] << 10 | in[inPos + 12] - in[inPos + 11] << 40;
        out[outPos + 6] = in[inPos + 12] - in[inPos + 11] >>> 24 | in[inPos + 13] - in[inPos + 12] << 6 | in[inPos + 14] - in[inPos + 13] << 36;
        out[outPos + 7] = in[inPos + 14] - in[inPos + 13] >>> 28 | in[inPos + 15] - in[inPos + 14] << 2 | in[inPos + 16] - in[inPos + 15] << 32 | in[inPos + 17] - in[inPos + 16] << 62;
        out[outPos + 8] = in[inPos + 17] - in[inPos + 16] >>> 2 | in[inPos + 18] - in[inPos + 17] << 28 | in[inPos + 19] - in[inPos + 18] << 58;
        out[outPos + 9] = in[inPos + 19] - in[inPos + 18] >>> 6 | in[inPos + 20] - in[inPos + 19] << 24 | in[inPos + 21] - in[inPos + 20] << 54;
        out[outPos + 10] = in[inPos + 21] - in[inPos + 20] >>> 10 | in[inPos + 22] - in[inPos + 21] << 20 | in[inPos + 23] - in[inPos + 22] << 50;
        out[outPos + 11] = in[inPos + 23] - in[inPos + 22] >>> 14 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 46;
        out[outPos + 12] = in[inPos + 25] - in[inPos + 24] >>> 18 | in[inPos + 26] - in[inPos + 25] << 12 | in[inPos + 27] - in[inPos + 26] << 42;
        out[outPos + 13] = in[inPos + 27] - in[inPos + 26] >>> 22 | in[inPos + 28] - in[inPos + 27] << 8 | in[inPos + 29] - in[inPos + 28] << 38;
        out[outPos + 14] = in[inPos + 29] - in[inPos + 28] >>> 26 | in[inPos + 30] - in[inPos + 29] << 4 | in[inPos + 31] - in[inPos + 30] << 34;
        out[outPos + 15] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 30 | in[inPos + 34] - in[inPos + 33] << 60;
        out[outPos + 16] = in[inPos + 34] - in[inPos + 33] >>> 4 | in[inPos + 35] - in[inPos + 34] << 26 | in[inPos + 36] - in[inPos + 35] << 56;
        out[outPos + 17] = in[inPos + 36] - in[inPos + 35] >>> 8 | in[inPos + 37] - in[inPos + 36] << 22 | in[inPos + 38] - in[inPos + 37] << 52;
        out[outPos + 18] = in[inPos + 38] - in[inPos + 37] >>> 12 | in[inPos + 39] - in[inPos + 38] << 18 | in[inPos + 40] - in[inPos + 39] << 48;
        out[outPos + 19] = in[inPos + 40] - in[inPos + 39] >>> 16 | in[inPos + 41] - in[inPos + 40] << 14 | in[inPos + 42] - in[inPos + 41] << 44;
        out[outPos + 20] = in[inPos + 42] - in[inPos + 41] >>> 20 | in[inPos + 43] - in[inPos + 42] << 10 | in[inPos + 44] - in[inPos + 43] << 40;
        out[outPos + 21] = in[inPos + 44] - in[inPos + 43] >>> 24 | in[inPos + 45] - in[inPos + 44] << 6 | in[inPos + 46] - in[inPos + 45] << 36;
        out[outPos + 22] = in[inPos + 46] - in[inPos + 45] >>> 28 | in[inPos + 47] - in[inPos + 46] << 2 | in[inPos + 48] - in[inPos + 47] << 32 | in[inPos + 49] - in[inPos + 48] << 62;
        out[outPos + 23] = in[inPos + 49] - in[inPos + 48] >>> 2 | in[inPos + 50] - in[inPos + 49] << 28 | in[inPos + 51] - in[inPos + 50] << 58;
        out[outPos + 24] = in[inPos + 51] - in[inPos + 50] >>> 6 | in[inPos + 52] - in[inPos + 51] << 24 | in[inPos + 53] - in[inPos + 52] << 54;
        out[outPos + 25] = in[inPos + 53] - in[inPos + 52] >>> 10 | in[inPos + 54] - in[inPos + 53] << 20 | in[inPos + 55] - in[inPos + 54] << 50;
        out[outPos + 26] = in[inPos + 55] - in[inPos + 54] >>> 14 | in[inPos + 56] - in[inPos + 55] << 16 | in[inPos + 57] - in[inPos + 56] << 46;
        out[outPos + 27] = in[inPos + 57] - in[inPos + 56] >>> 18 | in[inPos + 58] - in[inPos + 57] << 12 | in[inPos + 59] - in[inPos + 58] << 42;
        out[outPos + 28] = in[inPos + 59] - in[inPos + 58] >>> 22 | in[inPos + 60] - in[inPos + 59] << 8 | in[inPos + 61] - in[inPos + 60] << 38;
        out[outPos + 29] = in[inPos + 61] - in[inPos + 60] >>> 26 | in[inPos + 62] - in[inPos + 61] << 4 | in[inPos + 63] - in[inPos + 62] << 34;
    }

    private static void unpack30(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 30 & 0x3FFFFFFFL) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 60 | (in[inPos + 1] & 0x3FFFFFFL) << 4) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 26 & 0x3FFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 0x3FFFFFL) << 8) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 22 & 0x3FFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 52 | (in[inPos + 3] & 0x3FFFFL) << 12) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 18 & 0x3FFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 48 | (in[inPos + 4] & 0x3FFFL) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 14 & 0x3FFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 44 | (in[inPos + 5] & 0x3FFL) << 20) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 10 & 0x3FFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 5] >>> 40 | (in[inPos + 6] & 0x3FL) << 24) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 6 & 0x3FFFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 6] >>> 36 | (in[inPos + 7] & 3L) << 28) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 2 & 0x3FFFFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 7] >>> 32 & 0x3FFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 7] >>> 62 | (in[inPos + 8] & 0xFFFFFFFL) << 2) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 8] >>> 28 & 0x3FFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 8] >>> 58 | (in[inPos + 9] & 0xFFFFFFL) << 6) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 9] >>> 24 & 0x3FFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0xFFFFFL) << 10) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 10] >>> 20 & 0x3FFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 10] >>> 50 | (in[inPos + 11] & 0xFFFFL) << 14) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 11] >>> 16 & 0x3FFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 11] >>> 46 | (in[inPos + 12] & 0xFFFL) << 18) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 12] >>> 12 & 0x3FFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 12] >>> 42 | (in[inPos + 13] & 0xFFL) << 22) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 13] >>> 8 & 0x3FFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 13] >>> 38 | (in[inPos + 14] & 0xFL) << 26) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 14] >>> 4 & 0x3FFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 14] >>> 34) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 15] & 0x3FFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 15] >>> 30 & 0x3FFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 15] >>> 60 | (in[inPos + 16] & 0x3FFFFFFL) << 4) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 16] >>> 26 & 0x3FFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0x3FFFFFL) << 8) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 17] >>> 22 & 0x3FFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 17] >>> 52 | (in[inPos + 18] & 0x3FFFFL) << 12) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 18] >>> 18 & 0x3FFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0x3FFFL) << 16) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 19] >>> 14 & 0x3FFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0x3FFL) << 20) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 20] >>> 10 & 0x3FFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 20] >>> 40 | (in[inPos + 21] & 0x3FL) << 24) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 21] >>> 6 & 0x3FFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 21] >>> 36 | (in[inPos + 22] & 3L) << 28) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 22] >>> 2 & 0x3FFFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 22] >>> 32 & 0x3FFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 22] >>> 62 | (in[inPos + 23] & 0xFFFFFFFL) << 2) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 23] >>> 28 & 0x3FFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 23] >>> 58 | (in[inPos + 24] & 0xFFFFFFL) << 6) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 24] >>> 24 & 0x3FFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 24] >>> 54 | (in[inPos + 25] & 0xFFFFFL) << 10) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 25] >>> 20 & 0x3FFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 25] >>> 50 | (in[inPos + 26] & 0xFFFFL) << 14) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 26] >>> 16 & 0x3FFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 26] >>> 46 | (in[inPos + 27] & 0xFFFL) << 18) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 27] >>> 12 & 0x3FFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 27] >>> 42 | (in[inPos + 28] & 0xFFL) << 22) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 28] >>> 8 & 0x3FFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 28] >>> 38 | (in[inPos + 29] & 0xFL) << 26) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 29] >>> 4 & 0x3FFFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 29] >>> 34) + out[outPos + 62];
    }

    private static void pack31(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 31 | in[inPos + 2] - in[inPos + 1] << 62;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] >>> 2 | in[inPos + 3] - in[inPos + 2] << 29 | in[inPos + 4] - in[inPos + 3] << 60;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 27 | in[inPos + 6] - in[inPos + 5] << 58;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] >>> 6 | in[inPos + 7] - in[inPos + 6] << 25 | in[inPos + 8] - in[inPos + 7] << 56;
        out[outPos + 4] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 23 | in[inPos + 10] - in[inPos + 9] << 54;
        out[outPos + 5] = in[inPos + 10] - in[inPos + 9] >>> 10 | in[inPos + 11] - in[inPos + 10] << 21 | in[inPos + 12] - in[inPos + 11] << 52;
        out[outPos + 6] = in[inPos + 12] - in[inPos + 11] >>> 12 | in[inPos + 13] - in[inPos + 12] << 19 | in[inPos + 14] - in[inPos + 13] << 50;
        out[outPos + 7] = in[inPos + 14] - in[inPos + 13] >>> 14 | in[inPos + 15] - in[inPos + 14] << 17 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 8] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 15 | in[inPos + 18] - in[inPos + 17] << 46;
        out[outPos + 9] = in[inPos + 18] - in[inPos + 17] >>> 18 | in[inPos + 19] - in[inPos + 18] << 13 | in[inPos + 20] - in[inPos + 19] << 44;
        out[outPos + 10] = in[inPos + 20] - in[inPos + 19] >>> 20 | in[inPos + 21] - in[inPos + 20] << 11 | in[inPos + 22] - in[inPos + 21] << 42;
        out[outPos + 11] = in[inPos + 22] - in[inPos + 21] >>> 22 | in[inPos + 23] - in[inPos + 22] << 9 | in[inPos + 24] - in[inPos + 23] << 40;
        out[outPos + 12] = in[inPos + 24] - in[inPos + 23] >>> 24 | in[inPos + 25] - in[inPos + 24] << 7 | in[inPos + 26] - in[inPos + 25] << 38;
        out[outPos + 13] = in[inPos + 26] - in[inPos + 25] >>> 26 | in[inPos + 27] - in[inPos + 26] << 5 | in[inPos + 28] - in[inPos + 27] << 36;
        out[outPos + 14] = in[inPos + 28] - in[inPos + 27] >>> 28 | in[inPos + 29] - in[inPos + 28] << 3 | in[inPos + 30] - in[inPos + 29] << 34;
        out[outPos + 15] = in[inPos + 30] - in[inPos + 29] >>> 30 | in[inPos + 31] - in[inPos + 30] << 1 | in[inPos + 32] - in[inPos + 31] << 32 | in[inPos + 33] - in[inPos + 32] << 63;
        out[outPos + 16] = in[inPos + 33] - in[inPos + 32] >>> 1 | in[inPos + 34] - in[inPos + 33] << 30 | in[inPos + 35] - in[inPos + 34] << 61;
        out[outPos + 17] = in[inPos + 35] - in[inPos + 34] >>> 3 | in[inPos + 36] - in[inPos + 35] << 28 | in[inPos + 37] - in[inPos + 36] << 59;
        out[outPos + 18] = in[inPos + 37] - in[inPos + 36] >>> 5 | in[inPos + 38] - in[inPos + 37] << 26 | in[inPos + 39] - in[inPos + 38] << 57;
        out[outPos + 19] = in[inPos + 39] - in[inPos + 38] >>> 7 | in[inPos + 40] - in[inPos + 39] << 24 | in[inPos + 41] - in[inPos + 40] << 55;
        out[outPos + 20] = in[inPos + 41] - in[inPos + 40] >>> 9 | in[inPos + 42] - in[inPos + 41] << 22 | in[inPos + 43] - in[inPos + 42] << 53;
        out[outPos + 21] = in[inPos + 43] - in[inPos + 42] >>> 11 | in[inPos + 44] - in[inPos + 43] << 20 | in[inPos + 45] - in[inPos + 44] << 51;
        out[outPos + 22] = in[inPos + 45] - in[inPos + 44] >>> 13 | in[inPos + 46] - in[inPos + 45] << 18 | in[inPos + 47] - in[inPos + 46] << 49;
        out[outPos + 23] = in[inPos + 47] - in[inPos + 46] >>> 15 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 47;
        out[outPos + 24] = in[inPos + 49] - in[inPos + 48] >>> 17 | in[inPos + 50] - in[inPos + 49] << 14 | in[inPos + 51] - in[inPos + 50] << 45;
        out[outPos + 25] = in[inPos + 51] - in[inPos + 50] >>> 19 | in[inPos + 52] - in[inPos + 51] << 12 | in[inPos + 53] - in[inPos + 52] << 43;
        out[outPos + 26] = in[inPos + 53] - in[inPos + 52] >>> 21 | in[inPos + 54] - in[inPos + 53] << 10 | in[inPos + 55] - in[inPos + 54] << 41;
        out[outPos + 27] = in[inPos + 55] - in[inPos + 54] >>> 23 | in[inPos + 56] - in[inPos + 55] << 8 | in[inPos + 57] - in[inPos + 56] << 39;
        out[outPos + 28] = in[inPos + 57] - in[inPos + 56] >>> 25 | in[inPos + 58] - in[inPos + 57] << 6 | in[inPos + 59] - in[inPos + 58] << 37;
        out[outPos + 29] = in[inPos + 59] - in[inPos + 58] >>> 27 | in[inPos + 60] - in[inPos + 59] << 4 | in[inPos + 61] - in[inPos + 60] << 35;
        out[outPos + 30] = in[inPos + 61] - in[inPos + 60] >>> 29 | in[inPos + 62] - in[inPos + 61] << 2 | in[inPos + 63] - in[inPos + 62] << 33;
    }

    private static void unpack31(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & Integer.MAX_VALUE) + initValue;
        out[outPos + 1] = (in[inPos] >>> 31 & Integer.MAX_VALUE) + out[outPos];
        out[outPos + 2] = (in[inPos] >>> 62 | (in[inPos + 1] & 0x1FFFFFFFL) << 2) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 29 & Integer.MAX_VALUE) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 1] >>> 60 | (in[inPos + 2] & 0x7FFFFFFL) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 27 & Integer.MAX_VALUE) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 2] >>> 58 | (in[inPos + 3] & 0x1FFFFFFL) << 6) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 25 & Integer.MAX_VALUE) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 3] >>> 56 | (in[inPos + 4] & 0x7FFFFFL) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 23 & Integer.MAX_VALUE) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 4] >>> 54 | (in[inPos + 5] & 0x1FFFFFL) << 10) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 21 & Integer.MAX_VALUE) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 5] >>> 52 | (in[inPos + 6] & 0x7FFFFL) << 12) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 19 & Integer.MAX_VALUE) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 6] >>> 50 | (in[inPos + 7] & 0x1FFFFL) << 14) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 17 & Integer.MAX_VALUE) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 7] >>> 48 | (in[inPos + 8] & 0x7FFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 8] >>> 15 & Integer.MAX_VALUE) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 8] >>> 46 | (in[inPos + 9] & 0x1FFFL) << 18) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 9] >>> 13 & Integer.MAX_VALUE) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 9] >>> 44 | (in[inPos + 10] & 0x7FFL) << 20) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 10] >>> 11 & Integer.MAX_VALUE) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 10] >>> 42 | (in[inPos + 11] & 0x1FFL) << 22) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 11] >>> 9 & Integer.MAX_VALUE) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 11] >>> 40 | (in[inPos + 12] & 0x7FL) << 24) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 12] >>> 7 & Integer.MAX_VALUE) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 12] >>> 38 | (in[inPos + 13] & 0x1FL) << 26) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 13] >>> 5 & Integer.MAX_VALUE) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 13] >>> 36 | (in[inPos + 14] & 7L) << 28) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 14] >>> 3 & Integer.MAX_VALUE) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 14] >>> 34 | (in[inPos + 15] & 1L) << 30) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 15] >>> 1 & Integer.MAX_VALUE) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 15] >>> 32 & Integer.MAX_VALUE) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 15] >>> 63 | (in[inPos + 16] & 0x3FFFFFFFL) << 1) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 16] >>> 30 & Integer.MAX_VALUE) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 16] >>> 61 | (in[inPos + 17] & 0xFFFFFFFL) << 3) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 17] >>> 28 & Integer.MAX_VALUE) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 17] >>> 59 | (in[inPos + 18] & 0x3FFFFFFL) << 5) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 18] >>> 26 & Integer.MAX_VALUE) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 18] >>> 57 | (in[inPos + 19] & 0xFFFFFFL) << 7) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 19] >>> 24 & Integer.MAX_VALUE) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 19] >>> 55 | (in[inPos + 20] & 0x3FFFFFL) << 9) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 20] >>> 22 & Integer.MAX_VALUE) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 20] >>> 53 | (in[inPos + 21] & 0xFFFFFL) << 11) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 21] >>> 20 & Integer.MAX_VALUE) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 21] >>> 51 | (in[inPos + 22] & 0x3FFFFL) << 13) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 22] >>> 18 & Integer.MAX_VALUE) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 22] >>> 49 | (in[inPos + 23] & 0xFFFFL) << 15) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 23] >>> 16 & Integer.MAX_VALUE) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 23] >>> 47 | (in[inPos + 24] & 0x3FFFL) << 17) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 24] >>> 14 & Integer.MAX_VALUE) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 24] >>> 45 | (in[inPos + 25] & 0xFFFL) << 19) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 25] >>> 12 & Integer.MAX_VALUE) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 25] >>> 43 | (in[inPos + 26] & 0x3FFL) << 21) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 26] >>> 10 & Integer.MAX_VALUE) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 26] >>> 41 | (in[inPos + 27] & 0xFFL) << 23) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 27] >>> 8 & Integer.MAX_VALUE) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 27] >>> 39 | (in[inPos + 28] & 0x3FL) << 25) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 28] >>> 6 & Integer.MAX_VALUE) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 28] >>> 37 | (in[inPos + 29] & 0xFL) << 27) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 29] >>> 4 & Integer.MAX_VALUE) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 29] >>> 35 | (in[inPos + 30] & 3L) << 29) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 30] >>> 2 & Integer.MAX_VALUE) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 30] >>> 33) + out[outPos + 62];
    }

    private static void pack32(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 32;
        out[outPos + 1] = in[inPos + 2] - in[inPos + 1] | in[inPos + 3] - in[inPos + 2] << 32;
        out[outPos + 2] = in[inPos + 4] - in[inPos + 3] | in[inPos + 5] - in[inPos + 4] << 32;
        out[outPos + 3] = in[inPos + 6] - in[inPos + 5] | in[inPos + 7] - in[inPos + 6] << 32;
        out[outPos + 4] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 32;
        out[outPos + 5] = in[inPos + 10] - in[inPos + 9] | in[inPos + 11] - in[inPos + 10] << 32;
        out[outPos + 6] = in[inPos + 12] - in[inPos + 11] | in[inPos + 13] - in[inPos + 12] << 32;
        out[outPos + 7] = in[inPos + 14] - in[inPos + 13] | in[inPos + 15] - in[inPos + 14] << 32;
        out[outPos + 8] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 32;
        out[outPos + 9] = in[inPos + 18] - in[inPos + 17] | in[inPos + 19] - in[inPos + 18] << 32;
        out[outPos + 10] = in[inPos + 20] - in[inPos + 19] | in[inPos + 21] - in[inPos + 20] << 32;
        out[outPos + 11] = in[inPos + 22] - in[inPos + 21] | in[inPos + 23] - in[inPos + 22] << 32;
        out[outPos + 12] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 32;
        out[outPos + 13] = in[inPos + 26] - in[inPos + 25] | in[inPos + 27] - in[inPos + 26] << 32;
        out[outPos + 14] = in[inPos + 28] - in[inPos + 27] | in[inPos + 29] - in[inPos + 28] << 32;
        out[outPos + 15] = in[inPos + 30] - in[inPos + 29] | in[inPos + 31] - in[inPos + 30] << 32;
        out[outPos + 16] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 32;
        out[outPos + 17] = in[inPos + 34] - in[inPos + 33] | in[inPos + 35] - in[inPos + 34] << 32;
        out[outPos + 18] = in[inPos + 36] - in[inPos + 35] | in[inPos + 37] - in[inPos + 36] << 32;
        out[outPos + 19] = in[inPos + 38] - in[inPos + 37] | in[inPos + 39] - in[inPos + 38] << 32;
        out[outPos + 20] = in[inPos + 40] - in[inPos + 39] | in[inPos + 41] - in[inPos + 40] << 32;
        out[outPos + 21] = in[inPos + 42] - in[inPos + 41] | in[inPos + 43] - in[inPos + 42] << 32;
        out[outPos + 22] = in[inPos + 44] - in[inPos + 43] | in[inPos + 45] - in[inPos + 44] << 32;
        out[outPos + 23] = in[inPos + 46] - in[inPos + 45] | in[inPos + 47] - in[inPos + 46] << 32;
        out[outPos + 24] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 32;
        out[outPos + 25] = in[inPos + 50] - in[inPos + 49] | in[inPos + 51] - in[inPos + 50] << 32;
        out[outPos + 26] = in[inPos + 52] - in[inPos + 51] | in[inPos + 53] - in[inPos + 52] << 32;
        out[outPos + 27] = in[inPos + 54] - in[inPos + 53] | in[inPos + 55] - in[inPos + 54] << 32;
        out[outPos + 28] = in[inPos + 56] - in[inPos + 55] | in[inPos + 57] - in[inPos + 56] << 32;
        out[outPos + 29] = in[inPos + 58] - in[inPos + 57] | in[inPos + 59] - in[inPos + 58] << 32;
        out[outPos + 30] = in[inPos + 60] - in[inPos + 59] | in[inPos + 61] - in[inPos + 60] << 32;
        out[outPos + 31] = in[inPos + 62] - in[inPos + 61] | in[inPos + 63] - in[inPos + 62] << 32;
    }

    private static void unpack32(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 32) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] & 0xFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 32) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] & 0xFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 32) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] & 0xFFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 32) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] & 0xFFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 32) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] & 0xFFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 32) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] & 0xFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 32) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] & 0xFFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 32) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 8] & 0xFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 8] >>> 32) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 9] & 0xFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 9] >>> 32) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 10] & 0xFFFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 10] >>> 32) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 11] & 0xFFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 11] >>> 32) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 12] & 0xFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 12] >>> 32) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 13] & 0xFFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 13] >>> 32) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 14] & 0xFFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 14] >>> 32) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 15] & 0xFFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 15] >>> 32) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 16] & 0xFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 16] >>> 32) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 17] & 0xFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 17] >>> 32) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 18] & 0xFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 18] >>> 32) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 19] & 0xFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 19] >>> 32) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 20] & 0xFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 20] >>> 32) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 21] & 0xFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 21] >>> 32) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 22] & 0xFFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 22] >>> 32) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 23] & 0xFFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 23] >>> 32) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 24] & 0xFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 24] >>> 32) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 25] & 0xFFFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 25] >>> 32) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 26] & 0xFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 26] >>> 32) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 27] & 0xFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 27] >>> 32) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 28] & 0xFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 28] >>> 32) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 29] & 0xFFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 29] >>> 32) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 30] & 0xFFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 30] >>> 32) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 31] & 0xFFFFFFFFL) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 31] >>> 32) + out[outPos + 62];
    }

    private static void pack33(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 33;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 31 | in[inPos + 2] - in[inPos + 1] << 2 | in[inPos + 3] - in[inPos + 2] << 35;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 29 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 37;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 27 | in[inPos + 6] - in[inPos + 5] << 6 | in[inPos + 7] - in[inPos + 6] << 39;
        out[outPos + 4] = in[inPos + 7] - in[inPos + 6] >>> 25 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 41;
        out[outPos + 5] = in[inPos + 9] - in[inPos + 8] >>> 23 | in[inPos + 10] - in[inPos + 9] << 10 | in[inPos + 11] - in[inPos + 10] << 43;
        out[outPos + 6] = in[inPos + 11] - in[inPos + 10] >>> 21 | in[inPos + 12] - in[inPos + 11] << 12 | in[inPos + 13] - in[inPos + 12] << 45;
        out[outPos + 7] = in[inPos + 13] - in[inPos + 12] >>> 19 | in[inPos + 14] - in[inPos + 13] << 14 | in[inPos + 15] - in[inPos + 14] << 47;
        out[outPos + 8] = in[inPos + 15] - in[inPos + 14] >>> 17 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 49;
        out[outPos + 9] = in[inPos + 17] - in[inPos + 16] >>> 15 | in[inPos + 18] - in[inPos + 17] << 18 | in[inPos + 19] - in[inPos + 18] << 51;
        out[outPos + 10] = in[inPos + 19] - in[inPos + 18] >>> 13 | in[inPos + 20] - in[inPos + 19] << 20 | in[inPos + 21] - in[inPos + 20] << 53;
        out[outPos + 11] = in[inPos + 21] - in[inPos + 20] >>> 11 | in[inPos + 22] - in[inPos + 21] << 22 | in[inPos + 23] - in[inPos + 22] << 55;
        out[outPos + 12] = in[inPos + 23] - in[inPos + 22] >>> 9 | in[inPos + 24] - in[inPos + 23] << 24 | in[inPos + 25] - in[inPos + 24] << 57;
        out[outPos + 13] = in[inPos + 25] - in[inPos + 24] >>> 7 | in[inPos + 26] - in[inPos + 25] << 26 | in[inPos + 27] - in[inPos + 26] << 59;
        out[outPos + 14] = in[inPos + 27] - in[inPos + 26] >>> 5 | in[inPos + 28] - in[inPos + 27] << 28 | in[inPos + 29] - in[inPos + 28] << 61;
        out[outPos + 15] = in[inPos + 29] - in[inPos + 28] >>> 3 | in[inPos + 30] - in[inPos + 29] << 30 | in[inPos + 31] - in[inPos + 30] << 63;
        out[outPos + 16] = in[inPos + 31] - in[inPos + 30] >>> 1 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 17] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 1 | in[inPos + 34] - in[inPos + 33] << 34;
        out[outPos + 18] = in[inPos + 34] - in[inPos + 33] >>> 30 | in[inPos + 35] - in[inPos + 34] << 3 | in[inPos + 36] - in[inPos + 35] << 36;
        out[outPos + 19] = in[inPos + 36] - in[inPos + 35] >>> 28 | in[inPos + 37] - in[inPos + 36] << 5 | in[inPos + 38] - in[inPos + 37] << 38;
        out[outPos + 20] = in[inPos + 38] - in[inPos + 37] >>> 26 | in[inPos + 39] - in[inPos + 38] << 7 | in[inPos + 40] - in[inPos + 39] << 40;
        out[outPos + 21] = in[inPos + 40] - in[inPos + 39] >>> 24 | in[inPos + 41] - in[inPos + 40] << 9 | in[inPos + 42] - in[inPos + 41] << 42;
        out[outPos + 22] = in[inPos + 42] - in[inPos + 41] >>> 22 | in[inPos + 43] - in[inPos + 42] << 11 | in[inPos + 44] - in[inPos + 43] << 44;
        out[outPos + 23] = in[inPos + 44] - in[inPos + 43] >>> 20 | in[inPos + 45] - in[inPos + 44] << 13 | in[inPos + 46] - in[inPos + 45] << 46;
        out[outPos + 24] = in[inPos + 46] - in[inPos + 45] >>> 18 | in[inPos + 47] - in[inPos + 46] << 15 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 25] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 17 | in[inPos + 50] - in[inPos + 49] << 50;
        out[outPos + 26] = in[inPos + 50] - in[inPos + 49] >>> 14 | in[inPos + 51] - in[inPos + 50] << 19 | in[inPos + 52] - in[inPos + 51] << 52;
        out[outPos + 27] = in[inPos + 52] - in[inPos + 51] >>> 12 | in[inPos + 53] - in[inPos + 52] << 21 | in[inPos + 54] - in[inPos + 53] << 54;
        out[outPos + 28] = in[inPos + 54] - in[inPos + 53] >>> 10 | in[inPos + 55] - in[inPos + 54] << 23 | in[inPos + 56] - in[inPos + 55] << 56;
        out[outPos + 29] = in[inPos + 56] - in[inPos + 55] >>> 8 | in[inPos + 57] - in[inPos + 56] << 25 | in[inPos + 58] - in[inPos + 57] << 58;
        out[outPos + 30] = in[inPos + 58] - in[inPos + 57] >>> 6 | in[inPos + 59] - in[inPos + 58] << 27 | in[inPos + 60] - in[inPos + 59] << 60;
        out[outPos + 31] = in[inPos + 60] - in[inPos + 59] >>> 4 | in[inPos + 61] - in[inPos + 60] << 29 | in[inPos + 62] - in[inPos + 61] << 62;
        out[outPos + 32] = in[inPos + 62] - in[inPos + 61] >>> 2 | in[inPos + 63] - in[inPos + 62] << 31;
    }

    private static void unpack33(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 33 | (in[inPos + 1] & 3L) << 31) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 2 & 0x1FFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 35 | (in[inPos + 2] & 0xFL) << 29) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 4 & 0x1FFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 37 | (in[inPos + 3] & 0x3FL) << 27) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 6 & 0x1FFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 39 | (in[inPos + 4] & 0xFFL) << 25) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 8 & 0x1FFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 41 | (in[inPos + 5] & 0x3FFL) << 23) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 10 & 0x1FFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 43 | (in[inPos + 6] & 0xFFFL) << 21) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] >>> 12 & 0x1FFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 45 | (in[inPos + 7] & 0x3FFFL) << 19) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] >>> 14 & 0x1FFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 47 | (in[inPos + 8] & 0xFFFFL) << 17) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 8] >>> 16 & 0x1FFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 8] >>> 49 | (in[inPos + 9] & 0x3FFFFL) << 15) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 9] >>> 18 & 0x1FFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 9] >>> 51 | (in[inPos + 10] & 0xFFFFFL) << 13) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 10] >>> 20 & 0x1FFFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 10] >>> 53 | (in[inPos + 11] & 0x3FFFFFL) << 11) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 11] >>> 22 & 0x1FFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 11] >>> 55 | (in[inPos + 12] & 0xFFFFFFL) << 9) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 12] >>> 24 & 0x1FFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 12] >>> 57 | (in[inPos + 13] & 0x3FFFFFFL) << 7) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 13] >>> 26 & 0x1FFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 13] >>> 59 | (in[inPos + 14] & 0xFFFFFFFL) << 5) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 14] >>> 28 & 0x1FFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 14] >>> 61 | (in[inPos + 15] & 0x3FFFFFFFL) << 3) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 15] >>> 30 & 0x1FFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 15] >>> 63 | (in[inPos + 16] & 0xFFFFFFFFL) << 1) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 16] >>> 32 | (in[inPos + 17] & 1L) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 17] >>> 1 & 0x1FFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 17] >>> 34 | (in[inPos + 18] & 7L) << 30) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 18] >>> 3 & 0x1FFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 18] >>> 36 | (in[inPos + 19] & 0x1FL) << 28) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 19] >>> 5 & 0x1FFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 19] >>> 38 | (in[inPos + 20] & 0x7FL) << 26) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 20] >>> 7 & 0x1FFFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 20] >>> 40 | (in[inPos + 21] & 0x1FFL) << 24) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 21] >>> 9 & 0x1FFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 21] >>> 42 | (in[inPos + 22] & 0x7FFL) << 22) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 22] >>> 11 & 0x1FFFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 22] >>> 44 | (in[inPos + 23] & 0x1FFFL) << 20) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 23] >>> 13 & 0x1FFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 23] >>> 46 | (in[inPos + 24] & 0x7FFFL) << 18) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 24] >>> 15 & 0x1FFFFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 24] >>> 48 | (in[inPos + 25] & 0x1FFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 25] >>> 17 & 0x1FFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 25] >>> 50 | (in[inPos + 26] & 0x7FFFFL) << 14) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 26] >>> 19 & 0x1FFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 26] >>> 52 | (in[inPos + 27] & 0x1FFFFFL) << 12) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 27] >>> 21 & 0x1FFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 27] >>> 54 | (in[inPos + 28] & 0x7FFFFFL) << 10) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 28] >>> 23 & 0x1FFFFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 28] >>> 56 | (in[inPos + 29] & 0x1FFFFFFL) << 8) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 29] >>> 25 & 0x1FFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 29] >>> 58 | (in[inPos + 30] & 0x7FFFFFFL) << 6) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 30] >>> 27 & 0x1FFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 30] >>> 60 | (in[inPos + 31] & 0x1FFFFFFFL) << 4) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 31] >>> 29 & 0x1FFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 31] >>> 62 | (in[inPos + 32] & Integer.MAX_VALUE) << 2) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 32] >>> 31) + out[outPos + 62];
    }

    private static void pack34(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 34;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 30 | in[inPos + 2] - in[inPos + 1] << 4 | in[inPos + 3] - in[inPos + 2] << 38;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 26 | in[inPos + 4] - in[inPos + 3] << 8 | in[inPos + 5] - in[inPos + 4] << 42;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 22 | in[inPos + 6] - in[inPos + 5] << 12 | in[inPos + 7] - in[inPos + 6] << 46;
        out[outPos + 4] = in[inPos + 7] - in[inPos + 6] >>> 18 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 50;
        out[outPos + 5] = in[inPos + 9] - in[inPos + 8] >>> 14 | in[inPos + 10] - in[inPos + 9] << 20 | in[inPos + 11] - in[inPos + 10] << 54;
        out[outPos + 6] = in[inPos + 11] - in[inPos + 10] >>> 10 | in[inPos + 12] - in[inPos + 11] << 24 | in[inPos + 13] - in[inPos + 12] << 58;
        out[outPos + 7] = in[inPos + 13] - in[inPos + 12] >>> 6 | in[inPos + 14] - in[inPos + 13] << 28 | in[inPos + 15] - in[inPos + 14] << 62;
        out[outPos + 8] = in[inPos + 15] - in[inPos + 14] >>> 2 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 9] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 2 | in[inPos + 18] - in[inPos + 17] << 36;
        out[outPos + 10] = in[inPos + 18] - in[inPos + 17] >>> 28 | in[inPos + 19] - in[inPos + 18] << 6 | in[inPos + 20] - in[inPos + 19] << 40;
        out[outPos + 11] = in[inPos + 20] - in[inPos + 19] >>> 24 | in[inPos + 21] - in[inPos + 20] << 10 | in[inPos + 22] - in[inPos + 21] << 44;
        out[outPos + 12] = in[inPos + 22] - in[inPos + 21] >>> 20 | in[inPos + 23] - in[inPos + 22] << 14 | in[inPos + 24] - in[inPos + 23] << 48;
        out[outPos + 13] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 18 | in[inPos + 26] - in[inPos + 25] << 52;
        out[outPos + 14] = in[inPos + 26] - in[inPos + 25] >>> 12 | in[inPos + 27] - in[inPos + 26] << 22 | in[inPos + 28] - in[inPos + 27] << 56;
        out[outPos + 15] = in[inPos + 28] - in[inPos + 27] >>> 8 | in[inPos + 29] - in[inPos + 28] << 26 | in[inPos + 30] - in[inPos + 29] << 60;
        out[outPos + 16] = in[inPos + 30] - in[inPos + 29] >>> 4 | in[inPos + 31] - in[inPos + 30] << 30;
        out[outPos + 17] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 34;
        out[outPos + 18] = in[inPos + 33] - in[inPos + 32] >>> 30 | in[inPos + 34] - in[inPos + 33] << 4 | in[inPos + 35] - in[inPos + 34] << 38;
        out[outPos + 19] = in[inPos + 35] - in[inPos + 34] >>> 26 | in[inPos + 36] - in[inPos + 35] << 8 | in[inPos + 37] - in[inPos + 36] << 42;
        out[outPos + 20] = in[inPos + 37] - in[inPos + 36] >>> 22 | in[inPos + 38] - in[inPos + 37] << 12 | in[inPos + 39] - in[inPos + 38] << 46;
        out[outPos + 21] = in[inPos + 39] - in[inPos + 38] >>> 18 | in[inPos + 40] - in[inPos + 39] << 16 | in[inPos + 41] - in[inPos + 40] << 50;
        out[outPos + 22] = in[inPos + 41] - in[inPos + 40] >>> 14 | in[inPos + 42] - in[inPos + 41] << 20 | in[inPos + 43] - in[inPos + 42] << 54;
        out[outPos + 23] = in[inPos + 43] - in[inPos + 42] >>> 10 | in[inPos + 44] - in[inPos + 43] << 24 | in[inPos + 45] - in[inPos + 44] << 58;
        out[outPos + 24] = in[inPos + 45] - in[inPos + 44] >>> 6 | in[inPos + 46] - in[inPos + 45] << 28 | in[inPos + 47] - in[inPos + 46] << 62;
        out[outPos + 25] = in[inPos + 47] - in[inPos + 46] >>> 2 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 26] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 2 | in[inPos + 50] - in[inPos + 49] << 36;
        out[outPos + 27] = in[inPos + 50] - in[inPos + 49] >>> 28 | in[inPos + 51] - in[inPos + 50] << 6 | in[inPos + 52] - in[inPos + 51] << 40;
        out[outPos + 28] = in[inPos + 52] - in[inPos + 51] >>> 24 | in[inPos + 53] - in[inPos + 52] << 10 | in[inPos + 54] - in[inPos + 53] << 44;
        out[outPos + 29] = in[inPos + 54] - in[inPos + 53] >>> 20 | in[inPos + 55] - in[inPos + 54] << 14 | in[inPos + 56] - in[inPos + 55] << 48;
        out[outPos + 30] = in[inPos + 56] - in[inPos + 55] >>> 16 | in[inPos + 57] - in[inPos + 56] << 18 | in[inPos + 58] - in[inPos + 57] << 52;
        out[outPos + 31] = in[inPos + 58] - in[inPos + 57] >>> 12 | in[inPos + 59] - in[inPos + 58] << 22 | in[inPos + 60] - in[inPos + 59] << 56;
        out[outPos + 32] = in[inPos + 60] - in[inPos + 59] >>> 8 | in[inPos + 61] - in[inPos + 60] << 26 | in[inPos + 62] - in[inPos + 61] << 60;
        out[outPos + 33] = in[inPos + 62] - in[inPos + 61] >>> 4 | in[inPos + 63] - in[inPos + 62] << 30;
    }

    private static void unpack34(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 34 | (in[inPos + 1] & 0xFL) << 30) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 4 & 0x3FFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 38 | (in[inPos + 2] & 0xFFL) << 26) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 8 & 0x3FFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 42 | (in[inPos + 3] & 0xFFFL) << 22) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 12 & 0x3FFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 46 | (in[inPos + 4] & 0xFFFFL) << 18) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 16 & 0x3FFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 50 | (in[inPos + 5] & 0xFFFFFL) << 14) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 20 & 0x3FFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 5] >>> 54 | (in[inPos + 6] & 0xFFFFFFL) << 10) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] >>> 24 & 0x3FFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 6] >>> 58 | (in[inPos + 7] & 0xFFFFFFFL) << 6) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] >>> 28 & 0x3FFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 7] >>> 62 | (in[inPos + 8] & 0xFFFFFFFFL) << 2) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 8] >>> 32 | (in[inPos + 9] & 3L) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 9] >>> 2 & 0x3FFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 9] >>> 36 | (in[inPos + 10] & 0x3FL) << 28) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 10] >>> 6 & 0x3FFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 10] >>> 40 | (in[inPos + 11] & 0x3FFL) << 24) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 11] >>> 10 & 0x3FFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 11] >>> 44 | (in[inPos + 12] & 0x3FFFL) << 20) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 12] >>> 14 & 0x3FFFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 12] >>> 48 | (in[inPos + 13] & 0x3FFFFL) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 13] >>> 18 & 0x3FFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 13] >>> 52 | (in[inPos + 14] & 0x3FFFFFL) << 12) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 14] >>> 22 & 0x3FFFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 14] >>> 56 | (in[inPos + 15] & 0x3FFFFFFL) << 8) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 15] >>> 26 & 0x3FFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 15] >>> 60 | (in[inPos + 16] & 0x3FFFFFFFL) << 4) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 16] >>> 30) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 17] & 0x3FFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 17] >>> 34 | (in[inPos + 18] & 0xFL) << 30) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 18] >>> 4 & 0x3FFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 18] >>> 38 | (in[inPos + 19] & 0xFFL) << 26) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 19] >>> 8 & 0x3FFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 19] >>> 42 | (in[inPos + 20] & 0xFFFL) << 22) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 20] >>> 12 & 0x3FFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 20] >>> 46 | (in[inPos + 21] & 0xFFFFL) << 18) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 21] >>> 16 & 0x3FFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 21] >>> 50 | (in[inPos + 22] & 0xFFFFFL) << 14) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 22] >>> 20 & 0x3FFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 22] >>> 54 | (in[inPos + 23] & 0xFFFFFFL) << 10) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 23] >>> 24 & 0x3FFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 23] >>> 58 | (in[inPos + 24] & 0xFFFFFFFL) << 6) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 24] >>> 28 & 0x3FFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 24] >>> 62 | (in[inPos + 25] & 0xFFFFFFFFL) << 2) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 25] >>> 32 | (in[inPos + 26] & 3L) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 26] >>> 2 & 0x3FFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 26] >>> 36 | (in[inPos + 27] & 0x3FL) << 28) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 27] >>> 6 & 0x3FFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 27] >>> 40 | (in[inPos + 28] & 0x3FFL) << 24) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 28] >>> 10 & 0x3FFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 28] >>> 44 | (in[inPos + 29] & 0x3FFFL) << 20) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 29] >>> 14 & 0x3FFFFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 29] >>> 48 | (in[inPos + 30] & 0x3FFFFL) << 16) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 30] >>> 18 & 0x3FFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 30] >>> 52 | (in[inPos + 31] & 0x3FFFFFL) << 12) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 31] >>> 22 & 0x3FFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 31] >>> 56 | (in[inPos + 32] & 0x3FFFFFFL) << 8) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 32] >>> 26 & 0x3FFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 32] >>> 60 | (in[inPos + 33] & 0x3FFFFFFFL) << 4) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 33] >>> 30) + out[outPos + 62];
    }

    private static void pack35(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 35;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 29 | in[inPos + 2] - in[inPos + 1] << 6 | in[inPos + 3] - in[inPos + 2] << 41;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 23 | in[inPos + 4] - in[inPos + 3] << 12 | in[inPos + 5] - in[inPos + 4] << 47;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 17 | in[inPos + 6] - in[inPos + 5] << 18 | in[inPos + 7] - in[inPos + 6] << 53;
        out[outPos + 4] = in[inPos + 7] - in[inPos + 6] >>> 11 | in[inPos + 8] - in[inPos + 7] << 24 | in[inPos + 9] - in[inPos + 8] << 59;
        out[outPos + 5] = in[inPos + 9] - in[inPos + 8] >>> 5 | in[inPos + 10] - in[inPos + 9] << 30;
        out[outPos + 6] = in[inPos + 10] - in[inPos + 9] >>> 34 | in[inPos + 11] - in[inPos + 10] << 1 | in[inPos + 12] - in[inPos + 11] << 36;
        out[outPos + 7] = in[inPos + 12] - in[inPos + 11] >>> 28 | in[inPos + 13] - in[inPos + 12] << 7 | in[inPos + 14] - in[inPos + 13] << 42;
        out[outPos + 8] = in[inPos + 14] - in[inPos + 13] >>> 22 | in[inPos + 15] - in[inPos + 14] << 13 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 9] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 19 | in[inPos + 18] - in[inPos + 17] << 54;
        out[outPos + 10] = in[inPos + 18] - in[inPos + 17] >>> 10 | in[inPos + 19] - in[inPos + 18] << 25 | in[inPos + 20] - in[inPos + 19] << 60;
        out[outPos + 11] = in[inPos + 20] - in[inPos + 19] >>> 4 | in[inPos + 21] - in[inPos + 20] << 31;
        out[outPos + 12] = in[inPos + 21] - in[inPos + 20] >>> 33 | in[inPos + 22] - in[inPos + 21] << 2 | in[inPos + 23] - in[inPos + 22] << 37;
        out[outPos + 13] = in[inPos + 23] - in[inPos + 22] >>> 27 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 43;
        out[outPos + 14] = in[inPos + 25] - in[inPos + 24] >>> 21 | in[inPos + 26] - in[inPos + 25] << 14 | in[inPos + 27] - in[inPos + 26] << 49;
        out[outPos + 15] = in[inPos + 27] - in[inPos + 26] >>> 15 | in[inPos + 28] - in[inPos + 27] << 20 | in[inPos + 29] - in[inPos + 28] << 55;
        out[outPos + 16] = in[inPos + 29] - in[inPos + 28] >>> 9 | in[inPos + 30] - in[inPos + 29] << 26 | in[inPos + 31] - in[inPos + 30] << 61;
        out[outPos + 17] = in[inPos + 31] - in[inPos + 30] >>> 3 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 18] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 3 | in[inPos + 34] - in[inPos + 33] << 38;
        out[outPos + 19] = in[inPos + 34] - in[inPos + 33] >>> 26 | in[inPos + 35] - in[inPos + 34] << 9 | in[inPos + 36] - in[inPos + 35] << 44;
        out[outPos + 20] = in[inPos + 36] - in[inPos + 35] >>> 20 | in[inPos + 37] - in[inPos + 36] << 15 | in[inPos + 38] - in[inPos + 37] << 50;
        out[outPos + 21] = in[inPos + 38] - in[inPos + 37] >>> 14 | in[inPos + 39] - in[inPos + 38] << 21 | in[inPos + 40] - in[inPos + 39] << 56;
        out[outPos + 22] = in[inPos + 40] - in[inPos + 39] >>> 8 | in[inPos + 41] - in[inPos + 40] << 27 | in[inPos + 42] - in[inPos + 41] << 62;
        out[outPos + 23] = in[inPos + 42] - in[inPos + 41] >>> 2 | in[inPos + 43] - in[inPos + 42] << 33;
        out[outPos + 24] = in[inPos + 43] - in[inPos + 42] >>> 31 | in[inPos + 44] - in[inPos + 43] << 4 | in[inPos + 45] - in[inPos + 44] << 39;
        out[outPos + 25] = in[inPos + 45] - in[inPos + 44] >>> 25 | in[inPos + 46] - in[inPos + 45] << 10 | in[inPos + 47] - in[inPos + 46] << 45;
        out[outPos + 26] = in[inPos + 47] - in[inPos + 46] >>> 19 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 51;
        out[outPos + 27] = in[inPos + 49] - in[inPos + 48] >>> 13 | in[inPos + 50] - in[inPos + 49] << 22 | in[inPos + 51] - in[inPos + 50] << 57;
        out[outPos + 28] = in[inPos + 51] - in[inPos + 50] >>> 7 | in[inPos + 52] - in[inPos + 51] << 28 | in[inPos + 53] - in[inPos + 52] << 63;
        out[outPos + 29] = in[inPos + 53] - in[inPos + 52] >>> 1 | in[inPos + 54] - in[inPos + 53] << 34;
        out[outPos + 30] = in[inPos + 54] - in[inPos + 53] >>> 30 | in[inPos + 55] - in[inPos + 54] << 5 | in[inPos + 56] - in[inPos + 55] << 40;
        out[outPos + 31] = in[inPos + 56] - in[inPos + 55] >>> 24 | in[inPos + 57] - in[inPos + 56] << 11 | in[inPos + 58] - in[inPos + 57] << 46;
        out[outPos + 32] = in[inPos + 58] - in[inPos + 57] >>> 18 | in[inPos + 59] - in[inPos + 58] << 17 | in[inPos + 60] - in[inPos + 59] << 52;
        out[outPos + 33] = in[inPos + 60] - in[inPos + 59] >>> 12 | in[inPos + 61] - in[inPos + 60] << 23 | in[inPos + 62] - in[inPos + 61] << 58;
        out[outPos + 34] = in[inPos + 62] - in[inPos + 61] >>> 6 | in[inPos + 63] - in[inPos + 62] << 29;
    }

    private static void unpack35(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 35 | (in[inPos + 1] & 0x3FL) << 29) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 6 & 0x7FFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 41 | (in[inPos + 2] & 0xFFFL) << 23) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 12 & 0x7FFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 47 | (in[inPos + 3] & 0x3FFFFL) << 17) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 18 & 0x7FFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 53 | (in[inPos + 4] & 0xFFFFFFL) << 11) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 24 & 0x7FFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 4] >>> 59 | (in[inPos + 5] & 0x3FFFFFFFL) << 5) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 30 | (in[inPos + 6] & 1L) << 34) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 1 & 0x7FFFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] >>> 36 | (in[inPos + 7] & 0x7FL) << 28) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 7] >>> 7 & 0x7FFFFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] >>> 42 | (in[inPos + 8] & 0x1FFFL) << 22) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 8] >>> 13 & 0x7FFFFFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 8] >>> 48 | (in[inPos + 9] & 0x7FFFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 9] >>> 19 & 0x7FFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0x1FFFFFFL) << 10) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 10] >>> 25 & 0x7FFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 10] >>> 60 | (in[inPos + 11] & Integer.MAX_VALUE) << 4) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 11] >>> 31 | (in[inPos + 12] & 3L) << 33) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 12] >>> 2 & 0x7FFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 12] >>> 37 | (in[inPos + 13] & 0xFFL) << 27) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 13] >>> 8 & 0x7FFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 13] >>> 43 | (in[inPos + 14] & 0x3FFFL) << 21) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 14] >>> 14 & 0x7FFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 14] >>> 49 | (in[inPos + 15] & 0xFFFFFL) << 15) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 15] >>> 20 & 0x7FFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 15] >>> 55 | (in[inPos + 16] & 0x3FFFFFFL) << 9) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 16] >>> 26 & 0x7FFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 16] >>> 61 | (in[inPos + 17] & 0xFFFFFFFFL) << 3) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 17] >>> 32 | (in[inPos + 18] & 7L) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 18] >>> 3 & 0x7FFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 18] >>> 38 | (in[inPos + 19] & 0x1FFL) << 26) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 19] >>> 9 & 0x7FFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0x7FFFL) << 20) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 20] >>> 15 & 0x7FFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 20] >>> 50 | (in[inPos + 21] & 0x1FFFFFL) << 14) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 21] >>> 21 & 0x7FFFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 21] >>> 56 | (in[inPos + 22] & 0x7FFFFFFL) << 8) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 22] >>> 27 & 0x7FFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 22] >>> 62 | (in[inPos + 23] & 0x1FFFFFFFFL) << 2) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 23] >>> 33 | (in[inPos + 24] & 0xFL) << 31) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 24] >>> 4 & 0x7FFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 24] >>> 39 | (in[inPos + 25] & 0x3FFL) << 25) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 25] >>> 10 & 0x7FFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 25] >>> 45 | (in[inPos + 26] & 0xFFFFL) << 19) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 26] >>> 16 & 0x7FFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 26] >>> 51 | (in[inPos + 27] & 0x3FFFFFL) << 13) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 27] >>> 22 & 0x7FFFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 27] >>> 57 | (in[inPos + 28] & 0xFFFFFFFL) << 7) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 28] >>> 28 & 0x7FFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 28] >>> 63 | (in[inPos + 29] & 0x3FFFFFFFFL) << 1) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 29] >>> 34 | (in[inPos + 30] & 0x1FL) << 30) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 30] >>> 5 & 0x7FFFFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 30] >>> 40 | (in[inPos + 31] & 0x7FFL) << 24) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 31] >>> 11 & 0x7FFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 31] >>> 46 | (in[inPos + 32] & 0x1FFFFL) << 18) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 32] >>> 17 & 0x7FFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 32] >>> 52 | (in[inPos + 33] & 0x7FFFFFL) << 12) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 33] >>> 23 & 0x7FFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 33] >>> 58 | (in[inPos + 34] & 0x1FFFFFFFL) << 6) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 34] >>> 29) + out[outPos + 62];
    }

    private static void pack36(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 36;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 28 | in[inPos + 2] - in[inPos + 1] << 8 | in[inPos + 3] - in[inPos + 2] << 44;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 20 | in[inPos + 4] - in[inPos + 3] << 16 | in[inPos + 5] - in[inPos + 4] << 52;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 12 | in[inPos + 6] - in[inPos + 5] << 24 | in[inPos + 7] - in[inPos + 6] << 60;
        out[outPos + 4] = in[inPos + 7] - in[inPos + 6] >>> 4 | in[inPos + 8] - in[inPos + 7] << 32;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] >>> 32 | in[inPos + 9] - in[inPos + 8] << 4 | in[inPos + 10] - in[inPos + 9] << 40;
        out[outPos + 6] = in[inPos + 10] - in[inPos + 9] >>> 24 | in[inPos + 11] - in[inPos + 10] << 12 | in[inPos + 12] - in[inPos + 11] << 48;
        out[outPos + 7] = in[inPos + 12] - in[inPos + 11] >>> 16 | in[inPos + 13] - in[inPos + 12] << 20 | in[inPos + 14] - in[inPos + 13] << 56;
        out[outPos + 8] = in[inPos + 14] - in[inPos + 13] >>> 8 | in[inPos + 15] - in[inPos + 14] << 28;
        out[outPos + 9] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 36;
        out[outPos + 10] = in[inPos + 17] - in[inPos + 16] >>> 28 | in[inPos + 18] - in[inPos + 17] << 8 | in[inPos + 19] - in[inPos + 18] << 44;
        out[outPos + 11] = in[inPos + 19] - in[inPos + 18] >>> 20 | in[inPos + 20] - in[inPos + 19] << 16 | in[inPos + 21] - in[inPos + 20] << 52;
        out[outPos + 12] = in[inPos + 21] - in[inPos + 20] >>> 12 | in[inPos + 22] - in[inPos + 21] << 24 | in[inPos + 23] - in[inPos + 22] << 60;
        out[outPos + 13] = in[inPos + 23] - in[inPos + 22] >>> 4 | in[inPos + 24] - in[inPos + 23] << 32;
        out[outPos + 14] = in[inPos + 24] - in[inPos + 23] >>> 32 | in[inPos + 25] - in[inPos + 24] << 4 | in[inPos + 26] - in[inPos + 25] << 40;
        out[outPos + 15] = in[inPos + 26] - in[inPos + 25] >>> 24 | in[inPos + 27] - in[inPos + 26] << 12 | in[inPos + 28] - in[inPos + 27] << 48;
        out[outPos + 16] = in[inPos + 28] - in[inPos + 27] >>> 16 | in[inPos + 29] - in[inPos + 28] << 20 | in[inPos + 30] - in[inPos + 29] << 56;
        out[outPos + 17] = in[inPos + 30] - in[inPos + 29] >>> 8 | in[inPos + 31] - in[inPos + 30] << 28;
        out[outPos + 18] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 36;
        out[outPos + 19] = in[inPos + 33] - in[inPos + 32] >>> 28 | in[inPos + 34] - in[inPos + 33] << 8 | in[inPos + 35] - in[inPos + 34] << 44;
        out[outPos + 20] = in[inPos + 35] - in[inPos + 34] >>> 20 | in[inPos + 36] - in[inPos + 35] << 16 | in[inPos + 37] - in[inPos + 36] << 52;
        out[outPos + 21] = in[inPos + 37] - in[inPos + 36] >>> 12 | in[inPos + 38] - in[inPos + 37] << 24 | in[inPos + 39] - in[inPos + 38] << 60;
        out[outPos + 22] = in[inPos + 39] - in[inPos + 38] >>> 4 | in[inPos + 40] - in[inPos + 39] << 32;
        out[outPos + 23] = in[inPos + 40] - in[inPos + 39] >>> 32 | in[inPos + 41] - in[inPos + 40] << 4 | in[inPos + 42] - in[inPos + 41] << 40;
        out[outPos + 24] = in[inPos + 42] - in[inPos + 41] >>> 24 | in[inPos + 43] - in[inPos + 42] << 12 | in[inPos + 44] - in[inPos + 43] << 48;
        out[outPos + 25] = in[inPos + 44] - in[inPos + 43] >>> 16 | in[inPos + 45] - in[inPos + 44] << 20 | in[inPos + 46] - in[inPos + 45] << 56;
        out[outPos + 26] = in[inPos + 46] - in[inPos + 45] >>> 8 | in[inPos + 47] - in[inPos + 46] << 28;
        out[outPos + 27] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 36;
        out[outPos + 28] = in[inPos + 49] - in[inPos + 48] >>> 28 | in[inPos + 50] - in[inPos + 49] << 8 | in[inPos + 51] - in[inPos + 50] << 44;
        out[outPos + 29] = in[inPos + 51] - in[inPos + 50] >>> 20 | in[inPos + 52] - in[inPos + 51] << 16 | in[inPos + 53] - in[inPos + 52] << 52;
        out[outPos + 30] = in[inPos + 53] - in[inPos + 52] >>> 12 | in[inPos + 54] - in[inPos + 53] << 24 | in[inPos + 55] - in[inPos + 54] << 60;
        out[outPos + 31] = in[inPos + 55] - in[inPos + 54] >>> 4 | in[inPos + 56] - in[inPos + 55] << 32;
        out[outPos + 32] = in[inPos + 56] - in[inPos + 55] >>> 32 | in[inPos + 57] - in[inPos + 56] << 4 | in[inPos + 58] - in[inPos + 57] << 40;
        out[outPos + 33] = in[inPos + 58] - in[inPos + 57] >>> 24 | in[inPos + 59] - in[inPos + 58] << 12 | in[inPos + 60] - in[inPos + 59] << 48;
        out[outPos + 34] = in[inPos + 60] - in[inPos + 59] >>> 16 | in[inPos + 61] - in[inPos + 60] << 20 | in[inPos + 62] - in[inPos + 61] << 56;
        out[outPos + 35] = in[inPos + 62] - in[inPos + 61] >>> 8 | in[inPos + 63] - in[inPos + 62] << 28;
    }

    private static void unpack36(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 36 | (in[inPos + 1] & 0xFFL) << 28) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 8 & 0xFFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 44 | (in[inPos + 2] & 0xFFFFL) << 20) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 16 & 0xFFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 52 | (in[inPos + 3] & 0xFFFFFFL) << 12) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 24 & 0xFFFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0xFFFFFFFFL) << 4) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 32 | (in[inPos + 5] & 0xFL) << 32) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 4 & 0xFFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 40 | (in[inPos + 6] & 0xFFFL) << 24) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 12 & 0xFFFFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] >>> 48 | (in[inPos + 7] & 0xFFFFFL) << 16) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 7] >>> 20 & 0xFFFFFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0xFFFFFFFL) << 8) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 8] >>> 28) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 9] & 0xFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 9] >>> 36 | (in[inPos + 10] & 0xFFL) << 28) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 10] >>> 8 & 0xFFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 10] >>> 44 | (in[inPos + 11] & 0xFFFFL) << 20) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 11] >>> 16 & 0xFFFFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0xFFFFFFL) << 12) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 12] >>> 24 & 0xFFFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 12] >>> 60 | (in[inPos + 13] & 0xFFFFFFFFL) << 4) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 13] >>> 32 | (in[inPos + 14] & 0xFL) << 32) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 14] >>> 4 & 0xFFFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 14] >>> 40 | (in[inPos + 15] & 0xFFFL) << 24) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 15] >>> 12 & 0xFFFFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0xFFFFFL) << 16) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 16] >>> 20 & 0xFFFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0xFFFFFFFL) << 8) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 17] >>> 28) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 18] & 0xFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 18] >>> 36 | (in[inPos + 19] & 0xFFL) << 28) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 19] >>> 8 & 0xFFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0xFFFFL) << 20) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 20] >>> 16 & 0xFFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 20] >>> 52 | (in[inPos + 21] & 0xFFFFFFL) << 12) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 21] >>> 24 & 0xFFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 21] >>> 60 | (in[inPos + 22] & 0xFFFFFFFFL) << 4) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 22] >>> 32 | (in[inPos + 23] & 0xFL) << 32) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 23] >>> 4 & 0xFFFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 23] >>> 40 | (in[inPos + 24] & 0xFFFL) << 24) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 24] >>> 12 & 0xFFFFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 24] >>> 48 | (in[inPos + 25] & 0xFFFFFL) << 16) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 25] >>> 20 & 0xFFFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 25] >>> 56 | (in[inPos + 26] & 0xFFFFFFFL) << 8) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 26] >>> 28) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 27] & 0xFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 27] >>> 36 | (in[inPos + 28] & 0xFFL) << 28) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 28] >>> 8 & 0xFFFFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 28] >>> 44 | (in[inPos + 29] & 0xFFFFL) << 20) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 29] >>> 16 & 0xFFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 29] >>> 52 | (in[inPos + 30] & 0xFFFFFFL) << 12) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 30] >>> 24 & 0xFFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 30] >>> 60 | (in[inPos + 31] & 0xFFFFFFFFL) << 4) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 31] >>> 32 | (in[inPos + 32] & 0xFL) << 32) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 32] >>> 4 & 0xFFFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 32] >>> 40 | (in[inPos + 33] & 0xFFFL) << 24) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 33] >>> 12 & 0xFFFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 33] >>> 48 | (in[inPos + 34] & 0xFFFFFL) << 16) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 34] >>> 20 & 0xFFFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 34] >>> 56 | (in[inPos + 35] & 0xFFFFFFFL) << 8) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 35] >>> 28) + out[outPos + 62];
    }

    private static void pack37(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 37;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 27 | in[inPos + 2] - in[inPos + 1] << 10 | in[inPos + 3] - in[inPos + 2] << 47;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 17 | in[inPos + 4] - in[inPos + 3] << 20 | in[inPos + 5] - in[inPos + 4] << 57;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 7 | in[inPos + 6] - in[inPos + 5] << 30;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 34 | in[inPos + 7] - in[inPos + 6] << 3 | in[inPos + 8] - in[inPos + 7] << 40;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] >>> 24 | in[inPos + 9] - in[inPos + 8] << 13 | in[inPos + 10] - in[inPos + 9] << 50;
        out[outPos + 6] = in[inPos + 10] - in[inPos + 9] >>> 14 | in[inPos + 11] - in[inPos + 10] << 23 | in[inPos + 12] - in[inPos + 11] << 60;
        out[outPos + 7] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 33;
        out[outPos + 8] = in[inPos + 13] - in[inPos + 12] >>> 31 | in[inPos + 14] - in[inPos + 13] << 6 | in[inPos + 15] - in[inPos + 14] << 43;
        out[outPos + 9] = in[inPos + 15] - in[inPos + 14] >>> 21 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 53;
        out[outPos + 10] = in[inPos + 17] - in[inPos + 16] >>> 11 | in[inPos + 18] - in[inPos + 17] << 26 | in[inPos + 19] - in[inPos + 18] << 63;
        out[outPos + 11] = in[inPos + 19] - in[inPos + 18] >>> 1 | in[inPos + 20] - in[inPos + 19] << 36;
        out[outPos + 12] = in[inPos + 20] - in[inPos + 19] >>> 28 | in[inPos + 21] - in[inPos + 20] << 9 | in[inPos + 22] - in[inPos + 21] << 46;
        out[outPos + 13] = in[inPos + 22] - in[inPos + 21] >>> 18 | in[inPos + 23] - in[inPos + 22] << 19 | in[inPos + 24] - in[inPos + 23] << 56;
        out[outPos + 14] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 29;
        out[outPos + 15] = in[inPos + 25] - in[inPos + 24] >>> 35 | in[inPos + 26] - in[inPos + 25] << 2 | in[inPos + 27] - in[inPos + 26] << 39;
        out[outPos + 16] = in[inPos + 27] - in[inPos + 26] >>> 25 | in[inPos + 28] - in[inPos + 27] << 12 | in[inPos + 29] - in[inPos + 28] << 49;
        out[outPos + 17] = in[inPos + 29] - in[inPos + 28] >>> 15 | in[inPos + 30] - in[inPos + 29] << 22 | in[inPos + 31] - in[inPos + 30] << 59;
        out[outPos + 18] = in[inPos + 31] - in[inPos + 30] >>> 5 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 19] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 5 | in[inPos + 34] - in[inPos + 33] << 42;
        out[outPos + 20] = in[inPos + 34] - in[inPos + 33] >>> 22 | in[inPos + 35] - in[inPos + 34] << 15 | in[inPos + 36] - in[inPos + 35] << 52;
        out[outPos + 21] = in[inPos + 36] - in[inPos + 35] >>> 12 | in[inPos + 37] - in[inPos + 36] << 25 | in[inPos + 38] - in[inPos + 37] << 62;
        out[outPos + 22] = in[inPos + 38] - in[inPos + 37] >>> 2 | in[inPos + 39] - in[inPos + 38] << 35;
        out[outPos + 23] = in[inPos + 39] - in[inPos + 38] >>> 29 | in[inPos + 40] - in[inPos + 39] << 8 | in[inPos + 41] - in[inPos + 40] << 45;
        out[outPos + 24] = in[inPos + 41] - in[inPos + 40] >>> 19 | in[inPos + 42] - in[inPos + 41] << 18 | in[inPos + 43] - in[inPos + 42] << 55;
        out[outPos + 25] = in[inPos + 43] - in[inPos + 42] >>> 9 | in[inPos + 44] - in[inPos + 43] << 28;
        out[outPos + 26] = in[inPos + 44] - in[inPos + 43] >>> 36 | in[inPos + 45] - in[inPos + 44] << 1 | in[inPos + 46] - in[inPos + 45] << 38;
        out[outPos + 27] = in[inPos + 46] - in[inPos + 45] >>> 26 | in[inPos + 47] - in[inPos + 46] << 11 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 28] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 21 | in[inPos + 50] - in[inPos + 49] << 58;
        out[outPos + 29] = in[inPos + 50] - in[inPos + 49] >>> 6 | in[inPos + 51] - in[inPos + 50] << 31;
        out[outPos + 30] = in[inPos + 51] - in[inPos + 50] >>> 33 | in[inPos + 52] - in[inPos + 51] << 4 | in[inPos + 53] - in[inPos + 52] << 41;
        out[outPos + 31] = in[inPos + 53] - in[inPos + 52] >>> 23 | in[inPos + 54] - in[inPos + 53] << 14 | in[inPos + 55] - in[inPos + 54] << 51;
        out[outPos + 32] = in[inPos + 55] - in[inPos + 54] >>> 13 | in[inPos + 56] - in[inPos + 55] << 24 | in[inPos + 57] - in[inPos + 56] << 61;
        out[outPos + 33] = in[inPos + 57] - in[inPos + 56] >>> 3 | in[inPos + 58] - in[inPos + 57] << 34;
        out[outPos + 34] = in[inPos + 58] - in[inPos + 57] >>> 30 | in[inPos + 59] - in[inPos + 58] << 7 | in[inPos + 60] - in[inPos + 59] << 44;
        out[outPos + 35] = in[inPos + 60] - in[inPos + 59] >>> 20 | in[inPos + 61] - in[inPos + 60] << 17 | in[inPos + 62] - in[inPos + 61] << 54;
        out[outPos + 36] = in[inPos + 62] - in[inPos + 61] >>> 10 | in[inPos + 63] - in[inPos + 62] << 27;
    }

    private static void unpack37(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 37 | (in[inPos + 1] & 0x3FFL) << 27) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 10 & 0x1FFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 47 | (in[inPos + 2] & 0xFFFFFL) << 17) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 20 & 0x1FFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 57 | (in[inPos + 3] & 0x3FFFFFFFL) << 7) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 30 | (in[inPos + 4] & 7L) << 34) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 3 & 0x1FFFFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 40 | (in[inPos + 5] & 0x1FFFL) << 24) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 13 & 0x1FFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 50 | (in[inPos + 6] & 0x7FFFFFL) << 14) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 23 & 0x1FFFFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 6] >>> 60 | (in[inPos + 7] & 0x1FFFFFFFFL) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 7] >>> 33 | (in[inPos + 8] & 0x3FL) << 31) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 8] >>> 6 & 0x1FFFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 8] >>> 43 | (in[inPos + 9] & 0xFFFFL) << 21) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 9] >>> 16 & 0x1FFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 9] >>> 53 | (in[inPos + 10] & 0x3FFFFFFL) << 11) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 10] >>> 26 & 0x1FFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 10] >>> 63 | (in[inPos + 11] & 0xFFFFFFFFFL) << 1) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 11] >>> 36 | (in[inPos + 12] & 0x1FFL) << 28) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 12] >>> 9 & 0x1FFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 12] >>> 46 | (in[inPos + 13] & 0x7FFFFL) << 18) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 13] >>> 19 & 0x1FFFFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 13] >>> 56 | (in[inPos + 14] & 0x1FFFFFFFL) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 14] >>> 29 | (in[inPos + 15] & 3L) << 35) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 15] >>> 2 & 0x1FFFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 15] >>> 39 | (in[inPos + 16] & 0xFFFL) << 25) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 16] >>> 12 & 0x1FFFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 16] >>> 49 | (in[inPos + 17] & 0x3FFFFFL) << 15) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 17] >>> 22 & 0x1FFFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 17] >>> 59 | (in[inPos + 18] & 0xFFFFFFFFL) << 5) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 18] >>> 32 | (in[inPos + 19] & 0x1FL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 19] >>> 5 & 0x1FFFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 19] >>> 42 | (in[inPos + 20] & 0x7FFFL) << 22) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 20] >>> 15 & 0x1FFFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 20] >>> 52 | (in[inPos + 21] & 0x1FFFFFFL) << 12) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 21] >>> 25 & 0x1FFFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 21] >>> 62 | (in[inPos + 22] & 0x7FFFFFFFFL) << 2) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 22] >>> 35 | (in[inPos + 23] & 0xFFL) << 29) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 23] >>> 8 & 0x1FFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 23] >>> 45 | (in[inPos + 24] & 0x3FFFFL) << 19) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 24] >>> 18 & 0x1FFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 24] >>> 55 | (in[inPos + 25] & 0xFFFFFFFL) << 9) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 25] >>> 28 | (in[inPos + 26] & 1L) << 36) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 26] >>> 1 & 0x1FFFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 26] >>> 38 | (in[inPos + 27] & 0x7FFL) << 26) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 27] >>> 11 & 0x1FFFFFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 27] >>> 48 | (in[inPos + 28] & 0x1FFFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 28] >>> 21 & 0x1FFFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 28] >>> 58 | (in[inPos + 29] & Integer.MAX_VALUE) << 6) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 29] >>> 31 | (in[inPos + 30] & 0xFL) << 33) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 30] >>> 4 & 0x1FFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 30] >>> 41 | (in[inPos + 31] & 0x3FFFL) << 23) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 31] >>> 14 & 0x1FFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 31] >>> 51 | (in[inPos + 32] & 0xFFFFFFL) << 13) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 32] >>> 24 & 0x1FFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 32] >>> 61 | (in[inPos + 33] & 0x3FFFFFFFFL) << 3) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 33] >>> 34 | (in[inPos + 34] & 0x7FL) << 30) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 34] >>> 7 & 0x1FFFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 34] >>> 44 | (in[inPos + 35] & 0x1FFFFL) << 20) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 35] >>> 17 & 0x1FFFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 35] >>> 54 | (in[inPos + 36] & 0x7FFFFFFL) << 10) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 36] >>> 27) + out[outPos + 62];
    }

    private static void pack38(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 38;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 26 | in[inPos + 2] - in[inPos + 1] << 12 | in[inPos + 3] - in[inPos + 2] << 50;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 14 | in[inPos + 4] - in[inPos + 3] << 24 | in[inPos + 5] - in[inPos + 4] << 62;
        out[outPos + 3] = in[inPos + 5] - in[inPos + 4] >>> 2 | in[inPos + 6] - in[inPos + 5] << 36;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 28 | in[inPos + 7] - in[inPos + 6] << 10 | in[inPos + 8] - in[inPos + 7] << 48;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 22 | in[inPos + 10] - in[inPos + 9] << 60;
        out[outPos + 6] = in[inPos + 10] - in[inPos + 9] >>> 4 | in[inPos + 11] - in[inPos + 10] << 34;
        out[outPos + 7] = in[inPos + 11] - in[inPos + 10] >>> 30 | in[inPos + 12] - in[inPos + 11] << 8 | in[inPos + 13] - in[inPos + 12] << 46;
        out[outPos + 8] = in[inPos + 13] - in[inPos + 12] >>> 18 | in[inPos + 14] - in[inPos + 13] << 20 | in[inPos + 15] - in[inPos + 14] << 58;
        out[outPos + 9] = in[inPos + 15] - in[inPos + 14] >>> 6 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 10] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 6 | in[inPos + 18] - in[inPos + 17] << 44;
        out[outPos + 11] = in[inPos + 18] - in[inPos + 17] >>> 20 | in[inPos + 19] - in[inPos + 18] << 18 | in[inPos + 20] - in[inPos + 19] << 56;
        out[outPos + 12] = in[inPos + 20] - in[inPos + 19] >>> 8 | in[inPos + 21] - in[inPos + 20] << 30;
        out[outPos + 13] = in[inPos + 21] - in[inPos + 20] >>> 34 | in[inPos + 22] - in[inPos + 21] << 4 | in[inPos + 23] - in[inPos + 22] << 42;
        out[outPos + 14] = in[inPos + 23] - in[inPos + 22] >>> 22 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 54;
        out[outPos + 15] = in[inPos + 25] - in[inPos + 24] >>> 10 | in[inPos + 26] - in[inPos + 25] << 28;
        out[outPos + 16] = in[inPos + 26] - in[inPos + 25] >>> 36 | in[inPos + 27] - in[inPos + 26] << 2 | in[inPos + 28] - in[inPos + 27] << 40;
        out[outPos + 17] = in[inPos + 28] - in[inPos + 27] >>> 24 | in[inPos + 29] - in[inPos + 28] << 14 | in[inPos + 30] - in[inPos + 29] << 52;
        out[outPos + 18] = in[inPos + 30] - in[inPos + 29] >>> 12 | in[inPos + 31] - in[inPos + 30] << 26;
        out[outPos + 19] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 38;
        out[outPos + 20] = in[inPos + 33] - in[inPos + 32] >>> 26 | in[inPos + 34] - in[inPos + 33] << 12 | in[inPos + 35] - in[inPos + 34] << 50;
        out[outPos + 21] = in[inPos + 35] - in[inPos + 34] >>> 14 | in[inPos + 36] - in[inPos + 35] << 24 | in[inPos + 37] - in[inPos + 36] << 62;
        out[outPos + 22] = in[inPos + 37] - in[inPos + 36] >>> 2 | in[inPos + 38] - in[inPos + 37] << 36;
        out[outPos + 23] = in[inPos + 38] - in[inPos + 37] >>> 28 | in[inPos + 39] - in[inPos + 38] << 10 | in[inPos + 40] - in[inPos + 39] << 48;
        out[outPos + 24] = in[inPos + 40] - in[inPos + 39] >>> 16 | in[inPos + 41] - in[inPos + 40] << 22 | in[inPos + 42] - in[inPos + 41] << 60;
        out[outPos + 25] = in[inPos + 42] - in[inPos + 41] >>> 4 | in[inPos + 43] - in[inPos + 42] << 34;
        out[outPos + 26] = in[inPos + 43] - in[inPos + 42] >>> 30 | in[inPos + 44] - in[inPos + 43] << 8 | in[inPos + 45] - in[inPos + 44] << 46;
        out[outPos + 27] = in[inPos + 45] - in[inPos + 44] >>> 18 | in[inPos + 46] - in[inPos + 45] << 20 | in[inPos + 47] - in[inPos + 46] << 58;
        out[outPos + 28] = in[inPos + 47] - in[inPos + 46] >>> 6 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 29] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 6 | in[inPos + 50] - in[inPos + 49] << 44;
        out[outPos + 30] = in[inPos + 50] - in[inPos + 49] >>> 20 | in[inPos + 51] - in[inPos + 50] << 18 | in[inPos + 52] - in[inPos + 51] << 56;
        out[outPos + 31] = in[inPos + 52] - in[inPos + 51] >>> 8 | in[inPos + 53] - in[inPos + 52] << 30;
        out[outPos + 32] = in[inPos + 53] - in[inPos + 52] >>> 34 | in[inPos + 54] - in[inPos + 53] << 4 | in[inPos + 55] - in[inPos + 54] << 42;
        out[outPos + 33] = in[inPos + 55] - in[inPos + 54] >>> 22 | in[inPos + 56] - in[inPos + 55] << 16 | in[inPos + 57] - in[inPos + 56] << 54;
        out[outPos + 34] = in[inPos + 57] - in[inPos + 56] >>> 10 | in[inPos + 58] - in[inPos + 57] << 28;
        out[outPos + 35] = in[inPos + 58] - in[inPos + 57] >>> 36 | in[inPos + 59] - in[inPos + 58] << 2 | in[inPos + 60] - in[inPos + 59] << 40;
        out[outPos + 36] = in[inPos + 60] - in[inPos + 59] >>> 24 | in[inPos + 61] - in[inPos + 60] << 14 | in[inPos + 62] - in[inPos + 61] << 52;
        out[outPos + 37] = in[inPos + 62] - in[inPos + 61] >>> 12 | in[inPos + 63] - in[inPos + 62] << 26;
    }

    private static void unpack38(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 38 | (in[inPos + 1] & 0xFFFL) << 26) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 12 & 0x3FFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 50 | (in[inPos + 2] & 0xFFFFFFL) << 14) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 24 & 0x3FFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 2] >>> 62 | (in[inPos + 3] & 0xFFFFFFFFFL) << 2) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 36 | (in[inPos + 4] & 0x3FFL) << 28) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 10 & 0x3FFFFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 48 | (in[inPos + 5] & 0x3FFFFFL) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 22 & 0x3FFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 5] >>> 60 | (in[inPos + 6] & 0x3FFFFFFFFL) << 4) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 34 | (in[inPos + 7] & 0xFFL) << 30) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 8 & 0x3FFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 7] >>> 46 | (in[inPos + 8] & 0xFFFFFL) << 18) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 8] >>> 20 & 0x3FFFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 8] >>> 58 | (in[inPos + 9] & 0xFFFFFFFFL) << 6) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 9] >>> 32 | (in[inPos + 10] & 0x3FL) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 10] >>> 6 & 0x3FFFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 10] >>> 44 | (in[inPos + 11] & 0x3FFFFL) << 20) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 11] >>> 18 & 0x3FFFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 11] >>> 56 | (in[inPos + 12] & 0x3FFFFFFFL) << 8) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 12] >>> 30 | (in[inPos + 13] & 0xFL) << 34) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 13] >>> 4 & 0x3FFFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 13] >>> 42 | (in[inPos + 14] & 0xFFFFL) << 22) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 14] >>> 16 & 0x3FFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 14] >>> 54 | (in[inPos + 15] & 0xFFFFFFFL) << 10) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 15] >>> 28 | (in[inPos + 16] & 3L) << 36) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 16] >>> 2 & 0x3FFFFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 16] >>> 40 | (in[inPos + 17] & 0x3FFFL) << 24) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 17] >>> 14 & 0x3FFFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 17] >>> 52 | (in[inPos + 18] & 0x3FFFFFFL) << 12) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 18] >>> 26) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 19] & 0x3FFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 19] >>> 38 | (in[inPos + 20] & 0xFFFL) << 26) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 20] >>> 12 & 0x3FFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 20] >>> 50 | (in[inPos + 21] & 0xFFFFFFL) << 14) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 21] >>> 24 & 0x3FFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 21] >>> 62 | (in[inPos + 22] & 0xFFFFFFFFFL) << 2) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 22] >>> 36 | (in[inPos + 23] & 0x3FFL) << 28) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 23] >>> 10 & 0x3FFFFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 23] >>> 48 | (in[inPos + 24] & 0x3FFFFFL) << 16) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 24] >>> 22 & 0x3FFFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 24] >>> 60 | (in[inPos + 25] & 0x3FFFFFFFFL) << 4) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 25] >>> 34 | (in[inPos + 26] & 0xFFL) << 30) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 26] >>> 8 & 0x3FFFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 26] >>> 46 | (in[inPos + 27] & 0xFFFFFL) << 18) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 27] >>> 20 & 0x3FFFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 27] >>> 58 | (in[inPos + 28] & 0xFFFFFFFFL) << 6) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 28] >>> 32 | (in[inPos + 29] & 0x3FL) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 29] >>> 6 & 0x3FFFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 29] >>> 44 | (in[inPos + 30] & 0x3FFFFL) << 20) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 30] >>> 18 & 0x3FFFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 30] >>> 56 | (in[inPos + 31] & 0x3FFFFFFFL) << 8) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 31] >>> 30 | (in[inPos + 32] & 0xFL) << 34) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 32] >>> 4 & 0x3FFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 32] >>> 42 | (in[inPos + 33] & 0xFFFFL) << 22) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 33] >>> 16 & 0x3FFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 33] >>> 54 | (in[inPos + 34] & 0xFFFFFFFL) << 10) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 34] >>> 28 | (in[inPos + 35] & 3L) << 36) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 35] >>> 2 & 0x3FFFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 35] >>> 40 | (in[inPos + 36] & 0x3FFFL) << 24) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 36] >>> 14 & 0x3FFFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 36] >>> 52 | (in[inPos + 37] & 0x3FFFFFFL) << 12) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 37] >>> 26) + out[outPos + 62];
    }

    private static void pack39(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 39;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 25 | in[inPos + 2] - in[inPos + 1] << 14 | in[inPos + 3] - in[inPos + 2] << 53;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 11 | in[inPos + 4] - in[inPos + 3] << 28;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 36 | in[inPos + 5] - in[inPos + 4] << 3 | in[inPos + 6] - in[inPos + 5] << 42;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 22 | in[inPos + 7] - in[inPos + 6] << 17 | in[inPos + 8] - in[inPos + 7] << 56;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 31;
        out[outPos + 6] = in[inPos + 9] - in[inPos + 8] >>> 33 | in[inPos + 10] - in[inPos + 9] << 6 | in[inPos + 11] - in[inPos + 10] << 45;
        out[outPos + 7] = in[inPos + 11] - in[inPos + 10] >>> 19 | in[inPos + 12] - in[inPos + 11] << 20 | in[inPos + 13] - in[inPos + 12] << 59;
        out[outPos + 8] = in[inPos + 13] - in[inPos + 12] >>> 5 | in[inPos + 14] - in[inPos + 13] << 34;
        out[outPos + 9] = in[inPos + 14] - in[inPos + 13] >>> 30 | in[inPos + 15] - in[inPos + 14] << 9 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 10] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 23 | in[inPos + 18] - in[inPos + 17] << 62;
        out[outPos + 11] = in[inPos + 18] - in[inPos + 17] >>> 2 | in[inPos + 19] - in[inPos + 18] << 37;
        out[outPos + 12] = in[inPos + 19] - in[inPos + 18] >>> 27 | in[inPos + 20] - in[inPos + 19] << 12 | in[inPos + 21] - in[inPos + 20] << 51;
        out[outPos + 13] = in[inPos + 21] - in[inPos + 20] >>> 13 | in[inPos + 22] - in[inPos + 21] << 26;
        out[outPos + 14] = in[inPos + 22] - in[inPos + 21] >>> 38 | in[inPos + 23] - in[inPos + 22] << 1 | in[inPos + 24] - in[inPos + 23] << 40;
        out[outPos + 15] = in[inPos + 24] - in[inPos + 23] >>> 24 | in[inPos + 25] - in[inPos + 24] << 15 | in[inPos + 26] - in[inPos + 25] << 54;
        out[outPos + 16] = in[inPos + 26] - in[inPos + 25] >>> 10 | in[inPos + 27] - in[inPos + 26] << 29;
        out[outPos + 17] = in[inPos + 27] - in[inPos + 26] >>> 35 | in[inPos + 28] - in[inPos + 27] << 4 | in[inPos + 29] - in[inPos + 28] << 43;
        out[outPos + 18] = in[inPos + 29] - in[inPos + 28] >>> 21 | in[inPos + 30] - in[inPos + 29] << 18 | in[inPos + 31] - in[inPos + 30] << 57;
        out[outPos + 19] = in[inPos + 31] - in[inPos + 30] >>> 7 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 20] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 7 | in[inPos + 34] - in[inPos + 33] << 46;
        out[outPos + 21] = in[inPos + 34] - in[inPos + 33] >>> 18 | in[inPos + 35] - in[inPos + 34] << 21 | in[inPos + 36] - in[inPos + 35] << 60;
        out[outPos + 22] = in[inPos + 36] - in[inPos + 35] >>> 4 | in[inPos + 37] - in[inPos + 36] << 35;
        out[outPos + 23] = in[inPos + 37] - in[inPos + 36] >>> 29 | in[inPos + 38] - in[inPos + 37] << 10 | in[inPos + 39] - in[inPos + 38] << 49;
        out[outPos + 24] = in[inPos + 39] - in[inPos + 38] >>> 15 | in[inPos + 40] - in[inPos + 39] << 24 | in[inPos + 41] - in[inPos + 40] << 63;
        out[outPos + 25] = in[inPos + 41] - in[inPos + 40] >>> 1 | in[inPos + 42] - in[inPos + 41] << 38;
        out[outPos + 26] = in[inPos + 42] - in[inPos + 41] >>> 26 | in[inPos + 43] - in[inPos + 42] << 13 | in[inPos + 44] - in[inPos + 43] << 52;
        out[outPos + 27] = in[inPos + 44] - in[inPos + 43] >>> 12 | in[inPos + 45] - in[inPos + 44] << 27;
        out[outPos + 28] = in[inPos + 45] - in[inPos + 44] >>> 37 | in[inPos + 46] - in[inPos + 45] << 2 | in[inPos + 47] - in[inPos + 46] << 41;
        out[outPos + 29] = in[inPos + 47] - in[inPos + 46] >>> 23 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 55;
        out[outPos + 30] = in[inPos + 49] - in[inPos + 48] >>> 9 | in[inPos + 50] - in[inPos + 49] << 30;
        out[outPos + 31] = in[inPos + 50] - in[inPos + 49] >>> 34 | in[inPos + 51] - in[inPos + 50] << 5 | in[inPos + 52] - in[inPos + 51] << 44;
        out[outPos + 32] = in[inPos + 52] - in[inPos + 51] >>> 20 | in[inPos + 53] - in[inPos + 52] << 19 | in[inPos + 54] - in[inPos + 53] << 58;
        out[outPos + 33] = in[inPos + 54] - in[inPos + 53] >>> 6 | in[inPos + 55] - in[inPos + 54] << 33;
        out[outPos + 34] = in[inPos + 55] - in[inPos + 54] >>> 31 | in[inPos + 56] - in[inPos + 55] << 8 | in[inPos + 57] - in[inPos + 56] << 47;
        out[outPos + 35] = in[inPos + 57] - in[inPos + 56] >>> 17 | in[inPos + 58] - in[inPos + 57] << 22 | in[inPos + 59] - in[inPos + 58] << 61;
        out[outPos + 36] = in[inPos + 59] - in[inPos + 58] >>> 3 | in[inPos + 60] - in[inPos + 59] << 36;
        out[outPos + 37] = in[inPos + 60] - in[inPos + 59] >>> 28 | in[inPos + 61] - in[inPos + 60] << 11 | in[inPos + 62] - in[inPos + 61] << 50;
        out[outPos + 38] = in[inPos + 62] - in[inPos + 61] >>> 14 | in[inPos + 63] - in[inPos + 62] << 25;
    }

    private static void unpack39(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 39 | (in[inPos + 1] & 0x3FFFL) << 25) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 14 & 0x7FFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 53 | (in[inPos + 2] & 0xFFFFFFFL) << 11) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 28 | (in[inPos + 3] & 7L) << 36) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 3 & 0x7FFFFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 42 | (in[inPos + 4] & 0x1FFFFL) << 22) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 17 & 0x7FFFFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 4] >>> 56 | (in[inPos + 5] & Integer.MAX_VALUE) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 31 | (in[inPos + 6] & 0x3FL) << 33) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 6 & 0x7FFFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 45 | (in[inPos + 7] & 0xFFFFFL) << 19) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 20 & 0x7FFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 7] >>> 59 | (in[inPos + 8] & 0x3FFFFFFFFL) << 5) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 8] >>> 34 | (in[inPos + 9] & 0x1FFL) << 30) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 9] >>> 9 & 0x7FFFFFFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 9] >>> 48 | (in[inPos + 10] & 0x7FFFFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 10] >>> 23 & 0x7FFFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 10] >>> 62 | (in[inPos + 11] & 0x1FFFFFFFFFL) << 2) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 11] >>> 37 | (in[inPos + 12] & 0xFFFL) << 27) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 12] >>> 12 & 0x7FFFFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 12] >>> 51 | (in[inPos + 13] & 0x3FFFFFFL) << 13) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 13] >>> 26 | (in[inPos + 14] & 1L) << 38) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 14] >>> 1 & 0x7FFFFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 14] >>> 40 | (in[inPos + 15] & 0x7FFFL) << 24) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 15] >>> 15 & 0x7FFFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 15] >>> 54 | (in[inPos + 16] & 0x1FFFFFFFL) << 10) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 16] >>> 29 | (in[inPos + 17] & 0xFL) << 35) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 17] >>> 4 & 0x7FFFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 17] >>> 43 | (in[inPos + 18] & 0x3FFFFL) << 21) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 18] >>> 18 & 0x7FFFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 18] >>> 57 | (in[inPos + 19] & 0xFFFFFFFFL) << 7) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 19] >>> 32 | (in[inPos + 20] & 0x7FL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 20] >>> 7 & 0x7FFFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 20] >>> 46 | (in[inPos + 21] & 0x1FFFFFL) << 18) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 21] >>> 21 & 0x7FFFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 21] >>> 60 | (in[inPos + 22] & 0x7FFFFFFFFL) << 4) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 22] >>> 35 | (in[inPos + 23] & 0x3FFL) << 29) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 23] >>> 10 & 0x7FFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 23] >>> 49 | (in[inPos + 24] & 0xFFFFFFL) << 15) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 24] >>> 24 & 0x7FFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 24] >>> 63 | (in[inPos + 25] & 0x3FFFFFFFFFL) << 1) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 25] >>> 38 | (in[inPos + 26] & 0x1FFFL) << 26) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 26] >>> 13 & 0x7FFFFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 26] >>> 52 | (in[inPos + 27] & 0x7FFFFFFL) << 12) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 27] >>> 27 | (in[inPos + 28] & 3L) << 37) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 28] >>> 2 & 0x7FFFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 28] >>> 41 | (in[inPos + 29] & 0xFFFFL) << 23) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 29] >>> 16 & 0x7FFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 29] >>> 55 | (in[inPos + 30] & 0x3FFFFFFFL) << 9) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 30] >>> 30 | (in[inPos + 31] & 0x1FL) << 34) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 31] >>> 5 & 0x7FFFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 31] >>> 44 | (in[inPos + 32] & 0x7FFFFL) << 20) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 32] >>> 19 & 0x7FFFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 32] >>> 58 | (in[inPos + 33] & 0x1FFFFFFFFL) << 6) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 33] >>> 33 | (in[inPos + 34] & 0xFFL) << 31) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 34] >>> 8 & 0x7FFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 34] >>> 47 | (in[inPos + 35] & 0x3FFFFFL) << 17) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 35] >>> 22 & 0x7FFFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 35] >>> 61 | (in[inPos + 36] & 0xFFFFFFFFFL) << 3) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 36] >>> 36 | (in[inPos + 37] & 0x7FFL) << 28) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 37] >>> 11 & 0x7FFFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 37] >>> 50 | (in[inPos + 38] & 0x1FFFFFFL) << 14) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 38] >>> 25) + out[outPos + 62];
    }

    private static void pack40(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 40;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 24 | in[inPos + 2] - in[inPos + 1] << 16 | in[inPos + 3] - in[inPos + 2] << 56;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 8 | in[inPos + 4] - in[inPos + 3] << 32;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 32 | in[inPos + 5] - in[inPos + 4] << 8 | in[inPos + 6] - in[inPos + 5] << 48;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 16 | in[inPos + 7] - in[inPos + 6] << 24;
        out[outPos + 5] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 40;
        out[outPos + 6] = in[inPos + 9] - in[inPos + 8] >>> 24 | in[inPos + 10] - in[inPos + 9] << 16 | in[inPos + 11] - in[inPos + 10] << 56;
        out[outPos + 7] = in[inPos + 11] - in[inPos + 10] >>> 8 | in[inPos + 12] - in[inPos + 11] << 32;
        out[outPos + 8] = in[inPos + 12] - in[inPos + 11] >>> 32 | in[inPos + 13] - in[inPos + 12] << 8 | in[inPos + 14] - in[inPos + 13] << 48;
        out[outPos + 9] = in[inPos + 14] - in[inPos + 13] >>> 16 | in[inPos + 15] - in[inPos + 14] << 24;
        out[outPos + 10] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 40;
        out[outPos + 11] = in[inPos + 17] - in[inPos + 16] >>> 24 | in[inPos + 18] - in[inPos + 17] << 16 | in[inPos + 19] - in[inPos + 18] << 56;
        out[outPos + 12] = in[inPos + 19] - in[inPos + 18] >>> 8 | in[inPos + 20] - in[inPos + 19] << 32;
        out[outPos + 13] = in[inPos + 20] - in[inPos + 19] >>> 32 | in[inPos + 21] - in[inPos + 20] << 8 | in[inPos + 22] - in[inPos + 21] << 48;
        out[outPos + 14] = in[inPos + 22] - in[inPos + 21] >>> 16 | in[inPos + 23] - in[inPos + 22] << 24;
        out[outPos + 15] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 40;
        out[outPos + 16] = in[inPos + 25] - in[inPos + 24] >>> 24 | in[inPos + 26] - in[inPos + 25] << 16 | in[inPos + 27] - in[inPos + 26] << 56;
        out[outPos + 17] = in[inPos + 27] - in[inPos + 26] >>> 8 | in[inPos + 28] - in[inPos + 27] << 32;
        out[outPos + 18] = in[inPos + 28] - in[inPos + 27] >>> 32 | in[inPos + 29] - in[inPos + 28] << 8 | in[inPos + 30] - in[inPos + 29] << 48;
        out[outPos + 19] = in[inPos + 30] - in[inPos + 29] >>> 16 | in[inPos + 31] - in[inPos + 30] << 24;
        out[outPos + 20] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 40;
        out[outPos + 21] = in[inPos + 33] - in[inPos + 32] >>> 24 | in[inPos + 34] - in[inPos + 33] << 16 | in[inPos + 35] - in[inPos + 34] << 56;
        out[outPos + 22] = in[inPos + 35] - in[inPos + 34] >>> 8 | in[inPos + 36] - in[inPos + 35] << 32;
        out[outPos + 23] = in[inPos + 36] - in[inPos + 35] >>> 32 | in[inPos + 37] - in[inPos + 36] << 8 | in[inPos + 38] - in[inPos + 37] << 48;
        out[outPos + 24] = in[inPos + 38] - in[inPos + 37] >>> 16 | in[inPos + 39] - in[inPos + 38] << 24;
        out[outPos + 25] = in[inPos + 40] - in[inPos + 39] | in[inPos + 41] - in[inPos + 40] << 40;
        out[outPos + 26] = in[inPos + 41] - in[inPos + 40] >>> 24 | in[inPos + 42] - in[inPos + 41] << 16 | in[inPos + 43] - in[inPos + 42] << 56;
        out[outPos + 27] = in[inPos + 43] - in[inPos + 42] >>> 8 | in[inPos + 44] - in[inPos + 43] << 32;
        out[outPos + 28] = in[inPos + 44] - in[inPos + 43] >>> 32 | in[inPos + 45] - in[inPos + 44] << 8 | in[inPos + 46] - in[inPos + 45] << 48;
        out[outPos + 29] = in[inPos + 46] - in[inPos + 45] >>> 16 | in[inPos + 47] - in[inPos + 46] << 24;
        out[outPos + 30] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 40;
        out[outPos + 31] = in[inPos + 49] - in[inPos + 48] >>> 24 | in[inPos + 50] - in[inPos + 49] << 16 | in[inPos + 51] - in[inPos + 50] << 56;
        out[outPos + 32] = in[inPos + 51] - in[inPos + 50] >>> 8 | in[inPos + 52] - in[inPos + 51] << 32;
        out[outPos + 33] = in[inPos + 52] - in[inPos + 51] >>> 32 | in[inPos + 53] - in[inPos + 52] << 8 | in[inPos + 54] - in[inPos + 53] << 48;
        out[outPos + 34] = in[inPos + 54] - in[inPos + 53] >>> 16 | in[inPos + 55] - in[inPos + 54] << 24;
        out[outPos + 35] = in[inPos + 56] - in[inPos + 55] | in[inPos + 57] - in[inPos + 56] << 40;
        out[outPos + 36] = in[inPos + 57] - in[inPos + 56] >>> 24 | in[inPos + 58] - in[inPos + 57] << 16 | in[inPos + 59] - in[inPos + 58] << 56;
        out[outPos + 37] = in[inPos + 59] - in[inPos + 58] >>> 8 | in[inPos + 60] - in[inPos + 59] << 32;
        out[outPos + 38] = in[inPos + 60] - in[inPos + 59] >>> 32 | in[inPos + 61] - in[inPos + 60] << 8 | in[inPos + 62] - in[inPos + 61] << 48;
        out[outPos + 39] = in[inPos + 62] - in[inPos + 61] >>> 16 | in[inPos + 63] - in[inPos + 62] << 24;
    }

    private static void unpack40(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 40 | (in[inPos + 1] & 0xFFFFL) << 24) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 0xFFFFFFFFL) << 8) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 32 | (in[inPos + 3] & 0xFFL) << 32) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 48 | (in[inPos + 4] & 0xFFFFFFL) << 16) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 24) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] & 0xFFFFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 40 | (in[inPos + 6] & 0xFFFFL) << 24) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 6] >>> 56 | (in[inPos + 7] & 0xFFFFFFFFL) << 8) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 32 | (in[inPos + 8] & 0xFFL) << 32) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 8] >>> 48 | (in[inPos + 9] & 0xFFFFFFL) << 16) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 9] >>> 24) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 10] & 0xFFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 10] >>> 40 | (in[inPos + 11] & 0xFFFFL) << 24) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 11] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 11] >>> 56 | (in[inPos + 12] & 0xFFFFFFFFL) << 8) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 12] >>> 32 | (in[inPos + 13] & 0xFFL) << 32) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 13] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 13] >>> 48 | (in[inPos + 14] & 0xFFFFFFL) << 16) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 14] >>> 24) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 15] & 0xFFFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 15] >>> 40 | (in[inPos + 16] & 0xFFFFL) << 24) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 16] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0xFFFFFFFFL) << 8) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 17] >>> 32 | (in[inPos + 18] & 0xFFL) << 32) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 18] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0xFFFFFFL) << 16) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 19] >>> 24) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 20] & 0xFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 20] >>> 40 | (in[inPos + 21] & 0xFFFFL) << 24) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 21] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 21] >>> 56 | (in[inPos + 22] & 0xFFFFFFFFL) << 8) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 22] >>> 32 | (in[inPos + 23] & 0xFFL) << 32) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 23] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 23] >>> 48 | (in[inPos + 24] & 0xFFFFFFL) << 16) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 24] >>> 24) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 25] & 0xFFFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 25] >>> 40 | (in[inPos + 26] & 0xFFFFL) << 24) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 26] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 26] >>> 56 | (in[inPos + 27] & 0xFFFFFFFFL) << 8) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 27] >>> 32 | (in[inPos + 28] & 0xFFL) << 32) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 28] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 28] >>> 48 | (in[inPos + 29] & 0xFFFFFFL) << 16) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 29] >>> 24) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 30] & 0xFFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 30] >>> 40 | (in[inPos + 31] & 0xFFFFL) << 24) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 31] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 31] >>> 56 | (in[inPos + 32] & 0xFFFFFFFFL) << 8) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 32] >>> 32 | (in[inPos + 33] & 0xFFL) << 32) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 33] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 33] >>> 48 | (in[inPos + 34] & 0xFFFFFFL) << 16) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 34] >>> 24) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 35] & 0xFFFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 35] >>> 40 | (in[inPos + 36] & 0xFFFFL) << 24) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 36] >>> 16 & 0xFFFFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 36] >>> 56 | (in[inPos + 37] & 0xFFFFFFFFL) << 8) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 37] >>> 32 | (in[inPos + 38] & 0xFFL) << 32) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 38] >>> 8 & 0xFFFFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 38] >>> 48 | (in[inPos + 39] & 0xFFFFFFL) << 16) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 39] >>> 24) + out[outPos + 62];
    }

    private static void pack41(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 41;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 23 | in[inPos + 2] - in[inPos + 1] << 18 | in[inPos + 3] - in[inPos + 2] << 59;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 5 | in[inPos + 4] - in[inPos + 3] << 36;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 28 | in[inPos + 5] - in[inPos + 4] << 13 | in[inPos + 6] - in[inPos + 5] << 54;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 10 | in[inPos + 7] - in[inPos + 6] << 31;
        out[outPos + 5] = in[inPos + 7] - in[inPos + 6] >>> 33 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 49;
        out[outPos + 6] = in[inPos + 9] - in[inPos + 8] >>> 15 | in[inPos + 10] - in[inPos + 9] << 26;
        out[outPos + 7] = in[inPos + 10] - in[inPos + 9] >>> 38 | in[inPos + 11] - in[inPos + 10] << 3 | in[inPos + 12] - in[inPos + 11] << 44;
        out[outPos + 8] = in[inPos + 12] - in[inPos + 11] >>> 20 | in[inPos + 13] - in[inPos + 12] << 21 | in[inPos + 14] - in[inPos + 13] << 62;
        out[outPos + 9] = in[inPos + 14] - in[inPos + 13] >>> 2 | in[inPos + 15] - in[inPos + 14] << 39;
        out[outPos + 10] = in[inPos + 15] - in[inPos + 14] >>> 25 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 57;
        out[outPos + 11] = in[inPos + 17] - in[inPos + 16] >>> 7 | in[inPos + 18] - in[inPos + 17] << 34;
        out[outPos + 12] = in[inPos + 18] - in[inPos + 17] >>> 30 | in[inPos + 19] - in[inPos + 18] << 11 | in[inPos + 20] - in[inPos + 19] << 52;
        out[outPos + 13] = in[inPos + 20] - in[inPos + 19] >>> 12 | in[inPos + 21] - in[inPos + 20] << 29;
        out[outPos + 14] = in[inPos + 21] - in[inPos + 20] >>> 35 | in[inPos + 22] - in[inPos + 21] << 6 | in[inPos + 23] - in[inPos + 22] << 47;
        out[outPos + 15] = in[inPos + 23] - in[inPos + 22] >>> 17 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 16] = in[inPos + 24] - in[inPos + 23] >>> 40 | in[inPos + 25] - in[inPos + 24] << 1 | in[inPos + 26] - in[inPos + 25] << 42;
        out[outPos + 17] = in[inPos + 26] - in[inPos + 25] >>> 22 | in[inPos + 27] - in[inPos + 26] << 19 | in[inPos + 28] - in[inPos + 27] << 60;
        out[outPos + 18] = in[inPos + 28] - in[inPos + 27] >>> 4 | in[inPos + 29] - in[inPos + 28] << 37;
        out[outPos + 19] = in[inPos + 29] - in[inPos + 28] >>> 27 | in[inPos + 30] - in[inPos + 29] << 14 | in[inPos + 31] - in[inPos + 30] << 55;
        out[outPos + 20] = in[inPos + 31] - in[inPos + 30] >>> 9 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 21] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 9 | in[inPos + 34] - in[inPos + 33] << 50;
        out[outPos + 22] = in[inPos + 34] - in[inPos + 33] >>> 14 | in[inPos + 35] - in[inPos + 34] << 27;
        out[outPos + 23] = in[inPos + 35] - in[inPos + 34] >>> 37 | in[inPos + 36] - in[inPos + 35] << 4 | in[inPos + 37] - in[inPos + 36] << 45;
        out[outPos + 24] = in[inPos + 37] - in[inPos + 36] >>> 19 | in[inPos + 38] - in[inPos + 37] << 22 | in[inPos + 39] - in[inPos + 38] << 63;
        out[outPos + 25] = in[inPos + 39] - in[inPos + 38] >>> 1 | in[inPos + 40] - in[inPos + 39] << 40;
        out[outPos + 26] = in[inPos + 40] - in[inPos + 39] >>> 24 | in[inPos + 41] - in[inPos + 40] << 17 | in[inPos + 42] - in[inPos + 41] << 58;
        out[outPos + 27] = in[inPos + 42] - in[inPos + 41] >>> 6 | in[inPos + 43] - in[inPos + 42] << 35;
        out[outPos + 28] = in[inPos + 43] - in[inPos + 42] >>> 29 | in[inPos + 44] - in[inPos + 43] << 12 | in[inPos + 45] - in[inPos + 44] << 53;
        out[outPos + 29] = in[inPos + 45] - in[inPos + 44] >>> 11 | in[inPos + 46] - in[inPos + 45] << 30;
        out[outPos + 30] = in[inPos + 46] - in[inPos + 45] >>> 34 | in[inPos + 47] - in[inPos + 46] << 7 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 31] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 25;
        out[outPos + 32] = in[inPos + 49] - in[inPos + 48] >>> 39 | in[inPos + 50] - in[inPos + 49] << 2 | in[inPos + 51] - in[inPos + 50] << 43;
        out[outPos + 33] = in[inPos + 51] - in[inPos + 50] >>> 21 | in[inPos + 52] - in[inPos + 51] << 20 | in[inPos + 53] - in[inPos + 52] << 61;
        out[outPos + 34] = in[inPos + 53] - in[inPos + 52] >>> 3 | in[inPos + 54] - in[inPos + 53] << 38;
        out[outPos + 35] = in[inPos + 54] - in[inPos + 53] >>> 26 | in[inPos + 55] - in[inPos + 54] << 15 | in[inPos + 56] - in[inPos + 55] << 56;
        out[outPos + 36] = in[inPos + 56] - in[inPos + 55] >>> 8 | in[inPos + 57] - in[inPos + 56] << 33;
        out[outPos + 37] = in[inPos + 57] - in[inPos + 56] >>> 31 | in[inPos + 58] - in[inPos + 57] << 10 | in[inPos + 59] - in[inPos + 58] << 51;
        out[outPos + 38] = in[inPos + 59] - in[inPos + 58] >>> 13 | in[inPos + 60] - in[inPos + 59] << 28;
        out[outPos + 39] = in[inPos + 60] - in[inPos + 59] >>> 36 | in[inPos + 61] - in[inPos + 60] << 5 | in[inPos + 62] - in[inPos + 61] << 46;
        out[outPos + 40] = in[inPos + 62] - in[inPos + 61] >>> 18 | in[inPos + 63] - in[inPos + 62] << 23;
    }

    private static void unpack41(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 41 | (in[inPos + 1] & 0x3FFFFL) << 23) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 18 & 0x1FFFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 59 | (in[inPos + 2] & 0xFFFFFFFFFL) << 5) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 36 | (in[inPos + 3] & 0x1FFFL) << 28) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 13 & 0x1FFFFFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 54 | (in[inPos + 4] & Integer.MAX_VALUE) << 10) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 31 | (in[inPos + 5] & 0xFFL) << 33) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 8 & 0x1FFFFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 49 | (in[inPos + 6] & 0x3FFFFFFL) << 15) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 26 | (in[inPos + 7] & 7L) << 38) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 3 & 0x1FFFFFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 44 | (in[inPos + 8] & 0x1FFFFFL) << 20) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 21 & 0x1FFFFFFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 8] >>> 62 | (in[inPos + 9] & 0x7FFFFFFFFFL) << 2) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 9] >>> 39 | (in[inPos + 10] & 0xFFFFL) << 25) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 10] >>> 16 & 0x1FFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 10] >>> 57 | (in[inPos + 11] & 0x3FFFFFFFFL) << 7) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 11] >>> 34 | (in[inPos + 12] & 0x7FFL) << 30) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 12] >>> 11 & 0x1FFFFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 12] >>> 52 | (in[inPos + 13] & 0x1FFFFFFFL) << 12) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 13] >>> 29 | (in[inPos + 14] & 0x3FL) << 35) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 14] >>> 6 & 0x1FFFFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 14] >>> 47 | (in[inPos + 15] & 0xFFFFFFL) << 17) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 15] >>> 24 | (in[inPos + 16] & 1L) << 40) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 16] >>> 1 & 0x1FFFFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 16] >>> 42 | (in[inPos + 17] & 0x7FFFFL) << 22) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 17] >>> 19 & 0x1FFFFFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 17] >>> 60 | (in[inPos + 18] & 0x1FFFFFFFFFL) << 4) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 18] >>> 37 | (in[inPos + 19] & 0x3FFFL) << 27) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 19] >>> 14 & 0x1FFFFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 19] >>> 55 | (in[inPos + 20] & 0xFFFFFFFFL) << 9) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 20] >>> 32 | (in[inPos + 21] & 0x1FFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 21] >>> 9 & 0x1FFFFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 21] >>> 50 | (in[inPos + 22] & 0x7FFFFFFL) << 14) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 22] >>> 27 | (in[inPos + 23] & 0xFL) << 37) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 23] >>> 4 & 0x1FFFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 23] >>> 45 | (in[inPos + 24] & 0x3FFFFFL) << 19) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 24] >>> 22 & 0x1FFFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 24] >>> 63 | (in[inPos + 25] & 0xFFFFFFFFFFL) << 1) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 25] >>> 40 | (in[inPos + 26] & 0x1FFFFL) << 24) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 26] >>> 17 & 0x1FFFFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 26] >>> 58 | (in[inPos + 27] & 0x7FFFFFFFFL) << 6) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 27] >>> 35 | (in[inPos + 28] & 0xFFFL) << 29) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 28] >>> 12 & 0x1FFFFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 28] >>> 53 | (in[inPos + 29] & 0x3FFFFFFFL) << 11) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 29] >>> 30 | (in[inPos + 30] & 0x7FL) << 34) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 30] >>> 7 & 0x1FFFFFFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 30] >>> 48 | (in[inPos + 31] & 0x1FFFFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 31] >>> 25 | (in[inPos + 32] & 3L) << 39) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 32] >>> 2 & 0x1FFFFFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 32] >>> 43 | (in[inPos + 33] & 0xFFFFFL) << 21) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 33] >>> 20 & 0x1FFFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 33] >>> 61 | (in[inPos + 34] & 0x3FFFFFFFFFL) << 3) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 34] >>> 38 | (in[inPos + 35] & 0x7FFFL) << 26) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 35] >>> 15 & 0x1FFFFFFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 35] >>> 56 | (in[inPos + 36] & 0x1FFFFFFFFL) << 8) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 36] >>> 33 | (in[inPos + 37] & 0x3FFL) << 31) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 37] >>> 10 & 0x1FFFFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 37] >>> 51 | (in[inPos + 38] & 0xFFFFFFFL) << 13) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 38] >>> 28 | (in[inPos + 39] & 0x1FL) << 36) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 39] >>> 5 & 0x1FFFFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 39] >>> 46 | (in[inPos + 40] & 0x7FFFFFL) << 18) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 40] >>> 23) + out[outPos + 62];
    }

    private static void pack42(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 42;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 22 | in[inPos + 2] - in[inPos + 1] << 20 | in[inPos + 3] - in[inPos + 2] << 62;
        out[outPos + 2] = in[inPos + 3] - in[inPos + 2] >>> 2 | in[inPos + 4] - in[inPos + 3] << 40;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 24 | in[inPos + 5] - in[inPos + 4] << 18 | in[inPos + 6] - in[inPos + 5] << 60;
        out[outPos + 4] = in[inPos + 6] - in[inPos + 5] >>> 4 | in[inPos + 7] - in[inPos + 6] << 38;
        out[outPos + 5] = in[inPos + 7] - in[inPos + 6] >>> 26 | in[inPos + 8] - in[inPos + 7] << 16 | in[inPos + 9] - in[inPos + 8] << 58;
        out[outPos + 6] = in[inPos + 9] - in[inPos + 8] >>> 6 | in[inPos + 10] - in[inPos + 9] << 36;
        out[outPos + 7] = in[inPos + 10] - in[inPos + 9] >>> 28 | in[inPos + 11] - in[inPos + 10] << 14 | in[inPos + 12] - in[inPos + 11] << 56;
        out[outPos + 8] = in[inPos + 12] - in[inPos + 11] >>> 8 | in[inPos + 13] - in[inPos + 12] << 34;
        out[outPos + 9] = in[inPos + 13] - in[inPos + 12] >>> 30 | in[inPos + 14] - in[inPos + 13] << 12 | in[inPos + 15] - in[inPos + 14] << 54;
        out[outPos + 10] = in[inPos + 15] - in[inPos + 14] >>> 10 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 11] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 10 | in[inPos + 18] - in[inPos + 17] << 52;
        out[outPos + 12] = in[inPos + 18] - in[inPos + 17] >>> 12 | in[inPos + 19] - in[inPos + 18] << 30;
        out[outPos + 13] = in[inPos + 19] - in[inPos + 18] >>> 34 | in[inPos + 20] - in[inPos + 19] << 8 | in[inPos + 21] - in[inPos + 20] << 50;
        out[outPos + 14] = in[inPos + 21] - in[inPos + 20] >>> 14 | in[inPos + 22] - in[inPos + 21] << 28;
        out[outPos + 15] = in[inPos + 22] - in[inPos + 21] >>> 36 | in[inPos + 23] - in[inPos + 22] << 6 | in[inPos + 24] - in[inPos + 23] << 48;
        out[outPos + 16] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 26;
        out[outPos + 17] = in[inPos + 25] - in[inPos + 24] >>> 38 | in[inPos + 26] - in[inPos + 25] << 4 | in[inPos + 27] - in[inPos + 26] << 46;
        out[outPos + 18] = in[inPos + 27] - in[inPos + 26] >>> 18 | in[inPos + 28] - in[inPos + 27] << 24;
        out[outPos + 19] = in[inPos + 28] - in[inPos + 27] >>> 40 | in[inPos + 29] - in[inPos + 28] << 2 | in[inPos + 30] - in[inPos + 29] << 44;
        out[outPos + 20] = in[inPos + 30] - in[inPos + 29] >>> 20 | in[inPos + 31] - in[inPos + 30] << 22;
        out[outPos + 21] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 42;
        out[outPos + 22] = in[inPos + 33] - in[inPos + 32] >>> 22 | in[inPos + 34] - in[inPos + 33] << 20 | in[inPos + 35] - in[inPos + 34] << 62;
        out[outPos + 23] = in[inPos + 35] - in[inPos + 34] >>> 2 | in[inPos + 36] - in[inPos + 35] << 40;
        out[outPos + 24] = in[inPos + 36] - in[inPos + 35] >>> 24 | in[inPos + 37] - in[inPos + 36] << 18 | in[inPos + 38] - in[inPos + 37] << 60;
        out[outPos + 25] = in[inPos + 38] - in[inPos + 37] >>> 4 | in[inPos + 39] - in[inPos + 38] << 38;
        out[outPos + 26] = in[inPos + 39] - in[inPos + 38] >>> 26 | in[inPos + 40] - in[inPos + 39] << 16 | in[inPos + 41] - in[inPos + 40] << 58;
        out[outPos + 27] = in[inPos + 41] - in[inPos + 40] >>> 6 | in[inPos + 42] - in[inPos + 41] << 36;
        out[outPos + 28] = in[inPos + 42] - in[inPos + 41] >>> 28 | in[inPos + 43] - in[inPos + 42] << 14 | in[inPos + 44] - in[inPos + 43] << 56;
        out[outPos + 29] = in[inPos + 44] - in[inPos + 43] >>> 8 | in[inPos + 45] - in[inPos + 44] << 34;
        out[outPos + 30] = in[inPos + 45] - in[inPos + 44] >>> 30 | in[inPos + 46] - in[inPos + 45] << 12 | in[inPos + 47] - in[inPos + 46] << 54;
        out[outPos + 31] = in[inPos + 47] - in[inPos + 46] >>> 10 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 32] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 10 | in[inPos + 50] - in[inPos + 49] << 52;
        out[outPos + 33] = in[inPos + 50] - in[inPos + 49] >>> 12 | in[inPos + 51] - in[inPos + 50] << 30;
        out[outPos + 34] = in[inPos + 51] - in[inPos + 50] >>> 34 | in[inPos + 52] - in[inPos + 51] << 8 | in[inPos + 53] - in[inPos + 52] << 50;
        out[outPos + 35] = in[inPos + 53] - in[inPos + 52] >>> 14 | in[inPos + 54] - in[inPos + 53] << 28;
        out[outPos + 36] = in[inPos + 54] - in[inPos + 53] >>> 36 | in[inPos + 55] - in[inPos + 54] << 6 | in[inPos + 56] - in[inPos + 55] << 48;
        out[outPos + 37] = in[inPos + 56] - in[inPos + 55] >>> 16 | in[inPos + 57] - in[inPos + 56] << 26;
        out[outPos + 38] = in[inPos + 57] - in[inPos + 56] >>> 38 | in[inPos + 58] - in[inPos + 57] << 4 | in[inPos + 59] - in[inPos + 58] << 46;
        out[outPos + 39] = in[inPos + 59] - in[inPos + 58] >>> 18 | in[inPos + 60] - in[inPos + 59] << 24;
        out[outPos + 40] = in[inPos + 60] - in[inPos + 59] >>> 40 | in[inPos + 61] - in[inPos + 60] << 2 | in[inPos + 62] - in[inPos + 61] << 44;
        out[outPos + 41] = in[inPos + 62] - in[inPos + 61] >>> 20 | in[inPos + 63] - in[inPos + 62] << 22;
    }

    private static void unpack42(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 42 | (in[inPos + 1] & 0xFFFFFL) << 22) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 20 & 0x3FFFFFFFFFFL) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0xFFFFFFFFFFL) << 2) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 40 | (in[inPos + 3] & 0x3FFFFL) << 24) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 18 & 0x3FFFFFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0x3FFFFFFFFFL) << 4) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 38 | (in[inPos + 5] & 0xFFFFL) << 26) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 16 & 0x3FFFFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 0xFFFFFFFFFL) << 6) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 36 | (in[inPos + 7] & 0x3FFFL) << 28) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 14 & 0x3FFFFFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0x3FFFFFFFFL) << 8) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 34 | (in[inPos + 9] & 0xFFFL) << 30) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 9] >>> 12 & 0x3FFFFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0xFFFFFFFFL) << 10) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 10] >>> 32 | (in[inPos + 11] & 0x3FFL) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 11] >>> 10 & 0x3FFFFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0x3FFFFFFFL) << 12) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 12] >>> 30 | (in[inPos + 13] & 0xFFL) << 34) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 13] >>> 8 & 0x3FFFFFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 13] >>> 50 | (in[inPos + 14] & 0xFFFFFFFL) << 14) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 14] >>> 28 | (in[inPos + 15] & 0x3FL) << 36) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 15] >>> 6 & 0x3FFFFFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0x3FFFFFFL) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 16] >>> 26 | (in[inPos + 17] & 0xFL) << 38) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 17] >>> 4 & 0x3FFFFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 17] >>> 46 | (in[inPos + 18] & 0xFFFFFFL) << 18) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 18] >>> 24 | (in[inPos + 19] & 3L) << 40) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 19] >>> 2 & 0x3FFFFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0x3FFFFFL) << 20) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 20] >>> 22) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 21] & 0x3FFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 21] >>> 42 | (in[inPos + 22] & 0xFFFFFL) << 22) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 22] >>> 20 & 0x3FFFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 22] >>> 62 | (in[inPos + 23] & 0xFFFFFFFFFFL) << 2) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 23] >>> 40 | (in[inPos + 24] & 0x3FFFFL) << 24) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 24] >>> 18 & 0x3FFFFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 24] >>> 60 | (in[inPos + 25] & 0x3FFFFFFFFFL) << 4) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 25] >>> 38 | (in[inPos + 26] & 0xFFFFL) << 26) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 26] >>> 16 & 0x3FFFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 26] >>> 58 | (in[inPos + 27] & 0xFFFFFFFFFL) << 6) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 27] >>> 36 | (in[inPos + 28] & 0x3FFFL) << 28) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 28] >>> 14 & 0x3FFFFFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 28] >>> 56 | (in[inPos + 29] & 0x3FFFFFFFFL) << 8) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 29] >>> 34 | (in[inPos + 30] & 0xFFFL) << 30) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 30] >>> 12 & 0x3FFFFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 30] >>> 54 | (in[inPos + 31] & 0xFFFFFFFFL) << 10) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 31] >>> 32 | (in[inPos + 32] & 0x3FFL) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 32] >>> 10 & 0x3FFFFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 32] >>> 52 | (in[inPos + 33] & 0x3FFFFFFFL) << 12) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 33] >>> 30 | (in[inPos + 34] & 0xFFL) << 34) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 34] >>> 8 & 0x3FFFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 34] >>> 50 | (in[inPos + 35] & 0xFFFFFFFL) << 14) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 35] >>> 28 | (in[inPos + 36] & 0x3FL) << 36) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 36] >>> 6 & 0x3FFFFFFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 36] >>> 48 | (in[inPos + 37] & 0x3FFFFFFL) << 16) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 37] >>> 26 | (in[inPos + 38] & 0xFL) << 38) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 38] >>> 4 & 0x3FFFFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 38] >>> 46 | (in[inPos + 39] & 0xFFFFFFL) << 18) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 39] >>> 24 | (in[inPos + 40] & 3L) << 40) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 40] >>> 2 & 0x3FFFFFFFFFFL) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 40] >>> 44 | (in[inPos + 41] & 0x3FFFFFL) << 20) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 41] >>> 22) + out[outPos + 62];
    }

    private static void pack43(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 43;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 21 | in[inPos + 2] - in[inPos + 1] << 22;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 42 | in[inPos + 3] - in[inPos + 2] << 1 | in[inPos + 4] - in[inPos + 3] << 44;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 20 | in[inPos + 5] - in[inPos + 4] << 23;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 41 | in[inPos + 6] - in[inPos + 5] << 2 | in[inPos + 7] - in[inPos + 6] << 45;
        out[outPos + 5] = in[inPos + 7] - in[inPos + 6] >>> 19 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] >>> 40 | in[inPos + 9] - in[inPos + 8] << 3 | in[inPos + 10] - in[inPos + 9] << 46;
        out[outPos + 7] = in[inPos + 10] - in[inPos + 9] >>> 18 | in[inPos + 11] - in[inPos + 10] << 25;
        out[outPos + 8] = in[inPos + 11] - in[inPos + 10] >>> 39 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 47;
        out[outPos + 9] = in[inPos + 13] - in[inPos + 12] >>> 17 | in[inPos + 14] - in[inPos + 13] << 26;
        out[outPos + 10] = in[inPos + 14] - in[inPos + 13] >>> 38 | in[inPos + 15] - in[inPos + 14] << 5 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 11] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 27;
        out[outPos + 12] = in[inPos + 17] - in[inPos + 16] >>> 37 | in[inPos + 18] - in[inPos + 17] << 6 | in[inPos + 19] - in[inPos + 18] << 49;
        out[outPos + 13] = in[inPos + 19] - in[inPos + 18] >>> 15 | in[inPos + 20] - in[inPos + 19] << 28;
        out[outPos + 14] = in[inPos + 20] - in[inPos + 19] >>> 36 | in[inPos + 21] - in[inPos + 20] << 7 | in[inPos + 22] - in[inPos + 21] << 50;
        out[outPos + 15] = in[inPos + 22] - in[inPos + 21] >>> 14 | in[inPos + 23] - in[inPos + 22] << 29;
        out[outPos + 16] = in[inPos + 23] - in[inPos + 22] >>> 35 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 51;
        out[outPos + 17] = in[inPos + 25] - in[inPos + 24] >>> 13 | in[inPos + 26] - in[inPos + 25] << 30;
        out[outPos + 18] = in[inPos + 26] - in[inPos + 25] >>> 34 | in[inPos + 27] - in[inPos + 26] << 9 | in[inPos + 28] - in[inPos + 27] << 52;
        out[outPos + 19] = in[inPos + 28] - in[inPos + 27] >>> 12 | in[inPos + 29] - in[inPos + 28] << 31;
        out[outPos + 20] = in[inPos + 29] - in[inPos + 28] >>> 33 | in[inPos + 30] - in[inPos + 29] << 10 | in[inPos + 31] - in[inPos + 30] << 53;
        out[outPos + 21] = in[inPos + 31] - in[inPos + 30] >>> 11 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 22] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 11 | in[inPos + 34] - in[inPos + 33] << 54;
        out[outPos + 23] = in[inPos + 34] - in[inPos + 33] >>> 10 | in[inPos + 35] - in[inPos + 34] << 33;
        out[outPos + 24] = in[inPos + 35] - in[inPos + 34] >>> 31 | in[inPos + 36] - in[inPos + 35] << 12 | in[inPos + 37] - in[inPos + 36] << 55;
        out[outPos + 25] = in[inPos + 37] - in[inPos + 36] >>> 9 | in[inPos + 38] - in[inPos + 37] << 34;
        out[outPos + 26] = in[inPos + 38] - in[inPos + 37] >>> 30 | in[inPos + 39] - in[inPos + 38] << 13 | in[inPos + 40] - in[inPos + 39] << 56;
        out[outPos + 27] = in[inPos + 40] - in[inPos + 39] >>> 8 | in[inPos + 41] - in[inPos + 40] << 35;
        out[outPos + 28] = in[inPos + 41] - in[inPos + 40] >>> 29 | in[inPos + 42] - in[inPos + 41] << 14 | in[inPos + 43] - in[inPos + 42] << 57;
        out[outPos + 29] = in[inPos + 43] - in[inPos + 42] >>> 7 | in[inPos + 44] - in[inPos + 43] << 36;
        out[outPos + 30] = in[inPos + 44] - in[inPos + 43] >>> 28 | in[inPos + 45] - in[inPos + 44] << 15 | in[inPos + 46] - in[inPos + 45] << 58;
        out[outPos + 31] = in[inPos + 46] - in[inPos + 45] >>> 6 | in[inPos + 47] - in[inPos + 46] << 37;
        out[outPos + 32] = in[inPos + 47] - in[inPos + 46] >>> 27 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 59;
        out[outPos + 33] = in[inPos + 49] - in[inPos + 48] >>> 5 | in[inPos + 50] - in[inPos + 49] << 38;
        out[outPos + 34] = in[inPos + 50] - in[inPos + 49] >>> 26 | in[inPos + 51] - in[inPos + 50] << 17 | in[inPos + 52] - in[inPos + 51] << 60;
        out[outPos + 35] = in[inPos + 52] - in[inPos + 51] >>> 4 | in[inPos + 53] - in[inPos + 52] << 39;
        out[outPos + 36] = in[inPos + 53] - in[inPos + 52] >>> 25 | in[inPos + 54] - in[inPos + 53] << 18 | in[inPos + 55] - in[inPos + 54] << 61;
        out[outPos + 37] = in[inPos + 55] - in[inPos + 54] >>> 3 | in[inPos + 56] - in[inPos + 55] << 40;
        out[outPos + 38] = in[inPos + 56] - in[inPos + 55] >>> 24 | in[inPos + 57] - in[inPos + 56] << 19 | in[inPos + 58] - in[inPos + 57] << 62;
        out[outPos + 39] = in[inPos + 58] - in[inPos + 57] >>> 2 | in[inPos + 59] - in[inPos + 58] << 41;
        out[outPos + 40] = in[inPos + 59] - in[inPos + 58] >>> 23 | in[inPos + 60] - in[inPos + 59] << 20 | in[inPos + 61] - in[inPos + 60] << 63;
        out[outPos + 41] = in[inPos + 61] - in[inPos + 60] >>> 1 | in[inPos + 62] - in[inPos + 61] << 42;
        out[outPos + 42] = in[inPos + 62] - in[inPos + 61] >>> 22 | in[inPos + 63] - in[inPos + 62] << 21;
    }

    private static void unpack43(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 43 | (in[inPos + 1] & 0x3FFFFFL) << 21) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 22 | (in[inPos + 2] & 1L) << 42) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 1 & 0x7FFFFFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 44 | (in[inPos + 3] & 0x7FFFFFL) << 20) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 23 | (in[inPos + 4] & 3L) << 41) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 2 & 0x7FFFFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 45 | (in[inPos + 5] & 0xFFFFFFL) << 19) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 24 | (in[inPos + 6] & 7L) << 40) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 3 & 0x7FFFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 46 | (in[inPos + 7] & 0x1FFFFFFL) << 18) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 25 | (in[inPos + 8] & 0xFL) << 39) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 8] >>> 4 & 0x7FFFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 47 | (in[inPos + 9] & 0x3FFFFFFL) << 17) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 9] >>> 26 | (in[inPos + 10] & 0x1FL) << 38) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 10] >>> 5 & 0x7FFFFFFFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 10] >>> 48 | (in[inPos + 11] & 0x7FFFFFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 11] >>> 27 | (in[inPos + 12] & 0x3FL) << 37) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 12] >>> 6 & 0x7FFFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 12] >>> 49 | (in[inPos + 13] & 0xFFFFFFFL) << 15) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 13] >>> 28 | (in[inPos + 14] & 0x7FL) << 36) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 14] >>> 7 & 0x7FFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 14] >>> 50 | (in[inPos + 15] & 0x1FFFFFFFL) << 14) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 15] >>> 29 | (in[inPos + 16] & 0xFFL) << 35) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 16] >>> 8 & 0x7FFFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 16] >>> 51 | (in[inPos + 17] & 0x3FFFFFFFL) << 13) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 17] >>> 30 | (in[inPos + 18] & 0x1FFL) << 34) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 18] >>> 9 & 0x7FFFFFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 18] >>> 52 | (in[inPos + 19] & Integer.MAX_VALUE) << 12) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 19] >>> 31 | (in[inPos + 20] & 0x3FFL) << 33) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 20] >>> 10 & 0x7FFFFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 20] >>> 53 | (in[inPos + 21] & 0xFFFFFFFFL) << 11) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 21] >>> 32 | (in[inPos + 22] & 0x7FFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 22] >>> 11 & 0x7FFFFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 22] >>> 54 | (in[inPos + 23] & 0x1FFFFFFFFL) << 10) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 23] >>> 33 | (in[inPos + 24] & 0xFFFL) << 31) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 24] >>> 12 & 0x7FFFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 24] >>> 55 | (in[inPos + 25] & 0x3FFFFFFFFL) << 9) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 25] >>> 34 | (in[inPos + 26] & 0x1FFFL) << 30) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 26] >>> 13 & 0x7FFFFFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 26] >>> 56 | (in[inPos + 27] & 0x7FFFFFFFFL) << 8) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 27] >>> 35 | (in[inPos + 28] & 0x3FFFL) << 29) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 28] >>> 14 & 0x7FFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 28] >>> 57 | (in[inPos + 29] & 0xFFFFFFFFFL) << 7) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 29] >>> 36 | (in[inPos + 30] & 0x7FFFL) << 28) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 30] >>> 15 & 0x7FFFFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 30] >>> 58 | (in[inPos + 31] & 0x1FFFFFFFFFL) << 6) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 31] >>> 37 | (in[inPos + 32] & 0xFFFFL) << 27) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 32] >>> 16 & 0x7FFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 32] >>> 59 | (in[inPos + 33] & 0x3FFFFFFFFFL) << 5) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 33] >>> 38 | (in[inPos + 34] & 0x1FFFFL) << 26) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 34] >>> 17 & 0x7FFFFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 34] >>> 60 | (in[inPos + 35] & 0x7FFFFFFFFFL) << 4) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 35] >>> 39 | (in[inPos + 36] & 0x3FFFFL) << 25) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 36] >>> 18 & 0x7FFFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 36] >>> 61 | (in[inPos + 37] & 0xFFFFFFFFFFL) << 3) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 37] >>> 40 | (in[inPos + 38] & 0x7FFFFL) << 24) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 38] >>> 19 & 0x7FFFFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 38] >>> 62 | (in[inPos + 39] & 0x1FFFFFFFFFFL) << 2) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 39] >>> 41 | (in[inPos + 40] & 0xFFFFFL) << 23) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 40] >>> 20 & 0x7FFFFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 40] >>> 63 | (in[inPos + 41] & 0x3FFFFFFFFFFL) << 1) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 41] >>> 42 | (in[inPos + 42] & 0x1FFFFFL) << 22) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 42] >>> 21) + out[outPos + 62];
    }

    private static void pack44(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 44;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 20 | in[inPos + 2] - in[inPos + 1] << 24;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 40 | in[inPos + 3] - in[inPos + 2] << 4 | in[inPos + 4] - in[inPos + 3] << 48;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 16 | in[inPos + 5] - in[inPos + 4] << 28;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 36 | in[inPos + 6] - in[inPos + 5] << 8 | in[inPos + 7] - in[inPos + 6] << 52;
        out[outPos + 5] = in[inPos + 7] - in[inPos + 6] >>> 12 | in[inPos + 8] - in[inPos + 7] << 32;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] >>> 32 | in[inPos + 9] - in[inPos + 8] << 12 | in[inPos + 10] - in[inPos + 9] << 56;
        out[outPos + 7] = in[inPos + 10] - in[inPos + 9] >>> 8 | in[inPos + 11] - in[inPos + 10] << 36;
        out[outPos + 8] = in[inPos + 11] - in[inPos + 10] >>> 28 | in[inPos + 12] - in[inPos + 11] << 16 | in[inPos + 13] - in[inPos + 12] << 60;
        out[outPos + 9] = in[inPos + 13] - in[inPos + 12] >>> 4 | in[inPos + 14] - in[inPos + 13] << 40;
        out[outPos + 10] = in[inPos + 14] - in[inPos + 13] >>> 24 | in[inPos + 15] - in[inPos + 14] << 20;
        out[outPos + 11] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 44;
        out[outPos + 12] = in[inPos + 17] - in[inPos + 16] >>> 20 | in[inPos + 18] - in[inPos + 17] << 24;
        out[outPos + 13] = in[inPos + 18] - in[inPos + 17] >>> 40 | in[inPos + 19] - in[inPos + 18] << 4 | in[inPos + 20] - in[inPos + 19] << 48;
        out[outPos + 14] = in[inPos + 20] - in[inPos + 19] >>> 16 | in[inPos + 21] - in[inPos + 20] << 28;
        out[outPos + 15] = in[inPos + 21] - in[inPos + 20] >>> 36 | in[inPos + 22] - in[inPos + 21] << 8 | in[inPos + 23] - in[inPos + 22] << 52;
        out[outPos + 16] = in[inPos + 23] - in[inPos + 22] >>> 12 | in[inPos + 24] - in[inPos + 23] << 32;
        out[outPos + 17] = in[inPos + 24] - in[inPos + 23] >>> 32 | in[inPos + 25] - in[inPos + 24] << 12 | in[inPos + 26] - in[inPos + 25] << 56;
        out[outPos + 18] = in[inPos + 26] - in[inPos + 25] >>> 8 | in[inPos + 27] - in[inPos + 26] << 36;
        out[outPos + 19] = in[inPos + 27] - in[inPos + 26] >>> 28 | in[inPos + 28] - in[inPos + 27] << 16 | in[inPos + 29] - in[inPos + 28] << 60;
        out[outPos + 20] = in[inPos + 29] - in[inPos + 28] >>> 4 | in[inPos + 30] - in[inPos + 29] << 40;
        out[outPos + 21] = in[inPos + 30] - in[inPos + 29] >>> 24 | in[inPos + 31] - in[inPos + 30] << 20;
        out[outPos + 22] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 44;
        out[outPos + 23] = in[inPos + 33] - in[inPos + 32] >>> 20 | in[inPos + 34] - in[inPos + 33] << 24;
        out[outPos + 24] = in[inPos + 34] - in[inPos + 33] >>> 40 | in[inPos + 35] - in[inPos + 34] << 4 | in[inPos + 36] - in[inPos + 35] << 48;
        out[outPos + 25] = in[inPos + 36] - in[inPos + 35] >>> 16 | in[inPos + 37] - in[inPos + 36] << 28;
        out[outPos + 26] = in[inPos + 37] - in[inPos + 36] >>> 36 | in[inPos + 38] - in[inPos + 37] << 8 | in[inPos + 39] - in[inPos + 38] << 52;
        out[outPos + 27] = in[inPos + 39] - in[inPos + 38] >>> 12 | in[inPos + 40] - in[inPos + 39] << 32;
        out[outPos + 28] = in[inPos + 40] - in[inPos + 39] >>> 32 | in[inPos + 41] - in[inPos + 40] << 12 | in[inPos + 42] - in[inPos + 41] << 56;
        out[outPos + 29] = in[inPos + 42] - in[inPos + 41] >>> 8 | in[inPos + 43] - in[inPos + 42] << 36;
        out[outPos + 30] = in[inPos + 43] - in[inPos + 42] >>> 28 | in[inPos + 44] - in[inPos + 43] << 16 | in[inPos + 45] - in[inPos + 44] << 60;
        out[outPos + 31] = in[inPos + 45] - in[inPos + 44] >>> 4 | in[inPos + 46] - in[inPos + 45] << 40;
        out[outPos + 32] = in[inPos + 46] - in[inPos + 45] >>> 24 | in[inPos + 47] - in[inPos + 46] << 20;
        out[outPos + 33] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 44;
        out[outPos + 34] = in[inPos + 49] - in[inPos + 48] >>> 20 | in[inPos + 50] - in[inPos + 49] << 24;
        out[outPos + 35] = in[inPos + 50] - in[inPos + 49] >>> 40 | in[inPos + 51] - in[inPos + 50] << 4 | in[inPos + 52] - in[inPos + 51] << 48;
        out[outPos + 36] = in[inPos + 52] - in[inPos + 51] >>> 16 | in[inPos + 53] - in[inPos + 52] << 28;
        out[outPos + 37] = in[inPos + 53] - in[inPos + 52] >>> 36 | in[inPos + 54] - in[inPos + 53] << 8 | in[inPos + 55] - in[inPos + 54] << 52;
        out[outPos + 38] = in[inPos + 55] - in[inPos + 54] >>> 12 | in[inPos + 56] - in[inPos + 55] << 32;
        out[outPos + 39] = in[inPos + 56] - in[inPos + 55] >>> 32 | in[inPos + 57] - in[inPos + 56] << 12 | in[inPos + 58] - in[inPos + 57] << 56;
        out[outPos + 40] = in[inPos + 58] - in[inPos + 57] >>> 8 | in[inPos + 59] - in[inPos + 58] << 36;
        out[outPos + 41] = in[inPos + 59] - in[inPos + 58] >>> 28 | in[inPos + 60] - in[inPos + 59] << 16 | in[inPos + 61] - in[inPos + 60] << 60;
        out[outPos + 42] = in[inPos + 61] - in[inPos + 60] >>> 4 | in[inPos + 62] - in[inPos + 61] << 40;
        out[outPos + 43] = in[inPos + 62] - in[inPos + 61] >>> 24 | in[inPos + 63] - in[inPos + 62] << 20;
    }

    private static void unpack44(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 44 | (in[inPos + 1] & 0xFFFFFFL) << 20) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 24 | (in[inPos + 2] & 0xFL) << 40) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 4 & 0xFFFFFFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 48 | (in[inPos + 3] & 0xFFFFFFFL) << 16) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 28 | (in[inPos + 4] & 0xFFL) << 36) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 8 & 0xFFFFFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 52 | (in[inPos + 5] & 0xFFFFFFFFL) << 12) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 32 | (in[inPos + 6] & 0xFFFL) << 32) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 12 & 0xFFFFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 6] >>> 56 | (in[inPos + 7] & 0xFFFFFFFFFL) << 8) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 36 | (in[inPos + 8] & 0xFFFFL) << 28) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 8] >>> 16 & 0xFFFFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 8] >>> 60 | (in[inPos + 9] & 0xFFFFFFFFFFL) << 4) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 9] >>> 40 | (in[inPos + 10] & 0xFFFFFL) << 24) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 10] >>> 20) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 11] & 0xFFFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 11] >>> 44 | (in[inPos + 12] & 0xFFFFFFL) << 20) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 12] >>> 24 | (in[inPos + 13] & 0xFL) << 40) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 13] >>> 4 & 0xFFFFFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 13] >>> 48 | (in[inPos + 14] & 0xFFFFFFFL) << 16) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 14] >>> 28 | (in[inPos + 15] & 0xFFL) << 36) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 15] >>> 8 & 0xFFFFFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 15] >>> 52 | (in[inPos + 16] & 0xFFFFFFFFL) << 12) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 16] >>> 32 | (in[inPos + 17] & 0xFFFL) << 32) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 17] >>> 12 & 0xFFFFFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 17] >>> 56 | (in[inPos + 18] & 0xFFFFFFFFFL) << 8) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 18] >>> 36 | (in[inPos + 19] & 0xFFFFL) << 28) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 19] >>> 16 & 0xFFFFFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 19] >>> 60 | (in[inPos + 20] & 0xFFFFFFFFFFL) << 4) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 20] >>> 40 | (in[inPos + 21] & 0xFFFFFL) << 24) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 21] >>> 20) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 22] & 0xFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 22] >>> 44 | (in[inPos + 23] & 0xFFFFFFL) << 20) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 23] >>> 24 | (in[inPos + 24] & 0xFL) << 40) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 24] >>> 4 & 0xFFFFFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 24] >>> 48 | (in[inPos + 25] & 0xFFFFFFFL) << 16) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 25] >>> 28 | (in[inPos + 26] & 0xFFL) << 36) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 26] >>> 8 & 0xFFFFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 26] >>> 52 | (in[inPos + 27] & 0xFFFFFFFFL) << 12) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 27] >>> 32 | (in[inPos + 28] & 0xFFFL) << 32) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 28] >>> 12 & 0xFFFFFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 28] >>> 56 | (in[inPos + 29] & 0xFFFFFFFFFL) << 8) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 29] >>> 36 | (in[inPos + 30] & 0xFFFFL) << 28) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 30] >>> 16 & 0xFFFFFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 30] >>> 60 | (in[inPos + 31] & 0xFFFFFFFFFFL) << 4) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 31] >>> 40 | (in[inPos + 32] & 0xFFFFFL) << 24) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 32] >>> 20) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 33] & 0xFFFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 33] >>> 44 | (in[inPos + 34] & 0xFFFFFFL) << 20) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 34] >>> 24 | (in[inPos + 35] & 0xFL) << 40) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 35] >>> 4 & 0xFFFFFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 35] >>> 48 | (in[inPos + 36] & 0xFFFFFFFL) << 16) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 36] >>> 28 | (in[inPos + 37] & 0xFFL) << 36) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 37] >>> 8 & 0xFFFFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 37] >>> 52 | (in[inPos + 38] & 0xFFFFFFFFL) << 12) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 38] >>> 32 | (in[inPos + 39] & 0xFFFL) << 32) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 39] >>> 12 & 0xFFFFFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 39] >>> 56 | (in[inPos + 40] & 0xFFFFFFFFFL) << 8) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 40] >>> 36 | (in[inPos + 41] & 0xFFFFL) << 28) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 41] >>> 16 & 0xFFFFFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 41] >>> 60 | (in[inPos + 42] & 0xFFFFFFFFFFL) << 4) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 42] >>> 40 | (in[inPos + 43] & 0xFFFFFL) << 24) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 43] >>> 20) + out[outPos + 62];
    }

    private static void pack45(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 45;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 19 | in[inPos + 2] - in[inPos + 1] << 26;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 38 | in[inPos + 3] - in[inPos + 2] << 7 | in[inPos + 4] - in[inPos + 3] << 52;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 12 | in[inPos + 5] - in[inPos + 4] << 33;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 31 | in[inPos + 6] - in[inPos + 5] << 14 | in[inPos + 7] - in[inPos + 6] << 59;
        out[outPos + 5] = in[inPos + 7] - in[inPos + 6] >>> 5 | in[inPos + 8] - in[inPos + 7] << 40;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] >>> 24 | in[inPos + 9] - in[inPos + 8] << 21;
        out[outPos + 7] = in[inPos + 9] - in[inPos + 8] >>> 43 | in[inPos + 10] - in[inPos + 9] << 2 | in[inPos + 11] - in[inPos + 10] << 47;
        out[outPos + 8] = in[inPos + 11] - in[inPos + 10] >>> 17 | in[inPos + 12] - in[inPos + 11] << 28;
        out[outPos + 9] = in[inPos + 12] - in[inPos + 11] >>> 36 | in[inPos + 13] - in[inPos + 12] << 9 | in[inPos + 14] - in[inPos + 13] << 54;
        out[outPos + 10] = in[inPos + 14] - in[inPos + 13] >>> 10 | in[inPos + 15] - in[inPos + 14] << 35;
        out[outPos + 11] = in[inPos + 15] - in[inPos + 14] >>> 29 | in[inPos + 16] - in[inPos + 15] << 16 | in[inPos + 17] - in[inPos + 16] << 61;
        out[outPos + 12] = in[inPos + 17] - in[inPos + 16] >>> 3 | in[inPos + 18] - in[inPos + 17] << 42;
        out[outPos + 13] = in[inPos + 18] - in[inPos + 17] >>> 22 | in[inPos + 19] - in[inPos + 18] << 23;
        out[outPos + 14] = in[inPos + 19] - in[inPos + 18] >>> 41 | in[inPos + 20] - in[inPos + 19] << 4 | in[inPos + 21] - in[inPos + 20] << 49;
        out[outPos + 15] = in[inPos + 21] - in[inPos + 20] >>> 15 | in[inPos + 22] - in[inPos + 21] << 30;
        out[outPos + 16] = in[inPos + 22] - in[inPos + 21] >>> 34 | in[inPos + 23] - in[inPos + 22] << 11 | in[inPos + 24] - in[inPos + 23] << 56;
        out[outPos + 17] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 37;
        out[outPos + 18] = in[inPos + 25] - in[inPos + 24] >>> 27 | in[inPos + 26] - in[inPos + 25] << 18 | in[inPos + 27] - in[inPos + 26] << 63;
        out[outPos + 19] = in[inPos + 27] - in[inPos + 26] >>> 1 | in[inPos + 28] - in[inPos + 27] << 44;
        out[outPos + 20] = in[inPos + 28] - in[inPos + 27] >>> 20 | in[inPos + 29] - in[inPos + 28] << 25;
        out[outPos + 21] = in[inPos + 29] - in[inPos + 28] >>> 39 | in[inPos + 30] - in[inPos + 29] << 6 | in[inPos + 31] - in[inPos + 30] << 51;
        out[outPos + 22] = in[inPos + 31] - in[inPos + 30] >>> 13 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 23] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 13 | in[inPos + 34] - in[inPos + 33] << 58;
        out[outPos + 24] = in[inPos + 34] - in[inPos + 33] >>> 6 | in[inPos + 35] - in[inPos + 34] << 39;
        out[outPos + 25] = in[inPos + 35] - in[inPos + 34] >>> 25 | in[inPos + 36] - in[inPos + 35] << 20;
        out[outPos + 26] = in[inPos + 36] - in[inPos + 35] >>> 44 | in[inPos + 37] - in[inPos + 36] << 1 | in[inPos + 38] - in[inPos + 37] << 46;
        out[outPos + 27] = in[inPos + 38] - in[inPos + 37] >>> 18 | in[inPos + 39] - in[inPos + 38] << 27;
        out[outPos + 28] = in[inPos + 39] - in[inPos + 38] >>> 37 | in[inPos + 40] - in[inPos + 39] << 8 | in[inPos + 41] - in[inPos + 40] << 53;
        out[outPos + 29] = in[inPos + 41] - in[inPos + 40] >>> 11 | in[inPos + 42] - in[inPos + 41] << 34;
        out[outPos + 30] = in[inPos + 42] - in[inPos + 41] >>> 30 | in[inPos + 43] - in[inPos + 42] << 15 | in[inPos + 44] - in[inPos + 43] << 60;
        out[outPos + 31] = in[inPos + 44] - in[inPos + 43] >>> 4 | in[inPos + 45] - in[inPos + 44] << 41;
        out[outPos + 32] = in[inPos + 45] - in[inPos + 44] >>> 23 | in[inPos + 46] - in[inPos + 45] << 22;
        out[outPos + 33] = in[inPos + 46] - in[inPos + 45] >>> 42 | in[inPos + 47] - in[inPos + 46] << 3 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 34] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 29;
        out[outPos + 35] = in[inPos + 49] - in[inPos + 48] >>> 35 | in[inPos + 50] - in[inPos + 49] << 10 | in[inPos + 51] - in[inPos + 50] << 55;
        out[outPos + 36] = in[inPos + 51] - in[inPos + 50] >>> 9 | in[inPos + 52] - in[inPos + 51] << 36;
        out[outPos + 37] = in[inPos + 52] - in[inPos + 51] >>> 28 | in[inPos + 53] - in[inPos + 52] << 17 | in[inPos + 54] - in[inPos + 53] << 62;
        out[outPos + 38] = in[inPos + 54] - in[inPos + 53] >>> 2 | in[inPos + 55] - in[inPos + 54] << 43;
        out[outPos + 39] = in[inPos + 55] - in[inPos + 54] >>> 21 | in[inPos + 56] - in[inPos + 55] << 24;
        out[outPos + 40] = in[inPos + 56] - in[inPos + 55] >>> 40 | in[inPos + 57] - in[inPos + 56] << 5 | in[inPos + 58] - in[inPos + 57] << 50;
        out[outPos + 41] = in[inPos + 58] - in[inPos + 57] >>> 14 | in[inPos + 59] - in[inPos + 58] << 31;
        out[outPos + 42] = in[inPos + 59] - in[inPos + 58] >>> 33 | in[inPos + 60] - in[inPos + 59] << 12 | in[inPos + 61] - in[inPos + 60] << 57;
        out[outPos + 43] = in[inPos + 61] - in[inPos + 60] >>> 7 | in[inPos + 62] - in[inPos + 61] << 38;
        out[outPos + 44] = in[inPos + 62] - in[inPos + 61] >>> 26 | in[inPos + 63] - in[inPos + 62] << 19;
    }

    private static void unpack45(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 45 | (in[inPos + 1] & 0x3FFFFFFL) << 19) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 26 | (in[inPos + 2] & 0x7FL) << 38) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 7 & 0x1FFFFFFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 52 | (in[inPos + 3] & 0x1FFFFFFFFL) << 12) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 33 | (in[inPos + 4] & 0x3FFFL) << 31) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 14 & 0x1FFFFFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 4] >>> 59 | (in[inPos + 5] & 0xFFFFFFFFFFL) << 5) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 40 | (in[inPos + 6] & 0x1FFFFFL) << 24) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 21 | (in[inPos + 7] & 3L) << 43) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 2 & 0x1FFFFFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 47 | (in[inPos + 8] & 0xFFFFFFFL) << 17) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 8] >>> 28 | (in[inPos + 9] & 0x1FFL) << 36) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 9] >>> 9 & 0x1FFFFFFFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0x7FFFFFFFFL) << 10) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 10] >>> 35 | (in[inPos + 11] & 0xFFFFL) << 29) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 11] >>> 16 & 0x1FFFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 11] >>> 61 | (in[inPos + 12] & 0x3FFFFFFFFFFL) << 3) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 12] >>> 42 | (in[inPos + 13] & 0x7FFFFFL) << 22) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 13] >>> 23 | (in[inPos + 14] & 0xFL) << 41) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 14] >>> 4 & 0x1FFFFFFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 14] >>> 49 | (in[inPos + 15] & 0x3FFFFFFFL) << 15) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 15] >>> 30 | (in[inPos + 16] & 0x7FFL) << 34) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 16] >>> 11 & 0x1FFFFFFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0x1FFFFFFFFFL) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 17] >>> 37 | (in[inPos + 18] & 0x3FFFFL) << 27) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 18] >>> 18 & 0x1FFFFFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 18] >>> 63 | (in[inPos + 19] & 0xFFFFFFFFFFFL) << 1) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0x1FFFFFFL) << 20) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 20] >>> 25 | (in[inPos + 21] & 0x3FL) << 39) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 21] >>> 6 & 0x1FFFFFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 21] >>> 51 | (in[inPos + 22] & 0xFFFFFFFFL) << 13) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 22] >>> 32 | (in[inPos + 23] & 0x1FFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 23] >>> 13 & 0x1FFFFFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 23] >>> 58 | (in[inPos + 24] & 0x7FFFFFFFFFL) << 6) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 24] >>> 39 | (in[inPos + 25] & 0xFFFFFL) << 25) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 25] >>> 20 | (in[inPos + 26] & 1L) << 44) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 26] >>> 1 & 0x1FFFFFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 26] >>> 46 | (in[inPos + 27] & 0x7FFFFFFL) << 18) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 27] >>> 27 | (in[inPos + 28] & 0xFFL) << 37) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 28] >>> 8 & 0x1FFFFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 28] >>> 53 | (in[inPos + 29] & 0x3FFFFFFFFL) << 11) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 29] >>> 34 | (in[inPos + 30] & 0x7FFFL) << 30) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 30] >>> 15 & 0x1FFFFFFFFFFFL) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 30] >>> 60 | (in[inPos + 31] & 0x1FFFFFFFFFFL) << 4) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 31] >>> 41 | (in[inPos + 32] & 0x3FFFFFL) << 23) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 32] >>> 22 | (in[inPos + 33] & 7L) << 42) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 33] >>> 3 & 0x1FFFFFFFFFFFL) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 33] >>> 48 | (in[inPos + 34] & 0x1FFFFFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 34] >>> 29 | (in[inPos + 35] & 0x3FFL) << 35) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 35] >>> 10 & 0x1FFFFFFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 35] >>> 55 | (in[inPos + 36] & 0xFFFFFFFFFL) << 9) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 36] >>> 36 | (in[inPos + 37] & 0x1FFFFL) << 28) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 37] >>> 17 & 0x1FFFFFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 37] >>> 62 | (in[inPos + 38] & 0x7FFFFFFFFFFL) << 2) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 38] >>> 43 | (in[inPos + 39] & 0xFFFFFFL) << 21) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 39] >>> 24 | (in[inPos + 40] & 0x1FL) << 40) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 40] >>> 5 & 0x1FFFFFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 40] >>> 50 | (in[inPos + 41] & Integer.MAX_VALUE) << 14) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 41] >>> 31 | (in[inPos + 42] & 0xFFFL) << 33) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 42] >>> 12 & 0x1FFFFFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 42] >>> 57 | (in[inPos + 43] & 0x3FFFFFFFFFL) << 7) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 43] >>> 38 | (in[inPos + 44] & 0x7FFFFL) << 26) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 44] >>> 19) + out[outPos + 62];
    }

    private static void pack46(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 46;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 18 | in[inPos + 2] - in[inPos + 1] << 28;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 36 | in[inPos + 3] - in[inPos + 2] << 10 | in[inPos + 4] - in[inPos + 3] << 56;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 8 | in[inPos + 5] - in[inPos + 4] << 38;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 26 | in[inPos + 6] - in[inPos + 5] << 20;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 44 | in[inPos + 7] - in[inPos + 6] << 2 | in[inPos + 8] - in[inPos + 7] << 48;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 30;
        out[outPos + 7] = in[inPos + 9] - in[inPos + 8] >>> 34 | in[inPos + 10] - in[inPos + 9] << 12 | in[inPos + 11] - in[inPos + 10] << 58;
        out[outPos + 8] = in[inPos + 11] - in[inPos + 10] >>> 6 | in[inPos + 12] - in[inPos + 11] << 40;
        out[outPos + 9] = in[inPos + 12] - in[inPos + 11] >>> 24 | in[inPos + 13] - in[inPos + 12] << 22;
        out[outPos + 10] = in[inPos + 13] - in[inPos + 12] >>> 42 | in[inPos + 14] - in[inPos + 13] << 4 | in[inPos + 15] - in[inPos + 14] << 50;
        out[outPos + 11] = in[inPos + 15] - in[inPos + 14] >>> 14 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 12] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 14 | in[inPos + 18] - in[inPos + 17] << 60;
        out[outPos + 13] = in[inPos + 18] - in[inPos + 17] >>> 4 | in[inPos + 19] - in[inPos + 18] << 42;
        out[outPos + 14] = in[inPos + 19] - in[inPos + 18] >>> 22 | in[inPos + 20] - in[inPos + 19] << 24;
        out[outPos + 15] = in[inPos + 20] - in[inPos + 19] >>> 40 | in[inPos + 21] - in[inPos + 20] << 6 | in[inPos + 22] - in[inPos + 21] << 52;
        out[outPos + 16] = in[inPos + 22] - in[inPos + 21] >>> 12 | in[inPos + 23] - in[inPos + 22] << 34;
        out[outPos + 17] = in[inPos + 23] - in[inPos + 22] >>> 30 | in[inPos + 24] - in[inPos + 23] << 16 | in[inPos + 25] - in[inPos + 24] << 62;
        out[outPos + 18] = in[inPos + 25] - in[inPos + 24] >>> 2 | in[inPos + 26] - in[inPos + 25] << 44;
        out[outPos + 19] = in[inPos + 26] - in[inPos + 25] >>> 20 | in[inPos + 27] - in[inPos + 26] << 26;
        out[outPos + 20] = in[inPos + 27] - in[inPos + 26] >>> 38 | in[inPos + 28] - in[inPos + 27] << 8 | in[inPos + 29] - in[inPos + 28] << 54;
        out[outPos + 21] = in[inPos + 29] - in[inPos + 28] >>> 10 | in[inPos + 30] - in[inPos + 29] << 36;
        out[outPos + 22] = in[inPos + 30] - in[inPos + 29] >>> 28 | in[inPos + 31] - in[inPos + 30] << 18;
        out[outPos + 23] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 46;
        out[outPos + 24] = in[inPos + 33] - in[inPos + 32] >>> 18 | in[inPos + 34] - in[inPos + 33] << 28;
        out[outPos + 25] = in[inPos + 34] - in[inPos + 33] >>> 36 | in[inPos + 35] - in[inPos + 34] << 10 | in[inPos + 36] - in[inPos + 35] << 56;
        out[outPos + 26] = in[inPos + 36] - in[inPos + 35] >>> 8 | in[inPos + 37] - in[inPos + 36] << 38;
        out[outPos + 27] = in[inPos + 37] - in[inPos + 36] >>> 26 | in[inPos + 38] - in[inPos + 37] << 20;
        out[outPos + 28] = in[inPos + 38] - in[inPos + 37] >>> 44 | in[inPos + 39] - in[inPos + 38] << 2 | in[inPos + 40] - in[inPos + 39] << 48;
        out[outPos + 29] = in[inPos + 40] - in[inPos + 39] >>> 16 | in[inPos + 41] - in[inPos + 40] << 30;
        out[outPos + 30] = in[inPos + 41] - in[inPos + 40] >>> 34 | in[inPos + 42] - in[inPos + 41] << 12 | in[inPos + 43] - in[inPos + 42] << 58;
        out[outPos + 31] = in[inPos + 43] - in[inPos + 42] >>> 6 | in[inPos + 44] - in[inPos + 43] << 40;
        out[outPos + 32] = in[inPos + 44] - in[inPos + 43] >>> 24 | in[inPos + 45] - in[inPos + 44] << 22;
        out[outPos + 33] = in[inPos + 45] - in[inPos + 44] >>> 42 | in[inPos + 46] - in[inPos + 45] << 4 | in[inPos + 47] - in[inPos + 46] << 50;
        out[outPos + 34] = in[inPos + 47] - in[inPos + 46] >>> 14 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 35] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 14 | in[inPos + 50] - in[inPos + 49] << 60;
        out[outPos + 36] = in[inPos + 50] - in[inPos + 49] >>> 4 | in[inPos + 51] - in[inPos + 50] << 42;
        out[outPos + 37] = in[inPos + 51] - in[inPos + 50] >>> 22 | in[inPos + 52] - in[inPos + 51] << 24;
        out[outPos + 38] = in[inPos + 52] - in[inPos + 51] >>> 40 | in[inPos + 53] - in[inPos + 52] << 6 | in[inPos + 54] - in[inPos + 53] << 52;
        out[outPos + 39] = in[inPos + 54] - in[inPos + 53] >>> 12 | in[inPos + 55] - in[inPos + 54] << 34;
        out[outPos + 40] = in[inPos + 55] - in[inPos + 54] >>> 30 | in[inPos + 56] - in[inPos + 55] << 16 | in[inPos + 57] - in[inPos + 56] << 62;
        out[outPos + 41] = in[inPos + 57] - in[inPos + 56] >>> 2 | in[inPos + 58] - in[inPos + 57] << 44;
        out[outPos + 42] = in[inPos + 58] - in[inPos + 57] >>> 20 | in[inPos + 59] - in[inPos + 58] << 26;
        out[outPos + 43] = in[inPos + 59] - in[inPos + 58] >>> 38 | in[inPos + 60] - in[inPos + 59] << 8 | in[inPos + 61] - in[inPos + 60] << 54;
        out[outPos + 44] = in[inPos + 61] - in[inPos + 60] >>> 10 | in[inPos + 62] - in[inPos + 61] << 36;
        out[outPos + 45] = in[inPos + 62] - in[inPos + 61] >>> 28 | in[inPos + 63] - in[inPos + 62] << 18;
    }

    private static void unpack46(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 46 | (in[inPos + 1] & 0xFFFFFFFL) << 18) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 28 | (in[inPos + 2] & 0x3FFL) << 36) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 10 & 0x3FFFFFFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 56 | (in[inPos + 3] & 0x3FFFFFFFFFL) << 8) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 38 | (in[inPos + 4] & 0xFFFFFL) << 26) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 20 | (in[inPos + 5] & 3L) << 44) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 2 & 0x3FFFFFFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 48 | (in[inPos + 6] & 0x3FFFFFFFL) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 30 | (in[inPos + 7] & 0xFFFL) << 34) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 12 & 0x3FFFFFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 7] >>> 58 | (in[inPos + 8] & 0xFFFFFFFFFFL) << 6) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 8] >>> 40 | (in[inPos + 9] & 0x3FFFFFL) << 24) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 9] >>> 22 | (in[inPos + 10] & 0xFL) << 42) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 4 & 0x3FFFFFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 10] >>> 50 | (in[inPos + 11] & 0xFFFFFFFFL) << 14) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 11] >>> 32 | (in[inPos + 12] & 0x3FFFL) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 12] >>> 14 & 0x3FFFFFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 12] >>> 60 | (in[inPos + 13] & 0x3FFFFFFFFFFL) << 4) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 13] >>> 42 | (in[inPos + 14] & 0xFFFFFFL) << 22) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 14] >>> 24 | (in[inPos + 15] & 0x3FL) << 40) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 15] >>> 6 & 0x3FFFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 15] >>> 52 | (in[inPos + 16] & 0x3FFFFFFFFL) << 12) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 16] >>> 34 | (in[inPos + 17] & 0xFFFFL) << 30) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 17] >>> 16 & 0x3FFFFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 17] >>> 62 | (in[inPos + 18] & 0xFFFFFFFFFFFL) << 2) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 18] >>> 44 | (in[inPos + 19] & 0x3FFFFFFL) << 20) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 19] >>> 26 | (in[inPos + 20] & 0xFFL) << 38) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 20] >>> 8 & 0x3FFFFFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 20] >>> 54 | (in[inPos + 21] & 0xFFFFFFFFFL) << 10) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 21] >>> 36 | (in[inPos + 22] & 0x3FFFFL) << 28) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 22] >>> 18) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 23] & 0x3FFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 23] >>> 46 | (in[inPos + 24] & 0xFFFFFFFL) << 18) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 24] >>> 28 | (in[inPos + 25] & 0x3FFL) << 36) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 25] >>> 10 & 0x3FFFFFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 25] >>> 56 | (in[inPos + 26] & 0x3FFFFFFFFFL) << 8) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 26] >>> 38 | (in[inPos + 27] & 0xFFFFFL) << 26) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 27] >>> 20 | (in[inPos + 28] & 3L) << 44) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 28] >>> 2 & 0x3FFFFFFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 28] >>> 48 | (in[inPos + 29] & 0x3FFFFFFFL) << 16) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 29] >>> 30 | (in[inPos + 30] & 0xFFFL) << 34) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 30] >>> 12 & 0x3FFFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 30] >>> 58 | (in[inPos + 31] & 0xFFFFFFFFFFL) << 6) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 31] >>> 40 | (in[inPos + 32] & 0x3FFFFFL) << 24) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 32] >>> 22 | (in[inPos + 33] & 0xFL) << 42) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 33] >>> 4 & 0x3FFFFFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 33] >>> 50 | (in[inPos + 34] & 0xFFFFFFFFL) << 14) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 34] >>> 32 | (in[inPos + 35] & 0x3FFFL) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 35] >>> 14 & 0x3FFFFFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 35] >>> 60 | (in[inPos + 36] & 0x3FFFFFFFFFFL) << 4) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 36] >>> 42 | (in[inPos + 37] & 0xFFFFFFL) << 22) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 37] >>> 24 | (in[inPos + 38] & 0x3FL) << 40) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 38] >>> 6 & 0x3FFFFFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 38] >>> 52 | (in[inPos + 39] & 0x3FFFFFFFFL) << 12) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 39] >>> 34 | (in[inPos + 40] & 0xFFFFL) << 30) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 40] >>> 16 & 0x3FFFFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 40] >>> 62 | (in[inPos + 41] & 0xFFFFFFFFFFFL) << 2) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 41] >>> 44 | (in[inPos + 42] & 0x3FFFFFFL) << 20) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 42] >>> 26 | (in[inPos + 43] & 0xFFL) << 38) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 43] >>> 8 & 0x3FFFFFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 43] >>> 54 | (in[inPos + 44] & 0xFFFFFFFFFL) << 10) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 44] >>> 36 | (in[inPos + 45] & 0x3FFFFL) << 28) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 45] >>> 18) + out[outPos + 62];
    }

    private static void pack47(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 47;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 17 | in[inPos + 2] - in[inPos + 1] << 30;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 34 | in[inPos + 3] - in[inPos + 2] << 13 | in[inPos + 4] - in[inPos + 3] << 60;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 43;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 21 | in[inPos + 6] - in[inPos + 5] << 26;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 38 | in[inPos + 7] - in[inPos + 6] << 9 | in[inPos + 8] - in[inPos + 7] << 56;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 39;
        out[outPos + 7] = in[inPos + 9] - in[inPos + 8] >>> 25 | in[inPos + 10] - in[inPos + 9] << 22;
        out[outPos + 8] = in[inPos + 10] - in[inPos + 9] >>> 42 | in[inPos + 11] - in[inPos + 10] << 5 | in[inPos + 12] - in[inPos + 11] << 52;
        out[outPos + 9] = in[inPos + 12] - in[inPos + 11] >>> 12 | in[inPos + 13] - in[inPos + 12] << 35;
        out[outPos + 10] = in[inPos + 13] - in[inPos + 12] >>> 29 | in[inPos + 14] - in[inPos + 13] << 18;
        out[outPos + 11] = in[inPos + 14] - in[inPos + 13] >>> 46 | in[inPos + 15] - in[inPos + 14] << 1 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 12] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 31;
        out[outPos + 13] = in[inPos + 17] - in[inPos + 16] >>> 33 | in[inPos + 18] - in[inPos + 17] << 14 | in[inPos + 19] - in[inPos + 18] << 61;
        out[outPos + 14] = in[inPos + 19] - in[inPos + 18] >>> 3 | in[inPos + 20] - in[inPos + 19] << 44;
        out[outPos + 15] = in[inPos + 20] - in[inPos + 19] >>> 20 | in[inPos + 21] - in[inPos + 20] << 27;
        out[outPos + 16] = in[inPos + 21] - in[inPos + 20] >>> 37 | in[inPos + 22] - in[inPos + 21] << 10 | in[inPos + 23] - in[inPos + 22] << 57;
        out[outPos + 17] = in[inPos + 23] - in[inPos + 22] >>> 7 | in[inPos + 24] - in[inPos + 23] << 40;
        out[outPos + 18] = in[inPos + 24] - in[inPos + 23] >>> 24 | in[inPos + 25] - in[inPos + 24] << 23;
        out[outPos + 19] = in[inPos + 25] - in[inPos + 24] >>> 41 | in[inPos + 26] - in[inPos + 25] << 6 | in[inPos + 27] - in[inPos + 26] << 53;
        out[outPos + 20] = in[inPos + 27] - in[inPos + 26] >>> 11 | in[inPos + 28] - in[inPos + 27] << 36;
        out[outPos + 21] = in[inPos + 28] - in[inPos + 27] >>> 28 | in[inPos + 29] - in[inPos + 28] << 19;
        out[outPos + 22] = in[inPos + 29] - in[inPos + 28] >>> 45 | in[inPos + 30] - in[inPos + 29] << 2 | in[inPos + 31] - in[inPos + 30] << 49;
        out[outPos + 23] = in[inPos + 31] - in[inPos + 30] >>> 15 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 24] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 15 | in[inPos + 34] - in[inPos + 33] << 62;
        out[outPos + 25] = in[inPos + 34] - in[inPos + 33] >>> 2 | in[inPos + 35] - in[inPos + 34] << 45;
        out[outPos + 26] = in[inPos + 35] - in[inPos + 34] >>> 19 | in[inPos + 36] - in[inPos + 35] << 28;
        out[outPos + 27] = in[inPos + 36] - in[inPos + 35] >>> 36 | in[inPos + 37] - in[inPos + 36] << 11 | in[inPos + 38] - in[inPos + 37] << 58;
        out[outPos + 28] = in[inPos + 38] - in[inPos + 37] >>> 6 | in[inPos + 39] - in[inPos + 38] << 41;
        out[outPos + 29] = in[inPos + 39] - in[inPos + 38] >>> 23 | in[inPos + 40] - in[inPos + 39] << 24;
        out[outPos + 30] = in[inPos + 40] - in[inPos + 39] >>> 40 | in[inPos + 41] - in[inPos + 40] << 7 | in[inPos + 42] - in[inPos + 41] << 54;
        out[outPos + 31] = in[inPos + 42] - in[inPos + 41] >>> 10 | in[inPos + 43] - in[inPos + 42] << 37;
        out[outPos + 32] = in[inPos + 43] - in[inPos + 42] >>> 27 | in[inPos + 44] - in[inPos + 43] << 20;
        out[outPos + 33] = in[inPos + 44] - in[inPos + 43] >>> 44 | in[inPos + 45] - in[inPos + 44] << 3 | in[inPos + 46] - in[inPos + 45] << 50;
        out[outPos + 34] = in[inPos + 46] - in[inPos + 45] >>> 14 | in[inPos + 47] - in[inPos + 46] << 33;
        out[outPos + 35] = in[inPos + 47] - in[inPos + 46] >>> 31 | in[inPos + 48] - in[inPos + 47] << 16 | in[inPos + 49] - in[inPos + 48] << 63;
        out[outPos + 36] = in[inPos + 49] - in[inPos + 48] >>> 1 | in[inPos + 50] - in[inPos + 49] << 46;
        out[outPos + 37] = in[inPos + 50] - in[inPos + 49] >>> 18 | in[inPos + 51] - in[inPos + 50] << 29;
        out[outPos + 38] = in[inPos + 51] - in[inPos + 50] >>> 35 | in[inPos + 52] - in[inPos + 51] << 12 | in[inPos + 53] - in[inPos + 52] << 59;
        out[outPos + 39] = in[inPos + 53] - in[inPos + 52] >>> 5 | in[inPos + 54] - in[inPos + 53] << 42;
        out[outPos + 40] = in[inPos + 54] - in[inPos + 53] >>> 22 | in[inPos + 55] - in[inPos + 54] << 25;
        out[outPos + 41] = in[inPos + 55] - in[inPos + 54] >>> 39 | in[inPos + 56] - in[inPos + 55] << 8 | in[inPos + 57] - in[inPos + 56] << 55;
        out[outPos + 42] = in[inPos + 57] - in[inPos + 56] >>> 9 | in[inPos + 58] - in[inPos + 57] << 38;
        out[outPos + 43] = in[inPos + 58] - in[inPos + 57] >>> 26 | in[inPos + 59] - in[inPos + 58] << 21;
        out[outPos + 44] = in[inPos + 59] - in[inPos + 58] >>> 43 | in[inPos + 60] - in[inPos + 59] << 4 | in[inPos + 61] - in[inPos + 60] << 51;
        out[outPos + 45] = in[inPos + 61] - in[inPos + 60] >>> 13 | in[inPos + 62] - in[inPos + 61] << 34;
        out[outPos + 46] = in[inPos + 62] - in[inPos + 61] >>> 30 | in[inPos + 63] - in[inPos + 62] << 17;
    }

    private static void unpack47(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 47 | (in[inPos + 1] & 0x3FFFFFFFL) << 17) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 30 | (in[inPos + 2] & 0x1FFFL) << 34) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 13 & 0x7FFFFFFFFFFFL) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 2] >>> 60 | (in[inPos + 3] & 0x7FFFFFFFFFFL) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 43 | (in[inPos + 4] & 0x3FFFFFFL) << 21) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 26 | (in[inPos + 5] & 0x1FFL) << 38) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 9 & 0x7FFFFFFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 5] >>> 56 | (in[inPos + 6] & 0x7FFFFFFFFFL) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 39 | (in[inPos + 7] & 0x3FFFFFL) << 25) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 22 | (in[inPos + 8] & 0x1FL) << 42) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 5 & 0x7FFFFFFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 8] >>> 52 | (in[inPos + 9] & 0x7FFFFFFFFL) << 12) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 9] >>> 35 | (in[inPos + 10] & 0x3FFFFL) << 29) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 18 | (in[inPos + 11] & 1L) << 46) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 11] >>> 1 & 0x7FFFFFFFFFFFL) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 11] >>> 48 | (in[inPos + 12] & Integer.MAX_VALUE) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 12] >>> 31 | (in[inPos + 13] & 0x3FFFL) << 33) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 13] >>> 14 & 0x7FFFFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 13] >>> 61 | (in[inPos + 14] & 0xFFFFFFFFFFFL) << 3) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 14] >>> 44 | (in[inPos + 15] & 0x7FFFFFFL) << 20) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 15] >>> 27 | (in[inPos + 16] & 0x3FFL) << 37) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 16] >>> 10 & 0x7FFFFFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 16] >>> 57 | (in[inPos + 17] & 0xFFFFFFFFFFL) << 7) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 17] >>> 40 | (in[inPos + 18] & 0x7FFFFFL) << 24) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 18] >>> 23 | (in[inPos + 19] & 0x3FL) << 41) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 19] >>> 6 & 0x7FFFFFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 19] >>> 53 | (in[inPos + 20] & 0xFFFFFFFFFL) << 11) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 20] >>> 36 | (in[inPos + 21] & 0x7FFFFL) << 28) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 21] >>> 19 | (in[inPos + 22] & 3L) << 45) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 22] >>> 2 & 0x7FFFFFFFFFFFL) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 22] >>> 49 | (in[inPos + 23] & 0xFFFFFFFFL) << 15) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 23] >>> 32 | (in[inPos + 24] & 0x7FFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 24] >>> 15 & 0x7FFFFFFFFFFFL) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 24] >>> 62 | (in[inPos + 25] & 0x1FFFFFFFFFFFL) << 2) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 25] >>> 45 | (in[inPos + 26] & 0xFFFFFFFL) << 19) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 26] >>> 28 | (in[inPos + 27] & 0x7FFL) << 36) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 27] >>> 11 & 0x7FFFFFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 27] >>> 58 | (in[inPos + 28] & 0x1FFFFFFFFFFL) << 6) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 28] >>> 41 | (in[inPos + 29] & 0xFFFFFFL) << 23) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 29] >>> 24 | (in[inPos + 30] & 0x7FL) << 40) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 30] >>> 7 & 0x7FFFFFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 30] >>> 54 | (in[inPos + 31] & 0x1FFFFFFFFFL) << 10) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 31] >>> 37 | (in[inPos + 32] & 0xFFFFFL) << 27) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 32] >>> 20 | (in[inPos + 33] & 7L) << 44) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 33] >>> 3 & 0x7FFFFFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 33] >>> 50 | (in[inPos + 34] & 0x1FFFFFFFFL) << 14) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 34] >>> 33 | (in[inPos + 35] & 0xFFFFL) << 31) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 35] >>> 16 & 0x7FFFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 35] >>> 63 | (in[inPos + 36] & 0x3FFFFFFFFFFFL) << 1) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 36] >>> 46 | (in[inPos + 37] & 0x1FFFFFFFL) << 18) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 37] >>> 29 | (in[inPos + 38] & 0xFFFL) << 35) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 38] >>> 12 & 0x7FFFFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 38] >>> 59 | (in[inPos + 39] & 0x3FFFFFFFFFFL) << 5) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 39] >>> 42 | (in[inPos + 40] & 0x1FFFFFFL) << 22) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 40] >>> 25 | (in[inPos + 41] & 0xFFL) << 39) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 41] >>> 8 & 0x7FFFFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 41] >>> 55 | (in[inPos + 42] & 0x3FFFFFFFFFL) << 9) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 42] >>> 38 | (in[inPos + 43] & 0x1FFFFFL) << 26) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 43] >>> 21 | (in[inPos + 44] & 0xFL) << 43) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 44] >>> 4 & 0x7FFFFFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 44] >>> 51 | (in[inPos + 45] & 0x3FFFFFFFFL) << 13) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 45] >>> 34 | (in[inPos + 46] & 0x1FFFFL) << 30) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 46] >>> 17) + out[outPos + 62];
    }

    private static void pack48(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 48;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 16 | in[inPos + 2] - in[inPos + 1] << 32;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 32 | in[inPos + 3] - in[inPos + 2] << 16;
        out[outPos + 3] = in[inPos + 4] - in[inPos + 3] | in[inPos + 5] - in[inPos + 4] << 48;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 16 | in[inPos + 6] - in[inPos + 5] << 32;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 32 | in[inPos + 7] - in[inPos + 6] << 16;
        out[outPos + 6] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 48;
        out[outPos + 7] = in[inPos + 9] - in[inPos + 8] >>> 16 | in[inPos + 10] - in[inPos + 9] << 32;
        out[outPos + 8] = in[inPos + 10] - in[inPos + 9] >>> 32 | in[inPos + 11] - in[inPos + 10] << 16;
        out[outPos + 9] = in[inPos + 12] - in[inPos + 11] | in[inPos + 13] - in[inPos + 12] << 48;
        out[outPos + 10] = in[inPos + 13] - in[inPos + 12] >>> 16 | in[inPos + 14] - in[inPos + 13] << 32;
        out[outPos + 11] = in[inPos + 14] - in[inPos + 13] >>> 32 | in[inPos + 15] - in[inPos + 14] << 16;
        out[outPos + 12] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 48;
        out[outPos + 13] = in[inPos + 17] - in[inPos + 16] >>> 16 | in[inPos + 18] - in[inPos + 17] << 32;
        out[outPos + 14] = in[inPos + 18] - in[inPos + 17] >>> 32 | in[inPos + 19] - in[inPos + 18] << 16;
        out[outPos + 15] = in[inPos + 20] - in[inPos + 19] | in[inPos + 21] - in[inPos + 20] << 48;
        out[outPos + 16] = in[inPos + 21] - in[inPos + 20] >>> 16 | in[inPos + 22] - in[inPos + 21] << 32;
        out[outPos + 17] = in[inPos + 22] - in[inPos + 21] >>> 32 | in[inPos + 23] - in[inPos + 22] << 16;
        out[outPos + 18] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 48;
        out[outPos + 19] = in[inPos + 25] - in[inPos + 24] >>> 16 | in[inPos + 26] - in[inPos + 25] << 32;
        out[outPos + 20] = in[inPos + 26] - in[inPos + 25] >>> 32 | in[inPos + 27] - in[inPos + 26] << 16;
        out[outPos + 21] = in[inPos + 28] - in[inPos + 27] | in[inPos + 29] - in[inPos + 28] << 48;
        out[outPos + 22] = in[inPos + 29] - in[inPos + 28] >>> 16 | in[inPos + 30] - in[inPos + 29] << 32;
        out[outPos + 23] = in[inPos + 30] - in[inPos + 29] >>> 32 | in[inPos + 31] - in[inPos + 30] << 16;
        out[outPos + 24] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 48;
        out[outPos + 25] = in[inPos + 33] - in[inPos + 32] >>> 16 | in[inPos + 34] - in[inPos + 33] << 32;
        out[outPos + 26] = in[inPos + 34] - in[inPos + 33] >>> 32 | in[inPos + 35] - in[inPos + 34] << 16;
        out[outPos + 27] = in[inPos + 36] - in[inPos + 35] | in[inPos + 37] - in[inPos + 36] << 48;
        out[outPos + 28] = in[inPos + 37] - in[inPos + 36] >>> 16 | in[inPos + 38] - in[inPos + 37] << 32;
        out[outPos + 29] = in[inPos + 38] - in[inPos + 37] >>> 32 | in[inPos + 39] - in[inPos + 38] << 16;
        out[outPos + 30] = in[inPos + 40] - in[inPos + 39] | in[inPos + 41] - in[inPos + 40] << 48;
        out[outPos + 31] = in[inPos + 41] - in[inPos + 40] >>> 16 | in[inPos + 42] - in[inPos + 41] << 32;
        out[outPos + 32] = in[inPos + 42] - in[inPos + 41] >>> 32 | in[inPos + 43] - in[inPos + 42] << 16;
        out[outPos + 33] = in[inPos + 44] - in[inPos + 43] | in[inPos + 45] - in[inPos + 44] << 48;
        out[outPos + 34] = in[inPos + 45] - in[inPos + 44] >>> 16 | in[inPos + 46] - in[inPos + 45] << 32;
        out[outPos + 35] = in[inPos + 46] - in[inPos + 45] >>> 32 | in[inPos + 47] - in[inPos + 46] << 16;
        out[outPos + 36] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 48;
        out[outPos + 37] = in[inPos + 49] - in[inPos + 48] >>> 16 | in[inPos + 50] - in[inPos + 49] << 32;
        out[outPos + 38] = in[inPos + 50] - in[inPos + 49] >>> 32 | in[inPos + 51] - in[inPos + 50] << 16;
        out[outPos + 39] = in[inPos + 52] - in[inPos + 51] | in[inPos + 53] - in[inPos + 52] << 48;
        out[outPos + 40] = in[inPos + 53] - in[inPos + 52] >>> 16 | in[inPos + 54] - in[inPos + 53] << 32;
        out[outPos + 41] = in[inPos + 54] - in[inPos + 53] >>> 32 | in[inPos + 55] - in[inPos + 54] << 16;
        out[outPos + 42] = in[inPos + 56] - in[inPos + 55] | in[inPos + 57] - in[inPos + 56] << 48;
        out[outPos + 43] = in[inPos + 57] - in[inPos + 56] >>> 16 | in[inPos + 58] - in[inPos + 57] << 32;
        out[outPos + 44] = in[inPos + 58] - in[inPos + 57] >>> 32 | in[inPos + 59] - in[inPos + 58] << 16;
        out[outPos + 45] = in[inPos + 60] - in[inPos + 59] | in[inPos + 61] - in[inPos + 60] << 48;
        out[outPos + 46] = in[inPos + 61] - in[inPos + 60] >>> 16 | in[inPos + 62] - in[inPos + 61] << 32;
        out[outPos + 47] = in[inPos + 62] - in[inPos + 61] >>> 32 | in[inPos + 63] - in[inPos + 62] << 16;
    }

    private static void unpack48(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 48 | (in[inPos + 1] & 0xFFFFFFFFL) << 16) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 32 | (in[inPos + 2] & 0xFFFFL) << 32) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 16) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] & 0xFFFFFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 48 | (in[inPos + 4] & 0xFFFFFFFFL) << 16) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 32 | (in[inPos + 5] & 0xFFFFL) << 32) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 16) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] & 0xFFFFFFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 48 | (in[inPos + 7] & 0xFFFFFFFFL) << 16) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 32 | (in[inPos + 8] & 0xFFFFL) << 32) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 16) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] & 0xFFFFFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 9] >>> 48 | (in[inPos + 10] & 0xFFFFFFFFL) << 16) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 32 | (in[inPos + 11] & 0xFFFFL) << 32) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 11] >>> 16) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 12] & 0xFFFFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 12] >>> 48 | (in[inPos + 13] & 0xFFFFFFFFL) << 16) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 13] >>> 32 | (in[inPos + 14] & 0xFFFFL) << 32) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 14] >>> 16) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 15] & 0xFFFFFFFFFFFFL) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0xFFFFFFFFL) << 16) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 16] >>> 32 | (in[inPos + 17] & 0xFFFFL) << 32) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 17] >>> 16) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 18] & 0xFFFFFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0xFFFFFFFFL) << 16) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 19] >>> 32 | (in[inPos + 20] & 0xFFFFL) << 32) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 20] >>> 16) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 21] & 0xFFFFFFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 21] >>> 48 | (in[inPos + 22] & 0xFFFFFFFFL) << 16) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 22] >>> 32 | (in[inPos + 23] & 0xFFFFL) << 32) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 23] >>> 16) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 24] & 0xFFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 24] >>> 48 | (in[inPos + 25] & 0xFFFFFFFFL) << 16) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 25] >>> 32 | (in[inPos + 26] & 0xFFFFL) << 32) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 26] >>> 16) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 27] & 0xFFFFFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 27] >>> 48 | (in[inPos + 28] & 0xFFFFFFFFL) << 16) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 28] >>> 32 | (in[inPos + 29] & 0xFFFFL) << 32) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 29] >>> 16) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 30] & 0xFFFFFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 30] >>> 48 | (in[inPos + 31] & 0xFFFFFFFFL) << 16) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 31] >>> 32 | (in[inPos + 32] & 0xFFFFL) << 32) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 32] >>> 16) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 33] & 0xFFFFFFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 33] >>> 48 | (in[inPos + 34] & 0xFFFFFFFFL) << 16) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 34] >>> 32 | (in[inPos + 35] & 0xFFFFL) << 32) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 35] >>> 16) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 36] & 0xFFFFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 36] >>> 48 | (in[inPos + 37] & 0xFFFFFFFFL) << 16) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 37] >>> 32 | (in[inPos + 38] & 0xFFFFL) << 32) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 38] >>> 16) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 39] & 0xFFFFFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 39] >>> 48 | (in[inPos + 40] & 0xFFFFFFFFL) << 16) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 40] >>> 32 | (in[inPos + 41] & 0xFFFFL) << 32) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 41] >>> 16) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 42] & 0xFFFFFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 42] >>> 48 | (in[inPos + 43] & 0xFFFFFFFFL) << 16) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 43] >>> 32 | (in[inPos + 44] & 0xFFFFL) << 32) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 44] >>> 16) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 45] & 0xFFFFFFFFFFFFL) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 45] >>> 48 | (in[inPos + 46] & 0xFFFFFFFFL) << 16) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 46] >>> 32 | (in[inPos + 47] & 0xFFFFL) << 32) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 47] >>> 16) + out[outPos + 62];
    }

    private static void pack49(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 49;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 15 | in[inPos + 2] - in[inPos + 1] << 34;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 30 | in[inPos + 3] - in[inPos + 2] << 19;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 45 | in[inPos + 4] - in[inPos + 3] << 4 | in[inPos + 5] - in[inPos + 4] << 53;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 11 | in[inPos + 6] - in[inPos + 5] << 38;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 26 | in[inPos + 7] - in[inPos + 6] << 23;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 41 | in[inPos + 8] - in[inPos + 7] << 8 | in[inPos + 9] - in[inPos + 8] << 57;
        out[outPos + 7] = in[inPos + 9] - in[inPos + 8] >>> 7 | in[inPos + 10] - in[inPos + 9] << 42;
        out[outPos + 8] = in[inPos + 10] - in[inPos + 9] >>> 22 | in[inPos + 11] - in[inPos + 10] << 27;
        out[outPos + 9] = in[inPos + 11] - in[inPos + 10] >>> 37 | in[inPos + 12] - in[inPos + 11] << 12 | in[inPos + 13] - in[inPos + 12] << 61;
        out[outPos + 10] = in[inPos + 13] - in[inPos + 12] >>> 3 | in[inPos + 14] - in[inPos + 13] << 46;
        out[outPos + 11] = in[inPos + 14] - in[inPos + 13] >>> 18 | in[inPos + 15] - in[inPos + 14] << 31;
        out[outPos + 12] = in[inPos + 15] - in[inPos + 14] >>> 33 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 13] = in[inPos + 16] - in[inPos + 15] >>> 48 | in[inPos + 17] - in[inPos + 16] << 1 | in[inPos + 18] - in[inPos + 17] << 50;
        out[outPos + 14] = in[inPos + 18] - in[inPos + 17] >>> 14 | in[inPos + 19] - in[inPos + 18] << 35;
        out[outPos + 15] = in[inPos + 19] - in[inPos + 18] >>> 29 | in[inPos + 20] - in[inPos + 19] << 20;
        out[outPos + 16] = in[inPos + 20] - in[inPos + 19] >>> 44 | in[inPos + 21] - in[inPos + 20] << 5 | in[inPos + 22] - in[inPos + 21] << 54;
        out[outPos + 17] = in[inPos + 22] - in[inPos + 21] >>> 10 | in[inPos + 23] - in[inPos + 22] << 39;
        out[outPos + 18] = in[inPos + 23] - in[inPos + 22] >>> 25 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 19] = in[inPos + 24] - in[inPos + 23] >>> 40 | in[inPos + 25] - in[inPos + 24] << 9 | in[inPos + 26] - in[inPos + 25] << 58;
        out[outPos + 20] = in[inPos + 26] - in[inPos + 25] >>> 6 | in[inPos + 27] - in[inPos + 26] << 43;
        out[outPos + 21] = in[inPos + 27] - in[inPos + 26] >>> 21 | in[inPos + 28] - in[inPos + 27] << 28;
        out[outPos + 22] = in[inPos + 28] - in[inPos + 27] >>> 36 | in[inPos + 29] - in[inPos + 28] << 13 | in[inPos + 30] - in[inPos + 29] << 62;
        out[outPos + 23] = in[inPos + 30] - in[inPos + 29] >>> 2 | in[inPos + 31] - in[inPos + 30] << 47;
        out[outPos + 24] = in[inPos + 31] - in[inPos + 30] >>> 17 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 25] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 17;
        out[outPos + 26] = in[inPos + 33] - in[inPos + 32] >>> 47 | in[inPos + 34] - in[inPos + 33] << 2 | in[inPos + 35] - in[inPos + 34] << 51;
        out[outPos + 27] = in[inPos + 35] - in[inPos + 34] >>> 13 | in[inPos + 36] - in[inPos + 35] << 36;
        out[outPos + 28] = in[inPos + 36] - in[inPos + 35] >>> 28 | in[inPos + 37] - in[inPos + 36] << 21;
        out[outPos + 29] = in[inPos + 37] - in[inPos + 36] >>> 43 | in[inPos + 38] - in[inPos + 37] << 6 | in[inPos + 39] - in[inPos + 38] << 55;
        out[outPos + 30] = in[inPos + 39] - in[inPos + 38] >>> 9 | in[inPos + 40] - in[inPos + 39] << 40;
        out[outPos + 31] = in[inPos + 40] - in[inPos + 39] >>> 24 | in[inPos + 41] - in[inPos + 40] << 25;
        out[outPos + 32] = in[inPos + 41] - in[inPos + 40] >>> 39 | in[inPos + 42] - in[inPos + 41] << 10 | in[inPos + 43] - in[inPos + 42] << 59;
        out[outPos + 33] = in[inPos + 43] - in[inPos + 42] >>> 5 | in[inPos + 44] - in[inPos + 43] << 44;
        out[outPos + 34] = in[inPos + 44] - in[inPos + 43] >>> 20 | in[inPos + 45] - in[inPos + 44] << 29;
        out[outPos + 35] = in[inPos + 45] - in[inPos + 44] >>> 35 | in[inPos + 46] - in[inPos + 45] << 14 | in[inPos + 47] - in[inPos + 46] << 63;
        out[outPos + 36] = in[inPos + 47] - in[inPos + 46] >>> 1 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 37] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 33;
        out[outPos + 38] = in[inPos + 49] - in[inPos + 48] >>> 31 | in[inPos + 50] - in[inPos + 49] << 18;
        out[outPos + 39] = in[inPos + 50] - in[inPos + 49] >>> 46 | in[inPos + 51] - in[inPos + 50] << 3 | in[inPos + 52] - in[inPos + 51] << 52;
        out[outPos + 40] = in[inPos + 52] - in[inPos + 51] >>> 12 | in[inPos + 53] - in[inPos + 52] << 37;
        out[outPos + 41] = in[inPos + 53] - in[inPos + 52] >>> 27 | in[inPos + 54] - in[inPos + 53] << 22;
        out[outPos + 42] = in[inPos + 54] - in[inPos + 53] >>> 42 | in[inPos + 55] - in[inPos + 54] << 7 | in[inPos + 56] - in[inPos + 55] << 56;
        out[outPos + 43] = in[inPos + 56] - in[inPos + 55] >>> 8 | in[inPos + 57] - in[inPos + 56] << 41;
        out[outPos + 44] = in[inPos + 57] - in[inPos + 56] >>> 23 | in[inPos + 58] - in[inPos + 57] << 26;
        out[outPos + 45] = in[inPos + 58] - in[inPos + 57] >>> 38 | in[inPos + 59] - in[inPos + 58] << 11 | in[inPos + 60] - in[inPos + 59] << 60;
        out[outPos + 46] = in[inPos + 60] - in[inPos + 59] >>> 4 | in[inPos + 61] - in[inPos + 60] << 45;
        out[outPos + 47] = in[inPos + 61] - in[inPos + 60] >>> 19 | in[inPos + 62] - in[inPos + 61] << 30;
        out[outPos + 48] = in[inPos + 62] - in[inPos + 61] >>> 34 | in[inPos + 63] - in[inPos + 62] << 15;
    }

    private static void unpack49(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 49 | (in[inPos + 1] & 0x3FFFFFFFFL) << 15) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 34 | (in[inPos + 2] & 0x7FFFFL) << 30) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 19 | (in[inPos + 3] & 0xFL) << 45) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 4 & 0x1FFFFFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 53 | (in[inPos + 4] & 0x3FFFFFFFFFL) << 11) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 38 | (in[inPos + 5] & 0x7FFFFFL) << 26) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 23 | (in[inPos + 6] & 0xFFL) << 41) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 8 & 0x1FFFFFFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 6] >>> 57 | (in[inPos + 7] & 0x3FFFFFFFFFFL) << 7) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 42 | (in[inPos + 8] & 0x7FFFFFFL) << 22) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 27 | (in[inPos + 9] & 0xFFFL) << 37) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] >>> 12 & 0x1FFFFFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 9] >>> 61 | (in[inPos + 10] & 0x3FFFFFFFFFFFL) << 3) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 46 | (in[inPos + 11] & Integer.MAX_VALUE) << 18) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 11] >>> 31 | (in[inPos + 12] & 0xFFFFL) << 33) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 12] >>> 16 | (in[inPos + 13] & 1L) << 48) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 13] >>> 1 & 0x1FFFFFFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 13] >>> 50 | (in[inPos + 14] & 0x7FFFFFFFFL) << 14) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 14] >>> 35 | (in[inPos + 15] & 0xFFFFFL) << 29) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 15] >>> 20 | (in[inPos + 16] & 0x1FL) << 44) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 16] >>> 5 & 0x1FFFFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 16] >>> 54 | (in[inPos + 17] & 0x7FFFFFFFFFL) << 10) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 17] >>> 39 | (in[inPos + 18] & 0xFFFFFFL) << 25) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 18] >>> 24 | (in[inPos + 19] & 0x1FFL) << 40) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 19] >>> 9 & 0x1FFFFFFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 19] >>> 58 | (in[inPos + 20] & 0x7FFFFFFFFFFL) << 6) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 20] >>> 43 | (in[inPos + 21] & 0xFFFFFFFL) << 21) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 21] >>> 28 | (in[inPos + 22] & 0x1FFFL) << 36) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 22] >>> 13 & 0x1FFFFFFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 22] >>> 62 | (in[inPos + 23] & 0x7FFFFFFFFFFFL) << 2) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 23] >>> 47 | (in[inPos + 24] & 0xFFFFFFFFL) << 17) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 24] >>> 32 | (in[inPos + 25] & 0x1FFFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 25] >>> 17 | (in[inPos + 26] & 3L) << 47) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 26] >>> 2 & 0x1FFFFFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 26] >>> 51 | (in[inPos + 27] & 0xFFFFFFFFFL) << 13) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 27] >>> 36 | (in[inPos + 28] & 0x1FFFFFL) << 28) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 28] >>> 21 | (in[inPos + 29] & 0x3FL) << 43) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 29] >>> 6 & 0x1FFFFFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 29] >>> 55 | (in[inPos + 30] & 0xFFFFFFFFFFL) << 9) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 30] >>> 40 | (in[inPos + 31] & 0x1FFFFFFL) << 24) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 31] >>> 25 | (in[inPos + 32] & 0x3FFL) << 39) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 32] >>> 10 & 0x1FFFFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 32] >>> 59 | (in[inPos + 33] & 0xFFFFFFFFFFFL) << 5) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 33] >>> 44 | (in[inPos + 34] & 0x1FFFFFFFL) << 20) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 34] >>> 29 | (in[inPos + 35] & 0x3FFFL) << 35) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 35] >>> 14 & 0x1FFFFFFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 35] >>> 63 | (in[inPos + 36] & 0xFFFFFFFFFFFFL) << 1) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 36] >>> 48 | (in[inPos + 37] & 0x1FFFFFFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 37] >>> 33 | (in[inPos + 38] & 0x3FFFFL) << 31) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 38] >>> 18 | (in[inPos + 39] & 7L) << 46) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 39] >>> 3 & 0x1FFFFFFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 39] >>> 52 | (in[inPos + 40] & 0x1FFFFFFFFFL) << 12) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 40] >>> 37 | (in[inPos + 41] & 0x3FFFFFL) << 27) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 41] >>> 22 | (in[inPos + 42] & 0x7FL) << 42) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 42] >>> 7 & 0x1FFFFFFFFFFFFL) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 42] >>> 56 | (in[inPos + 43] & 0x1FFFFFFFFFFL) << 8) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 43] >>> 41 | (in[inPos + 44] & 0x3FFFFFFL) << 23) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 44] >>> 26 | (in[inPos + 45] & 0x7FFL) << 38) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 45] >>> 11 & 0x1FFFFFFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 45] >>> 60 | (in[inPos + 46] & 0x1FFFFFFFFFFFL) << 4) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 46] >>> 45 | (in[inPos + 47] & 0x3FFFFFFFL) << 19) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 47] >>> 30 | (in[inPos + 48] & 0x7FFFL) << 34) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 48] >>> 15) + out[outPos + 62];
    }

    private static void pack50(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 50;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 14 | in[inPos + 2] - in[inPos + 1] << 36;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 28 | in[inPos + 3] - in[inPos + 2] << 22;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 42 | in[inPos + 4] - in[inPos + 3] << 8 | in[inPos + 5] - in[inPos + 4] << 58;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 6 | in[inPos + 6] - in[inPos + 5] << 44;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 20 | in[inPos + 7] - in[inPos + 6] << 30;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 34 | in[inPos + 8] - in[inPos + 7] << 16;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 48 | in[inPos + 9] - in[inPos + 8] << 2 | in[inPos + 10] - in[inPos + 9] << 52;
        out[outPos + 8] = in[inPos + 10] - in[inPos + 9] >>> 12 | in[inPos + 11] - in[inPos + 10] << 38;
        out[outPos + 9] = in[inPos + 11] - in[inPos + 10] >>> 26 | in[inPos + 12] - in[inPos + 11] << 24;
        out[outPos + 10] = in[inPos + 12] - in[inPos + 11] >>> 40 | in[inPos + 13] - in[inPos + 12] << 10 | in[inPos + 14] - in[inPos + 13] << 60;
        out[outPos + 11] = in[inPos + 14] - in[inPos + 13] >>> 4 | in[inPos + 15] - in[inPos + 14] << 46;
        out[outPos + 12] = in[inPos + 15] - in[inPos + 14] >>> 18 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 13] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 18;
        out[outPos + 14] = in[inPos + 17] - in[inPos + 16] >>> 46 | in[inPos + 18] - in[inPos + 17] << 4 | in[inPos + 19] - in[inPos + 18] << 54;
        out[outPos + 15] = in[inPos + 19] - in[inPos + 18] >>> 10 | in[inPos + 20] - in[inPos + 19] << 40;
        out[outPos + 16] = in[inPos + 20] - in[inPos + 19] >>> 24 | in[inPos + 21] - in[inPos + 20] << 26;
        out[outPos + 17] = in[inPos + 21] - in[inPos + 20] >>> 38 | in[inPos + 22] - in[inPos + 21] << 12 | in[inPos + 23] - in[inPos + 22] << 62;
        out[outPos + 18] = in[inPos + 23] - in[inPos + 22] >>> 2 | in[inPos + 24] - in[inPos + 23] << 48;
        out[outPos + 19] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 34;
        out[outPos + 20] = in[inPos + 25] - in[inPos + 24] >>> 30 | in[inPos + 26] - in[inPos + 25] << 20;
        out[outPos + 21] = in[inPos + 26] - in[inPos + 25] >>> 44 | in[inPos + 27] - in[inPos + 26] << 6 | in[inPos + 28] - in[inPos + 27] << 56;
        out[outPos + 22] = in[inPos + 28] - in[inPos + 27] >>> 8 | in[inPos + 29] - in[inPos + 28] << 42;
        out[outPos + 23] = in[inPos + 29] - in[inPos + 28] >>> 22 | in[inPos + 30] - in[inPos + 29] << 28;
        out[outPos + 24] = in[inPos + 30] - in[inPos + 29] >>> 36 | in[inPos + 31] - in[inPos + 30] << 14;
        out[outPos + 25] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 50;
        out[outPos + 26] = in[inPos + 33] - in[inPos + 32] >>> 14 | in[inPos + 34] - in[inPos + 33] << 36;
        out[outPos + 27] = in[inPos + 34] - in[inPos + 33] >>> 28 | in[inPos + 35] - in[inPos + 34] << 22;
        out[outPos + 28] = in[inPos + 35] - in[inPos + 34] >>> 42 | in[inPos + 36] - in[inPos + 35] << 8 | in[inPos + 37] - in[inPos + 36] << 58;
        out[outPos + 29] = in[inPos + 37] - in[inPos + 36] >>> 6 | in[inPos + 38] - in[inPos + 37] << 44;
        out[outPos + 30] = in[inPos + 38] - in[inPos + 37] >>> 20 | in[inPos + 39] - in[inPos + 38] << 30;
        out[outPos + 31] = in[inPos + 39] - in[inPos + 38] >>> 34 | in[inPos + 40] - in[inPos + 39] << 16;
        out[outPos + 32] = in[inPos + 40] - in[inPos + 39] >>> 48 | in[inPos + 41] - in[inPos + 40] << 2 | in[inPos + 42] - in[inPos + 41] << 52;
        out[outPos + 33] = in[inPos + 42] - in[inPos + 41] >>> 12 | in[inPos + 43] - in[inPos + 42] << 38;
        out[outPos + 34] = in[inPos + 43] - in[inPos + 42] >>> 26 | in[inPos + 44] - in[inPos + 43] << 24;
        out[outPos + 35] = in[inPos + 44] - in[inPos + 43] >>> 40 | in[inPos + 45] - in[inPos + 44] << 10 | in[inPos + 46] - in[inPos + 45] << 60;
        out[outPos + 36] = in[inPos + 46] - in[inPos + 45] >>> 4 | in[inPos + 47] - in[inPos + 46] << 46;
        out[outPos + 37] = in[inPos + 47] - in[inPos + 46] >>> 18 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 38] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 18;
        out[outPos + 39] = in[inPos + 49] - in[inPos + 48] >>> 46 | in[inPos + 50] - in[inPos + 49] << 4 | in[inPos + 51] - in[inPos + 50] << 54;
        out[outPos + 40] = in[inPos + 51] - in[inPos + 50] >>> 10 | in[inPos + 52] - in[inPos + 51] << 40;
        out[outPos + 41] = in[inPos + 52] - in[inPos + 51] >>> 24 | in[inPos + 53] - in[inPos + 52] << 26;
        out[outPos + 42] = in[inPos + 53] - in[inPos + 52] >>> 38 | in[inPos + 54] - in[inPos + 53] << 12 | in[inPos + 55] - in[inPos + 54] << 62;
        out[outPos + 43] = in[inPos + 55] - in[inPos + 54] >>> 2 | in[inPos + 56] - in[inPos + 55] << 48;
        out[outPos + 44] = in[inPos + 56] - in[inPos + 55] >>> 16 | in[inPos + 57] - in[inPos + 56] << 34;
        out[outPos + 45] = in[inPos + 57] - in[inPos + 56] >>> 30 | in[inPos + 58] - in[inPos + 57] << 20;
        out[outPos + 46] = in[inPos + 58] - in[inPos + 57] >>> 44 | in[inPos + 59] - in[inPos + 58] << 6 | in[inPos + 60] - in[inPos + 59] << 56;
        out[outPos + 47] = in[inPos + 60] - in[inPos + 59] >>> 8 | in[inPos + 61] - in[inPos + 60] << 42;
        out[outPos + 48] = in[inPos + 61] - in[inPos + 60] >>> 22 | in[inPos + 62] - in[inPos + 61] << 28;
        out[outPos + 49] = in[inPos + 62] - in[inPos + 61] >>> 36 | in[inPos + 63] - in[inPos + 62] << 14;
    }

    private static void unpack50(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 50 | (in[inPos + 1] & 0xFFFFFFFFFL) << 14) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 36 | (in[inPos + 2] & 0x3FFFFFL) << 28) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 22 | (in[inPos + 3] & 0xFFL) << 42) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 8 & 0x3FFFFFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 58 | (in[inPos + 4] & 0xFFFFFFFFFFFL) << 6) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 44 | (in[inPos + 5] & 0x3FFFFFFFL) << 20) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 30 | (in[inPos + 6] & 0xFFFFL) << 34) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 16 | (in[inPos + 7] & 3L) << 48) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 2 & 0x3FFFFFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 52 | (in[inPos + 8] & 0x3FFFFFFFFFL) << 12) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 38 | (in[inPos + 9] & 0xFFFFFFL) << 26) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] >>> 24 | (in[inPos + 10] & 0x3FFL) << 40) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 10 & 0x3FFFFFFFFFFFFL) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 10] >>> 60 | (in[inPos + 11] & 0x3FFFFFFFFFFFL) << 4) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 11] >>> 46 | (in[inPos + 12] & 0xFFFFFFFFL) << 18) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 12] >>> 32 | (in[inPos + 13] & 0x3FFFFL) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 13] >>> 18 | (in[inPos + 14] & 0xFL) << 46) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 14] >>> 4 & 0x3FFFFFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 14] >>> 54 | (in[inPos + 15] & 0xFFFFFFFFFFL) << 10) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 15] >>> 40 | (in[inPos + 16] & 0x3FFFFFFL) << 24) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 16] >>> 26 | (in[inPos + 17] & 0xFFFL) << 38) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 17] >>> 12 & 0x3FFFFFFFFFFFFL) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 17] >>> 62 | (in[inPos + 18] & 0xFFFFFFFFFFFFL) << 2) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0x3FFFFFFFFL) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 19] >>> 34 | (in[inPos + 20] & 0xFFFFFL) << 30) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 20] >>> 20 | (in[inPos + 21] & 0x3FL) << 44) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 21] >>> 6 & 0x3FFFFFFFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 21] >>> 56 | (in[inPos + 22] & 0x3FFFFFFFFFFL) << 8) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 22] >>> 42 | (in[inPos + 23] & 0xFFFFFFFL) << 22) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 23] >>> 28 | (in[inPos + 24] & 0x3FFFL) << 36) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 24] >>> 14) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 25] & 0x3FFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 25] >>> 50 | (in[inPos + 26] & 0xFFFFFFFFFL) << 14) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 26] >>> 36 | (in[inPos + 27] & 0x3FFFFFL) << 28) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 27] >>> 22 | (in[inPos + 28] & 0xFFL) << 42) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 28] >>> 8 & 0x3FFFFFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 28] >>> 58 | (in[inPos + 29] & 0xFFFFFFFFFFFL) << 6) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 29] >>> 44 | (in[inPos + 30] & 0x3FFFFFFFL) << 20) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 30] >>> 30 | (in[inPos + 31] & 0xFFFFL) << 34) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 31] >>> 16 | (in[inPos + 32] & 3L) << 48) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 32] >>> 2 & 0x3FFFFFFFFFFFFL) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 32] >>> 52 | (in[inPos + 33] & 0x3FFFFFFFFFL) << 12) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 33] >>> 38 | (in[inPos + 34] & 0xFFFFFFL) << 26) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 34] >>> 24 | (in[inPos + 35] & 0x3FFL) << 40) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 35] >>> 10 & 0x3FFFFFFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 35] >>> 60 | (in[inPos + 36] & 0x3FFFFFFFFFFFL) << 4) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 36] >>> 46 | (in[inPos + 37] & 0xFFFFFFFFL) << 18) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 37] >>> 32 | (in[inPos + 38] & 0x3FFFFL) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 38] >>> 18 | (in[inPos + 39] & 0xFL) << 46) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 39] >>> 4 & 0x3FFFFFFFFFFFFL) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 39] >>> 54 | (in[inPos + 40] & 0xFFFFFFFFFFL) << 10) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 40] >>> 40 | (in[inPos + 41] & 0x3FFFFFFL) << 24) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 41] >>> 26 | (in[inPos + 42] & 0xFFFL) << 38) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 42] >>> 12 & 0x3FFFFFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 42] >>> 62 | (in[inPos + 43] & 0xFFFFFFFFFFFFL) << 2) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 43] >>> 48 | (in[inPos + 44] & 0x3FFFFFFFFL) << 16) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 44] >>> 34 | (in[inPos + 45] & 0xFFFFFL) << 30) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 45] >>> 20 | (in[inPos + 46] & 0x3FL) << 44) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 46] >>> 6 & 0x3FFFFFFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 46] >>> 56 | (in[inPos + 47] & 0x3FFFFFFFFFFL) << 8) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 47] >>> 42 | (in[inPos + 48] & 0xFFFFFFFL) << 22) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 48] >>> 28 | (in[inPos + 49] & 0x3FFFL) << 36) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 49] >>> 14) + out[outPos + 62];
    }

    private static void pack51(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 51;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 13 | in[inPos + 2] - in[inPos + 1] << 38;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 26 | in[inPos + 3] - in[inPos + 2] << 25;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 39 | in[inPos + 4] - in[inPos + 3] << 12 | in[inPos + 5] - in[inPos + 4] << 63;
        out[outPos + 4] = in[inPos + 5] - in[inPos + 4] >>> 1 | in[inPos + 6] - in[inPos + 5] << 50;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 14 | in[inPos + 7] - in[inPos + 6] << 37;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 27 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 40 | in[inPos + 9] - in[inPos + 8] << 11 | in[inPos + 10] - in[inPos + 9] << 62;
        out[outPos + 8] = in[inPos + 10] - in[inPos + 9] >>> 2 | in[inPos + 11] - in[inPos + 10] << 49;
        out[outPos + 9] = in[inPos + 11] - in[inPos + 10] >>> 15 | in[inPos + 12] - in[inPos + 11] << 36;
        out[outPos + 10] = in[inPos + 12] - in[inPos + 11] >>> 28 | in[inPos + 13] - in[inPos + 12] << 23;
        out[outPos + 11] = in[inPos + 13] - in[inPos + 12] >>> 41 | in[inPos + 14] - in[inPos + 13] << 10 | in[inPos + 15] - in[inPos + 14] << 61;
        out[outPos + 12] = in[inPos + 15] - in[inPos + 14] >>> 3 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 13] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 35;
        out[outPos + 14] = in[inPos + 17] - in[inPos + 16] >>> 29 | in[inPos + 18] - in[inPos + 17] << 22;
        out[outPos + 15] = in[inPos + 18] - in[inPos + 17] >>> 42 | in[inPos + 19] - in[inPos + 18] << 9 | in[inPos + 20] - in[inPos + 19] << 60;
        out[outPos + 16] = in[inPos + 20] - in[inPos + 19] >>> 4 | in[inPos + 21] - in[inPos + 20] << 47;
        out[outPos + 17] = in[inPos + 21] - in[inPos + 20] >>> 17 | in[inPos + 22] - in[inPos + 21] << 34;
        out[outPos + 18] = in[inPos + 22] - in[inPos + 21] >>> 30 | in[inPos + 23] - in[inPos + 22] << 21;
        out[outPos + 19] = in[inPos + 23] - in[inPos + 22] >>> 43 | in[inPos + 24] - in[inPos + 23] << 8 | in[inPos + 25] - in[inPos + 24] << 59;
        out[outPos + 20] = in[inPos + 25] - in[inPos + 24] >>> 5 | in[inPos + 26] - in[inPos + 25] << 46;
        out[outPos + 21] = in[inPos + 26] - in[inPos + 25] >>> 18 | in[inPos + 27] - in[inPos + 26] << 33;
        out[outPos + 22] = in[inPos + 27] - in[inPos + 26] >>> 31 | in[inPos + 28] - in[inPos + 27] << 20;
        out[outPos + 23] = in[inPos + 28] - in[inPos + 27] >>> 44 | in[inPos + 29] - in[inPos + 28] << 7 | in[inPos + 30] - in[inPos + 29] << 58;
        out[outPos + 24] = in[inPos + 30] - in[inPos + 29] >>> 6 | in[inPos + 31] - in[inPos + 30] << 45;
        out[outPos + 25] = in[inPos + 31] - in[inPos + 30] >>> 19 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 26] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 19;
        out[outPos + 27] = in[inPos + 33] - in[inPos + 32] >>> 45 | in[inPos + 34] - in[inPos + 33] << 6 | in[inPos + 35] - in[inPos + 34] << 57;
        out[outPos + 28] = in[inPos + 35] - in[inPos + 34] >>> 7 | in[inPos + 36] - in[inPos + 35] << 44;
        out[outPos + 29] = in[inPos + 36] - in[inPos + 35] >>> 20 | in[inPos + 37] - in[inPos + 36] << 31;
        out[outPos + 30] = in[inPos + 37] - in[inPos + 36] >>> 33 | in[inPos + 38] - in[inPos + 37] << 18;
        out[outPos + 31] = in[inPos + 38] - in[inPos + 37] >>> 46 | in[inPos + 39] - in[inPos + 38] << 5 | in[inPos + 40] - in[inPos + 39] << 56;
        out[outPos + 32] = in[inPos + 40] - in[inPos + 39] >>> 8 | in[inPos + 41] - in[inPos + 40] << 43;
        out[outPos + 33] = in[inPos + 41] - in[inPos + 40] >>> 21 | in[inPos + 42] - in[inPos + 41] << 30;
        out[outPos + 34] = in[inPos + 42] - in[inPos + 41] >>> 34 | in[inPos + 43] - in[inPos + 42] << 17;
        out[outPos + 35] = in[inPos + 43] - in[inPos + 42] >>> 47 | in[inPos + 44] - in[inPos + 43] << 4 | in[inPos + 45] - in[inPos + 44] << 55;
        out[outPos + 36] = in[inPos + 45] - in[inPos + 44] >>> 9 | in[inPos + 46] - in[inPos + 45] << 42;
        out[outPos + 37] = in[inPos + 46] - in[inPos + 45] >>> 22 | in[inPos + 47] - in[inPos + 46] << 29;
        out[outPos + 38] = in[inPos + 47] - in[inPos + 46] >>> 35 | in[inPos + 48] - in[inPos + 47] << 16;
        out[outPos + 39] = in[inPos + 48] - in[inPos + 47] >>> 48 | in[inPos + 49] - in[inPos + 48] << 3 | in[inPos + 50] - in[inPos + 49] << 54;
        out[outPos + 40] = in[inPos + 50] - in[inPos + 49] >>> 10 | in[inPos + 51] - in[inPos + 50] << 41;
        out[outPos + 41] = in[inPos + 51] - in[inPos + 50] >>> 23 | in[inPos + 52] - in[inPos + 51] << 28;
        out[outPos + 42] = in[inPos + 52] - in[inPos + 51] >>> 36 | in[inPos + 53] - in[inPos + 52] << 15;
        out[outPos + 43] = in[inPos + 53] - in[inPos + 52] >>> 49 | in[inPos + 54] - in[inPos + 53] << 2 | in[inPos + 55] - in[inPos + 54] << 53;
        out[outPos + 44] = in[inPos + 55] - in[inPos + 54] >>> 11 | in[inPos + 56] - in[inPos + 55] << 40;
        out[outPos + 45] = in[inPos + 56] - in[inPos + 55] >>> 24 | in[inPos + 57] - in[inPos + 56] << 27;
        out[outPos + 46] = in[inPos + 57] - in[inPos + 56] >>> 37 | in[inPos + 58] - in[inPos + 57] << 14;
        out[outPos + 47] = in[inPos + 58] - in[inPos + 57] >>> 50 | in[inPos + 59] - in[inPos + 58] << 1 | in[inPos + 60] - in[inPos + 59] << 52;
        out[outPos + 48] = in[inPos + 60] - in[inPos + 59] >>> 12 | in[inPos + 61] - in[inPos + 60] << 39;
        out[outPos + 49] = in[inPos + 61] - in[inPos + 60] >>> 25 | in[inPos + 62] - in[inPos + 61] << 26;
        out[outPos + 50] = in[inPos + 62] - in[inPos + 61] >>> 38 | in[inPos + 63] - in[inPos + 62] << 13;
    }

    private static void unpack51(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 51 | (in[inPos + 1] & 0x3FFFFFFFFFL) << 13) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 38 | (in[inPos + 2] & 0x1FFFFFFL) << 26) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 25 | (in[inPos + 3] & 0xFFFL) << 39) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 12 & 0x7FFFFFFFFFFFFL) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 3] >>> 63 | (in[inPos + 4] & 0x3FFFFFFFFFFFFL) << 1) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 50 | (in[inPos + 5] & 0x1FFFFFFFFFL) << 14) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 37 | (in[inPos + 6] & 0xFFFFFFL) << 27) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 24 | (in[inPos + 7] & 0x7FFL) << 40) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 11 & 0x7FFFFFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 7] >>> 62 | (in[inPos + 8] & 0x1FFFFFFFFFFFFL) << 2) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 49 | (in[inPos + 9] & 0xFFFFFFFFFL) << 15) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] >>> 36 | (in[inPos + 10] & 0x7FFFFFL) << 28) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 23 | (in[inPos + 11] & 0x3FFL) << 41) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 11] >>> 10 & 0x7FFFFFFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 11] >>> 61 | (in[inPos + 12] & 0xFFFFFFFFFFFFL) << 3) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 12] >>> 48 | (in[inPos + 13] & 0x7FFFFFFFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 13] >>> 35 | (in[inPos + 14] & 0x3FFFFFL) << 29) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 14] >>> 22 | (in[inPos + 15] & 0x1FFL) << 42) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 15] >>> 9 & 0x7FFFFFFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 15] >>> 60 | (in[inPos + 16] & 0x7FFFFFFFFFFFL) << 4) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 16] >>> 47 | (in[inPos + 17] & 0x3FFFFFFFFL) << 17) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 17] >>> 34 | (in[inPos + 18] & 0x1FFFFFL) << 30) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 18] >>> 21 | (in[inPos + 19] & 0xFFL) << 43) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 19] >>> 8 & 0x7FFFFFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 19] >>> 59 | (in[inPos + 20] & 0x3FFFFFFFFFFFL) << 5) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 20] >>> 46 | (in[inPos + 21] & 0x1FFFFFFFFL) << 18) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 21] >>> 33 | (in[inPos + 22] & 0xFFFFFL) << 31) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 22] >>> 20 | (in[inPos + 23] & 0x7FL) << 44) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 23] >>> 7 & 0x7FFFFFFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 23] >>> 58 | (in[inPos + 24] & 0x1FFFFFFFFFFFL) << 6) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 24] >>> 45 | (in[inPos + 25] & 0xFFFFFFFFL) << 19) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 25] >>> 32 | (in[inPos + 26] & 0x7FFFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 26] >>> 19 | (in[inPos + 27] & 0x3FL) << 45) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 27] >>> 6 & 0x7FFFFFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 27] >>> 57 | (in[inPos + 28] & 0xFFFFFFFFFFFL) << 7) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 28] >>> 44 | (in[inPos + 29] & Integer.MAX_VALUE) << 20) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 29] >>> 31 | (in[inPos + 30] & 0x3FFFFL) << 33) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 30] >>> 18 | (in[inPos + 31] & 0x1FL) << 46) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 31] >>> 5 & 0x7FFFFFFFFFFFFL) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 31] >>> 56 | (in[inPos + 32] & 0x7FFFFFFFFFFL) << 8) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 32] >>> 43 | (in[inPos + 33] & 0x3FFFFFFFL) << 21) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 33] >>> 30 | (in[inPos + 34] & 0x1FFFFL) << 34) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 34] >>> 17 | (in[inPos + 35] & 0xFL) << 47) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 35] >>> 4 & 0x7FFFFFFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 35] >>> 55 | (in[inPos + 36] & 0x3FFFFFFFFFFL) << 9) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 36] >>> 42 | (in[inPos + 37] & 0x1FFFFFFFL) << 22) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 37] >>> 29 | (in[inPos + 38] & 0xFFFFL) << 35) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 38] >>> 16 | (in[inPos + 39] & 7L) << 48) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 39] >>> 3 & 0x7FFFFFFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 39] >>> 54 | (in[inPos + 40] & 0x1FFFFFFFFFFL) << 10) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 40] >>> 41 | (in[inPos + 41] & 0xFFFFFFFL) << 23) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 41] >>> 28 | (in[inPos + 42] & 0x7FFFL) << 36) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 42] >>> 15 | (in[inPos + 43] & 3L) << 49) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 43] >>> 2 & 0x7FFFFFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 43] >>> 53 | (in[inPos + 44] & 0xFFFFFFFFFFL) << 11) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 44] >>> 40 | (in[inPos + 45] & 0x7FFFFFFL) << 24) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 45] >>> 27 | (in[inPos + 46] & 0x3FFFL) << 37) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 46] >>> 14 | (in[inPos + 47] & 1L) << 50) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 47] >>> 1 & 0x7FFFFFFFFFFFFL) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 47] >>> 52 | (in[inPos + 48] & 0x7FFFFFFFFFL) << 12) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 48] >>> 39 | (in[inPos + 49] & 0x3FFFFFFL) << 25) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 49] >>> 26 | (in[inPos + 50] & 0x1FFFL) << 38) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 50] >>> 13) + out[outPos + 62];
    }

    private static void pack52(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 52;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 12 | in[inPos + 2] - in[inPos + 1] << 40;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 24 | in[inPos + 3] - in[inPos + 2] << 28;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 36 | in[inPos + 4] - in[inPos + 3] << 16;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 48 | in[inPos + 5] - in[inPos + 4] << 4 | in[inPos + 6] - in[inPos + 5] << 56;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 8 | in[inPos + 7] - in[inPos + 6] << 44;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 20 | in[inPos + 8] - in[inPos + 7] << 32;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 32 | in[inPos + 9] - in[inPos + 8] << 20;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 44 | in[inPos + 10] - in[inPos + 9] << 8 | in[inPos + 11] - in[inPos + 10] << 60;
        out[outPos + 9] = in[inPos + 11] - in[inPos + 10] >>> 4 | in[inPos + 12] - in[inPos + 11] << 48;
        out[outPos + 10] = in[inPos + 12] - in[inPos + 11] >>> 16 | in[inPos + 13] - in[inPos + 12] << 36;
        out[outPos + 11] = in[inPos + 13] - in[inPos + 12] >>> 28 | in[inPos + 14] - in[inPos + 13] << 24;
        out[outPos + 12] = in[inPos + 14] - in[inPos + 13] >>> 40 | in[inPos + 15] - in[inPos + 14] << 12;
        out[outPos + 13] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 52;
        out[outPos + 14] = in[inPos + 17] - in[inPos + 16] >>> 12 | in[inPos + 18] - in[inPos + 17] << 40;
        out[outPos + 15] = in[inPos + 18] - in[inPos + 17] >>> 24 | in[inPos + 19] - in[inPos + 18] << 28;
        out[outPos + 16] = in[inPos + 19] - in[inPos + 18] >>> 36 | in[inPos + 20] - in[inPos + 19] << 16;
        out[outPos + 17] = in[inPos + 20] - in[inPos + 19] >>> 48 | in[inPos + 21] - in[inPos + 20] << 4 | in[inPos + 22] - in[inPos + 21] << 56;
        out[outPos + 18] = in[inPos + 22] - in[inPos + 21] >>> 8 | in[inPos + 23] - in[inPos + 22] << 44;
        out[outPos + 19] = in[inPos + 23] - in[inPos + 22] >>> 20 | in[inPos + 24] - in[inPos + 23] << 32;
        out[outPos + 20] = in[inPos + 24] - in[inPos + 23] >>> 32 | in[inPos + 25] - in[inPos + 24] << 20;
        out[outPos + 21] = in[inPos + 25] - in[inPos + 24] >>> 44 | in[inPos + 26] - in[inPos + 25] << 8 | in[inPos + 27] - in[inPos + 26] << 60;
        out[outPos + 22] = in[inPos + 27] - in[inPos + 26] >>> 4 | in[inPos + 28] - in[inPos + 27] << 48;
        out[outPos + 23] = in[inPos + 28] - in[inPos + 27] >>> 16 | in[inPos + 29] - in[inPos + 28] << 36;
        out[outPos + 24] = in[inPos + 29] - in[inPos + 28] >>> 28 | in[inPos + 30] - in[inPos + 29] << 24;
        out[outPos + 25] = in[inPos + 30] - in[inPos + 29] >>> 40 | in[inPos + 31] - in[inPos + 30] << 12;
        out[outPos + 26] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 52;
        out[outPos + 27] = in[inPos + 33] - in[inPos + 32] >>> 12 | in[inPos + 34] - in[inPos + 33] << 40;
        out[outPos + 28] = in[inPos + 34] - in[inPos + 33] >>> 24 | in[inPos + 35] - in[inPos + 34] << 28;
        out[outPos + 29] = in[inPos + 35] - in[inPos + 34] >>> 36 | in[inPos + 36] - in[inPos + 35] << 16;
        out[outPos + 30] = in[inPos + 36] - in[inPos + 35] >>> 48 | in[inPos + 37] - in[inPos + 36] << 4 | in[inPos + 38] - in[inPos + 37] << 56;
        out[outPos + 31] = in[inPos + 38] - in[inPos + 37] >>> 8 | in[inPos + 39] - in[inPos + 38] << 44;
        out[outPos + 32] = in[inPos + 39] - in[inPos + 38] >>> 20 | in[inPos + 40] - in[inPos + 39] << 32;
        out[outPos + 33] = in[inPos + 40] - in[inPos + 39] >>> 32 | in[inPos + 41] - in[inPos + 40] << 20;
        out[outPos + 34] = in[inPos + 41] - in[inPos + 40] >>> 44 | in[inPos + 42] - in[inPos + 41] << 8 | in[inPos + 43] - in[inPos + 42] << 60;
        out[outPos + 35] = in[inPos + 43] - in[inPos + 42] >>> 4 | in[inPos + 44] - in[inPos + 43] << 48;
        out[outPos + 36] = in[inPos + 44] - in[inPos + 43] >>> 16 | in[inPos + 45] - in[inPos + 44] << 36;
        out[outPos + 37] = in[inPos + 45] - in[inPos + 44] >>> 28 | in[inPos + 46] - in[inPos + 45] << 24;
        out[outPos + 38] = in[inPos + 46] - in[inPos + 45] >>> 40 | in[inPos + 47] - in[inPos + 46] << 12;
        out[outPos + 39] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 52;
        out[outPos + 40] = in[inPos + 49] - in[inPos + 48] >>> 12 | in[inPos + 50] - in[inPos + 49] << 40;
        out[outPos + 41] = in[inPos + 50] - in[inPos + 49] >>> 24 | in[inPos + 51] - in[inPos + 50] << 28;
        out[outPos + 42] = in[inPos + 51] - in[inPos + 50] >>> 36 | in[inPos + 52] - in[inPos + 51] << 16;
        out[outPos + 43] = in[inPos + 52] - in[inPos + 51] >>> 48 | in[inPos + 53] - in[inPos + 52] << 4 | in[inPos + 54] - in[inPos + 53] << 56;
        out[outPos + 44] = in[inPos + 54] - in[inPos + 53] >>> 8 | in[inPos + 55] - in[inPos + 54] << 44;
        out[outPos + 45] = in[inPos + 55] - in[inPos + 54] >>> 20 | in[inPos + 56] - in[inPos + 55] << 32;
        out[outPos + 46] = in[inPos + 56] - in[inPos + 55] >>> 32 | in[inPos + 57] - in[inPos + 56] << 20;
        out[outPos + 47] = in[inPos + 57] - in[inPos + 56] >>> 44 | in[inPos + 58] - in[inPos + 57] << 8 | in[inPos + 59] - in[inPos + 58] << 60;
        out[outPos + 48] = in[inPos + 59] - in[inPos + 58] >>> 4 | in[inPos + 60] - in[inPos + 59] << 48;
        out[outPos + 49] = in[inPos + 60] - in[inPos + 59] >>> 16 | in[inPos + 61] - in[inPos + 60] << 36;
        out[outPos + 50] = in[inPos + 61] - in[inPos + 60] >>> 28 | in[inPos + 62] - in[inPos + 61] << 24;
        out[outPos + 51] = in[inPos + 62] - in[inPos + 61] >>> 40 | in[inPos + 63] - in[inPos + 62] << 12;
    }

    private static void unpack52(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 52 | (in[inPos + 1] & 0xFFFFFFFFFFL) << 12) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 40 | (in[inPos + 2] & 0xFFFFFFFL) << 24) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 28 | (in[inPos + 3] & 0xFFFFL) << 36) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 16 | (in[inPos + 4] & 0xFL) << 48) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 4 & 0xFFFFFFFFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 56 | (in[inPos + 5] & 0xFFFFFFFFFFFL) << 8) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 44 | (in[inPos + 6] & 0xFFFFFFFFL) << 20) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 32 | (in[inPos + 7] & 0xFFFFFL) << 32) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 20 | (in[inPos + 8] & 0xFFL) << 44) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 8 & 0xFFFFFFFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 8] >>> 60 | (in[inPos + 9] & 0xFFFFFFFFFFFFL) << 4) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] >>> 48 | (in[inPos + 10] & 0xFFFFFFFFFL) << 16) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 36 | (in[inPos + 11] & 0xFFFFFFL) << 28) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 11] >>> 24 | (in[inPos + 12] & 0xFFFL) << 40) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 12] >>> 12) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 13] & 0xFFFFFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 13] >>> 52 | (in[inPos + 14] & 0xFFFFFFFFFFL) << 12) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 14] >>> 40 | (in[inPos + 15] & 0xFFFFFFFL) << 24) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 15] >>> 28 | (in[inPos + 16] & 0xFFFFL) << 36) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 16] >>> 16 | (in[inPos + 17] & 0xFL) << 48) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 17] >>> 4 & 0xFFFFFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 17] >>> 56 | (in[inPos + 18] & 0xFFFFFFFFFFFL) << 8) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 18] >>> 44 | (in[inPos + 19] & 0xFFFFFFFFL) << 20) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 19] >>> 32 | (in[inPos + 20] & 0xFFFFFL) << 32) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 20] >>> 20 | (in[inPos + 21] & 0xFFL) << 44) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 21] >>> 8 & 0xFFFFFFFFFFFFFL) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 21] >>> 60 | (in[inPos + 22] & 0xFFFFFFFFFFFFL) << 4) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 22] >>> 48 | (in[inPos + 23] & 0xFFFFFFFFFL) << 16) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 23] >>> 36 | (in[inPos + 24] & 0xFFFFFFL) << 28) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 24] >>> 24 | (in[inPos + 25] & 0xFFFL) << 40) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 25] >>> 12) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 26] & 0xFFFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 26] >>> 52 | (in[inPos + 27] & 0xFFFFFFFFFFL) << 12) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 27] >>> 40 | (in[inPos + 28] & 0xFFFFFFFL) << 24) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 28] >>> 28 | (in[inPos + 29] & 0xFFFFL) << 36) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 29] >>> 16 | (in[inPos + 30] & 0xFL) << 48) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 30] >>> 4 & 0xFFFFFFFFFFFFFL) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 30] >>> 56 | (in[inPos + 31] & 0xFFFFFFFFFFFL) << 8) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 31] >>> 44 | (in[inPos + 32] & 0xFFFFFFFFL) << 20) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 32] >>> 32 | (in[inPos + 33] & 0xFFFFFL) << 32) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 33] >>> 20 | (in[inPos + 34] & 0xFFL) << 44) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 34] >>> 8 & 0xFFFFFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 34] >>> 60 | (in[inPos + 35] & 0xFFFFFFFFFFFFL) << 4) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 35] >>> 48 | (in[inPos + 36] & 0xFFFFFFFFFL) << 16) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 36] >>> 36 | (in[inPos + 37] & 0xFFFFFFL) << 28) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 37] >>> 24 | (in[inPos + 38] & 0xFFFL) << 40) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 38] >>> 12) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 39] & 0xFFFFFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 39] >>> 52 | (in[inPos + 40] & 0xFFFFFFFFFFL) << 12) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 40] >>> 40 | (in[inPos + 41] & 0xFFFFFFFL) << 24) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 41] >>> 28 | (in[inPos + 42] & 0xFFFFL) << 36) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 42] >>> 16 | (in[inPos + 43] & 0xFL) << 48) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 43] >>> 4 & 0xFFFFFFFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 43] >>> 56 | (in[inPos + 44] & 0xFFFFFFFFFFFL) << 8) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 44] >>> 44 | (in[inPos + 45] & 0xFFFFFFFFL) << 20) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 45] >>> 32 | (in[inPos + 46] & 0xFFFFFL) << 32) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 46] >>> 20 | (in[inPos + 47] & 0xFFL) << 44) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 47] >>> 8 & 0xFFFFFFFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 47] >>> 60 | (in[inPos + 48] & 0xFFFFFFFFFFFFL) << 4) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 48] >>> 48 | (in[inPos + 49] & 0xFFFFFFFFFL) << 16) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 49] >>> 36 | (in[inPos + 50] & 0xFFFFFFL) << 28) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 50] >>> 24 | (in[inPos + 51] & 0xFFFL) << 40) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 51] >>> 12) + out[outPos + 62];
    }

    private static void pack53(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 53;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 11 | in[inPos + 2] - in[inPos + 1] << 42;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 22 | in[inPos + 3] - in[inPos + 2] << 31;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 33 | in[inPos + 4] - in[inPos + 3] << 20;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 44 | in[inPos + 5] - in[inPos + 4] << 9 | in[inPos + 6] - in[inPos + 5] << 62;
        out[outPos + 5] = in[inPos + 6] - in[inPos + 5] >>> 2 | in[inPos + 7] - in[inPos + 6] << 51;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 13 | in[inPos + 8] - in[inPos + 7] << 40;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 24 | in[inPos + 9] - in[inPos + 8] << 29;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 35 | in[inPos + 10] - in[inPos + 9] << 18;
        out[outPos + 9] = in[inPos + 10] - in[inPos + 9] >>> 46 | in[inPos + 11] - in[inPos + 10] << 7 | in[inPos + 12] - in[inPos + 11] << 60;
        out[outPos + 10] = in[inPos + 12] - in[inPos + 11] >>> 4 | in[inPos + 13] - in[inPos + 12] << 49;
        out[outPos + 11] = in[inPos + 13] - in[inPos + 12] >>> 15 | in[inPos + 14] - in[inPos + 13] << 38;
        out[outPos + 12] = in[inPos + 14] - in[inPos + 13] >>> 26 | in[inPos + 15] - in[inPos + 14] << 27;
        out[outPos + 13] = in[inPos + 15] - in[inPos + 14] >>> 37 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 14] = in[inPos + 16] - in[inPos + 15] >>> 48 | in[inPos + 17] - in[inPos + 16] << 5 | in[inPos + 18] - in[inPos + 17] << 58;
        out[outPos + 15] = in[inPos + 18] - in[inPos + 17] >>> 6 | in[inPos + 19] - in[inPos + 18] << 47;
        out[outPos + 16] = in[inPos + 19] - in[inPos + 18] >>> 17 | in[inPos + 20] - in[inPos + 19] << 36;
        out[outPos + 17] = in[inPos + 20] - in[inPos + 19] >>> 28 | in[inPos + 21] - in[inPos + 20] << 25;
        out[outPos + 18] = in[inPos + 21] - in[inPos + 20] >>> 39 | in[inPos + 22] - in[inPos + 21] << 14;
        out[outPos + 19] = in[inPos + 22] - in[inPos + 21] >>> 50 | in[inPos + 23] - in[inPos + 22] << 3 | in[inPos + 24] - in[inPos + 23] << 56;
        out[outPos + 20] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 45;
        out[outPos + 21] = in[inPos + 25] - in[inPos + 24] >>> 19 | in[inPos + 26] - in[inPos + 25] << 34;
        out[outPos + 22] = in[inPos + 26] - in[inPos + 25] >>> 30 | in[inPos + 27] - in[inPos + 26] << 23;
        out[outPos + 23] = in[inPos + 27] - in[inPos + 26] >>> 41 | in[inPos + 28] - in[inPos + 27] << 12;
        out[outPos + 24] = in[inPos + 28] - in[inPos + 27] >>> 52 | in[inPos + 29] - in[inPos + 28] << 1 | in[inPos + 30] - in[inPos + 29] << 54;
        out[outPos + 25] = in[inPos + 30] - in[inPos + 29] >>> 10 | in[inPos + 31] - in[inPos + 30] << 43;
        out[outPos + 26] = in[inPos + 31] - in[inPos + 30] >>> 21 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 27] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 21;
        out[outPos + 28] = in[inPos + 33] - in[inPos + 32] >>> 43 | in[inPos + 34] - in[inPos + 33] << 10 | in[inPos + 35] - in[inPos + 34] << 63;
        out[outPos + 29] = in[inPos + 35] - in[inPos + 34] >>> 1 | in[inPos + 36] - in[inPos + 35] << 52;
        out[outPos + 30] = in[inPos + 36] - in[inPos + 35] >>> 12 | in[inPos + 37] - in[inPos + 36] << 41;
        out[outPos + 31] = in[inPos + 37] - in[inPos + 36] >>> 23 | in[inPos + 38] - in[inPos + 37] << 30;
        out[outPos + 32] = in[inPos + 38] - in[inPos + 37] >>> 34 | in[inPos + 39] - in[inPos + 38] << 19;
        out[outPos + 33] = in[inPos + 39] - in[inPos + 38] >>> 45 | in[inPos + 40] - in[inPos + 39] << 8 | in[inPos + 41] - in[inPos + 40] << 61;
        out[outPos + 34] = in[inPos + 41] - in[inPos + 40] >>> 3 | in[inPos + 42] - in[inPos + 41] << 50;
        out[outPos + 35] = in[inPos + 42] - in[inPos + 41] >>> 14 | in[inPos + 43] - in[inPos + 42] << 39;
        out[outPos + 36] = in[inPos + 43] - in[inPos + 42] >>> 25 | in[inPos + 44] - in[inPos + 43] << 28;
        out[outPos + 37] = in[inPos + 44] - in[inPos + 43] >>> 36 | in[inPos + 45] - in[inPos + 44] << 17;
        out[outPos + 38] = in[inPos + 45] - in[inPos + 44] >>> 47 | in[inPos + 46] - in[inPos + 45] << 6 | in[inPos + 47] - in[inPos + 46] << 59;
        out[outPos + 39] = in[inPos + 47] - in[inPos + 46] >>> 5 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 40] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 37;
        out[outPos + 41] = in[inPos + 49] - in[inPos + 48] >>> 27 | in[inPos + 50] - in[inPos + 49] << 26;
        out[outPos + 42] = in[inPos + 50] - in[inPos + 49] >>> 38 | in[inPos + 51] - in[inPos + 50] << 15;
        out[outPos + 43] = in[inPos + 51] - in[inPos + 50] >>> 49 | in[inPos + 52] - in[inPos + 51] << 4 | in[inPos + 53] - in[inPos + 52] << 57;
        out[outPos + 44] = in[inPos + 53] - in[inPos + 52] >>> 7 | in[inPos + 54] - in[inPos + 53] << 46;
        out[outPos + 45] = in[inPos + 54] - in[inPos + 53] >>> 18 | in[inPos + 55] - in[inPos + 54] << 35;
        out[outPos + 46] = in[inPos + 55] - in[inPos + 54] >>> 29 | in[inPos + 56] - in[inPos + 55] << 24;
        out[outPos + 47] = in[inPos + 56] - in[inPos + 55] >>> 40 | in[inPos + 57] - in[inPos + 56] << 13;
        out[outPos + 48] = in[inPos + 57] - in[inPos + 56] >>> 51 | in[inPos + 58] - in[inPos + 57] << 2 | in[inPos + 59] - in[inPos + 58] << 55;
        out[outPos + 49] = in[inPos + 59] - in[inPos + 58] >>> 9 | in[inPos + 60] - in[inPos + 59] << 44;
        out[outPos + 50] = in[inPos + 60] - in[inPos + 59] >>> 20 | in[inPos + 61] - in[inPos + 60] << 33;
        out[outPos + 51] = in[inPos + 61] - in[inPos + 60] >>> 31 | in[inPos + 62] - in[inPos + 61] << 22;
        out[outPos + 52] = in[inPos + 62] - in[inPos + 61] >>> 42 | in[inPos + 63] - in[inPos + 62] << 11;
    }

    private static void unpack53(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 53 | (in[inPos + 1] & 0x3FFFFFFFFFFL) << 11) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 42 | (in[inPos + 2] & Integer.MAX_VALUE) << 22) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 31 | (in[inPos + 3] & 0xFFFFFL) << 33) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 20 | (in[inPos + 4] & 0x1FFL) << 44) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 9 & 0x1FFFFFFFFFFFFFL) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 4] >>> 62 | (in[inPos + 5] & 0x7FFFFFFFFFFFFL) << 2) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 51 | (in[inPos + 6] & 0xFFFFFFFFFFL) << 13) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 40 | (in[inPos + 7] & 0x1FFFFFFFL) << 24) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 29 | (in[inPos + 8] & 0x3FFFFL) << 35) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 18 | (in[inPos + 9] & 0x7FL) << 46) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 7 & 0x1FFFFFFFFFFFFFL) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 9] >>> 60 | (in[inPos + 10] & 0x1FFFFFFFFFFFFL) << 4) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 49 | (in[inPos + 11] & 0x3FFFFFFFFFL) << 15) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 11] >>> 38 | (in[inPos + 12] & 0x7FFFFFFL) << 26) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 12] >>> 27 | (in[inPos + 13] & 0xFFFFL) << 37) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 13] >>> 16 | (in[inPos + 14] & 0x1FL) << 48) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 14] >>> 5 & 0x1FFFFFFFFFFFFFL) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 14] >>> 58 | (in[inPos + 15] & 0x7FFFFFFFFFFFL) << 6) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 15] >>> 47 | (in[inPos + 16] & 0xFFFFFFFFFL) << 17) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 16] >>> 36 | (in[inPos + 17] & 0x1FFFFFFL) << 28) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 17] >>> 25 | (in[inPos + 18] & 0x3FFFL) << 39) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 18] >>> 14 | (in[inPos + 19] & 7L) << 50) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 19] >>> 3 & 0x1FFFFFFFFFFFFFL) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 19] >>> 56 | (in[inPos + 20] & 0x1FFFFFFFFFFFL) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 20] >>> 45 | (in[inPos + 21] & 0x3FFFFFFFFL) << 19) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 21] >>> 34 | (in[inPos + 22] & 0x7FFFFFL) << 30) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 22] >>> 23 | (in[inPos + 23] & 0xFFFL) << 41) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 23] >>> 12 | (in[inPos + 24] & 1L) << 52) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 24] >>> 1 & 0x1FFFFFFFFFFFFFL) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 24] >>> 54 | (in[inPos + 25] & 0x7FFFFFFFFFFL) << 10) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 25] >>> 43 | (in[inPos + 26] & 0xFFFFFFFFL) << 21) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 26] >>> 32 | (in[inPos + 27] & 0x1FFFFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 27] >>> 21 | (in[inPos + 28] & 0x3FFL) << 43) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 28] >>> 10 & 0x1FFFFFFFFFFFFFL) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 28] >>> 63 | (in[inPos + 29] & 0xFFFFFFFFFFFFFL) << 1) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 29] >>> 52 | (in[inPos + 30] & 0x1FFFFFFFFFFL) << 12) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 30] >>> 41 | (in[inPos + 31] & 0x3FFFFFFFL) << 23) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 31] >>> 30 | (in[inPos + 32] & 0x7FFFFL) << 34) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 32] >>> 19 | (in[inPos + 33] & 0xFFL) << 45) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 33] >>> 8 & 0x1FFFFFFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 33] >>> 61 | (in[inPos + 34] & 0x3FFFFFFFFFFFFL) << 3) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 34] >>> 50 | (in[inPos + 35] & 0x7FFFFFFFFFL) << 14) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 35] >>> 39 | (in[inPos + 36] & 0xFFFFFFFL) << 25) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 36] >>> 28 | (in[inPos + 37] & 0x1FFFFL) << 36) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 37] >>> 17 | (in[inPos + 38] & 0x3FL) << 47) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 38] >>> 6 & 0x1FFFFFFFFFFFFFL) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 38] >>> 59 | (in[inPos + 39] & 0xFFFFFFFFFFFFL) << 5) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 39] >>> 48 | (in[inPos + 40] & 0x1FFFFFFFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 40] >>> 37 | (in[inPos + 41] & 0x3FFFFFFL) << 27) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 41] >>> 26 | (in[inPos + 42] & 0x7FFFL) << 38) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 42] >>> 15 | (in[inPos + 43] & 0xFL) << 49) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 43] >>> 4 & 0x1FFFFFFFFFFFFFL) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 43] >>> 57 | (in[inPos + 44] & 0x3FFFFFFFFFFFL) << 7) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 44] >>> 46 | (in[inPos + 45] & 0x7FFFFFFFFL) << 18) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 45] >>> 35 | (in[inPos + 46] & 0xFFFFFFL) << 29) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 46] >>> 24 | (in[inPos + 47] & 0x1FFFL) << 40) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 47] >>> 13 | (in[inPos + 48] & 3L) << 51) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 48] >>> 2 & 0x1FFFFFFFFFFFFFL) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 48] >>> 55 | (in[inPos + 49] & 0xFFFFFFFFFFFL) << 9) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 49] >>> 44 | (in[inPos + 50] & 0x1FFFFFFFFL) << 20) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 50] >>> 33 | (in[inPos + 51] & 0x3FFFFFL) << 31) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 51] >>> 22 | (in[inPos + 52] & 0x7FFL) << 42) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 52] >>> 11) + out[outPos + 62];
    }

    private static void pack54(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 54;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 10 | in[inPos + 2] - in[inPos + 1] << 44;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 20 | in[inPos + 3] - in[inPos + 2] << 34;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 30 | in[inPos + 4] - in[inPos + 3] << 24;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 40 | in[inPos + 5] - in[inPos + 4] << 14;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 50 | in[inPos + 6] - in[inPos + 5] << 4 | in[inPos + 7] - in[inPos + 6] << 58;
        out[outPos + 6] = in[inPos + 7] - in[inPos + 6] >>> 6 | in[inPos + 8] - in[inPos + 7] << 48;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 38;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 26 | in[inPos + 10] - in[inPos + 9] << 28;
        out[outPos + 9] = in[inPos + 10] - in[inPos + 9] >>> 36 | in[inPos + 11] - in[inPos + 10] << 18;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 46 | in[inPos + 12] - in[inPos + 11] << 8 | in[inPos + 13] - in[inPos + 12] << 62;
        out[outPos + 11] = in[inPos + 13] - in[inPos + 12] >>> 2 | in[inPos + 14] - in[inPos + 13] << 52;
        out[outPos + 12] = in[inPos + 14] - in[inPos + 13] >>> 12 | in[inPos + 15] - in[inPos + 14] << 42;
        out[outPos + 13] = in[inPos + 15] - in[inPos + 14] >>> 22 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 14] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 22;
        out[outPos + 15] = in[inPos + 17] - in[inPos + 16] >>> 42 | in[inPos + 18] - in[inPos + 17] << 12;
        out[outPos + 16] = in[inPos + 18] - in[inPos + 17] >>> 52 | in[inPos + 19] - in[inPos + 18] << 2 | in[inPos + 20] - in[inPos + 19] << 56;
        out[outPos + 17] = in[inPos + 20] - in[inPos + 19] >>> 8 | in[inPos + 21] - in[inPos + 20] << 46;
        out[outPos + 18] = in[inPos + 21] - in[inPos + 20] >>> 18 | in[inPos + 22] - in[inPos + 21] << 36;
        out[outPos + 19] = in[inPos + 22] - in[inPos + 21] >>> 28 | in[inPos + 23] - in[inPos + 22] << 26;
        out[outPos + 20] = in[inPos + 23] - in[inPos + 22] >>> 38 | in[inPos + 24] - in[inPos + 23] << 16;
        out[outPos + 21] = in[inPos + 24] - in[inPos + 23] >>> 48 | in[inPos + 25] - in[inPos + 24] << 6 | in[inPos + 26] - in[inPos + 25] << 60;
        out[outPos + 22] = in[inPos + 26] - in[inPos + 25] >>> 4 | in[inPos + 27] - in[inPos + 26] << 50;
        out[outPos + 23] = in[inPos + 27] - in[inPos + 26] >>> 14 | in[inPos + 28] - in[inPos + 27] << 40;
        out[outPos + 24] = in[inPos + 28] - in[inPos + 27] >>> 24 | in[inPos + 29] - in[inPos + 28] << 30;
        out[outPos + 25] = in[inPos + 29] - in[inPos + 28] >>> 34 | in[inPos + 30] - in[inPos + 29] << 20;
        out[outPos + 26] = in[inPos + 30] - in[inPos + 29] >>> 44 | in[inPos + 31] - in[inPos + 30] << 10;
        out[outPos + 27] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 54;
        out[outPos + 28] = in[inPos + 33] - in[inPos + 32] >>> 10 | in[inPos + 34] - in[inPos + 33] << 44;
        out[outPos + 29] = in[inPos + 34] - in[inPos + 33] >>> 20 | in[inPos + 35] - in[inPos + 34] << 34;
        out[outPos + 30] = in[inPos + 35] - in[inPos + 34] >>> 30 | in[inPos + 36] - in[inPos + 35] << 24;
        out[outPos + 31] = in[inPos + 36] - in[inPos + 35] >>> 40 | in[inPos + 37] - in[inPos + 36] << 14;
        out[outPos + 32] = in[inPos + 37] - in[inPos + 36] >>> 50 | in[inPos + 38] - in[inPos + 37] << 4 | in[inPos + 39] - in[inPos + 38] << 58;
        out[outPos + 33] = in[inPos + 39] - in[inPos + 38] >>> 6 | in[inPos + 40] - in[inPos + 39] << 48;
        out[outPos + 34] = in[inPos + 40] - in[inPos + 39] >>> 16 | in[inPos + 41] - in[inPos + 40] << 38;
        out[outPos + 35] = in[inPos + 41] - in[inPos + 40] >>> 26 | in[inPos + 42] - in[inPos + 41] << 28;
        out[outPos + 36] = in[inPos + 42] - in[inPos + 41] >>> 36 | in[inPos + 43] - in[inPos + 42] << 18;
        out[outPos + 37] = in[inPos + 43] - in[inPos + 42] >>> 46 | in[inPos + 44] - in[inPos + 43] << 8 | in[inPos + 45] - in[inPos + 44] << 62;
        out[outPos + 38] = in[inPos + 45] - in[inPos + 44] >>> 2 | in[inPos + 46] - in[inPos + 45] << 52;
        out[outPos + 39] = in[inPos + 46] - in[inPos + 45] >>> 12 | in[inPos + 47] - in[inPos + 46] << 42;
        out[outPos + 40] = in[inPos + 47] - in[inPos + 46] >>> 22 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 41] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 22;
        out[outPos + 42] = in[inPos + 49] - in[inPos + 48] >>> 42 | in[inPos + 50] - in[inPos + 49] << 12;
        out[outPos + 43] = in[inPos + 50] - in[inPos + 49] >>> 52 | in[inPos + 51] - in[inPos + 50] << 2 | in[inPos + 52] - in[inPos + 51] << 56;
        out[outPos + 44] = in[inPos + 52] - in[inPos + 51] >>> 8 | in[inPos + 53] - in[inPos + 52] << 46;
        out[outPos + 45] = in[inPos + 53] - in[inPos + 52] >>> 18 | in[inPos + 54] - in[inPos + 53] << 36;
        out[outPos + 46] = in[inPos + 54] - in[inPos + 53] >>> 28 | in[inPos + 55] - in[inPos + 54] << 26;
        out[outPos + 47] = in[inPos + 55] - in[inPos + 54] >>> 38 | in[inPos + 56] - in[inPos + 55] << 16;
        out[outPos + 48] = in[inPos + 56] - in[inPos + 55] >>> 48 | in[inPos + 57] - in[inPos + 56] << 6 | in[inPos + 58] - in[inPos + 57] << 60;
        out[outPos + 49] = in[inPos + 58] - in[inPos + 57] >>> 4 | in[inPos + 59] - in[inPos + 58] << 50;
        out[outPos + 50] = in[inPos + 59] - in[inPos + 58] >>> 14 | in[inPos + 60] - in[inPos + 59] << 40;
        out[outPos + 51] = in[inPos + 60] - in[inPos + 59] >>> 24 | in[inPos + 61] - in[inPos + 60] << 30;
        out[outPos + 52] = in[inPos + 61] - in[inPos + 60] >>> 34 | in[inPos + 62] - in[inPos + 61] << 20;
        out[outPos + 53] = in[inPos + 62] - in[inPos + 61] >>> 44 | in[inPos + 63] - in[inPos + 62] << 10;
    }

    private static void unpack54(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 54 | (in[inPos + 1] & 0xFFFFFFFFFFFL) << 10) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 44 | (in[inPos + 2] & 0x3FFFFFFFFL) << 20) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 34 | (in[inPos + 3] & 0xFFFFFFL) << 30) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 24 | (in[inPos + 4] & 0x3FFFL) << 40) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 14 | (in[inPos + 5] & 0xFL) << 50) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 4 & 0x3FFFFFFFFFFFFFL) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 0xFFFFFFFFFFFFL) << 6) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 48 | (in[inPos + 7] & 0x3FFFFFFFFFL) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 38 | (in[inPos + 8] & 0xFFFFFFFL) << 26) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 28 | (in[inPos + 9] & 0x3FFFFL) << 36) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 18 | (in[inPos + 10] & 0xFFL) << 46) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 8 & 0x3FFFFFFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 10] >>> 62 | (in[inPos + 11] & 0xFFFFFFFFFFFFFL) << 2) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0x3FFFFFFFFFFL) << 12) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 12] >>> 42 | (in[inPos + 13] & 0xFFFFFFFFL) << 22) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 13] >>> 32 | (in[inPos + 14] & 0x3FFFFFL) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 14] >>> 22 | (in[inPos + 15] & 0xFFFL) << 42) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 15] >>> 12 | (in[inPos + 16] & 3L) << 52) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 16] >>> 2 & 0x3FFFFFFFFFFFFFL) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0x3FFFFFFFFFFFL) << 8) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 17] >>> 46 | (in[inPos + 18] & 0xFFFFFFFFFL) << 18) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 18] >>> 36 | (in[inPos + 19] & 0x3FFFFFFL) << 28) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 19] >>> 26 | (in[inPos + 20] & 0xFFFFL) << 38) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 20] >>> 16 | (in[inPos + 21] & 0x3FL) << 48) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 21] >>> 6 & 0x3FFFFFFFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 21] >>> 60 | (in[inPos + 22] & 0x3FFFFFFFFFFFFL) << 4) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 22] >>> 50 | (in[inPos + 23] & 0xFFFFFFFFFFL) << 14) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 23] >>> 40 | (in[inPos + 24] & 0x3FFFFFFFL) << 24) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 24] >>> 30 | (in[inPos + 25] & 0xFFFFFL) << 34) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 25] >>> 20 | (in[inPos + 26] & 0x3FFL) << 44) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 26] >>> 10) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 27] & 0x3FFFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 27] >>> 54 | (in[inPos + 28] & 0xFFFFFFFFFFFL) << 10) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 28] >>> 44 | (in[inPos + 29] & 0x3FFFFFFFFL) << 20) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 29] >>> 34 | (in[inPos + 30] & 0xFFFFFFL) << 30) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 30] >>> 24 | (in[inPos + 31] & 0x3FFFL) << 40) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 31] >>> 14 | (in[inPos + 32] & 0xFL) << 50) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 32] >>> 4 & 0x3FFFFFFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 32] >>> 58 | (in[inPos + 33] & 0xFFFFFFFFFFFFL) << 6) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 33] >>> 48 | (in[inPos + 34] & 0x3FFFFFFFFFL) << 16) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 34] >>> 38 | (in[inPos + 35] & 0xFFFFFFFL) << 26) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 35] >>> 28 | (in[inPos + 36] & 0x3FFFFL) << 36) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 36] >>> 18 | (in[inPos + 37] & 0xFFL) << 46) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 37] >>> 8 & 0x3FFFFFFFFFFFFFL) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 37] >>> 62 | (in[inPos + 38] & 0xFFFFFFFFFFFFFL) << 2) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 38] >>> 52 | (in[inPos + 39] & 0x3FFFFFFFFFFL) << 12) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 39] >>> 42 | (in[inPos + 40] & 0xFFFFFFFFL) << 22) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 40] >>> 32 | (in[inPos + 41] & 0x3FFFFFL) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 41] >>> 22 | (in[inPos + 42] & 0xFFFL) << 42) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 42] >>> 12 | (in[inPos + 43] & 3L) << 52) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 43] >>> 2 & 0x3FFFFFFFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 43] >>> 56 | (in[inPos + 44] & 0x3FFFFFFFFFFFL) << 8) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 44] >>> 46 | (in[inPos + 45] & 0xFFFFFFFFFL) << 18) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 45] >>> 36 | (in[inPos + 46] & 0x3FFFFFFL) << 28) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 46] >>> 26 | (in[inPos + 47] & 0xFFFFL) << 38) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 47] >>> 16 | (in[inPos + 48] & 0x3FL) << 48) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 48] >>> 6 & 0x3FFFFFFFFFFFFFL) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 48] >>> 60 | (in[inPos + 49] & 0x3FFFFFFFFFFFFL) << 4) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 49] >>> 50 | (in[inPos + 50] & 0xFFFFFFFFFFL) << 14) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 50] >>> 40 | (in[inPos + 51] & 0x3FFFFFFFL) << 24) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 51] >>> 30 | (in[inPos + 52] & 0xFFFFFL) << 34) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 52] >>> 20 | (in[inPos + 53] & 0x3FFL) << 44) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 53] >>> 10) + out[outPos + 62];
    }

    private static void pack55(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 55;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 9 | in[inPos + 2] - in[inPos + 1] << 46;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 18 | in[inPos + 3] - in[inPos + 2] << 37;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 27 | in[inPos + 4] - in[inPos + 3] << 28;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 36 | in[inPos + 5] - in[inPos + 4] << 19;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 45 | in[inPos + 6] - in[inPos + 5] << 10;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 54 | in[inPos + 7] - in[inPos + 6] << 1 | in[inPos + 8] - in[inPos + 7] << 56;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 47;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 17 | in[inPos + 10] - in[inPos + 9] << 38;
        out[outPos + 9] = in[inPos + 10] - in[inPos + 9] >>> 26 | in[inPos + 11] - in[inPos + 10] << 29;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 35 | in[inPos + 12] - in[inPos + 11] << 20;
        out[outPos + 11] = in[inPos + 12] - in[inPos + 11] >>> 44 | in[inPos + 13] - in[inPos + 12] << 11;
        out[outPos + 12] = in[inPos + 13] - in[inPos + 12] >>> 53 | in[inPos + 14] - in[inPos + 13] << 2 | in[inPos + 15] - in[inPos + 14] << 57;
        out[outPos + 13] = in[inPos + 15] - in[inPos + 14] >>> 7 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 14] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 39;
        out[outPos + 15] = in[inPos + 17] - in[inPos + 16] >>> 25 | in[inPos + 18] - in[inPos + 17] << 30;
        out[outPos + 16] = in[inPos + 18] - in[inPos + 17] >>> 34 | in[inPos + 19] - in[inPos + 18] << 21;
        out[outPos + 17] = in[inPos + 19] - in[inPos + 18] >>> 43 | in[inPos + 20] - in[inPos + 19] << 12;
        out[outPos + 18] = in[inPos + 20] - in[inPos + 19] >>> 52 | in[inPos + 21] - in[inPos + 20] << 3 | in[inPos + 22] - in[inPos + 21] << 58;
        out[outPos + 19] = in[inPos + 22] - in[inPos + 21] >>> 6 | in[inPos + 23] - in[inPos + 22] << 49;
        out[outPos + 20] = in[inPos + 23] - in[inPos + 22] >>> 15 | in[inPos + 24] - in[inPos + 23] << 40;
        out[outPos + 21] = in[inPos + 24] - in[inPos + 23] >>> 24 | in[inPos + 25] - in[inPos + 24] << 31;
        out[outPos + 22] = in[inPos + 25] - in[inPos + 24] >>> 33 | in[inPos + 26] - in[inPos + 25] << 22;
        out[outPos + 23] = in[inPos + 26] - in[inPos + 25] >>> 42 | in[inPos + 27] - in[inPos + 26] << 13;
        out[outPos + 24] = in[inPos + 27] - in[inPos + 26] >>> 51 | in[inPos + 28] - in[inPos + 27] << 4 | in[inPos + 29] - in[inPos + 28] << 59;
        out[outPos + 25] = in[inPos + 29] - in[inPos + 28] >>> 5 | in[inPos + 30] - in[inPos + 29] << 50;
        out[outPos + 26] = in[inPos + 30] - in[inPos + 29] >>> 14 | in[inPos + 31] - in[inPos + 30] << 41;
        out[outPos + 27] = in[inPos + 31] - in[inPos + 30] >>> 23 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 28] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 23;
        out[outPos + 29] = in[inPos + 33] - in[inPos + 32] >>> 41 | in[inPos + 34] - in[inPos + 33] << 14;
        out[outPos + 30] = in[inPos + 34] - in[inPos + 33] >>> 50 | in[inPos + 35] - in[inPos + 34] << 5 | in[inPos + 36] - in[inPos + 35] << 60;
        out[outPos + 31] = in[inPos + 36] - in[inPos + 35] >>> 4 | in[inPos + 37] - in[inPos + 36] << 51;
        out[outPos + 32] = in[inPos + 37] - in[inPos + 36] >>> 13 | in[inPos + 38] - in[inPos + 37] << 42;
        out[outPos + 33] = in[inPos + 38] - in[inPos + 37] >>> 22 | in[inPos + 39] - in[inPos + 38] << 33;
        out[outPos + 34] = in[inPos + 39] - in[inPos + 38] >>> 31 | in[inPos + 40] - in[inPos + 39] << 24;
        out[outPos + 35] = in[inPos + 40] - in[inPos + 39] >>> 40 | in[inPos + 41] - in[inPos + 40] << 15;
        out[outPos + 36] = in[inPos + 41] - in[inPos + 40] >>> 49 | in[inPos + 42] - in[inPos + 41] << 6 | in[inPos + 43] - in[inPos + 42] << 61;
        out[outPos + 37] = in[inPos + 43] - in[inPos + 42] >>> 3 | in[inPos + 44] - in[inPos + 43] << 52;
        out[outPos + 38] = in[inPos + 44] - in[inPos + 43] >>> 12 | in[inPos + 45] - in[inPos + 44] << 43;
        out[outPos + 39] = in[inPos + 45] - in[inPos + 44] >>> 21 | in[inPos + 46] - in[inPos + 45] << 34;
        out[outPos + 40] = in[inPos + 46] - in[inPos + 45] >>> 30 | in[inPos + 47] - in[inPos + 46] << 25;
        out[outPos + 41] = in[inPos + 47] - in[inPos + 46] >>> 39 | in[inPos + 48] - in[inPos + 47] << 16;
        out[outPos + 42] = in[inPos + 48] - in[inPos + 47] >>> 48 | in[inPos + 49] - in[inPos + 48] << 7 | in[inPos + 50] - in[inPos + 49] << 62;
        out[outPos + 43] = in[inPos + 50] - in[inPos + 49] >>> 2 | in[inPos + 51] - in[inPos + 50] << 53;
        out[outPos + 44] = in[inPos + 51] - in[inPos + 50] >>> 11 | in[inPos + 52] - in[inPos + 51] << 44;
        out[outPos + 45] = in[inPos + 52] - in[inPos + 51] >>> 20 | in[inPos + 53] - in[inPos + 52] << 35;
        out[outPos + 46] = in[inPos + 53] - in[inPos + 52] >>> 29 | in[inPos + 54] - in[inPos + 53] << 26;
        out[outPos + 47] = in[inPos + 54] - in[inPos + 53] >>> 38 | in[inPos + 55] - in[inPos + 54] << 17;
        out[outPos + 48] = in[inPos + 55] - in[inPos + 54] >>> 47 | in[inPos + 56] - in[inPos + 55] << 8 | in[inPos + 57] - in[inPos + 56] << 63;
        out[outPos + 49] = in[inPos + 57] - in[inPos + 56] >>> 1 | in[inPos + 58] - in[inPos + 57] << 54;
        out[outPos + 50] = in[inPos + 58] - in[inPos + 57] >>> 10 | in[inPos + 59] - in[inPos + 58] << 45;
        out[outPos + 51] = in[inPos + 59] - in[inPos + 58] >>> 19 | in[inPos + 60] - in[inPos + 59] << 36;
        out[outPos + 52] = in[inPos + 60] - in[inPos + 59] >>> 28 | in[inPos + 61] - in[inPos + 60] << 27;
        out[outPos + 53] = in[inPos + 61] - in[inPos + 60] >>> 37 | in[inPos + 62] - in[inPos + 61] << 18;
        out[outPos + 54] = in[inPos + 62] - in[inPos + 61] >>> 46 | in[inPos + 63] - in[inPos + 62] << 9;
    }

    private static void unpack55(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 55 | (in[inPos + 1] & 0x3FFFFFFFFFFFL) << 9) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 46 | (in[inPos + 2] & 0x1FFFFFFFFFL) << 18) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 37 | (in[inPos + 3] & 0xFFFFFFFL) << 27) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 28 | (in[inPos + 4] & 0x7FFFFL) << 36) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 19 | (in[inPos + 5] & 0x3FFL) << 45) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 10 | (in[inPos + 6] & 1L) << 54) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 1 & 0x7FFFFFFFFFFFFFL) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 6] >>> 56 | (in[inPos + 7] & 0x7FFFFFFFFFFFL) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 47 | (in[inPos + 8] & 0x3FFFFFFFFFL) << 17) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 38 | (in[inPos + 9] & 0x1FFFFFFFL) << 26) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 29 | (in[inPos + 10] & 0xFFFFFL) << 35) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 20 | (in[inPos + 11] & 0x7FFL) << 44) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 11] >>> 11 | (in[inPos + 12] & 3L) << 53) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 12] >>> 2 & 0x7FFFFFFFFFFFFFL) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 12] >>> 57 | (in[inPos + 13] & 0xFFFFFFFFFFFFL) << 7) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 13] >>> 48 | (in[inPos + 14] & 0x7FFFFFFFFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 14] >>> 39 | (in[inPos + 15] & 0x3FFFFFFFL) << 25) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 15] >>> 30 | (in[inPos + 16] & 0x1FFFFFL) << 34) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 16] >>> 21 | (in[inPos + 17] & 0xFFFL) << 43) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 17] >>> 12 | (in[inPos + 18] & 7L) << 52) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 18] >>> 3 & 0x7FFFFFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 18] >>> 58 | (in[inPos + 19] & 0x1FFFFFFFFFFFFL) << 6) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 19] >>> 49 | (in[inPos + 20] & 0xFFFFFFFFFFL) << 15) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 20] >>> 40 | (in[inPos + 21] & Integer.MAX_VALUE) << 24) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 21] >>> 31 | (in[inPos + 22] & 0x3FFFFFL) << 33) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 22] >>> 22 | (in[inPos + 23] & 0x1FFFL) << 42) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 23] >>> 13 | (in[inPos + 24] & 0xFL) << 51) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 24] >>> 4 & 0x7FFFFFFFFFFFFFL) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 24] >>> 59 | (in[inPos + 25] & 0x3FFFFFFFFFFFFL) << 5) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 25] >>> 50 | (in[inPos + 26] & 0x1FFFFFFFFFFL) << 14) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 26] >>> 41 | (in[inPos + 27] & 0xFFFFFFFFL) << 23) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 27] >>> 32 | (in[inPos + 28] & 0x7FFFFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 28] >>> 23 | (in[inPos + 29] & 0x3FFFL) << 41) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 29] >>> 14 | (in[inPos + 30] & 0x1FL) << 50) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 30] >>> 5 & 0x7FFFFFFFFFFFFFL) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 30] >>> 60 | (in[inPos + 31] & 0x7FFFFFFFFFFFFL) << 4) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 31] >>> 51 | (in[inPos + 32] & 0x3FFFFFFFFFFL) << 13) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 32] >>> 42 | (in[inPos + 33] & 0x1FFFFFFFFL) << 22) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 33] >>> 33 | (in[inPos + 34] & 0xFFFFFFL) << 31) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 34] >>> 24 | (in[inPos + 35] & 0x7FFFL) << 40) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 35] >>> 15 | (in[inPos + 36] & 0x3FL) << 49) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 36] >>> 6 & 0x7FFFFFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 36] >>> 61 | (in[inPos + 37] & 0xFFFFFFFFFFFFFL) << 3) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 37] >>> 52 | (in[inPos + 38] & 0x7FFFFFFFFFFL) << 12) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 38] >>> 43 | (in[inPos + 39] & 0x3FFFFFFFFL) << 21) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 39] >>> 34 | (in[inPos + 40] & 0x1FFFFFFL) << 30) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 40] >>> 25 | (in[inPos + 41] & 0xFFFFL) << 39) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 41] >>> 16 | (in[inPos + 42] & 0x7FL) << 48) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 42] >>> 7 & 0x7FFFFFFFFFFFFFL) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 42] >>> 62 | (in[inPos + 43] & 0x1FFFFFFFFFFFFFL) << 2) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 43] >>> 53 | (in[inPos + 44] & 0xFFFFFFFFFFFL) << 11) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 44] >>> 44 | (in[inPos + 45] & 0x7FFFFFFFFL) << 20) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 45] >>> 35 | (in[inPos + 46] & 0x3FFFFFFL) << 29) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 46] >>> 26 | (in[inPos + 47] & 0x1FFFFL) << 38) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 47] >>> 17 | (in[inPos + 48] & 0xFFL) << 47) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 48] >>> 8 & 0x7FFFFFFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 48] >>> 63 | (in[inPos + 49] & 0x3FFFFFFFFFFFFFL) << 1) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 49] >>> 54 | (in[inPos + 50] & 0x1FFFFFFFFFFFL) << 10) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 50] >>> 45 | (in[inPos + 51] & 0xFFFFFFFFFL) << 19) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 51] >>> 36 | (in[inPos + 52] & 0x7FFFFFFL) << 28) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 52] >>> 27 | (in[inPos + 53] & 0x3FFFFL) << 37) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 53] >>> 18 | (in[inPos + 54] & 0x1FFL) << 46) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 54] >>> 9) + out[outPos + 62];
    }

    private static void pack56(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 56;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 8 | in[inPos + 2] - in[inPos + 1] << 48;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 16 | in[inPos + 3] - in[inPos + 2] << 40;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 24 | in[inPos + 4] - in[inPos + 3] << 32;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 32 | in[inPos + 5] - in[inPos + 4] << 24;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 40 | in[inPos + 6] - in[inPos + 5] << 16;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 48 | in[inPos + 7] - in[inPos + 6] << 8;
        out[outPos + 7] = in[inPos + 8] - in[inPos + 7] | in[inPos + 9] - in[inPos + 8] << 56;
        out[outPos + 8] = in[inPos + 9] - in[inPos + 8] >>> 8 | in[inPos + 10] - in[inPos + 9] << 48;
        out[outPos + 9] = in[inPos + 10] - in[inPos + 9] >>> 16 | in[inPos + 11] - in[inPos + 10] << 40;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 24 | in[inPos + 12] - in[inPos + 11] << 32;
        out[outPos + 11] = in[inPos + 12] - in[inPos + 11] >>> 32 | in[inPos + 13] - in[inPos + 12] << 24;
        out[outPos + 12] = in[inPos + 13] - in[inPos + 12] >>> 40 | in[inPos + 14] - in[inPos + 13] << 16;
        out[outPos + 13] = in[inPos + 14] - in[inPos + 13] >>> 48 | in[inPos + 15] - in[inPos + 14] << 8;
        out[outPos + 14] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 56;
        out[outPos + 15] = in[inPos + 17] - in[inPos + 16] >>> 8 | in[inPos + 18] - in[inPos + 17] << 48;
        out[outPos + 16] = in[inPos + 18] - in[inPos + 17] >>> 16 | in[inPos + 19] - in[inPos + 18] << 40;
        out[outPos + 17] = in[inPos + 19] - in[inPos + 18] >>> 24 | in[inPos + 20] - in[inPos + 19] << 32;
        out[outPos + 18] = in[inPos + 20] - in[inPos + 19] >>> 32 | in[inPos + 21] - in[inPos + 20] << 24;
        out[outPos + 19] = in[inPos + 21] - in[inPos + 20] >>> 40 | in[inPos + 22] - in[inPos + 21] << 16;
        out[outPos + 20] = in[inPos + 22] - in[inPos + 21] >>> 48 | in[inPos + 23] - in[inPos + 22] << 8;
        out[outPos + 21] = in[inPos + 24] - in[inPos + 23] | in[inPos + 25] - in[inPos + 24] << 56;
        out[outPos + 22] = in[inPos + 25] - in[inPos + 24] >>> 8 | in[inPos + 26] - in[inPos + 25] << 48;
        out[outPos + 23] = in[inPos + 26] - in[inPos + 25] >>> 16 | in[inPos + 27] - in[inPos + 26] << 40;
        out[outPos + 24] = in[inPos + 27] - in[inPos + 26] >>> 24 | in[inPos + 28] - in[inPos + 27] << 32;
        out[outPos + 25] = in[inPos + 28] - in[inPos + 27] >>> 32 | in[inPos + 29] - in[inPos + 28] << 24;
        out[outPos + 26] = in[inPos + 29] - in[inPos + 28] >>> 40 | in[inPos + 30] - in[inPos + 29] << 16;
        out[outPos + 27] = in[inPos + 30] - in[inPos + 29] >>> 48 | in[inPos + 31] - in[inPos + 30] << 8;
        out[outPos + 28] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 56;
        out[outPos + 29] = in[inPos + 33] - in[inPos + 32] >>> 8 | in[inPos + 34] - in[inPos + 33] << 48;
        out[outPos + 30] = in[inPos + 34] - in[inPos + 33] >>> 16 | in[inPos + 35] - in[inPos + 34] << 40;
        out[outPos + 31] = in[inPos + 35] - in[inPos + 34] >>> 24 | in[inPos + 36] - in[inPos + 35] << 32;
        out[outPos + 32] = in[inPos + 36] - in[inPos + 35] >>> 32 | in[inPos + 37] - in[inPos + 36] << 24;
        out[outPos + 33] = in[inPos + 37] - in[inPos + 36] >>> 40 | in[inPos + 38] - in[inPos + 37] << 16;
        out[outPos + 34] = in[inPos + 38] - in[inPos + 37] >>> 48 | in[inPos + 39] - in[inPos + 38] << 8;
        out[outPos + 35] = in[inPos + 40] - in[inPos + 39] | in[inPos + 41] - in[inPos + 40] << 56;
        out[outPos + 36] = in[inPos + 41] - in[inPos + 40] >>> 8 | in[inPos + 42] - in[inPos + 41] << 48;
        out[outPos + 37] = in[inPos + 42] - in[inPos + 41] >>> 16 | in[inPos + 43] - in[inPos + 42] << 40;
        out[outPos + 38] = in[inPos + 43] - in[inPos + 42] >>> 24 | in[inPos + 44] - in[inPos + 43] << 32;
        out[outPos + 39] = in[inPos + 44] - in[inPos + 43] >>> 32 | in[inPos + 45] - in[inPos + 44] << 24;
        out[outPos + 40] = in[inPos + 45] - in[inPos + 44] >>> 40 | in[inPos + 46] - in[inPos + 45] << 16;
        out[outPos + 41] = in[inPos + 46] - in[inPos + 45] >>> 48 | in[inPos + 47] - in[inPos + 46] << 8;
        out[outPos + 42] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 56;
        out[outPos + 43] = in[inPos + 49] - in[inPos + 48] >>> 8 | in[inPos + 50] - in[inPos + 49] << 48;
        out[outPos + 44] = in[inPos + 50] - in[inPos + 49] >>> 16 | in[inPos + 51] - in[inPos + 50] << 40;
        out[outPos + 45] = in[inPos + 51] - in[inPos + 50] >>> 24 | in[inPos + 52] - in[inPos + 51] << 32;
        out[outPos + 46] = in[inPos + 52] - in[inPos + 51] >>> 32 | in[inPos + 53] - in[inPos + 52] << 24;
        out[outPos + 47] = in[inPos + 53] - in[inPos + 52] >>> 40 | in[inPos + 54] - in[inPos + 53] << 16;
        out[outPos + 48] = in[inPos + 54] - in[inPos + 53] >>> 48 | in[inPos + 55] - in[inPos + 54] << 8;
        out[outPos + 49] = in[inPos + 56] - in[inPos + 55] | in[inPos + 57] - in[inPos + 56] << 56;
        out[outPos + 50] = in[inPos + 57] - in[inPos + 56] >>> 8 | in[inPos + 58] - in[inPos + 57] << 48;
        out[outPos + 51] = in[inPos + 58] - in[inPos + 57] >>> 16 | in[inPos + 59] - in[inPos + 58] << 40;
        out[outPos + 52] = in[inPos + 59] - in[inPos + 58] >>> 24 | in[inPos + 60] - in[inPos + 59] << 32;
        out[outPos + 53] = in[inPos + 60] - in[inPos + 59] >>> 32 | in[inPos + 61] - in[inPos + 60] << 24;
        out[outPos + 54] = in[inPos + 61] - in[inPos + 60] >>> 40 | in[inPos + 62] - in[inPos + 61] << 16;
        out[outPos + 55] = in[inPos + 62] - in[inPos + 61] >>> 48 | in[inPos + 63] - in[inPos + 62] << 8;
    }

    private static void unpack56(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 56 | (in[inPos + 1] & 0xFFFFFFFFFFFFL) << 8) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 48 | (in[inPos + 2] & 0xFFFFFFFFFFL) << 16) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 40 | (in[inPos + 3] & 0xFFFFFFFFL) << 24) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 32 | (in[inPos + 4] & 0xFFFFFFL) << 32) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 24 | (in[inPos + 5] & 0xFFFFL) << 40) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 16 | (in[inPos + 6] & 0xFFL) << 48) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 8) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] & 0xFFFFFFFFFFFFFFL) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0xFFFFFFFFFFFFL) << 8) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 48 | (in[inPos + 9] & 0xFFFFFFFFFFL) << 16) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 40 | (in[inPos + 10] & 0xFFFFFFFFL) << 24) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 32 | (in[inPos + 11] & 0xFFFFFFL) << 32) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 11] >>> 24 | (in[inPos + 12] & 0xFFFFL) << 40) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 12] >>> 16 | (in[inPos + 13] & 0xFFL) << 48) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 13] >>> 8) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 14] & 0xFFFFFFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 14] >>> 56 | (in[inPos + 15] & 0xFFFFFFFFFFFFL) << 8) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0xFFFFFFFFFFL) << 16) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 16] >>> 40 | (in[inPos + 17] & 0xFFFFFFFFL) << 24) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 17] >>> 32 | (in[inPos + 18] & 0xFFFFFFL) << 32) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 18] >>> 24 | (in[inPos + 19] & 0xFFFFL) << 40) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 19] >>> 16 | (in[inPos + 20] & 0xFFL) << 48) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 20] >>> 8) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 21] & 0xFFFFFFFFFFFFFFL) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 21] >>> 56 | (in[inPos + 22] & 0xFFFFFFFFFFFFL) << 8) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 22] >>> 48 | (in[inPos + 23] & 0xFFFFFFFFFFL) << 16) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 23] >>> 40 | (in[inPos + 24] & 0xFFFFFFFFL) << 24) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 24] >>> 32 | (in[inPos + 25] & 0xFFFFFFL) << 32) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 25] >>> 24 | (in[inPos + 26] & 0xFFFFL) << 40) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 26] >>> 16 | (in[inPos + 27] & 0xFFL) << 48) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 27] >>> 8) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 28] & 0xFFFFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 28] >>> 56 | (in[inPos + 29] & 0xFFFFFFFFFFFFL) << 8) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 29] >>> 48 | (in[inPos + 30] & 0xFFFFFFFFFFL) << 16) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 30] >>> 40 | (in[inPos + 31] & 0xFFFFFFFFL) << 24) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 31] >>> 32 | (in[inPos + 32] & 0xFFFFFFL) << 32) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 32] >>> 24 | (in[inPos + 33] & 0xFFFFL) << 40) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 33] >>> 16 | (in[inPos + 34] & 0xFFL) << 48) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 34] >>> 8) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 35] & 0xFFFFFFFFFFFFFFL) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 35] >>> 56 | (in[inPos + 36] & 0xFFFFFFFFFFFFL) << 8) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 36] >>> 48 | (in[inPos + 37] & 0xFFFFFFFFFFL) << 16) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 37] >>> 40 | (in[inPos + 38] & 0xFFFFFFFFL) << 24) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 38] >>> 32 | (in[inPos + 39] & 0xFFFFFFL) << 32) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 39] >>> 24 | (in[inPos + 40] & 0xFFFFL) << 40) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 40] >>> 16 | (in[inPos + 41] & 0xFFL) << 48) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 41] >>> 8) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 42] & 0xFFFFFFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 42] >>> 56 | (in[inPos + 43] & 0xFFFFFFFFFFFFL) << 8) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 43] >>> 48 | (in[inPos + 44] & 0xFFFFFFFFFFL) << 16) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 44] >>> 40 | (in[inPos + 45] & 0xFFFFFFFFL) << 24) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 45] >>> 32 | (in[inPos + 46] & 0xFFFFFFL) << 32) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 46] >>> 24 | (in[inPos + 47] & 0xFFFFL) << 40) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 47] >>> 16 | (in[inPos + 48] & 0xFFL) << 48) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 48] >>> 8) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 49] & 0xFFFFFFFFFFFFFFL) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 49] >>> 56 | (in[inPos + 50] & 0xFFFFFFFFFFFFL) << 8) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 50] >>> 48 | (in[inPos + 51] & 0xFFFFFFFFFFL) << 16) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 51] >>> 40 | (in[inPos + 52] & 0xFFFFFFFFL) << 24) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 52] >>> 32 | (in[inPos + 53] & 0xFFFFFFL) << 32) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 53] >>> 24 | (in[inPos + 54] & 0xFFFFL) << 40) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 54] >>> 16 | (in[inPos + 55] & 0xFFL) << 48) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 55] >>> 8) + out[outPos + 62];
    }

    private static void pack57(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 57;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 7 | in[inPos + 2] - in[inPos + 1] << 50;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 14 | in[inPos + 3] - in[inPos + 2] << 43;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 21 | in[inPos + 4] - in[inPos + 3] << 36;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 28 | in[inPos + 5] - in[inPos + 4] << 29;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 35 | in[inPos + 6] - in[inPos + 5] << 22;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 42 | in[inPos + 7] - in[inPos + 6] << 15;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 49 | in[inPos + 8] - in[inPos + 7] << 8;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 56 | in[inPos + 9] - in[inPos + 8] << 1 | in[inPos + 10] - in[inPos + 9] << 58;
        out[outPos + 9] = in[inPos + 10] - in[inPos + 9] >>> 6 | in[inPos + 11] - in[inPos + 10] << 51;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 13 | in[inPos + 12] - in[inPos + 11] << 44;
        out[outPos + 11] = in[inPos + 12] - in[inPos + 11] >>> 20 | in[inPos + 13] - in[inPos + 12] << 37;
        out[outPos + 12] = in[inPos + 13] - in[inPos + 12] >>> 27 | in[inPos + 14] - in[inPos + 13] << 30;
        out[outPos + 13] = in[inPos + 14] - in[inPos + 13] >>> 34 | in[inPos + 15] - in[inPos + 14] << 23;
        out[outPos + 14] = in[inPos + 15] - in[inPos + 14] >>> 41 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 15] = in[inPos + 16] - in[inPos + 15] >>> 48 | in[inPos + 17] - in[inPos + 16] << 9;
        out[outPos + 16] = in[inPos + 17] - in[inPos + 16] >>> 55 | in[inPos + 18] - in[inPos + 17] << 2 | in[inPos + 19] - in[inPos + 18] << 59;
        out[outPos + 17] = in[inPos + 19] - in[inPos + 18] >>> 5 | in[inPos + 20] - in[inPos + 19] << 52;
        out[outPos + 18] = in[inPos + 20] - in[inPos + 19] >>> 12 | in[inPos + 21] - in[inPos + 20] << 45;
        out[outPos + 19] = in[inPos + 21] - in[inPos + 20] >>> 19 | in[inPos + 22] - in[inPos + 21] << 38;
        out[outPos + 20] = in[inPos + 22] - in[inPos + 21] >>> 26 | in[inPos + 23] - in[inPos + 22] << 31;
        out[outPos + 21] = in[inPos + 23] - in[inPos + 22] >>> 33 | in[inPos + 24] - in[inPos + 23] << 24;
        out[outPos + 22] = in[inPos + 24] - in[inPos + 23] >>> 40 | in[inPos + 25] - in[inPos + 24] << 17;
        out[outPos + 23] = in[inPos + 25] - in[inPos + 24] >>> 47 | in[inPos + 26] - in[inPos + 25] << 10;
        out[outPos + 24] = in[inPos + 26] - in[inPos + 25] >>> 54 | in[inPos + 27] - in[inPos + 26] << 3 | in[inPos + 28] - in[inPos + 27] << 60;
        out[outPos + 25] = in[inPos + 28] - in[inPos + 27] >>> 4 | in[inPos + 29] - in[inPos + 28] << 53;
        out[outPos + 26] = in[inPos + 29] - in[inPos + 28] >>> 11 | in[inPos + 30] - in[inPos + 29] << 46;
        out[outPos + 27] = in[inPos + 30] - in[inPos + 29] >>> 18 | in[inPos + 31] - in[inPos + 30] << 39;
        out[outPos + 28] = in[inPos + 31] - in[inPos + 30] >>> 25 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 29] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 25;
        out[outPos + 30] = in[inPos + 33] - in[inPos + 32] >>> 39 | in[inPos + 34] - in[inPos + 33] << 18;
        out[outPos + 31] = in[inPos + 34] - in[inPos + 33] >>> 46 | in[inPos + 35] - in[inPos + 34] << 11;
        out[outPos + 32] = in[inPos + 35] - in[inPos + 34] >>> 53 | in[inPos + 36] - in[inPos + 35] << 4 | in[inPos + 37] - in[inPos + 36] << 61;
        out[outPos + 33] = in[inPos + 37] - in[inPos + 36] >>> 3 | in[inPos + 38] - in[inPos + 37] << 54;
        out[outPos + 34] = in[inPos + 38] - in[inPos + 37] >>> 10 | in[inPos + 39] - in[inPos + 38] << 47;
        out[outPos + 35] = in[inPos + 39] - in[inPos + 38] >>> 17 | in[inPos + 40] - in[inPos + 39] << 40;
        out[outPos + 36] = in[inPos + 40] - in[inPos + 39] >>> 24 | in[inPos + 41] - in[inPos + 40] << 33;
        out[outPos + 37] = in[inPos + 41] - in[inPos + 40] >>> 31 | in[inPos + 42] - in[inPos + 41] << 26;
        out[outPos + 38] = in[inPos + 42] - in[inPos + 41] >>> 38 | in[inPos + 43] - in[inPos + 42] << 19;
        out[outPos + 39] = in[inPos + 43] - in[inPos + 42] >>> 45 | in[inPos + 44] - in[inPos + 43] << 12;
        out[outPos + 40] = in[inPos + 44] - in[inPos + 43] >>> 52 | in[inPos + 45] - in[inPos + 44] << 5 | in[inPos + 46] - in[inPos + 45] << 62;
        out[outPos + 41] = in[inPos + 46] - in[inPos + 45] >>> 2 | in[inPos + 47] - in[inPos + 46] << 55;
        out[outPos + 42] = in[inPos + 47] - in[inPos + 46] >>> 9 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 43] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 41;
        out[outPos + 44] = in[inPos + 49] - in[inPos + 48] >>> 23 | in[inPos + 50] - in[inPos + 49] << 34;
        out[outPos + 45] = in[inPos + 50] - in[inPos + 49] >>> 30 | in[inPos + 51] - in[inPos + 50] << 27;
        out[outPos + 46] = in[inPos + 51] - in[inPos + 50] >>> 37 | in[inPos + 52] - in[inPos + 51] << 20;
        out[outPos + 47] = in[inPos + 52] - in[inPos + 51] >>> 44 | in[inPos + 53] - in[inPos + 52] << 13;
        out[outPos + 48] = in[inPos + 53] - in[inPos + 52] >>> 51 | in[inPos + 54] - in[inPos + 53] << 6 | in[inPos + 55] - in[inPos + 54] << 63;
        out[outPos + 49] = in[inPos + 55] - in[inPos + 54] >>> 1 | in[inPos + 56] - in[inPos + 55] << 56;
        out[outPos + 50] = in[inPos + 56] - in[inPos + 55] >>> 8 | in[inPos + 57] - in[inPos + 56] << 49;
        out[outPos + 51] = in[inPos + 57] - in[inPos + 56] >>> 15 | in[inPos + 58] - in[inPos + 57] << 42;
        out[outPos + 52] = in[inPos + 58] - in[inPos + 57] >>> 22 | in[inPos + 59] - in[inPos + 58] << 35;
        out[outPos + 53] = in[inPos + 59] - in[inPos + 58] >>> 29 | in[inPos + 60] - in[inPos + 59] << 28;
        out[outPos + 54] = in[inPos + 60] - in[inPos + 59] >>> 36 | in[inPos + 61] - in[inPos + 60] << 21;
        out[outPos + 55] = in[inPos + 61] - in[inPos + 60] >>> 43 | in[inPos + 62] - in[inPos + 61] << 14;
        out[outPos + 56] = in[inPos + 62] - in[inPos + 61] >>> 50 | in[inPos + 63] - in[inPos + 62] << 7;
    }

    private static void unpack57(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 57 | (in[inPos + 1] & 0x3FFFFFFFFFFFFL) << 7) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 50 | (in[inPos + 2] & 0x7FFFFFFFFFFL) << 14) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 43 | (in[inPos + 3] & 0xFFFFFFFFFL) << 21) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 36 | (in[inPos + 4] & 0x1FFFFFFFL) << 28) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 29 | (in[inPos + 5] & 0x3FFFFFL) << 35) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 22 | (in[inPos + 6] & 0x7FFFL) << 42) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 15 | (in[inPos + 7] & 0xFFL) << 49) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 8 | (in[inPos + 8] & 1L) << 56) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 1 & 0x1FFFFFFFFFFFFFFL) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 8] >>> 58 | (in[inPos + 9] & 0x7FFFFFFFFFFFFL) << 6) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 51 | (in[inPos + 10] & 0xFFFFFFFFFFFL) << 13) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 44 | (in[inPos + 11] & 0x1FFFFFFFFFL) << 20) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 11] >>> 37 | (in[inPos + 12] & 0x3FFFFFFFL) << 27) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 12] >>> 30 | (in[inPos + 13] & 0x7FFFFFL) << 34) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 13] >>> 23 | (in[inPos + 14] & 0xFFFFL) << 41) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 14] >>> 16 | (in[inPos + 15] & 0x1FFL) << 48) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 15] >>> 9 | (in[inPos + 16] & 3L) << 55) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 16] >>> 2 & 0x1FFFFFFFFFFFFFFL) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 16] >>> 59 | (in[inPos + 17] & 0xFFFFFFFFFFFFFL) << 5) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 17] >>> 52 | (in[inPos + 18] & 0x1FFFFFFFFFFFL) << 12) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 18] >>> 45 | (in[inPos + 19] & 0x3FFFFFFFFFL) << 19) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 19] >>> 38 | (in[inPos + 20] & Integer.MAX_VALUE) << 26) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 20] >>> 31 | (in[inPos + 21] & 0xFFFFFFL) << 33) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 21] >>> 24 | (in[inPos + 22] & 0x1FFFFL) << 40) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 22] >>> 17 | (in[inPos + 23] & 0x3FFL) << 47) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 23] >>> 10 | (in[inPos + 24] & 7L) << 54) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 24] >>> 3 & 0x1FFFFFFFFFFFFFFL) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 24] >>> 60 | (in[inPos + 25] & 0x1FFFFFFFFFFFFFL) << 4) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 25] >>> 53 | (in[inPos + 26] & 0x3FFFFFFFFFFFL) << 11) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 26] >>> 46 | (in[inPos + 27] & 0x7FFFFFFFFFL) << 18) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 27] >>> 39 | (in[inPos + 28] & 0xFFFFFFFFL) << 25) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 28] >>> 32 | (in[inPos + 29] & 0x1FFFFFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 29] >>> 25 | (in[inPos + 30] & 0x3FFFFL) << 39) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 30] >>> 18 | (in[inPos + 31] & 0x7FFL) << 46) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 31] >>> 11 | (in[inPos + 32] & 0xFL) << 53) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 32] >>> 4 & 0x1FFFFFFFFFFFFFFL) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 32] >>> 61 | (in[inPos + 33] & 0x3FFFFFFFFFFFFFL) << 3) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 33] >>> 54 | (in[inPos + 34] & 0x7FFFFFFFFFFFL) << 10) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 34] >>> 47 | (in[inPos + 35] & 0xFFFFFFFFFFL) << 17) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 35] >>> 40 | (in[inPos + 36] & 0x1FFFFFFFFL) << 24) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 36] >>> 33 | (in[inPos + 37] & 0x3FFFFFFL) << 31) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 37] >>> 26 | (in[inPos + 38] & 0x7FFFFL) << 38) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 38] >>> 19 | (in[inPos + 39] & 0xFFFL) << 45) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 39] >>> 12 | (in[inPos + 40] & 0x1FL) << 52) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 40] >>> 5 & 0x1FFFFFFFFFFFFFFL) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 40] >>> 62 | (in[inPos + 41] & 0x7FFFFFFFFFFFFFL) << 2) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 41] >>> 55 | (in[inPos + 42] & 0xFFFFFFFFFFFFL) << 9) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 42] >>> 48 | (in[inPos + 43] & 0x1FFFFFFFFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 43] >>> 41 | (in[inPos + 44] & 0x3FFFFFFFFL) << 23) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 44] >>> 34 | (in[inPos + 45] & 0x7FFFFFFL) << 30) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 45] >>> 27 | (in[inPos + 46] & 0xFFFFFL) << 37) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 46] >>> 20 | (in[inPos + 47] & 0x1FFFL) << 44) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 47] >>> 13 | (in[inPos + 48] & 0x3FL) << 51) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 48] >>> 6 & 0x1FFFFFFFFFFFFFFL) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 48] >>> 63 | (in[inPos + 49] & 0xFFFFFFFFFFFFFFL) << 1) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 49] >>> 56 | (in[inPos + 50] & 0x1FFFFFFFFFFFFL) << 8) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 50] >>> 49 | (in[inPos + 51] & 0x3FFFFFFFFFFL) << 15) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 51] >>> 42 | (in[inPos + 52] & 0x7FFFFFFFFL) << 22) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 52] >>> 35 | (in[inPos + 53] & 0xFFFFFFFL) << 29) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 53] >>> 28 | (in[inPos + 54] & 0x1FFFFFL) << 36) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 54] >>> 21 | (in[inPos + 55] & 0x3FFFL) << 43) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 55] >>> 14 | (in[inPos + 56] & 0x7FL) << 50) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 56] >>> 7) + out[outPos + 62];
    }

    private static void pack58(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 58;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 6 | in[inPos + 2] - in[inPos + 1] << 52;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 12 | in[inPos + 3] - in[inPos + 2] << 46;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 18 | in[inPos + 4] - in[inPos + 3] << 40;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 24 | in[inPos + 5] - in[inPos + 4] << 34;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 30 | in[inPos + 6] - in[inPos + 5] << 28;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 36 | in[inPos + 7] - in[inPos + 6] << 22;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 42 | in[inPos + 8] - in[inPos + 7] << 16;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 48 | in[inPos + 9] - in[inPos + 8] << 10;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 54 | in[inPos + 10] - in[inPos + 9] << 4 | in[inPos + 11] - in[inPos + 10] << 62;
        out[outPos + 10] = in[inPos + 11] - in[inPos + 10] >>> 2 | in[inPos + 12] - in[inPos + 11] << 56;
        out[outPos + 11] = in[inPos + 12] - in[inPos + 11] >>> 8 | in[inPos + 13] - in[inPos + 12] << 50;
        out[outPos + 12] = in[inPos + 13] - in[inPos + 12] >>> 14 | in[inPos + 14] - in[inPos + 13] << 44;
        out[outPos + 13] = in[inPos + 14] - in[inPos + 13] >>> 20 | in[inPos + 15] - in[inPos + 14] << 38;
        out[outPos + 14] = in[inPos + 15] - in[inPos + 14] >>> 26 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 15] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 26;
        out[outPos + 16] = in[inPos + 17] - in[inPos + 16] >>> 38 | in[inPos + 18] - in[inPos + 17] << 20;
        out[outPos + 17] = in[inPos + 18] - in[inPos + 17] >>> 44 | in[inPos + 19] - in[inPos + 18] << 14;
        out[outPos + 18] = in[inPos + 19] - in[inPos + 18] >>> 50 | in[inPos + 20] - in[inPos + 19] << 8;
        out[outPos + 19] = in[inPos + 20] - in[inPos + 19] >>> 56 | in[inPos + 21] - in[inPos + 20] << 2 | in[inPos + 22] - in[inPos + 21] << 60;
        out[outPos + 20] = in[inPos + 22] - in[inPos + 21] >>> 4 | in[inPos + 23] - in[inPos + 22] << 54;
        out[outPos + 21] = in[inPos + 23] - in[inPos + 22] >>> 10 | in[inPos + 24] - in[inPos + 23] << 48;
        out[outPos + 22] = in[inPos + 24] - in[inPos + 23] >>> 16 | in[inPos + 25] - in[inPos + 24] << 42;
        out[outPos + 23] = in[inPos + 25] - in[inPos + 24] >>> 22 | in[inPos + 26] - in[inPos + 25] << 36;
        out[outPos + 24] = in[inPos + 26] - in[inPos + 25] >>> 28 | in[inPos + 27] - in[inPos + 26] << 30;
        out[outPos + 25] = in[inPos + 27] - in[inPos + 26] >>> 34 | in[inPos + 28] - in[inPos + 27] << 24;
        out[outPos + 26] = in[inPos + 28] - in[inPos + 27] >>> 40 | in[inPos + 29] - in[inPos + 28] << 18;
        out[outPos + 27] = in[inPos + 29] - in[inPos + 28] >>> 46 | in[inPos + 30] - in[inPos + 29] << 12;
        out[outPos + 28] = in[inPos + 30] - in[inPos + 29] >>> 52 | in[inPos + 31] - in[inPos + 30] << 6;
        out[outPos + 29] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 58;
        out[outPos + 30] = in[inPos + 33] - in[inPos + 32] >>> 6 | in[inPos + 34] - in[inPos + 33] << 52;
        out[outPos + 31] = in[inPos + 34] - in[inPos + 33] >>> 12 | in[inPos + 35] - in[inPos + 34] << 46;
        out[outPos + 32] = in[inPos + 35] - in[inPos + 34] >>> 18 | in[inPos + 36] - in[inPos + 35] << 40;
        out[outPos + 33] = in[inPos + 36] - in[inPos + 35] >>> 24 | in[inPos + 37] - in[inPos + 36] << 34;
        out[outPos + 34] = in[inPos + 37] - in[inPos + 36] >>> 30 | in[inPos + 38] - in[inPos + 37] << 28;
        out[outPos + 35] = in[inPos + 38] - in[inPos + 37] >>> 36 | in[inPos + 39] - in[inPos + 38] << 22;
        out[outPos + 36] = in[inPos + 39] - in[inPos + 38] >>> 42 | in[inPos + 40] - in[inPos + 39] << 16;
        out[outPos + 37] = in[inPos + 40] - in[inPos + 39] >>> 48 | in[inPos + 41] - in[inPos + 40] << 10;
        out[outPos + 38] = in[inPos + 41] - in[inPos + 40] >>> 54 | in[inPos + 42] - in[inPos + 41] << 4 | in[inPos + 43] - in[inPos + 42] << 62;
        out[outPos + 39] = in[inPos + 43] - in[inPos + 42] >>> 2 | in[inPos + 44] - in[inPos + 43] << 56;
        out[outPos + 40] = in[inPos + 44] - in[inPos + 43] >>> 8 | in[inPos + 45] - in[inPos + 44] << 50;
        out[outPos + 41] = in[inPos + 45] - in[inPos + 44] >>> 14 | in[inPos + 46] - in[inPos + 45] << 44;
        out[outPos + 42] = in[inPos + 46] - in[inPos + 45] >>> 20 | in[inPos + 47] - in[inPos + 46] << 38;
        out[outPos + 43] = in[inPos + 47] - in[inPos + 46] >>> 26 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 44] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 26;
        out[outPos + 45] = in[inPos + 49] - in[inPos + 48] >>> 38 | in[inPos + 50] - in[inPos + 49] << 20;
        out[outPos + 46] = in[inPos + 50] - in[inPos + 49] >>> 44 | in[inPos + 51] - in[inPos + 50] << 14;
        out[outPos + 47] = in[inPos + 51] - in[inPos + 50] >>> 50 | in[inPos + 52] - in[inPos + 51] << 8;
        out[outPos + 48] = in[inPos + 52] - in[inPos + 51] >>> 56 | in[inPos + 53] - in[inPos + 52] << 2 | in[inPos + 54] - in[inPos + 53] << 60;
        out[outPos + 49] = in[inPos + 54] - in[inPos + 53] >>> 4 | in[inPos + 55] - in[inPos + 54] << 54;
        out[outPos + 50] = in[inPos + 55] - in[inPos + 54] >>> 10 | in[inPos + 56] - in[inPos + 55] << 48;
        out[outPos + 51] = in[inPos + 56] - in[inPos + 55] >>> 16 | in[inPos + 57] - in[inPos + 56] << 42;
        out[outPos + 52] = in[inPos + 57] - in[inPos + 56] >>> 22 | in[inPos + 58] - in[inPos + 57] << 36;
        out[outPos + 53] = in[inPos + 58] - in[inPos + 57] >>> 28 | in[inPos + 59] - in[inPos + 58] << 30;
        out[outPos + 54] = in[inPos + 59] - in[inPos + 58] >>> 34 | in[inPos + 60] - in[inPos + 59] << 24;
        out[outPos + 55] = in[inPos + 60] - in[inPos + 59] >>> 40 | in[inPos + 61] - in[inPos + 60] << 18;
        out[outPos + 56] = in[inPos + 61] - in[inPos + 60] >>> 46 | in[inPos + 62] - in[inPos + 61] << 12;
        out[outPos + 57] = in[inPos + 62] - in[inPos + 61] >>> 52 | in[inPos + 63] - in[inPos + 62] << 6;
    }

    private static void unpack58(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 58 | (in[inPos + 1] & 0xFFFFFFFFFFFFFL) << 6) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 52 | (in[inPos + 2] & 0x3FFFFFFFFFFFL) << 12) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 46 | (in[inPos + 3] & 0xFFFFFFFFFFL) << 18) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 40 | (in[inPos + 4] & 0x3FFFFFFFFL) << 24) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 34 | (in[inPos + 5] & 0xFFFFFFFL) << 30) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 28 | (in[inPos + 6] & 0x3FFFFFL) << 36) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 22 | (in[inPos + 7] & 0xFFFFL) << 42) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 16 | (in[inPos + 8] & 0x3FFL) << 48) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 10 | (in[inPos + 9] & 0xFL) << 54) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 4 & 0x3FFFFFFFFFFFFFFL) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 9] >>> 62 | (in[inPos + 10] & 0xFFFFFFFFFFFFFFL) << 2) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 10] >>> 56 | (in[inPos + 11] & 0x3FFFFFFFFFFFFL) << 8) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 11] >>> 50 | (in[inPos + 12] & 0xFFFFFFFFFFFL) << 14) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 12] >>> 44 | (in[inPos + 13] & 0x3FFFFFFFFFL) << 20) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 13] >>> 38 | (in[inPos + 14] & 0xFFFFFFFFL) << 26) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 14] >>> 32 | (in[inPos + 15] & 0x3FFFFFFL) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 15] >>> 26 | (in[inPos + 16] & 0xFFFFFL) << 38) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 16] >>> 20 | (in[inPos + 17] & 0x3FFFL) << 44) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 17] >>> 14 | (in[inPos + 18] & 0xFFL) << 50) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 18] >>> 8 | (in[inPos + 19] & 3L) << 56) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 19] >>> 2 & 0x3FFFFFFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 19] >>> 60 | (in[inPos + 20] & 0x3FFFFFFFFFFFFFL) << 4) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 20] >>> 54 | (in[inPos + 21] & 0xFFFFFFFFFFFFL) << 10) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 21] >>> 48 | (in[inPos + 22] & 0x3FFFFFFFFFFL) << 16) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 22] >>> 42 | (in[inPos + 23] & 0xFFFFFFFFFL) << 22) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 23] >>> 36 | (in[inPos + 24] & 0x3FFFFFFFL) << 28) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 24] >>> 30 | (in[inPos + 25] & 0xFFFFFFL) << 34) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 25] >>> 24 | (in[inPos + 26] & 0x3FFFFL) << 40) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 26] >>> 18 | (in[inPos + 27] & 0xFFFL) << 46) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 27] >>> 12 | (in[inPos + 28] & 0x3FL) << 52) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 28] >>> 6) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 29] & 0x3FFFFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 29] >>> 58 | (in[inPos + 30] & 0xFFFFFFFFFFFFFL) << 6) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 30] >>> 52 | (in[inPos + 31] & 0x3FFFFFFFFFFFL) << 12) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 31] >>> 46 | (in[inPos + 32] & 0xFFFFFFFFFFL) << 18) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 32] >>> 40 | (in[inPos + 33] & 0x3FFFFFFFFL) << 24) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 33] >>> 34 | (in[inPos + 34] & 0xFFFFFFFL) << 30) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 34] >>> 28 | (in[inPos + 35] & 0x3FFFFFL) << 36) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 35] >>> 22 | (in[inPos + 36] & 0xFFFFL) << 42) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 36] >>> 16 | (in[inPos + 37] & 0x3FFL) << 48) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 37] >>> 10 | (in[inPos + 38] & 0xFL) << 54) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 38] >>> 4 & 0x3FFFFFFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 38] >>> 62 | (in[inPos + 39] & 0xFFFFFFFFFFFFFFL) << 2) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 39] >>> 56 | (in[inPos + 40] & 0x3FFFFFFFFFFFFL) << 8) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 40] >>> 50 | (in[inPos + 41] & 0xFFFFFFFFFFFL) << 14) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 41] >>> 44 | (in[inPos + 42] & 0x3FFFFFFFFFL) << 20) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 42] >>> 38 | (in[inPos + 43] & 0xFFFFFFFFL) << 26) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 43] >>> 32 | (in[inPos + 44] & 0x3FFFFFFL) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 44] >>> 26 | (in[inPos + 45] & 0xFFFFFL) << 38) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 45] >>> 20 | (in[inPos + 46] & 0x3FFFL) << 44) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 46] >>> 14 | (in[inPos + 47] & 0xFFL) << 50) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 47] >>> 8 | (in[inPos + 48] & 3L) << 56) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 48] >>> 2 & 0x3FFFFFFFFFFFFFFL) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 48] >>> 60 | (in[inPos + 49] & 0x3FFFFFFFFFFFFFL) << 4) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 49] >>> 54 | (in[inPos + 50] & 0xFFFFFFFFFFFFL) << 10) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 50] >>> 48 | (in[inPos + 51] & 0x3FFFFFFFFFFL) << 16) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 51] >>> 42 | (in[inPos + 52] & 0xFFFFFFFFFL) << 22) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 52] >>> 36 | (in[inPos + 53] & 0x3FFFFFFFL) << 28) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 53] >>> 30 | (in[inPos + 54] & 0xFFFFFFL) << 34) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 54] >>> 24 | (in[inPos + 55] & 0x3FFFFL) << 40) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 55] >>> 18 | (in[inPos + 56] & 0xFFFL) << 46) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 56] >>> 12 | (in[inPos + 57] & 0x3FL) << 52) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 57] >>> 6) + out[outPos + 62];
    }

    private static void pack59(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 59;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 5 | in[inPos + 2] - in[inPos + 1] << 54;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 10 | in[inPos + 3] - in[inPos + 2] << 49;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 15 | in[inPos + 4] - in[inPos + 3] << 44;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 20 | in[inPos + 5] - in[inPos + 4] << 39;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 25 | in[inPos + 6] - in[inPos + 5] << 34;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 30 | in[inPos + 7] - in[inPos + 6] << 29;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 35 | in[inPos + 8] - in[inPos + 7] << 24;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 40 | in[inPos + 9] - in[inPos + 8] << 19;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 45 | in[inPos + 10] - in[inPos + 9] << 14;
        out[outPos + 10] = in[inPos + 10] - in[inPos + 9] >>> 50 | in[inPos + 11] - in[inPos + 10] << 9;
        out[outPos + 11] = in[inPos + 11] - in[inPos + 10] >>> 55 | in[inPos + 12] - in[inPos + 11] << 4 | in[inPos + 13] - in[inPos + 12] << 63;
        out[outPos + 12] = in[inPos + 13] - in[inPos + 12] >>> 1 | in[inPos + 14] - in[inPos + 13] << 58;
        out[outPos + 13] = in[inPos + 14] - in[inPos + 13] >>> 6 | in[inPos + 15] - in[inPos + 14] << 53;
        out[outPos + 14] = in[inPos + 15] - in[inPos + 14] >>> 11 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 15] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 43;
        out[outPos + 16] = in[inPos + 17] - in[inPos + 16] >>> 21 | in[inPos + 18] - in[inPos + 17] << 38;
        out[outPos + 17] = in[inPos + 18] - in[inPos + 17] >>> 26 | in[inPos + 19] - in[inPos + 18] << 33;
        out[outPos + 18] = in[inPos + 19] - in[inPos + 18] >>> 31 | in[inPos + 20] - in[inPos + 19] << 28;
        out[outPos + 19] = in[inPos + 20] - in[inPos + 19] >>> 36 | in[inPos + 21] - in[inPos + 20] << 23;
        out[outPos + 20] = in[inPos + 21] - in[inPos + 20] >>> 41 | in[inPos + 22] - in[inPos + 21] << 18;
        out[outPos + 21] = in[inPos + 22] - in[inPos + 21] >>> 46 | in[inPos + 23] - in[inPos + 22] << 13;
        out[outPos + 22] = in[inPos + 23] - in[inPos + 22] >>> 51 | in[inPos + 24] - in[inPos + 23] << 8;
        out[outPos + 23] = in[inPos + 24] - in[inPos + 23] >>> 56 | in[inPos + 25] - in[inPos + 24] << 3 | in[inPos + 26] - in[inPos + 25] << 62;
        out[outPos + 24] = in[inPos + 26] - in[inPos + 25] >>> 2 | in[inPos + 27] - in[inPos + 26] << 57;
        out[outPos + 25] = in[inPos + 27] - in[inPos + 26] >>> 7 | in[inPos + 28] - in[inPos + 27] << 52;
        out[outPos + 26] = in[inPos + 28] - in[inPos + 27] >>> 12 | in[inPos + 29] - in[inPos + 28] << 47;
        out[outPos + 27] = in[inPos + 29] - in[inPos + 28] >>> 17 | in[inPos + 30] - in[inPos + 29] << 42;
        out[outPos + 28] = in[inPos + 30] - in[inPos + 29] >>> 22 | in[inPos + 31] - in[inPos + 30] << 37;
        out[outPos + 29] = in[inPos + 31] - in[inPos + 30] >>> 27 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 30] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 27;
        out[outPos + 31] = in[inPos + 33] - in[inPos + 32] >>> 37 | in[inPos + 34] - in[inPos + 33] << 22;
        out[outPos + 32] = in[inPos + 34] - in[inPos + 33] >>> 42 | in[inPos + 35] - in[inPos + 34] << 17;
        out[outPos + 33] = in[inPos + 35] - in[inPos + 34] >>> 47 | in[inPos + 36] - in[inPos + 35] << 12;
        out[outPos + 34] = in[inPos + 36] - in[inPos + 35] >>> 52 | in[inPos + 37] - in[inPos + 36] << 7;
        out[outPos + 35] = in[inPos + 37] - in[inPos + 36] >>> 57 | in[inPos + 38] - in[inPos + 37] << 2 | in[inPos + 39] - in[inPos + 38] << 61;
        out[outPos + 36] = in[inPos + 39] - in[inPos + 38] >>> 3 | in[inPos + 40] - in[inPos + 39] << 56;
        out[outPos + 37] = in[inPos + 40] - in[inPos + 39] >>> 8 | in[inPos + 41] - in[inPos + 40] << 51;
        out[outPos + 38] = in[inPos + 41] - in[inPos + 40] >>> 13 | in[inPos + 42] - in[inPos + 41] << 46;
        out[outPos + 39] = in[inPos + 42] - in[inPos + 41] >>> 18 | in[inPos + 43] - in[inPos + 42] << 41;
        out[outPos + 40] = in[inPos + 43] - in[inPos + 42] >>> 23 | in[inPos + 44] - in[inPos + 43] << 36;
        out[outPos + 41] = in[inPos + 44] - in[inPos + 43] >>> 28 | in[inPos + 45] - in[inPos + 44] << 31;
        out[outPos + 42] = in[inPos + 45] - in[inPos + 44] >>> 33 | in[inPos + 46] - in[inPos + 45] << 26;
        out[outPos + 43] = in[inPos + 46] - in[inPos + 45] >>> 38 | in[inPos + 47] - in[inPos + 46] << 21;
        out[outPos + 44] = in[inPos + 47] - in[inPos + 46] >>> 43 | in[inPos + 48] - in[inPos + 47] << 16;
        out[outPos + 45] = in[inPos + 48] - in[inPos + 47] >>> 48 | in[inPos + 49] - in[inPos + 48] << 11;
        out[outPos + 46] = in[inPos + 49] - in[inPos + 48] >>> 53 | in[inPos + 50] - in[inPos + 49] << 6;
        out[outPos + 47] = in[inPos + 50] - in[inPos + 49] >>> 58 | in[inPos + 51] - in[inPos + 50] << 1 | in[inPos + 52] - in[inPos + 51] << 60;
        out[outPos + 48] = in[inPos + 52] - in[inPos + 51] >>> 4 | in[inPos + 53] - in[inPos + 52] << 55;
        out[outPos + 49] = in[inPos + 53] - in[inPos + 52] >>> 9 | in[inPos + 54] - in[inPos + 53] << 50;
        out[outPos + 50] = in[inPos + 54] - in[inPos + 53] >>> 14 | in[inPos + 55] - in[inPos + 54] << 45;
        out[outPos + 51] = in[inPos + 55] - in[inPos + 54] >>> 19 | in[inPos + 56] - in[inPos + 55] << 40;
        out[outPos + 52] = in[inPos + 56] - in[inPos + 55] >>> 24 | in[inPos + 57] - in[inPos + 56] << 35;
        out[outPos + 53] = in[inPos + 57] - in[inPos + 56] >>> 29 | in[inPos + 58] - in[inPos + 57] << 30;
        out[outPos + 54] = in[inPos + 58] - in[inPos + 57] >>> 34 | in[inPos + 59] - in[inPos + 58] << 25;
        out[outPos + 55] = in[inPos + 59] - in[inPos + 58] >>> 39 | in[inPos + 60] - in[inPos + 59] << 20;
        out[outPos + 56] = in[inPos + 60] - in[inPos + 59] >>> 44 | in[inPos + 61] - in[inPos + 60] << 15;
        out[outPos + 57] = in[inPos + 61] - in[inPos + 60] >>> 49 | in[inPos + 62] - in[inPos + 61] << 10;
        out[outPos + 58] = in[inPos + 62] - in[inPos + 61] >>> 54 | in[inPos + 63] - in[inPos + 62] << 5;
    }

    private static void unpack59(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x7FFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 59 | (in[inPos + 1] & 0x3FFFFFFFFFFFFFL) << 5) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 54 | (in[inPos + 2] & 0x1FFFFFFFFFFFFL) << 10) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 49 | (in[inPos + 3] & 0xFFFFFFFFFFFL) << 15) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 44 | (in[inPos + 4] & 0x7FFFFFFFFFL) << 20) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 39 | (in[inPos + 5] & 0x3FFFFFFFFL) << 25) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 34 | (in[inPos + 6] & 0x1FFFFFFFL) << 30) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 29 | (in[inPos + 7] & 0xFFFFFFL) << 35) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 24 | (in[inPos + 8] & 0x7FFFFL) << 40) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 19 | (in[inPos + 9] & 0x3FFFL) << 45) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 14 | (in[inPos + 10] & 0x1FFL) << 50) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 10] >>> 9 | (in[inPos + 11] & 0xFL) << 55) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 11] >>> 4 & 0x7FFFFFFFFFFFFFFL) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 11] >>> 63 | (in[inPos + 12] & 0x3FFFFFFFFFFFFFFL) << 1) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 12] >>> 58 | (in[inPos + 13] & 0x1FFFFFFFFFFFFFL) << 6) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 13] >>> 53 | (in[inPos + 14] & 0xFFFFFFFFFFFFL) << 11) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 14] >>> 48 | (in[inPos + 15] & 0x7FFFFFFFFFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 15] >>> 43 | (in[inPos + 16] & 0x3FFFFFFFFFL) << 21) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 16] >>> 38 | (in[inPos + 17] & 0x1FFFFFFFFL) << 26) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 17] >>> 33 | (in[inPos + 18] & 0xFFFFFFFL) << 31) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 18] >>> 28 | (in[inPos + 19] & 0x7FFFFFL) << 36) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 19] >>> 23 | (in[inPos + 20] & 0x3FFFFL) << 41) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 20] >>> 18 | (in[inPos + 21] & 0x1FFFL) << 46) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 21] >>> 13 | (in[inPos + 22] & 0xFFL) << 51) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 22] >>> 8 | (in[inPos + 23] & 7L) << 56) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 23] >>> 3 & 0x7FFFFFFFFFFFFFFL) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 23] >>> 62 | (in[inPos + 24] & 0x1FFFFFFFFFFFFFFL) << 2) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 24] >>> 57 | (in[inPos + 25] & 0xFFFFFFFFFFFFFL) << 7) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 25] >>> 52 | (in[inPos + 26] & 0x7FFFFFFFFFFFL) << 12) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 26] >>> 47 | (in[inPos + 27] & 0x3FFFFFFFFFFL) << 17) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 27] >>> 42 | (in[inPos + 28] & 0x1FFFFFFFFFL) << 22) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 28] >>> 37 | (in[inPos + 29] & 0xFFFFFFFFL) << 27) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 29] >>> 32 | (in[inPos + 30] & 0x7FFFFFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 30] >>> 27 | (in[inPos + 31] & 0x3FFFFFL) << 37) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 31] >>> 22 | (in[inPos + 32] & 0x1FFFFL) << 42) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 32] >>> 17 | (in[inPos + 33] & 0xFFFL) << 47) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 33] >>> 12 | (in[inPos + 34] & 0x7FL) << 52) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 34] >>> 7 | (in[inPos + 35] & 3L) << 57) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 35] >>> 2 & 0x7FFFFFFFFFFFFFFL) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 35] >>> 61 | (in[inPos + 36] & 0xFFFFFFFFFFFFFFL) << 3) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 36] >>> 56 | (in[inPos + 37] & 0x7FFFFFFFFFFFFL) << 8) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 37] >>> 51 | (in[inPos + 38] & 0x3FFFFFFFFFFFL) << 13) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 38] >>> 46 | (in[inPos + 39] & 0x1FFFFFFFFFFL) << 18) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 39] >>> 41 | (in[inPos + 40] & 0xFFFFFFFFFL) << 23) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 40] >>> 36 | (in[inPos + 41] & Integer.MAX_VALUE) << 28) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 41] >>> 31 | (in[inPos + 42] & 0x3FFFFFFL) << 33) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 42] >>> 26 | (in[inPos + 43] & 0x1FFFFFL) << 38) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 43] >>> 21 | (in[inPos + 44] & 0xFFFFL) << 43) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 44] >>> 16 | (in[inPos + 45] & 0x7FFL) << 48) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 45] >>> 11 | (in[inPos + 46] & 0x3FL) << 53) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 46] >>> 6 | (in[inPos + 47] & 1L) << 58) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 47] >>> 1 & 0x7FFFFFFFFFFFFFFL) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 47] >>> 60 | (in[inPos + 48] & 0x7FFFFFFFFFFFFFL) << 4) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 48] >>> 55 | (in[inPos + 49] & 0x3FFFFFFFFFFFFL) << 9) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 49] >>> 50 | (in[inPos + 50] & 0x1FFFFFFFFFFFL) << 14) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 50] >>> 45 | (in[inPos + 51] & 0xFFFFFFFFFFL) << 19) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 51] >>> 40 | (in[inPos + 52] & 0x7FFFFFFFFL) << 24) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 52] >>> 35 | (in[inPos + 53] & 0x3FFFFFFFL) << 29) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 53] >>> 30 | (in[inPos + 54] & 0x1FFFFFFL) << 34) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 54] >>> 25 | (in[inPos + 55] & 0xFFFFFL) << 39) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 55] >>> 20 | (in[inPos + 56] & 0x7FFFL) << 44) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 56] >>> 15 | (in[inPos + 57] & 0x3FFL) << 49) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 57] >>> 10 | (in[inPos + 58] & 0x1FL) << 54) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 58] >>> 5) + out[outPos + 62];
    }

    private static void pack60(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 60;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 4 | in[inPos + 2] - in[inPos + 1] << 56;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 8 | in[inPos + 3] - in[inPos + 2] << 52;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 12 | in[inPos + 4] - in[inPos + 3] << 48;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 16 | in[inPos + 5] - in[inPos + 4] << 44;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 20 | in[inPos + 6] - in[inPos + 5] << 40;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 24 | in[inPos + 7] - in[inPos + 6] << 36;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 28 | in[inPos + 8] - in[inPos + 7] << 32;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 32 | in[inPos + 9] - in[inPos + 8] << 28;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 36 | in[inPos + 10] - in[inPos + 9] << 24;
        out[outPos + 10] = in[inPos + 10] - in[inPos + 9] >>> 40 | in[inPos + 11] - in[inPos + 10] << 20;
        out[outPos + 11] = in[inPos + 11] - in[inPos + 10] >>> 44 | in[inPos + 12] - in[inPos + 11] << 16;
        out[outPos + 12] = in[inPos + 12] - in[inPos + 11] >>> 48 | in[inPos + 13] - in[inPos + 12] << 12;
        out[outPos + 13] = in[inPos + 13] - in[inPos + 12] >>> 52 | in[inPos + 14] - in[inPos + 13] << 8;
        out[outPos + 14] = in[inPos + 14] - in[inPos + 13] >>> 56 | in[inPos + 15] - in[inPos + 14] << 4;
        out[outPos + 15] = in[inPos + 16] - in[inPos + 15] | in[inPos + 17] - in[inPos + 16] << 60;
        out[outPos + 16] = in[inPos + 17] - in[inPos + 16] >>> 4 | in[inPos + 18] - in[inPos + 17] << 56;
        out[outPos + 17] = in[inPos + 18] - in[inPos + 17] >>> 8 | in[inPos + 19] - in[inPos + 18] << 52;
        out[outPos + 18] = in[inPos + 19] - in[inPos + 18] >>> 12 | in[inPos + 20] - in[inPos + 19] << 48;
        out[outPos + 19] = in[inPos + 20] - in[inPos + 19] >>> 16 | in[inPos + 21] - in[inPos + 20] << 44;
        out[outPos + 20] = in[inPos + 21] - in[inPos + 20] >>> 20 | in[inPos + 22] - in[inPos + 21] << 40;
        out[outPos + 21] = in[inPos + 22] - in[inPos + 21] >>> 24 | in[inPos + 23] - in[inPos + 22] << 36;
        out[outPos + 22] = in[inPos + 23] - in[inPos + 22] >>> 28 | in[inPos + 24] - in[inPos + 23] << 32;
        out[outPos + 23] = in[inPos + 24] - in[inPos + 23] >>> 32 | in[inPos + 25] - in[inPos + 24] << 28;
        out[outPos + 24] = in[inPos + 25] - in[inPos + 24] >>> 36 | in[inPos + 26] - in[inPos + 25] << 24;
        out[outPos + 25] = in[inPos + 26] - in[inPos + 25] >>> 40 | in[inPos + 27] - in[inPos + 26] << 20;
        out[outPos + 26] = in[inPos + 27] - in[inPos + 26] >>> 44 | in[inPos + 28] - in[inPos + 27] << 16;
        out[outPos + 27] = in[inPos + 28] - in[inPos + 27] >>> 48 | in[inPos + 29] - in[inPos + 28] << 12;
        out[outPos + 28] = in[inPos + 29] - in[inPos + 28] >>> 52 | in[inPos + 30] - in[inPos + 29] << 8;
        out[outPos + 29] = in[inPos + 30] - in[inPos + 29] >>> 56 | in[inPos + 31] - in[inPos + 30] << 4;
        out[outPos + 30] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 60;
        out[outPos + 31] = in[inPos + 33] - in[inPos + 32] >>> 4 | in[inPos + 34] - in[inPos + 33] << 56;
        out[outPos + 32] = in[inPos + 34] - in[inPos + 33] >>> 8 | in[inPos + 35] - in[inPos + 34] << 52;
        out[outPos + 33] = in[inPos + 35] - in[inPos + 34] >>> 12 | in[inPos + 36] - in[inPos + 35] << 48;
        out[outPos + 34] = in[inPos + 36] - in[inPos + 35] >>> 16 | in[inPos + 37] - in[inPos + 36] << 44;
        out[outPos + 35] = in[inPos + 37] - in[inPos + 36] >>> 20 | in[inPos + 38] - in[inPos + 37] << 40;
        out[outPos + 36] = in[inPos + 38] - in[inPos + 37] >>> 24 | in[inPos + 39] - in[inPos + 38] << 36;
        out[outPos + 37] = in[inPos + 39] - in[inPos + 38] >>> 28 | in[inPos + 40] - in[inPos + 39] << 32;
        out[outPos + 38] = in[inPos + 40] - in[inPos + 39] >>> 32 | in[inPos + 41] - in[inPos + 40] << 28;
        out[outPos + 39] = in[inPos + 41] - in[inPos + 40] >>> 36 | in[inPos + 42] - in[inPos + 41] << 24;
        out[outPos + 40] = in[inPos + 42] - in[inPos + 41] >>> 40 | in[inPos + 43] - in[inPos + 42] << 20;
        out[outPos + 41] = in[inPos + 43] - in[inPos + 42] >>> 44 | in[inPos + 44] - in[inPos + 43] << 16;
        out[outPos + 42] = in[inPos + 44] - in[inPos + 43] >>> 48 | in[inPos + 45] - in[inPos + 44] << 12;
        out[outPos + 43] = in[inPos + 45] - in[inPos + 44] >>> 52 | in[inPos + 46] - in[inPos + 45] << 8;
        out[outPos + 44] = in[inPos + 46] - in[inPos + 45] >>> 56 | in[inPos + 47] - in[inPos + 46] << 4;
        out[outPos + 45] = in[inPos + 48] - in[inPos + 47] | in[inPos + 49] - in[inPos + 48] << 60;
        out[outPos + 46] = in[inPos + 49] - in[inPos + 48] >>> 4 | in[inPos + 50] - in[inPos + 49] << 56;
        out[outPos + 47] = in[inPos + 50] - in[inPos + 49] >>> 8 | in[inPos + 51] - in[inPos + 50] << 52;
        out[outPos + 48] = in[inPos + 51] - in[inPos + 50] >>> 12 | in[inPos + 52] - in[inPos + 51] << 48;
        out[outPos + 49] = in[inPos + 52] - in[inPos + 51] >>> 16 | in[inPos + 53] - in[inPos + 52] << 44;
        out[outPos + 50] = in[inPos + 53] - in[inPos + 52] >>> 20 | in[inPos + 54] - in[inPos + 53] << 40;
        out[outPos + 51] = in[inPos + 54] - in[inPos + 53] >>> 24 | in[inPos + 55] - in[inPos + 54] << 36;
        out[outPos + 52] = in[inPos + 55] - in[inPos + 54] >>> 28 | in[inPos + 56] - in[inPos + 55] << 32;
        out[outPos + 53] = in[inPos + 56] - in[inPos + 55] >>> 32 | in[inPos + 57] - in[inPos + 56] << 28;
        out[outPos + 54] = in[inPos + 57] - in[inPos + 56] >>> 36 | in[inPos + 58] - in[inPos + 57] << 24;
        out[outPos + 55] = in[inPos + 58] - in[inPos + 57] >>> 40 | in[inPos + 59] - in[inPos + 58] << 20;
        out[outPos + 56] = in[inPos + 59] - in[inPos + 58] >>> 44 | in[inPos + 60] - in[inPos + 59] << 16;
        out[outPos + 57] = in[inPos + 60] - in[inPos + 59] >>> 48 | in[inPos + 61] - in[inPos + 60] << 12;
        out[outPos + 58] = in[inPos + 61] - in[inPos + 60] >>> 52 | in[inPos + 62] - in[inPos + 61] << 8;
        out[outPos + 59] = in[inPos + 62] - in[inPos + 61] >>> 56 | in[inPos + 63] - in[inPos + 62] << 4;
    }

    private static void unpack60(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0xFFFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 60 | (in[inPos + 1] & 0xFFFFFFFFFFFFFFL) << 4) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 56 | (in[inPos + 2] & 0xFFFFFFFFFFFFFL) << 8) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 52 | (in[inPos + 3] & 0xFFFFFFFFFFFFL) << 12) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 48 | (in[inPos + 4] & 0xFFFFFFFFFFFL) << 16) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 44 | (in[inPos + 5] & 0xFFFFFFFFFFL) << 20) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 40 | (in[inPos + 6] & 0xFFFFFFFFFL) << 24) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 36 | (in[inPos + 7] & 0xFFFFFFFFL) << 28) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 32 | (in[inPos + 8] & 0xFFFFFFFL) << 32) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 28 | (in[inPos + 9] & 0xFFFFFFL) << 36) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 24 | (in[inPos + 10] & 0xFFFFFL) << 40) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 10] >>> 20 | (in[inPos + 11] & 0xFFFFL) << 44) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 11] >>> 16 | (in[inPos + 12] & 0xFFFL) << 48) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 12] >>> 12 | (in[inPos + 13] & 0xFFL) << 52) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 13] >>> 8 | (in[inPos + 14] & 0xFL) << 56) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 14] >>> 4) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 15] & 0xFFFFFFFFFFFFFFFL) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 15] >>> 60 | (in[inPos + 16] & 0xFFFFFFFFFFFFFFL) << 4) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 16] >>> 56 | (in[inPos + 17] & 0xFFFFFFFFFFFFFL) << 8) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 17] >>> 52 | (in[inPos + 18] & 0xFFFFFFFFFFFFL) << 12) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 18] >>> 48 | (in[inPos + 19] & 0xFFFFFFFFFFFL) << 16) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0xFFFFFFFFFFL) << 20) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 20] >>> 40 | (in[inPos + 21] & 0xFFFFFFFFFL) << 24) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 21] >>> 36 | (in[inPos + 22] & 0xFFFFFFFFL) << 28) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 22] >>> 32 | (in[inPos + 23] & 0xFFFFFFFL) << 32) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 23] >>> 28 | (in[inPos + 24] & 0xFFFFFFL) << 36) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 24] >>> 24 | (in[inPos + 25] & 0xFFFFFL) << 40) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 25] >>> 20 | (in[inPos + 26] & 0xFFFFL) << 44) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 26] >>> 16 | (in[inPos + 27] & 0xFFFL) << 48) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 27] >>> 12 | (in[inPos + 28] & 0xFFL) << 52) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 28] >>> 8 | (in[inPos + 29] & 0xFL) << 56) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 29] >>> 4) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 30] & 0xFFFFFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 30] >>> 60 | (in[inPos + 31] & 0xFFFFFFFFFFFFFFL) << 4) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 31] >>> 56 | (in[inPos + 32] & 0xFFFFFFFFFFFFFL) << 8) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 32] >>> 52 | (in[inPos + 33] & 0xFFFFFFFFFFFFL) << 12) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 33] >>> 48 | (in[inPos + 34] & 0xFFFFFFFFFFFL) << 16) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 34] >>> 44 | (in[inPos + 35] & 0xFFFFFFFFFFL) << 20) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 35] >>> 40 | (in[inPos + 36] & 0xFFFFFFFFFL) << 24) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 36] >>> 36 | (in[inPos + 37] & 0xFFFFFFFFL) << 28) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 37] >>> 32 | (in[inPos + 38] & 0xFFFFFFFL) << 32) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 38] >>> 28 | (in[inPos + 39] & 0xFFFFFFL) << 36) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 39] >>> 24 | (in[inPos + 40] & 0xFFFFFL) << 40) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 40] >>> 20 | (in[inPos + 41] & 0xFFFFL) << 44) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 41] >>> 16 | (in[inPos + 42] & 0xFFFL) << 48) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 42] >>> 12 | (in[inPos + 43] & 0xFFL) << 52) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 43] >>> 8 | (in[inPos + 44] & 0xFL) << 56) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 44] >>> 4) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 45] & 0xFFFFFFFFFFFFFFFL) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 45] >>> 60 | (in[inPos + 46] & 0xFFFFFFFFFFFFFFL) << 4) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 46] >>> 56 | (in[inPos + 47] & 0xFFFFFFFFFFFFFL) << 8) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 47] >>> 52 | (in[inPos + 48] & 0xFFFFFFFFFFFFL) << 12) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 48] >>> 48 | (in[inPos + 49] & 0xFFFFFFFFFFFL) << 16) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 49] >>> 44 | (in[inPos + 50] & 0xFFFFFFFFFFL) << 20) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 50] >>> 40 | (in[inPos + 51] & 0xFFFFFFFFFL) << 24) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 51] >>> 36 | (in[inPos + 52] & 0xFFFFFFFFL) << 28) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 52] >>> 32 | (in[inPos + 53] & 0xFFFFFFFL) << 32) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 53] >>> 28 | (in[inPos + 54] & 0xFFFFFFL) << 36) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 54] >>> 24 | (in[inPos + 55] & 0xFFFFFL) << 40) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 55] >>> 20 | (in[inPos + 56] & 0xFFFFL) << 44) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 56] >>> 16 | (in[inPos + 57] & 0xFFFL) << 48) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 57] >>> 12 | (in[inPos + 58] & 0xFFL) << 52) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 58] >>> 8 | (in[inPos + 59] & 0xFL) << 56) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 59] >>> 4) + out[outPos + 62];
    }

    private static void pack61(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 61;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 3 | in[inPos + 2] - in[inPos + 1] << 58;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 6 | in[inPos + 3] - in[inPos + 2] << 55;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 9 | in[inPos + 4] - in[inPos + 3] << 52;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 12 | in[inPos + 5] - in[inPos + 4] << 49;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 15 | in[inPos + 6] - in[inPos + 5] << 46;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 18 | in[inPos + 7] - in[inPos + 6] << 43;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 21 | in[inPos + 8] - in[inPos + 7] << 40;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 24 | in[inPos + 9] - in[inPos + 8] << 37;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 27 | in[inPos + 10] - in[inPos + 9] << 34;
        out[outPos + 10] = in[inPos + 10] - in[inPos + 9] >>> 30 | in[inPos + 11] - in[inPos + 10] << 31;
        out[outPos + 11] = in[inPos + 11] - in[inPos + 10] >>> 33 | in[inPos + 12] - in[inPos + 11] << 28;
        out[outPos + 12] = in[inPos + 12] - in[inPos + 11] >>> 36 | in[inPos + 13] - in[inPos + 12] << 25;
        out[outPos + 13] = in[inPos + 13] - in[inPos + 12] >>> 39 | in[inPos + 14] - in[inPos + 13] << 22;
        out[outPos + 14] = in[inPos + 14] - in[inPos + 13] >>> 42 | in[inPos + 15] - in[inPos + 14] << 19;
        out[outPos + 15] = in[inPos + 15] - in[inPos + 14] >>> 45 | in[inPos + 16] - in[inPos + 15] << 16;
        out[outPos + 16] = in[inPos + 16] - in[inPos + 15] >>> 48 | in[inPos + 17] - in[inPos + 16] << 13;
        out[outPos + 17] = in[inPos + 17] - in[inPos + 16] >>> 51 | in[inPos + 18] - in[inPos + 17] << 10;
        out[outPos + 18] = in[inPos + 18] - in[inPos + 17] >>> 54 | in[inPos + 19] - in[inPos + 18] << 7;
        out[outPos + 19] = in[inPos + 19] - in[inPos + 18] >>> 57 | in[inPos + 20] - in[inPos + 19] << 4;
        out[outPos + 20] = in[inPos + 20] - in[inPos + 19] >>> 60 | in[inPos + 21] - in[inPos + 20] << 1 | in[inPos + 22] - in[inPos + 21] << 62;
        out[outPos + 21] = in[inPos + 22] - in[inPos + 21] >>> 2 | in[inPos + 23] - in[inPos + 22] << 59;
        out[outPos + 22] = in[inPos + 23] - in[inPos + 22] >>> 5 | in[inPos + 24] - in[inPos + 23] << 56;
        out[outPos + 23] = in[inPos + 24] - in[inPos + 23] >>> 8 | in[inPos + 25] - in[inPos + 24] << 53;
        out[outPos + 24] = in[inPos + 25] - in[inPos + 24] >>> 11 | in[inPos + 26] - in[inPos + 25] << 50;
        out[outPos + 25] = in[inPos + 26] - in[inPos + 25] >>> 14 | in[inPos + 27] - in[inPos + 26] << 47;
        out[outPos + 26] = in[inPos + 27] - in[inPos + 26] >>> 17 | in[inPos + 28] - in[inPos + 27] << 44;
        out[outPos + 27] = in[inPos + 28] - in[inPos + 27] >>> 20 | in[inPos + 29] - in[inPos + 28] << 41;
        out[outPos + 28] = in[inPos + 29] - in[inPos + 28] >>> 23 | in[inPos + 30] - in[inPos + 29] << 38;
        out[outPos + 29] = in[inPos + 30] - in[inPos + 29] >>> 26 | in[inPos + 31] - in[inPos + 30] << 35;
        out[outPos + 30] = in[inPos + 31] - in[inPos + 30] >>> 29 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 31] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 29;
        out[outPos + 32] = in[inPos + 33] - in[inPos + 32] >>> 35 | in[inPos + 34] - in[inPos + 33] << 26;
        out[outPos + 33] = in[inPos + 34] - in[inPos + 33] >>> 38 | in[inPos + 35] - in[inPos + 34] << 23;
        out[outPos + 34] = in[inPos + 35] - in[inPos + 34] >>> 41 | in[inPos + 36] - in[inPos + 35] << 20;
        out[outPos + 35] = in[inPos + 36] - in[inPos + 35] >>> 44 | in[inPos + 37] - in[inPos + 36] << 17;
        out[outPos + 36] = in[inPos + 37] - in[inPos + 36] >>> 47 | in[inPos + 38] - in[inPos + 37] << 14;
        out[outPos + 37] = in[inPos + 38] - in[inPos + 37] >>> 50 | in[inPos + 39] - in[inPos + 38] << 11;
        out[outPos + 38] = in[inPos + 39] - in[inPos + 38] >>> 53 | in[inPos + 40] - in[inPos + 39] << 8;
        out[outPos + 39] = in[inPos + 40] - in[inPos + 39] >>> 56 | in[inPos + 41] - in[inPos + 40] << 5;
        out[outPos + 40] = in[inPos + 41] - in[inPos + 40] >>> 59 | in[inPos + 42] - in[inPos + 41] << 2 | in[inPos + 43] - in[inPos + 42] << 63;
        out[outPos + 41] = in[inPos + 43] - in[inPos + 42] >>> 1 | in[inPos + 44] - in[inPos + 43] << 60;
        out[outPos + 42] = in[inPos + 44] - in[inPos + 43] >>> 4 | in[inPos + 45] - in[inPos + 44] << 57;
        out[outPos + 43] = in[inPos + 45] - in[inPos + 44] >>> 7 | in[inPos + 46] - in[inPos + 45] << 54;
        out[outPos + 44] = in[inPos + 46] - in[inPos + 45] >>> 10 | in[inPos + 47] - in[inPos + 46] << 51;
        out[outPos + 45] = in[inPos + 47] - in[inPos + 46] >>> 13 | in[inPos + 48] - in[inPos + 47] << 48;
        out[outPos + 46] = in[inPos + 48] - in[inPos + 47] >>> 16 | in[inPos + 49] - in[inPos + 48] << 45;
        out[outPos + 47] = in[inPos + 49] - in[inPos + 48] >>> 19 | in[inPos + 50] - in[inPos + 49] << 42;
        out[outPos + 48] = in[inPos + 50] - in[inPos + 49] >>> 22 | in[inPos + 51] - in[inPos + 50] << 39;
        out[outPos + 49] = in[inPos + 51] - in[inPos + 50] >>> 25 | in[inPos + 52] - in[inPos + 51] << 36;
        out[outPos + 50] = in[inPos + 52] - in[inPos + 51] >>> 28 | in[inPos + 53] - in[inPos + 52] << 33;
        out[outPos + 51] = in[inPos + 53] - in[inPos + 52] >>> 31 | in[inPos + 54] - in[inPos + 53] << 30;
        out[outPos + 52] = in[inPos + 54] - in[inPos + 53] >>> 34 | in[inPos + 55] - in[inPos + 54] << 27;
        out[outPos + 53] = in[inPos + 55] - in[inPos + 54] >>> 37 | in[inPos + 56] - in[inPos + 55] << 24;
        out[outPos + 54] = in[inPos + 56] - in[inPos + 55] >>> 40 | in[inPos + 57] - in[inPos + 56] << 21;
        out[outPos + 55] = in[inPos + 57] - in[inPos + 56] >>> 43 | in[inPos + 58] - in[inPos + 57] << 18;
        out[outPos + 56] = in[inPos + 58] - in[inPos + 57] >>> 46 | in[inPos + 59] - in[inPos + 58] << 15;
        out[outPos + 57] = in[inPos + 59] - in[inPos + 58] >>> 49 | in[inPos + 60] - in[inPos + 59] << 12;
        out[outPos + 58] = in[inPos + 60] - in[inPos + 59] >>> 52 | in[inPos + 61] - in[inPos + 60] << 9;
        out[outPos + 59] = in[inPos + 61] - in[inPos + 60] >>> 55 | in[inPos + 62] - in[inPos + 61] << 6;
        out[outPos + 60] = in[inPos + 62] - in[inPos + 61] >>> 58 | in[inPos + 63] - in[inPos + 62] << 3;
    }

    private static void unpack61(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x1FFFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 61 | (in[inPos + 1] & 0x3FFFFFFFFFFFFFFL) << 3) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 58 | (in[inPos + 2] & 0x7FFFFFFFFFFFFFL) << 6) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 55 | (in[inPos + 3] & 0xFFFFFFFFFFFFFL) << 9) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 52 | (in[inPos + 4] & 0x1FFFFFFFFFFFFL) << 12) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 49 | (in[inPos + 5] & 0x3FFFFFFFFFFFL) << 15) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 46 | (in[inPos + 6] & 0x7FFFFFFFFFFL) << 18) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 43 | (in[inPos + 7] & 0xFFFFFFFFFFL) << 21) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 40 | (in[inPos + 8] & 0x1FFFFFFFFFL) << 24) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 37 | (in[inPos + 9] & 0x3FFFFFFFFL) << 27) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 34 | (in[inPos + 10] & Integer.MAX_VALUE) << 30) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 10] >>> 31 | (in[inPos + 11] & 0xFFFFFFFL) << 33) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 11] >>> 28 | (in[inPos + 12] & 0x1FFFFFFL) << 36) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 12] >>> 25 | (in[inPos + 13] & 0x3FFFFFL) << 39) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 13] >>> 22 | (in[inPos + 14] & 0x7FFFFL) << 42) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 14] >>> 19 | (in[inPos + 15] & 0xFFFFL) << 45) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 15] >>> 16 | (in[inPos + 16] & 0x1FFFL) << 48) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 16] >>> 13 | (in[inPos + 17] & 0x3FFL) << 51) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 17] >>> 10 | (in[inPos + 18] & 0x7FL) << 54) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 18] >>> 7 | (in[inPos + 19] & 0xFL) << 57) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 19] >>> 4 | (in[inPos + 20] & 1L) << 60) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 20] >>> 1 & 0x1FFFFFFFFFFFFFFFL) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 20] >>> 62 | (in[inPos + 21] & 0x7FFFFFFFFFFFFFFL) << 2) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 21] >>> 59 | (in[inPos + 22] & 0xFFFFFFFFFFFFFFL) << 5) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 22] >>> 56 | (in[inPos + 23] & 0x1FFFFFFFFFFFFFL) << 8) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 23] >>> 53 | (in[inPos + 24] & 0x3FFFFFFFFFFFFL) << 11) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 24] >>> 50 | (in[inPos + 25] & 0x7FFFFFFFFFFFL) << 14) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 25] >>> 47 | (in[inPos + 26] & 0xFFFFFFFFFFFL) << 17) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 26] >>> 44 | (in[inPos + 27] & 0x1FFFFFFFFFFL) << 20) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 27] >>> 41 | (in[inPos + 28] & 0x3FFFFFFFFFL) << 23) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 28] >>> 38 | (in[inPos + 29] & 0x7FFFFFFFFL) << 26) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 29] >>> 35 | (in[inPos + 30] & 0xFFFFFFFFL) << 29) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 30] >>> 32 | (in[inPos + 31] & 0x1FFFFFFFL) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 31] >>> 29 | (in[inPos + 32] & 0x3FFFFFFL) << 35) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 32] >>> 26 | (in[inPos + 33] & 0x7FFFFFL) << 38) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 33] >>> 23 | (in[inPos + 34] & 0xFFFFFL) << 41) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 34] >>> 20 | (in[inPos + 35] & 0x1FFFFL) << 44) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 35] >>> 17 | (in[inPos + 36] & 0x3FFFL) << 47) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 36] >>> 14 | (in[inPos + 37] & 0x7FFL) << 50) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 37] >>> 11 | (in[inPos + 38] & 0xFFL) << 53) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 38] >>> 8 | (in[inPos + 39] & 0x1FL) << 56) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 39] >>> 5 | (in[inPos + 40] & 3L) << 59) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 40] >>> 2 & 0x1FFFFFFFFFFFFFFFL) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 40] >>> 63 | (in[inPos + 41] & 0xFFFFFFFFFFFFFFFL) << 1) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 41] >>> 60 | (in[inPos + 42] & 0x1FFFFFFFFFFFFFFL) << 4) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 42] >>> 57 | (in[inPos + 43] & 0x3FFFFFFFFFFFFFL) << 7) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 43] >>> 54 | (in[inPos + 44] & 0x7FFFFFFFFFFFFL) << 10) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 44] >>> 51 | (in[inPos + 45] & 0xFFFFFFFFFFFFL) << 13) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 45] >>> 48 | (in[inPos + 46] & 0x1FFFFFFFFFFFL) << 16) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 46] >>> 45 | (in[inPos + 47] & 0x3FFFFFFFFFFL) << 19) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 47] >>> 42 | (in[inPos + 48] & 0x7FFFFFFFFFL) << 22) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 48] >>> 39 | (in[inPos + 49] & 0xFFFFFFFFFL) << 25) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 49] >>> 36 | (in[inPos + 50] & 0x1FFFFFFFFL) << 28) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 50] >>> 33 | (in[inPos + 51] & 0x3FFFFFFFL) << 31) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 51] >>> 30 | (in[inPos + 52] & 0x7FFFFFFL) << 34) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 52] >>> 27 | (in[inPos + 53] & 0xFFFFFFL) << 37) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 53] >>> 24 | (in[inPos + 54] & 0x1FFFFFL) << 40) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 54] >>> 21 | (in[inPos + 55] & 0x3FFFFL) << 43) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 55] >>> 18 | (in[inPos + 56] & 0x7FFFL) << 46) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 56] >>> 15 | (in[inPos + 57] & 0xFFFL) << 49) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 57] >>> 12 | (in[inPos + 58] & 0x1FFL) << 52) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 58] >>> 9 | (in[inPos + 59] & 0x3FL) << 55) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 59] >>> 6 | (in[inPos + 60] & 7L) << 58) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 60] >>> 3) + out[outPos + 62];
    }

    private static void pack62(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 62;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 2 | in[inPos + 2] - in[inPos + 1] << 60;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 4 | in[inPos + 3] - in[inPos + 2] << 58;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 6 | in[inPos + 4] - in[inPos + 3] << 56;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 8 | in[inPos + 5] - in[inPos + 4] << 54;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 10 | in[inPos + 6] - in[inPos + 5] << 52;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 12 | in[inPos + 7] - in[inPos + 6] << 50;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 14 | in[inPos + 8] - in[inPos + 7] << 48;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 16 | in[inPos + 9] - in[inPos + 8] << 46;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 18 | in[inPos + 10] - in[inPos + 9] << 44;
        out[outPos + 10] = in[inPos + 10] - in[inPos + 9] >>> 20 | in[inPos + 11] - in[inPos + 10] << 42;
        out[outPos + 11] = in[inPos + 11] - in[inPos + 10] >>> 22 | in[inPos + 12] - in[inPos + 11] << 40;
        out[outPos + 12] = in[inPos + 12] - in[inPos + 11] >>> 24 | in[inPos + 13] - in[inPos + 12] << 38;
        out[outPos + 13] = in[inPos + 13] - in[inPos + 12] >>> 26 | in[inPos + 14] - in[inPos + 13] << 36;
        out[outPos + 14] = in[inPos + 14] - in[inPos + 13] >>> 28 | in[inPos + 15] - in[inPos + 14] << 34;
        out[outPos + 15] = in[inPos + 15] - in[inPos + 14] >>> 30 | in[inPos + 16] - in[inPos + 15] << 32;
        out[outPos + 16] = in[inPos + 16] - in[inPos + 15] >>> 32 | in[inPos + 17] - in[inPos + 16] << 30;
        out[outPos + 17] = in[inPos + 17] - in[inPos + 16] >>> 34 | in[inPos + 18] - in[inPos + 17] << 28;
        out[outPos + 18] = in[inPos + 18] - in[inPos + 17] >>> 36 | in[inPos + 19] - in[inPos + 18] << 26;
        out[outPos + 19] = in[inPos + 19] - in[inPos + 18] >>> 38 | in[inPos + 20] - in[inPos + 19] << 24;
        out[outPos + 20] = in[inPos + 20] - in[inPos + 19] >>> 40 | in[inPos + 21] - in[inPos + 20] << 22;
        out[outPos + 21] = in[inPos + 21] - in[inPos + 20] >>> 42 | in[inPos + 22] - in[inPos + 21] << 20;
        out[outPos + 22] = in[inPos + 22] - in[inPos + 21] >>> 44 | in[inPos + 23] - in[inPos + 22] << 18;
        out[outPos + 23] = in[inPos + 23] - in[inPos + 22] >>> 46 | in[inPos + 24] - in[inPos + 23] << 16;
        out[outPos + 24] = in[inPos + 24] - in[inPos + 23] >>> 48 | in[inPos + 25] - in[inPos + 24] << 14;
        out[outPos + 25] = in[inPos + 25] - in[inPos + 24] >>> 50 | in[inPos + 26] - in[inPos + 25] << 12;
        out[outPos + 26] = in[inPos + 26] - in[inPos + 25] >>> 52 | in[inPos + 27] - in[inPos + 26] << 10;
        out[outPos + 27] = in[inPos + 27] - in[inPos + 26] >>> 54 | in[inPos + 28] - in[inPos + 27] << 8;
        out[outPos + 28] = in[inPos + 28] - in[inPos + 27] >>> 56 | in[inPos + 29] - in[inPos + 28] << 6;
        out[outPos + 29] = in[inPos + 29] - in[inPos + 28] >>> 58 | in[inPos + 30] - in[inPos + 29] << 4;
        out[outPos + 30] = in[inPos + 30] - in[inPos + 29] >>> 60 | in[inPos + 31] - in[inPos + 30] << 2;
        out[outPos + 31] = in[inPos + 32] - in[inPos + 31] | in[inPos + 33] - in[inPos + 32] << 62;
        out[outPos + 32] = in[inPos + 33] - in[inPos + 32] >>> 2 | in[inPos + 34] - in[inPos + 33] << 60;
        out[outPos + 33] = in[inPos + 34] - in[inPos + 33] >>> 4 | in[inPos + 35] - in[inPos + 34] << 58;
        out[outPos + 34] = in[inPos + 35] - in[inPos + 34] >>> 6 | in[inPos + 36] - in[inPos + 35] << 56;
        out[outPos + 35] = in[inPos + 36] - in[inPos + 35] >>> 8 | in[inPos + 37] - in[inPos + 36] << 54;
        out[outPos + 36] = in[inPos + 37] - in[inPos + 36] >>> 10 | in[inPos + 38] - in[inPos + 37] << 52;
        out[outPos + 37] = in[inPos + 38] - in[inPos + 37] >>> 12 | in[inPos + 39] - in[inPos + 38] << 50;
        out[outPos + 38] = in[inPos + 39] - in[inPos + 38] >>> 14 | in[inPos + 40] - in[inPos + 39] << 48;
        out[outPos + 39] = in[inPos + 40] - in[inPos + 39] >>> 16 | in[inPos + 41] - in[inPos + 40] << 46;
        out[outPos + 40] = in[inPos + 41] - in[inPos + 40] >>> 18 | in[inPos + 42] - in[inPos + 41] << 44;
        out[outPos + 41] = in[inPos + 42] - in[inPos + 41] >>> 20 | in[inPos + 43] - in[inPos + 42] << 42;
        out[outPos + 42] = in[inPos + 43] - in[inPos + 42] >>> 22 | in[inPos + 44] - in[inPos + 43] << 40;
        out[outPos + 43] = in[inPos + 44] - in[inPos + 43] >>> 24 | in[inPos + 45] - in[inPos + 44] << 38;
        out[outPos + 44] = in[inPos + 45] - in[inPos + 44] >>> 26 | in[inPos + 46] - in[inPos + 45] << 36;
        out[outPos + 45] = in[inPos + 46] - in[inPos + 45] >>> 28 | in[inPos + 47] - in[inPos + 46] << 34;
        out[outPos + 46] = in[inPos + 47] - in[inPos + 46] >>> 30 | in[inPos + 48] - in[inPos + 47] << 32;
        out[outPos + 47] = in[inPos + 48] - in[inPos + 47] >>> 32 | in[inPos + 49] - in[inPos + 48] << 30;
        out[outPos + 48] = in[inPos + 49] - in[inPos + 48] >>> 34 | in[inPos + 50] - in[inPos + 49] << 28;
        out[outPos + 49] = in[inPos + 50] - in[inPos + 49] >>> 36 | in[inPos + 51] - in[inPos + 50] << 26;
        out[outPos + 50] = in[inPos + 51] - in[inPos + 50] >>> 38 | in[inPos + 52] - in[inPos + 51] << 24;
        out[outPos + 51] = in[inPos + 52] - in[inPos + 51] >>> 40 | in[inPos + 53] - in[inPos + 52] << 22;
        out[outPos + 52] = in[inPos + 53] - in[inPos + 52] >>> 42 | in[inPos + 54] - in[inPos + 53] << 20;
        out[outPos + 53] = in[inPos + 54] - in[inPos + 53] >>> 44 | in[inPos + 55] - in[inPos + 54] << 18;
        out[outPos + 54] = in[inPos + 55] - in[inPos + 54] >>> 46 | in[inPos + 56] - in[inPos + 55] << 16;
        out[outPos + 55] = in[inPos + 56] - in[inPos + 55] >>> 48 | in[inPos + 57] - in[inPos + 56] << 14;
        out[outPos + 56] = in[inPos + 57] - in[inPos + 56] >>> 50 | in[inPos + 58] - in[inPos + 57] << 12;
        out[outPos + 57] = in[inPos + 58] - in[inPos + 57] >>> 52 | in[inPos + 59] - in[inPos + 58] << 10;
        out[outPos + 58] = in[inPos + 59] - in[inPos + 58] >>> 54 | in[inPos + 60] - in[inPos + 59] << 8;
        out[outPos + 59] = in[inPos + 60] - in[inPos + 59] >>> 56 | in[inPos + 61] - in[inPos + 60] << 6;
        out[outPos + 60] = in[inPos + 61] - in[inPos + 60] >>> 58 | in[inPos + 62] - in[inPos + 61] << 4;
        out[outPos + 61] = in[inPos + 62] - in[inPos + 61] >>> 60 | in[inPos + 63] - in[inPos + 62] << 2;
    }

    private static void unpack62(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & 0x3FFFFFFFFFFFFFFFL) + initValue;
        out[outPos + 1] = (in[inPos] >>> 62 | (in[inPos + 1] & 0xFFFFFFFFFFFFFFFL) << 2) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 60 | (in[inPos + 2] & 0x3FFFFFFFFFFFFFFL) << 4) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 58 | (in[inPos + 3] & 0xFFFFFFFFFFFFFFL) << 6) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 56 | (in[inPos + 4] & 0x3FFFFFFFFFFFFFL) << 8) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 54 | (in[inPos + 5] & 0xFFFFFFFFFFFFFL) << 10) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 52 | (in[inPos + 6] & 0x3FFFFFFFFFFFFL) << 12) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 50 | (in[inPos + 7] & 0xFFFFFFFFFFFFL) << 14) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 48 | (in[inPos + 8] & 0x3FFFFFFFFFFFL) << 16) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 46 | (in[inPos + 9] & 0xFFFFFFFFFFFL) << 18) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 44 | (in[inPos + 10] & 0x3FFFFFFFFFFL) << 20) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 10] >>> 42 | (in[inPos + 11] & 0xFFFFFFFFFFL) << 22) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 11] >>> 40 | (in[inPos + 12] & 0x3FFFFFFFFFL) << 24) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 12] >>> 38 | (in[inPos + 13] & 0xFFFFFFFFFL) << 26) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 13] >>> 36 | (in[inPos + 14] & 0x3FFFFFFFFL) << 28) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 14] >>> 34 | (in[inPos + 15] & 0xFFFFFFFFL) << 30) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 15] >>> 32 | (in[inPos + 16] & 0x3FFFFFFFL) << 32) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 16] >>> 30 | (in[inPos + 17] & 0xFFFFFFFL) << 34) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 17] >>> 28 | (in[inPos + 18] & 0x3FFFFFFL) << 36) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 18] >>> 26 | (in[inPos + 19] & 0xFFFFFFL) << 38) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 19] >>> 24 | (in[inPos + 20] & 0x3FFFFFL) << 40) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 20] >>> 22 | (in[inPos + 21] & 0xFFFFFL) << 42) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 21] >>> 20 | (in[inPos + 22] & 0x3FFFFL) << 44) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 22] >>> 18 | (in[inPos + 23] & 0xFFFFL) << 46) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 23] >>> 16 | (in[inPos + 24] & 0x3FFFL) << 48) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 24] >>> 14 | (in[inPos + 25] & 0xFFFL) << 50) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 25] >>> 12 | (in[inPos + 26] & 0x3FFL) << 52) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 26] >>> 10 | (in[inPos + 27] & 0xFFL) << 54) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 27] >>> 8 | (in[inPos + 28] & 0x3FL) << 56) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 28] >>> 6 | (in[inPos + 29] & 0xFL) << 58) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 29] >>> 4 | (in[inPos + 30] & 3L) << 60) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 30] >>> 2) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 31] & 0x3FFFFFFFFFFFFFFFL) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 31] >>> 62 | (in[inPos + 32] & 0xFFFFFFFFFFFFFFFL) << 2) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 32] >>> 60 | (in[inPos + 33] & 0x3FFFFFFFFFFFFFFL) << 4) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 33] >>> 58 | (in[inPos + 34] & 0xFFFFFFFFFFFFFFL) << 6) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 34] >>> 56 | (in[inPos + 35] & 0x3FFFFFFFFFFFFFL) << 8) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 35] >>> 54 | (in[inPos + 36] & 0xFFFFFFFFFFFFFL) << 10) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 36] >>> 52 | (in[inPos + 37] & 0x3FFFFFFFFFFFFL) << 12) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 37] >>> 50 | (in[inPos + 38] & 0xFFFFFFFFFFFFL) << 14) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 38] >>> 48 | (in[inPos + 39] & 0x3FFFFFFFFFFFL) << 16) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 39] >>> 46 | (in[inPos + 40] & 0xFFFFFFFFFFFL) << 18) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 40] >>> 44 | (in[inPos + 41] & 0x3FFFFFFFFFFL) << 20) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 41] >>> 42 | (in[inPos + 42] & 0xFFFFFFFFFFL) << 22) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 42] >>> 40 | (in[inPos + 43] & 0x3FFFFFFFFFL) << 24) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 43] >>> 38 | (in[inPos + 44] & 0xFFFFFFFFFL) << 26) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 44] >>> 36 | (in[inPos + 45] & 0x3FFFFFFFFL) << 28) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 45] >>> 34 | (in[inPos + 46] & 0xFFFFFFFFL) << 30) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 46] >>> 32 | (in[inPos + 47] & 0x3FFFFFFFL) << 32) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 47] >>> 30 | (in[inPos + 48] & 0xFFFFFFFL) << 34) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 48] >>> 28 | (in[inPos + 49] & 0x3FFFFFFL) << 36) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 49] >>> 26 | (in[inPos + 50] & 0xFFFFFFL) << 38) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 50] >>> 24 | (in[inPos + 51] & 0x3FFFFFL) << 40) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 51] >>> 22 | (in[inPos + 52] & 0xFFFFFL) << 42) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 52] >>> 20 | (in[inPos + 53] & 0x3FFFFL) << 44) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 53] >>> 18 | (in[inPos + 54] & 0xFFFFL) << 46) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 54] >>> 16 | (in[inPos + 55] & 0x3FFFL) << 48) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 55] >>> 14 | (in[inPos + 56] & 0xFFFL) << 50) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 56] >>> 12 | (in[inPos + 57] & 0x3FFL) << 52) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 57] >>> 10 | (in[inPos + 58] & 0xFFL) << 54) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 58] >>> 8 | (in[inPos + 59] & 0x3FL) << 56) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 59] >>> 6 | (in[inPos + 60] & 0xFL) << 58) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 60] >>> 4 | (in[inPos + 61] & 3L) << 60) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 61] >>> 2) + out[outPos + 62];
    }

    private static void pack63(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = in[inPos] - initValue | in[inPos + 1] - in[inPos] << 63;
        out[outPos + 1] = in[inPos + 1] - in[inPos] >>> 1 | in[inPos + 2] - in[inPos + 1] << 62;
        out[outPos + 2] = in[inPos + 2] - in[inPos + 1] >>> 2 | in[inPos + 3] - in[inPos + 2] << 61;
        out[outPos + 3] = in[inPos + 3] - in[inPos + 2] >>> 3 | in[inPos + 4] - in[inPos + 3] << 60;
        out[outPos + 4] = in[inPos + 4] - in[inPos + 3] >>> 4 | in[inPos + 5] - in[inPos + 4] << 59;
        out[outPos + 5] = in[inPos + 5] - in[inPos + 4] >>> 5 | in[inPos + 6] - in[inPos + 5] << 58;
        out[outPos + 6] = in[inPos + 6] - in[inPos + 5] >>> 6 | in[inPos + 7] - in[inPos + 6] << 57;
        out[outPos + 7] = in[inPos + 7] - in[inPos + 6] >>> 7 | in[inPos + 8] - in[inPos + 7] << 56;
        out[outPos + 8] = in[inPos + 8] - in[inPos + 7] >>> 8 | in[inPos + 9] - in[inPos + 8] << 55;
        out[outPos + 9] = in[inPos + 9] - in[inPos + 8] >>> 9 | in[inPos + 10] - in[inPos + 9] << 54;
        out[outPos + 10] = in[inPos + 10] - in[inPos + 9] >>> 10 | in[inPos + 11] - in[inPos + 10] << 53;
        out[outPos + 11] = in[inPos + 11] - in[inPos + 10] >>> 11 | in[inPos + 12] - in[inPos + 11] << 52;
        out[outPos + 12] = in[inPos + 12] - in[inPos + 11] >>> 12 | in[inPos + 13] - in[inPos + 12] << 51;
        out[outPos + 13] = in[inPos + 13] - in[inPos + 12] >>> 13 | in[inPos + 14] - in[inPos + 13] << 50;
        out[outPos + 14] = in[inPos + 14] - in[inPos + 13] >>> 14 | in[inPos + 15] - in[inPos + 14] << 49;
        out[outPos + 15] = in[inPos + 15] - in[inPos + 14] >>> 15 | in[inPos + 16] - in[inPos + 15] << 48;
        out[outPos + 16] = in[inPos + 16] - in[inPos + 15] >>> 16 | in[inPos + 17] - in[inPos + 16] << 47;
        out[outPos + 17] = in[inPos + 17] - in[inPos + 16] >>> 17 | in[inPos + 18] - in[inPos + 17] << 46;
        out[outPos + 18] = in[inPos + 18] - in[inPos + 17] >>> 18 | in[inPos + 19] - in[inPos + 18] << 45;
        out[outPos + 19] = in[inPos + 19] - in[inPos + 18] >>> 19 | in[inPos + 20] - in[inPos + 19] << 44;
        out[outPos + 20] = in[inPos + 20] - in[inPos + 19] >>> 20 | in[inPos + 21] - in[inPos + 20] << 43;
        out[outPos + 21] = in[inPos + 21] - in[inPos + 20] >>> 21 | in[inPos + 22] - in[inPos + 21] << 42;
        out[outPos + 22] = in[inPos + 22] - in[inPos + 21] >>> 22 | in[inPos + 23] - in[inPos + 22] << 41;
        out[outPos + 23] = in[inPos + 23] - in[inPos + 22] >>> 23 | in[inPos + 24] - in[inPos + 23] << 40;
        out[outPos + 24] = in[inPos + 24] - in[inPos + 23] >>> 24 | in[inPos + 25] - in[inPos + 24] << 39;
        out[outPos + 25] = in[inPos + 25] - in[inPos + 24] >>> 25 | in[inPos + 26] - in[inPos + 25] << 38;
        out[outPos + 26] = in[inPos + 26] - in[inPos + 25] >>> 26 | in[inPos + 27] - in[inPos + 26] << 37;
        out[outPos + 27] = in[inPos + 27] - in[inPos + 26] >>> 27 | in[inPos + 28] - in[inPos + 27] << 36;
        out[outPos + 28] = in[inPos + 28] - in[inPos + 27] >>> 28 | in[inPos + 29] - in[inPos + 28] << 35;
        out[outPos + 29] = in[inPos + 29] - in[inPos + 28] >>> 29 | in[inPos + 30] - in[inPos + 29] << 34;
        out[outPos + 30] = in[inPos + 30] - in[inPos + 29] >>> 30 | in[inPos + 31] - in[inPos + 30] << 33;
        out[outPos + 31] = in[inPos + 31] - in[inPos + 30] >>> 31 | in[inPos + 32] - in[inPos + 31] << 32;
        out[outPos + 32] = in[inPos + 32] - in[inPos + 31] >>> 32 | in[inPos + 33] - in[inPos + 32] << 31;
        out[outPos + 33] = in[inPos + 33] - in[inPos + 32] >>> 33 | in[inPos + 34] - in[inPos + 33] << 30;
        out[outPos + 34] = in[inPos + 34] - in[inPos + 33] >>> 34 | in[inPos + 35] - in[inPos + 34] << 29;
        out[outPos + 35] = in[inPos + 35] - in[inPos + 34] >>> 35 | in[inPos + 36] - in[inPos + 35] << 28;
        out[outPos + 36] = in[inPos + 36] - in[inPos + 35] >>> 36 | in[inPos + 37] - in[inPos + 36] << 27;
        out[outPos + 37] = in[inPos + 37] - in[inPos + 36] >>> 37 | in[inPos + 38] - in[inPos + 37] << 26;
        out[outPos + 38] = in[inPos + 38] - in[inPos + 37] >>> 38 | in[inPos + 39] - in[inPos + 38] << 25;
        out[outPos + 39] = in[inPos + 39] - in[inPos + 38] >>> 39 | in[inPos + 40] - in[inPos + 39] << 24;
        out[outPos + 40] = in[inPos + 40] - in[inPos + 39] >>> 40 | in[inPos + 41] - in[inPos + 40] << 23;
        out[outPos + 41] = in[inPos + 41] - in[inPos + 40] >>> 41 | in[inPos + 42] - in[inPos + 41] << 22;
        out[outPos + 42] = in[inPos + 42] - in[inPos + 41] >>> 42 | in[inPos + 43] - in[inPos + 42] << 21;
        out[outPos + 43] = in[inPos + 43] - in[inPos + 42] >>> 43 | in[inPos + 44] - in[inPos + 43] << 20;
        out[outPos + 44] = in[inPos + 44] - in[inPos + 43] >>> 44 | in[inPos + 45] - in[inPos + 44] << 19;
        out[outPos + 45] = in[inPos + 45] - in[inPos + 44] >>> 45 | in[inPos + 46] - in[inPos + 45] << 18;
        out[outPos + 46] = in[inPos + 46] - in[inPos + 45] >>> 46 | in[inPos + 47] - in[inPos + 46] << 17;
        out[outPos + 47] = in[inPos + 47] - in[inPos + 46] >>> 47 | in[inPos + 48] - in[inPos + 47] << 16;
        out[outPos + 48] = in[inPos + 48] - in[inPos + 47] >>> 48 | in[inPos + 49] - in[inPos + 48] << 15;
        out[outPos + 49] = in[inPos + 49] - in[inPos + 48] >>> 49 | in[inPos + 50] - in[inPos + 49] << 14;
        out[outPos + 50] = in[inPos + 50] - in[inPos + 49] >>> 50 | in[inPos + 51] - in[inPos + 50] << 13;
        out[outPos + 51] = in[inPos + 51] - in[inPos + 50] >>> 51 | in[inPos + 52] - in[inPos + 51] << 12;
        out[outPos + 52] = in[inPos + 52] - in[inPos + 51] >>> 52 | in[inPos + 53] - in[inPos + 52] << 11;
        out[outPos + 53] = in[inPos + 53] - in[inPos + 52] >>> 53 | in[inPos + 54] - in[inPos + 53] << 10;
        out[outPos + 54] = in[inPos + 54] - in[inPos + 53] >>> 54 | in[inPos + 55] - in[inPos + 54] << 9;
        out[outPos + 55] = in[inPos + 55] - in[inPos + 54] >>> 55 | in[inPos + 56] - in[inPos + 55] << 8;
        out[outPos + 56] = in[inPos + 56] - in[inPos + 55] >>> 56 | in[inPos + 57] - in[inPos + 56] << 7;
        out[outPos + 57] = in[inPos + 57] - in[inPos + 56] >>> 57 | in[inPos + 58] - in[inPos + 57] << 6;
        out[outPos + 58] = in[inPos + 58] - in[inPos + 57] >>> 58 | in[inPos + 59] - in[inPos + 58] << 5;
        out[outPos + 59] = in[inPos + 59] - in[inPos + 58] >>> 59 | in[inPos + 60] - in[inPos + 59] << 4;
        out[outPos + 60] = in[inPos + 60] - in[inPos + 59] >>> 60 | in[inPos + 61] - in[inPos + 60] << 3;
        out[outPos + 61] = in[inPos + 61] - in[inPos + 60] >>> 61 | in[inPos + 62] - in[inPos + 61] << 2;
        out[outPos + 62] = in[inPos + 62] - in[inPos + 61] >>> 62 | in[inPos + 63] - in[inPos + 62] << 1;
    }

    private static void unpack63(long initValue, long[] in, int inPos, long[] out, int outPos) {
        out[outPos] = (in[inPos] & Long.MAX_VALUE) + initValue;
        out[outPos + 1] = (in[inPos] >>> 63 | (in[inPos + 1] & 0x3FFFFFFFFFFFFFFFL) << 1) + out[outPos];
        out[outPos + 2] = (in[inPos + 1] >>> 62 | (in[inPos + 2] & 0x1FFFFFFFFFFFFFFFL) << 2) + out[outPos + 1];
        out[outPos + 3] = (in[inPos + 2] >>> 61 | (in[inPos + 3] & 0xFFFFFFFFFFFFFFFL) << 3) + out[outPos + 2];
        out[outPos + 4] = (in[inPos + 3] >>> 60 | (in[inPos + 4] & 0x7FFFFFFFFFFFFFFL) << 4) + out[outPos + 3];
        out[outPos + 5] = (in[inPos + 4] >>> 59 | (in[inPos + 5] & 0x3FFFFFFFFFFFFFFL) << 5) + out[outPos + 4];
        out[outPos + 6] = (in[inPos + 5] >>> 58 | (in[inPos + 6] & 0x1FFFFFFFFFFFFFFL) << 6) + out[outPos + 5];
        out[outPos + 7] = (in[inPos + 6] >>> 57 | (in[inPos + 7] & 0xFFFFFFFFFFFFFFL) << 7) + out[outPos + 6];
        out[outPos + 8] = (in[inPos + 7] >>> 56 | (in[inPos + 8] & 0x7FFFFFFFFFFFFFL) << 8) + out[outPos + 7];
        out[outPos + 9] = (in[inPos + 8] >>> 55 | (in[inPos + 9] & 0x3FFFFFFFFFFFFFL) << 9) + out[outPos + 8];
        out[outPos + 10] = (in[inPos + 9] >>> 54 | (in[inPos + 10] & 0x1FFFFFFFFFFFFFL) << 10) + out[outPos + 9];
        out[outPos + 11] = (in[inPos + 10] >>> 53 | (in[inPos + 11] & 0xFFFFFFFFFFFFFL) << 11) + out[outPos + 10];
        out[outPos + 12] = (in[inPos + 11] >>> 52 | (in[inPos + 12] & 0x7FFFFFFFFFFFFL) << 12) + out[outPos + 11];
        out[outPos + 13] = (in[inPos + 12] >>> 51 | (in[inPos + 13] & 0x3FFFFFFFFFFFFL) << 13) + out[outPos + 12];
        out[outPos + 14] = (in[inPos + 13] >>> 50 | (in[inPos + 14] & 0x1FFFFFFFFFFFFL) << 14) + out[outPos + 13];
        out[outPos + 15] = (in[inPos + 14] >>> 49 | (in[inPos + 15] & 0xFFFFFFFFFFFFL) << 15) + out[outPos + 14];
        out[outPos + 16] = (in[inPos + 15] >>> 48 | (in[inPos + 16] & 0x7FFFFFFFFFFFL) << 16) + out[outPos + 15];
        out[outPos + 17] = (in[inPos + 16] >>> 47 | (in[inPos + 17] & 0x3FFFFFFFFFFFL) << 17) + out[outPos + 16];
        out[outPos + 18] = (in[inPos + 17] >>> 46 | (in[inPos + 18] & 0x1FFFFFFFFFFFL) << 18) + out[outPos + 17];
        out[outPos + 19] = (in[inPos + 18] >>> 45 | (in[inPos + 19] & 0xFFFFFFFFFFFL) << 19) + out[outPos + 18];
        out[outPos + 20] = (in[inPos + 19] >>> 44 | (in[inPos + 20] & 0x7FFFFFFFFFFL) << 20) + out[outPos + 19];
        out[outPos + 21] = (in[inPos + 20] >>> 43 | (in[inPos + 21] & 0x3FFFFFFFFFFL) << 21) + out[outPos + 20];
        out[outPos + 22] = (in[inPos + 21] >>> 42 | (in[inPos + 22] & 0x1FFFFFFFFFFL) << 22) + out[outPos + 21];
        out[outPos + 23] = (in[inPos + 22] >>> 41 | (in[inPos + 23] & 0xFFFFFFFFFFL) << 23) + out[outPos + 22];
        out[outPos + 24] = (in[inPos + 23] >>> 40 | (in[inPos + 24] & 0x7FFFFFFFFFL) << 24) + out[outPos + 23];
        out[outPos + 25] = (in[inPos + 24] >>> 39 | (in[inPos + 25] & 0x3FFFFFFFFFL) << 25) + out[outPos + 24];
        out[outPos + 26] = (in[inPos + 25] >>> 38 | (in[inPos + 26] & 0x1FFFFFFFFFL) << 26) + out[outPos + 25];
        out[outPos + 27] = (in[inPos + 26] >>> 37 | (in[inPos + 27] & 0xFFFFFFFFFL) << 27) + out[outPos + 26];
        out[outPos + 28] = (in[inPos + 27] >>> 36 | (in[inPos + 28] & 0x7FFFFFFFFL) << 28) + out[outPos + 27];
        out[outPos + 29] = (in[inPos + 28] >>> 35 | (in[inPos + 29] & 0x3FFFFFFFFL) << 29) + out[outPos + 28];
        out[outPos + 30] = (in[inPos + 29] >>> 34 | (in[inPos + 30] & 0x1FFFFFFFFL) << 30) + out[outPos + 29];
        out[outPos + 31] = (in[inPos + 30] >>> 33 | (in[inPos + 31] & 0xFFFFFFFFL) << 31) + out[outPos + 30];
        out[outPos + 32] = (in[inPos + 31] >>> 32 | (in[inPos + 32] & Integer.MAX_VALUE) << 32) + out[outPos + 31];
        out[outPos + 33] = (in[inPos + 32] >>> 31 | (in[inPos + 33] & 0x3FFFFFFFL) << 33) + out[outPos + 32];
        out[outPos + 34] = (in[inPos + 33] >>> 30 | (in[inPos + 34] & 0x1FFFFFFFL) << 34) + out[outPos + 33];
        out[outPos + 35] = (in[inPos + 34] >>> 29 | (in[inPos + 35] & 0xFFFFFFFL) << 35) + out[outPos + 34];
        out[outPos + 36] = (in[inPos + 35] >>> 28 | (in[inPos + 36] & 0x7FFFFFFL) << 36) + out[outPos + 35];
        out[outPos + 37] = (in[inPos + 36] >>> 27 | (in[inPos + 37] & 0x3FFFFFFL) << 37) + out[outPos + 36];
        out[outPos + 38] = (in[inPos + 37] >>> 26 | (in[inPos + 38] & 0x1FFFFFFL) << 38) + out[outPos + 37];
        out[outPos + 39] = (in[inPos + 38] >>> 25 | (in[inPos + 39] & 0xFFFFFFL) << 39) + out[outPos + 38];
        out[outPos + 40] = (in[inPos + 39] >>> 24 | (in[inPos + 40] & 0x7FFFFFL) << 40) + out[outPos + 39];
        out[outPos + 41] = (in[inPos + 40] >>> 23 | (in[inPos + 41] & 0x3FFFFFL) << 41) + out[outPos + 40];
        out[outPos + 42] = (in[inPos + 41] >>> 22 | (in[inPos + 42] & 0x1FFFFFL) << 42) + out[outPos + 41];
        out[outPos + 43] = (in[inPos + 42] >>> 21 | (in[inPos + 43] & 0xFFFFFL) << 43) + out[outPos + 42];
        out[outPos + 44] = (in[inPos + 43] >>> 20 | (in[inPos + 44] & 0x7FFFFL) << 44) + out[outPos + 43];
        out[outPos + 45] = (in[inPos + 44] >>> 19 | (in[inPos + 45] & 0x3FFFFL) << 45) + out[outPos + 44];
        out[outPos + 46] = (in[inPos + 45] >>> 18 | (in[inPos + 46] & 0x1FFFFL) << 46) + out[outPos + 45];
        out[outPos + 47] = (in[inPos + 46] >>> 17 | (in[inPos + 47] & 0xFFFFL) << 47) + out[outPos + 46];
        out[outPos + 48] = (in[inPos + 47] >>> 16 | (in[inPos + 48] & 0x7FFFL) << 48) + out[outPos + 47];
        out[outPos + 49] = (in[inPos + 48] >>> 15 | (in[inPos + 49] & 0x3FFFL) << 49) + out[outPos + 48];
        out[outPos + 50] = (in[inPos + 49] >>> 14 | (in[inPos + 50] & 0x1FFFL) << 50) + out[outPos + 49];
        out[outPos + 51] = (in[inPos + 50] >>> 13 | (in[inPos + 51] & 0xFFFL) << 51) + out[outPos + 50];
        out[outPos + 52] = (in[inPos + 51] >>> 12 | (in[inPos + 52] & 0x7FFL) << 52) + out[outPos + 51];
        out[outPos + 53] = (in[inPos + 52] >>> 11 | (in[inPos + 53] & 0x3FFL) << 53) + out[outPos + 52];
        out[outPos + 54] = (in[inPos + 53] >>> 10 | (in[inPos + 54] & 0x1FFL) << 54) + out[outPos + 53];
        out[outPos + 55] = (in[inPos + 54] >>> 9 | (in[inPos + 55] & 0xFFL) << 55) + out[outPos + 54];
        out[outPos + 56] = (in[inPos + 55] >>> 8 | (in[inPos + 56] & 0x7FL) << 56) + out[outPos + 55];
        out[outPos + 57] = (in[inPos + 56] >>> 7 | (in[inPos + 57] & 0x3FL) << 57) + out[outPos + 56];
        out[outPos + 58] = (in[inPos + 57] >>> 6 | (in[inPos + 58] & 0x1FL) << 58) + out[outPos + 57];
        out[outPos + 59] = (in[inPos + 58] >>> 5 | (in[inPos + 59] & 0xFL) << 59) + out[outPos + 58];
        out[outPos + 60] = (in[inPos + 59] >>> 4 | (in[inPos + 60] & 7L) << 60) + out[outPos + 59];
        out[outPos + 61] = (in[inPos + 60] >>> 3 | (in[inPos + 61] & 3L) << 61) + out[outPos + 60];
        out[outPos + 62] = (in[inPos + 61] >>> 2 | (in[inPos + 62] & 1L) << 62) + out[outPos + 61];
        out[outPos + 63] = (in[inPos + 62] >>> 1) + out[outPos + 62];
    }
}

