/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.mvstore.type;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.type.KeyableDataType;

public class StringDataType
implements KeyableDataType<String> {
    public static final KeyableDataType<String> INSTANCE = new StringDataType();

    private StringDataType() {
    }

    @Override
    public int getFixedMemory() {
        return -1;
    }

    public final String[] createStorage(int size) {
        return new String[size];
    }

    @Override
    public final int compare(String a, String b) {
        return a.compareTo(b);
    }

    @Override
    public int getMemory(String obj) {
        return 24 + 2 * obj.length();
    }

    @Override
    public String read(ByteBuf buf) {
        return DataUtil.readString(buf);
    }

    @Override
    public void write(ByteBuf buf, String s) {
        DataUtil.writeString(buf, s);
    }

    public static final class AsciiStringDataType
    extends StringDataType {
        public static final KeyableDataType<String> INSTANCE = new AsciiStringDataType();

        private AsciiStringDataType() {
        }

        @Override
        public String read(ByteBuf buf) {
            int length = IntBitPacker.readVar(buf);
            int readerIndex = buf.readerIndex();
            String result = buf.toString(readerIndex, length, StandardCharsets.US_ASCII);
            buf.readerIndex(readerIndex + length);
            return result;
        }

        @Override
        public void write(ByteBuf buf, String s) {
            int length = s.length();
            IntBitPacker.writeVar(buf, length);
            buf.writeCharSequence(s, StandardCharsets.US_ASCII);
        }
    }
}

