/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar.quickfix;

import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.choice.ChoiceTitleIntentionAction;
import com.intellij.codeInsight.intention.choice.ChoiceVariantIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.ui.components.dsl.SwingKTKt;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.TextProblem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix;", "", "()V", "getReplacementFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "problem", "Lcom/intellij/grazie/text/TextProblem;", "underlineRanges", "Lcom/intellij/psi/SmartPsiFileRange;", "file", "Lcom/intellij/psi/PsiFile;", "ChangeToVariantAction", "ReplaceTypoTitleAction", "intellij.grazie.core"})
public final class GrazieReplaceTypoQuickFix {
    @NotNull
    public static final GrazieReplaceTypoQuickFix INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalQuickFix> getReplacementFixes(@NotNull TextProblem problem, @NotNull List<? extends SmartPsiFileRange> underlineRanges, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter(underlineRanges, (String)"underlineRanges");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        TextRange textRange = problem.getReplacementRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"problem.replacementRange");
        TextRange replacementRange = textRange;
        CharSequence charSequence = replacementRange.subSequence((CharSequence)problem.getText());
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"replacementRange.subSequence(problem.text)");
        CharSequence replacedText = charSequence;
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)file2.getProject());
        String[] stringArray = new String[1];
        String string = problem.getShortMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"problem.shortMessage");
        stringArray[0] = string;
        String familyName = GrazieBundle.INSTANCE.message("grazie.grammar.quickfix.replace.typo.text", stringArray);
        Object[] objectArray = new LocalQuickFix[1];
        String string2 = problem.getShortMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"problem.shortMessage");
        objectArray[0] = (LocalQuickFix)new ReplaceTypoTitleAction(familyName, string2);
        ArrayList result2 = CollectionsKt.arrayListOf((Object[])objectArray);
        List<String> list = problem.getCorrections();
        Intrinsics.checkNotNullExpressionValue(list, (String)"problem.corrections");
        Iterable $this$forEachIndexed$iv = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String replacement;
            void var22_24;
            void suggestion;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string3 = (String)item$iv;
            int index = n;
            boolean bl2 = false;
            int commonPrefix = StringUtil.commonPrefixLength((CharSequence)((CharSequence)suggestion), (CharSequence)replacedText);
            int n2 = StringUtil.commonSuffixLength((CharSequence)((CharSequence)suggestion), (CharSequence)replacedText);
            int n3 = suggestion.length();
            int n4 = replacementRange.getLength();
            int n5 = 0;
            n3 = Math.min(n3, n4) - commonPrefix;
            n4 = 0;
            int commonSuffix = Math.min(n2, n3);
            TextRange localRange = new TextRange(replacementRange.getStartOffset() + commonPrefix, replacementRange.getEndOffset() - commonSuffix);
            Intrinsics.checkNotNullExpressionValue((Object)suggestion, (String)"suggestion");
            n5 = suggestion.length() - commonSuffix;
            boolean bl3 = false;
            void v7 = var22_24;
            if (v7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkNotNullExpressionValue((Object)v7.substring(commonPrefix, n5), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Rule rule = problem.getRule();
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"problem.rule");
            SmartPsiFileRange smartPsiFileRange = spm.createSmartPsiFileRangePointer(file2, problem.getText().textRangeToFile(localRange));
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiFileRange, (String)"spm.createSmartPsiFileRa\u2026tRangeToFile(localRange))");
            result2.add(new ChangeToVariantAction(rule, index, familyName, (String)suggestion, replacement, underlineRanges, smartPsiFileRange));
        }
        return result2;
    }

    private GrazieReplaceTypoQuickFix() {
    }

    static {
        GrazieReplaceTypoQuickFix grazieReplaceTypoQuickFix;
        INSTANCE = grazieReplaceTypoQuickFix = new GrazieReplaceTypoQuickFix();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ReplaceTypoTitleAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceTitleIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "family", "", "title", "(Ljava/lang/String;Ljava/lang/String;)V", "intellij.grazie.core"})
    private static final class ReplaceTypoTitleAction
    extends ChoiceTitleIntentionAction
    implements HighPriorityAction {
        public ReplaceTypoTitleAction(@IntentionFamilyName @NotNull String family, @IntentionName @NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            super(family, title);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016J\"\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\"\u001a\u00020!H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/quickfix/GrazieReplaceTypoQuickFix$ChangeToVariantAction;", "Lcom/intellij/codeInsight/intention/choice/ChoiceVariantIntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "rule", "Lcom/intellij/grazie/text/Rule;", "index", "", "family", "", "suggestion", "replacement", "underlineRanges", "", "Lcom/intellij/psi/SmartPsiFileRange;", "replacementRange", "(Lcom/intellij/grazie/text/Rule;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/intellij/psi/SmartPsiFileRange;)V", "getIndex", "()I", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFamilyName", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "getName", "getTooltipText", "isAvailable", "", "startInWriteAction", "intellij.grazie.core"})
    private static final class ChangeToVariantAction
    extends ChoiceVariantIntentionAction
    implements HighPriorityAction {
        private final Rule rule;
        private final int index;
        private final String family;
        private final String suggestion;
        private final String replacement;
        private final List<SmartPsiFileRange> underlineRanges;
        private final SmartPsiFileRange replacementRange;

        @NotNull
        public String getName() {
            String string = this.suggestion;
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            String string2 = charSequence.length() > 0 ? string : null;
            if (string2 == null) {
                string2 = SwingKTKt.msg("grazie.grammar.quickfix.remove.typo.tooltip", new String[0]);
            }
            return string2;
        }

        @NotNull
        public String getTooltipText() {
            CharSequence charSequence = this.suggestion;
            boolean bl = false;
            return charSequence.length() > 0 ? SwingKTKt.msg("grazie.grammar.quickfix.replace.typo.tooltip", this.suggestion) : SwingKTKt.msg("grazie.grammar.quickfix.remove.typo.tooltip", new String[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.family;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return this.replacementRange.getRange() != null;
        }

        @NotNull
        public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return (FileModifier)this;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            GrazieFUSCounter.INSTANCE.quickFixInvoked(this.rule, project, "accept.suggestion");
            Segment segment = this.replacementRange.getRange();
            if (segment == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)segment, (String)"this.replacementRange.range ?: return");
            Segment replacementRange = segment;
            FileViewProvider fileViewProvider = file2.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"file.viewProvider");
            Document document = fileViewProvider.getDocument();
            if (document == null) {
                return;
            }
            Document document2 = document;
            Iterable $this$forEach$iv = this.underlineRanges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Segment segment2;
                SmartPsiFileRange underline = (SmartPsiFileRange)element$iv;
                boolean bl = false;
                if (underline.getRange() == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                Segment it = segment2;
                boolean bl4 = false;
                UpdateHighlightersUtil.removeHighlightersWithExactRange((Document)document2, (Project)project, (Segment)it);
            }
            document2.replaceString(replacementRange.getStartOffset(), replacementRange.getEndOffset(), (CharSequence)this.replacement);
        }

        public boolean startInWriteAction() {
            return true;
        }

        public int getIndex() {
            return this.index;
        }

        public ChangeToVariantAction(@NotNull Rule rule, int index, @IntentionFamilyName @NotNull String family, @NlsSafe @NotNull String suggestion, @NotNull String replacement, @NotNull List<? extends SmartPsiFileRange> underlineRanges, @NotNull SmartPsiFileRange replacementRange) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            Intrinsics.checkNotNullParameter((Object)family, (String)"family");
            Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            Intrinsics.checkNotNullParameter(underlineRanges, (String)"underlineRanges");
            Intrinsics.checkNotNullParameter((Object)replacementRange, (String)"replacementRange");
            this.rule = rule;
            this.index = index;
            this.family = family;
            this.suggestion = suggestion;
            this.replacement = replacement;
            this.underlineRanges = underlineRanges;
            this.replacementRange = replacementRange;
        }
    }
}

