/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.jlanguage;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.LangTool;
import com.intellij.grazie.jlanguage.broker.GrazieDynamicDataBroker;
import com.intellij.grazie.jlanguage.filters.UppercaseMatchFilter;
import com.intellij.grazie.utils.JLangUtilsKt;
import com.intellij.util.containers.ContainerUtil;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.Tag;
import org.languagetool.broker.ClassBroker;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ExampleSentence;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.spelling.SpellingCheckRule;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0015\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aJ\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011H\u0016J\u0014\u0010\"\u001a\u00020\u0018*\u00020#2\u0006\u0010$\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/grazie/jlanguage/LangTool;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "()V", "MINIMUM_EXAMPLE_SIMILARITY", "", "langs", "", "Lcom/intellij/grazie/jlanguage/Lang;", "Lorg/languagetool/JLanguageTool;", "levenshtein", "Lorg/apache/commons/text/similarity/LevenshteinDistance;", "rulesEnabledByDefault", "", "", "createTool", "lang", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "getTool", "globalIdPrefix", "globalIdPrefix$intellij_grazie_core", "init", "", "isRuleEnabledByDefault", "", "ruleId", "isRuleEnabledByDefault$intellij_grazie_core", "removeVerySimilarExamples", "", "Lorg/languagetool/rules/IncorrectExample;", "examples", "update", "prevState", "newState", "isSimilarTo", "", "sequence", "intellij.grazie.core"})
public final class LangTool
implements GrazieStateLifecycle {
    private static final Map<Lang, JLanguageTool> langs;
    private static final Map<Lang, Set<String>> rulesEnabledByDefault;
    private static final double MINIMUM_EXAMPLE_SIMILARITY = 0.2;
    private static final LevenshteinDistance levenshtein;
    @NotNull
    public static final LangTool INSTANCE;

    @NotNull
    public final String globalIdPrefix$intellij_grazie_core(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return "LanguageTool." + lang.getRemote().getIso().name() + ".";
    }

    @NotNull
    public final JLanguageTool getTool(@NotNull Lang lang, @NotNull GrazieConfig.State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        JLanguageTool jLanguageTool = langs.computeIfAbsent(lang, new Function(lang, state){
            final /* synthetic */ Lang $lang;
            final /* synthetic */ GrazieConfig.State $state;

            @NotNull
            public final JLanguageTool apply(@NotNull Lang it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return LangTool.access$createTool(LangTool.INSTANCE, this.$lang, this.$state);
            }
            {
                this.$lang = lang;
                this.$state = state;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)jLanguageTool, (String)"langs.computeIfAbsent(la\u2026createTool(lang, state) }");
        return jLanguageTool;
    }

    public static /* synthetic */ JLanguageTool getTool$default(LangTool langTool, Lang lang, GrazieConfig.State state, int n, Object object) {
        if ((n & 2) != 0) {
            state = GrazieConfig.Companion.get();
        }
        return langTool.getTool(lang, state);
    }

    /*
     * WARNING - void declaration
     */
    private final JLanguageTool createTool(Lang lang, GrazieConfig.State state) {
        Iterator $this$mapNotNullTo$iv$iv;
        boolean bl;
        int n;
        void $this$mapNotNullTo$iv$iv2;
        Language jLanguage = lang.getJLanguage();
        boolean bl2 = jLanguage != null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Trying to get LangTool for not available language";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        JLanguageTool jLanguageTool = new JLanguageTool(jLanguage, null, new ResultCache(1000L));
        bl3 = false;
        bl4 = false;
        JLanguageTool $this$apply = jLanguageTool;
        boolean bl6 = false;
        $this$apply.setCheckCancelledCallback((JLanguageTool.CheckCancelledCallback)createTool.2.1.INSTANCE);
        $this$apply.addMatchFilter((RuleMatchFilter)new UppercaseMatchFilter());
        String prefix = INSTANCE.globalIdPrefix$intellij_grazie_core(lang);
        Iterable $this$mapNotNull$iv = state.getUserDisabledRules();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<String> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl7 = false;
            String it = (String)element$iv$iv;
            boolean bl8 = false;
            if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                String string2 = it;
                int n2 = prefix.length();
                n = 0;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n2);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            if (string == null) continue;
            String string5 = string;
            boolean bl9 = false;
            bl = false;
            String it$iv$iv = string5;
            boolean bl10 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set disabledRules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = state.getUserEnabledRules();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl11 = false;
            String it = (String)element$iv$iv;
            boolean bl12 = false;
            if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                String string6 = it;
                n = prefix.length();
                boolean bl13 = false;
                String string7 = string6;
                if (string7 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n);
                string = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = null;
            }
            if (string == null) continue;
            String string9 = string;
            bl = false;
            boolean bl14 = false;
            String it$iv$iv = string9;
            boolean bl15 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set enabledRules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$forEach$iv = disabledRules;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl16 = false;
            $this$apply.disableRule(id);
        }
        $this$forEach$iv = enabledRules;
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl17 = false;
            $this$apply.enableRule(id);
        }
        createTool.2.4 $fun$loadConfigFile$4 = createTool.2.4.INSTANCE;
        $fun$loadConfigFile$4.invoke("en/enabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>($this$apply, disabledRules, lang, state){
            final /* synthetic */ JLanguageTool $this_apply;
            final /* synthetic */ Set $disabledRules;
            final /* synthetic */ Lang $lang$inlined;
            final /* synthetic */ GrazieConfig.State $state$inlined;
            {
                this.$this_apply = jLanguageTool;
                this.$disabledRules = set;
                this.$lang$inlined = lang;
                this.$state$inlined = state;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String ruleId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang$inlined.getIso().name()) && !this.$disabledRules.contains(ruleId)) {
                    this.$this_apply.enableRule(ruleId);
                }
            }
        }));
        $fun$loadConfigFile$4.invoke("en/disabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>($this$apply, enabledRules, lang, state){
            final /* synthetic */ JLanguageTool $this_apply;
            final /* synthetic */ Set $enabledRules;
            final /* synthetic */ Lang $lang$inlined;
            final /* synthetic */ GrazieConfig.State $state$inlined;
            {
                this.$this_apply = jLanguageTool;
                this.$enabledRules = set;
                this.$lang$inlined = lang;
                this.$state$inlined = state;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String ruleId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang$inlined.getIso().name()) && !this.$enabledRules.contains(ruleId)) {
                    this.$this_apply.disableRule(ruleId);
                }
            }
        }));
        $fun$loadConfigFile$4.invoke("en/enabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>($this$apply, lang, state){
            final /* synthetic */ JLanguageTool $this_apply;
            final /* synthetic */ Lang $lang$inlined;
            final /* synthetic */ GrazieConfig.State $state$inlined;
            {
                this.$this_apply = jLanguageTool;
                this.$lang$inlined = lang;
                this.$state$inlined = state;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String categoryId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang$inlined.getIso().name())) {
                    this.$this_apply.enableRuleCategory(new CategoryId(categoryId));
                }
            }
        }));
        $fun$loadConfigFile$4.invoke("en/disabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>($this$apply, lang, state){
            final /* synthetic */ JLanguageTool $this_apply;
            final /* synthetic */ Lang $lang$inlined;
            final /* synthetic */ GrazieConfig.State $state$inlined;
            {
                this.$this_apply = jLanguageTool;
                this.$lang$inlined = lang;
                this.$state$inlined = state;
                super(2);
            }

            public final void invoke(@NotNull String iso, @NotNull String categoryId) {
                Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
                Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
                if (Intrinsics.areEqual((Object)iso, (Object)this.$lang$inlined.getIso().name())) {
                    this.$this_apply.disableCategory(new CategoryId(categoryId));
                }
            }
        }));
        List list = $this$apply.getAllSpellingCheckRules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allSpellingCheckRules");
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv2) {
            SpellingCheckRule rule = (SpellingCheckRule)element$iv;
            boolean bl18 = false;
            SpellingCheckRule spellingCheckRule = rule;
            Intrinsics.checkNotNullExpressionValue((Object)spellingCheckRule, (String)"rule");
            $this$apply.disableRule(spellingCheckRule.getId());
        }
        for (Rule rule : $this$apply.getAllActiveRules()) {
            if (!rule.hasTag(Tag.picky)) continue;
            Rule rule2 = rule;
            Intrinsics.checkNotNullExpressionValue((Object)rule2, (String)"rule");
            if (enabledRules.contains(rule2.getId())) continue;
            $this$apply.disableRule(rule.getId());
        }
        Iterator iterator3 = $this$apply.getAllRules().iterator();
        while (iterator3.hasNext()) {
            Rule rule;
            Rule rule3 = rule = (Rule)iterator3.next();
            Intrinsics.checkNotNullExpressionValue((Object)rule3, (String)"rule");
            rule3.setCorrectExamples(CollectionsKt.emptyList());
            rule.setErrorTriggeringExamples(CollectionsKt.emptyList());
            List list2 = rule.getIncorrectExamples();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"rule.incorrectExamples");
            rule.setIncorrectExamples(INSTANCE.removeVerySimilarExamples(list2));
        }
        Language language = $this$apply.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"this.language");
        language.getDisambiguator();
        Authenticator.setDefault(null);
        return jLanguageTool;
    }

    private final List<IncorrectExample> removeVerySimilarExamples(List<IncorrectExample> examples) {
        ArrayList<IncorrectExample> accepted = new ArrayList<IncorrectExample>();
        for (IncorrectExample example : examples) {
            Object v3;
            block6: {
                boolean bl;
                block5: {
                    Iterable $this$none$iv = accepted;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            IncorrectExample it = (IncorrectExample)element$iv;
                            boolean bl2 = false;
                            if (!INSTANCE.isSimilarTo(JLangUtilsKt.getText((ExampleSentence)it), JLangUtilsKt.getText((ExampleSentence)example))) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                List list = example.getCorrections();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"example.corrections");
                Iterable iterable = list;
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                boolean bl4 = false;
                for (Object t : iterable2) {
                    String it = (String)t;
                    boolean bl5 = false;
                    String string = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                    CharSequence charSequence = string;
                    boolean bl6 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            String firstCorrection = v3;
            accepted.add(new IncorrectExample(example.getExample(), ContainerUtil.createMaybeSingletonList((Object)firstCorrection)));
            if (accepted.size() <= 5) continue;
            break;
        }
        return accepted;
    }

    private final boolean isSimilarTo(CharSequence $this$isSimilarTo, CharSequence sequence) {
        return (double)levenshtein.apply($this$isSimilarTo, sequence).intValue() / (double)$this$isSimilarTo.length() < 0.2;
    }

    public final boolean isRuleEnabledByDefault$intellij_grazie_core(@NotNull Lang lang, @NotNull String ruleId) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        Set<String> set = rulesEnabledByDefault.computeIfAbsent(lang, new Function(lang){
            final /* synthetic */ Lang $lang;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<String> apply(@NotNull Lang it) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                List list = LangTool.access$createTool(LangTool.INSTANCE, this.$lang, new GrazieConfig.State(null, null, null, false, null, null, null, null, null, null, 1023, null)).getAllActiveRules();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createTool(lang, GrazieC\u2026g.State()).allActiveRules");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Rule rule = (Rule)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    String string = v1.getId();
                    collection.add(string);
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
            {
                this.$lang = lang;
            }
        });
        Intrinsics.checkNotNullExpressionValue(set, (String)"rulesEnabledByDefault.co\u2026p { it.id }.toSet()\n    }");
        Set<String> activeIds2 = set;
        return activeIds2.contains(ruleId);
    }

    @Override
    public void init(@NotNull GrazieConfig.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Iterable $this$forEach$iv = state.getAvailableLanguages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Lang it = (Lang)((Object)element$iv);
            boolean bl = false;
            INSTANCE.getTool(it, state);
        }
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (Intrinsics.areEqual(prevState.getAvailableLanguages(), newState.getAvailableLanguages()) && Intrinsics.areEqual(prevState.getUserDisabledRules(), newState.getUserDisabledRules()) && Intrinsics.areEqual(prevState.getUserEnabledRules(), newState.getUserEnabledRules())) {
            return;
        }
        langs.clear();
        rulesEnabledByDefault.clear();
        this.init(newState);
    }

    private LangTool() {
    }

    static {
        LangTool langTool;
        INSTANCE = langTool = new LangTool();
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentSoftValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConcurrentSoftValueMap()");
        langs = concurrentMap;
        rulesEnabledByDefault = new ConcurrentHashMap();
        JLanguageTool.setDataBroker((ResourceDataBroker)GrazieDynamicDataBroker.INSTANCE);
        JLanguageTool.setClassBrokerBroker((ClassBroker)1.INSTANCE);
        levenshtein = new LevenshteinDistance();
    }

    public static final /* synthetic */ JLanguageTool access$createTool(LangTool $this, Lang lang, GrazieConfig.State state) {
        return $this.createTool(lang, state);
    }
}

