/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.tokenizer.sentence.SRXSentenceTokenizer;
import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/text/CommentProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "isAboutIdentifierParts", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "text", "Lcom/intellij/grazie/text/TextContent;", "isInFirstSentence", "isNumberRange", "isPathPart", "isTodoComment", "file", "Lcom/intellij/psi/PsiFile;", "looksLikeCode", "", "shouldIgnore", "textAround", "range", "Lcom/intellij/openapi/util/TextRange;", "intellij.grazie.core"})
public final class CommentProblemFilter
extends ProblemFilter {
    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
        TextContent text2 = textContent;
        TextContent.TextDomain domain = text2.getDomain();
        if (domain == TextContent.TextDomain.COMMENTS || domain == TextContent.TextDomain.DOCUMENTATION) {
            PsiElement psiElement = text2.getCommonParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"text.commonParent");
            PsiFile psiFile = psiElement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"text.commonParent.containingFile");
            if (this.isTodoComment(psiFile, text2)) {
                return true;
            }
            Rule rule = problem.getRule();
            Intrinsics.checkNotNullExpressionValue((Object)rule, (String)"problem.rule");
            String string = rule.getGlobalId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"problem.rule.globalId");
            if (StringsKt.endsWith$default((String)string, (String)"DOUBLE_PUNCTUATION", (boolean)false, (int)2, null) && (this.isNumberRange(problem, text2) || this.isPathPart(problem, text2))) {
                return true;
            }
            Rule rule2 = problem.getRule();
            Intrinsics.checkNotNullExpressionValue((Object)rule2, (String)"problem.rule");
            String string2 = rule2.getGlobalId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"problem.rule.globalId");
            if (StringsKt.startsWith$default((String)string2, (String)"LanguageTool.", (boolean)false, (int)2, null) && this.isAboutIdentifierParts(problem, text2)) {
                return true;
            }
        }
        if (domain == TextContent.TextDomain.DOCUMENTATION) {
            return this.isInFirstSentence(problem) && problem.fitsGroup(new RuleGroup("INCOMPLETE_SENTENCE"));
        }
        if (domain == TextContent.TextDomain.COMMENTS) {
            CharSequence charSequence = text2;
            TextRange textRange = problem.getHighlightRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"problem.highlightRange");
            if (this.looksLikeCode(this.textAround(charSequence, textRange))) {
                return true;
            }
            if (problem.fitsGroup(new RuleGroup("UNDECORATED_SENTENCE_SEPARATION"))) {
                return true;
            }
            if (Text.isSingleSentence(text2) && problem.fitsGroup(RuleGroup.UNDECORATED_SINGLE_SENTENCE)) {
                return true;
            }
        }
        return false;
    }

    private final CharSequence textAround(CharSequence text2, TextRange range) {
        return text2.subSequence(RangesKt.coerceAtLeast((int)(range.getStartOffset() - 20), (int)0), RangesKt.coerceAtMost((int)(range.getEndOffset() + 20), (int)text2.length()));
    }

    private final boolean looksLikeCode(CharSequence text2) {
        int codeChars = 0;
        int textChars = 0;
        CharSequence charSequence = text2;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (StringsKt.contains$default((CharSequence)"(){}[]<>=+-*/%|&!;,.:\"'\\@$#^", (char)c, (boolean)false, (int)2, null)) {
                ++codeChars;
                continue;
            }
            char c2 = c;
            boolean bl = false;
            if (!Character.isLetterOrDigit(c2)) continue;
            ++textChars;
        }
        return codeChars > 0 && textChars / codeChars < 4;
    }

    private final boolean isInFirstSentence(TextProblem problem) {
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"problem.text");
        CharSequence charSequence = textContent;
        int n = 0;
        TextRange textRange = problem.getHighlightRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"problem.highlightRange");
        int n2 = textRange.getStartOffset();
        boolean bl = false;
        return SRXSentenceTokenizer.INSTANCE.tokenize(((Object)charSequence.subSequence(n, n2)).toString()).size() <= 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNumberRange(TextProblem problem, TextContent text2) {
        TextRange textRange = problem.getHighlightRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"problem.highlightRange");
        TextRange range = textRange;
        if (range.getStartOffset() <= 0) return false;
        if (range.getEndOffset() >= text2.length()) return false;
        char c = text2.charAt(range.getStartOffset() - 1);
        boolean bl = false;
        if (!Character.isDigit(c)) return false;
        c = text2.charAt(range.getEndOffset());
        bl = false;
        if (!Character.isDigit(c)) return false;
        return true;
    }

    private final boolean isPathPart(TextProblem problem, TextContent text2) {
        TextRange textRange = problem.getHighlightRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"problem.highlightRange");
        TextRange range = textRange;
        return StringsKt.endsWith$default((CharSequence)text2.subSequence(0, range.getStartOffset()), (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text2.subSequence(range.getEndOffset(), text2.length()), (char)'/', (boolean)false, (int)2, null);
    }

    private final boolean isAboutIdentifierParts(TextProblem problem, TextContent text2) {
        TextRange textRange = problem.getHighlightRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"problem.highlightRange");
        TextRange range = textRange;
        return StringsKt.endsWith$default((CharSequence)text2.subSequence(0, range.getStartOffset()), (char)'_', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)text2.subSequence(range.getEndOffset(), text2.length()), (char)'_', (boolean)false, (int)2, null);
    }

    private final boolean isTodoComment(PsiFile file2, TextContent text2) {
        boolean bl;
        block1: {
            TodoItem[] todoItemArray = PsiTodoSearchHelper.SERVICE.getInstance((Project)file2.getProject()).findTodoItems(file2);
            Intrinsics.checkNotNullExpressionValue((Object)todoItemArray, (String)"PsiTodoSearchHelper.SERV\u2026ject).findTodoItems(file)");
            TodoItem[] $this$any$iv = todoItemArray;
            boolean $i$f$any = false;
            TodoItem[] todoItemArray2 = $this$any$iv;
            int n = todoItemArray2.length;
            for (int i = 0; i < n; ++i) {
                TodoItem element$iv;
                TodoItem it = element$iv = todoItemArray2[i];
                boolean bl2 = false;
                TodoItem todoItem = it;
                Intrinsics.checkNotNullExpressionValue((Object)todoItem, (String)"it");
                if (!text2.intersectsRange(todoItem.getTextRange())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }
}

