/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCIncludeCPPAnnotatorKt;
import com.jetbrains.cidr.lang.daemon.OCNavigateIncludeCPP;
import com.jetbrains.cidr.lang.parser.OCPreprocessorDirectiveElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/OCIncludeCPPAnnotator;", "Lcom/jetbrains/cidr/lang/daemon/OCAnnotator;", "()V", "doAnnotate", "", "directive", "Lcom/jetbrains/cidr/lang/psi/OCIncludeDirective;", "includeChild", "Lcom/intellij/psi/PsiElement;", "cppChild", "doColorText", "includeRange", "Lcom/intellij/openapi/util/TextRange;", "cppRange", "isEnabled", "", "file", "Lcom/intellij/psi/PsiFile;", "visitImportDirective", "intellij.c"})
public final class OCIncludeCPPAnnotator
extends OCAnnotator {
    @Override
    protected boolean isEnabled(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return super.isEnabled(file) && PlatformUtils.isCidr();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitImportDirective(@NotNull OCIncludeDirective directive) {
        Object v7;
        PsiElement includeChild;
        block9: {
            void $this$firstOrNull$iv;
            Object v4;
            block8: {
                block11: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
                        if (this.getHolder() == null) break block10;
                        String string = directive.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"directive.text");
                        CharSequence charSequence = string;
                        boolean bl = false;
                        if (charSequence.length() == 0 || directive.getDelimiters() != OCIncludeDirective.Delimiters.ANGLE_BRACKETS) break block10;
                        OCFile oCFile = directive.getContainingOCFile();
                        Intrinsics.checkNotNullExpressionValue((Object)oCFile, (String)"directive.containingOCFile");
                        OCLanguageKind oCLanguageKind = oCFile.getKind();
                        Intrinsics.checkNotNullExpressionValue((Object)oCLanguageKind, (String)"directive.containingOCFile.kind");
                        if (oCLanguageKind.isCpp() && directive.getIncludedFile() == null) break block11;
                    }
                    return;
                }
                SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)directive);
                Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"SyntaxTraverser\n        \u2026 .psiTraverser(directive)");
                Iterable $this$firstOrNull$iv2 = (Iterable)syntaxTraverser;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv2) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(OCElementUtil.getElementType(it) instanceof OCPreprocessorDirectiveElementType)) continue;
                    v4 = element$iv;
                    break block8;
                }
                v4 = null;
            }
            PsiElement psiElement = v4;
            if (psiElement == null) {
                return;
            }
            includeChild = psiElement;
            SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)directive);
            Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"SyntaxTraverser\n        \u2026 .psiTraverser(directive)");
            Iterable $i$f$firstOrNull = (Iterable)syntaxTraverser;
            boolean $i$f$firstOrNull2 = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)OCElementUtil.getElementType(it), (Object)((Object)OCTokenTypes.HEADER_PATH_LITERAL))) continue;
                v7 = element$iv;
                break block9;
            }
            v7 = null;
        }
        PsiElement psiElement = v7;
        if (psiElement == null) {
            return;
        }
        PsiElement cppChild = psiElement;
        if (Intrinsics.areEqual((Object)includeChild.getText(), (Object)"#include") && StringUtil.equalsIgnoreCase((CharSequence)directive.getReferenceText(), (CharSequence)"C++")) {
            this.doAnnotate(directive, includeChild, cppChild);
        }
    }

    private final void doAnnotate(OCIncludeDirective directive, PsiElement includeChild, PsiElement cppChild) {
        OCElementsRange oCElementsRange = new OCElementsRange(directive, directive).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (oCElementsRange == null || (oCElementsRange = oCElementsRange.getTextRange()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)oCElementsRange, (String)"OCElementsRange(directiv\u2026ET) ?.textRange ?: return");
        OCElementsRange range = oCElementsRange;
        OCElementsRange oCElementsRange2 = new OCElementsRange(includeChild, includeChild).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (oCElementsRange2 == null || (oCElementsRange2 = oCElementsRange2.getTextRange()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)oCElementsRange2, (String)"OCElementsRange(includeC\u2026ET) ?.textRange ?: return");
        OCElementsRange includeRange = oCElementsRange2;
        OCElementsRange oCElementsRange3 = new OCElementsRange(cppChild, cppChild).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (oCElementsRange3 == null || (oCElementsRange3 = oCElementsRange3.getTextRange()) == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)oCElementsRange3, (String)"OCElementsRange(cppChild\u2026ET) ?.textRange ?: return");
        OCElementsRange cppRange = oCElementsRange3;
        AnnotationHolder annotationHolder = this.getHolder();
        Intrinsics.checkNotNull((Object)annotationHolder);
        annotationHolder.newAnnotation(OCIncludeCPPAnnotatorKt.access$getINCLUDE_CPP_HIGHLIGHT_SEVERITY$p(), OCBundle.message("include.cpp.message", new Object[0])).range((TextRange)range).withFix((IntentionAction)new OCNavigateIncludeCPP(directive)).create();
        this.doColorText((TextRange)includeRange, (TextRange)cppRange);
    }

    /*
     * WARNING - void declaration
     */
    private final void doColorText(TextRange includeRange, TextRange cppRange) {
        int n = 0;
        int n2 = includeRange.getLength();
        while (n < n2) {
            void r;
            TextRange subRange = new TextRange((int)r, (int)(r + true));
            TextAttributes attributes = new TextAttributes();
            attributes.setForegroundColor((Color)OCIncludeCPPAnnotatorKt.access$getRAINBOW_COLORS$p()[r % OCIncludeCPPAnnotatorKt.access$getRAINBOW_COLORS$p().length]);
            AnnotationHolder annotationHolder = this.getHolder();
            Intrinsics.checkNotNull((Object)annotationHolder);
            annotationHolder.newAnnotation(HighlightSeverity.INFORMATION, "").range(includeRange.cutOut(subRange)).enforcedTextAttributes(attributes).create();
            ++r;
        }
        TextAttributes attributes = new TextAttributes();
        attributes.setForegroundColor((Color)OCIncludeCPPAnnotatorKt.access$getCPP_COLOR$p());
        AnnotationHolder annotationHolder = this.getHolder();
        Intrinsics.checkNotNull((Object)annotationHolder);
        annotationHolder.newAnnotation(HighlightSeverity.INFORMATION, "").range(cppRange).enforcedTextAttributes(attributes).create();
    }
}

