/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCCompoundInitializerCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCParameterListCallPlace;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<PsiElement, FunctionInfoWrapper, OCExpression> {
    public static final Logger LOG = Logger.getInstance(OCFunctionParameterInfoHandler.class);
    private static final Condition<String> IS_UNNAMED = s -> "<unnamed>".equals(s);

    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        int startOffset;
        int offset;
        PsiFile file;
        OCFunctionCallPlace<?> callPlace;
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((callPlace = OCFunctionParameterInfoHandler.findCallPlace(file = context.getFile(), offset = context.getOffset(), startOffset = context.getParameterListStart())) != null) {
            ArrayList<OCFunctionCallOption> callOptions = new ArrayList<OCFunctionCallOption>();
            callPlace.collectCallOptions(callOptions);
            callOptions.sort((o1, o2) -> Comparing.compare((int)o1.getOffset(), (int)o2.getOffset()));
            ArrayList<FunctionInfoWrapper> overloads = new ArrayList<FunctionInfoWrapper>();
            OCResolveContext resolveContext = OCResolveContext.forPsi(callPlace.getElement());
            block0: for (OCFunctionCallOption option : callOptions) {
                OCFunctionParameterInfo info = option.getParameterInfo();
                OCFunctionType funcType = info.getType();
                for (int i2 = 0; i2 < overloads.size(); ++i2) {
                    FunctionInfoWrapper other = (FunctionInfoWrapper)overloads.get(i2);
                    OCFunctionType otherType = other.getInfo().getType();
                    if (!otherType.equalsAfterResolving(funcType, resolveContext)) continue;
                    if (!OCFunctionParameterInfoHandler.hasUnnamedParam(otherType) || OCFunctionParameterInfoHandler.hasUnnamedParam(funcType)) continue block0;
                    overloads.set(i2, new FunctionInfoWrapper(info));
                    continue block0;
                }
                overloads.add(new FunctionInfoWrapper(info));
            }
            context.setItemsToShow(overloads.toArray());
        }
        return callPlace == null ? null : (PsiElement)callPlace.getElement();
    }

    private static boolean hasUnnamedParam(@NotNull OCFunctionType funcType) {
        List<String> names;
        if (funcType == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if ((names = funcType.getParameterNames()) == null) {
            return funcType.getParameterTypes().size() > 0;
        }
        return ContainerUtil.find(names, IS_UNNAMED) != null;
    }

    @Nullable
    private static OCFunctionCallPlace<?> findCallPlace(PsiFile file, int offset, int startOffset) {
        if (file == null) {
            return null;
        }
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement e1 = file.findElementAt(offset);
        PsiElement e2 = file.findElementAt(startOffset);
        if (e1 == null || e2 == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.findCommonContext((PsiElement)e1, (PsiElement)e2);
        if (element == null) {
            return null;
        }
        while (element != null) {
            OCFunctionCallPlace<? extends PsiElement> place = OCFunctionParameterInfoHandler.callPlace(element);
            if (place != null) {
                return place;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    @Nullable
    private static OCFunctionCallPlace<? extends PsiElement> callPlace(@NotNull PsiElement element) {
        if (element == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (element instanceof OCArgumentList) {
            return new OCArgumentListCallPlace((OCArgumentList)element);
        }
        if (!(element instanceof OCElement)) {
            return null;
        }
        if (!((OCElement)element).getContainingOCFile().isCpp()) {
            return null;
        }
        if (element instanceof OCParameterList) {
            return new OCParameterListCallPlace((OCParameterList)element);
        }
        if (element instanceof OCCompoundInitializer) {
            return new OCCompoundInitializerCallPlace((OCCompoundInitializer)element);
        }
        return null;
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(4);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.parameterInfo");
        context.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace<?> place;
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return (place = OCFunctionParameterInfoHandler.findCallPlace(context.getFile(), context.getOffset(), context.getParameterListStart())) == null ? null : (PsiElement)place.getElement();
    }

    public void updateParameterInfo(@NotNull PsiElement parameterOwner, @NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace<? extends PsiElement> callPlace;
        if (parameterOwner == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(7);
        }
        OCLog.LOG.assertTrue((callPlace = OCFunctionParameterInfoHandler.callPlace(parameterOwner)) != null);
        int offset = context.getOffset();
        if (!parameterOwner.getTextRange().contains(offset)) {
            context.removeHint();
            return;
        }
        int index = 0;
        for (ASTNode child = parameterOwner.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.COMMA) continue;
            ++index;
        }
        context.setCurrentParameter(index);
        Object[] methods = context.getObjectsToView();
        List<OCExpression> argExpressions = callPlace.getArgumentExpressions();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            FunctionInfoWrapper wrapper = (FunctionInfoWrapper)methods[i2];
            OCFunctionType funcType = wrapper.getInfo().getType();
            boolean isEnabled = OCFunctionParameterInfoHandler.isApplicableBeforeIndex(funcType, argExpressions, index);
            context.setUIComponentEnabled(i2, isEnabled);
            wrapper.ui = OCFunctionParameterInfoHandler.calcUI(wrapper.getInfo(), index, isEnabled, parameterOwner);
        }
    }

    public static boolean isApplicableBeforeIndex(@NotNull OCFunctionType funcType, @NotNull List<OCExpression> argExpressions, int index) {
        if (funcType == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (argExpressions == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(9);
        }
        List<OCType> paramTypes = funcType.getParameterTypes();
        return (index == 0 || paramTypes.size() > index || funcType.isVararg()) && OCFunctionParameterInfoHandler.isAssignableParametersBeforeGivenIndex(paramTypes, argExpressions, index + 1);
    }

    private static boolean isAssignableParametersBeforeGivenIndex(@NotNull List<? extends OCType> params, @NotNull List<OCExpression> args, int length) {
        if (params == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (args == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(11);
        }
        int min = Math.min(length, Math.min(args.size(), params.size()));
        for (int j = 0; j < min; ++j) {
            OCType argType;
            OCType paramType = params.get(j);
            OCExpression arg = args.get(j);
            if (arg == null || !paramType.checkCompatible(argType = arg.getResolvedType(), arg, arg, OCResolveContext.forPsi(arg)).getState().isError(arg)) continue;
            return false;
        }
        return true;
    }

    public void updateUI(@NotNull FunctionInfoWrapper wrapper, @NotNull ParameterInfoUIContext context) {
        PsiElement owner;
        if (wrapper == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if ((owner = context.getParameterOwner()) != null) {
            OCFunctionParameterInfoHandler.updateFunctionUI(wrapper.ui, context);
        }
    }

    private static FunctionInfoWrapper.UI calcUI(@NotNull OCFunctionParameterInfo info, int currentParameter, boolean isEnabled, @NotNull PsiElement context) {
        int commaStart;
        if (info == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(14);
        }
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(15);
        }
        StringBuilder buffer = new StringBuilder();
        OCFunctionType type = info.getType();
        List<String> defParamValues = info.getDefaultParameterValues();
        List<OCType> paramTypes = type.getParameterTypes();
        @Nullable List<String> paramNames = type.getParameterNames();
        String paramTypeHint = null;
        if ((context instanceof OCArgumentList || context instanceof OCParameterList) && context.getParent() instanceof OCDeclarator && (paramTypeHint = ((OCDeclarator)context.getParent()).getType().getBestNameInContext(context)) != null && (commaStart = paramTypeHint.indexOf(40)) != -1) {
            paramTypeHint = paramTypeHint.substring(0, commaStart);
        }
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramTypes.isEmpty()) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            int numParams = paramTypes.size();
            for (int i2 = 0; i2 < numParams; ++i2) {
                int startOffset = buffer.length();
                String typeText = paramTypes.get(i2).getBestNameInContext(context, paramTypeHint);
                String paramName = paramNames == null ? "<unnamed>" : paramNames.get(i2);
                String defValue = defParamValues == null ? null : defParamValues.get(i2);
                buffer.append(OCDocUtil.parameterSignature(typeText, paramName, defValue));
                int endOffset = buffer.length();
                if (i2 < numParams - 1) {
                    buffer.append(", ");
                }
                if (!isEnabled || i2 != currentParameter && (i2 != numParams - 1 || !type.isVararg() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return new FunctionInfoWrapper.UI(buffer.toString(), highlightStartOffset, highlightEndOffset);
    }

    public static String updateFunctionUI(@NotNull FunctionInfoWrapper.UI ui, ParameterInfoUIContext context) {
        if (ui == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(16);
        }
        return context.setupUIComponentPresentation(ui.text, ui.highlightStartOffset, ui.highlightEndOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    public OCExpression @NotNull [] getActualParameters(@NotNull PsiElement parameterOwner) {
        OCFunctionCallPlace<? extends PsiElement> callPlace;
        if (parameterOwner == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(17);
        }
        OCLog.LOG.assertTrue((callPlace = OCFunctionParameterInfoHandler.callPlace(parameterOwner)) != null);
        OCExpression[] oCExpressionArray = callPlace.getArgumentExpressions().toArray(new OCExpression[0]);
        if (oCExpressionArray == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(18);
        }
        return oCExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        OCPunctuatorElementType oCPunctuatorElementType = OCTokenTypes.COMMA;
        if (oCPunctuatorElementType == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(19);
        }
        return oCPunctuatorElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        OCPunctuatorElementType oCPunctuatorElementType = OCTokenTypes.RBRACE;
        if (oCPunctuatorElementType == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(20);
        }
        return oCPunctuatorElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{OCCallExpression.class, OCDeclarator.class, OCArgumentList.class});
        if (hashSet == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set<Class<PsiFile>> set = Collections.singleton(PsiFile.class);
        if (set == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    public Class<PsiElement> getArgumentListClass() {
        return PsiElement.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argExpressions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasUnnamedParam";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "callPlace";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableBeforeIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableParametersBeforeGivenIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calcUI";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateFunctionUI";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FunctionInfoWrapper {
        @NotNull
        private final OCFunctionParameterInfo myInfo;
        @NotNull
        private UI ui;

        public FunctionInfoWrapper(@NotNull OCFunctionParameterInfo info) {
            if (info == null) {
                FunctionInfoWrapper.$$$reportNull$$$0(0);
            }
            this.ui = new UI("", -1, -1);
            this.myInfo = info;
        }

        @NotNull
        public OCFunctionParameterInfo getInfo() {
            OCFunctionParameterInfo oCFunctionParameterInfo = this.myInfo;
            if (oCFunctionParameterInfo == null) {
                FunctionInfoWrapper.$$$reportNull$$$0(1);
            }
            return oCFunctionParameterInfo;
        }

        @NotNull
        public UI getUi() {
            UI uI = this.ui;
            if (uI == null) {
                FunctionInfoWrapper.$$$reportNull$$$0(2);
            }
            return uI;
        }

        public void setUi(@NotNull UI ui) {
            if (ui == null) {
                FunctionInfoWrapper.$$$reportNull$$$0(3);
            }
            this.ui = ui;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler$FunctionInfoWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler$FunctionInfoWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setUi";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static final class UI {
            @NotNull
            public final String text;
            public final int highlightStartOffset;
            public final int highlightEndOffset;

            private UI(@NotNull String text, int highlightStartOffset, int highlightEndOffset) {
                if (text == null) {
                    UI.$$$reportNull$$$0(0);
                }
                this.text = text;
                this.highlightStartOffset = highlightStartOffset;
                this.highlightEndOffset = highlightEndOffset;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler$FunctionInfoWrapper$UI", "<init>"));
            }
        }
    }
}

