/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.DefaultTypingActionsExtension;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.NotNull;

public class OCTypingActionsExtension
extends DefaultTypingActionsExtension {
    public static final Key<Boolean> INSIDE_TYPING_ACTION_HINT = Key.create((String)"INSIDE_TYPING_ACTION_HINT");

    public void startCopy(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
    }

    public boolean isSuitableContext(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(3);
        }
        return Registry.is((String)"cidr.enable.typingActionsExtension") && PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()) instanceof OCPsiFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void format(@NotNull Project project, @NotNull Editor editor, int howtoReformat, int startOffset, int endOffset, int anchorColumn, boolean indentBeforeReformat) {
        boolean forceBulkUpdate;
        boolean skipCommitMode;
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(5);
        }
        Document document = editor.getDocument();
        boolean bl = skipCommitMode = INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)editor.getDocument()) == Boolean.TRUE;
        if (!skipCommitMode) {
            INSIDE_TYPING_ACTION_HINT.set((UserDataHolder)editor.getDocument(), (Object)Boolean.TRUE);
        }
        boolean bl2 = forceBulkUpdate = !document.isInBulkUpdate();
        if (forceBulkUpdate) {
            document.setInBulkUpdate(true);
        }
        try {
            super.format(project, editor, howtoReformat, startOffset, endOffset, anchorColumn, indentBeforeReformat);
        }
        finally {
            if (forceBulkUpdate) {
                document.setInBulkUpdate(false);
            }
            if (!skipCommitMode) {
                INSIDE_TYPING_ACTION_HINT.set((UserDataHolder)editor.getDocument(), null);
            }
        }
    }

    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(7);
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        OCLanguage language = OCLanguage.getInstance();
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)language);
        if (lineIndentProvider != null && file != null) {
            HighlighterIterator it = editor.getHighlighter().createIterator(startOffset);
            OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file);
            CharSequence fileText = document.getCharsSequence();
            int currentLine = -1;
            RangeMarker actionRange = document.createRangeMarker(startOffset, endOffset);
            while (!it.atEnd() && it.getStart() <= actionRange.getEndOffset()) {
                int startLine;
                if (it.getTokenType() != TokenType.WHITE_SPACE && (startLine = document.getLineNumber(it.getStart())) > currentLine) {
                    currentLine = startLine;
                    int startIndent = document.getLineStartOffset(startLine);
                    int endIndent = CharArrayUtil.shiftForward((CharSequence)fileText, (int)startIndent, (String)" \t");
                    String newIndentString = lineIndentProvider.getLineIndent(project, editor, (Language)language, startIndent);
                    if (newIndentString != null && newIndentString != LineIndentProvider.DO_NOT_ADJUST) {
                        int shiftMultilineToken = 0;
                        RangeMarker marker = document.createRangeMarker(it.getStart(), it.getEnd());
                        if (it.getTokenType() == OCTokenTypes.BLOCK_COMMENT && startLine != document.getLineNumber(it.getEnd())) {
                            shiftMultilineToken = multilineNodeFormatter.indent(newIndentString) - multilineNodeFormatter.indent(fileText.subSequence(startIndent, endIndent));
                        }
                        document.replaceString(startIndent, endIndent, (CharSequence)newIndentString);
                        if (shiftMultilineToken != 0) {
                            document.replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)multilineNodeFormatter.getShiftedLeafText(shiftMultilineToken, fileText.subSequence(marker.getStartOffset(), marker.getEndOffset())));
                        }
                        it = editor.getHighlighter().createIterator(marker.getEndOffset());
                        marker.dispose();
                        continue;
                    }
                }
                it.advance();
            }
            actionRange.dispose();
        }
    }

    protected void adjustLineIndent(@NotNull Project project, @NotNull Editor editor, int offset) {
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(9);
        }
        this.adjustLineIndent(project, editor, offset, offset);
    }

    protected void reformatRange(@NotNull Project project, @NotNull Editor editor, int startOffset, int endOffset) {
        FormattingService service;
        if (project == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            OCTypingActionsExtension.$$$reportNull$$$0(11);
        }
        Document document = editor.getDocument();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file != null && !((service = FormattingServiceUtil.findService((PsiFile)file, (boolean)false, (boolean)false)) instanceof CoreFormattingService)) {
            service.formatRanges(file, (FormattingRangesInfo)new FormatTextRanges(TextRange.create((int)startOffset, (int)endOffset), true), true, true);
            return;
        }
        this.adjustLineIndent(project, editor, startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCTypingActionsExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startCopy";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "format";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustLineIndent";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

