/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import org.jetbrains.annotations.NotNull;

public class MacroInsertHandler
implements InsertHandler<LookupElement> {
    private final OCMacroSymbol mySymbol;

    public MacroInsertHandler(OCMacroSymbol symbol) {
        this.mySymbol = symbol;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        if (context == null) {
            MacroInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            MacroInsertHandler.$$$reportNull$$$0(1);
        }
        if (this.mySymbol.hasParameterList()) {
            boolean hasParams = !this.mySymbol.getParameterNames().isEmpty();
            CallableInsertUtils.addParensIfRequired(context, item, hasParams);
            if (hasParams && CallableInsertUtils.shouldInsertPlaceholders(context)) {
                StringBuilder insertion = new StringBuilder();
                OCImmutableList<String> params = this.mySymbol.getParameterNames();
                boolean isVararg = this.mySymbol.isVararg();
                int paramCount = params.size();
                int varargIdx = isVararg ? paramCount - 1 : Integer.MAX_VALUE;
                for (int i2 = 0; i2 < paramCount; ++i2) {
                    String param = (String)params.get(i2);
                    if (i2 > 0) {
                        insertion.append(", ");
                    }
                    if (i2 == 0 || i2 < varargIdx) {
                        insertion.append("<#");
                    }
                    insertion.append("__VA_ARGS__...".equals(param) ? "..." : param);
                    if (i2 == varargIdx - 1) continue;
                    insertion.append("#>");
                }
                context.getDocument().insertString(context.getEditor().getCaretModel().getOffset(), (CharSequence)insertion);
                CallableInsertUtils.selectFirstPlaceholderIfPresent(context);
            }
            if (hasParams) {
                AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/MacroInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

