/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.surround.OCSurrounder;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;

public class OCCondCompilationSurrounder
extends OCSurrounder {
    public String getTemplateDescription() {
        return "#ifdef";
    }

    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        if (project == null) {
            OCCondCompilationSurrounder.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCCondCompilationSurrounder.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            OCCondCompilationSurrounder.$$$reportNull$$$0(2);
        }
        int startOffset = elements[0].getTextRange().getStartOffset();
        int endOffset = elements[elements.length - 1].getTextRange().getEndOffset();
        PsiFile file = elements[0].getContainingFile();
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        startOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t") + 1;
        boolean needNewLineAfterEndIf = endOffset < chars.length() && chars.charAt(endOffset) != '\n';
        String endTag = needNewLineAfterEndIf ? "\n#endif\n" : "\n#endif";
        document.insertString(endOffset, (CharSequence)endTag);
        RangeMarker endif = document.createRangeMarker(TextRange.create((int)endOffset, (int)(endOffset + endTag.length())));
        RangeMarker afterEndif = null;
        if (needNewLineAfterEndIf) {
            int afterEndTag = endOffset + endTag.length();
            afterEndif = document.createRangeMarker(TextRange.create((int)afterEndTag, (int)afterEndTag));
        }
        boolean needNewLineBeforeIfDef = startOffset > 0 && chars.charAt(startOffset - 1) != '\n';
        String startTag = needNewLineBeforeIfDef ? "\n#ifdef\n" : "#ifdef\n";
        document.insertString(startOffset, (CharSequence)startTag);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        int caretOffset = startOffset + startTag.length() - 1;
        RangeMarker caret = document.createRangeMarker(TextRange.create((int)caretOffset, (int)caretOffset));
        OCChangeUtil.reformatTextIfNotInjected(file, startOffset, startOffset + startTag.length());
        OCChangeUtil.reformatTextIfNotInjected(file, endif.getStartOffset(), endif.getEndOffset());
        endif.dispose();
        if (afterEndif != null) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, afterEndif.getStartOffset());
            endif.dispose();
        }
        caretOffset = caret.getStartOffset();
        caret.dispose();
        document.insertString(caretOffset, (CharSequence)" ");
        return TextRange.create((int)(++caretOffset), (int)caretOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/surround/OCCondCompilationSurrounder";
        objectArray[2] = "surroundElements";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

