/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCWrapStringIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCLiteralExpression literal;
        if (project == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(1);
        }
        return OCCodeInsightUtil.isValid(literal = OCWrapStringIntentionAction.getStringLiteral(editor, element.getContainingFile())) && OCElementUtil.getStringLiteral(literal) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message("intentions.wrap.with.stringFormat", new Object[0]);
        if (string == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private static OCLiteralExpression getStringLiteral(Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return OCElementUtil.getAdjacentParentOfType(element, OCLiteralExpression.class);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiFile file;
        OCLiteralExpression literal;
        if (project == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            OCWrapStringIntentionAction.$$$reportNull$$$0(5);
        }
        if ((literal = OCWrapStringIntentionAction.getStringLiteral(editor, file = element.getContainingFile())) == null) {
            return;
        }
        OCSendMessageExpression call = (OCSendMessageExpression)OCElementFactory.expressionFromText("[NSString stringWithFormat: 0]", (PsiElement)file);
        call.getArguments().get(0).getArgumentExpression().replace(literal);
        call = (OCSendMessageExpression)literal.replace(call);
        if (editor != null) {
            editor.getCaretModel().moveToOffset(call.getTextRange().getEndOffset());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCWrapStringIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

