/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCNotInitializedVarChecker
extends OCSingleSymbolAlgorithm {
    private boolean myWasInitialized;

    protected OCNotInitializedVarChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        if (cfg == null) {
            OCNotInitializedVarChecker.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            OCNotInitializedVarChecker.$$$reportNull$$$0(1);
        }
        super(cfg, true, symbol);
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        OCControlFlowGraph parentCfg = this.myCfg.getClosureVariableDeclaratorGraph(this.mySymbol);
        if (parentCfg != null) {
            if (this.myCfg.hasInstructionsInParentGraph(this.mySymbol, OCInstruction.InstructionKind.WRITE, OCInstruction.InstructionKind.WRITE_IN_BLOCK, OCInstruction.InstructionKind.REFERENCE)) {
                this.myWasInitialized = true;
                return;
            }
            if (parentCfg.getInstructions(this.mySymbol) != null) {
                this.traverseFromStart(this.mySymbol);
            }
        } else {
            this.traverse(this.myCfg.getDeclaratorInstruction(this.mySymbol), this.mySymbol, true);
        }
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotInitializedVarChecker.$$$reportNull$$$0(2);
        }
        switch (instruction.getKind()) {
            case KILL: 
            case WRITE: 
            case WRITE_IN_BLOCK: 
            case REFERENCE: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotInitializedVarChecker.$$$reportNull$$$0(3);
        }
        return instruction.getKind() == OCInstruction.InstructionKind.DECLARATOR;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotInitializedVarChecker.$$$reportNull$$$0(4);
        }
        return instruction.getKind() == OCInstruction.InstructionKind.READ && !instruction.isTransparentRead();
    }

    @Override
    @Nullable
    protected List<OCNode> getJumpTargets(@NotNull OCNode node, boolean isForward) {
        if (node == null) {
            OCNotInitializedVarChecker.$$$reportNull$$$0(5);
        }
        List<OCNode> jumpTargets = super.getJumpTargets(node, isForward);
        List<OCNode> fakeJumpTargets = node.getFakeJumpTargets();
        if (jumpTargets != null && fakeJumpTargets != null) {
            ArrayList<OCNode> result = new ArrayList<OCNode>(jumpTargets);
            result.removeAll(fakeJumpTargets);
            return result;
        }
        return jumpTargets;
    }

    @NotNull
    public List<PsiElement> getNotInitializedReads() {
        if (this.myWasInitialized) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                OCNotInitializedVarChecker.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<PsiElement> list = this.getReachableElements();
        if (list == null) {
            OCNotInitializedVarChecker.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/legacy/dfa/OCNotInitializedVarChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/legacy/dfa/OCNotInitializedVarChecker";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotInitializedReads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStartInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEndInstruction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJumpTargets";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

