/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.lexer;

public class OCLexerUtils {
    public static int indexOf(CharSequence source, CharSequence model) {
        return OCLexerUtils.indexOf(source, model, 0);
    }

    public static int indexOf(CharSequence source, CharSequence model, int fromSourceIndex) {
        return OCLexerUtils.indexOf(source, 0, source.length(), model, 0, model.length(), fromSourceIndex);
    }

    static int indexOf(CharSequence source, int sourceOffset, int sourceLength, CharSequence model, int modelOffset, int modelLength, int fromSourceIndex) {
        if (fromSourceIndex >= sourceLength) {
            return modelLength == 0 ? sourceLength : -1;
        }
        if (fromSourceIndex < 0) {
            fromSourceIndex = 0;
        }
        if (modelLength == 0) {
            return fromSourceIndex;
        }
        char first = model.charAt(modelOffset);
        int maxSourceOffset = sourceOffset + (sourceLength - modelLength);
        for (int i2 = sourceOffset + fromSourceIndex; i2 <= maxSourceOffset; ++i2) {
            if (source.charAt(i2) != first) {
                while (++i2 <= maxSourceOffset && source.charAt(i2) != first) {
                }
            }
            if (i2 > maxSourceOffset) continue;
            int j = i2 + 1;
            int end = j + modelLength - 1;
            int k = modelOffset + 1;
            while (j < end && source.charAt(j) == model.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i2 - sourceOffset;
        }
        return -1;
    }
}

