/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapDefaultPathResolver;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPathResolver;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.ModuleMapAwareHeadersSearchRoot;
import java.io.File;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleMapRoot
extends HeadersRoot
implements ModuleMapAwareHeadersSearchRoot {
    @NotNull
    protected final File moduleMapFile;

    public ModuleMapRoot(@NotNull Project project, @NotNull File moduleMapFile) {
        if (project == null) {
            ModuleMapRoot.$$$reportNull$$$0(0);
        }
        if (moduleMapFile == null) {
            ModuleMapRoot.$$$reportNull$$$0(1);
        }
        super(project);
        this.moduleMapFile = moduleMapFile;
    }

    @Nls
    public String getPresentableName() {
        return this.moduleMapFile.getName();
    }

    public VirtualFile getVirtualFile() {
        return this.findModuleMapVirtualFile();
    }

    public boolean isValid() {
        return true;
    }

    public boolean processChildren(@NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor == null) {
            ModuleMapRoot.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    @Nullable
    public VirtualFile findModuleMapVirtualFile() {
        VirtualFile file = VfsUtil.findFileByIoFile((File)this.moduleMapFile, (boolean)true);
        if (!ModuleMapUtil.checkModuleMapFile(file)) {
            return null;
        }
        return file;
    }

    @Override
    @NotNull
    public ModuleMapPathResolver createModuleMapPathResolver() {
        VirtualFile root = VfsUtil.findFileByIoFile((File)this.moduleMapFile.getParentFile(), (boolean)true);
        if (root == null) {
            root = new LightVirtualFile();
        }
        return new ModuleMapDefaultPathResolver(root, VfsUtilCore.getRootFile((VirtualFile)root));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return FileUtil.filesEqual((File)this.moduleMapFile, (File)((ModuleMapRoot)o).moduleMapFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.moduleMapFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleMapFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/modulemap/resolve/ModuleMapRoot";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

