/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class OCImportGraph {
    private static final boolean USE_STRICT = Registry.is((String)"cidr.indexer.strictImportGraph", (boolean)false);
    private static final NotNullLazyKey<Map<VirtualFile, Set<VirtualFile>>, OCResolveConfiguration> ROOT_TO_ALL_HEADERS_CACHE = NotNullLazyKey.create((String)"ROOT_TO_ALL_HEADERS_CACHE", dom -> new ConcurrentHashMap());
    private final Project myProject;
    private final SimpleModificationTracker myModificationTracker;
    private final CachedValue<MultiMap<VirtualFile, VirtualFile>> myHeaderToAllRootsCache;
    private final AtomicInteger isEnsuringFilesProcessed;
    private final Object myLock;
    private final MultiMap<VirtualFile, VirtualFile> myHeaderToIncluders;
    private final MultiMap<VirtualFile, VirtualFile> myAddOnlyHeaderToIncluders;

    @NotNull
    public static OCImportGraph getInstance(@NotNull Project project) {
        if (project == null) {
            OCImportGraph.$$$reportNull$$$0(0);
        }
        OCImportGraph oCImportGraph = (OCImportGraph)project.getService(OCImportGraph.class);
        if (oCImportGraph == null) {
            OCImportGraph.$$$reportNull$$$0(1);
        }
        return oCImportGraph;
    }

    public OCImportGraph(@NotNull Project project) {
        if (project == null) {
            OCImportGraph.$$$reportNull$$$0(2);
        }
        this.myModificationTracker = new SimpleModificationTracker();
        this.isEnsuringFilesProcessed = new AtomicInteger();
        this.myLock = new Object();
        this.myHeaderToIncluders = MultiMap.createSet();
        this.myAddOnlyHeaderToIncluders = MultiMap.createSet();
        this.myProject = project;
        this.myHeaderToAllRootsCache = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance((Project)this.myProject).getModificationTrackers();
            return new CachedValueProvider.Result((Object)MultiMap.createConcurrent(), new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }, false);
        project.getMessageBus().connect().subscribe(FileSymbolTableCacheListener.TOPIC, (Object)new FileSymbolTableCacheListener.Adaptor(){

            @Override
            public void onSymbolsUpToDate() {
                OCImportGraph.this.onUpToDate();
            }
        });
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            OCImportGraph.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    public void invalidateHeaderRootsCache() {
        ((MultiMap)this.myHeaderToAllRootsCache.getValue()).clear();
    }

    @NotNull
    public Collection<VirtualFile> getAllHeaderRoots(@NotNull VirtualFile header) {
        MultiMap value;
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(4);
        }
        if (!(value = (MultiMap)this.myHeaderToAllRootsCache.getValue()).containsKey((Object)header)) {
            Collection<VirtualFile> roots2 = this.findAllRootsThatInclude(header, true);
            assert (!roots2.isEmpty());
            value.put((Object)header, roots2);
        }
        Collection collection = value.get((Object)header);
        if (collection == null) {
            OCImportGraph.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public boolean isFileIncluded(@NotNull VirtualFile file) {
        if (file == null) {
            OCImportGraph.$$$reportNull$$$0(6);
        }
        return this.myHeaderToIncluders.containsKey((Object)file);
    }

    public void buildSymbolAndRootHeaderCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile rootFile, boolean isSurrogate, @Nullable ProgressIndicator indicator) {
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(7);
        }
        if (rootFile == null) {
            OCImportGraph.$$$reportNull$$$0(8);
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (!rootFile.isValid()) {
            return;
        }
        if (!OCInclusionContextUtil.isNeedToFindRoot(rootFile, this.myProject)) {
            OCImportGraph.invalidateRootHeadersCache(configuration, rootFile);
            this.getAllRootHeaders(configuration, rootFile, indicator, isSurrogate);
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(rootFile);
            if (psiFile instanceof OCConfigurationOwner) {
                OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, this.myProject, false);
                OCImportGraph.traverseWithIncludes(configuration, kind, rootFile, (OCConfigurationOwner)psiFile, isSurrogate, true);
            }
        }
    }

    @NotNull
    private static OCInclusionContext traverseWithIncludes(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind attemptedKind, @NotNull VirtualFile rootFile, @NotNull OCConfigurationOwner rootCO, boolean isSurrogate, boolean allowLanguageKindFallback) {
        OCInclusionContext context;
        block9: {
            OCInclusionContext oCInclusionContext;
            if (configuration == null) {
                OCImportGraph.$$$reportNull$$$0(9);
            }
            if (attemptedKind == null) {
                OCImportGraph.$$$reportNull$$$0(10);
            }
            if (rootFile == null) {
                OCImportGraph.$$$reportNull$$$0(11);
            }
            if (rootCO == null) {
                OCImportGraph.$$$reportNull$$$0(12);
            }
            try {
                VirtualFile file = OCInclusionContextUtil.getVirtualFile(rootCO);
                if (!file.isValid()) break block9;
                context = OCInclusionContext.sourceParsingContext(configuration, attemptedKind, rootCO, isSurrogate);
                context.setInheritProcessedFiles(true);
                context.setAbortOnLanguageKindMismatch(true);
                FileSymbolTable.forFile(rootCO, context);
                context.setAbortOnLanguageKindMismatch(false);
                if (!context.isProcessed(file)) break block9;
                oCInclusionContext = context;
            }
            catch (OCInclusionContext.LanguageKindMismatchException e) {
                OCLanguageKind requiredLanguageKind = OCInclusionContext.handleLanguageKindMismatch(rootFile, e, allowLanguageKindFallback);
                return OCImportGraph.traverseWithIncludes(configuration, requiredLanguageKind, rootFile, rootCO, isSurrogate, false);
            }
            if (oCInclusionContext == null) {
                OCImportGraph.$$$reportNull$$$0(13);
            }
            return oCInclusionContext;
        }
        context = OCInclusionContext.sourceParsingContext(configuration, attemptedKind, rootCO, isSurrogate);
        context.setAbortOnLanguageKindMismatch(true);
        context.preprocessInclude(rootCO, true);
        context.setAbortOnLanguageKindMismatch(false);
        OCInclusionContext oCInclusionContext = context;
        if (oCInclusionContext == null) {
            OCImportGraph.$$$reportNull$$$0(14);
        }
        return oCInclusionContext;
    }

    @NotNull
    private static Map<VirtualFile, Set<VirtualFile>> getRootToAllHeadersCache(@NotNull OCResolveConfiguration configuration) {
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(15);
        }
        Map map = (Map)ROOT_TO_ALL_HEADERS_CACHE.getValue((UserDataHolder)configuration);
        if (map == null) {
            OCImportGraph.$$$reportNull$$$0(16);
        }
        return map;
    }

    public static void invalidateRootHeadersCache(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile file) {
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(17);
        }
        if (file == null) {
            OCImportGraph.$$$reportNull$$$0(18);
        }
        OCImportGraph.getRootToAllHeadersCache(configuration).remove(file);
    }

    public static void invalidateRootHeadersCache(@NotNull OCResolveConfiguration configuration) {
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(19);
        }
        OCImportGraph.getRootToAllHeadersCache(configuration).clear();
    }

    @NotNull
    public Set<VirtualFile> getAllRootHeaders(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @Nullable ProgressIndicator indicator, boolean isSurrogate) {
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(20);
        }
        if (root == null) {
            OCImportGraph.$$$reportNull$$$0(21);
        }
        assert (!OCInclusionContextUtil.isNeedToFindRoot(root, this.myProject)) : "Not a root file";
        Map<VirtualFile, Set<VirtualFile>> value = OCImportGraph.getRootToAllHeadersCache(configuration);
        Set<Object> result = value.get(root);
        if (result == null) {
            PsiFile rootPsi;
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            PsiFile psiFile = rootPsi = root.isValid() ? psiManager.findFile(root) : null;
            if (rootPsi instanceof OCConfigurationOwner) {
                if (OCInclusionContext.isPrecompiledHeader(root, configuration)) {
                    result = OCImportGraph.getAllPCHRootHeaders(psiManager, configuration, root, indicator);
                } else {
                    OCConfigurationOwner rootCO = (OCConfigurationOwner)rootPsi;
                    OCLanguageKind kind = rootCO.getRootKind(configuration);
                    OCInclusionContext context = OCImportGraph.traverseWithIncludes(configuration, kind, root, rootCO, isSurrogate, true);
                    result = context.getProcessedFiles();
                }
            } else {
                result = Collections.emptySet();
            }
            value.put(root, result);
        }
        Set<VirtualFile> set = result;
        if (set == null) {
            OCImportGraph.$$$reportNull$$$0(22);
        }
        return set;
    }

    private static Set<VirtualFile> getAllPCHRootHeaders(@NotNull PsiManager psiManager, @NotNull OCResolveConfiguration configuration, @NotNull VirtualFile pch, @Nullable ProgressIndicator indicator) {
        if (psiManager == null) {
            OCImportGraph.$$$reportNull$$$0(23);
        }
        if (configuration == null) {
            OCImportGraph.$$$reportNull$$$0(24);
        }
        if (pch == null) {
            OCImportGraph.$$$reportNull$$$0(25);
        }
        HashSet<Pair> sources = new HashSet<Pair>();
        for (VirtualFile vRoot : configuration.getSources()) {
            OCLanguageKind kind;
            PsiFile rootPsi;
            if (!OCFileTypeHelpers.isSourceFile((String)vRoot.getName()) || pch.equals(vRoot)) continue;
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (!((rootPsi = vRoot.isValid() ? psiManager.findFile(vRoot) : null) instanceof OCConfigurationOwner) || !(kind = ((OCConfigurationOwner)rootPsi).getRootKind(configuration)).supportsPrecompiledHeaders()) continue;
            sources.add(Pair.create((Object)kind, (Object)rootPsi));
        }
        THashSet result = new THashSet();
        for (Pair src : sources) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            result.addAll(OCInclusionContext.initialPCHContextWithoutRoot(configuration, (OCLanguageKind)src.first, (PsiFile)src.second).getProcessedFiles());
        }
        result.remove((Object)pch);
        return Collections.unmodifiableSet(result);
    }

    @NotNull
    public Set<OCResolveConfiguration> getAllHeaderConfigurations(@NotNull PsiFile header, @Nullable ProgressIndicator progress) {
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(26);
        }
        if (!OCLanguageUtils.supportsResolve(header)) {
            Set<OCResolveConfiguration> set = Collections.emptySet();
            if (set == null) {
                OCImportGraph.$$$reportNull$$$0(27);
            }
            return set;
        }
        VirtualFile file = OCInclusionContextUtil.getVirtualFile(header);
        if (!OCInclusionContextUtil.isLongLived(file)) {
            Set<OCResolveConfiguration> set = Collections.emptySet();
            if (set == null) {
                OCImportGraph.$$$reportNull$$$0(28);
            }
            return set;
        }
        HashSet<OCResolveConfiguration> ret = new HashSet<OCResolveConfiguration>();
        for (VirtualFile root : this.getAllHeaderRoots(file)) {
            this.fillHeaderConfigurationsForRoot(file, root, ret, progress);
        }
        Set<OCResolveConfiguration> set = Collections.unmodifiableSet(ret);
        if (set == null) {
            OCImportGraph.$$$reportNull$$$0(29);
        }
        return set;
    }

    public void fillHeaderConfigurationsForRoot(@NotNull VirtualFile header, @NotNull VirtualFile root, @NotNull Set<OCResolveConfiguration> result, @Nullable ProgressIndicator progress) {
        Collection configs;
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(30);
        }
        if (root == null) {
            OCImportGraph.$$$reportNull$$$0(31);
        }
        if (result == null) {
            OCImportGraph.$$$reportNull$$$0(32);
        }
        if (progress != null) {
            progress.checkCanceled();
        }
        Collection collection = configs = OCInclusionContextUtil.isLongLived(root) ? OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)root, (Project)this.myProject) : OCWorkspace.getInstance((Project)this.myProject).getConfigurations();
        if (!OCInclusionContextUtil.isNeedToFindRoot(root, this.myProject)) {
            for (OCResolveConfiguration config : configs) {
                if (progress != null) {
                    progress.checkCanceled();
                }
                if (!this.getAllRootHeaders(config, root, progress, false).contains(header)) continue;
                result.add(config);
            }
        } else {
            result.addAll(configs);
        }
    }

    public boolean processIncludingFiles(@NotNull VirtualFile headerFile, boolean strict, boolean rootsOnly, @NotNull Processor<? super VirtualFile> processor) {
        if (headerFile == null) {
            OCImportGraph.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            OCImportGraph.$$$reportNull$$$0(34);
        }
        ArrayList<VirtualFile> importers = new ArrayList<VirtualFile>();
        HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
        importers.add(headerFile);
        while (!importers.isEmpty()) {
            ProgressManager.checkCanceled();
            ArrayList<VirtualFile> upperImporters = new ArrayList<VirtualFile>();
            for (VirtualFile headerHolder : importers) {
                ProgressManager.checkCanceled();
                if (headerHolder == null || !processed.add(headerHolder)) continue;
                Collection<VirtualFile> maybeUpperImporter = this.findImmediateIncludingFiles(headerHolder, strict);
                for (VirtualFile importHolder : maybeUpperImporter) {
                    ProgressManager.checkCanceled();
                    if (!importHolder.isValid()) continue;
                    PsiFile psiImportHolder = PsiManager.getInstance((Project)this.myProject).findFile(importHolder);
                    if (!(!OCLanguageUtils.supportsResolve(psiImportHolder) || rootsOnly && OCInclusionContextUtil.isNeedToFindRoot(psiImportHolder) || processor.process((Object)importHolder))) {
                        return false;
                    }
                    upperImporters.add(importHolder);
                }
            }
            importers = upperImporters;
        }
        return true;
    }

    @NotNull
    public Collection<VirtualFile> findAllRootsThatInclude(@NotNull VirtualFile original, boolean strict) {
        if (original == null) {
            OCImportGraph.$$$reportNull$$$0(35);
        }
        if (!OCInclusionContextUtil.isNeedToFindRoot(original, this.myProject) || !original.isValid()) {
            List<VirtualFile> list = Collections.singletonList(original);
            if (list == null) {
                OCImportGraph.$$$reportNull$$$0(36);
            }
            return list;
        }
        PsiFile originalFile = PsiManager.getInstance((Project)this.myProject).findFile(original);
        if (!OCLanguageUtils.supportsResolve(originalFile)) {
            List<VirtualFile> list = Collections.singletonList(original);
            if (list == null) {
                OCImportGraph.$$$reportNull$$$0(37);
            }
            return list;
        }
        THashSet result = new THashSet();
        this.processIncludingFiles(original, strict, true, (Processor<? super VirtualFile>)((Processor)virtualFile -> {
            result.add(virtualFile);
            return true;
        }));
        return result.isEmpty() ? Collections.singletonList(original) : new ArrayList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpToDate() {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myAddOnlyHeaderToIncluders.isEmpty()) {
                this.myAddOnlyHeaderToIncluders.clear();
                this.myModificationTracker.incModificationCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VirtualFile> findImmediateIncludingFiles(@NotNull VirtualFile header, boolean strict) {
        boolean useStrict;
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(38);
        }
        Application app = ApplicationManager.getApplication();
        boolean bl = useStrict = USE_STRICT || app.isUnitTestMode();
        if (strict) {
            app.assertReadAccessAllowed();
            boolean sync = app.isUnitTestMode() || useStrict && !app.isDispatchThread();
            this.ensureFilesProcessed(sync);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        Collection<VirtualFile> ns = null;
        if (!strict || !useStrict) {
            ns = this.getInner(header, true);
        }
        Collection<VirtualFile> sr = this.getInner(header, false);
        if (ns == null || ns.isEmpty()) {
            Collection<VirtualFile> collection = sr;
            // MONITOREXIT : object
            if (collection != null) return collection;
            OCImportGraph.$$$reportNull$$$0(39);
            return collection;
        }
        if (sr.isEmpty()) {
            Collection<VirtualFile> collection = ns;
            // MONITOREXIT : object
            if (collection != null) return collection;
            OCImportGraph.$$$reportNull$$$0(40);
            return collection;
        }
        THashSet fs = new THashSet(ns);
        fs.addAll(sr);
        THashSet tHashSet = fs;
        // MONITOREXIT : object
        if (tHashSet != null) return tHashSet;
        OCImportGraph.$$$reportNull$$$0(41);
        return tHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Contract(value="_, false -> !null")
    private Collection<VirtualFile> getInner(@NotNull VirtualFile header, boolean fromAddOnlyCache) {
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(42);
        }
        Object object = this.myLock;
        synchronized (object) {
            MultiMap<VirtualFile, VirtualFile> h2is;
            MultiMap<VirtualFile, VirtualFile> multiMap = h2is = fromAddOnlyCache ? this.myAddOnlyHeaderToIncluders : this.myHeaderToIncluders;
            if (fromAddOnlyCache && !h2is.containsKey((Object)header)) {
                return null;
            }
            Collection files = h2is.get((Object)header);
            boolean allValid = true;
            for (VirtualFile file : files) {
                if (file.isValid()) continue;
                allValid = false;
                break;
            }
            if (!allValid) {
                for (VirtualFile file : files.toArray(VirtualFile.EMPTY_ARRAY)) {
                    if (file.isValid()) continue;
                    h2is.remove((Object)header, (Object)file);
                }
                files = h2is.get((Object)header);
                if (!fromAddOnlyCache) {
                    this.invalidateHeaderRootsCache();
                }
            }
            return ContainerUtil.immutableList((Object[])files.toArray(VirtualFile.EMPTY_ARRAY));
        }
    }

    private void ensureFilesProcessed(boolean sync) {
        if (FileSymbolTablesCache.getInstance(this.myProject).isUpToDate(true)) {
            this.onUpToDate();
            return;
        }
        if (sync) {
            this.isEnsuringFilesProcessed.incrementAndGet();
            try {
                this.ensurePendingFilesProcessed();
                return;
            }
            finally {
                this.isEnsuringFilesProcessed.decrementAndGet();
            }
        }
        if (this.isEnsuringFilesProcessed.get() > 0) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (this.isEnsuringFilesProcessed.incrementAndGet() > 1) {
                this.isEnsuringFilesProcessed.decrementAndGet();
                return;
            }
            try {
                this.ensurePendingFilesProcessed();
            }
            finally {
                this.isEnsuringFilesProcessed.decrementAndGet();
            }
        }).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void ensurePendingFilesProcessed() {
        if (this.myProject.isDisposed() || !FileSymbolTablesCache.areSymbolsLoaded(this.myProject)) {
            return;
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
        cache.ensurePendingFilesProcessed(true);
        this.onUpToDate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeaderIncluder(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(43);
        }
        if (includer == null) {
            OCImportGraph.$$$reportNull$$$0(44);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myHeaderToIncluders.putValue((Object)header, (Object)includer);
            if (this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
            }
            this.invalidateHeaderRootsCache();
            this.myModificationTracker.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHeaderIncluder(@NotNull VirtualFile header, @NotNull VirtualFile includer) {
        if (header == null) {
            OCImportGraph.$$$reportNull$$$0(45);
        }
        if (includer == null) {
            OCImportGraph.$$$reportNull$$$0(46);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myHeaderToIncluders.remove((Object)header, (Object)includer)) {
                if (!this.myAddOnlyHeaderToIncluders.containsKey((Object)header)) {
                    this.myAddOnlyHeaderToIncluders.putValues((Object)header, this.myHeaderToIncluders.get((Object)header));
                    this.myAddOnlyHeaderToIncluders.putValue((Object)header, (Object)includer);
                }
                this.invalidateHeaderRootsCache();
                this.myModificationTracker.incModificationCount();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCImportGraph";
                break;
            }
            case 4: 
            case 26: 
            case 30: 
            case 38: 
            case 42: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attemptedKind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootCO";
                break;
            }
            case 21: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pch";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCImportGraph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaderRoots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "traverseWithIncludes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootToAllHeadersCache";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootHeaders";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHeaderConfigurations";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllRootsThatInclude";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findImmediateIncludingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllHeaderRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileIncluded";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolAndRootHeaderCache";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "traverseWithIncludes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRootToAllHeadersCache";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invalidateRootHeadersCache";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllRootHeaders";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllPCHRootHeaders";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAllHeaderConfigurations";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fillHeaderConfigurationsForRoot";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processIncludingFiles";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findAllRootsThatInclude";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findImmediateIncludingFiles";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getInner";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addHeaderIncluder";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeHeaderIncluder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 13: 
            case 14: 
            case 16: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

