/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingDataKeys;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextListener;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCLibraryFileResolveConfigurationProvider;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInclusionContextUtil {
    private static final NotNullLazyKey<CachedValue<OCResolveConfiguration>, PsiFile> FILE_ACTIVE_CONFIGURATION_CACHE = NotNullLazyKey.create((String)"FILE_ACTIVE_CONFIGURATION_CACHE", file -> {
        final Project project = file.getProject();
        return CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<OCResolveConfiguration>(){

            public CachedValueProvider.Result<OCResolveConfiguration> compute() {
                if (project.isDefault()) {
                    return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
                }
                OCWorkspaceModificationTrackers tracker = OCWorkspace.getInstance((Project)project).getModificationTrackers();
                return new CachedValueProvider.Result((Object)this.inferConfiguration(), new Object[]{FileSymbolTablesCache.getInstance(project).getOutOfBlockModificationTracker(), tracker.getResolveConfigurationsTracker(), tracker.getSourceFilesTracker(), tracker.getCompilerSettingsTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }

            @Nullable
            private OCResolveConfiguration inferConfiguration() {
                VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
                if (SymbolTableProvider.isSourceFile(file.getProject(), virtualFile)) {
                    return OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, file.getProject()).getConfiguration();
                }
                return null;
            }
        }, false);
    });
    private static final NotNullLazyKey<Map<VirtualFile, OCResolveRootAndConfiguration>, Project> HEADER_ROOT_AND_CONFIGURATION_KEY = NotNullLazyKey.create((String)"HEADER_ROOT_AND_CONFIGURATION_KEY", p -> new ConcurrentHashMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCImmutableInclusionContext>, Project> HEADER_CONTEXT_KEY = NotNullLazyKey.create((String)"HEADER_CONTEXT_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());
    private static final NotNullLazyKey<Map<VirtualFile, OCContextChangeSet>, Project> CONTEXT_CHANGES_KEY = NotNullLazyKey.create((String)"CONTEXT_CHANGES_KEY", p -> ContainerUtil.createConcurrentSoftValueMap());

    @Deprecated
    @Nullable
    public static OCResolveConfiguration computePreselectedConfiguration(@NotNull Project project, @NotNull Collection<OCResolveConfiguration> configs) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(0);
        }
        if (configs == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(1);
        }
        return (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, configs).first;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static VirtualFile getVirtualFile(@Nullable PsiFile file) {
        PsiFile prevOriginalFile;
        if (file == null) {
            return null;
        }
        PsiFile originalFile = file;
        do {
            prevOriginalFile = originalFile;
        } while ((originalFile = originalFile.getOriginalFile()) != prevOriginalFile);
        VirtualFile vFile = originalFile.getVirtualFile();
        if (vFile != null) {
            return vFile;
        }
        vFile = (VirtualFile)file.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        if (vFile != null) {
            return vFile;
        }
        return originalFile.getViewProvider().getVirtualFile();
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isLongLived(@Nullable VirtualFile fileFromGetVirtualFileCall) {
        return fileFromGetVirtualFileCall != null && !(fileFromGetVirtualFileCall instanceof LightVirtualFile);
    }

    @Nullable
    public static PsiFile findCachedPsiFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(3);
        }
        if (!file.isValid()) {
            return null;
        }
        return PsiManagerEx.getInstanceEx((Project)project).getFileManager().getCachedPsiFile(file);
    }

    public static boolean isRoot(@NotNull PsiFile file) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(4);
        }
        if (OCFileTypeHelpers.isSourceFile((String)file.getName())) {
            return !OCWorkspace.getInstance((Project)file.getProject()).getConfigurationsForFile(OCInclusionContextUtil.getVirtualFile(file)).isEmpty();
        }
        return false;
    }

    public static boolean isNeedToFindRoot(@NotNull PsiFile file) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(5);
        }
        return OCInclusionContextUtil.isNeedToFindRoot(OCInclusionContextUtil.getVirtualFile(file), file.getProject());
    }

    public static boolean isNeedToFindRoot(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(7);
        }
        if (!OCInclusionContextUtil.isLongLived(file)) {
            return false;
        }
        if (OCFileTypeHelpers.isSourceFile((String)file.getName())) {
            return OCWorkspace.getInstance((Project)project).getConfigurationsForFile(file).isEmpty();
        }
        return !OCPCHCache.isPrecompiledHeader((VirtualFile)file, (Project)project);
    }

    @NotNull
    public static OCResolveRootAndConfiguration getResolveRootAndActiveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Map cache;
        OCResolveRootAndConfiguration cached;
        if (virtualFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(9);
        }
        if ((cached = (OCResolveRootAndConfiguration)(cache = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project)).get(virtualFile)) != null) {
            OCResolveRootAndConfiguration oCResolveRootAndConfiguration = cached;
            if (oCResolveRootAndConfiguration == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(10);
            }
            return oCResolveRootAndConfiguration;
        }
        OCResolveRootAndConfiguration result = null;
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project)) {
            result = OCInclusionContextUtil.getResolveRootAndActiveConfigurationForHeader(virtualFile, project);
        }
        if (result == null) {
            result = OCInclusionContextUtil.createResolveRootAndConfiguration(project, OCResolveConfigurations.doGetPreselectedConfiguration((VirtualFile)virtualFile, (Project)project), virtualFile);
        }
        cache.put(virtualFile, result);
        ((OCInclusionContextListener)project.getMessageBus().syncPublisher(OCInclusionContextListener.TOPIC)).resolveRootAndActiveConfigurationChanged(virtualFile, result);
        OCResolveRootAndConfiguration oCResolveRootAndConfiguration = result;
        if (oCResolveRootAndConfiguration == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(11);
        }
        return oCResolveRootAndConfiguration;
    }

    @Nullable
    private static OCResolveRootAndConfiguration getResolveRootAndActiveConfigurationForHeader(@NotNull VirtualFile virtualHeaderFile, @NotNull Project project) {
        if (virtualHeaderFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(13);
        }
        String headerNameWithoutExtension = virtualHeaderFile.getNameWithoutExtension();
        OCImportGraph importGraph = OCImportGraph.getInstance(project);
        ArrayList<VirtualFile> roots2 = new ArrayList<VirtualFile>(importGraph.getAllHeaderRoots(virtualHeaderFile));
        roots2.sort(new VirtualFileComparator(project, headerNameWithoutExtension));
        ArrayList<Pair> rootsThatMayMatchSelectedConfiguration = new ArrayList<Pair>();
        for (VirtualFile root : roots2) {
            Ref scoreRef;
            Collection configs = OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)root, (Project)project);
            if (OCResolveConfigurations.findPreselectedConfiguration((Project)project, (Collection)configs, (Ref)(scoreRef = new Ref((Object)0))) == null) continue;
            rootsThatMayMatchSelectedConfiguration.add(Pair.create((Object)root, (Object)((Integer)scoreRef.get())));
        }
        rootsThatMayMatchSelectedConfiguration.sort((o1, o2) -> Comparing.compare((Comparable)((Integer)o1.second), (Comparable)((Integer)o2.second)));
        OCResolveRootAndConfiguration fallBack = null;
        HashSet<VirtualFile> visitedRoots = new HashSet<VirtualFile>(rootsThatMayMatchSelectedConfiguration.size());
        for (Pair info : rootsThatMayMatchSelectedConfiguration) {
            VirtualFile rootFile = (VirtualFile)info.first;
            visitedRoots.add(rootFile);
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            if (configurations.isEmpty()) continue;
            OCResolveConfiguration configuration = OCResolveConfigurations.findPreselectedConfiguration((Project)project, configurations, null);
            if (configuration != null) {
                return OCInclusionContextUtil.createResolveRootAndConfiguration(project, configuration, rootFile);
            }
            if (fallBack != null) continue;
            Pair c = OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, configurations);
            if (c.first == null) continue;
            fallBack = OCInclusionContextUtil.createResolveRootAndConfiguration(project, (OCResolveConfiguration)c.first, rootFile);
        }
        for (VirtualFile rootFile : roots2) {
            if (visitedRoots.contains(rootFile)) {
                if (fallBack == null || !rootFile.equals(fallBack.getRootFile())) continue;
                return fallBack;
            }
            HashSet<OCResolveConfiguration> configurations = new HashSet<OCResolveConfiguration>();
            importGraph.fillHeaderConfigurationsForRoot(virtualHeaderFile, rootFile, configurations, null);
            Pair c = OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, configurations);
            if (c.first == null) continue;
            return OCInclusionContextUtil.createResolveRootAndConfiguration(project, (OCResolveConfiguration)c.first, rootFile);
        }
        return null;
    }

    @NotNull
    private static OCResolveRootAndConfiguration createResolveRootAndConfiguration(@NotNull Project project, @Nullable OCResolveConfiguration configuration, @NotNull VirtualFile rootFile) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(14);
        }
        if (rootFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(15);
        }
        OCLanguageKind kind = OCLanguageKindCalculator.calculateLanguageKind(configuration, rootFile, project, false);
        return new OCResolveRootAndConfiguration(configuration, kind, rootFile);
    }

    public static void invalidateHeaderRootAndActiveConfigurationForAllExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(16);
        }
        OCInclusionContextUtil.removeExcept((Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project), virtualFile);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, project);
    }

    public static void invalidateHeaderContextsExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(17);
        }
        OCInclusionContextUtil.removeExcept((Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project), virtualFile);
        OCInclusionContextUtil.invalidateContextChangeCacheExcept(virtualFile, project);
    }

    public static void invalidateContextChangeCacheExcept(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(18);
        }
        OCInclusionContextUtil.removeExcept((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project), virtualFile);
    }

    public static <K, V> void removeExcept(@NotNull Map<K, V> map, @Nullable K key) {
        if (map == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(19);
        }
        if (key == null) {
            map.clear();
        } else {
            map.keySet().retainAll(Collections.singleton(key));
        }
    }

    public static void invalidateHeaderRootAndActiveConfigurationFor(@Nullable VirtualFile virtualFileInEditor, @NotNull Project project) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(20);
        }
        if (virtualFileInEditor == null) {
            return;
        }
        Map cached = (Map)HEADER_ROOT_AND_CONFIGURATION_KEY.getValue((UserDataHolder)project);
        cached.remove(virtualFileInEditor);
        OCInclusionContextUtil.invalidateHeaderContextsExcept(null, project);
    }

    @NotNull
    public static OCImmutableInclusionContext headerContext(@NotNull PsiFile file) {
        PsiFile original;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(21);
        }
        if ((original = OCInclusionContextUtil.getOriginalFile(file)) == null) {
            OCInclusionContext oCInclusionContext = OCInclusionContextImpl.emptyWithBuiltinMacros(null, file);
            if (oCInclusionContext == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(22);
            }
            return oCInclusionContext;
        }
        Project project = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        Map cache = (Map)HEADER_CONTEXT_KEY.getValue((UserDataHolder)project);
        OCImmutableInclusionContext cached = (OCImmutableInclusionContext)cache.get(virtualFile);
        if (cached != null) {
            OCImmutableInclusionContext oCImmutableInclusionContext = cached;
            if (oCImmutableInclusionContext == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(23);
            }
            return oCImmutableInclusionContext;
        }
        OCInclusionContext result = OCInclusionContextUtil.innerCalculateHeaderContext(original, null);
        cache.put(virtualFile, result);
        OCInclusionContext oCInclusionContext = result;
        if (oCInclusionContext == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(24);
        }
        return oCInclusionContext;
    }

    public static OCInclusionContext calculateHeaderContext(@NotNull PsiFile file, @Nullable OCLanguageKind languageKind) {
        PsiFile original;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(25);
        }
        if ((original = OCInclusionContextUtil.getOriginalFile(file)) == null) {
            return OCInclusionContextImpl.emptyWithBuiltinMacros(languageKind, file);
        }
        return OCInclusionContextUtil.innerCalculateHeaderContext(original, languageKind);
    }

    @Nullable
    public static PsiFile getOriginalFile(@Nullable PsiFile file) {
        PsiFile physical;
        if (file == null) {
            return null;
        }
        PsiFile original = OCLanguageUtils.asFileWithOCResolve(file.getOriginalFile());
        if (original == null) {
            return null;
        }
        if (original.isPhysical()) {
            return original;
        }
        for (physical = original; physical != null && !physical.isPhysical(); physical = physical.getContext()) {
        }
        return OCLanguageUtils.asFileWithOCResolve(physical != null ? physical.getContainingFile() : null);
    }

    @NotNull
    private static OCInclusionContext innerCalculateHeaderContext(@NotNull PsiFile original, @Nullable OCLanguageKind kind) {
        if (original == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(26);
        }
        Project project = original.getProject();
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(original);
        if (OCInclusionContextUtil.isNeedToFindRoot(virtualFile, project)) {
            PsiFile importHolder;
            OCResolveRootAndConfiguration rootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            PsiFile psiFile = importHolder = rootFile != null && rootFile.isValid() ? OCLanguageUtils.asFileWithOCResolve(project, rootFile) : null;
            if (importHolder != null && !rootFile.equals(virtualFile)) {
                OCResolveConfiguration config = rootAndConfiguration.getConfiguration();
                if (config != null) {
                    OCImmutableInclusionContext precompiledContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, virtualFile, rootFile);
                    if (precompiledContext == null) {
                        OCLanguageKind importHolderKind = OCPsiFile.getKind(importHolder);
                        assert (importHolderKind != null) : "file without OC resolve";
                        precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(config, importHolderKind, importHolder);
                    } else {
                        precompiledContext = precompiledContext.getParent();
                        assert (precompiledContext != null && precompiledContext.getParent() == null);
                    }
                    OCInclusionContext result = precompiledContext.derive(importHolder);
                    result.preprocessContextOf(importHolder, virtualFile);
                    OCInclusionContext oCInclusionContext = result;
                    if (oCInclusionContext == null) {
                        OCInclusionContextUtil.$$$reportNull$$$0(27);
                    }
                    return oCInclusionContext;
                }
            } else if (kind == null) {
                kind = rootAndConfiguration.getKind();
            }
        }
        return OCInclusionContextUtil.sourceFileContext(original, kind);
    }

    @NotNull
    private static OCInclusionContext sourceFileContext(@NotNull PsiFile file, @Nullable OCLanguageKind kindOrNullForDefault) {
        OCResolveConfiguration config;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(28);
        }
        if (kindOrNullForDefault == null) {
            OCLanguageKind kind = OCPsiFile.getKind(file);
            assert (kind != null) : "file without OC resolve";
            kindOrNullForDefault = kind;
        }
        if ((config = OCResolveConfigurations.doGetPreselectedConfiguration((VirtualFile)OCInclusionContextUtil.getVirtualFile(file), (Project)file.getProject())) != null) {
            OCInclusionContext oCInclusionContext = OCInclusionContext.sourceParsingContext(config, kindOrNullForDefault, file);
            if (oCInclusionContext == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(29);
            }
            return oCInclusionContext;
        }
        OCInclusionContext oCInclusionContext = OCInclusionContextImpl.emptyWithBuiltinMacros(kindOrNullForDefault, file);
        if (oCInclusionContext == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(30);
        }
        return oCInclusionContext;
    }

    public static void resetUserSelectedConfigurations(@NotNull Project project) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(31);
        }
        OCResolveContextSettings.getInstance((Project)project).resetConfigurationPriorities();
    }

    public static void setUserSelectedConfiguration(@NotNull PsiFile psiFile, @Nullable OCResolveConfiguration config) {
        PsiFile contextFile;
        if (psiFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(32);
        }
        Project project = psiFile.getProject();
        if (config != null) {
            OCResolveContextSettings.getInstance((Project)project).setSelectedConfiguration(config);
        }
        if ((contextFile = FileContextUtil.getContextFile((PsiElement)psiFile)) != null) {
            psiFile = contextFile;
        }
        psiFile.putUserData(FILE_ACTIVE_CONFIGURATION_CACHE, null);
        OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationFor(OCInclusionContextUtil.getVirtualFile(psiFile), project);
        VirtualFile file = psiFile.getVirtualFile();
        if (file != null) {
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
        }
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile contextFile = FileContextUtil.getContextFile((PsiElement)element);
        return contextFile == null || !FileSymbolTablesCache.areSymbolsLoaded(contextFile.getProject()) ? null : (OCResolveConfiguration)((CachedValue)FILE_ACTIVE_CONFIGURATION_CACHE.getValue((UserDataHolder)contextFile)).getValue();
    }

    @Nullable
    public static OCResolveConfiguration getActiveConfiguration(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(33);
        }
        return OCInclusionContextUtil.getActiveConfiguration(file == null ? null : PsiManager.getInstance((Project)project).findFile(file));
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForFile(@NotNull PsiFile file, @Nullable ProgressIndicator progress) {
        PsiFile fileWithResolve;
        if (file == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(34);
        }
        if ((fileWithResolve = OCLanguageUtils.asFileWithOCResolve(file)) != null && OCInclusionContextUtil.isNeedToFindRoot(file)) {
            Set<OCResolveConfiguration> set = OCImportGraph.getInstance(file.getProject()).getAllHeaderConfigurations(fileWithResolve, progress);
            if (set == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(35);
            }
            return set;
        }
        Collection<OCResolveConfiguration> configurations = OCLibraryFileResolveConfigurationProvider.getConfigurations(file, progress);
        if (configurations != null) {
            Collection<OCResolveConfiguration> collection = configurations;
            if (collection == null) {
                OCInclusionContextUtil.$$$reportNull$$$0(36);
            }
            return collection;
        }
        Collection collection = OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile((VirtualFile)OCInclusionContextUtil.getVirtualFile(file), (Project)file.getProject());
        if (collection == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(37);
        }
        return collection;
    }

    public static String pragmaOnceId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(38);
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_pragma_once");
    }

    public static String inclusionId(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(39);
        }
        return OCInclusionContextUtil.fileGuard(vFile, "__CIDR_included");
    }

    @NonNls
    private static String fileGuard(@NotNull VirtualFile vFile, @NotNull @NonNls String prefix) {
        if (vFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(40);
        }
        if (prefix == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(41);
        }
        if (vFile instanceof VirtualFileWithId) {
            return prefix + "_id_" + ((VirtualFileWithId)vFile).getId();
        }
        return prefix + "_path_" + vFile.getPath();
    }

    public static void storeCachedContextChangeSet(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull OCContextChangeSet changeSet) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(42);
        }
        if (virtualFile == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(43);
        }
        if (changeSet == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(44);
        }
        ((Map)CONTEXT_CHANGES_KEY.get((UserDataHolder)project)).put(virtualFile, changeSet);
    }

    public static OCContextChangeSet cachedContextChangeSet(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            OCInclusionContextUtil.$$$reportNull$$$0(45);
        }
        if (virtualFile == null) {
            return null;
        }
        return (OCContextChangeSet)((Map)CONTEXT_CHANGES_KEY.getValue((UserDataHolder)project)).get(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 25: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualHeaderFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveRootAndActiveConfiguration";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "headerContext";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "innerCalculateHeaderContext";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceFileContext";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBuildConfigurationsForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computePreselectedConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCachedPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNeedToFindRoot";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResolveRootAndActiveConfiguration";
                break;
            }
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getResolveRootAndActiveConfigurationForHeader";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createResolveRootAndConfiguration";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderRootAndActiveConfigurationForAllExcept";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderContextsExcept";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "invalidateContextChangeCacheExcept";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeExcept";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invalidateHeaderRootAndActiveConfigurationFor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "headerContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calculateHeaderContext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "innerCalculateHeaderContext";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sourceFileContext";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resetUserSelectedConfigurations";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setUserSelectedConfiguration";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfiguration";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAllBuildConfigurationsForFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "pragmaOnceId";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "inclusionId";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "fileGuard";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "storeCachedContextChangeSet";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "cachedContextChangeSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VirtualFileComparator
    implements Comparator<VirtualFile> {
        private final Project myProject;
        private final String myHeaderNameWithoutExtension;

        public VirtualFileComparator(Project project, String headerNameWithoutExtension) {
            this.myProject = project;
            this.myHeaderNameWithoutExtension = headerNameWithoutExtension.toUpperCase(Locale.getDefault());
        }

        @Override
        public int compare(@NotNull VirtualFile root1, @NotNull VirtualFile root2) {
            int result;
            if (root1 == null) {
                VirtualFileComparator.$$$reportNull$$$0(0);
            }
            if (root2 == null) {
                VirtualFileComparator.$$$reportNull$$$0(1);
            }
            if ((result = Comparing.compare((boolean)OCPCHCache.isPrecompiledHeader((VirtualFile)root1, (Project)this.myProject), (boolean)OCPCHCache.isPrecompiledHeader((VirtualFile)root2, (Project)this.myProject))) != 0) {
                return -result;
            }
            result = Comparing.compare((boolean)OCFileTypeHelpers.isSourceFile((String)root1.getName()), (boolean)OCFileTypeHelpers.isSourceFile((String)root2.getName()));
            if (result != 0) {
                return -result;
            }
            String rootName1 = root1.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            String rootName2 = root2.getNameWithoutExtension().toUpperCase(Locale.getDefault());
            result = Comparing.compare((boolean)this.myHeaderNameWithoutExtension.equals(rootName1), (boolean)this.myHeaderNameWithoutExtension.equals(rootName2));
            if (result != 0) {
                return -result;
            }
            result = Comparing.compare((Comparable)((Object)rootName1), (Comparable)((Object)rootName2));
            if (result != 0) {
                return result;
            }
            return Comparing.compare((Comparable)((Object)root1.getPath()), (Comparable)((Object)root2.getPath()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root2";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/preprocessor/OCInclusionContextUtil$VirtualFileComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

