/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCParsingNameScope
implements DeepEqual.Equality<OCParsingNameScope> {
    @NonNls
    private static final String LOCAL_SCOPE_NAME = "$LOCAL_SCOPE$";
    public static final String GLOBAL_SCOPE_NAME = "";
    private static final int LAST_COMPONENT_INDEX = 0x3FFFFFFF;
    @NotNull
    private final String myName;
    @Nullable
    private Set<String> myProtocolNames;
    @Nullable
    private Map<String, Kind> myNameKinds;
    @Nullable
    private Map<String, OCParsingNameScope> myInnerScopes;
    @Nullable
    private List<OCParsingNameScope> myNamespaceUsings;
    @Nullable
    private final OCParsingNameScope myParent;
    @Nullable
    private OCParsingNameScope myDelegate;
    @Nullable
    private List<TemplateTypeParameter> myTemplateTypeParameters;
    @Nullable
    private List<String> myTemplateValueParameters;
    public static final HashingStrategy<OCParsingNameScope> HASHING_STRATEGY = new HashingStrategy<OCParsingNameScope>(){

        public boolean equals(OCParsingNameScope o1, OCParsingNameScope o2) {
            return DeepEqual.equalObjects(o1, o2);
        }

        public int hashCode(OCParsingNameScope scope) {
            int result = scope.myName.hashCode();
            result = 31 * result + (scope.myNameKinds != null ? scope.myNameKinds.size() : 0);
            result = 31 * result + (scope.myProtocolNames != null ? scope.myProtocolNames.size() : 0);
            result = 31 * result + (scope.myNamespaceUsings != null ? scope.myNamespaceUsings.size() : 0);
            result = 31 * result + (scope.myParent != null ? scope.myParent.myName.hashCode() : 0);
            result = 31 * result + (scope.myInnerScopes != null ? scope.myInnerScopes.size() : 0);
            return result;
        }
    };

    @Nullable
    public OCParsingNameScope getDelegate() {
        return this.myDelegate;
    }

    public OCParsingNameScope() {
        this(GLOBAL_SCOPE_NAME, null);
    }

    @NotNull
    public OCParsingNameScope copy() {
        OCParsingNameScope oCParsingNameScope = this.delegatingCopy();
        if (oCParsingNameScope == null) {
            OCParsingNameScope.$$$reportNull$$$0(0);
        }
        return oCParsingNameScope;
    }

    @NotNull
    public OCParsingNameScope delegatingCopy() {
        OCParsingNameScope parent = this.getParent();
        OCParsingNameScope result = this.newScope(this.getName(), parent == null ? null : parent.delegatingCopy());
        result.myDelegate = this;
        OCParsingNameScope oCParsingNameScope = result;
        if (oCParsingNameScope == null) {
            OCParsingNameScope.$$$reportNull$$$0(1);
        }
        return oCParsingNameScope;
    }

    @NotNull
    protected OCParsingNameScope newScope(@NotNull @NonNls String name, @Nullable OCParsingNameScope parentCopy) {
        if (name == null) {
            OCParsingNameScope.$$$reportNull$$$0(2);
        }
        return new OCParsingNameScope(name, parentCopy);
    }

    @NotNull
    public OCParsingNameScope mergeToDelegate() {
        if (this.myDelegate == null) {
            OCParsingNameScope oCParsingNameScope = this;
            if (oCParsingNameScope == null) {
                OCParsingNameScope.$$$reportNull$$$0(3);
            }
            return oCParsingNameScope;
        }
        this.myDelegate.addProtocolNames(this.myProtocolNames);
        this.myDelegate.addNameKinds(this.myNameKinds);
        if (this.myInnerScopes != null) {
            for (Map.Entry<String, OCParsingNameScope> entry : this.myInnerScopes.entrySet()) {
                String name = entry.getKey();
                OCParsingNameScope scope = entry.getValue();
                OCParsingNameScope delegateScope = this.myDelegate.getInnerScope(name);
                if (delegateScope != null) {
                    delegateScope.merge(scope);
                    continue;
                }
                this.myDelegate.addInnerScope(name, scope);
            }
        }
        this.myDelegate.addNamespaceUsings(this.myNamespaceUsings);
        OCParsingNameScope oCParsingNameScope = this.myDelegate;
        if (oCParsingNameScope == null) {
            OCParsingNameScope.$$$reportNull$$$0(4);
        }
        return oCParsingNameScope;
    }

    private OCParsingNameScope getInnerScope(@Nullable String name) {
        return this.myInnerScopes == null || name == null ? null : this.myInnerScopes.get(name);
    }

    private void addInnerScope(@NotNull String name, @NotNull OCParsingNameScope scope) {
        if (name == null) {
            OCParsingNameScope.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            OCParsingNameScope.$$$reportNull$$$0(6);
        }
        if (this.myInnerScopes == null) {
            this.myInnerScopes = CollectionFactory.createSmallMemoryFootprintMap();
        }
        this.myInnerScopes.put(name, scope);
    }

    private void merge(@NotNull OCParsingNameScope scope) {
        if (scope == null) {
            OCParsingNameScope.$$$reportNull$$$0(7);
        }
        this.addProtocolNames(scope.myProtocolNames);
        this.addNameKinds(scope.myNameKinds);
        this.addInnerScopes(scope.myInnerScopes);
        this.addNamespaceUsings(scope.myNamespaceUsings);
    }

    private void addNameKinds(@Nullable Map<String, Kind> nameKinds) {
        if (nameKinds == null) {
            return;
        }
        if (this.myNameKinds == null) {
            this.myNameKinds = new HashMap<String, Kind>(nameKinds);
        } else {
            this.myNameKinds.putAll(nameKinds);
        }
    }

    private void addInnerScopes(@Nullable Map<String, OCParsingNameScope> scopes) {
        if (scopes == null) {
            return;
        }
        if (this.myInnerScopes == null) {
            this.myInnerScopes = new HashMap<String, OCParsingNameScope>(scopes);
        } else {
            this.myInnerScopes.putAll(scopes);
        }
    }

    private void addProtocolNames(@Nullable Set<String> protocolNames) {
        if (protocolNames == null) {
            return;
        }
        if (this.myProtocolNames == null) {
            this.myProtocolNames = new HashSet<String>(protocolNames);
        } else {
            this.myProtocolNames.addAll(protocolNames);
        }
    }

    private void addNamespaceUsings(@Nullable List<OCParsingNameScope> namespaceUsings) {
        if (namespaceUsings == null) {
            return;
        }
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>(namespaceUsings);
        } else {
            this.myNamespaceUsings.addAll(namespaceUsings);
        }
    }

    @NotNull
    @NonNls
    private String getNiceName() {
        if (this.getName() == GLOBAL_SCOPE_NAME) {
            return "::";
        }
        if (this.getName() == LOCAL_SCOPE_NAME) {
            return "<local>";
        }
        String string = this.getName();
        if (string == null) {
            OCParsingNameScope.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected OCParsingNameScope(@NotNull @NonNls String name, @Nullable OCParsingNameScope parent) {
        if (name == null) {
            OCParsingNameScope.$$$reportNull$$$0(9);
        }
        this.myName = name;
        this.myParent = parent;
        if (parent != null) {
            OCParsingNameScope delegate;
            parent.addInnerScope(name, this);
            if (parent.myDelegate != null && (delegate = parent.myDelegate.getInnerScope(name)) != null) {
                this.myDelegate = delegate;
            }
        }
    }

    public static Kind getTypeKind(boolean isTemplate) {
        return isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
    }

    public static boolean isTemplate(@Nullable Kind kind) {
        return kind == Kind.CPP_CONCEPT || kind == Kind.TEMPLATE_TYPE || kind == Kind.TEMPLATE_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.OBJC_INTERFACE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isCppType(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_TYPE || kind == Kind.TEMPLATE_TYPE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    public static boolean isValue(@Nullable Kind kind) {
        return kind == Kind.SIMPLE_VALUE || kind == Kind.TEMPLATE_VALUE || kind == Kind.TYPE_AND_VALUE || kind == Kind.UNKNOWN;
    }

    @Nullable
    public OCParsingNameScope getParent() {
        return this.myParent;
    }

    public OCParsingNameScope dropAndGetParent() {
        if (this.myParent != null && this.myParent.myInnerScopes != null) {
            this.myParent.myInnerScopes.remove(this.myName);
        }
        return this.myParent;
    }

    @NotNull
    @TestOnly
    public Collection<OCParsingNameScope> getInnerScopes() {
        Collection<OCParsingNameScope> collection = this.myInnerScopes == null ? Collections.emptyList() : this.myInnerScopes.values();
        if (collection == null) {
            OCParsingNameScope.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    @TestOnly
    public Collection<String> getDefinedNames() {
        Collection<String> collection = this.myNameKinds == null ? Collections.emptyList() : this.myNameKinds.keySet();
        if (collection == null) {
            OCParsingNameScope.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Nullable
    public Kind getKind(String qualifiedName) {
        return this.getKind(Collections.singletonList(qualifiedName));
    }

    @Nullable
    public Kind getKind(List<String> qualifiedName) {
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 1 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            return this.getKindInGlobal(qualifiedName, context);
        }
        return this.getKindWithParents(qualifiedName, 0, context);
    }

    @Nullable
    private Kind getKindTerminal(@NotNull String qualifiedName, @Nullable ResolveContext context) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(12);
        }
        Kind result = null;
        OCParsingNameScope scope = this;
        while (result == null && scope != null) {
            Kind kind = result = scope.myNameKinds == null ? null : scope.myNameKinds.get(qualifiedName);
            if (result == null && scope.myNamespaceUsings != null) {
                if (context == null) {
                    context = new ResolveContext();
                }
                if (context.shouldCheckAtOffset(scope, 0x3FFFFFFF)) {
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        Kind r = using.getKindTerminal(qualifiedName, context);
                        if (!OCParsingNameScope.isType(r) && !OCParsingNameScope.isValue(r)) continue;
                        result = r;
                        break;
                    }
                }
            }
            scope = scope.myDelegate;
        }
        return result;
    }

    public boolean isProtocol(@Nullable String name) {
        return this.isProtocol(name, true);
    }

    protected boolean isProtocol(@Nullable String name, boolean shouldCheckDelegates) {
        return this.myProtocolNames != null && this.myProtocolNames.contains(name) || shouldCheckDelegates && this.myDelegate != null && this.myDelegate.isProtocol(name, true) || this.myParent != null && this.myParent.isProtocol(name, this.myDelegate == null);
    }

    @Nullable
    protected Kind getKind(List<String> qualifiedName, int offset, ResolveContext context) {
        String namePart;
        Kind result = OCParsingNameScope.getKindIfDecltype(qualifiedName, offset, context);
        if (result != null) {
            return result;
        }
        if (qualifiedName.size() == 1) {
            if (this.myTemplateValueParameters != null && this.myTemplateValueParameters.contains(qualifiedName.get(0))) {
                return Kind.SIMPLE_VALUE;
            }
            if (this.myTemplateTypeParameters != null) {
                for (TemplateTypeParameter pair : this.myTemplateTypeParameters) {
                    if (!pair.name.equals(qualifiedName.get(0))) continue;
                    return pair.isTemplateTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
                }
            }
        }
        if ((namePart = qualifiedName.get(offset)) != null && qualifiedName.size() == offset + 1) {
            result = this.getKindTerminal(namePart, context);
        } else {
            OCParsingNameScope scope = this;
            while (result == null && scope != null) {
                OCParsingNameScope child = scope.getInnerScope(namePart);
                if (child != null && (result = child.getKind(qualifiedName, offset + 1, context)) == null) {
                    result = Kind.UNKNOWN;
                }
                if (result == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                    boolean foundNonType = false;
                    for (OCParsingNameScope using : scope.myNamespaceUsings) {
                        result = using.getKindWithParents(qualifiedName, offset, context);
                        if (result == Kind.NON_TYPE) {
                            foundNonType = true;
                            continue;
                        }
                        if (result == null) continue;
                        break;
                    }
                    if (result == null && foundNonType) {
                        result = Kind.NON_TYPE;
                    }
                }
                scope = scope.myDelegate;
            }
        }
        return result;
    }

    @Nullable
    private Kind getKindWithParents(List<String> qualifiedName, int offset, ResolveContext context) {
        Kind result = this.getKind(qualifiedName, offset, context);
        if (this.myParent != null) {
            if (result == null) {
                return this.myParent.getKindWithParents(qualifiedName, offset, context);
            }
            if (result == Kind.NON_TYPE) {
                Kind parentResult = this.myParent.getKindWithParents(qualifiedName, offset, context);
                return parentResult != null ? parentResult : Kind.NON_TYPE;
            }
        }
        return result;
    }

    @Nullable
    private Kind getKindInGlobal(List<String> qualifiedName, ResolveContext context) {
        if (this.myParent != null) {
            return this.myParent.getKindInGlobal(qualifiedName, context);
        }
        if (qualifiedName.size() > 1) {
            return this.getKind(qualifiedName, 1, context);
        }
        return Kind.TEMPLATE_TYPE;
    }

    private static Kind getKindIfDecltype(List<String> qualifiedName, int offset, ResolveContext context) {
        assert (offset >= 0 && offset < qualifiedName.size());
        String namePart = qualifiedName.get(offset);
        if (namePart != null && OCTokenTypes.DECLTYPE_CPP_KEYWORD.getName().contentEquals(namePart)) {
            return Kind.SIMPLE_TYPE;
        }
        return null;
    }

    public void defineConcept(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(13);
        }
        Kind kind = Kind.CPP_CONCEPT;
        if (this.getKind(qualifiedName) != null) {
            return;
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineType(@NotNull String qualifiedName, boolean isTemplate) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(14);
        }
        this.defineType(qualifiedName, isTemplate, false);
    }

    public void defineType(@NotNull String qualifiedName, boolean isTemplate, boolean isFriend) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(15);
        }
        Kind kind = isTemplate ? Kind.TEMPLATE_TYPE : Kind.SIMPLE_TYPE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isValue(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else {
            if (existing == Kind.TEMPLATE_TYPE) {
                return;
            }
            if (isFriend && this.getKind(qualifiedName) != null) {
                this.getKind(qualifiedName);
                return;
            }
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineInterface(String qualifiedName) {
        Kind kind = Kind.OBJC_INTERFACE;
        if (OCParsingNameScope.isValue(this.getKindTerminal(qualifiedName, null))) {
            kind = Kind.TYPE_AND_VALUE;
        }
        this.registerKind(qualifiedName, kind);
    }

    public void defineProtocol(String name) {
        if (this.myProtocolNames == null) {
            this.myProtocolNames = new HashSet<String>();
        }
        this.myProtocolNames.add(name);
    }

    public void defineValue(String qualifiedName, boolean isTemplate) {
        Kind kind = isTemplate ? Kind.TEMPLATE_VALUE : Kind.SIMPLE_VALUE;
        Kind existing = this.getKindTerminal(qualifiedName, null);
        if (OCParsingNameScope.isType(existing)) {
            kind = Kind.TYPE_AND_VALUE;
        } else if (existing == Kind.TEMPLATE_VALUE) {
            return;
        }
        this.registerKind(qualifiedName, kind);
    }

    private void registerKind(String name, Kind kind) {
        if (this.myNameKinds == null) {
            this.myNameKinds = CollectionFactory.createSmallMemoryFootprintMap();
        }
        this.myNameKinds.put(name, kind);
    }

    public OCParsingNameScope defineNamespace(@NotNull String name) {
        OCParsingNameScope scope;
        if (name == null) {
            OCParsingNameScope.$$$reportNull$$$0(16);
        }
        if ((scope = this.getInnerScope(name)) == null || scope.getParent() != this) {
            scope = this.newScope(name, this);
        }
        return scope;
    }

    public OCParsingNameScope defineLocalScope() {
        return this.newScope(LOCAL_SCOPE_NAME, this);
    }

    @NotNull
    @NonNls
    public String getName() {
        String string = this.myName;
        if (string == null) {
            OCParsingNameScope.$$$reportNull$$$0(17);
        }
        return string;
    }

    public String toString() {
        return "OCParsingNameScope{" + this.getNiceName() + "}";
    }

    public void defineNamespaceAlias(String alias, String namespaceName) {
        this.defineNamespaceAlias(alias, Collections.singletonList(namespaceName));
    }

    public void defineNamespaceAlias(String alias, List<String> namespaceName) {
        OCParsingNameScope scope = this.resolveNamespace(namespaceName);
        if (scope != null) {
            this.addInnerScope(alias, scope);
        }
    }

    public void defineNamespaceUsing(@NotNull List<String> qualifiedName) {
        OCParsingNameScope scope;
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(18);
        }
        if (this.myNamespaceUsings == null) {
            this.myNamespaceUsings = new ArrayList<OCParsingNameScope>();
        }
        if ((scope = this.resolveNamespace(qualifiedName)) != null && scope != this && !this.myNamespaceUsings.contains(scope)) {
            this.myNamespaceUsings.add(scope);
        }
    }

    public void defineNamespaceUsing(@NotNull String name) {
        if (name == null) {
            OCParsingNameScope.$$$reportNull$$$0(19);
        }
        this.defineNamespaceUsing(Collections.singletonList(name));
    }

    public void defineSymbolUsing(@NotNull String name) {
        if (name == null) {
            OCParsingNameScope.$$$reportNull$$$0(20);
        }
        this.defineSymbolUsing(Collections.singletonList(name));
    }

    public void defineSymbolUsing(@NotNull List<String> qualifiedName) {
        Kind kind;
        boolean isType;
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(21);
        }
        if (!(isType = OCParsingNameScope.isType(kind = this.getKind(qualifiedName))) && !OCParsingNameScope.isValue(kind)) {
            return;
        }
        String alias = qualifiedName.get(qualifiedName.size() - 1);
        this.registerKind(alias, kind);
        if (isType) {
            this.defineNamespaceAlias(alias, qualifiedName);
        }
    }

    @NotNull
    public List<String> getTemplateValueParameters() {
        List<String> list = this.myTemplateValueParameters != null ? this.myTemplateValueParameters : Collections.emptyList();
        if (list == null) {
            OCParsingNameScope.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public List<TemplateTypeParameter> getTemplateTypeParameters() {
        List<TemplateTypeParameter> list = this.myTemplateTypeParameters != null ? this.myTemplateTypeParameters : Collections.emptyList();
        if (list == null) {
            OCParsingNameScope.$$$reportNull$$$0(23);
        }
        return list;
    }

    public void addTemplateValueParameter(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(24);
        }
        if (this.myTemplateValueParameters == null) {
            this.myTemplateValueParameters = new ArrayList<String>();
        }
        this.myTemplateValueParameters.add(qualifiedName);
    }

    public void addTemplateTypeParameter(@NotNull String qualifiedName, boolean isTemplateTemplate) {
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(25);
        }
        if (this.myTemplateTypeParameters == null) {
            this.myTemplateTypeParameters = new ArrayList<TemplateTypeParameter>();
        }
        this.myTemplateTypeParameters.add(new TemplateTypeParameter(qualifiedName, isTemplateTemplate));
    }

    public void clearTemplateParameters() {
        this.myTemplateValueParameters = null;
        this.myTemplateTypeParameters = null;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(@NotNull List<String> qualifiedName) {
        OCParsingNameScope result;
        if (qualifiedName == null) {
            OCParsingNameScope.$$$reportNull$$$0(26);
        }
        ResolveContext context = new ResolveContext();
        if (qualifiedName.size() > 0 && qualifiedName.get(0).equals(GLOBAL_SCOPE_NAME)) {
            OCParsingNameScope global = this;
            while (global.myParent != null) {
                global = global.myParent;
            }
            result = global.resolveNamespace(qualifiedName, 1, context);
        } else {
            result = this.resolveNamespace(qualifiedName, 0, context);
        }
        return result;
    }

    @Nullable
    private OCParsingNameScope resolveNamespace(List<String> qualifiedName, int offset, ResolveContext context) {
        if (offset == qualifiedName.size()) {
            return this;
        }
        OCParsingNameScope result = null;
        String name = qualifiedName.get(offset);
        OCParsingNameScope scope = this;
        while (result == null && scope != null) {
            OCParsingNameScope child = scope.getInnerScope(name);
            if (child != null) {
                result = child.resolveNamespace(qualifiedName, offset + 1, context);
            }
            if (result == null && scope.myNamespaceUsings != null && context.shouldCheckAtOffset(scope, offset)) {
                OCParsingNameScope using;
                Iterator<OCParsingNameScope> iterator = scope.myNamespaceUsings.iterator();
                while (iterator.hasNext() && (result = (using = iterator.next()).resolveNamespace(qualifiedName, offset, context)) == null) {
                }
            }
            scope = scope.myDelegate;
        }
        if (result == null && this.myParent != null) {
            result = this.myParent.resolveNamespace(qualifiedName, offset, context);
        }
        return result;
    }

    @Override
    public final boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCParsingNameScope first, @NotNull OCParsingNameScope second) {
        if (c == null) {
            OCParsingNameScope.$$$reportNull$$$0(27);
        }
        if (first == null) {
            OCParsingNameScope.$$$reportNull$$$0(28);
        }
        if (second == null) {
            OCParsingNameScope.$$$reportNull$$$0(29);
        }
        if (!first.myName.equals(second.myName)) {
            return false;
        }
        if (!Objects.equals(first.myNameKinds, second.myNameKinds)) {
            return false;
        }
        if (!Objects.equals(first.myProtocolNames, second.myProtocolNames)) {
            return false;
        }
        if (!Objects.equals(first.myTemplateTypeParameters, second.myTemplateTypeParameters)) {
            return false;
        }
        if (!Objects.equals(first.myTemplateValueParameters, second.myTemplateValueParameters)) {
            return false;
        }
        if (!c.equalLists(first.myNamespaceUsings, second.myNamespaceUsings)) {
            return false;
        }
        if (!c.equalObjects(first.myParent, second.myParent)) {
            return false;
        }
        return c.equalMaps(first.myInnerScopes, second.myInnerScopes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "delegatingCopy";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeToDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNiceName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerScopes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinedNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateValueParameters";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addInnerScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getKindTerminal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "defineConcept";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "defineType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "defineNamespace";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "defineNamespaceUsing";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "defineSymbolUsing";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateValueParameter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateTypeParameter";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveNamespace";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResolveContext {
        private Map<OCParsingNameScope, List<Integer>> myCurrentOffsets;

        private ResolveContext() {
        }

        public boolean shouldCheckAtOffset(@NotNull OCParsingNameScope scope, int positionInName) {
            SmartList checkedPositions;
            if (scope == null) {
                ResolveContext.$$$reportNull$$$0(0);
            }
            if (this.myCurrentOffsets == null) {
                this.myCurrentOffsets = CollectionFactory.createSmallMemoryFootprintMap();
                checkedPositions = null;
            } else {
                checkedPositions = this.myCurrentOffsets.get(scope);
            }
            if (checkedPositions == null) {
                checkedPositions = new SmartList((Object)positionInName);
                this.myCurrentOffsets.put(scope, (List<Integer>)checkedPositions);
            } else if (!checkedPositions.contains(positionInName)) {
                checkedPositions.add(positionInName);
            } else {
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope$ResolveContext", "shouldCheckAtOffset"));
        }
    }

    public static final class TemplateTypeParameter {
        @NotNull
        public final String name;
        public final boolean isTemplateTemplate;

        private TemplateTypeParameter(@NotNull String name, boolean isTemplateTemplate) {
            if (name == null) {
                TemplateTypeParameter.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.isTemplateTemplate = isTemplateTemplate;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TemplateTypeParameter)) {
                return false;
            }
            TemplateTypeParameter parameter = (TemplateTypeParameter)o;
            return this.isTemplateTemplate == parameter.isTemplateTemplate && this.name.equals(parameter.name);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + Boolean.hashCode(this.isTemplateTemplate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/cidr/lang/preprocessor/OCParsingNameScope$TemplateTypeParameter", "<init>"));
        }
    }

    public static enum Kind {
        UNKNOWN,
        SIMPLE_TYPE,
        TEMPLATE_TYPE,
        SIMPLE_VALUE,
        TEMPLATE_VALUE,
        OBJC_INTERFACE,
        TYPE_AND_VALUE,
        CPP_CONCEPT,
        NON_TYPE;

    }
}

