/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCBinaryExpression {
    public OCBinaryExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCBinaryExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        String name = this.getOperationSign().getName();
        OCExpression left = this.getLeft();
        OCExpression right = this.getRight();
        if (left != null && right != null) {
            return new OCOperatorReference((PsiElement)this, name, OCOperatorReference.OperatorPlacement.INFIX, this.getOperationSignNode().getPsi(), left, right);
        }
        return null;
    }

    @Override
    @Nullable
    public OCExpression getLeft() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public OCExpression getRight() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt instanceof OCPunctuatorElementType) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!(tt instanceof OCPunctuatorElementType)) continue;
            ASTNode aSTNode = child;
            if (aSTNode == null) {
                OCBinaryExpressionImpl.$$$reportNull$$$0(1);
            }
            return aSTNode;
        }
        throw new AssertionError((Object)("Cannot find operation sign in binary expression: " + this.getText()));
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        OCElementType oCElementType = (OCElementType)this.getOperationSignNode().getElementType();
        if (oCElementType == null) {
            OCBinaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return oCElementType;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCBinaryExpressionImpl.$$$reportNull$$$0(3);
        }
        visitor.visitBinaryExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context) {
        OCOperatorReference reference;
        if (context == null) {
            OCBinaryExpressionImpl.$$$reportNull$$$0(4);
        }
        if ((reference = (OCOperatorReference)this.getReference()) != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                OCType oCType = ((OCFunctionSymbol)operator).getEffectiveType(this);
                if (oCType == null) {
                    OCBinaryExpressionImpl.$$$reportNull$$$0(5);
                }
                return oCType;
            }
        }
        OCExpression l = this.getLeft();
        OCExpression r = this.getRight();
        if (l == null) {
            OCType oCType = r != null ? r.getResolvedType(context) : OCUnknownType.INSTANCE;
            if (oCType == null) {
                OCBinaryExpressionImpl.$$$reportNull$$$0(6);
            }
            return oCType;
        }
        if (r == null) {
            OCType oCType = l.getResolvedType(context);
            if (oCType == null) {
                OCBinaryExpressionImpl.$$$reportNull$$$0(7);
            }
            return oCType;
        }
        OCElementType sign = this.getOperationSign();
        OCType lt = l.getResolvedType(context);
        OCType rt = r.getResolvedType(context);
        OCType oCType = OCBinaryExpressionImpl.getBinaryExprType(sign, lt, rt, OCResolveContext.forPsi(this));
        if (oCType == null) {
            OCBinaryExpressionImpl.$$$reportNull$$$0(8);
        }
        return oCType;
    }

    public static OCType getBinaryExprType(OCElementType sign, OCType lt, OCType rt, @NotNull OCResolveContext ctx) {
        OCType result;
        if (ctx == null) {
            OCBinaryExpressionImpl.$$$reportNull$$$0(9);
        }
        if (lt.isUnresolved(ctx) || rt.isUnresolved(ctx)) {
            result = OCUnknownType.INSTANCE;
        } else if (OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)sign) || OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)sign)) {
            result = OCIntType.getAppropriateBool(ctx.isObjc());
        } else if (lt.isSubclassOfMagic(ctx) || rt.isSubclassOfMagic(ctx)) {
            result = new OCMagicType(lt);
        } else if (sign == OCTokenTypes.DOT_MUL || sign == OCTokenTypes.DEREF_MUL) {
            if (rt instanceof OCCppReferenceType) {
                rt = ((OCCppReferenceType)rt).getRefType();
            }
            result = rt instanceof OCPointerType ? ((OCPointerType)rt).getRefType() : OCBinaryExpressionImpl.unknownOrMagic(lt, rt, ctx);
        } else if (sign == OCTokenTypes.SPACESHIP) {
            result = OCIntType.INT;
        } else {
            if (lt instanceof OCCppReferenceType) {
                lt = ((OCCppReferenceType)lt).getRefType();
            }
            if (rt instanceof OCCppReferenceType) {
                rt = ((OCCppReferenceType)rt).getRefType();
            }
            result = lt instanceof OCNumericType && rt instanceof OCNumericType && (sign == OCTokenTypes.PLUS || sign == OCTokenTypes.MINUS || sign == OCTokenTypes.DIV || sign == OCTokenTypes.PERC || sign == OCTokenTypes.MUL || sign == OCTokenTypes.AND || sign == OCTokenTypes.OR || sign == OCTokenTypes.XOR) ? lt.getLeastCommonType(rt, ctx) : (lt instanceof OCPointerType && rt instanceof OCPointerType ? OCIntType.ULONG : (lt instanceof OCPointerType && rt.isIntegerCompatible(ctx) ? lt : (rt instanceof OCPointerType && lt.isIntegerCompatible(ctx) ? rt : (!(!lt.isNumberCompatible(ctx) && !lt.isPointerCompatible(ctx) || !rt.isNumberCompatible(ctx) && !rt.isPointerCompatible(ctx)) ? lt : OCBinaryExpressionImpl.unknownOrMagic(lt, rt, ctx)))));
        }
        if (result instanceof OCNumericType) {
            result = result.cloneWithoutCVQualifiers(ctx.getProject());
        }
        return result;
    }

    private static OCType unknownOrMagic(OCType lt, OCType rt, @NotNull OCResolveContext context) {
        if (context == null) {
            OCBinaryExpressionImpl.$$$reportNull$$$0(10);
        }
        if (lt.isMagicInside(context) || rt.isMagicInside(context)) {
            return new OCMagicType(lt);
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Arrays.asList(this.getLeft(), this.getRight());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCBinaryExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSignNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryExprType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unknownOrMagic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

