/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileSymbolsContainerBase;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCLazyNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileGlobalSymbols
extends OCFileSymbolsContainerBase {
    private final Map<OCSymbol, VirtualFile> mySymbolToImport;
    private final Map<String, Pair<OCSymbol, VirtualFile>> myUndefinedProtocols;
    private final Map<String, Pair<OCSymbol, VirtualFile>> myUndefinedClasses;
    private final Set<VirtualFile> myRequiredImports;

    private OCFileGlobalSymbols(@NotNull PsiFile file) {
        if (file == null) {
            OCFileGlobalSymbols.$$$reportNull$$$0(0);
        }
        super(file);
        this.mySymbolToImport = CollectionFactory.createSmallMemoryFootprintMap();
        this.myUndefinedProtocols = CollectionFactory.createSmallMemoryFootprintMap();
        this.myUndefinedClasses = CollectionFactory.createSmallMemoryFootprintMap();
        this.myRequiredImports = CollectionFactory.createSmallMemoryFootprintSet();
    }

    public boolean process(OCSymbol symbol) {
        if (symbol instanceof OCLazyNamedSymbol) {
            this.myLazyNamedSymbols.add((OCLazyNamedSymbol)symbol);
            return true;
        }
        if (symbol instanceof OCClassSymbol) {
            VirtualFile importFile = this.mySymbolToImport.get(symbol);
            OCClassSymbol classSymbol = (OCClassSymbol)symbol;
            if (!(classSymbol instanceof OCForeignSymbol)) {
                this.checkSuperAndProtocolsDefined(classSymbol, importFile);
            }
            this.myNameToSymbol.add((Object)symbol.getName(), (Object)symbol);
        } else if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
            this.myUsingSymbols.add((OCUsingSymbol)symbol);
        } else {
            this.myNameToSymbol.add((Object)symbol.getName(), (Object)symbol);
            if (symbol.getKind() == OCSymbolKind.NAMESPACE && ((OCNamespaceSymbol)symbol).isInlineNamespace()) {
                this.myInlineNamespaces.add((OCNamespaceSymbol)symbol);
            }
        }
        return true;
    }

    private void checkSuperAndProtocolsDefined(@NotNull OCClassSymbol classSymbol, @Nullable VirtualFile importFile) {
        String superName;
        if (classSymbol == null) {
            OCFileGlobalSymbols.$$$reportNull$$$0(1);
        }
        for (String protocol : classSymbol.getProtocolNames()) {
            if (this.myUndefinedProtocols.containsKey(protocol) || this.findDefinition(protocol, OCSymbolKind.PROTOCOL, importFile)) continue;
            this.myUndefinedProtocols.put(protocol, (Pair<OCSymbol, VirtualFile>)Pair.create((Object)classSymbol, (Object)importFile));
        }
        if (classSymbol instanceof OCInterfaceSymbol && !(superName = classSymbol.getSuperClassName()).isEmpty() && !this.myUndefinedClasses.containsKey(superName) && !this.findDefinition(superName, OCSymbolKind.INTERFACE, importFile)) {
            this.myUndefinedClasses.put(superName, (Pair<OCSymbol, VirtualFile>)Pair.create((Object)classSymbol, (Object)importFile));
        }
    }

    private boolean findDefinition(String name, final OCSymbolKind kind, VirtualFile importFile) {
        VirtualFile definitionImportFile;
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return symbol.getKind() == kind && !symbol.isPredeclaration();
            }
        };
        this.myNameToSymbol.processForKey((Object)name, (Processor)finder);
        OCSymbol definition = (OCSymbol)finder.getFoundValue();
        if (definition != null && !Comparing.equal((Object)importFile, (Object)(definitionImportFile = this.mySymbolToImport.get(definition)))) {
            this.myRequiredImports.add(definitionImportFile);
        }
        return finder.isFound();
    }

    public Map<OCSymbol, VirtualFile> getSymbolToImport() {
        return this.mySymbolToImport;
    }

    public Map<String, Pair<OCSymbol, VirtualFile>> getUndefinedProtocols() {
        return this.myUndefinedProtocols;
    }

    public Map<String, Pair<OCSymbol, VirtualFile>> getUndefinedClasses() {
        return this.myUndefinedClasses;
    }

    public Set<VirtualFile> getRequiredImports() {
        return this.myRequiredImports;
    }

    public static OCFileGlobalSymbols buildSymbols(@NotNull PsiFile file) {
        if (file == null) {
            OCFileGlobalSymbols.$$$reportNull$$$0(2);
        }
        OCFileGlobalSymbols symbols = new OCFileGlobalSymbols(file);
        OCFileGlobalSymbolsCache.processFile(file, symbols, symbols.mySymbolToImport);
        return symbols;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSymbol";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/symbols/OCFileGlobalSymbols";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSuperAndProtocolsDefined";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSymbols";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

