/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeGCCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol>
implements LowPriorityAction {
    private String myAttribute;
    private String myAttributeText;
    private boolean myEnable;
    @IntentionName
    private String myText;

    public OCChangeGCCAttributeIntentionAction(@NotNull OCSymbol symbol, String attribute, String attributeText, boolean enable, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(1);
        }
        this(symbol, attribute, attributeText, symbol.getNameWithKindLowercase(context), enable, context);
    }

    public OCChangeGCCAttributeIntentionAction(@NotNull OCSymbol symbol, String attribute, String attributeText, String subject, boolean enable, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(2);
        }
        if (context == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(3);
        }
        super(context.getProject(), symbol);
        this.myAttribute = attribute;
        this.myAttributeText = attributeText;
        this.myEnable = enable;
        this.myText = OCInspectionsBundle.message("intention.name.choice.enable.disable", enable ? 0 : 1, this.myAttributeText, subject);
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myEnable ^ this.mySymbol.hasAttribute(this.myAttribute);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.change.gcc.attribute.action", this.myAttributeText);
        if (string == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor) {
        if (project == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(5);
        }
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project))) {
            return;
        }
        ArrayList definitions = new ArrayList();
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
            PsiElement definition = symbol1.locateDefinition(project);
            if (definition != null) {
                definitions.add(definition);
            }
            return true;
        }), project);
        for (PsiElement definition : definitions) {
            this.importFileContainingAttribute(definition);
            int offset = -1;
            if (definition.getParent() instanceof OCDeclaration) {
                PsiElement leaf;
                OCElement footer;
                OCDeclaration declaration = (OCDeclaration)definition.getParent();
                OCTemplateParameterList templateParams = declaration.getTemplateParameterList();
                OCRequiresClause requiresClause = declaration.getRequiresClause();
                OCElement oCElement = footer = requiresClause != null ? requiresClause : templateParams;
                if (declaration.getParent() instanceof OCEnum && definition instanceof OCDeclarator) {
                    PsiElement nameIdentifier = ((OCDeclarator)definition).getNameIdentifier();
                    offset = nameIdentifier != null ? nameIdentifier.getTextRange().getEndOffset() : declaration.getTextRange().getEndOffset();
                } else if (footer != null) {
                    leaf = OCElementUtil.getNextNonWhitespaceCommentLeaf(footer);
                    offset = leaf != null ? leaf.getTextOffset() : footer.getTextRange().getEndOffset();
                } else {
                    leaf = OCElementUtil.getFirstNonWhitespaceCommentLeaf(definition.getParent());
                    OCMacroRange macroCall = OCElementUtil.getRangeInMacroCall(leaf);
                    if (macroCall != null) {
                        leaf = macroCall.getFirstElement();
                    }
                    offset = leaf != null ? leaf.getTextOffset() : definition.getParent().getTextRange().getStartOffset();
                }
            } else if (definition instanceof OCStructLike) {
                PsiElement nameIdentifier = ((OCStructLike)definition).getNameIdentifier();
                offset = nameIdentifier != null ? nameIdentifier.getTextOffset() : definition.getParent().getTextRange().getEndOffset();
            } else if (definition instanceof OCMethod) {
                List<OCMethodSelectorPart> parameters = ((OCMethod)definition).getParameters();
                if (!parameters.isEmpty()) {
                    offset = parameters.get(parameters.size() - 1).getTextRange().getEndOffset();
                }
            } else if (definition instanceof OCMethodSelectorPart) {
                OCTypeElement typeElement = ((OCMethodSelectorPart)definition).getTypeElement();
                if (typeElement != null) {
                    offset = typeElement.getTextOffset();
                }
            } else if (definition instanceof OCLabeledStatement) {
                offset = definition.getTextOffset();
            } else if (definition instanceof OCCppUsingStatement) {
                PsiElement nameIdentifier = ((OCCppUsingStatement)definition).getNameIdentifier();
                offset = nameIdentifier != null ? nameIdentifier.getTextRange().getEndOffset() : definition.getTextOffset();
            } else assert (false) : definition.getClass();
            if (offset == -1) continue;
            if (this.myEnable) {
                OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), offset, 0, " " + this.myAttributeText + " ", true);
                continue;
            }
            int index = definition.getText().indexOf(this.myAttributeText);
            if (index == -1) continue;
            OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), definition.getTextRange().getStartOffset() + index, this.myAttributeText.length(), "", true);
        }
    }

    private void importFileContainingAttribute(PsiElement definition) {
        PsiFile file = definition.getContainingFile();
        OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
        context.setProcessNonImported(true);
        OCSymbolReference.GlobalReference ref = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.with(this.myAttributeText));
        List<OCSymbol> unusedSymbols = context.resolveToSymbols(ref);
        for (OCSymbol unused : unusedSymbols) {
            if (unused.getKind() == OCSymbolKind.MACRO && new OCImportSymbolFix((PsiElement)definition.getContainingFile(), unused).fixBestItem(file.getProject(), file)) break;
        }
    }

    public static OCChangeGCCAttributeIntentionAction unused(@NotNull OCSymbol symbol, @NotNull PsiFile file) {
        if (symbol == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(7);
        }
        return OCChangeGCCAttributeIntentionAction.unused(symbol, symbol.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)file)), file);
    }

    public static OCChangeGCCAttributeIntentionAction unused(@NotNull OCSymbol symbol, @NotNull String subject, @NotNull PsiFile file) {
        if (symbol == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(8);
        }
        if (subject == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(9);
        }
        if (file == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(10);
        }
        if (OCCompilerFeaturesHelper.supportsCxxAttributes(file) && OCCompilerFeaturesHelper.supportsCxxMaybeUnusedAttribute(file)) {
            String attribute = OCAttributes.makeCppAttribute((String)"maybe_unused");
            return new OCChangeGCCAttributeIntentionAction(symbol, attribute, attribute, subject, true, OCCompilationContext.create((PsiElement)file));
        }
        return new OCChangeGCCAttributeIntentionAction(symbol, "unused", "__attribute__((unused))", subject, true, OCCompilationContext.create((PsiElement)file));
    }

    public static OCChangeGCCAttributeIntentionAction noreturn(@NotNull OCSymbol symbol, @NotNull PsiFile file) {
        if (symbol == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(11);
        }
        if (file == null) {
            OCChangeGCCAttributeIntentionAction.$$$reportNull$$$0(12);
        }
        String attribute = OCCompilerFeaturesHelper.supportsCxxAttributes(file) ? OCAttributes.makeCppAttribute((String)"noreturn") : OCSymbolAttribute.NORETURN.toString();
        return new OCChangeGCCAttributeIntentionAction(symbol, attribute, attribute, true, OCCompilationContext.create((PsiElement)file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangeGCCAttributeIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unused";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "noreturn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

