/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertObjCLiteralIntentionAction
extends OCPsiElementQuickFix<OCSendMessageExpression> {
    private static final Converter[] CONVERTERS;
    private static final MultiMap<String, Converter> ourConverters;
    private static final Converter NUMBER_CONST_CONVERTER;
    private static final Converter NUMBER_CONVERTER;
    private Converter myConverter;

    public OCConvertObjCLiteralIntentionAction(@NotNull OCSendMessageExpression element, Converter converter) {
        if (element == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(0);
        }
        super(element);
        this.myConverter = converter;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.convert.objc.literal", new Object[0]);
        if (string == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NlsSafe
    protected String getTextInternal() {
        return this.myConverter.getIntentionName();
    }

    @Override
    public boolean isAvailable(@NotNull OCSendMessageExpression element) {
        if (element == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(2);
        }
        return this.getReplacement(element) != null;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCSendMessageExpression expr) {
        OCExpression newExpr;
        if (expr == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(3);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.convertToLiteral");
        String replacement = this.getReplacement(expr);
        OCExpression oCExpression = newExpr = replacement != null ? OCElementFactory.expressionFromText(replacement, expr) : null;
        if (newExpr != null) {
            OCChangeUtil.replaceHandlingMacros(expr, newExpr);
        }
    }

    @Nullable
    public String getReplacement(@Nullable OCSendMessageExpression expr) {
        Converter converter = OCConvertObjCLiteralIntentionAction.findConverter(expr);
        if (converter == null) {
            return null;
        }
        List<List<OCExpression>> arguments = OCConvertObjCLiteralIntentionAction.getArguments(expr, converter);
        @NlsSafe String replacement = converter.getReplacement();
        OCExpression receiver = OCParenthesesUtils.diveIntoParentheses(expr.getReceiverExpression());
        boolean isEmpty = false;
        boolean isFirst = true;
        if (arguments == null || arguments.isEmpty()) {
            return null;
        }
        if (receiver != null) {
            replacement = replacement.replace("#R", this.tryGetReplacement(receiver, receiver, true, 3));
        }
        while (!isEmpty) {
            for (int i2 = 0; i2 < arguments.size(); ++i2) {
                String argReplacement;
                List<OCExpression> curArguments = arguments.get(i2);
                OCExpression argument = OCParenthesesUtils.diveIntoParentheses((OCExpression)ContainerUtil.getFirstItem(curArguments));
                if (argument != null) {
                    argReplacement = "";
                    if (converter.getSpecialFlag() == SpecialFlag.INTERLEAVE && arguments.size() == 2) {
                        OCExpression coArgument = OCParenthesesUtils.diveIntoParentheses((OCExpression)ContainerUtil.getFirstItem(arguments.get(1 - i2)));
                        if (coArgument != null) {
                            argReplacement = this.tryGetReplacement(argument, coArgument, isFirst && i2 == 1, -1);
                        }
                    } else {
                        argReplacement = this.tryGetReplacement(argument, argument, isFirst && i2 == 0, -1);
                    }
                } else {
                    return null;
                }
                replacement = replacement.replace("#P" + i2, argReplacement + OCConvertObjCLiteralIntentionAction.getLiteralSuffix(converter, expr.getMessageSelector(), argument));
            }
            for (List<OCExpression> curArguments : arguments) {
                curArguments.remove(0);
                isEmpty |= curArguments.isEmpty();
            }
            replacement = replacement.replace("#*", (CharSequence)(isEmpty ? "" : converter.getReplacementLoop() + "#*"));
            isFirst = false;
        }
        return replacement;
    }

    @NlsSafe
    private static String getLiteralSuffix(Converter converter, @NlsSafe String selector, OCExpression argument) {
        if (converter == NUMBER_CONST_CONVERTER) {
            Number number = OCExpressionEvaluator.evaluate(argument);
            if (OCExpressionEvaluator.isIntValue(number)) {
                if (selector.equals("numberWithFloat:")) {
                    return ".0F";
                }
                if (selector.equals("numberWithDouble:")) {
                    return ".0";
                }
            } else if (selector.equals("numberWithFloat:")) {
                return "F";
            }
        }
        return "";
    }

    @NotNull
    public String tryGetReplacement(@NotNull OCExpression expr, @NotNull OCExpression spacesAndCommentsFrom, boolean skipWhitespaces, int parentPrecedence) {
        if (expr == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(4);
        }
        if (spacesAndCommentsFrom == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(5);
        }
        Object replacement = expr instanceof OCSendMessageExpression ? this.getReplacement((OCSendMessageExpression)expr) : null;
        int precedence = OCParenthesesUtils.getPrecedence(expr, false);
        if (replacement == null) {
            replacement = parentPrecedence != -1 && precedence > parentPrecedence ? "(" + expr.getTextWithMacros() + ")" : expr.getTextWithMacros();
        }
        String string = OCElementUtil.getLeadingCommentsAndWhitespaces(spacesAndCommentsFrom, skipWhitespaces) + (String)replacement + OCElementUtil.getTrailingCommentsAndWhitespaces(spacesAndCommentsFrom, skipWhitespaces);
        if (string == null) {
            OCConvertObjCLiteralIntentionAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static Converter findConverter(@Nullable OCSendMessageExpression expr) {
        if (expr == null || OCElementUtil.containsDirectives(expr)) {
            return null;
        }
        OCExpression receiver = expr.getReceiverExpression();
        OCType receiverType = receiver != null ? receiver.getResolvedType().getGuessedType() : null;
        String selector = expr.getMessageSelector();
        if (selector.startsWith("numberWith")) {
            OCMethodSymbol responder = expr.getProbableResponders().getKnownResponder();
            OCExpression argument = (OCExpression)ContainerUtil.getFirstItem(expr.getArgumentExpressions());
            String argumentText = argument != null ? argument.getTextWithMacros() : null;
            OCDeclaratorSymbol paramSymbol = responder != null ? (OCDeclaratorSymbol)ContainerUtil.getFirstItem(responder.getParameterSymbols()) : null;
            OCResolveContext context = OCResolveContext.forPsi(expr);
            if (paramSymbol == null || argument == null || !paramSymbol.getType().resolve(context).checkCompatible(argument.getResolvedType(), argument, argument, context).getState().isOK()) {
                return null;
            }
            @NlsSafe String yes = "YES";
            @NlsSafe String no = "NO";
            if (argument instanceof OCLiteralExpression || yes.equals(argumentText) || no.equals(argumentText)) {
                return NUMBER_CONST_CONVERTER;
            }
            return NUMBER_CONVERTER;
        }
        if (receiverType instanceof OCPointerType) {
            receiverType = ((OCPointerType)receiverType).getRefType();
        }
        String receiverTypeName = receiverType instanceof OCObjectType ? ((OCObjectType)receiverType).getClassName() : null;
        boolean supportsObjectLiterals = OCCompilerFeaturesHelper.supportsObjectLiterals(expr.getContainingFile());
        boolean supportsSubscripting = OCCompilerFeaturesHelper.supportsSubscripting(expr.getContainingFile());
        for (Converter converter : ourConverters.get((Object)selector)) {
            if (converter.getFeature() == Feature.COLLECTION && !supportsObjectLiterals || converter.getFeature() == Feature.SUBSCRIPTING && !supportsSubscripting || !converter.getReceiverType().equals(receiverTypeName)) continue;
            if (converter.getFeature() != Feature.CONSTANT) {
                for (OCExpression argument : expr.getArgumentExpressions()) {
                    OCType type = argument.getResolvedType();
                    OCResolveContext context = OCResolveContext.forPsi(argument);
                    if (type.isPointerToObject() || type.isUnknown() || OCExpressionEvaluator.isLikeNil(argument, context) || type.isIntegerCompatible(context)) continue;
                    return null;
                }
            }
            return converter;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static List<List<OCExpression>> getArguments(OCSendMessageExpression expr, Converter converter) {
        ArrayList<List<OCExpression>> allArguments = new ArrayList<List<OCExpression>>();
        ArrayList<OCExpression> arguments = null;
        for (OCMessageArgument argument : expr.getArguments()) {
            String string = argument.getArgumentSelector().getSelectorName();
            OCExpression argExpr = argument.getArgumentExpression();
            if (argExpr == null) continue;
            if (!string.isEmpty() || arguments == null) {
                if (arguments != null) {
                    allArguments.add((List<OCExpression>)arguments);
                }
                arguments = new ArrayList<OCExpression>();
            }
            if (converter.getSpecialFlag() == SpecialFlag.UNPACK_ARRAYS) {
                Converter subConverter;
                List items;
                if (argExpr instanceof OCLiteralExpression && argExpr.getFirstChild() instanceof OCNSArrayLiteral) {
                    arguments.addAll(((OCNSArrayLiteral)argExpr.getFirstChild()).getElements());
                    continue;
                }
                if (!(argExpr instanceof OCSendMessageExpression) || !((OCSendMessageExpression)argExpr).getMessageSelector().startsWith("arrayWithObject") || (items = (subConverter = OCConvertObjCLiteralIntentionAction.findConverter((OCSendMessageExpression)argExpr)) != null ? (List)ContainerUtil.getFirstItem(OCConvertObjCLiteralIntentionAction.getArguments((OCSendMessageExpression)argExpr, subConverter)) : null) == null) continue;
                arguments.addAll(items);
                continue;
            }
            if (converter.isRequireNilTermination() && OCCodeInsightUtil.isLikeNull(argExpr.getTextWithMacros())) continue;
            arguments.add(argExpr);
        }
        if (arguments != null) {
            if (converter.getSpecialFlag() == SpecialFlag.INTERLEAVE) {
                void var6_9;
                ArrayList<OCExpression> args1 = new ArrayList<OCExpression>();
                ArrayList<OCExpression> args2 = new ArrayList<OCExpression>();
                boolean bl = false;
                while (var6_9 < arguments.size()) {
                    OCExpression argument = (OCExpression)arguments.get((int)var6_9);
                    if (var6_9 % 2 == false) {
                        args1.add(argument);
                    } else {
                        args2.add(argument);
                    }
                    ++var6_9;
                }
                allArguments.add(args1);
                allArguments.add(args2);
            } else {
                allArguments.add(arguments);
            }
        }
        int length = -1;
        for (List list : allArguments) {
            if (length == -1) {
                length = list.size();
                continue;
            }
            if (length == list.size()) continue;
            return null;
        }
        return length > 0 ? allArguments : null;
    }

    static {
        @NlsSafe String name = "Switch to @[]";
        @NlsSafe String name1 = "Switch to @()";
        @NlsSafe String name2 = "Switch to []";
        @NlsSafe String name3 = "Switch to @{}";
        CONVERTERS = new Converter[]{new Converter(Feature.CONSTANT, "NSNumber", "numberWith*", name1, "@#P0"), new Converter(Feature.CONSTANT, "NSNumber", "numberWith*", name1, "@(#P0)"), new Converter(Feature.COLLECTION, "NSArray", "arrayWithObject:", name, "@[#P0]"), new Converter(Feature.COLLECTION, "NSArray", "arrayWithObjects:", name, "@[#P0#*]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSArray", "initWithObjects:", name, "@[#P0#*]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSMutableArray", "arrayWithObject:", name, "[@[#P0] mutableCopy]"), new Converter(Feature.COLLECTION, "NSMutableArray", "arrayWithObjects:", name, "[@[#P0#*] mutableCopy]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSMutableArray", "initWithObjects:", name, "[@[#P0#*] mutableCopy]", ",#P0", true, null), new Converter(Feature.COLLECTION, "NSDictionary", "dictionaryWithObject:forKey:", name3, "@{#P1:#P0}"), new Converter(Feature.COLLECTION, "NSDictionary", "dictionaryWithObjects:forKeys:", name3, "@{#P1:#P0#*}", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSDictionary", "initWithObjects:forKeys:", name3, "@{#P1:#P0#*}", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSDictionary", "dictionaryWithObjectsAndKeys:", name3, "@{#P1:#P0#*}", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.COLLECTION, "NSDictionary", "initWithObjectsAndKeys:", name3, "@{#P1:#P0#*}", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.COLLECTION, "NSMutableDictionary", "dictionaryWithObject:forKey:", name3, "[@{#P1:#P0} mutableCopy]"), new Converter(Feature.COLLECTION, "NSMutableDictionary", "dictionaryWithObjects:forKeys:", name3, "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSMutableDictionary", "initWithObjects:forKeys:", name3, "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", false, SpecialFlag.UNPACK_ARRAYS), new Converter(Feature.COLLECTION, "NSMutableDictionary", "dictionaryWithObjectsAndKeys:", name3, "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.COLLECTION, "NSMutableDictionary", "initWithObjectsAndKeys:", name3, "[@{#P1:#P0#*} mutableCopy]", ",#P1:#P0", true, SpecialFlag.INTERLEAVE), new Converter(Feature.SUBSCRIPTING, "NSArray", "objectAtIndex:", name2, "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSArray", "objectAtIndexedSubscript:", name2, "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "objectAtIndex:", name2, "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "objectAtIndexedSubscript:", name2, "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "replaceObjectAtIndex:withObject:", name2, "#R[#P0] = #P1"), new Converter(Feature.SUBSCRIPTING, "NSMutableArray", "setObject:atIndexedSubscript:", name2, "#R[#P1] = #P0"), new Converter(Feature.SUBSCRIPTING, "NSDictionary", "objectForKey:", name2, "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableDictionary", "objectForKey:", name2, "#R[#P0]"), new Converter(Feature.SUBSCRIPTING, "NSMutableDictionary", "setObject:forKey:", name2, "#R[#P1] = #P0"), new Converter(Feature.SUBSCRIPTING, "NSMutableDictionary", "setObject:forKeyedSubscript:", name2, "#R[#P1] = #P0")};
        NUMBER_CONST_CONVERTER = CONVERTERS[0];
        NUMBER_CONVERTER = CONVERTERS[1];
        ourConverters = new MultiMap();
        for (Converter converter : CONVERTERS) {
            ourConverters.putValue((Object)converter.getMessageName(), (Object)converter);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCConvertObjCLiteralIntentionAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spacesAndCommentsFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCConvertObjCLiteralIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryGetReplacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryGetReplacement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Converter {
        private Feature myFeature;
        private String myReceiverType;
        private String myMessageName;
        private String myIntentionName;
        private String myReplacement;
        private String myReplacementLoop;
        private boolean myRequireNilTermination;
        private SpecialFlag mySpecialFlag;

        private Converter(Feature feature, @NlsSafe String receiverType, @NlsSafe String messageName, String intentionName, @NlsSafe String replacement) {
            this.myFeature = feature;
            this.myReceiverType = receiverType;
            this.myMessageName = messageName;
            this.myIntentionName = intentionName;
            this.myReplacement = replacement;
        }

        private Converter(Feature feature, @NlsSafe String receiverType, @NlsSafe String messageName, String intentionName, @NlsSafe String replacement, @Nullable @NlsSafe String loop, boolean requireNilTermination, @Nullable SpecialFlag flag) {
            this(feature, receiverType, messageName, intentionName, replacement);
            this.myReplacementLoop = loop;
            this.myRequireNilTermination = requireNilTermination;
            this.mySpecialFlag = flag;
        }

        public Feature getFeature() {
            return this.myFeature;
        }

        public String getMessageName() {
            return this.myMessageName;
        }

        public String getIntentionName() {
            return this.myIntentionName;
        }

        public String getReplacement() {
            return this.myReplacement;
        }

        public String getReplacementLoop() {
            return this.myReplacementLoop;
        }

        public String getReceiverType() {
            return this.myReceiverType;
        }

        public boolean isRequireNilTermination() {
            return this.myRequireNilTermination;
        }

        public SpecialFlag getSpecialFlag() {
            return this.mySpecialFlag;
        }
    }

    private static enum SpecialFlag {
        UNPACK_ARRAYS,
        INTERLEAVE;

    }

    private static enum Feature {
        CONSTANT,
        COLLECTION,
        SUBSCRIPTING;

    }
}

