/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCSynthesizePropertyQuickFixBase;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMakePropertyDynamicQuickFix
extends OCSynthesizePropertyQuickFixBase
implements LowPriorityAction {
    public OCMakePropertyDynamicQuickFix(OCImplementationSymbol implementationSymbol, OCPropertySymbol property, Project project) {
        super(implementationSymbol, property, project);
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myProperty == null) {
            String string = OCBundle.message("action.invalid.title", new Object[0]);
            if (string == null) {
                OCMakePropertyDynamicQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = OCBundle.message("quickfixes.make.property.dynamic", this.myProperty.getNameWithKindLowercase(OCCompilationContext.create(this.myProperty, this.myProject)));
        if (string == null) {
            OCMakePropertyDynamicQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCGenerateIvarsActionContext context) throws IncorrectOperationException {
        if (project == null) {
            OCMakePropertyDynamicQuickFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OCMakePropertyDynamicQuickFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCMakePropertyDynamicQuickFix.$$$reportNull$$$0(4);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement decl = this.myImplementationSymbol.locateDefinition(project);
        if (!(decl instanceof OCImplementation) || !FileModificationService.getInstance().prepareFileForWrite(decl.getContainingFile())) {
            return;
        }
        OCImplementation implementation = (OCImplementation)decl;
        OCSynthesizePropertiesList declaration = OCElementFactory.synthesizeList("@dynamic", this.myProperty.getName(), null, (PsiElement)file);
        OCInstanceVariablesList ivars = implementation.getInstanceVariablesList();
        implementation.addBefore(declaration, ivars.getNextSibling());
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile});
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            OCMakePropertyDynamicQuickFix.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCMakePropertyDynamicQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCMakePropertyDynamicQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

