/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCAutoReleasePoolStatement;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCMigrateToARCIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    public OCMigrateToARCIntentionAction(@NotNull OCSendMessageExpression expr) {
        if (expr == null) {
            OCMigrateToARCIntentionAction.$$$reportNull$$$0(0);
        }
        super(expr);
    }

    public OCMigrateToARCIntentionAction(@NotNull OCReferenceElement referenceElement) {
        if (referenceElement == null) {
            OCMigrateToARCIntentionAction.$$$reportNull$$$0(1);
        }
        super(referenceElement);
    }

    public OCMigrateToARCIntentionAction(@NotNull OCFile file) {
        if (file == null) {
            OCMigrateToARCIntentionAction.$$$reportNull$$$0(2);
        }
        super(file);
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.migrate.to.arc", new Object[0]);
        if (string == null) {
            OCMigrateToARCIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NlsSafe
    protected String getTextInternal() {
        PsiElement element = this.myElementPtr.getElement();
        if (element instanceof OCFile) {
            return "Migrate '" + ((OCFile)element).getName() + "' to ARC";
        }
        return "Migrate statement to ARC";
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            OCMigrateToARCIntentionAction.$$$reportNull$$$0(4);
        }
        return OCCompilerFeaturesHelper.isArcEnabled(element.getContainingFile());
    }

    @Override
    public void invoke(PsiFile file, @NotNull PsiElement element) throws IncorrectOperationException {
        OCDeclarationStatement statement;
        if (element == null) {
            OCMigrateToARCIntentionAction.$$$reportNull$$$0(5);
        }
        final ArrayList<OCSendMessageExpression> exprs = new ArrayList<OCSendMessageExpression>();
        final ArrayList<OCDeclarationStatement> poolDeclarations = new ArrayList<OCDeclarationStatement>();
        ArrayList<List<PsiElement>> poolStatements = new ArrayList<List<PsiElement>>();
        if (element instanceof OCFile) {
            element.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitSendMessageExpression(OCSendMessageExpression expr) {
                    super.visitSendMessageExpression(expr);
                    exprs.add(expr);
                }

                @Override
                public void visitDeclarationStatement(OCDeclarationStatement stmt) {
                    super.visitDeclarationStatement(stmt);
                    if (stmt.getDeclaration().getType().getName().equals("NSAutoreleasePool")) {
                        poolDeclarations.add(stmt);
                    }
                }
            });
        } else if (element instanceof OCSendMessageExpression) {
            exprs.add((OCSendMessageExpression)element);
        } else if (element instanceof OCReferenceElement && (statement = (OCDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarationStatement.class)) != null && statement.getDeclaration().getType().getName().equals("NSAutoreleasePool")) {
            poolDeclarations.add(statement);
        }
        OCMigrateToARCIntentionAction.collectPoolStatements(poolDeclarations, poolStatements);
        OCMigrateToARCIntentionAction.handleMethods(exprs);
        OCMigrateToARCIntentionAction.handleAutoreleasePools(poolStatements);
    }

    private static void handleAutoreleasePools(List<List<PsiElement>> poolStatements) {
        for (List<PsiElement> statements : poolStatements) {
            PsiElement firstStatement = statements.get(0);
            OCAutoReleasePoolStatement pool = (OCAutoReleasePoolStatement)OCElementFactory.statementFromText("@autoreleasepool{}", firstStatement);
            for (PsiElement statement : statements) {
                if (!statement.isValid() || statement == firstStatement) continue;
                OCChangeUtil.add(pool.getBody(), statement);
            }
            for (PsiElement statement : statements) {
                if (!statement.isValid() || statement == firstStatement) continue;
                OCChangeUtil.delete(statement);
            }
            OCChangeUtil.replaceHandlingMacros(firstStatement, pool);
        }
    }

    private static void collectPoolStatements(List<OCDeclarationStatement> poolDeclarations, List<List<PsiElement>> poolStatements) {
        block0: for (OCDeclarationStatement declaration : poolDeclarations) {
            PsiElement next;
            if (!declaration.isValid()) continue;
            HashSet<String> vars = new HashSet<String>();
            for (OCDeclarator declarator : declaration.getDeclaration().getDeclarators()) {
                vars.add(declarator.getName());
            }
            PsiElement lastUsage = null;
            for (next = declaration.getNextSibling(); next != null; next = next.getNextSibling()) {
                if (!OCMigrateToARCIntentionAction.isPoolUsage(vars, next)) continue;
                lastUsage = next;
            }
            if (lastUsage == null) continue;
            OCDeclarationStatement statement = declaration;
            ArrayList<OCDeclarationStatement> curPoolStatements = new ArrayList<OCDeclarationStatement>();
            poolStatements.add(curPoolStatements);
            while (statement != null) {
                next = statement.getNextSibling();
                if (OCMigrateToARCIntentionAction.isPoolUsage(vars, statement)) {
                    OCChangeUtil.delete(statement);
                } else {
                    curPoolStatements.add(statement);
                }
                if (statement == lastUsage) continue block0;
                statement = next;
            }
        }
    }

    private static boolean isPoolUsage(Set<String> vars, PsiElement next) {
        OCExpression receiver;
        OCExpression expression;
        return next instanceof OCExpressionStatement && (expression = ((OCExpressionStatement)next).getExpression()) instanceof OCSendMessageExpression && (receiver = ((OCSendMessageExpression)expression).getReceiverExpression()) instanceof OCReferenceExpression && vars.contains(receiver.getText());
    }

    private static void handleMethods(List<OCSendMessageExpression> exprs) {
        ArrayList<OCMethod> deallocMethods = new ArrayList<OCMethod>();
        for (OCSendMessageExpression expr : exprs) {
            OCExpression receiver;
            List<OCMethodSymbol> responders;
            if (!expr.isValid() || (responders = expr.getProbableResponders().getAllResponders()).isEmpty()) continue;
            OCMethodSymbol method = responders.get(0);
            if ("dealloc".equals(method.getName())) {
                OCMethod parentMethod = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, OCMethod.class);
                if (parentMethod != null && parentMethod.getSelector().equals("dealloc")) {
                    deallocMethods.add(parentMethod);
                }
            } else if (!method.isForbiddenByARC(expr)) continue;
            if ((receiver = expr.getReceiverExpression()) == null) continue;
            if (receiver instanceof OCReferenceExpression && expr.getParent() instanceof OCExpressionStatement) {
                OCChangeUtil.delete(expr.getParent());
                continue;
            }
            OCChangeUtil.replaceHandlingMacros(expr, receiver);
        }
        for (OCMethod deallocMethod : deallocMethods) {
            OCBlockStatement body = deallocMethod.getBody();
            if (body == null || !body.getStatements().isEmpty()) continue;
            OCChangeUtil.delete(deallocMethod);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCMigrateToARCIntentionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCMigrateToARCIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

