/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCConstructorInEmptyInitializationUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCExternalReferenceUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDotCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCPropertyAttributeUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.search.FileNameWithoutExtensionIndex;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchHelper;
import com.jetbrains.cidr.lang.search.constructors.OCBaseConstructorReference;
import com.jetbrains.cidr.lang.search.constructors.OCConstructorImplicitReferenceSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchUtil {
    private static final Map<String, Integer> EXTENSION_ORDER = new HashMap<String, Integer>();

    @NotNull
    public static Collection<VirtualFile> getProjectVirtualFilesByName(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            OCSearchUtil.$$$reportNull$$$0(1);
        }
        Collection collection = FilenameIndex.getVirtualFilesByName((Project)project, (String)name, (boolean)SystemInfo.isFileSystemCaseSensitive, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        if (collection == null) {
            OCSearchUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static List<OCFile> getProjectOCFilesByName(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            OCSearchUtil.$$$reportNull$$$0(4);
        }
        return OCSearchUtil.getOCFilesByName(project, name, GlobalSearchScope.projectScope((Project)project));
    }

    @NotNull
    public static List<OCFile> getOCFilesByName(@NotNull Project project, @NotNull String name, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(5);
        }
        if (name == null) {
            OCSearchUtil.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            OCSearchUtil.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.filter((Object[])FilenameIndex.getFilesByName((Project)project, (String)name, (GlobalSearchScope)scope), (Condition)new FilteringIterator.InstanceOf(OCFile.class));
        if (list == null) {
            OCSearchUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public static VirtualFile getAssociatedFileWithSameName(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            OCSearchUtil.$$$reportNull$$$0(10);
        }
        ArrayList filesWithScores = new ArrayList();
        OCSearchUtil.processAssociatedFilesWithSameName(project, virtualFile, (Processor<? super VirtualFile>)((Processor)file -> {
            int score;
            Integer order = EXTENSION_ORDER.get(OCSearchUtil.getLowerCaseExtension(file));
            int n = score = order == null ? 0 : order;
            if (Comparing.equal((Object)virtualFile.getParent(), (Object)file.getParent())) {
                score += 1000;
            } else if (OCSearchHelper.areFromSameProject(project, virtualFile, file)) {
                score += 500;
            }
            filesWithScores.add(Pair.create((Object)file, (Object)score));
            return true;
        }));
        if (filesWithScores.isEmpty()) {
            return null;
        }
        return (VirtualFile)((Pair)Collections.max(filesWithScores, (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$getAssociatedFileWithSameName$1(com.intellij.openapi.util.Pair com.intellij.openapi.util.Pair ), (Lcom/intellij/openapi/util/Pair;Lcom/intellij/openapi/util/Pair;)I)())).first;
    }

    public static void processAssociatedFilesWithSameName(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Processor<? super VirtualFile> processor) {
        HashSet associatedExts;
        String name;
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(11);
        }
        if (virtualFile == null) {
            OCSearchUtil.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            OCSearchUtil.$$$reportNull$$$0(13);
        }
        if (OCFileTypeHelpers.isHeaderFile((String)(name = virtualFile.getName()))) {
            associatedExts = new HashSet(OCFileTypeHelpers.sourceExtensions());
        } else if (OCFileTypeHelpers.isSourceFile((String)name)) {
            associatedExts = new HashSet(OCFileTypeHelpers.headerExtensions());
            associatedExts.remove("pch");
        } else {
            return;
        }
        String nameNoExtension = FileUtilRt.getNameWithoutExtension((String)name);
        FileBasedIndex.ValueProcessor extensionFilter = (file, value) -> {
            if (!file.isDirectory() && associatedExts.contains(OCSearchUtil.getLowerCaseExtension(file))) {
                return processor.process((Object)file);
            }
            return true;
        };
        FileNameWithoutExtensionIndex.processFiles(nameNoExtension, virtualFile.isCaseSensitive(), (FileBasedIndex.ValueProcessor<Void>)extensionFilter, GlobalSearchScope.projectScope((Project)project));
    }

    @NotNull
    private static String getLowerCaseExtension(@NotNull VirtualFile file) {
        if (file == null) {
            OCSearchUtil.$$$reportNull$$$0(14);
        }
        String string = StringUtil.toLowerCase((String)FileUtilRt.getExtension((String)file.getName()));
        if (string == null) {
            OCSearchUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(@Nullable T member, @NotNull Processor<? super T> processor, boolean searchAncestors, boolean searchInheritors, @NotNull Project project) {
        if (processor == null) {
            OCSearchUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(17);
        }
        return OCSearchUtil.processMembersHierarchy(member, processor, searchAncestors, searchInheritors, true, project);
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(@Nullable T member, @NotNull Processor<? super T> processor, boolean searchAncestors, boolean searchInheritors, boolean includeSameSymbols, Project project) {
        if (processor == null) {
            OCSearchUtil.$$$reportNull$$$0(18);
        }
        if (member instanceof OCFunctionSymbol) {
            OCFile file = member.getContainingOCFile(project);
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)member;
            if (searchInheritors && file != null) {
                OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters(functionSymbol, file, true);
                parameters.setIncludeSameSymbols(includeSameSymbols);
                parameters.setIncludeFriendsInResults(functionSymbol.isFriend());
                if (!OCFunctionInheritorsSearch.search(parameters).forEach(processor)) {
                    return false;
                }
            }
            if (searchAncestors && !new OCFunctionAncestorsQuery(functionSymbol, true, includeSameSymbols, project).forEach(processor)) {
                return false;
            }
        }
        if (member instanceof OCMemberSymbol) {
            OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)member, project);
            parameters.setIncludeSelfImplementation(includeSameSymbols);
            parameters.setInheritors(searchInheritors);
            parameters.setAncestors(searchAncestors);
            if (!OCMemberInheritorsSearch.search(parameters).forEach(processor)) {
                return false;
            }
        }
        return true;
    }

    public static boolean processMembersHierarchyPsi(@Nullable OCSymbolWithParent member, @NotNull Processor<? super PsiElement> processor, boolean searchAncestors, boolean searchInheritors, @NotNull Project project) {
        if (processor == null) {
            OCSearchUtil.$$$reportNull$$$0(19);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(20);
        }
        return OCSearchUtil.processMembersHierarchy(member, symbol -> {
            PsiElement overridingMethod = symbol.locateDefinition(project);
            if (overridingMethod instanceof OCDeclarator) {
                overridingMethod = overridingMethod.getParent();
            }
            if (overridingMethod != null) {
                return processor.process((Object)overridingMethod);
            }
            return true;
        }, searchAncestors, searchInheritors, project);
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> _")
    public static Ancestor findSomeAncestor(@Nullable OCSymbolWithParent member, @NotNull Project project) {
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(21);
        }
        AncestorBuilder result = new AncestorBuilder();
        OCSearchUtil.processMembersHierarchy(member, symbol -> {
            result.symbol = symbol;
            if (!OCSearchScope.isInProjectSources(symbol, project)) {
                result.isOutOfProject = true;
                return false;
            }
            return true;
        }, true, false, false, project);
        return result.getAncestor();
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> _")
    public static Ancestor findSomeInProjectAncestor(@Nullable OCSymbolWithParent member, @NotNull Project project) {
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(22);
        }
        AncestorBuilder result = new AncestorBuilder();
        OCSearchUtil.processMembersHierarchy(member, symbol -> {
            if (OCSearchScope.isInProjectSources(symbol, project)) {
                result.symbol = symbol;
                return false;
            }
            return true;
        }, true, false, false, project);
        return result.getAncestor();
    }

    public static boolean processMemberAncestors(@Nullable OCSymbolWithParent member, @NotNull Processor<? super OCSymbolWithParent> processor, boolean onlyDeclarations, @NotNull Project project) {
        if (processor == null) {
            OCSearchUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(24);
        }
        return OCSearchUtil.processMembersHierarchy(member, ancestor -> {
            if (onlyDeclarations && ancestor.isDefinition() && OCSearchUtil.getFirstPredeclaration(ancestor, project) != null || ancestor.equals(member)) {
                return true;
            }
            return processor.process(ancestor);
        }, true, false, true, project);
    }

    public static boolean findAllMemberUsages(@Nullable OCSymbolWithParent member, @NotNull Set<? super UsageInfo> result, boolean searchInheritors, boolean searchAncestors, @NotNull Project project) {
        if (result == null) {
            OCSearchUtil.$$$reportNull$$$0(25);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(26);
        }
        return OCSearchUtil.processMembersHierarchyPsi(member, (Processor<? super PsiElement>)((Processor)element -> {
            OCSearchUtil.findOneMethodUsages(element, result);
            return true;
        }), searchAncestors, searchInheritors, project);
    }

    public static void findOneMethodUsages(@NotNull PsiElement method, @NotNull Set<? super UsageInfo> result) {
        if (method == null) {
            OCSearchUtil.$$$reportNull$$$0(27);
        }
        if (result == null) {
            OCSearchUtil.$$$reportNull$$$0(28);
        }
        GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(method.getProject());
        if (method instanceof OCFunctionDeclaration) {
            OCDeclarator declarator = ((OCFunctionDeclaration)method).getDeclarator();
            if (declarator != null) {
                for (PsiReference ref : ReferencesSearch.search((PsiElement)declarator, (SearchScope)scope).findAll()) {
                    if (ref.getElement() == null || !OCLanguageUtils.getSlowLanguage().equals(ref.getElement().getLanguage())) continue;
                    result.add(new OCFunctionUsage(ref));
                }
                ArrayList<OCConstructorInEmptyInitializationUsage> ctorUsages = new ArrayList<OCConstructorInEmptyInitializationUsage>();
                for (PsiReference ref : OCConstructorImplicitReferenceSearch.search(declarator, (SearchScope)scope)) {
                    ctorUsages.add(new OCConstructorInEmptyInitializationUsage((OCBaseConstructorReference)ref));
                }
                ctorUsages.sort(Comparator.comparing(u -> u.getCtorReference().getField().getTextOffset()));
                result.addAll(ctorUsages);
            }
        } else if (method instanceof OCMethod) {
            Processor consumer = psiReference -> {
                if (psiReference instanceof OCExternalReference) {
                    result.add(new OCExternalReferenceUsage((OCExternalReference)psiReference));
                    return true;
                }
                PsiElement element = psiReference.getElement();
                if (element instanceof OCSendMessageExpression) {
                    result.add(new OCMethodCallUsage((PsiReference)psiReference));
                } else if (element instanceof OCSelectorExpression) {
                    result.add(new OCSelectorExpressionUsage((PsiReference)psiReference));
                } else if (element instanceof OCPropertyAttribute) {
                    result.add(new OCPropertyAttributeUsage((PsiReference)psiReference));
                } else if (element instanceof OCQualifiedExpression) {
                    result.add(new OCMethodDotCallUsage((PsiReference)psiReference));
                }
                return true;
            };
            ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)false).forEach(consumer);
        }
    }

    public static boolean hasRelatedSymbols(@NotNull OCStructSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(29);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(30);
        }
        Ref result = Ref.create((Object)false);
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (s instanceof OCStructSymbol && !s.isPredeclaration() && !symbol.equals(s)) {
                result.set((Object)true);
                return false;
            }
            return true;
        }), project);
        return (Boolean)result.get();
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(31);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(32);
        }
        return OCSearchUtil.getRelatedSymbols(symbol, false, project);
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol, boolean excludeProcessingSymbol, @NotNull Project project) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(33);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(34);
        }
        ArrayList<OCSymbol> result = new ArrayList<OCSymbol>();
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (excludeProcessingSymbol && symbol.equals(s)) {
                return true;
            }
            if (s instanceof OCStructSymbol && !s.isPredeclaration()) {
                if (((OCStructSymbol)s).isSpecialization()) {
                    if (!s.isPredeclaration()) {
                        result.add((OCSymbol)s);
                    }
                } else {
                    result.add(0, (OCSymbol)s);
                }
            }
            return true;
        }), project);
        ArrayList<OCSymbol> arrayList = result;
        if (arrayList == null) {
            OCSearchUtil.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    public static boolean processPredeclarations(@NotNull OCSymbol symbol, @NotNull Processor<? super OCSymbol> processor, @NotNull Project project) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(36);
        }
        if (processor == null) {
            OCSearchUtil.$$$reportNull$$$0(37);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(38);
        }
        return symbol.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(s -> s.isPredeclaration(), processor), project);
    }

    @Nullable
    public static OCSymbol getFirstPredeclaration(@NotNull OCSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(39);
        }
        if (project == null) {
            OCSearchUtil.$$$reportNull$$$0(40);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCSearchUtil.processPredeclarations(symbol, (Processor<? super OCSymbol>)finder, project);
        return (OCSymbol)finder.getFoundValue();
    }

    private static /* synthetic */ int lambda$getAssociatedFileWithSameName$1(Pair o1, Pair o2) {
        return Comparing.compare((Comparable)((Integer)o1.second), (Comparable)((Integer)o2.second));
    }

    static {
        ArrayList extensions = new ArrayList(OCFileTypeHelpers.sourceExtensions());
        extensions.addAll(OCFileTypeHelpers.headerExtensions());
        Collections.sort(extensions);
        int size = extensions.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String e = (String)extensions.get(i2);
            EXTENSION_ORDER.put(e, size - i2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/OCSearchUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 23: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/OCSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectVirtualFilesByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOCFilesByName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowerCaseExtension";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectVirtualFilesByName";
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 35: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectOCFilesByName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOCFilesByName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedFileWithSameName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAssociatedFilesWithSameName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLowerCaseExtension";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processMembersHierarchy";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processMembersHierarchyPsi";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findSomeAncestor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findSomeInProjectAncestor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processMemberAncestors";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findAllMemberUsages";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findOneMethodUsages";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasRelatedSymbols";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedSymbols";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processPredeclarations";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPredeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 15: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AncestorBuilder {
        @Nullable
        private OCSymbolWithParent symbol;
        private boolean isOutOfProject;

        private AncestorBuilder() {
        }

        @Nullable
        private Ancestor getAncestor() {
            return this.symbol != null ? new Ancestor(this.symbol, this.isOutOfProject) : null;
        }
    }

    public static final class Ancestor {
        @NotNull
        private final OCSymbolWithParent symbol;
        private final boolean isOutOfProject;

        private Ancestor(@NotNull OCSymbolWithParent symbol, boolean isOutOfProject) {
            if (symbol == null) {
                Ancestor.$$$reportNull$$$0(0);
            }
            this.symbol = symbol;
            this.isOutOfProject = isOutOfProject;
        }

        @NotNull
        public OCSymbolWithParent getSymbol() {
            OCSymbolWithParent oCSymbolWithParent = this.symbol;
            if (oCSymbolWithParent == null) {
                Ancestor.$$$reportNull$$$0(1);
            }
            return oCSymbolWithParent;
        }

        public boolean isOutOfProject() {
            return this.isOutOfProject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/search/OCSearchUtil$Ancestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/search/OCSearchUtil$Ancestor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

