/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCResolveContext
extends UserDataHolderBase
implements OCCompilationContext {
    public static final Key<Boolean> FAIL_ON_RESOLVE_CYCLE = Key.create((String)"FAIL_ON_RESOLVE_CYCLE");
    @Nullable
    private final PsiElement myElement;
    @Nullable
    private final Project myProject;
    @NotNull
    private final OCTypeSubstitution mySubstitution;
    @NotNull
    private final Set<Pair<OCSymbolReference, OCTypeSubstitution>> myResolving;
    private final HashMap<OCFunctionSymbol, OCStructSymbol> myOperatorParentsCache;
    private final Set<OCTypeResolveVisitor.TypeKey> myResolvingTypes;
    private final OCExpressionEvaluator.ValueEvaluator myEvaluator;
    private Map<OCType, OCType> myAutoParamsTypeMapping;
    private Map<OCDeclaratorSymbol, OCTypeParameterValueSymbol> myAutoParamsValueMapping;
    @Nullable
    private OCResolveContext myOriginalContext;
    private int myDepth;
    private Ref<Integer> myTypeResolveCounter;
    private final Stack<OCFunctionSymbol> myOuterFunctions;
    private Set<OCTypeParameterSymbol> myTypeDependencies;
    private boolean myProcessNonImported;
    private boolean myOriginallyProcessNonImported;
    private boolean myDontExpandVariadics;
    private boolean isVariadicExpansionMode;
    private boolean myDontUseSymbolContextsInDepends;
    private boolean myInSFINAE;
    private boolean myIncompleteMode;
    private boolean myUseSecondCache;
    private int myTemplateSubstitutionsCnt;
    private boolean myMsvcExtensionsCapable;

    @Deprecated
    @NotNull
    public static OCResolveContext empty(@NotNull Project project) {
        if (project == null) {
            OCResolveContext.$$$reportNull$$$0(0);
        }
        return new OCResolveContext(null, project);
    }

    @NotNull
    public static OCResolveContext forSymbol(@NotNull OCSymbol symbol, @NotNull Project project) {
        if (symbol == null) {
            OCResolveContext.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OCResolveContext.$$$reportNull$$$0(2);
        }
        return new OCResolveContext((PsiElement)symbol.getContainingPsiFile(project), project);
    }

    @NotNull
    public static OCResolveContext forPsi(@NotNull PsiElement element) {
        Project project;
        if (element == null) {
            OCResolveContext.$$$reportNull$$$0(3);
        }
        try {
            project = element.getProject();
        }
        catch (PsiInvalidElementAccessException e) {
            project = null;
        }
        return new OCResolveContext(OCPsiFile.tryGetElementFromOCFile(element), project);
    }

    @Deprecated
    @NotNull
    public static OCResolveContext forNullablePsi(@Nullable PsiElement element, @NotNull Project project) {
        if (project == null) {
            OCResolveContext.$$$reportNull$$$0(4);
        }
        return new OCResolveContext(OCPsiFile.tryGetElementFromOCFile(element), project);
    }

    private OCResolveContext(@NotNull OCResolveContext origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            OCResolveContext.$$$reportNull$$$0(5);
        }
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(6);
        }
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myOuterFunctions = new Stack();
        this.myUseSecondCache = true;
        this.myMsvcExtensionsCapable = true;
        this.myProject = origin.myProject;
        this.myOriginalContext = origin;
        this.myDepth = origin.myDepth + 1;
        this.myElement = origin.myElement;
        this.mySubstitution = substitution;
        this.myResolving = origin.myResolving;
        this.myResolvingTypes = origin.myResolvingTypes;
        this.myOperatorParentsCache = origin.myOperatorParentsCache;
        this.myTypeResolveCounter = origin.myTypeResolveCounter;
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = origin.myEvaluator;
        this.myIncompleteMode = origin.myIncompleteMode;
        this.myMsvcExtensionsCapable = origin.myMsvcExtensionsCapable;
    }

    private OCResolveContext(@Nullable PsiElement element, @Nullable Project project) {
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myOuterFunctions = new Stack();
        this.myUseSecondCache = true;
        this.myMsvcExtensionsCapable = true;
        this.myProject = project;
        this.myElement = element;
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = new THashSet();
        this.myOperatorParentsCache = new HashMap();
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = new OCExpressionEvaluator.ValueEvaluator(this);
    }

    @Deprecated
    @NotNull
    public static OCResolveContext emptyContextWithoutProject() {
        return new OCResolveContext();
    }

    @Deprecated
    private OCResolveContext() {
        this.myTypeResolveCounter = Ref.create((Object)0);
        this.myOuterFunctions = new Stack();
        this.myUseSecondCache = true;
        this.myMsvcExtensionsCapable = true;
        this.myProject = null;
        this.myElement = null;
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = new THashSet();
        this.myOperatorParentsCache = new HashMap();
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = new OCExpressionEvaluator.ValueEvaluator(this);
    }

    public String toString() {
        Object element;
        if (this.myElement instanceof PsiFile) {
            PsiFile file = (PsiFile)this.myElement;
            element = "file " + file.getName();
        } else {
            element = this.myElement != null ? "element " + this.myElement.getClass().getSimpleName() + ": " + this.myElement.getText() : (this.myProject != null ? "project " + this.myProject.getName() : "<null (deprecated)>");
        }
        return "OCResolveContext(" + (String)element + ")";
    }

    public List<OCSymbol> doResolveToSymbols(OCSymbolReference reference, boolean onlyTypes, boolean resolveSpecializations) {
        Pair pair = Pair.create((Object)reference, (Object)this.mySubstitution.getMinimalDependentSubstitution(reference, this));
        if (this.myResolving.contains(pair)) {
            if (this.getProject().getUserData(FAIL_ON_RESOLVE_CYCLE) == Boolean.TRUE) {
                throw new RuntimeException("Cycle in resolve, use \"//Allow resolve cycle\" in tests to suppress this assertion");
            }
            return Collections.emptyList();
        }
        try (CidrEventSpan ignored = new CidrEventSpan("resolve", ((OCSymbolReference)pair.first).toString(), pair.second);){
            this.myResolving.add((Pair<OCSymbolReference, OCTypeSubstitution>)pair);
            List<OCSymbol> result = reference.resolveToSymbols(this, onlyTypes, resolveSpecializations);
            this.myResolving.remove(pair);
            List<OCSymbol> list = result;
            return list;
        }
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference) {
        return this.resolveToSymbols(reference, false, false);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean onlyTypes) {
        return this.resolveToSymbols(reference, processTypedefs, true, onlyTypes);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean processTypeParameters, boolean onlyTypes) {
        List<OCSymbol> symbols = this.doResolveToSymbols(reference, onlyTypes, true);
        return OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, this, symbols, reference, processTypeParameters, true);
    }

    public Set<OCTypeResolveVisitor.TypeKey> getResolvingTypes() {
        return this.myResolvingTypes;
    }

    public Set<OCQualifiedName> getResolvingTypeNames() {
        return this.myResolvingTypes.stream().map(OCTypeResolveVisitor.TypeKey::getTypeName).collect(Collectors.toSet());
    }

    @Nullable
    public OCStructSymbol getNonMemberOperatorParent(OCSymbol operator) {
        if (operator instanceof OCFunctionSymbol) {
            OCFunctionSymbol function = (OCFunctionSymbol)operator;
            List<OCDeclaratorSymbol> params = function.getParameterSymbols();
            if (function.isCppNonMemberOperator(this)) {
                if (this.myOperatorParentsCache.containsKey(function)) {
                    return this.myOperatorParentsCache.get(function);
                }
                OCStructSymbol result = null;
                boolean wasUnknown = false;
                this.myOperatorParentsCache.put(function, null);
                for (int i2 = 0; i2 < params.size(); ++i2) {
                    OCDeclaratorSymbol parameter = operator.getName().equals("operator<<") ? params.get(params.size() - i2 - 1) : params.get(i2);
                    OCType paramType = parameter.getType().resolve(this).getTerminalType();
                    if (paramType instanceof OCStructType) {
                        result = ((OCStructType)paramType).getSymbol();
                        break;
                    }
                    if (!(paramType instanceof OCUnknownType)) continue;
                    wasUnknown = true;
                }
                if (result == null && wasUnknown) {
                    this.myOperatorParentsCache.remove(function);
                } else {
                    this.myOperatorParentsCache.put(function, result);
                }
                return result;
            }
        }
        return null;
    }

    @Nullable
    public PsiFile getFile() {
        return OCElementUtil.getContainingFileSkippingFragments(this.myElement);
    }

    @Deprecated
    @Nullable
    public PsiElement getElement() {
        return this.myElement != null && this.myElement.isValid() ? this.myElement : null;
    }

    @Deprecated
    @Nullable
    public Project getProjectOrNull() {
        return this.myProject;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            OCResolveContext.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCResolveContext.$$$reportNull$$$0(8);
        }
        return oCTypeSubstitution;
    }

    @Nullable
    public OCResolveContext getOriginalContext() {
        return this.myOriginalContext;
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(9);
        }
        OCResolveContext oCResolveContext = this.substitute(substitution, false, false);
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(10);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution, boolean overwriteSubstitution, boolean createIfID) {
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(11);
        }
        if (substitution != OCTypeSubstitution.ID || createIfID) {
            OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.compose(this.mySubstitution, substitution, overwriteSubstitution));
            result.setProcessNonImported(this.myProcessNonImported);
            OCResolveContext oCResolveContext = result;
            if (oCResolveContext == null) {
                OCResolveContext.$$$reportNull$$$0(12);
            }
            return oCResolveContext;
        }
        OCResolveContext oCResolveContext = this;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(13);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext substituteFirst(@NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(14);
        }
        if (substitution != OCTypeSubstitution.ID) {
            OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.compose(substitution, this.mySubstitution, false));
            result.setProcessNonImported(this.myProcessNonImported);
            OCResolveContext oCResolveContext = result;
            if (oCResolveContext == null) {
                OCResolveContext.$$$reportNull$$$0(15);
            }
            return oCResolveContext;
        }
        OCResolveContext oCResolveContext = this;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(16);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCResolveContext.$$$reportNull$$$0(17);
        }
        OCTypeSubstitution substitution = this.mySubstitution.getMinimalDependentSubstitution(symbol, this);
        substitution = symbol instanceof OCSymbolWithSubstitution ? OCTypeSubstitution.compose(substitution, ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution(), false) : substitution;
        OCResolveContext result = new OCResolveContext(this, substitution);
        result.setProcessNonImported(this.myProcessNonImported);
        OCResolveContext oCResolveContext = result;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(18);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCTypeArgument argument, @NotNull OCTypeSubstitution substitution) {
        if (argument == null) {
            OCResolveContext.$$$reportNull$$$0(19);
        }
        if (substitution == null) {
            OCResolveContext.$$$reportNull$$$0(20);
        }
        substitution = OCTypeSubstitution.compose(this.mySubstitution, substitution, false).getMinimalDependentSubstitution(argument, this);
        OCResolveContext result = new OCResolveContext(this, substitution);
        result.setProcessNonImported(this.myProcessNonImported);
        OCResolveContext oCResolveContext = result;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(21);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext clearSubstitution() {
        OCResolveContext result = new OCResolveContext(this, OCTypeSubstitution.ID);
        result.setProcessNonImported(this.myProcessNonImported);
        OCResolveContext oCResolveContext = result;
        if (oCResolveContext == null) {
            OCResolveContext.$$$reportNull$$$0(22);
        }
        return oCResolveContext;
    }

    @NotNull
    public OCResolveContext clone() {
        return new OCResolveContext(this, this.mySubstitution);
    }

    public int getNestingDepth() {
        return this.myDepth;
    }

    public OCExpressionEvaluator.ValueEvaluator getEvaluator() {
        return new OCExpressionEvaluator.ValueEvaluator(this.myEvaluator, this);
    }

    public boolean isProcessNonImported() {
        return this.myProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isProcessNonImported();
    }

    public boolean isInSFINAE() {
        return this.myInSFINAE || this.myOriginalContext != null && this.myOriginalContext.isInSFINAE();
    }

    public boolean isOriginallyProcessNonImported() {
        return this.myOriginallyProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isOriginallyProcessNonImported();
    }

    public boolean isDontExpandVariadics() {
        return this.myDontExpandVariadics || this.myOriginalContext != null && this.myOriginalContext.isDontExpandVariadics();
    }

    public void setDontExpandVariadics(boolean dontExpandVariadics) {
        this.myDontExpandVariadics = dontExpandVariadics;
    }

    public boolean isVariadicExpansionMode() {
        return this.isVariadicExpansionMode;
    }

    public void setVariadicExpansionMode(boolean variadicExpansionMode) {
        this.isVariadicExpansionMode = variadicExpansionMode;
    }

    public boolean isMsvcExtensionsCapable() {
        return this.myMsvcExtensionsCapable;
    }

    public void setMsvcExtensionsCapable(boolean msvcExtensionsCapable) {
        this.myMsvcExtensionsCapable = msvcExtensionsCapable;
    }

    public void addTypeDependency(@NotNull OCTypeParameterSymbol dependency) {
        if (dependency == null) {
            OCResolveContext.$$$reportNull$$$0(23);
        }
        this.myTypeDependencies.add(dependency);
    }

    public void addTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        if (typeDependencies == null) {
            OCResolveContext.$$$reportNull$$$0(24);
        }
        this.myTypeDependencies.addAll(typeDependencies);
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies() {
        return new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies(@Nullable OCType extraDependenciesSource) {
        final HashSet<OCTypeParameterSymbol> dependencies2 = new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
        if (extraDependenciesSource != null) {
            extraDependenciesSource.accept(new OCBooleanTypeVisitor(){

                @Override
                public Boolean visitTypeParameterType(OCTypeParameterType type) {
                    dependencies2.add(type.getSymbol());
                    return true;
                }
            });
        }
        HashSet<OCTypeParameterSymbol> hashSet = dependencies2;
        if (hashSet == null) {
            OCResolveContext.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    public void setTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        if (typeDependencies == null) {
            OCResolveContext.$$$reportNull$$$0(26);
        }
        this.myTypeDependencies = typeDependencies;
    }

    public void clearTypeDependencies() {
        this.myTypeDependencies.clear();
    }

    public boolean wasDependentType() {
        return !this.myTypeDependencies.isEmpty() || this.myOriginalContext != null && this.myOriginalContext.wasDependentType();
    }

    public int getTypeResolveCounter() {
        return (Integer)this.myTypeResolveCounter.get();
    }

    public void incTypeResolveCounter() {
        this.myTypeResolveCounter.set((Object)((Integer)this.myTypeResolveCounter.get() + 1));
    }

    public void setProcessNonImported(boolean processNonImported) {
        this.myProcessNonImported = processNonImported;
        if (this.myProcessNonImported) {
            this.myOriginallyProcessNonImported = true;
        }
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setProcessNonImported(processNonImported);
        }
    }

    public void setInSFINAE(boolean inSFINAE) {
        this.myInSFINAE = inSFINAE;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setInSFINAE(inSFINAE);
        }
    }

    public void setIncompleteMode(boolean incompleteMode) {
        this.myIncompleteMode = incompleteMode;
    }

    public boolean isIncompleteMode() {
        return this.myIncompleteMode;
    }

    public void setDontUseSymbolContextsInDepends(boolean flag) {
        this.myDontUseSymbolContextsInDepends = flag;
    }

    public boolean dontUseSymbolContextsInDepends() {
        return this.myDontUseSymbolContextsInDepends;
    }

    public static boolean setNonImportedFlag(@NotNull OCResolveContext context, boolean value) {
        if (context == null) {
            OCResolveContext.$$$reportNull$$$0(27);
        }
        boolean result = context.isProcessNonImported();
        context.setProcessNonImported(value);
        return result;
    }

    public static boolean setInSFINAEFlag(@NotNull OCResolveContext context, boolean value) {
        if (context == null) {
            OCResolveContext.$$$reportNull$$$0(28);
        }
        boolean result = context.isInSFINAE();
        context.setInSFINAE(value);
        return result;
    }

    public OCTypeParameterType getAutoParamTypeMapping(OCAutoType type) {
        return this.myAutoParamsTypeMapping != null ? (OCTypeParameterType)this.myAutoParamsTypeMapping.get(type) : null;
    }

    public void setAutoParamsTypeMapping(Map<OCType, OCType> autoParamsTypeMapping) {
        this.myAutoParamsTypeMapping = autoParamsTypeMapping;
    }

    @Nullable
    public OCTypeParameterValueSymbol getAutoParamValueMapping(@NotNull OCDeclaratorSymbol symbol) {
        if (symbol == null) {
            OCResolveContext.$$$reportNull$$$0(29);
        }
        return this.myAutoParamsValueMapping != null ? this.myAutoParamsValueMapping.get(symbol) : null;
    }

    public void setAutoParamsValueMapping(Map<OCDeclaratorSymbol, OCTypeParameterValueSymbol> autoParamsValueMapping) {
        this.myAutoParamsValueMapping = autoParamsValueMapping;
    }

    public boolean useSecondCache() {
        return this.myUseSecondCache;
    }

    public void setUseSecondCache(boolean useSecondCache) {
        this.myUseSecondCache = useSecondCache;
    }

    public void incTemplateSubstitutionsCnt() {
        ++this.myTemplateSubstitutionsCnt;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.incTemplateSubstitutionsCnt();
        }
    }

    public int getTemplateSubstitutionsCnt() {
        return this.myTemplateSubstitutionsCnt;
    }

    @Override
    public boolean isCpp() {
        return !OCCodeInsightUtil.isInPlainOldC(this.myElement);
    }

    public boolean isObjc() {
        return OCCodeInsightUtil.isInObjC(this.myElement);
    }

    public void pushOuterFunction(@NotNull OCFunctionSymbol functionSymbol) {
        if (functionSymbol == null) {
            OCResolveContext.$$$reportNull$$$0(30);
        }
        this.myOuterFunctions.push((Object)functionSymbol);
    }

    public void popOuterFunction() {
        this.myOuterFunctions.pop();
    }

    @Nullable
    public OCFunctionSymbol peekOuterFunction() {
        return this.myOuterFunctions.isEmpty() ? null : (OCFunctionSymbol)this.myOuterFunctions.peek();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCResolveContext";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDependencies";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCResolveContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteFirst";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "useFor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "clearSubstitution";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "empty";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forSymbol";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forPsi";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forNullablePsi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "substituteFirst";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "useFor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addTypeDependency";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTypeDependencies";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setTypeDependencies";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setNonImportedFlag";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setInSFINAEFlag";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAutoParamValueMapping";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "pushOuterFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

