/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.NodeStructure;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSymbolOffsetUtil {
    private static final int BITS_SUBST_OFFSET = 32;
    private static final long MAX_SUBST_OFFSET = 0x100000000L;
    private static final long SUBST_OFFSET_MASK = 0xFFFFFFFFL;
    public static final long INVALID_OFFSET = Long.MAX_VALUE;
    public static final Comparator<OCSymbol> SYMBOL_COMPARATOR_BY_SCOPE = Comparator.comparingLong(s -> s.getScope().getStartOffset());

    public static int getOffsetInTopMacroSubstitution(PsiElement element) {
        PsiElement prevLeaf = OCElementUtil.getPrevLeaf(element);
        if (prevLeaf instanceof OCMacroForeignLeafElement) {
            return ((OCMacroForeignLeafElement)prevLeaf).getOffsetInTopSubstitution() + 1;
        }
        if (prevLeaf instanceof ForeignLeafPsiElement) {
            return OCElementUtil.isSynthetic(prevLeaf) ? 0 : OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(prevLeaf) + 1;
        }
        return 0;
    }

    public static int getTextOffsetInTopMacroSubstitution(PsiElement element) {
        if (element instanceof ForeignLeafPsiElement) {
            PsiElement prevLeaf = OCElementUtil.getPrevSiblingOrParentSibling(element);
            if (prevLeaf != null) {
                return OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(prevLeaf) + prevLeaf.getTextLength();
            }
            return 0;
        }
        return element.getTextRange().getStartOffset();
    }

    public static <T> int getOffsetInTopMacroSubstitution(NodeStructure<T> structure, T node) {
        IElementType type = structure.getTokenType(node);
        if (node instanceof OCMacroForeignLeafElement) {
            return ((OCMacroForeignLeafElement)((Object)node)).getOffsetInTopSubstitution();
        }
        if (type instanceof OCMacroForeignLeafType) {
            return ((OCMacroForeignLeafType)type).getOffsetInTopSubstitution();
        }
        return 0;
    }

    public static long getComplexOffset(int textOffset, int substOffset) {
        return (long)textOffset << 32 | (long)substOffset;
    }

    public static long getComplexOffset(@Nullable PsiElement element) {
        if (element == null) {
            return 0L;
        }
        int offsetInTopMacroSubstitution = OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(element);
        return OCSymbolOffsetUtil.getComplexOffset(OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(element), offsetInTopMacroSubstitution);
    }

    public static ComplexTextRange getComplexRange(TextRange range) {
        return new ComplexTextRange(OCSymbolOffsetUtil.getComplexOffset(range.getStartOffset(), 0), OCSymbolOffsetUtil.getComplexOffset(range.getEndOffset(), 0));
    }

    public static ComplexTextRange getComplexRange(PsiElement element) {
        int substStart = OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(element);
        int substEnd = OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(OCElementUtil.getNextSiblingOrParentSibling(element));
        long startOffset = OCSymbolOffsetUtil.getComplexOffset(OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(element), substStart);
        long endOffset = OCSymbolOffsetUtil.getComplexOffset(OCSymbolOffsetUtil.getTextOffsetInTopMacroSubstitution(element) + element.getTextLength(), substEnd);
        return new ComplexTextRange(startOffset, endOffset);
    }

    public static long getVirtualComplexOffset(PsiElement element) {
        return element instanceof OCElement ? ((OCElement)element).getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(element.getTextOffset(), 0);
    }

    public static <T> long getComplexOffset(NodeStructure<T> structure, T node) {
        int offsetInTopMacroSubstitution = OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(structure, node);
        return OCSymbolOffsetUtil.getComplexOffset(structure.getStartOffset(node), offsetInTopMacroSubstitution);
    }

    public static <T> ComplexTextRange getComplexRange(NodeStructure<T> structure, T node) {
        int offsetInTopMacroSubstitution = OCSymbolOffsetUtil.getOffsetInTopMacroSubstitution(structure, node);
        long startOffset = OCSymbolOffsetUtil.getComplexOffset(structure.getStartOffset(node), offsetInTopMacroSubstitution);
        long endOffset = OCSymbolOffsetUtil.getComplexOffset(structure.getEndOffset(node), offsetInTopMacroSubstitution);
        return new ComplexTextRange(startOffset, endOffset);
    }

    public static long shift(long offset, long shift) {
        return offset == Long.MAX_VALUE ? Long.MAX_VALUE : offset + (shift << 32);
    }

    @NotNull
    public static ComplexTextRange shift(@NotNull ComplexTextRange range, int start, int shift) {
        TextRange textRange;
        if (range == null) {
            OCSymbolOffsetUtil.$$$reportNull$$$0(0);
        }
        if ((textRange = range.simple()).getEndOffset() <= start) {
            ComplexTextRange complexTextRange = range;
            if (complexTextRange == null) {
                OCSymbolOffsetUtil.$$$reportNull$$$0(1);
            }
            return complexTextRange;
        }
        int textStart = textRange.getStartOffset();
        if (textStart >= start) {
            textStart += shift;
        }
        int textEnd = textRange.getEndOffset() + shift;
        TextRange subst = range.subst();
        return new ComplexTextRange(OCSymbolOffsetUtil.getComplexOffset(textStart, subst.getStartOffset()), OCSymbolOffsetUtil.getComplexOffset(textEnd, subst.getEndOffset()));
    }

    public static int getTextOffset(long complexOffset) {
        return complexOffset == Long.MAX_VALUE ? 0 : (int)(complexOffset >> 32);
    }

    public static int getSubstOffset(long complexOffset) {
        return (int)(complexOffset & 0xFFFFFFFFL);
    }

    public static long adjust(long baseOffset, long complexOffset) {
        int baseTextOffset = OCSymbolOffsetUtil.getTextOffset(baseOffset);
        int newTextOffset = OCSymbolOffsetUtil.getTextOffset(complexOffset);
        int newSubstOffset = OCSymbolOffsetUtil.getSubstOffset(complexOffset);
        newTextOffset = Math.max(newTextOffset, baseTextOffset);
        return OCSymbolOffsetUtil.getComplexOffset(newTextOffset, newSubstOffset);
    }

    public static <Symbol extends OCSymbol> void updateOffset(@Nullable MostlySingularMultiMap<String, Symbol> members, int start, int lengthShift) {
        if (members == null) {
            return;
        }
        members.processAllValues(symbol -> {
            symbol.updateOffset(start, lengthShift);
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCSymbolOffsetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCSymbolOffsetUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "shift";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shift";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

