/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCDelegatingSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedNameImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamespaceSymbol
extends OCSymbolWithQualifiedNameImpl
implements OCNamespaceLikeSymbol {
    @Nullable
    private MostlySingularMultiMap<String, OCSymbol> myMembers;
    @Nullable
    private List<OCSymbol> myMembersList;
    private List<OCUsingSymbol> myNamespaceUsings;
    private Collection<OCNamespaceSymbol> myInlineNamespaces;
    private boolean myInlineNamespace;
    private boolean myIsSynthetic;
    private boolean myIsQualifiedContainer;
    private long myNameOffset;

    public OCNamespaceSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCNamespaceSymbol(@Nullable VirtualFile virtualFile, long startOffset, long nameOffset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> membersMap, @Nullable List<OCUsingSymbol> namespaceUsings, boolean inlineNamespace, boolean bl, boolean bl2) {
        void isQualifiedContainer;
        void isSynthetic;
        if (name == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(1);
        }
        super(virtualFile, startOffset, parent, name, attributes, null);
        this.myMembersList = ContainerUtil.trimToSize(membersList);
        this.myMembers = membersMap;
        this.myNamespaceUsings = namespaceUsings;
        this.myInlineNamespace = inlineNamespace;
        this.myIsSynthetic = isSynthetic;
        this.myIsQualifiedContainer = isQualifiedContainer;
        this.myNameOffset = nameOffset;
    }

    /*
     * WARNING - void declaration
     */
    protected OCNamespaceSymbol(@Nullable VirtualFile virtualFile, long startOffset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name, @NotNull List<String> attributes, @Nullable List<OCSymbol> membersList, @Nullable MostlySingularMultiMap<String, OCSymbol> members, @Nullable List<OCUsingSymbol> namespaceUsings, boolean inlineNamespace, OCVisibility oCVisibility) {
        void visibility;
        if (name == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(3);
        }
        super(virtualFile, startOffset, parent, name, attributes, (OCVisibility)visibility);
        this.myMembersList = membersList;
        this.myMembers = members;
        this.myNamespaceUsings = namespaceUsings;
        this.myInlineNamespace = inlineNamespace;
        this.myIsSynthetic = false;
        this.myNameOffset = startOffset;
    }

    public long getNameOffset() {
        return this.myNameOffset;
    }

    public static OCNamespaceSymbol createGlobalNamespaceSymbol(final PsiFile file) {
        return new OCNamespaceSymbol(file.getVirtualFile(), -1L, 0L, null, OCQualifiedName.GLOBAL, Collections.emptyList(), null, null, null, false, false, false){

            @Override
            public PsiElement locateDefinition(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol$1", "locateDefinition"));
            }
        };
    }

    public boolean isGlobalNamespace() {
        return this.myComplexOffset == -1L && this.myMembers == null;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.NAMESPACE;
        if (oCSymbolKind == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(4);
        }
        return oCSymbolKind;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return this.myIsQualifiedContainer ? OCSymbolKind.STRUCT.getIcon() : super.getBaseIcon();
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    public boolean isPredefinition() {
        return this.myMembers == null;
    }

    public boolean isQualifiedContainer() {
        return this.myIsQualifiedContainer;
    }

    @Override
    public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project) {
        Icon result;
        if (project == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(5);
        }
        if ((result = super.computeFullIconNow(symbolElement, project)) == null) {
            return null;
        }
        return OCTestFrameworks.isTestNamespace(this, symbolElement, project) ? OCIcons.getTestIcon(result) : result;
    }

    @Nullable
    protected MostlySingularMultiMap<String, OCSymbol> getMembers() {
        return this.myMembers;
    }

    @Nullable
    public OCSymbol findMember(@NotNull String name) {
        if (name == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(6);
        }
        if (this.myMembers != null) {
            Iterator iterator = this.myMembers.get((Object)name).iterator();
            return iterator.hasNext() ? ((OCSymbol)iterator.next()).getDelegate() : null;
        }
        return null;
    }

    public void addMember(@NotNull OCSymbol member) {
        if (member == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(7);
        }
        if (this.myMembers != null) {
            this.myMembers.add((Object)member.getName(), (Object)member);
            this.myMembersList.add(member);
        }
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(8);
        }
        if (first == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(9);
        }
        if (second == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(10);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCNamespaceSymbol f = (OCNamespaceSymbol)first;
        OCNamespaceSymbol s = (OCNamespaceSymbol)second;
        if (f.myInlineNamespace != s.myInlineNamespace) {
            return false;
        }
        if (f.myIsSynthetic != s.myIsSynthetic) {
            return false;
        }
        if (!c.equalLists(f.myNamespaceUsings, s.myNamespaceUsings)) {
            return false;
        }
        return c.equalMultiMaps(f.myMembers, s.myMembers);
    }

    @Override
    public void updateOffset(int start, int lengthShift) {
        super.updateOffset(start, lengthShift);
        OCSymbolOffsetUtil.updateOffset(this.myMembers, start, lengthShift);
    }

    @Override
    public void compact() {
        super.compact();
        OCNamespaceSymbol.compactMembersMultiMap(this.myMembers);
    }

    public static void compactMembersMultiMap(@Nullable MostlySingularMultiMap<?, ? extends OCSymbol> members) {
        if (members == null) {
            return;
        }
        members.compact();
        members.processAllValues(member -> {
            member.compact();
            return true;
        });
    }

    @Nullable
    public List<OCSymbol> getMembersList() {
        return this.myMembersList;
    }

    @Override
    public boolean processMembers(@Nullable String memberName, @NotNull Processor<? super OCSymbol> processor) {
        if (processor == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(11);
        }
        if (this.myMembers == null) {
            return true;
        }
        if (memberName != null) {
            return this.myMembers.processForKey((Object)memberName, OCDelegatingSymbol.getDelegateProcessor(processor));
        }
        return this.myMembers.processAllValues(OCDelegatingSymbol.getDelegateProcessor(processor));
    }

    public boolean processMembers(@NotNull Processor<OCSymbol> processor, int afterOffset, int beforeOffset) {
        if (processor == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(12);
        }
        return this.myMembersList == null || OCResolveUtil.processSymbolsFromList(processor, this.myMembersList, afterOffset, beforeOffset);
    }

    public boolean processMembersAndUsings(@NotNull Processor<OCSymbol> processor, int afterOffset, int beforeOffset) {
        if (processor == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(13);
        }
        List members = ContainerUtil.notNullize(this.getMembersList());
        List usings = ContainerUtil.notNullize((List)this.getNamespaceUsings());
        return OCResolveUtil.processSymbolsFromTwoLists(processor, members, usings, afterOffset, beforeOffset);
    }

    @Nullable
    public List<OCUsingSymbol> getNamespaceUsings() {
        return this.myNamespaceUsings;
    }

    @Override
    @Nullable
    public Collection<OCNamespaceSymbol> getInlineNamespaces() {
        return this.myInlineNamespaces;
    }

    public Processor<OCSymbol> getBuilder() {
        return symbol -> {
            if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                if (this.myNamespaceUsings == null) {
                    this.myNamespaceUsings = new ArrayList<OCUsingSymbol>();
                }
                this.myNamespaceUsings.add((OCUsingSymbol)symbol);
            } else {
                if (this.myMembers == null) {
                    this.myMembers = new MostlySingularMultiMap();
                    this.myMembersList = new ArrayList<OCSymbol>();
                }
                if (symbol != this) {
                    if (symbol instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)symbol).isInlineNamespace()) {
                        if (this.myInlineNamespaces == null) {
                            this.myInlineNamespaces = new ArrayList<OCNamespaceSymbol>();
                        }
                        this.myInlineNamespaces.add((OCNamespaceSymbol)symbol);
                    }
                    this.myMembers.add((Object)symbol.getName(), symbol);
                    this.myMembersList.add(symbol.getDelegate());
                }
            }
            return true;
        };
    }

    public boolean isInlineNamespace() {
        return this.myInlineNamespace;
    }

    public boolean isSyntheticNamespace() {
        return this.myIsSynthetic;
    }

    public int getLastElementOffset() {
        OCSymbol symbol;
        OCSymbol oCSymbol = symbol = this.myMembersList != null ? (OCSymbol)ContainerUtil.getLastItem(this.myMembersList) : null;
        if (symbol instanceof OCNamespaceSymbol) {
            return ((OCNamespaceSymbol)symbol).getLastElementOffset();
        }
        if (symbol != null) {
            return symbol.getOffset();
        }
        return this.getOffset();
    }

    @Override
    @Nullable
    public PsiFile getContainingPsiFile(@NotNull Project project) {
        if (project == null) {
            OCNamespaceSymbol.$$$reportNull$$$0(14);
        }
        return super.getContainingPsiFile(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeFullIconNow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMember";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMember";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processMembersAndUsings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPsiFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

