/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCIndexingStatisticsCollector
extends CounterUsagesCollector {
    public static final EventLogGroup GROUP = new EventLogGroup("oc.symbols", 3);
    public static final EnumEventField<OCSymbolTablesBuildingActivity.Mode> MODE_FIELD = EventFields.Enum((String)"mode", OCSymbolTablesBuildingActivity.Mode.class);
    public static final LongEventField DURATION_FIELD = EventFields.Long((String)"duration_ms");
    public static final StringEventField DURATION_GROUPED_FIELD = new DurationGroupField("duration_group");
    public static final IntEventField FILES_FIELD = EventFields.Int((String)"files");
    public static final IntEventField TABLES_FIELD = EventFields.Int((String)"tables");
    public static final StringEventField TABLES_GROUPED_FIELD = new TablesGroupField("tables_group");
    public static final VarargEventId SYMBOLS_BUILT_EVENT = GROUP.registerVarargEvent("built", new EventField[]{MODE_FIELD, DURATION_FIELD, DURATION_GROUPED_FIELD, FILES_FIELD, TABLES_FIELD, TABLES_GROUPED_FIELD});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    /*
     * WARNING - void declaration
     */
    public static void logSymbolBuilt(@NotNull OCSymbolTablesBuildingActivity.Mode mode, long duration, int files, int n) {
        void tables;
        if (mode == null) {
            OCIndexingStatisticsCollector.$$$reportNull$$$0(0);
        }
        SYMBOLS_BUILT_EVENT.log(new EventPair[]{MODE_FIELD.with((Object)mode), DURATION_FIELD.with((Object)duration), DURATION_GROUPED_FIELD.with((Object)OCIndexingStatisticsCollector.toDurationGroup(duration)), FILES_FIELD.with((Object)files), TABLES_FIELD.with((Object)((int)tables)), TABLES_GROUPED_FIELD.with((Object)OCIndexingStatisticsCollector.toTablesGroup((long)tables))});
    }

    @NotNull
    private static String toDurationGroup(long milliseconds) {
        long seconds = milliseconds / 1000L;
        if (seconds < 10L) {
            return "<10s";
        }
        if (seconds < 60L) {
            String string = 10L * (seconds / 10L) + "s+";
            if (string == null) {
                OCIndexingStatisticsCollector.$$$reportNull$$$0(1);
            }
            return string;
        }
        long minutes = seconds / 60L;
        if (minutes < 5L) {
            String string = minutes + "m+";
            if (string == null) {
                OCIndexingStatisticsCollector.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (minutes < 30L) {
            String string = ">" + 5L * (minutes / 5L) + "m";
            if (string == null) {
                OCIndexingStatisticsCollector.$$$reportNull$$$0(3);
            }
            return string;
        }
        return ">30m";
    }

    @NotNull
    private static String toTablesGroup(long tables) {
        if (tables == 0L) {
            return "0";
        }
        for (Integer threshold : Arrays.asList(10000, 5000, 2000, 1000, 500, 100, 10)) {
            if (tables < (long)threshold.intValue()) continue;
            String string = threshold + "+";
            if (string == null) {
                OCIndexingStatisticsCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "<10";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCIndexingStatisticsCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCIndexingStatisticsCollector";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toDurationGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toTablesGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logSymbolBuilt";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TablesGroupField
    extends StringEventField {
        private TablesGroupField(@NotNull String name) {
            if (name == null) {
                TablesGroupField.$$$reportNull$$$0(0);
            }
            super(name);
        }

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("{regexp#integer}", "<{regexp#integer}", "{regexp#integer}+");
            if (list == null) {
                TablesGroupField.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCIndexingStatisticsCollector$TablesGroupField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCIndexingStatisticsCollector$TablesGroupField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DurationGroupField
    extends StringEventField {
        private DurationGroupField(@NotNull String name) {
            if (name == null) {
                DurationGroupField.$$$reportNull$$$0(0);
            }
            super(name);
        }

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("<{regexp#integer}s", "{regexp#integer}s+", "{regexp#integer}m+", ">{regexp#integer}m");
            if (list == null) {
                DurationGroupField.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCIndexingStatisticsCollector$DurationGroupField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCIndexingStatisticsCollector$DurationGroupField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

