/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class OCSymbolSavingActivity {
    public static Pair<Integer, Integer> build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (indicator == null) {
            OCSymbolSavingActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCSymbolSavingActivity.$$$reportNull$$$0(1);
        }
        Project project = userData.getProject();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        OCSymbolTablesBuildingActivity.Mode mode = userData.getMode();
        cache.removeJunkTables(mode == OCSymbolTablesBuildingActivity.Mode.COMPACT);
        HashSet<VirtualFile> filesWithModifiedTables = new HashSet<VirtualFile>(cache.getFilesWithChangedTables());
        indicator.checkCanceled();
        indicator.setText(OCBundle.message("saving.symbols", new Object[0]));
        indicator.startTiming("Saving symbols");
        indicator.setInterval(Objects.requireNonNull(userData.getSavingFraction()), 1.0);
        int newTableFileCount = filesWithModifiedTables.size();
        int newTableCount = OCSymbolLoadingActivity.getAllTablesCount(cache, filesWithModifiedTables);
        @NonNls String serializeDescription = newTableFileCount + " files (" + newTableCount + " tables of total " + OCSymbolLoadingActivity.getAllTablesCount(cache) + ")";
        OCLog.LOG.info("Saving modified symbols for " + serializeDescription);
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "serializeTables", (Object)serializeDescription);){
            cache.serializeTables(Objects.requireNonNull(userData.getLocationHash()), filesWithModifiedTables, (ProgressIndicator)indicator);
            indicator.logTiming();
        }
        return Pair.create((Object)newTableFileCount, (Object)newTableCount);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "userData";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolSavingActivity";
        objectArray[2] = "build";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

