/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableListMultimap;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.OCClearingSymbolsActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCDeserializeModuleMapsActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCHeaderMapLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCIndexingStatisticsCollector;
import com.jetbrains.cidr.lang.symbols.symtable.OCInitialBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.OCModuleMapBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCModuleMapSerializationActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolSavingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.OCWorkerActivity;
import com.jetbrains.cidr.lang.symbols.symtable.RecursiveSymbolBuilding;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCSymbolTablesBuildingActivity
implements Disposable {
    private static final ExtensionPointName<OCInitialBuildingActivity> EP_NAME = ExtensionPointName.create((String)"cidr.lang.initialBuildingActivity");
    @NotNull
    private final FileSymbolTablesCache myCache;
    @Nullable
    private static NotNullProducer<? extends ProgressIndicator> ourIndicatorFactory;
    @NotNull
    private static final Set<Thread> mySymbolBuildingThreads;
    @NonNls
    public static final NotNullLazyKey<List<String>, Project> ACTIVITY_LOG;
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicInteger ourRequestCount;
    @NotNull
    private final Object ourLastBuildLock;
    @Nullable
    private volatile SymbolBuildingTask ourLastBuildTask;
    private volatile int ourLastBuild;

    public static OCSymbolTablesBuildingActivity getInstance(@NotNull Project project) {
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(0);
        }
        return (OCSymbolTablesBuildingActivity)project.getService(OCSymbolTablesBuildingActivity.class);
    }

    public OCSymbolTablesBuildingActivity(@NotNull Project project) {
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(1);
        }
        this.ourRequestCount = new AtomicInteger();
        this.ourLastBuildLock = new Object();
        this.project = project;
        this.myCache = FileSymbolTablesCache.getInstance(project);
    }

    public void assertParsingAndSymbolBuildingAllowed() {
        this.assertParsingAndSymbolBuildingAllowed(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertParsingAndSymbolBuildingAllowed(@NotNull Thread thread2) {
        boolean allowed;
        if (thread2 == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(2);
        }
        boolean bl = allowed = this.myCache.areSymbolsLoaded() || OCSymbolTablesBuildingActivity.isSymbolBuildingThread(thread2);
        if (!allowed) {
            String logEntries;
            List log;
            List list = log = (List)ACTIVITY_LOG.getValue((UserDataHolder)this.project);
            synchronized (list) {
                logEntries = StringUtil.join((Collection)log, (String)"\n");
            }
            @NonNls String message = "Symbol building is not allowed: " + System.currentTimeMillis() + " . \nLoaded: " + this.myCache.areSymbolsLoaded() + "\nDumb: " + DumbService.isDumb((Project)this.project) + "\nPrevious activities: \n" + logEntries;
            OCLog.LOG.error(message);
            throw new ProcessCanceledException(new Throwable(message));
        }
    }

    private static boolean isSymbolBuildingThread(@NotNull Thread thread2) {
        if (thread2 == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(3);
        }
        return RecursiveSymbolBuilding.isRecursiveSymbolBuildingThread(thread2) || mySymbolBuildingThreads.contains(thread2);
    }

    @TestOnly
    public static void setIndicatorFactory(@Nullable NotNullProducer<? extends ProgressIndicator> indicatorFactory) {
        ourIndicatorFactory = indicatorFactory;
    }

    public void rebuildSymbols() {
        this.rebuildSymbols(Mode.FAST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildSymbols(final @NotNull Mode mode) {
        if (mode == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(4);
        }
        if (this.project.isDisposed()) {
            return;
        }
        final int requestNumber = this.ourRequestCount.incrementAndGet();
        @NonNls String activityName = "rebuildSymbols";
        this.runSymbolActivity(new SymbolBuildingTask(activityName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = OCSymbolTablesBuildingActivity.this.ourLastBuildLock;
                synchronized (object) {
                    if (requestNumber <= OCSymbolTablesBuildingActivity.this.ourLastBuild) {
                        return;
                    }
                    OCSymbolTablesBuildingActivity.this.ourLastBuildTask = this;
                    OCSymbolTablesBuildingActivity.this.ourLastBuild = OCSymbolTablesBuildingActivity.this.ourRequestCount.get();
                }
                OCSymbolTablesBuildingActivity.this.buildSymbolsInternal(indicator, mode);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$1", "process"));
            }
        });
        Object object = this.ourLastBuildLock;
        synchronized (object) {
            SymbolBuildingTask currentTask = this.ourLastBuildTask;
            if (currentTask != null && this.ourLastBuild < requestNumber) {
                if (currentTask.shouldCancel()) {
                    DumbService.getInstance((Project)this.project).cancelTask((DumbModeTask)currentTask);
                }
                this.ourLastBuildTask = null;
            }
        }
    }

    public void buildSymbolsForFiles(final @NotNull Collection<VirtualFile> files) {
        if (files == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(5);
        }
        this.runSymbolActivity(new SymbolBuildingTask("buildSymbolsForFiles"){

            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                OCSymbolTablesBuildingActivity.this.buildSymbolsForFilesInternal(indicator, files);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$2", "process"));
            }
        });
    }

    public void rebuildModuleMaps() {
        OCInitialBuildingInfo info = new OCInitialBuildingInfo(this.project, Mode.FAST);
        this.rebuildModuleMaps(info);
    }

    public void rebuildModuleMaps(final @NotNull OCInitialBuildingInfo info) {
        if (info == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(6);
        }
        if (!ModuleMapCache.shouldBuildCache()) {
            return;
        }
        this.runSymbolActivity(new SymbolBuildingTask("rebuildModuleMaps"){

            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                ModuleMapCache.getInstance(OCSymbolTablesBuildingActivity.this.project).reset();
                indicator.setIndeterminate(false);
                OCDeserializeModuleMapsActivity.build(indicator, info);
                OCModuleMapBuildingActivity.buildRemainingModuleMaps(OCSymbolTablesBuildingActivity.this.project, indicator);
                OCModuleMapSerializationActivity.serializeModuleMaps(OCSymbolTablesBuildingActivity.this.project, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$3", "process"));
            }
        });
    }

    public void runSymbolActivity(@NonNls @NotNull String activityName, final @NotNull Consumer<? super OCBuildingActivityProgressIndicator> task) {
        if (activityName == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(7);
        }
        if (task == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(8);
        }
        this.runSymbolActivity(new SymbolBuildingTask(activityName){

            @Override
            protected void process(@NotNull OCBuildingActivityProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                task.consume((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$4", "process"));
            }
        });
    }

    public void runSymbolActivity(final @NotNull SymbolBuildingTask task) {
        Application app;
        if (task == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(9);
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode() && app.isWriteAccessAllowed()) {
            final Disposable listenerDisposable = Disposer.newDisposable();
            app.addApplicationListener(new ApplicationListener(){
                private final AtomicBoolean isHandled = new AtomicBoolean();

                public void afterWriteActionFinished(@NotNull Object action) {
                    if (action == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (!this.isHandled.getAndSet(true)) {
                        Disposer.dispose((Disposable)listenerDisposable);
                        DumbService.getInstance((Project)OCSymbolTablesBuildingActivity.this.project).queueTask((DumbModeTask)task);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$5", "afterWriteActionFinished"));
                }
            }, listenerDisposable);
            return;
        }
        DumbService.getInstance((Project)this.project).queueTask((DumbModeTask)task);
    }

    private void buildSymbolsForFilesInternal(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull Collection<VirtualFile> sourceFiles) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(10);
        }
        if (sourceFiles == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(11);
        }
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        OCSymbolTablesBuildingActivity.invokeAndWaitSafely((ProgressIndicator)indicator, () -> {
            if (indicator.isCanceled()) {
                return;
            }
            this.myCache.notifySymbolsUnloaded();
            this.myCache.reparseCachedPsiFiles();
        });
        indicator.checkCanceled();
        OCSymbolTableBuilder builder2 = new OCSymbolTableBuilder(this.project, indicator, sourceFiles, false);
        builder2.processBuildFiles(indicator.getFraction(), 1.0);
        this.notifySymbolsAreLoadedAndReparseCachedFiles(indicator);
    }

    private void buildSymbolsInternal(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull Mode mode) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(12);
        }
        if (mode == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(13);
        }
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            OCLog.LOG.error("Symbols building must not be initiated from write action, otherwise deadlock will occur");
            return;
        }
        long startTime = System.nanoTime();
        OCInitialBuildingInfo userInfo = new OCInitialBuildingInfo(this.project, mode);
        userInfo.setLocationHash(this.project.getLocationHash());
        OCClearingSymbolsActivity.build(indicator, userInfo);
        OCHeaderMapLoadingActivity.build(indicator, userInfo);
        OCDeserializeModuleMapsActivity.build(indicator, userInfo);
        OCSymbolLoadingActivity.build(indicator, userInfo);
        OCModuleMapBuildingActivity.build(indicator, userInfo);
        OCModuleMapSerializationActivity.build(indicator, userInfo);
        Collection<VirtualFile> allFiles = Objects.requireNonNull(userInfo.getAllFiles());
        @NonNls String allFilesDescription = allFiles.size() + " project files";
        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesBeforeSymbolBuilding", (Object)allFilesDescription);){
            OCSymbolTablesBuildingActivity.processAdditionalActivities(indicator, userInfo, true);
        }
        OCSymbolBuildingActivity.build(indicator, userInfo);
        ignored = new CidrEventSpan("symbols", "processAdditionalActivitiesAfterSymbolBuilding", (Object)allFilesDescription);
        try {
            OCSymbolTablesBuildingActivity.processAdditionalActivities(indicator, userInfo, false);
        }
        finally {
            ignored.close();
        }
        Pair<Integer, Integer> fileStats = OCSymbolSavingActivity.build(indicator, userInfo);
        long durationMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        OCIndexingStatisticsCollector.logSymbolBuilt(mode, durationMs, (Integer)fileStats.first, (Integer)fileStats.second);
        FileSymbolTable.reportStats(this.project);
    }

    private static void processAdditionalActivities(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userInfo, boolean beforeSymbolBuilding) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(14);
        }
        if (userInfo == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(15);
        }
        for (OCInitialBuildingActivity activity : EP_NAME.getExtensionList()) {
            if (activity.runBeforeSymbolBuilding() != beforeSymbolBuilding) continue;
            activity.build(indicator, userInfo);
        }
    }

    void notifySymbolsAreLoadedAndReparseCachedFiles(@NotNull OCBuildingActivityProgressIndicator indicator) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(16);
        }
        indicator.checkCanceled();
        OCSymbolTablesBuildingActivity.runCancelableReadAction(this.project, (ProgressIndicator)indicator, () -> {
            indicator.checkCanceled();
            this.myCache.compact();
            this.myCache.notifySymbolsLoaded();
        });
        indicator.checkCanceled();
        Runnable runnable = () -> {
            if (this.project.isDisposed() || indicator.isCanceled()) {
                return;
            }
            this.myCache.reparseCachedPsiFiles();
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().invokeAndWait(runnable);
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, this.project.getDisposed());
        }
    }

    public static void runCancelableReadAction(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(17);
        }
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(18);
        }
        if (runnable == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(19);
        }
        ReadAction.nonBlocking((Runnable)OCSymbolTablesBuildingActivity.withCustomLoopIndicator(runnable)).expireWith((Disposable)OCSymbolTablesBuildingActivity.getInstance(project)).wrapProgress(indicator).executeSynchronously();
    }

    public static <T> T runCancelableReadAction(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull Callable<T> callable) {
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(21);
        }
        if (callable == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(22);
        }
        return (T)ReadAction.nonBlocking(OCSymbolTablesBuildingActivity.withCustomLoopIndicator(callable)).expireWith((Disposable)OCSymbolTablesBuildingActivity.getInstance(project)).wrapProgress(indicator).executeSynchronously();
    }

    static void invokeAndWaitSafely(@NotNull ProgressIndicator indicator, @NotNull Runnable runnable) {
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(23);
        }
        if (runnable == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(24);
        }
        Semaphore s = new Semaphore(1);
        ModalityUiUtil.invokeLaterIfNeeded(() -> WriteAction.run(() -> {
            try {
                runnable.run();
            }
            finally {
                s.up();
            }
        }), (ModalityState)ModalityState.defaultModalityState());
        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)s, (ProgressIndicator)indicator);
    }

    /*
     * WARNING - void declaration
     */
    static <T> void processRecursiveTasks(@NotNull Project project, @NotNull OCBuildingActivityProgressIndicator indicator, double from, double to, @NotNull ImmutableListMultimap<Object, T> immutableListMultimap, @NotNull BiFunction<? super ProgressIndicator, ? super ProgressIndicator, RecursiveSymbolBuilding<T>> biFunction) {
        void clusters;
        void symbolBuildingProvider;
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(26);
        }
        if (immutableListMultimap == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(27);
        }
        if (biFunction == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(28);
        }
        OCSymbolTablesBuildingActivity.processWithWriteActionPriority((ProgressIndicator)indicator, project, (Consumer<? super ProgressIndicator>)((Consumer)arg_0 -> OCSymbolTablesBuildingActivity.lambda$processRecursiveTasks$7((BiFunction)symbolBuildingProvider, indicator, from, to, (ImmutableListMultimap)clusters, arg_0)));
    }

    static void runWithSymbolBuildingAllowed(@NotNull Runnable runnable) {
        if (runnable == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(29);
        }
        Thread currentThread = Thread.currentThread();
        assert (!OCSymbolTablesBuildingActivity.isSymbolBuildingThread(currentThread)) : "Dedicated thread should be used for symbols building";
        mySymbolBuildingThreads.add(currentThread);
        try {
            runnable.run();
        }
        finally {
            mySymbolBuildingThreads.remove(currentThread);
        }
    }

    static void processWithWriteActionPriority(@NotNull ProgressIndicator globalIndicator, @NotNull Project project, @NotNull Consumer<? super ProgressIndicator> runnable) {
        if (globalIndicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(30);
        }
        if (project == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(31);
        }
        if (runnable == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(32);
        }
        final ProgressIndicator localProgress = OCSymbolTablesBuildingActivity.createCancelableLoopIndicator(globalIndicator);
        ProgressManager.getInstance().runProcess(() -> {
            if (project.isDisposed()) {
                return;
            }
            ApplicationListener applicationListener = new ApplicationListener(){

                public void beforeWriteActionStart(@NotNull Object action) {
                    if (action == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    localProgress.cancel();
                }

                public void writeActionFinished(@NotNull Object action) {
                    if (action == null) {
                        6.$$$reportNull$$$0(1);
                    }
                    if (localProgress.isRunning()) {
                        localProgress.stop();
                    }
                    localProgress.start();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "action";
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$6";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeWriteActionStart";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "writeActionFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            Disposable listenerDisposable = Disposer.newDisposable();
            ApplicationManager.getApplication().addApplicationListener(applicationListener, listenerDisposable);
            try {
                runnable.consume((Object)localProgress);
            }
            finally {
                Disposer.dispose((Disposable)listenerDisposable);
            }
        }, localProgress);
    }

    @NotNull
    private static ProgressIndicator createCancelableLoopIndicator(@NotNull ProgressIndicator mainIndicator) {
        if (mainIndicator == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(33);
        }
        return ourIndicatorFactory != null ? (ProgressIndicator)ourIndicatorFactory.produce() : new SensitiveProgressWrapper(mainIndicator){

            protected boolean isReuseable() {
                return true;
            }
        };
    }

    @NotNull
    static Runnable withCustomLoopIndicator(@NotNull Runnable action) {
        NotNullProducer<? extends ProgressIndicator> indicatorFactory;
        if (action == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(34);
        }
        Runnable runnable = (indicatorFactory = ourIndicatorFactory) != null ? () -> ProgressManager.getInstance().runProcess(action, (ProgressIndicator)indicatorFactory.produce()) : action;
        if (runnable == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(35);
        }
        return runnable;
    }

    @NotNull
    private static <T> Callable<T> withCustomLoopIndicator(@NotNull Callable<T> action) {
        NotNullProducer<? extends ProgressIndicator> indicatorFactory;
        if (action == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(36);
        }
        Callable<Object> callable = (indicatorFactory = ourIndicatorFactory) != null ? () -> {
            Object result = ProgressManager.getInstance().runProcess(() -> {
                try {
                    return action.call();
                }
                catch (Exception e) {
                    return e;
                }
            }, (ProgressIndicator)indicatorFactory.produce());
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            return result;
        } : action;
        if (callable == null) {
            OCSymbolTablesBuildingActivity.$$$reportNull$$$0(37);
        }
        return callable;
    }

    public void dispose() {
    }

    private static /* synthetic */ void lambda$processRecursiveTasks$7(BiFunction symbolBuildingProvider, OCBuildingActivityProgressIndicator indicator, double from, double to, ImmutableListMultimap clusters, ProgressIndicator localIndicator) {
        RecursiveSymbolBuilding symbolBuilding = (RecursiveSymbolBuilding)symbolBuildingProvider.apply(indicator, localIndicator);
        OCWorkerActivity.runWithProgress(indicator, symbolBuilding.getIndicatorText(), from, to, () -> symbolBuilding.process(clusters));
    }

    static {
        mySymbolBuildingThreads = ContainerUtil.newConcurrentSet();
        ACTIVITY_LOG = NotNullLazyKey.create((String)"SYMBOL ACTIVITY LOG", dom -> new ArrayList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userInfo";
                break;
            }
            case 19: 
            case 24: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusters";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolBuildingProvider";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalIndicator";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainIndicator";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "withCustomLoopIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertParsingAndSymbolBuildingAllowed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSymbolBuildingThread";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rebuildSymbols";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolsForFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rebuildModuleMaps";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runSymbolActivity";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolsForFilesInternal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildSymbolsInternal";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processAdditionalActivities";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifySymbolsAreLoadedAndReparseCachedFiles";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runCancelableReadAction";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitSafely";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processRecursiveTasks";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runWithSymbolBuildingAllowed";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processWithWriteActionPriority";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCancelableLoopIndicator";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "withCustomLoopIndicator";
                break;
            }
            case 35: 
            case 37: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public abstract class SymbolBuildingTask
    extends DumbModeTask {
        @NotNull
        private final String myActivityName;
        private volatile boolean myShouldCancel;

        public SymbolBuildingTask(String activityName) {
            if (activityName == null) {
                SymbolBuildingTask.$$$reportNull$$$0(0);
            }
            super((Object)activityName);
            this.myShouldCancel = true;
            this.myActivityName = activityName;
        }

        private boolean shouldCancel() {
            return this.myShouldCancel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void performInDumbMode(@NotNull ProgressIndicator original) {
            if (original == null) {
                SymbolBuildingTask.$$$reportNull$$$0(1);
            }
            OCBuildingActivityProgressIndicator indicator = new OCBuildingActivityProgressIndicator(original);
            Disposable cancelOnProjectDispose = () -> {
                if (this.myShouldCancel) {
                    indicator.cancel();
                }
            };
            try {
                @NonNls List log = (List)ACTIVITY_LOG.getValue((UserDataHolder)OCSymbolTablesBuildingActivity.this.project);
                long start = System.currentTimeMillis();
                List list = log;
                synchronized (list) {
                    log.add(this.myActivityName + " " + start + ": START");
                }
                Disposer.register((Disposable)OCSymbolTablesBuildingActivity.getInstance(OCSymbolTablesBuildingActivity.this.project), (Disposable)cancelOnProjectDispose);
                this.process(indicator);
                this.myShouldCancel = false;
                list = log;
                synchronized (list) {
                    log.add(this.myActivityName + " " + start + ": END after " + (System.currentTimeMillis() - start));
                }
            }
            catch (ProcessCanceledException pce) {
                if (indicator.isCanceled()) {
                    throw pce;
                }
                this.reportUnexpectedException(pce);
            }
            catch (Throwable t) {
                this.reportUnexpectedException(t);
            }
            finally {
                Disposer.dispose((Disposable)cancelOnProjectDispose);
            }
        }

        protected abstract void process(@NotNull OCBuildingActivityProgressIndicator var1);

        private void reportUnexpectedException(Throwable t) {
            if (OCSymbolTablesBuildingActivity.this.project.isDisposed() || !OCSymbolTablesBuildingActivity.this.project.isOpen()) {
                return;
            }
            OCLog.LOG.error("Unexpected exception during symbol building (" + this.myActivityName + ")", t instanceof ProcessCanceledException ? new RuntimeException(t) : t);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activityName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCSymbolTablesBuildingActivity$SymbolBuildingTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum Mode {
        FAST,
        COMPACT,
        FULL;

    }
}

