/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.openapi.util.NlsSafe;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b!\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020*R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u0019R\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0017\"\u0004\b$\u0010\u0019R\u001a\u0010%\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0017\u00a8\u00062"}, d2={"Lcom/intellij/database/dialects/base/introspector/QueryStatEntry;", "", "turn", "", "name", "", "(ILjava/lang/String;)V", "durationAvg", "", "getDurationAvg", "()J", "durationMax", "getDurationMax", "setDurationMax", "(J)V", "durationMin", "getDurationMin", "setDurationMin", "durationSum", "getDurationSum", "setDurationSum", "fetchedPacks", "getFetchedPacks", "()I", "setFetchedPacks", "(I)V", "fetchedRows", "getFetchedRows", "setFetchedRows", "getName", "()Ljava/lang/String;", "numberOfFails", "getNumberOfFails", "setNumberOfFails", "numberOfFinishes", "getNumberOfFinishes", "setNumberOfFinishes", "numberOfStarts", "getNumberOfStarts", "setNumberOfStarts", "getTurn", "registerFinish", "", "duration", "packs", "rows", "failed", "", "registerStart", "DurationComparator", "intellij.database.dialects.base.core"})
public final class QueryStatEntry {
    private int numberOfStarts;
    private int numberOfFinishes;
    private int numberOfFails;
    private int fetchedPacks;
    private int fetchedRows;
    private long durationMin;
    private long durationMax;
    private long durationSum;
    private final int turn;
    @NotNull
    private final String name;

    public final int getNumberOfStarts() {
        return this.numberOfStarts;
    }

    public final void setNumberOfStarts(int n) {
        this.numberOfStarts = n;
    }

    public final int getNumberOfFinishes() {
        return this.numberOfFinishes;
    }

    public final void setNumberOfFinishes(int n) {
        this.numberOfFinishes = n;
    }

    public final int getNumberOfFails() {
        return this.numberOfFails;
    }

    public final void setNumberOfFails(int n) {
        this.numberOfFails = n;
    }

    public final int getFetchedPacks() {
        return this.fetchedPacks;
    }

    public final void setFetchedPacks(int n) {
        this.fetchedPacks = n;
    }

    public final int getFetchedRows() {
        return this.fetchedRows;
    }

    public final void setFetchedRows(int n) {
        this.fetchedRows = n;
    }

    public final long getDurationMin() {
        return this.durationMin;
    }

    public final void setDurationMin(long l) {
        this.durationMin = l;
    }

    public final long getDurationMax() {
        return this.durationMax;
    }

    public final void setDurationMax(long l) {
        this.durationMax = l;
    }

    public final long getDurationSum() {
        return this.durationSum;
    }

    public final void setDurationSum(long l) {
        this.durationSum = l;
    }

    public final long getDurationAvg() {
        return this.durationSum / (long)this.numberOfFinishes;
    }

    public final void registerStart() {
        int n = this.numberOfStarts;
        this.numberOfStarts = n + 1;
    }

    public final void registerFinish(long duration, int packs, int rows, boolean failed) {
        long d;
        long l = d = duration >= 0L ? duration : 1L;
        if (this.durationMin == 0L) {
            this.durationMin = d;
            this.durationMax = d;
            this.durationSum = d;
        } else {
            long l2 = this.durationMin;
            boolean bl = false;
            this.durationMin = Math.min(l2, d);
            l2 = this.durationMax;
            bl = false;
            this.durationMax = Math.max(l2, d);
            this.durationSum += d;
        }
        this.fetchedPacks += packs;
        this.fetchedRows += rows;
        int n = this.numberOfFinishes;
        this.numberOfFinishes = n + 1;
        if (failed) {
            n = this.numberOfFails;
            this.numberOfFails = n + 1;
        }
    }

    public static /* synthetic */ void registerFinish$default(QueryStatEntry queryStatEntry, long l, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        queryStatEntry.registerFinish(l, n, n2, bl);
    }

    public final int getTurn() {
        return this.turn;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public QueryStatEntry(int turn, @NlsSafe @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.turn = turn;
        this.name = name2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/base/introspector/QueryStatEntry$DurationComparator;", "Ljava/util/Comparator;", "Lcom/intellij/database/dialects/base/introspector/QueryStatEntry;", "Lkotlin/Comparator;", "()V", "compare", "", "o1", "o2", "intellij.database.dialects.base.core"})
    public static final class DurationComparator
    implements Comparator<QueryStatEntry> {
        @NotNull
        public static final DurationComparator INSTANCE;

        @Override
        public int compare(@NotNull QueryStatEntry o1, @NotNull QueryStatEntry o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            if (o1.getDurationSum() < o2.getDurationSum()) {
                return 1;
            }
            if (o1.getDurationSum() > o2.getDurationSum()) {
                return -1;
            }
            if (o1.getDurationMax() < o2.getDurationMax()) {
                return 1;
            }
            if (o1.getDurationMax() > o2.getDurationMax()) {
                return -1;
            }
            if (o1.getTurn() < o2.getTurn()) {
                return -1;
            }
            if (o1.getTurn() > o2.getTurn()) {
                return 1;
            }
            return 0;
        }

        private DurationComparator() {
        }

        static {
            DurationComparator durationComparator;
            INSTANCE = durationComparator = new DurationComparator();
        }
    }
}

