/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector.jdbc.wrappers;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ResultSetWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.Table> {
    private final Dbms myDbms;
    private final DatabaseMetaDataWrapper.Schema mySchema;

    public TableIt(@NotNull ResultSetWrapper rs, @NotNull Dbms dbms, @Nullable Boolean initialHasNext, @NotNull DatabaseMetaDataWrapper.Schema schema) {
        if (rs == null) {
            TableIt.$$$reportNull$$$0(0);
        }
        if (dbms == null) {
            TableIt.$$$reportNull$$$0(1);
        }
        if (schema == null) {
            TableIt.$$$reportNull$$$0(2);
        }
        super(rs, initialHasNext);
        this.myDbms = dbms;
        this.mySchema = schema;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.Table createStorage() {
        return new DatabaseMetaDataWrapper.Table(this.mySchema, "");
    }

    @Override
    protected DatabaseMetaDataWrapper.Table calcValue() {
        DatabaseMetaDataWrapper.Table res2 = (DatabaseMetaDataWrapper.Table)this.getStorageToFill();
        try {
            String name2 = this.myRs.getString("TABLE_NAME", 3);
            if (StringUtil.isEmpty((String)name2)) {
                return (DatabaseMetaDataWrapper.Table)this.skip();
            }
            res2.name = name2;
            res2.type = this.myRs.getString("TABLE_TYPE", 4);
            if (this.myDbms.isSqlite() && name2.startsWith("sqlite_autoindex_")) {
                res2.type = "INDEX";
            }
            res2.comment = this.myRs.getString("REMARKS", 5);
        }
        catch (SQLException e2) {
            this.onError(res2, e2);
            return (DatabaseMetaDataWrapper.Table)this.skip();
        }
        return res2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "schema";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/base/introspector/jdbc/wrappers/TableIt";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

