/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.bigquery.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.LegacyDeserializer;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.NameCache;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntroQueries;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospectionException;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector$BigQuerySchemaRetriever$retrieveRoutineArguments$;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector$BigQuerySchemaRetriever$retrieveRoutines$;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTablesAndViews$;
import com.intellij.database.dialects.bigquery.introspector.BigQueryIntrospectorKt;
import com.intellij.database.dialects.bigquery.model.BigQueryArgument;
import com.intellij.database.dialects.bigquery.model.BigQueryDatabase;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryLikeTable;
import com.intellij.database.dialects.bigquery.model.BigQueryMatView;
import com.intellij.database.dialects.bigquery.model.BigQueryMatViewColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryRoot;
import com.intellij.database.dialects.bigquery.model.BigQueryRoutine;
import com.intellij.database.dialects.bigquery.model.BigQuerySchema;
import com.intellij.database.dialects.bigquery.model.BigQueryTable;
import com.intellij.database.dialects.bigquery.model.BigQueryTableColumn;
import com.intellij.database.dialects.bigquery.model.BigQueryView;
import com.intellij.database.dialects.bigquery.model.BigQueryViewColumn;
import com.intellij.database.dialects.bigquery.model.properties.BigQueryTableColumnType;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrViewColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003\u0016\u0017\u0018B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014J6\u0010\f\u001a \u0012\u0006\b\u0001\u0012\u00020\u00030\rR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u00060\u0014R\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0004H\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/ModelFactory;)V", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "createMeta", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "createSchemaRetriever", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever;", "schema", "BigQueryDatabaseRetriever", "BigQuerySchemaRetriever", "Factory", "intellij.database.dialects.bigquery"})
public class BigQueryIntrospector
extends BaseMultiDatabaseIntrospector<BigQueryRoot, BigQueryDatabase, BigQuerySchema> {
    private final DatabaseMetaDataWrapper createMeta() {
        DatabaseConnectionCore connection;
        DatabaseConnectionCore databaseConnectionCore = connection = this.getDbConnection();
        if (databaseConnectionCore != null) {
            DatabaseMetaDataWrapper databaseMetaDataWrapper;
            DatabaseConnectionCore databaseConnectionCore2 = databaseConnectionCore;
            boolean bl = false;
            boolean bl2 = false;
            DatabaseConnectionCore it = databaseConnectionCore2;
            boolean bl3 = false;
            try {
                RemoteDatabaseMetaData remoteDatabaseMetaData = connection.getRemoteMetaData();
                if (remoteDatabaseMetaData == null) {
                    throw (Throwable)((Object)new BigQueryIntrospectionException("Connection#getMetaData() returns null. No introspection could be performed", null));
                }
                Intrinsics.checkNotNullExpressionValue((Object)remoteDatabaseMetaData, (String)"connection.remoteMetaDat\u2026ould be performed\", null)");
                RemoteDatabaseMetaData metaData = remoteDatabaseMetaData;
                DatabaseMetaDataWrapper databaseMetaDataWrapper2 = DatabaseMetaDataWrapper.create(connection, metaData).withErrorSink(this.getErrorSink());
                Intrinsics.checkNotNullExpressionValue((Object)databaseMetaDataWrapper2, (String)"DatabaseMetaDataWrapper\n\u2026.withErrorSink(errorSink)");
                databaseMetaDataWrapper = databaseMetaDataWrapper2;
            }
            catch (SQLException e2) {
                throw (Throwable)((Object)new BigQueryIntrospectionException("Failed to retrieve meta data", e2));
            }
            return databaseMetaDataWrapper;
        }
        throw (Throwable)((Object)new BigQueryIntrospectionException("Failed to get connection", null));
    }

    @NotNull
    protected BigQuerySchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull BigQuerySchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new BigQuerySchemaRetriever(transaction, schema);
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return new BaseMultiDatabaseIntrospector.DatabaseLister<BigQueryIntroQueries.Database, BigQueryDatabase>(this){
            final /* synthetic */ BigQueryIntrospector this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected List<BigQueryIntroQueries.Database> listDatabases(@NotNull DBTransaction tran) {
                List list;
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                Closeable closeable = BigQueryIntrospector.access$createMeta(this.this$0).databases();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ClosableIt it = (ClosableIt)closeable;
                    boolean bl3 = false;
                    List list2 = it.map(createDatabaseLister.listDatabases.1.1.INSTANCE).toList();
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createMeta().databases()\u2026        .toList()\n      }");
                return list;
            }

            protected boolean isCurrent(int idx, @NotNull BigQueryIntroQueries.Database db) {
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return Intrinsics.areEqual((Object)BigQueryIntrospector.access$getDbConnectionInfo$p((BigQueryIntrospector)this.this$0).databaseName, (Object)db.name);
            }

            @NotNull
            protected BigQueryDatabase applyDatabase(@NotNull ModNamingFamily<?> databases2, @NotNull BigQueryIntroQueries.Database db) {
                Intrinsics.checkNotNullParameter(databases2, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return (BigQueryDatabase)this.renew(databases2, db.name);
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<? extends BigQueryDatabase> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull BigQueryDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new BigQueryDatabaseRetriever(transaction, database);
    }

    public BigQueryIntrospector(@NotNull Project project, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        Dbms dbms = Dbms.BIGQUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"BIGQUERY");
        super(dbms, project, modelFactory);
    }

    public static final /* synthetic */ ConnectionInfo access$getDbConnectionInfo$p(BigQueryIntrospector $this) {
        return $this.getDbConnectionInfo();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "VERSION", "intellij.database.dialects.bigquery"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return version.isOrGreater(new int[]{1, 0});
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull Dbms dbms, @NotNull Project project, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return new BigQueryIntrospector(project, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e2) {
            return false;
        }

        public boolean isNative() {
            return DBIntrospector.Factory.DefaultImpls.isNative((DBIntrospector.Factory)this);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "intellij.database.dialects.bigquery"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE;

            private VERSION() {
            }

            static {
                VERSION vERSION;
                INSTANCE = vERSION = new VERSION();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\b\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J1\u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00120\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0018\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020'2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010*\u001a\u00020\u001aH\u0002J\b\u0010+\u001a\u00020\u001aH\u0014J\b\u0010,\u001a\u00020\u001aH\u0002J\b\u0010-\u001a\u00020\u001aH\u0002J\b\u0010.\u001a\u00020\u001aH\u0002J\b\u0010/\u001a\u00020\u001aH\u0002J\b\u00100\u001a\u00020\u000fH\u0002J\b\u00101\u001a\u00020\u001aH\u0002J\b\u00102\u001a\u00020\u001aH\u0002J\b\u00103\u001a\u00020\u001aH\u0002J\b\u00104\u001a\u00020\u001aH\u0002J\b\u00105\u001a\u00020\u001aH\u0002J\b\u00106\u001a\u00020\u001aH\u0002\u00a8\u00067"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQuerySchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;)V", "getColumnType", "Lcom/intellij/database/dialects/bigquery/model/properties/BigQueryTableColumnType;", "column", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$ColumnInfo;", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "parseTableOption", "T", "tableOrViewOption", "Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$TableOrViewOption;", "parse", "Lkotlin/Function1;", "", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntroQueries$TableOrViewOption;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "processLikeTableOption", "", "likeTable", "Lcom/intellij/database/dialects/bigquery/model/BigQueryLikeTable;", "processMatViewOption", "view", "Lcom/intellij/database/dialects/bigquery/model/BigQueryMatView;", "processTableColumn", "Lcom/intellij/database/dialects/bigquery/model/BigQueryTableColumn;", "columnInfo", "processTableOption", "table", "Lcom/intellij/database/dialects/bigquery/model/BigQueryTable;", "processViewColumn", "Lcom/intellij/database/dialects/bigquery/model/BigQueryLikeColumn;", "processViewOption", "Lcom/intellij/database/dialects/bigquery/model/BigQueryView;", "retrieveColumnComments", "retrieveMainContent", "retrieveRoutineArguments", "retrieveRoutineOptions", "retrieveRoutineSources", "retrieveRoutines", "retrieveRoutinesInfo", "retrieveRoutinesInfoFromMetaData", "retrieveTableAndViewColumns", "retrieveTablesAndViews", "retrieveTablesAndViewsInfo", "retrieveTablesAndViewsOptions", "retrieveViewsDefinitions", "intellij.database.dialects.bigquery"})
    protected final class BigQuerySchemaRetriever
    extends BaseIntrospector.AbstractSchemaRetriever<BigQuerySchema> {
        @Override
        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull BigQuerySchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        @Override
        protected void retrieveMainContent() {
            this.prepareParameters();
            this.retrieveTablesAndViews();
            this.retrieveTableAndViewColumns();
            this.retrieveColumnComments();
            this.retrieveRoutines();
            this.retrieveRoutineArguments();
            this.retrieveRoutineSources();
        }

        private final void retrieveTablesAndViews() {
            BigQueryIntrospector.this.reportRetrieving("tables and views", "introspection.retrieve.tablesViews");
            boolean $i$f$cleanupFamilies = false;
            Function1 it = BigQuerySchemaRetriever$retrieveTablesAndViews$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"schema.tables");
            it.invoke(modNamingFamily);
            ModNamingFamily<? extends BigQueryView> modNamingFamily2 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"schema.views");
            it.invoke(modNamingFamily2);
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily3 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"schema.matViews");
            it.invoke(modNamingFamily3);
            boolean bl2 = false;
            this.retrieveTablesAndViewsInfo();
            it = BigQuerySchemaRetriever$retrieveTablesAndViews$$inlined$cleanupFamilies$2.INSTANCE;
            bl = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily4 = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"schema.tables");
            it.invoke(modNamingFamily4);
            ModNamingFamily<? extends BigQueryView> modNamingFamily5 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"schema.views");
            it.invoke(modNamingFamily5);
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily6 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"schema.matViews");
            it.invoke(modNamingFamily6);
            this.retrieveTablesAndViewsOptions();
            this.retrieveViewsDefinitions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveTablesAndViewsInfo() {
            BigQueryDatabase bigQueryDatabase = ((BigQuerySchema)this.getSchema()).getParent();
            Closeable closeable = BigQueryIntrospector.this.createMeta().tables(new DatabaseMetaDataWrapper.Schema(((BigQuerySchema)this.getSchema()).getName(), bigQueryDatabase != null ? bigQueryDatabase.getName() : null), null, null);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ClosableIt it = (ClosableIt)closeable;
                boolean bl3 = false;
                ClosableIt closableIt = it;
                Intrinsics.checkNotNullExpressionValue((Object)closableIt, (String)"it");
                Iterator iterator = (Iterator)((Object)closableIt);
                boolean bl4 = false;
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    ModNamingFamily tables;
                    ObjectKind kind;
                    DatabaseMetaDataWrapper.Table t = (DatabaseMetaDataWrapper.Table)iterator2.next();
                    LegacyDeserializer.JdbcTableType jdbcTableType = LegacyDeserializer.JdbcTableType.findByName((String)t.type);
                    Intrinsics.checkNotNullExpressionValue((Object)jdbcTableType, (String)"JdbcTableType.findByName(t.type)");
                    Intrinsics.checkNotNullExpressionValue((Object)jdbcTableType.getKind(), (String)"JdbcTableType.findByName(t.type).kind");
                    ModFamily modFamily = DbImplUtilCore.familyOf((BasicModElement)((BasicModElement)this.getSchema()), (ObjectKind)kind);
                    if (!(modFamily instanceof ModNamingFamily)) {
                        modFamily = null;
                    }
                    if ((ModNamingFamily)modFamily == null) {
                        continue;
                    }
                    tables.createOrGet(t.name);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final void retrieveViewsDefinitions() {
            BigQueryIntroQueries.INSTANCE.processViewDefinitions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ViewDefinition, Unit>)((Function1)new Function1<BigQueryIntroQueries.ViewDefinition, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;

                public final void invoke(@NotNull BigQueryIntroQueries.ViewDefinition viewDef) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)viewDef, (String)"viewDef");
                        BigQueryView bigQueryView = (BigQueryView)((BigQuerySchema)this.this$0.getSchema()).getViews().get(viewDef.table_name);
                        if (bigQueryView == null) break block0;
                        BigQueryView bigQueryView2 = bigQueryView;
                        boolean bl = false;
                        boolean bl2 = false;
                        BigQueryView $this$apply = bigQueryView2;
                        boolean bl3 = false;
                        ((BasicModModel)$this$apply.getModel()).writeSources(new Runnable($this$apply, viewDef){
                            final /* synthetic */ BigQueryView $this_apply;
                            final /* synthetic */ BigQueryIntroQueries.ViewDefinition $viewDef$inlined;
                            {
                                this.$this_apply = bigQueryView;
                                this.$viewDef$inlined = viewDefinition;
                            }

                            public final void run() {
                                this.$this_apply.setSourceText((CompositeText)BaseIntrospectionFunctions.toCompositeText(this.$viewDef$inlined.view_definition, CompositeText.Kind.ORIGINAL_TEXT));
                            }
                        });
                    }
                }
                {
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }
            }));
        }

        private final void retrieveTablesAndViewsOptions() {
            BigQueryIntroQueries.INSTANCE.processViewAndTablesOptions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.TableOrViewOption, Unit>)((Function1)new Function1<BigQueryIntroQueries.TableOrViewOption, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;

                public final void invoke(@NotNull BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
                    Intrinsics.checkNotNullParameter((Object)tableOrViewOption, (String)"tableOrViewOption");
                    LegacyDeserializer.JdbcTableType jdbcTableType = LegacyDeserializer.JdbcTableType.findByName((String)tableOrViewOption.table_type);
                    Intrinsics.checkNotNullExpressionValue((Object)jdbcTableType, (String)"JdbcTableType.findByName\u2026eOrViewOption.table_type)");
                    ObjectKind objectKind = jdbcTableType.getKind();
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"JdbcTableType.findByName\u2026ewOption.table_type).kind");
                    ObjectKind kind = objectKind;
                    if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.MAT_VIEW)) {
                        BigQueryMatView bigQueryMatView = (BigQueryMatView)((BigQuerySchema)this.this$0.getSchema()).getMatViews().get(tableOrViewOption.table_name);
                        if (bigQueryMatView != null) {
                            BigQueryMatView bigQueryMatView2 = bigQueryMatView;
                            boolean bl = false;
                            boolean bl2 = false;
                            BigQueryMatView $this$apply = bigQueryMatView2;
                            boolean bl3 = false;
                            BigQuerySchemaRetriever.access$processMatViewOption(this.this$0, $this$apply, tableOrViewOption);
                        }
                    } else if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.VIEW)) {
                        BigQueryView bigQueryView = (BigQueryView)((BigQuerySchema)this.this$0.getSchema()).getViews().get(tableOrViewOption.table_name);
                        if (bigQueryView != null) {
                            BigQueryView bigQueryView2 = bigQueryView;
                            boolean bl = false;
                            boolean bl4 = false;
                            BigQueryView $this$apply = bigQueryView2;
                            boolean bl5 = false;
                            BigQuerySchemaRetriever.access$processViewOption(this.this$0, $this$apply, tableOrViewOption);
                        }
                    } else if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TABLE)) {
                        BigQueryTable bigQueryTable = (BigQueryTable)((BigQuerySchema)this.this$0.getSchema()).getTables().get(tableOrViewOption.table_name);
                        if (bigQueryTable != null) {
                            BigQueryTable bigQueryTable2 = bigQueryTable;
                            boolean bl = false;
                            boolean bl6 = false;
                            BigQueryTable $this$apply = bigQueryTable2;
                            boolean bl7 = false;
                            BigQuerySchemaRetriever.access$processTableOption(this.this$0, $this$apply, tableOrViewOption);
                        }
                    } else {
                        this.this$0.log.warn("Incorrect table type: '" + tableOrViewOption.table_type + "'. Detected ObjectKind: '" + kind.name() + '\'');
                    }
                }
                {
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }
            }));
        }

        private final void processLikeTableOption(BigQueryLikeTable likeTable, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            String string = tableOrViewOption.name;
            if (string != null) {
                switch (string) {
                    case "expiration_timestamp": {
                        likeTable.setExpirationTimestamp(tableOrViewOption.value);
                        break;
                    }
                    case "friendly_name": {
                        String string2 = tableOrViewOption.value;
                        likeTable.setFriendlyName(string2 != null ? StringsKt.removeSurrounding((String)string2, (CharSequence)"\"") : null);
                        break;
                    }
                    case "description": {
                        String string3 = tableOrViewOption.value;
                        likeTable.setComment(string3 != null ? StringsKt.removeSurrounding((String)string3, (CharSequence)"\"") : null);
                        break;
                    }
                    case "labels": {
                        likeTable.setLabels(tableOrViewOption.value);
                        break;
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void processTableOption(BigQueryTable table, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            block5: {
                this.processLikeTableOption(table, tableOrViewOption);
                String string = tableOrViewOption.name;
                if (string == null) return;
                String string2 = string;
                switch (string2.hashCode()) {
                    case 749023751: {
                        if (!string2.equals("require_partition_filter")) return;
                        break;
                    }
                    case 2094986649: {
                        if (!string2.equals("kms_key_name")) return;
                        break block5;
                    }
                    case -1838282606: {
                        if (!string2.equals("partition_expiration_days")) return;
                        Double d = (Double)this.parseTableOption(tableOrViewOption, processTableOption.1.INSTANCE);
                        if (d == null) return;
                        Double d2 = d;
                        boolean bl = false;
                        boolean bl2 = false;
                        double it = ((Number)d2).doubleValue();
                        boolean bl3 = false;
                        table.setPartitionExpirationDays(it);
                        return;
                    }
                }
                Boolean bl = (Boolean)this.parseTableOption(tableOrViewOption, processTableOption.3.INSTANCE);
                if (bl == null) return;
                Boolean bl4 = bl;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean it = bl4;
                boolean bl7 = false;
                table.setRequirePartitionFilter(it);
                return;
            }
            table.setKmsKeyName(tableOrViewOption.value);
            return;
        }

        private final void processViewOption(BigQueryView view, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            this.processLikeTableOption(view, tableOrViewOption);
        }

        private final void processMatViewOption(BigQueryMatView view, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            this.processLikeTableOption(view, tableOrViewOption);
            String string = tableOrViewOption.name;
            if (string != null) {
                switch (string) {
                    case "enable_refresh": {
                        Boolean bl = (Boolean)this.parseTableOption(tableOrViewOption, processMatViewOption.1.INSTANCE);
                        if (bl != null) {
                            Boolean bl2 = bl;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            boolean it = bl2;
                            boolean bl5 = false;
                            view.setEnableRefresh(it);
                        }
                        break;
                    }
                    case "refresh_interval_minutes": {
                        Double d = (Double)this.parseTableOption(tableOrViewOption, processMatViewOption.3.INSTANCE);
                        if (d != null) {
                            Double d2 = d;
                            boolean bl = false;
                            boolean bl6 = false;
                            double it = ((Number)d2).doubleValue();
                            boolean bl7 = false;
                            view.setRefreshIntervalMinutes(it);
                        }
                        break;
                    }
                }
            }
        }

        private final <T> T parseTableOption(BigQueryIntroQueries.TableOrViewOption tableOrViewOption, Function1<? super String, ? extends T> parse2) {
            try {
                Object object;
                String optionValue;
                String string = optionValue = tableOrViewOption.value;
                if (string != null) {
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    object = parse2.invoke((Object)optionValue);
                } else {
                    object = null;
                }
                return (T)object;
            }
            catch (Exception e2) {
                this.log.warn("Invalid table option " + tableOrViewOption.name + ": '" + tableOrViewOption.value + "', expected type: " + tableOrViewOption.type);
                return null;
            }
        }

        /*
         * Unable to fully structure code
         */
        private final BigQueryTableColumn processTableColumn(BigQueryTableColumn column, BigQueryIntroQueries.ColumnInfo columnInfo) {
            var3_3 = column;
            var4_4 = false;
            var5_5 = false;
            $this$apply = var3_3;
            $i$a$-apply-BigQueryIntrospector$BigQuerySchemaRetriever$processTableColumn$1 = false;
            $this$apply.setPosition(columnInfo.ordinal_position);
            $this$apply.setDataType(DataTypeFactory.of((String)columnInfo.data_type));
            if (!Intrinsics.areEqual((Object)columnInfo.is_nullable, (Object)"NO")) ** GOTO lbl-1000
            var8_8 = columnInfo.data_type;
            var9_9 = false;
            v0 = var8_8;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v1 = v0.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"(this as java.lang.String).toLowerCase()");
            if (!StringsKt.startsWith$default((String)v1, (String)"array", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            $this$apply.setNotNull(v2);
            $this$apply.setAutoCreated(Intrinsics.areEqual((Object)columnInfo.is_hidden, (Object)"YES"));
            $this$apply.setType(this.getColumnType(columnInfo));
            $this$apply.setClusteringOrdinalPosition(columnInfo.clustering_ordinal_position);
            return var3_3;
        }

        private final BigQueryTableColumnType getColumnType(BigQueryIntroQueries.ColumnInfo column2) {
            return Intrinsics.areEqual((Object)column2.is_partitioning, (Object)"YES") ? BigQueryTableColumnType.PARTITIONING : (column2.clustering_ordinal_position != 0 ? BigQueryTableColumnType.CLUSTERING : BigQueryTableColumnType.REGULAR);
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTableAndViewColumns() {
            void counter;
            boolean bl;
            boolean bl2;
            boolean bl3;
            BigQueryLikeTable t;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.COLUMN");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            boolean $i$f$cleanupFamilies = false;
            Function1 it = BigQuerySchemaRetriever$retrieveTableAndViewColumns$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl4 = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"schema.tables");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryTable)element$iv;
                bl3 = false;
                BigQueryTable bigQueryTable = t;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryTable, (String)"t");
                ModPositioningNamingFamily<? extends BigQueryTableColumn> modPositioningNamingFamily = bigQueryTable.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryView> modNamingFamily2 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"schema.views");
            $this$forEach$iv = (Iterable)modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryView)element$iv;
                bl2 = false;
                BigQueryLikeTable bigQueryLikeTable = t;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryLikeTable, (String)"t");
                ModPositioningNamingFamily<? extends BigQueryViewColumn> modPositioningNamingFamily = bigQueryLikeTable.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily3 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"schema.matViews");
            $this$forEach$iv = (Iterable)modNamingFamily3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryMatView)element$iv;
                bl = false;
                BigQueryLikeTable bigQueryLikeTable = t;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryLikeTable, (String)"t");
                ModPositioningNamingFamily<? extends BigQueryMatViewColumn> modPositioningNamingFamily = bigQueryLikeTable.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
            boolean bl5 = false;
            bl4 = false;
            List colsWithoutPosition = new ArrayList();
            NameCache tableCache = new NameCache();
            Ref.IntRef $i$f$forEach2 = new Ref.IntRef();
            $i$f$forEach2.element = 0;
            Function0<Unit> $fun$tableChanged$1 = new Function0<Unit>(colsWithoutPosition, (Ref.IntRef)counter){
                final /* synthetic */ List $colsWithoutPosition;
                final /* synthetic */ Ref.IntRef $counter;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    boolean bl = false;
                    for (BigQueryLikeColumn col : (Iterable)this.$colsWithoutPosition) {
                        void index2;
                        col.setPosition((short)(this.$counter.element + index2 + 1));
                        ++index2;
                    }
                    this.$colsWithoutPosition.clear();
                    this.$counter.element = 0;
                }
                {
                    this.$colsWithoutPosition = list;
                    this.$counter = intRef;
                    super(0);
                }
            };
            BigQueryIntroQueries.INSTANCE.processColumns(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ColumnInfo, Unit>)((Function1)new Function1<BigQueryIntroQueries.ColumnInfo, Unit>(tableCache, $fun$tableChanged$1, colsWithoutPosition, (Ref.IntRef)counter, this){
                final /* synthetic */ NameCache $tableCache;
                final /* synthetic */ retrieveTableAndViewColumns.2.1 $tableChanged$1;
                final /* synthetic */ List $colsWithoutPosition;
                final /* synthetic */ Ref.IntRef $counter;
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.$tableCache = nameCache;
                    this.$tableChanged$1 = var2_2;
                    this.$colsWithoutPosition = list;
                    this.$counter = intRef;
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke(@NotNull BigQueryIntroQueries.ColumnInfo columnInfo) {
                    Intrinsics.checkNotNullParameter((Object)columnInfo, (String)"columnInfo");
                    var2_2 = this.$tableCache;
                    name$iv = columnInfo.table_name;
                    $i$f$get = false;
                    var5_6 = this_$iv;
                    create$iv$iv = false;
                    $i$f$get = false;
                    if (this_$iv$iv.getV() == null) ** GOTO lbl-1000
                    v0 = this_$iv$iv.getV();
                    Intrinsics.checkNotNull(v0);
                    if (Intrinsics.areEqual((Object)v0.getName(), (Object)name$iv)) {
                        v1 = this_$iv$iv.getV();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_9 = (Function1)new Function1<ModNamingFamily<? extends T>, T>(create$iv$iv, name$iv){
                            final /* synthetic */ boolean $create;
                            final /* synthetic */ String $name;
                            {
                                this.$create = bl;
                                this.$name = string;
                                super(1);
                            }

                            @Nullable
                            public final T invoke(@NotNull ModNamingFamily<? extends T> $this$invoke) {
                                Intrinsics.checkNotNullParameter($this$invoke, (String)"$this$invoke");
                                return (T)(this.$create ? $this$invoke.createOrGet(this.$name) : (BasicModNamedElement)$this$invoke.get(this.$name));
                            }
                        };
                        var9_10 = this_$iv$iv;
                        var10_11 = this_$iv$iv;
                        $i$a$-get-BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$2$2$table$1 = false;
                        this.$tableChanged$1.invoke();
                        v2 = ((BigQuerySchema)this.this$0.getSchema()).getTables();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"schema.tables");
                        v3 = (BigQueryLikeTable)it.invoke(v2);
                        if (v3 == null) {
                            v4 = ((BigQuerySchema)this.this$0.getSchema()).getViews();
                            Intrinsics.checkNotNullExpressionValue(v4, (String)"schema.views");
                            v3 = v5 = (BigQueryLikeTable)it.invoke(v4);
                        }
                        if (v3 == null) {
                            v6 = ((BigQuerySchema)this.this$0.getSchema()).getMatViews();
                            Intrinsics.checkNotNullExpressionValue(v6, (String)"schema.matViews");
                            v5 = (BigQueryLikeTable)it.invoke(v6);
                        }
                        var12_13 = v5;
                        var10_11.setV((BasicModNamedElement)var12_13);
                        v1 = this_$iv$iv.getV();
                    }
                    var3_3 = table = (BigQueryLikeTable)v1;
                    if (var3_3 instanceof BigQueryView || var3_3 instanceof BigQueryMatView) {
                        v7 = table.getColumns().createOrGet(columnInfo.name);
                        if (v7 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.bigquery.model.BigQueryLikeColumn");
                        }
                        v8 = BigQuerySchemaRetriever.access$processViewColumn(this.this$0, (BigQueryLikeColumn)v7, columnInfo);
                    } else if (var3_3 instanceof BigQueryTable) {
                        v9 = ((BigQueryTable)table).getColumns().createOrGet(columnInfo.name);
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"table.columns.createOrGet(columnInfo.name)");
                        v8 = BigQuerySchemaRetriever.access$processTableColumn(this.this$0, (BigQueryTableColumn)v9, columnInfo);
                    } else {
                        v8 = column = null;
                    }
                    if (column != null) {
                        if (column.getPosition() == 0) {
                            this.$colsWithoutPosition.add(column);
                        } else {
                            var3_4 = this.$counter.element;
                            this.$counter.element = var3_4 + 1;
                        }
                    }
                }
            }));
            $fun$tableChanged$1.invoke();
            it = BigQuerySchemaRetriever$retrieveTableAndViewColumns$$inlined$cleanupFamilies$2.INSTANCE;
            $i$a$-cleanupFamilies-BigQueryIntrospector$BigQuerySchemaRetriever$retrieveTableAndViewColumns$1 = false;
            ModNamingFamily<? extends BigQueryTable> modNamingFamily4 = ((BigQuerySchema)this.getSchema()).getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"schema.tables");
            $this$forEach$iv = (Iterable)modNamingFamily4;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryTable)element$iv;
                bl3 = false;
                BigQueryLikeTable bigQueryLikeTable = t;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryLikeTable, (String)"t");
                ModPositioningNamingFamily<? extends BigQueryTableColumn> modPositioningNamingFamily = bigQueryLikeTable.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryView> modNamingFamily5 = ((BigQuerySchema)this.getSchema()).getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"schema.views");
            $this$forEach$iv = (Iterable)modNamingFamily5;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryView)element$iv;
                bl2 = false;
                BigQueryLikeTable bigQueryLikeTable = t;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryLikeTable, (String)"t");
                ModPositioningNamingFamily<? extends BigQueryViewColumn> modPositioningNamingFamily = bigQueryLikeTable.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
            ModNamingFamily<? extends BigQueryMatView> modNamingFamily6 = ((BigQuerySchema)this.getSchema()).getMatViews();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"schema.matViews");
            $this$forEach$iv = (Iterable)modNamingFamily6;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                t = (BigQueryMatView)element$iv;
                bl = false;
                BigQueryLikeTable bigQueryLikeTable = t;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryLikeTable, (String)"t");
                ModPositioningNamingFamily<? extends BigQueryMatViewColumn> modPositioningNamingFamily = bigQueryLikeTable.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"t.columns");
                it.invoke(modPositioningNamingFamily);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final BigQueryLikeColumn processViewColumn(BigQueryLikeColumn column, BigQueryIntroQueries.ColumnInfo columnInfo) {
            var3_3 = column;
            var4_4 = false;
            var5_5 = false;
            $this$apply = var3_3;
            $i$a$-apply-BigQueryIntrospector$BigQuerySchemaRetriever$processViewColumn$1 = false;
            $this$apply.setPosition(columnInfo.ordinal_position);
            $this$apply.setName(columnInfo.name);
            $this$apply.setDataType(DataTypeFactory.of((String)columnInfo.data_type));
            if (!Intrinsics.areEqual((Object)columnInfo.is_nullable, (Object)"NO")) ** GOTO lbl-1000
            var8_8 = columnInfo.data_type;
            var9_9 = false;
            v0 = var8_8;
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v1 = v0.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"(this as java.lang.String).toLowerCase()");
            if (!StringsKt.startsWith$default((String)v1, (String)"array", (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            $this$apply.setNotNull(v2);
            $this$apply.setAutoCreated(Intrinsics.areEqual((Object)columnInfo.is_hidden, (Object)"YES"));
            return var3_3;
        }

        private final void retrieveColumnComments() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.COLUMN");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            BigQueryIntroQueries.INSTANCE.processColumnComments(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.ColumnComment, Unit>)((Function1)new Function1<BigQueryIntroQueries.ColumnComment, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;

                public final void invoke(@NotNull BigQueryIntroQueries.ColumnComment c) {
                    block1: {
                        BigQueryLikeTable table;
                        BigQueryLikeTable bigQueryLikeTable;
                        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                        BigQueryTable bigQueryTable = (BigQueryTable)((BigQuerySchema)this.this$0.getSchema()).getTables().get(c.table_name);
                        BigQueryLikeTable bigQueryLikeTable2 = bigQueryTable != null ? (BigQueryLikeTable)bigQueryTable : (BigQueryLikeTable)((BigQuerySchema)this.this$0.getSchema()).getViews().get(c.table_name);
                        if (bigQueryLikeTable2 == null) {
                            bigQueryLikeTable2 = (BigQueryLikeTable)((BigQuerySchema)this.this$0.getSchema()).getMatViews().get(c.table_name);
                        }
                        if ((bigQueryLikeTable = (table = bigQueryLikeTable2)) == null || (bigQueryLikeTable = bigQueryLikeTable.getColumns()) == null || (bigQueryLikeTable = (BasicModTableOrViewColumn)bigQueryLikeTable.get(c.name)) == null) break block1;
                        BigQueryLikeTable bigQueryLikeTable3 = bigQueryLikeTable;
                        boolean bl = false;
                        boolean bl2 = false;
                        BigQueryLikeTable $this$apply = bigQueryLikeTable3;
                        boolean bl3 = false;
                        $this$apply.setComment(c.description);
                    }
                }
                {
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }
            }));
        }

        private final void retrieveRoutines() {
            BigQueryIntrospector.this.reportRetrieving("Routines", "introspection.retrieve.routinesList");
            boolean accessDenied = false;
            boolean $i$f$cleanupFamilies = false;
            Function1 it = BigQuerySchemaRetriever$retrieveRoutines$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl = false;
            ModNamingFamily<? extends BigQueryRoutine> modNamingFamily = ((BigQuerySchema)this.getSchema()).getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"schema.routines");
            it.invoke(modNamingFamily);
            boolean bl2 = false;
            boolean bl3 = accessDenied = !this.retrieveRoutinesInfo();
            if (accessDenied) {
                this.retrieveRoutinesInfoFromMetaData();
            }
            it = BigQuerySchemaRetriever$retrieveRoutines$$inlined$cleanupFamilies$2.INSTANCE;
            bl = false;
            ModNamingFamily<? extends BigQueryRoutine> modNamingFamily2 = ((BigQuerySchema)this.getSchema()).getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"schema.routines");
            it.invoke(modNamingFamily2);
            if (!accessDenied) {
                this.retrieveRoutineOptions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void retrieveRoutinesInfoFromMetaData() {
            BigQueryDatabase bigQueryDatabase = ((BigQuerySchema)this.getSchema()).getParent();
            Closeable closeable = BigQueryIntrospector.this.createMeta().routines(new DatabaseMetaDataWrapper.Schema(((BigQuerySchema)this.getSchema()).getName(), bigQueryDatabase != null ? bigQueryDatabase.getName() : null), null, null);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ClosableIt it = (ClosableIt)closeable;
                boolean bl3 = false;
                ClosableIt closableIt = it;
                Intrinsics.checkNotNullExpressionValue((Object)closableIt, (String)"it");
                Iterator iterator = (Iterator)((Object)closableIt);
                boolean bl4 = false;
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    DatabaseMetaDataWrapper.Routine routine2 = (DatabaseMetaDataWrapper.Routine)iterator2.next();
                    iterator = ((BigQuerySchema)this.getSchema()).getRoutines().createOrGet(routine2.name);
                    bl4 = false;
                    boolean bl5 = false;
                    BigQueryRoutine $this$apply = (BigQueryRoutine)((Object)iterator);
                    boolean bl6 = false;
                    $this$apply.setName(routine2.name);
                    $this$apply.setRoutineKind(routine2.kind);
                    $this$apply.setComment(routine2.comment);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final boolean retrieveRoutinesInfo() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.sources");
            return BigQueryIntroQueries.INSTANCE.processRoutines(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineInfo, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineInfo, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;

                public final void invoke(@NotNull BigQueryIntroQueries.RoutineInfo routine2) {
                    Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
                    BasicModNamedElement basicModNamedElement = ((BigQuerySchema)this.this$0.getSchema()).getRoutines().createOrGet(routine2.name);
                    boolean bl = false;
                    boolean bl2 = false;
                    BigQueryRoutine $this$apply = (BigQueryRoutine)basicModNamedElement;
                    boolean bl3 = false;
                    $this$apply.setName(routine2.name);
                    $this$apply.setRoutineKind(BigQueryIntrospectorKt.access$getRoutineKind(routine2.routine_kind));
                    $this$apply.setLanguage(routine2.language);
                    $this$apply.setDeterministic(Intrinsics.areEqual((Object)routine2.is_deterministic, (Object)"YES"));
                }
                {
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }
            }));
        }

        private final void retrieveRoutineArguments() {
            boolean bl;
            BigQueryRoutine r;
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ObjectKind.ARGUMENT");
            BigQueryIntrospector.this.reportRetrieving(objectKind);
            boolean $i$f$cleanupFamilies = false;
            Function1 it = BigQuerySchemaRetriever$retrieveRoutineArguments$$inlined$cleanupFamilies$1.INSTANCE;
            boolean bl2 = false;
            ModNamingFamily<? extends BigQueryRoutine> modNamingFamily = ((BigQuerySchema)this.getSchema()).getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"schema.routines");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                r = (BigQueryRoutine)element$iv;
                bl = false;
                BigQueryRoutine bigQueryRoutine = r;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryRoutine, (String)"r");
                ModPositioningNamingFamily<? extends BigQueryArgument> modPositioningNamingFamily = bigQueryRoutine.getArguments();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"r.arguments");
                it.invoke(modPositioningNamingFamily);
            }
            boolean bl3 = false;
            BigQueryIntroQueries.INSTANCE.processRoutineArguments(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineArgumentInfo, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineArgumentInfo, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;
                {
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }

                public final void invoke(@NotNull BigQueryIntroQueries.RoutineArgumentInfo argInfo) {
                    block4: {
                        String it;
                        boolean bl;
                        boolean bl2;
                        String string;
                        BasicModArgument element;
                        BasicModArgument basicModArgument;
                        Intrinsics.checkNotNullParameter((Object)argInfo, (String)"argInfo");
                        String string2 = argInfo.routine_name;
                        if (string2 == null) break block4;
                        String string3 = string2;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        String routine_name = string3;
                        boolean bl5 = false;
                        BigQueryRoutine routine2 = (BigQueryRoutine)((BigQuerySchema)this.this$0.getSchema()).getRoutines().createOrGet(routine_name);
                        if (Intrinsics.areEqual((Object)argInfo.is_result, (Object)"YES")) {
                            basicModArgument = routine2.createOrGetReturnArgument();
                        } else {
                            BigQueryRoutine bigQueryRoutine = routine2;
                            Intrinsics.checkNotNullExpressionValue((Object)bigQueryRoutine, (String)"routine");
                            basicModArgument = (BasicModArgument)bigQueryRoutine.getArguments().createOrGetAt(argInfo.ordinal_position);
                        }
                        BasicModArgument basicModArgument2 = element = basicModArgument;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        BasicModArgument $this$apply = basicModArgument2;
                        boolean bl8 = false;
                        String string4 = argInfo.name;
                        if (string4 != null) {
                            string = string4;
                            bl2 = false;
                            bl = false;
                            it = string;
                            boolean bl9 = false;
                            $this$apply.setName(it);
                        }
                        String string5 = argInfo.data_type;
                        if (string5 != null) {
                            string = string5;
                            bl2 = false;
                            bl = false;
                            it = string;
                            boolean bl10 = false;
                            $this$apply.setDataType(DataTypeFactory.of((String)it));
                        }
                        $this$apply.setArgumentDirection(BigQueryIntrospectorKt.access$getDirection(argInfo));
                    }
                }
            }));
            it = BigQuerySchemaRetriever$retrieveRoutineArguments$$inlined$cleanupFamilies$2.INSTANCE;
            bl2 = false;
            ModNamingFamily<? extends BigQueryRoutine> modNamingFamily2 = ((BigQuerySchema)this.getSchema()).getRoutines();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"schema.routines");
            $this$forEach$iv = (Iterable)modNamingFamily2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                r = (BigQueryRoutine)element$iv;
                bl = false;
                BigQueryRoutine bigQueryRoutine = r;
                Intrinsics.checkNotNullExpressionValue((Object)bigQueryRoutine, (String)"r");
                ModPositioningNamingFamily<? extends BigQueryArgument> modPositioningNamingFamily = bigQueryRoutine.getArguments();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"r.arguments");
                it.invoke(modPositioningNamingFamily);
            }
        }

        private final void retrieveRoutineSources() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.sources");
            BigQueryIntroQueries.INSTANCE.processRoutineSources(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineDefinition, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineDefinition, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;

                public final void invoke(@NotNull BigQueryIntroQueries.RoutineDefinition routine2) {
                    Intrinsics.checkNotNullParameter((Object)routine2, (String)"routine");
                    BasicModNamedElement basicModNamedElement = ((BigQuerySchema)this.this$0.getSchema()).getRoutines().createOrGet(routine2.name);
                    boolean bl = false;
                    boolean bl2 = false;
                    BigQueryRoutine $this$apply = (BigQueryRoutine)basicModNamedElement;
                    boolean bl3 = false;
                    ((BasicModModel)$this$apply.getModel()).writeSources(new Runnable($this$apply, routine2){
                        final /* synthetic */ BigQueryRoutine $this_apply;
                        final /* synthetic */ BigQueryIntroQueries.RoutineDefinition $routine$inlined;
                        {
                            this.$this_apply = bigQueryRoutine;
                            this.$routine$inlined = routineDefinition;
                        }

                        public final void run() {
                            String string = this.$routine$inlined.routine_definition;
                            boolean bl = false;
                            String string2 = string;
                            if (string2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            this.$this_apply.setSourceText((CompositeText)BaseIntrospectionFunctions.toCompositeText(((Object)StringsKt.trim((CharSequence)string2)).toString(), CompositeText.Kind.ORIGINAL_TEXT));
                        }
                    });
                }
                {
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }
            }));
        }

        private final void retrieveRoutineOptions() {
            BigQueryIntrospector.this.reportRetrieving("routine sources", "introspection.retrieve.routine.options");
            BigQueryIntroQueries.INSTANCE.processRoutineOptions(this.getTransaction(), (BigQuerySchema)this.getSchema(), (Function1<? super BigQueryIntroQueries.RoutineOption, Unit>)((Function1)new Function1<BigQueryIntroQueries.RoutineOption, Unit>(this){
                final /* synthetic */ BigQuerySchemaRetriever this$0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void invoke(@NotNull BigQueryIntroQueries.RoutineOption routineOption) {
                    Intrinsics.checkNotNullParameter((Object)routineOption, (String)"routineOption");
                    BigQueryRoutine bigQueryRoutine = (BigQueryRoutine)((BigQuerySchema)this.this$0.getSchema()).getRoutines().get(routineOption.routine_name);
                    if (bigQueryRoutine == null) return;
                    BigQueryRoutine bigQueryRoutine2 = bigQueryRoutine;
                    boolean bl = false;
                    boolean bl2 = false;
                    BigQueryRoutine $this$apply = bigQueryRoutine2;
                    boolean bl3 = false;
                    String string = routineOption.name;
                    if (string == null) return;
                    String string2 = string;
                    switch (string2.hashCode()) {
                        case 166208699: {
                            if (!string2.equals("library")) return;
                            break;
                        }
                        case -1724546052: {
                            if (!string2.equals("description")) return;
                            String string3 = routineOption.value;
                            $this$apply.setComment(string3 != null ? StringsKt.removeSurrounding((String)string3, (CharSequence)"\"") : null);
                            return;
                        }
                    }
                    String string4 = routineOption.value;
                    $this$apply.setLibrary(string4 != null ? StringsKt.removeSurrounding((String)string4, (CharSequence)"\"") : null);
                }
                {
                    this.this$0 = bigQuerySchemaRetriever;
                    super(1);
                }
            }));
        }

        public BigQuerySchemaRetriever(@NotNull DBTransaction transaction, BigQuerySchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseIntrospector)BigQueryIntrospector.this, transaction, (BasicModSchema)schema);
        }

        public static final /* synthetic */ void access$processMatViewOption(BigQuerySchemaRetriever $this, BigQueryMatView view, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            $this.processMatViewOption(view, tableOrViewOption);
        }

        public static final /* synthetic */ void access$processViewOption(BigQuerySchemaRetriever $this, BigQueryView view, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            $this.processViewOption(view, tableOrViewOption);
        }

        public static final /* synthetic */ void access$processTableOption(BigQuerySchemaRetriever $this, BigQueryTable table, BigQueryIntroQueries.TableOrViewOption tableOrViewOption) {
            $this.processTableOption(table, tableOrViewOption);
        }

        public static final /* synthetic */ BigQueryLikeColumn access$processViewColumn(BigQuerySchemaRetriever $this, BigQueryLikeColumn column2, BigQueryIntroQueries.ColumnInfo columnInfo) {
            return $this.processViewColumn(column2, columnInfo);
        }

        public static final /* synthetic */ BigQueryTableColumn access$processTableColumn(BigQuerySchemaRetriever $this, BigQueryTableColumn column2, BigQueryIntroQueries.ColumnInfo columnInfo) {
            return $this.processTableColumn(column2, columnInfo);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector$BigQueryDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/bigquery/model/BigQueryRoot;", "Lcom/intellij/database/dialects/bigquery/model/BigQuerySchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "(Lcom/intellij/database/dialects/bigquery/introspector/BigQueryIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/bigquery/model/BigQueryDatabase;)V", "retrieveSchemas", "", "retrieveSchemasSafe", "", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper$Schema;", "intellij.database.dialects.bigquery"})
    protected final class BigQueryDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<BigQueryDatabase> {
        @Override
        public void retrieveSchemas() {
            this.inDatabase((Function1)new Function1<BigQueryDatabase, Unit>(this){
                final /* synthetic */ BigQueryDatabaseRetriever this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull BigQueryDatabase db) {
                    void $this$applySchemasImpl$iv;
                    Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                    ModNamingFamily<? extends BigQuerySchema> modNamingFamily = db.getSchemas();
                    Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"db.schemas");
                    ModNamingFamily<? extends BigQuerySchema> modNamingFamily2 = modNamingFamily;
                    List scs$iv = BigQueryDatabaseRetriever.access$retrieveSchemasSafe(this.this$0);
                    boolean $i$f$applySchemasImpl = false;
                    $this$applySchemasImpl$iv.markChildrenAsSyncPending();
                    Iterable $this$forEach$iv$iv = scs$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void schema;
                        T element$iv$iv;
                        T sc$iv = element$iv$iv = iterator.next();
                        boolean bl = false;
                        DatabaseMetaDataWrapper.Schema schema2 = (DatabaseMetaDataWrapper.Schema)sc$iv;
                        void $this$applySchemasImpl = $this$applySchemasImpl$iv;
                        boolean bl2 = false;
                        BasicModNamedElement basicModNamedElement = db.getSchemas().createOrGet(schema.schema);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        BigQuerySchema $this$apply = (BigQuerySchema)basicModNamedElement;
                        boolean bl5 = false;
                        $this$apply.setCurrent(Intrinsics.areEqual((Object)BigQueryIntrospector.access$getDbConnectionInfo$p((BigQueryIntrospector)this.this$0.BigQueryIntrospector.this).schemaName, (Object)schema.schema));
                        BigQuerySchema cfr_ignored_0 = (BigQuerySchema)basicModNamedElement;
                    }
                    $this$applySchemasImpl$iv.removeSyncPendingChildren();
                    $this$applySchemasImpl$iv.sort();
                }
                {
                    this.this$0 = bigQueryDatabaseRetriever;
                    super(1);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<DatabaseMetaDataWrapper.Schema> retrieveSchemasSafe() {
            try {
                List list;
                Closeable closeable = BigQueryIntrospector.this.createMeta().schemas((JBIterable<String>)JBIterable.of((Object)((BigQueryDatabase)this.getDatabase()).getName()));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ClosableIt it = (ClosableIt)closeable;
                    boolean bl3 = false;
                    List list2 = it.filter(new Condition(this){
                        final /* synthetic */ BigQueryDatabaseRetriever this$0;
                        {
                            this.this$0 = bigQueryDatabaseRetriever;
                        }

                        public final boolean value(DatabaseMetaDataWrapper.Schema schema) {
                            return Intrinsics.areEqual((Object)schema.database, (Object)BigQueryDatabaseRetriever.access$getDatabase$p(this.this$0).getName());
                        }
                    }).toList();
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createMeta()\n          .\u2026me }.toList()\n          }");
                return list;
            }
            catch (Exception e2) {
                BigQueryIntrospector.this.getErrorSink().consume((Object)("Error while introspecting " + (BigQueryDatabase)this.getDatabase()), (Object)e2);
                return CollectionsKt.emptyList();
            }
        }

        public BigQueryDatabaseRetriever(@NotNull DBTransaction transaction, BigQueryDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)BigQueryIntrospector.this, transaction, (BasicModMateDatabase)database);
        }

        public static final /* synthetic */ List access$retrieveSchemasSafe(BigQueryDatabaseRetriever $this) {
            return $this.retrieveSchemasSafe();
        }

        public static final /* synthetic */ BigQueryDatabase access$getDatabase$p(BigQueryDatabaseRetriever $this) {
            return (BigQueryDatabase)$this.getDatabase();
        }
    }
}

