/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.cassandra.model.CassAggregate;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassIndex;
import com.intellij.database.dialects.cassandra.model.CassKey;
import com.intellij.database.dialects.cassandra.model.CassLikeTable;
import com.intellij.database.dialects.cassandra.model.CassMatView;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.CassTable;
import com.intellij.database.dialects.cassandra.model.CassTableColumn;
import com.intellij.database.dialects.cassandra.model.CassTrigger;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaDefaults;
import com.intellij.database.dialects.cassandra.model.properties.CassKeyColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.properties.IndexColumn;
import com.intellij.database.script.CompositeText;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.cassandra.CassTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlWhereClauseImpl;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#H\u0002J\u0019\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\u0007\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010'J\u0019\u0010(\u001a\u0004\u0018\u00010)2\b\u0010\u0007\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010*J\u0014\u0010+\u001a\u0004\u0018\u00010!2\b\u0010\u0007\u001a\u0004\u0018\u00010&H\u0002J+\u0010,\u001a\u0004\u0018\u00010&2\u0006\u0010-\u001a\u00020&2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u0002000/\"\u000200H\u0002\u00a2\u0006\u0002\u00101J\u0012\u00102\u001a\u0004\u0018\u00010!2\u0006\u0010-\u001a\u00020&H\u0002J\u001e\u00103\u001a\u0010\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u000205\u0018\u0001042\u0006\u0010\u0007\u001a\u00020#H\u0002J\u0010\u00106\u001a\u0002052\u0006\u00107\u001a\u000208H\u0002J$\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@H\u0016J\u0010\u0010A\u001a\u00020!2\u0006\u00107\u001a\u000208H\u0002J\u0012\u0010B\u001a\u0004\u0018\u00010\b2\u0006\u00107\u001a\u000208H\u0002\u00a8\u0006C"}, d2={"Lcom/intellij/database/dialects/cassandra/CassObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "buildAggregate", "Lcom/intellij/database/dialects/cassandra/model/CassAggregate;", "buildFunction", "Lcom/intellij/database/dialects/cassandra/model/CassFunction;", "buildIndex", "Lcom/intellij/database/dialects/cassandra/model/CassIndex;", "buildKey", "Lcom/intellij/database/dialects/cassandra/model/CassKey;", "buildLikeTable", "Lcom/intellij/database/dialects/cassandra/model/CassLikeTable;", "buildMatView", "Lcom/intellij/database/dialects/cassandra/model/CassMatView;", "buildRole", "Lcom/intellij/database/dialects/cassandra/model/CassRole;", "buildSchema", "Lcom/intellij/database/dialects/cassandra/model/CassSchema;", "buildTableColumn", "Lcom/intellij/database/dialects/cassandra/model/CassTableColumn;", "buildTrigger", "Lcom/intellij/database/dialects/cassandra/model/CassTrigger;", "clusteringColNames", "", "", "key", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "findBoolean", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Boolean;", "findDouble", "", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Double;", "findMap", "findPrevSibling", "element", "skip", "", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/PsiElement;[Lcom/intellij/psi/tree/IElementType;)Lcom/intellij/psi/PsiElement;", "findReferenceNameInNextSiblings", "getClusteringColOrder", "", "Lcom/intellij/database/dialects/cassandra/model/properties/CassKeyColumn$Companion$ClusteringOrder;", "getClusteringOrder", "ref", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/script/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getName", "resolve", "intellij.database.dialects.cassandra"})
public final class CassObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof CassTable) {
            this.buildLikeTable((CassLikeTable)obj2, source, context);
        } else if (basicModElement instanceof CassTableColumn) {
            this.buildTableColumn((CassTableColumn)obj2, source, context);
        } else if (basicModElement instanceof CassMatView) {
            this.buildMatView((CassMatView)obj2, source, context);
        } else if (basicModElement instanceof CassKey) {
            this.buildKey((CassKey)obj2, source, context);
        } else if (basicModElement instanceof CassFunction) {
            this.buildFunction((CassFunction)obj2, source, context);
        } else if (basicModElement instanceof CassAggregate) {
            this.buildAggregate((CassAggregate)obj2, source, context);
        } else if (basicModElement instanceof CassTrigger) {
            this.buildTrigger((CassTrigger)obj2, source, context);
        } else if (basicModElement instanceof CassRole) {
            this.buildRole((CassRole)obj2, source, context);
        } else if (basicModElement instanceof CassSchema) {
            this.buildSchema((CassSchema)obj2, source, context);
        } else if (basicModElement instanceof CassIndex) {
            this.buildIndex((CassIndex)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    @Override
    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW) ? TextRange.EMPTY_RANGE : super.getCompactDefinition(path, text, def);
    }

    private final void buildSchema(CassSchema obj2, DasObject source, SqlObjectBuilder.Context context) {
        super.buildNamespace((BasicModNamespace)obj2, source, context);
        if (!(source instanceof SqlCreateStatement)) {
            return;
        }
        obj2.setReplication(CassSchemaDefaults.INSTANCE.getReplication());
        obj2.setDurableWrites(true);
        PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)source), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
        if (psiElement == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"SqlImplUtil.getChildOfTy\u2026OPTIONS_CLAUSE) ?: return");
        PsiElement optionsClause = psiElement;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$forEachChild = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
        PsiElement psiElement2 = optionsClause;
        PsiElement first$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
        boolean $i$f$forEachSibling = false;
        for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
            Object object;
            boolean bl;
            boolean bl2;
            IElementType iElementType;
            PsiElement el = tmp$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement3 = el.getFirstChild();
            Object object2 = iElementType = psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null;
            if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_REPLICATION)) {
                if (this.findMap(el) != null) {
                    bl2 = false;
                    bl = false;
                    Object replication = object;
                    boolean bl4 = false;
                    obj2.setReplication((String)replication);
                }
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DURABLE_WRITES)) continue;
            if (this.findBoolean(el) == null) continue;
            bl2 = false;
            bl = false;
            boolean durable_writes = (Boolean)object;
            boolean bl5 = false;
            obj2.setDurableWrites(durable_writes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildRole(CassRole obj2, DasObject source, SqlObjectBuilder.Context context) {
        CassRole stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.buildBasicElement((BasicModElement)obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_10 = $this$stubbed$iv;
        if (var8_10 instanceof CassRole) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_10 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassRole)) {
                object = null;
            }
            basicElement = (BasicElement)((CassRole)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassRole)basicElement) != null) {
            obj2.setSuperRole(stubbed.isSuperRole());
            obj2.setCanLogin(stubbed.isCanLogin());
        } else {
            boolean isSuperRole = false;
            boolean isCanLogin = false;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)dasObject2), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
            if (psiElement == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"SqlImplUtil.getChildOfTy\u2026OPTIONS_CLAUSE) ?: return");
            PsiElement optionsClause = psiElement;
            SqlObjectBuilderImpl this_$iv2 = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv2;
            PsiElement psiElement2 = optionsClause;
            PsiElement first$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                boolean it;
                Boolean bl;
                boolean bl2;
                boolean bl3;
                IElementType iElementType;
                PsiElement e2 = tmp$iv$iv;
                boolean bl4 = false;
                PsiElement psiElement3 = e2.getFirstChild();
                Object object = iElementType = psiElement3 != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement3) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SUPERUSER)) {
                    if (this.findBoolean(e2) != null) {
                        bl3 = false;
                        bl2 = false;
                        it = bl;
                        boolean bl5 = false;
                        isSuperRole = it;
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LOGIN)) continue;
                if (this.findBoolean(e2) == null) continue;
                bl3 = false;
                bl2 = false;
                it = bl;
                boolean bl6 = false;
                isCanLogin = it;
            }
            obj2.setSuperRole(isSuperRole);
            obj2.setCanLogin(isCanLogin);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTrigger(CassTrigger obj2, DasObject source, SqlObjectBuilder.Context context) {
        String string;
        BasicElement basicElement;
        SqlObjectBuilderImpl $this$stubbed$iv;
        super.buildTrigger(obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed2 = false;
        void var8_8 = $this$stubbed$iv;
        if (var8_8 instanceof CassTrigger) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_8 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassTrigger)) {
                object = null;
            }
            basicElement = (BasicElement)((CassTrigger)object);
        } else {
            basicElement = null;
        }
        CassTrigger stubbed = (CassTrigger)basicElement;
        CassTrigger cassTrigger = obj2;
        if (stubbed != null) {
            string = stubbed.getClassName();
        } else {
            void el$iv;
            void this_$iv2;
            String className = null;
            $this$stubbed$iv = this;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            PsiElement $i$f$stubbed2 = (PsiElement)dasObject2;
            CassTrigger cassTrigger2 = cassTrigger;
            boolean $i$f$forEachChild = false;
            void var9_12 = this_$iv2;
            void v7 = el$iv;
            PsiElement first$iv$iv = v7 != null ? v7.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                String string2;
                IElementType iElementType;
                PsiElement e2 = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement = e2.getFirstChild();
                Object object = iElementType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_USING)) continue;
                if (this.findString(e2.getFirstChild()) == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string2;
                boolean bl4 = false;
                className = it;
            }
            cassTrigger = cassTrigger2;
            string = className;
        }
        cassTrigger.setClassName(string);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAggregate(CassAggregate obj2, DasObject source, SqlObjectBuilder.Context context) {
        CassAggregate stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.buildRoutine(obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_8 = $this$stubbed$iv;
        if (var8_8 instanceof CassAggregate) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_8 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassAggregate)) {
                object = null;
            }
            basicElement = (BasicElement)((CassAggregate)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassAggregate)basicElement) != null) {
            obj2.setStateFunc(stubbed.getStateFunc());
            obj2.setFinalFunc(stubbed.getFinalFunc());
            obj2.setStateType(stubbed.getStateType());
            obj2.setInitCond(stubbed.getInitCond());
        } else {
            String stateFunc = null;
            String finalFunc = null;
            DataType dataType = ModelConsts.NO_DATA_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"NO_DATA_TYPE");
            DataType stateType = dataType;
            String initCond = null;
            if (source instanceof SqlCreateStatement) {
                SqlObjectBuilderImpl this_$iv2 = this;
                boolean $i$f$forEachChild = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv2;
                PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    SqlExpression expression;
                    String funcName;
                    String string;
                    boolean bl;
                    boolean bl2;
                    IElementType iElementType;
                    PsiElement it = tmp$iv$iv;
                    boolean bl3 = false;
                    PsiElement psiElement = it.getFirstChild();
                    Object object = iElementType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SFUNC)) {
                        PsiElement psiElement2 = it.getFirstChild();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"it.firstChild");
                        if (this.findReferenceNameInNextSiblings(psiElement2) != null) {
                            bl2 = false;
                            bl = false;
                            funcName = string;
                            boolean bl4 = false;
                            stateFunc = funcName;
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_FINALFUNC)) {
                        PsiElement psiElement3 = it.getFirstChild();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"it.firstChild");
                        if (this.findReferenceNameInNextSiblings(psiElement3) != null) {
                            bl2 = false;
                            bl = false;
                            funcName = string;
                            boolean bl5 = false;
                            finalFunc = funcName;
                        }
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_STYPE)) {
                        SqlTypeElement typeElement = (SqlTypeElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)it.getFirstChild(), SqlTypeElement.class);
                        if (typeElement == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)typeElement.getDataType(), (String)"typeElement.dataType");
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_INITCOND) || (expression = (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)it.getFirstChild(), SqlExpression.class)) == null) continue;
                    initCond = expression.getText();
                }
            }
            obj2.setStateFunc(stateFunc);
            obj2.setFinalFunc(finalFunc);
            obj2.setStateType(stateType);
            obj2.setInitCond(initCond);
        }
    }

    private final String findReferenceNameInNextSiblings(PsiElement element) {
        SqlReferenceExpression ref2 = (SqlReferenceExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)element, SqlReferenceExpression.class);
        if (ref2 == null) {
            return null;
        }
        DasObject dasObject = this.resolve(ref2);
        return dasObject != null ? dasObject.getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildFunction(CassFunction obj2, DasObject source, SqlObjectBuilder.Context context) {
        CassFunction stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.buildRoutine(obj2, source, context);
        if (!(source instanceof SqlCreateFunctionStatementImpl)) {
            return;
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_9 = $this$stubbed$iv;
        if (var8_9 instanceof CassFunction) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_9 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassFunction)) {
                object = null;
            }
            basicElement = (BasicElement)((CassFunction)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassFunction)basicElement) != null) {
            obj2.setCalledOnNullInput(stubbed.isCalledOnNullInput());
            obj2.setLanguage(stubbed.getLanguage());
        } else {
            void sourceText;
            this_$iv = new Ref.ObjectRef();
            ((Ref.ObjectRef)this_$iv).element = null;
            boolean isCalledOnNullInput = false;
            String language = null;
            SqlObjectBuilderImpl this_$iv2 = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv2;
            PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                IElementType iElementType;
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                PsiElement psiElement = it.getFirstChild();
                Object object = iElementType = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_AS)) {
                    String string;
                    TextRange range;
                    SqlStringLiteralExpression stringLiteral = (SqlStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)it, SqlStringLiteralExpression.class);
                    if (stringLiteral == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)ElementManipulators.getValueTextRange((PsiElement)((PsiElement)stringLiteral)), (String)"ElementManipulators.getV\u2026eTextRange(stringLiteral)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringLiteral.getText(), (String)"stringLiteral.text");
                    int n = range.getStartOffset();
                    int n2 = range.getEndOffset();
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    sourceText.element = (CompositeText)this.asComposite(string3, CompositeText.Kind.ORIGINAL_TEXT);
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CALLED)) {
                    isCalledOnNullInput = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_LANGUAGE)) continue;
                PsiElement psiElement2 = it.getFirstChild();
                SqlTokenType sqlTokenType = SqlTokens.SQL_IDENT;
                Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_IDENT");
                PsiElement lang = this.findSibling(psiElement2, (IElementType)sqlTokenType);
                if (lang == null) continue;
                language = lang.getText();
            }
            this.assignSources(obj2, context, (Function0<? extends CompositeText>)((Function0)new Function0<CompositeText>((Ref.ObjectRef)sourceText){
                final /* synthetic */ Ref.ObjectRef $sourceText;

                @Nullable
                public final CompositeText invoke() {
                    return (CompositeText)this.$sourceText.element;
                }
                {
                    this.$sourceText = objectRef;
                    super(0);
                }
            }));
            obj2.setCalledOnNullInput(isCalledOnNullInput);
            obj2.setLanguage(language);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTableColumn(CassTableColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        CassTableColumn stubbed;
        BasicElement basicElement;
        void $this$stubbed$iv;
        super.build((BasicModElement)obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        SqlObjectBuilderImpl sqlObjectBuilderImpl = $this$stubbed$iv;
        if (sqlObjectBuilderImpl instanceof CassTableColumn) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (sqlObjectBuilderImpl instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassTableColumn)) {
                object = null;
            }
            basicElement = (BasicElement)((CassTableColumn)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (CassTableColumn)basicElement) != null) {
            obj2.setStaticColumn(stubbed.isStaticColumn());
        } else {
            boolean isStatic = false;
            if (source instanceof SqlColumnDefinition) {
                SqlObjectBuilderImpl this_$iv2 = this;
                boolean $i$f$forEachChild = false;
                sqlObjectBuilderImpl = this_$iv2;
                PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
                boolean $i$f$forEachSibling = false;
                for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it = tmp$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)CassTypes.CASS_STATIC)) continue;
                    isStatic = true;
                }
            }
            obj2.setStaticColumn(isStatic);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLikeTable(CassLikeTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        BasicElement basicElement;
        void $this$stubbed$iv$iv;
        void $this$stubbedOrBuild$iv;
        super.buildBasicElement((BasicModElement)obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbedOrBuild = false;
        void var8_7 = $this$stubbedOrBuild$iv;
        SqlObjectBuilderImpl this_$iv$iv = this_$iv;
        boolean $i$f$stubbed = false;
        void var11_11 = $this$stubbed$iv$iv;
        if (var11_11 instanceof CassLikeTable) {
            basicElement = (BasicElement)$this$stubbed$iv$iv;
        } else if (var11_11 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassLikeTable)) {
                object = null;
            }
            basicElement = (BasicElement)((CassLikeTable)object);
        } else {
            basicElement = null;
        }
        BasicElement basicElement2 = basicElement;
        if (basicElement == null) {
            BasicElement basicElement3 = ((BasicElement)obj2).getMetaObject().newDataObject();
            if (basicElement3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dialects.cassandra.model.CassLikeTable");
            }
            BasicElement basicElement4 = (BasicElement)((CassLikeTable)basicElement3);
            boolean bl = false;
            boolean bl2 = false;
            CassLikeTable $this$stubbedOrBuild = (CassLikeTable)basicElement4;
            boolean bl3 = false;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            PsiElement optionsClause = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)dasObject2), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
            SqlObjectBuilderImpl this_$iv2 = this;
            boolean $i$f$forEachChild = false;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv2;
            PsiElement psiElement = optionsClause;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                double d;
                Object object;
                boolean bl4;
                boolean bl5;
                PsiElement el = tmp$iv$iv;
                boolean bl6 = false;
                if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)el), (Object)SqlCompositeElementTypes.SQL_CLAUSE) ^ true) continue;
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)el.getFirstChild());
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMMENT)) {
                    $this$stubbedOrBuild.setComment(this.findString(el.getFirstChild()));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_BLOOM_FILTER_FP_CHANCE)) {
                    if (this.findDouble(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        d = ((Number)object).doubleValue();
                        boolean bl7 = false;
                        $this$stubbedOrBuild.setBloomFilterFpChance(d);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CACHING)) {
                    if (this.findMap(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        Object map2 = object;
                        boolean bl8 = false;
                        $this$stubbedOrBuild.setCaching((String)map2);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CDC)) {
                    if (this.findBoolean(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        boolean bl9 = (Boolean)object;
                        boolean bl10 = false;
                        $this$stubbedOrBuild.setCdc(bl9);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMPACTION)) {
                    if (this.findMap(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        Object map3 = object;
                        boolean bl11 = false;
                        $this$stubbedOrBuild.setCompaction((String)map3);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_COMPRESSION)) {
                    if (this.findMap(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        Object map4 = object;
                        boolean bl12 = false;
                        $this$stubbedOrBuild.setCompression((String)map4);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_CRC_CHECK_CHANCE)) {
                    if (this.findDouble(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        d = ((Number)object).doubleValue();
                        boolean bl13 = false;
                        $this$stubbedOrBuild.setCrcCheckChance(d);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DCLOCAL_READ_REPAIR_CHANCE)) {
                    if (this.findDouble(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        d = ((Number)object).doubleValue();
                        boolean bl14 = false;
                        $this$stubbedOrBuild.setDclocalReadRepairChance(d);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_DEFAULT_TIME_TO_LIVE)) {
                    if (this.findInt(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        int n = ((Number)object).intValue();
                        boolean bl15 = false;
                        $this$stubbedOrBuild.setDefaultTimeToLive(n);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_GC_GRACE_SECONDS)) {
                    if (this.findInt(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        int n = ((Number)object).intValue();
                        boolean bl16 = false;
                        $this$stubbedOrBuild.setGcGraceSeconds(n);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MAX_INDEX_INTERVAL)) {
                    if (this.findInt(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        int n = ((Number)object).intValue();
                        boolean bl17 = false;
                        $this$stubbedOrBuild.setMaxIndexInterval(n);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MEMTABLE_FLUSH_PERIOD_IN_MS)) {
                    if (this.findInt(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        int n = ((Number)object).intValue();
                        boolean bl18 = false;
                        $this$stubbedOrBuild.setMemtableFlushPeriodInMs(n);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_MIN_INDEX_INTERVAL)) {
                    if (this.findInt(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        int n = ((Number)object).intValue();
                        boolean bl19 = false;
                        $this$stubbedOrBuild.setMinIndexInterval(n);
                    }
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_READ_REPAIR_CHANCE)) {
                    if (this.findDouble(el) != null) {
                        bl5 = false;
                        bl4 = false;
                        d = ((Number)object).doubleValue();
                        boolean bl20 = false;
                        $this$stubbedOrBuild.setReadRepairChance(d);
                    }
                    continue;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_SPECULATIVE_RETRY)) continue;
                if (this.findString(el.getFirstChild()) == null) continue;
                bl5 = false;
                bl4 = false;
                Object it = object;
                boolean bl21 = false;
                $this$stubbedOrBuild.setSpeculativeRetry((String)it);
            }
            basicElement2 = basicElement4;
        }
        CassLikeTable src2 = (CassLikeTable)basicElement2;
        obj2.setComment(src2.getComment());
        obj2.setBloomFilterFpChance(src2.getBloomFilterFpChance());
        obj2.setCaching(src2.getCaching());
        obj2.setCdc(src2.isCdc());
        obj2.setCompaction(src2.getCompaction());
        obj2.setCompression(src2.getCompression());
        obj2.setCrcCheckChance(src2.getCrcCheckChance());
        obj2.setDclocalReadRepairChance(src2.getDclocalReadRepairChance());
        obj2.setDefaultTimeToLive(src2.getDefaultTimeToLive());
        obj2.setGcGraceSeconds(src2.getGcGraceSeconds());
        obj2.setMaxIndexInterval(src2.getMaxIndexInterval());
        obj2.setMemtableFlushPeriodInMs(src2.getMemtableFlushPeriodInMs());
        obj2.setMinIndexInterval(src2.getMinIndexInterval());
        obj2.setReadRepairChance(src2.getReadRepairChance());
        obj2.setSpeculativeRetry(src2.getSpeculativeRetry());
    }

    private final CassKeyColumn.Companion.ClusteringOrder getClusteringOrder(SqlReferenceExpression ref2) {
        PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((PsiElement)ref2));
        return Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)SqlCommonKeywords.SQL_DESC) ? CassKeyColumn.Companion.ClusteringOrder.DESC : CassKeyColumn.Companion.ClusteringOrder.ASC;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildKey(CassKey obj2, DasObject source, SqlObjectBuilder.Context context) {
        List list;
        BasicElement basicElement;
        void $this$stubbed$iv;
        obj2.setPrimary(true);
        if (!context.isStubBuilder()) {
            obj2.setName("primary key");
        }
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed2 = false;
        void var8_8 = $this$stubbed$iv;
        if (var8_8 instanceof CassKey) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_8 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassKey)) {
                object = null;
            }
            basicElement = (BasicElement)((CassKey)object);
        } else {
            basicElement = null;
        }
        CassKey stubbed = (CassKey)basicElement;
        CassKey cassKey = obj2;
        if (stubbed != null) {
            list = stubbed.getColumns();
        } else if (!(source instanceof SqlTableKeyDefinition)) {
            list = CollectionsKt.emptyList();
        } else {
            Object object;
            String it;
            Collection<CassKeyColumn> collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            List<String> clusteringColNames = this.clusteringColNames((SqlTableKeyDefinition)source);
            Map<String, CassKeyColumn.Companion.ClusteringOrder> clusteringColOrder = this.getClusteringColOrder((SqlTableKeyDefinition)source);
            Iterable $i$f$stubbed2 = clusteringColNames;
            CassKey cassKey2 = cassKey;
            boolean $i$f$map = false;
            void var9_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object2 = clusteringColOrder;
                if (object2 == null || (object2 = object2.get(it)) == null) {
                    object2 = CassKeyColumn.Companion.ClusteringOrder.ASC;
                }
                object = new CassKeyColumn(it, (CassKeyColumn.Companion.ClusteringOrder)((Object)object2));
                collection.add((CassKeyColumn)object);
            }
            collection = (List)destination$iv$iv;
            Collection collection2 = collection;
            MultiRef multiRef = ((SqlTableKeyDefinition)source).getColumnsRef();
            Intrinsics.checkNotNullExpressionValue((Object)multiRef, (String)"source.columnsRef");
            $this$map$iv = this.collectNames((MultiRef<? extends DasObject>)multiRef);
            collection = collection2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                CassKeyColumn cassKeyColumn = new CassKeyColumn(it, null);
                object.add(cassKeyColumn);
            }
            object = (List)destination$iv$iv;
            cassKey = cassKey2;
            list = CollectionsKt.plus(collection, (Iterable)((Iterable)object));
        }
        cassKey.setColumns(list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> clusteringColNames(SqlTableKeyDefinition key2) {
        SqlColumnDefinitionImpl column2 = (SqlColumnDefinitionImpl)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)key2), SqlColumnDefinitionImpl.class);
        if (column2 != null) {
            return CollectionsKt.emptyList();
        }
        SqlReferenceList[] referenceLists = (SqlReferenceList[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)key2), SqlReferenceList.class);
        if (referenceLists != null && referenceLists.length > 1) {
            void $this$mapTo$iv$iv;
            List list = SqlImplUtil.getReferenceList((SqlReferenceList)referenceLists[1]);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"SqlImplUtil.getReferenceList(referenceLists[1])");
            List list2 = list;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                String string = this.getName((SqlReferenceExpression)v1);
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, CassKeyColumn.Companion.ClusteringOrder> getClusteringColOrder(SqlTableKeyDefinition source) {
        Object v4;
        Iterable iterable;
        block8: {
            void $this$firstOrNull$iv;
            SqlTableDefinition sqlTableDefinition = (SqlTableDefinition)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)source), SqlTableDefinition.class);
            if (sqlTableDefinition == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableDefinition, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
            SqlTableDefinition tableDef = sqlTableDefinition;
            PsiElement psiElement = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)tableDef), (IElementType)CassTypes.CASS_WITH_OPTIONS_CLAUSE);
            if (psiElement == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"SqlImplUtil.getChildOfTy\u2026NS_CLAUSE) ?: return null");
            PsiElement optionsClause = psiElement;
            List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)optionsClause, SqlClause.class);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026e, SqlClause::class.java)");
            iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlClause it = (SqlClause)element$iv;
                boolean bl = false;
                SqlClause sqlClause = it;
                Intrinsics.checkNotNullExpressionValue((Object)sqlClause, (String)"it");
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)sqlClause.getFirstChild()), (Object)CassTypes.CASS_CLUSTERING)) continue;
                v4 = element$iv;
                break block8;
            }
            v4 = null;
        }
        SqlClause sqlClause = v4;
        if (sqlClause != null) {
            iterable = sqlClause;
            boolean bl = false;
            boolean bl2 = false;
            Iterable el = iterable;
            boolean bl3 = false;
            SqlReferenceList referenceList = (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)el), SqlReferenceList.class);
            Object object = referenceList;
            if (object != null && (object = object.getReferenceList()) != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable2 = (Iterable)object;
                boolean $i$f$map = false;
                void var12_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void ref2;
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    void v7 = ref2;
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"ref");
                    Pair pair = new Pair((Object)this.getName((SqlReferenceExpression)v7), (Object)this.getClusteringOrder((SqlReferenceExpression)ref2));
                    collection.add(pair);
                }
                object = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                if (object == null) {
                } else {
                    return object;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildIndex(CassIndex obj2, DasObject source, SqlObjectBuilder.Context context) {
        List list;
        BasicElement basicElement;
        Iterable $this$stubbed$iv;
        this.buildNamedElement((BasicModNamedElement)obj2, source, context);
        DasObject dasObject = source;
        SqlObjectBuilderImpl this_$iv = this;
        boolean $i$f$stubbed = false;
        void var8_7 = $this$stubbed$iv;
        if (var8_7 instanceof CassIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (var8_7 instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            if (!(stubElement instanceof SqlDefinitionStub)) {
                stubElement = null;
            }
            SqlDefinitionStub sqlDefinitionStub = (SqlDefinitionStub)stubElement;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof CassIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((CassIndex)object);
        } else {
            basicElement = null;
        }
        CassIndex stubbed = (CassIndex)basicElement;
        CassIndex cassIndex = obj2;
        if (stubbed != null) {
            list = stubbed.getColumns();
        } else {
            Collection<IndexColumn> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            DasObject dasObject2 = source;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            List list2 = SqlImplUtil.getReferenceList((SqlReferenceList)((SqlReferenceList)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)dasObject2), SqlReferenceList.class)));
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"SqlImplUtil.getReference\u2026ferenceList::class.java))");
            List list3 = list2;
            $this$stubbed$iv = list3;
            CassIndex cassIndex2 = cassIndex;
            boolean $i$f$map = false;
            var8_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IElementType iElementType;
                void expression;
                SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v8 = expression;
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"expression");
                PsiElement psiElement = (PsiElement)v8;
                IElementType[] iElementTypeArray = new IElementType[2];
                IElementType iElementType2 = CassTypes.CASS_LEFT_PAREN;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"CASS_LEFT_PAREN");
                iElementTypeArray[0] = iElementType2;
                IElementType iElementType3 = TokenType.WHITE_SPACE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"WHITE_SPACE");
                iElementTypeArray[1] = iElementType3;
                PsiElement prevSibling = this.findPrevSibling(psiElement, iElementTypeArray);
                String modifier = prevSibling == null ? null : (Intrinsics.areEqual((Object)(iElementType = PsiTreeUtilKt.getElementType((PsiElement)prevSibling)), (Object)CassTypes.CASS_FULL) ? "full" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_KEYS) ? "keys" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_ENTRIES) ? "entries" : (Intrinsics.areEqual((Object)iElementType, (Object)CassTypes.CASS_VALUES) ? "values" : null))));
                IndexColumn indexColumn = new IndexColumn(this.getName((SqlReferenceExpression)expression), modifier);
                collection.add(indexColumn);
            }
            collection = (List)destination$iv$iv;
            cassIndex = cassIndex2;
            list = collection;
        }
        cassIndex.setColumns(list);
    }

    private final PsiElement findPrevSibling(PsiElement element, IElementType ... skip) {
        PsiElement prevSibling;
        for (prevSibling = element.getPrevSibling(); prevSibling != null && ArraysKt.contains((Object[])skip, (Object)PsiTreeUtilKt.getElementType((PsiElement)prevSibling)); prevSibling = prevSibling.getPrevSibling()) {
        }
        return prevSibling;
    }

    private final String getName(SqlReferenceExpression ref2) {
        Object object = this.resolve(ref2);
        if (object == null || (object = object.getName()) == null) {
            String string = ref2.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ref.name");
        }
        return object;
    }

    private final DasObject resolve(SqlReferenceExpression ref2) {
        ResolveResult[] resolveResultArray = ref2.multiResolve(false);
        int n = resolveResultArray.length;
        for (int j = 0; j < n; ++j) {
            ResolveResult result2;
            ResolveResult resolveResult = result2 = resolveResultArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)resolveResult, (String)"result");
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof DasObject)) continue;
            return (DasObject)element;
        }
        return null;
    }

    private final Boolean findBoolean(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_BOOLEAN_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        if (object != null && (object = object.getText()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object text = object2;
            boolean bl3 = false;
            String string = StringUtil.toLowerCase((String)text);
            if (string != null) {
                switch (string) {
                    case "true": {
                        return true;
                    }
                    case "false": {
                        return false;
                    }
                }
            }
            return null;
        }
        return null;
    }

    private final Double findDouble(PsiElement source) {
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_NUMERIC_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes.SQL_NUMERIC_LITERAL");
        PsiElement num = this.findChild(source, (IElementType)sqlCompositeElementType);
        Object object = num;
        return object != null && (object = object.getText()) != null ? StringsKt.toDoubleOrNull((String)object) : null;
    }

    private final String findMap(PsiElement source) {
        IElementType iElementType = CassTypes.CASS_SET_OR_MAP_LITERAL;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"CASS_SET_OR_MAP_LITERAL");
        PsiElement psiElement = this.findChild(source, iElementType);
        return psiElement != null ? psiElement.getText() : null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void buildMatView(CassMatView obj, DasObject source, SqlObjectBuilder.Context context) {
        block12: {
            block11: {
                this.buildLikeTable(obj, source, context);
                var6_4 = source;
                this_$iv = this;
                $i$f$stubbed = false;
                var8_8 = $this$stubbed$iv;
                if (var8_8 instanceof CassMatView) {
                    v0 = (BasicElement)$this$stubbed$iv;
                } else if (var8_8 instanceof SqlStubbedElement) {
                    v1 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    if (!(v1 instanceof SqlDefinitionStub)) {
                        v1 = null;
                    }
                    v2 = (SqlDefinitionStub)v1;
                    v3 /* !! */  = v2 != null ? v2.getElement() : null;
                    if (!(v3 /* !! */  instanceof CassMatView)) {
                        v3 /* !! */  = null;
                    }
                    v0 = (BasicElement)((CassMatView)v3 /* !! */ );
                } else {
                    v0 = null;
                }
                if ((stubbed = (CassMatView)v0) == null) break block11;
                obj.setBaseTableName(stubbed.getBaseTableName());
                obj.setWhereClause(stubbed.getWhereClause());
                break block12;
            }
            v4 = source;
            if (!(v4 instanceof SqlCreateViewStatement)) {
                v4 = null;
            }
            obj.setBaseTableName((v5 = (fromClause = (SqlFromClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)(stmt = (SqlCreateViewStatement)v4)), SqlFromClause.class))) != null && (v5 = v5.getFromExpression()) != null ? v5.getText() : null);
            whereClause = (SqlWhereClauseImpl)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)stmt), SqlWhereClauseImpl.class);
            v6 = whereClause;
            if (v6 == null || (v6 = v6.getText()) == null) ** GOTO lbl-1000
            var8_8 = v6;
            var9_10 = "where".length();
            var10_11 = false;
            v7 = var8_8;
            if (v7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            v8 = v7.substring(var9_10);
            Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"(this as java.lang.String).substring(startIndex)");
            v6 = v8;
            if (v8 != null) {
                var8_8 = v6;
                var9_10 = 0;
                v9 = var8_8;
                if (v9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                v10 = StringsKt.trim((CharSequence)((CharSequence)v9)).toString();
            } else lbl-1000:
            // 2 sources

            {
                v10 = null;
            }
            obj.setWhereClause(v10);
        }
    }
}

