/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.util.DbImplUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsSsoAuthProvider
implements DatabaseAuthProvider {
    public static final String ID = "ms-sso";

    public @Nullable CompletionStage<// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent) {
        if (proto2 == null) {
            MsSsoAuthProvider.$$$reportNull$$$0(0);
        }
        if (!this.isMsSso(proto2.getConnectionPoint().getDataSource())) {
            return null;
        }
        JdbcSettings.INTEGRATED_SECURITY.put(proto2.getExtraProperties(), (Object)true);
        DatabaseCredentialsAuthProvider.applyCredentials((DatabaseConnectionInterceptor.ProtoConnection)proto2, null, (boolean)false);
        return CompletableFuture.completedFuture(proto2);
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message((String)"database.auth.type.windows", (Object[])new Object[0]);
        if (string == null) {
            MsSsoAuthProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isApplicable(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            MsSsoAuthProvider.$$$reportNull$$$0(2);
        }
        return DbImplUtil.supportsDomainAuth((DatabaseDriver)dataSource.getDatabaseDriver());
    }

    protected boolean isMsSso(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            MsSsoAuthProvider.$$$reportNull$$$0(3);
        }
        return dataSource.getDbms().isMicrosoft() && ID.equals(dataSource.getAuthProviderId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proto";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/MsSsoAuthProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/MsSsoAuthProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMsSso";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

