/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseLikeColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/mysqlbase/MysqlBaseGridHelper;", "Lcom/intellij/database/datagrid/GridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "getAttributes", "", "Lcom/intellij/database/datagrid/DataConsumer$Column$Attribute;", "column", "Lcom/intellij/database/model/DasColumn;", "intellij.database.dialects.mysqlbase"})
public final class MysqlBaseGridHelper
implements GridHelper {
    @NotNull
    private final Dbms dbms;

    @NotNull
    public Set<DataConsumer.Column.Attribute> getAttributes(@NotNull DasColumn column2) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        Object object = DbImplUtilCore.unwrap((DasObject)((DasObject)column2));
        if (!(object instanceof MysqlBaseLikeColumn)) {
            object = null;
        }
        MysqlBaseLikeColumn mysqlBaseLikeColumn = (MysqlBaseLikeColumn)object;
        if (mysqlBaseLikeColumn == null) {
            return SetsKt.emptySet();
        }
        MysqlBaseLikeColumn mysqlColumn = mysqlBaseLikeColumn;
        String string = mysqlColumn.getDataType().suffix;
        if (string == null) {
            return SetsKt.emptySet();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mysqlColumn.dataType.suffix ?: return emptySet()");
        String suffix2 = string;
        return StringsKt.endsWith((String)suffix2, (String)"zerofill", (boolean)true) ? SetsKt.setOf((Object)DataConsumer.Column.Attribute.ZERO_PADDING) : SetsKt.emptySet();
    }

    @NotNull
    public Dbms getDbms() {
        return this.dbms;
    }

    public MysqlBaseGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.dbms = dbms;
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return GridHelper.DefaultImpls.createCellCodeFragment((GridHelper)this, (String)text, (Project)project, (Domain)domain);
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return GridHelper.DefaultImpls.createCellCodeFragment((GridHelper)this, (String)text, (Project)project, grid, row, column2);
    }

    @Nullable
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project project, @NotNull String filterText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasTable table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filterText, (String)"filterText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return GridHelper.DefaultImpls.createFilterCodeFragment((GridHelper)this, (Project)project, (String)filterText, (String)queryText, (DbDataSource)dataSource, (DasTable)table);
    }

    @Nullable
    public PsiCodeFragment createSortingCodeFragment(@NotNull Project project, @NotNull String sortingText, @Nullable String queryText, @NotNull DbDataSource dataSource, @Nullable DasTable table) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sortingText, (String)"sortingText");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        return GridHelper.DefaultImpls.createSortingCodeFragment((GridHelper)this, (Project)project, (String)sortingText, (String)queryText, (DbDataSource)dataSource, (DasTable)table);
    }

    @Nullable
    public Language getCellLanguage(@NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return GridHelper.DefaultImpls.getCellLanguage((GridHelper)this, (Domain)domain);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return GridHelper.DefaultImpls.getCellLanguage((GridHelper)this, grid, row, column2);
    }

    @NotNull
    public Language getFilterLanguage() {
        return GridHelper.DefaultImpls.getFilterLanguage((GridHelper)this);
    }

    public void setFilterText(@NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull String text, int caretPosition) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        GridHelper.DefaultImpls.setFilterText((GridHelper)this, grid, (String)text, (int)caretPosition);
    }
}

