/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlVariable;
import com.intellij.database.debugger.SqlVariableKind;
import com.intellij.database.dialects.oracle.debugger.OraProgram;
import com.intellij.database.dialects.oracle.debugger.OracleDebugHelper;
import com.intellij.database.dialects.oracle.generator.OraNamingService;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000p\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a.\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001j\u0004\u0018\u0001`\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a(\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001j\u0004\u0018\u0001`\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a(\u0010\u000f\u001a\u00020\u00102\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u001a&\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u001ab\u0010\u001c\u001a\u0004\u0018\u00010\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00182\b\b\u0002\u0010(\u001a\u00020\u00182\b\b\u0002\u0010)\u001a\u00020\u001eH\u0002\u001a \u0010*\u001a\n\u0012\u0004\u0012\u0002H+\u0018\u00010\u0001\"\u0004\b\u0000\u0010+*\b\u0012\u0004\u0012\u0002H+0\u0001H\u0002\u00a8\u0006,"}, d2={"findEnclosingBlocks", "", "Lcom/intellij/sql/psi/SqlBlockStatement;", "element", "Lcom/intellij/psi/PsiElement;", "findVariables", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "programSource", "Lcom/intellij/database/debugger/SqlProgramSource;", "program", "Lcom/intellij/database/dialects/oracle/debugger/OraProgram;", "lineNr", "", "glueRight", "peekFieldsFromPackage", "", "packageDefinition", "Lcom/intellij/sql/psi/SqlCreateStatement;", "list", "", "peekVariablesFromBlock", "block", "variableKind", "Lcom/intellij/database/debugger/SqlVariableKind;", "peekVariablesFromRoutine", "routineDefinition", "Lcom/intellij/sql/psi/impl/SqlProcedureDefinitionImpl;", "prepareVariable", "name", "", "packageName", "schemaName", "dataType", "Lcom/intellij/database/model/DataType;", "sqlType", "Lcom/intellij/sql/psi/SqlType;", "direction", "Lcom/intellij/database/model/ArgumentDirection;", "kind", "rootKind", "prefix", "orNull", "E", "intellij.database.dialects.oracle.ex"})
@JvmName(name="OraVariableFinderFun")
public final class OraVariableFinderFun {
    @Nullable
    public static final List<SqlVariable> findVariables(@NotNull SqlProgramSource programSource, @Nullable OraProgram program, int lineNr) {
        Intrinsics.checkNotNullParameter((Object)programSource, (String)"programSource");
        PsiFile psiFile = programSource.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        return (List)OracleDebugHelper.inReadAction((Function0)new Function0<List<? extends SqlVariable>>(programSource, lineNr, file, program){
            final /* synthetic */ SqlProgramSource $programSource;
            final /* synthetic */ int $lineNr;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ OraProgram $program;

            @Nullable
            public final List<SqlVariable> invoke() {
                int positionOffset = this.$programSource.getLineOffset(this.$lineNr);
                PsiElement psiElement = this.$file.findElementAt(positionOffset);
                if (psiElement == null) {
                    return null;
                }
                PsiElement positionElement = psiElement;
                positionElement = OraVariableFinderFun.access$glueRight(positionElement);
                return OraVariableFinderFun.access$findVariables(this.$program, positionElement);
            }
            {
                this.$programSource = sqlProgramSource;
                this.$lineNr = n;
                this.$file = psiFile;
                this.$program = oraProgram;
                super(0);
            }
        });
    }

    private static final PsiElement glueRight(PsiElement element) {
        PsiElement next;
        if (element instanceof PsiWhiteSpace && (next = ((PsiWhiteSpace)element).getNextSibling()) != null) {
            return next;
        }
        return element;
    }

    private static final List<SqlBlockStatement> findEnclosingBlocks(PsiElement element) {
        ArrayList blocks = new ArrayList(8);
        for (PsiElement el = element; el != null; el = el.getParent()) {
            if (el instanceof SqlBlockStatement) {
                Collection collection = blocks;
                boolean bl = false;
                collection.add(el);
            }
            if (el instanceof PsiFile) break;
        }
        if (blocks.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        CollectionsKt.reverse((List)blocks);
        return blocks;
    }

    private static final List<SqlVariable> findVariables(OraProgram program, PsiElement element) {
        Object object;
        List list = new ArrayList();
        for (PsiElement elem = element; elem != null; elem = elem.getParent()) {
            object = elem;
            if (object instanceof SqlBlockStatement) {
                OraVariableFinderFun.peekVariablesFromBlock(elem, SqlVariableKind.LOCAL, list);
                continue;
            }
            if (object instanceof SqlProcedureDefinitionImpl) {
                OraVariableFinderFun.peekVariablesFromRoutine((SqlProcedureDefinitionImpl)elem, list);
                break;
            }
            if (!(object instanceof SqlCreateStatement)) continue;
            OraVariableFinderFun.peekFieldsFromPackage(program, (SqlCreateStatement)elem, list);
            break;
        }
        object = list;
        boolean bl = false;
        return !object.isEmpty() ? list : null;
    }

    private static final void peekVariablesFromRoutine(SqlProcedureDefinitionImpl routineDefinition, List<SqlVariable> list) {
        Iterable iterable = routineDefinition.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"routineDefinition.arguments");
        Iterable arguments = iterable;
        for (SqlParameterDefinition argument : arguments) {
            SqlVariable variable = OraVariableFinderFun.prepareVariable$default(argument.getName(), null, null, argument.getDataType(), argument.getSqlType(), argument.getArgumentDirection(), SqlVariableKind.ARG, null, null, 384, null);
            if (variable == null) continue;
            Collection collection = list;
            boolean bl = false;
            collection.add(variable);
        }
        OraVariableFinderFun.peekVariablesFromBlock((PsiElement)routineDefinition, SqlVariableKind.LOCAL, list);
    }

    private static final void peekFieldsFromPackage(OraProgram program, SqlCreateStatement packageDefinition, List<SqlVariable> list) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)((PsiElement)packageDefinition)).filter(SqlVariableDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.sqlChildren(\u2026leDefinition::class.java)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlVariableDefinition it = (SqlVariableDefinition)element$iv;
            boolean bl = false;
            SqlVariableDefinition sqlVariableDefinition = it;
            Intrinsics.checkNotNullExpressionValue((Object)sqlVariableDefinition, (String)"it");
            OraProgram oraProgram = program;
            OraProgram oraProgram2 = program;
            SqlVariable variable = OraVariableFinderFun.prepareVariable$default(sqlVariableDefinition.getName(), oraProgram != null ? oraProgram.getProgramName() : null, oraProgram2 != null ? oraProgram2.getSchemaName() : null, it.getDataType(), it.getSqlType(), null, SqlVariableKind.FIELD, null, null, 384, null);
            if (variable == null) continue;
            Collection collection = list;
            boolean bl2 = false;
            collection.add(variable);
        }
    }

    private static final void peekVariablesFromBlock(PsiElement block, SqlVariableKind variableKind, List<SqlVariable> list) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)block).filter(SqlVariableDefinition.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil.sqlChildren(\u2026leDefinition::class.java)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlVariableDefinition it = (SqlVariableDefinition)element$iv;
            boolean bl = false;
            SqlVariableDefinition sqlVariableDefinition = it;
            Intrinsics.checkNotNullExpressionValue((Object)sqlVariableDefinition, (String)"it");
            SqlVariable variable = OraVariableFinderFun.prepareVariable$default(sqlVariableDefinition.getName(), null, null, it.getDataType(), it.getSqlType(), null, variableKind, null, null, 384, null);
            if (variable == null) continue;
            Collection collection = list;
            boolean bl2 = false;
            collection.add(variable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final SqlVariable prepareVariable(String name2, String packageName, String schemaName, DataType dataType, SqlType sqlType, ArgumentDirection direction, SqlVariableKind kind, SqlVariableKind rootKind, String prefix) {
        CharSequence charSequence = name2;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || dataType == null) {
            return null;
        }
        String qname = prefix + OraNamingService.INSTANCE.catToScript(name2, ObjectKind.VARIABLE, true);
        ArrayList<SqlVariable> fields = null;
        if (sqlType instanceof SqlTableType) {
            int n;
            SqlType.Category category = ((SqlTableType)sqlType).getCategory();
            Intrinsics.checkNotNullExpressionValue((Object)category, (String)"sqlType.category");
            SqlType.Category category2 = category;
            if ((category2 == SqlType.Category.RECORD || category2 == SqlType.Category.TABLE) && (n = ((SqlTableType)sqlType).getColumnCount()) > 0) {
                fields = new ArrayList<SqlVariable>(n);
                int n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    SqlType innerSqlType;
                    void i2;
                    String innerName = ((SqlTableType)sqlType).getColumnName((int)i2);
                    SqlType sqlType2 = innerSqlType = ((SqlTableType)sqlType).getColumnType((int)i2);
                    SqlVariable innerVariable = OraVariableFinderFun.prepareVariable(innerName, packageName, schemaName, (DataType)(sqlType2 != null ? sqlType2.getDataType() : null), innerSqlType, null, SqlVariableKind.FIELD, rootKind, qname + '.');
                    if (innerVariable != null) {
                        fields.add(innerVariable);
                    }
                    ++i2;
                }
            }
        }
        ArrayList<SqlVariable> arrayList = fields;
        return new SqlVariable(name2, qname, packageName, schemaName, kind, rootKind, direction, dataType, arrayList != null ? OraVariableFinderFun.orNull((List)arrayList) : null);
    }

    static /* synthetic */ SqlVariable prepareVariable$default(String string, String string2, String string3, DataType dataType, SqlType sqlType, ArgumentDirection argumentDirection, SqlVariableKind sqlVariableKind, SqlVariableKind sqlVariableKind2, String string4, int n, Object object) {
        if ((n & 0x80) != 0) {
            sqlVariableKind2 = sqlVariableKind;
        }
        if ((n & 0x100) != 0) {
            string4 = "";
        }
        return OraVariableFinderFun.prepareVariable(string, string2, string3, dataType, sqlType, argumentDirection, sqlVariableKind, sqlVariableKind2, string4);
    }

    private static final <E> List<E> orNull(List<? extends E> $this$orNull) {
        Collection collection = $this$orNull;
        boolean bl = false;
        return !collection.isEmpty() ? $this$orNull : null;
    }

    public static final /* synthetic */ PsiElement access$glueRight(PsiElement element) {
        return OraVariableFinderFun.glueRight(element);
    }

    public static final /* synthetic */ List access$findEnclosingBlocks(PsiElement element) {
        return OraVariableFinderFun.findEnclosingBlocks(element);
    }

    public static final /* synthetic */ void access$peekVariablesFromBlock(PsiElement block, SqlVariableKind variableKind, List list) {
        OraVariableFinderFun.peekVariablesFromBlock(block, variableKind, list);
    }

    public static final /* synthetic */ List access$findVariables(OraProgram program, PsiElement element) {
        return OraVariableFinderFun.findVariables(program, element);
    }
}

