/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model.properties;

import com.intellij.openapi.util.text.StringUtil;

public enum PgDataTypeSubCategory {
    NONE('\u0000'),
    ARRAY('A'),
    BOOLEAN('B'),
    COMPOSITE('C'),
    DATE_TIME('D'),
    ENUM('E'),
    GEOMETRIC('G'),
    NETWORK('I'),
    NUMERIC('N'),
    PSEUDO('P'),
    STRING('S'),
    TIME_SPAN('T'),
    USER_DEFINED('U'),
    BIT_STRING('V'),
    UNKNOWN('X');

    public final char code;

    private PgDataTypeSubCategory(char code) {
        this.code = code;
    }

    public static PgDataTypeSubCategory of(char c) {
        switch (Character.toUpperCase(c)) {
            case '\u0000': {
                return NONE;
            }
            case 'A': {
                return ARRAY;
            }
            case 'B': {
                return BOOLEAN;
            }
            case 'C': {
                return COMPOSITE;
            }
            case 'D': {
                return DATE_TIME;
            }
            case 'E': {
                return ENUM;
            }
            case 'G': {
                return GEOMETRIC;
            }
            case 'I': {
                return NETWORK;
            }
            case 'N': {
                return NUMERIC;
            }
            case 'P': {
                return PSEUDO;
            }
            case 'S': {
                return STRING;
            }
            case 'T': {
                return TIME_SPAN;
            }
            case 'U': {
                return USER_DEFINED;
            }
            case 'V': {
                return BIT_STRING;
            }
        }
        return UNKNOWN;
    }

    public String human_readable_name() {
        return StringUtil.toLowerCase((String)this.name()).replace('_', ' ');
    }
}

