/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model;

import com.intellij.database.dialects.postgresbase.model.PgBaseDescriptionService$WhenMappings;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.PgBaseRoutine;
import com.intellij.database.dialects.postgresbase.model.properties.PgRoutineKind;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fH\u0014J,\u0010\r\u001a\u00020\n\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0010\u0010\u000b\u001a\f\u0012\u0004\u0012\u0002H\u000e\u0012\u0002\b\u00030\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/postgresbase/model/PgBaseDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "describeRoutine", "", "r", "Lcom/intellij/database/model/basic/BasicRoutine;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "ignoreAutoDescribe", "", "property", "Lcom/intellij/database/model/meta/BasicMetaPropertyId;", "isPropertyValueDefault", "T", "Lcom/intellij/database/model/basic/BasicElement;", "e", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "intellij.database.dialects.postgresbase"})
public abstract class PgBaseDescriptionService
extends DescriptionService {
    protected boolean ignoreAutoDescribe(@Nullable BasicMetaPropertyId<?> property) {
        return Intrinsics.areEqual(property, PgBaseObjectWithOwner.OWNER) || super.ignoreAutoDescribe(property);
    }

    protected <T extends BasicElement> boolean isPropertyValueDefault(@NotNull BasicElement e2, @NotNull BasicMetaProperty<T, ?> property) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        if (e2 instanceof PgBaseRoutine && Intrinsics.areEqual((Object)property.id, PgBaseRoutine.LANGUAGE_NAME)) {
            return StringsKt.equals((String)"plpgsql", (String)((PgBaseRoutine)e2).getLanguageName(), (boolean)true);
        }
        return super.isPropertyValueDefault(e2, property);
    }

    @NotNull
    protected String describeRoutine(@NotNull BasicRoutine r, @NotNull DescriptionService.Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection collection = context.getDescribed();
        BasicMetaPropertyId<PgRoutineKind> basicMetaPropertyId = PgBaseRoutine.PG_ROUTINE_KIND;
        boolean bl = false;
        collection.add(basicMetaPropertyId);
        BasicRoutine basicRoutine = r;
        if (!(basicRoutine instanceof PgBaseRoutine)) {
            basicRoutine = null;
        }
        PgBaseRoutine pgBaseRoutine = (PgBaseRoutine)basicRoutine;
        if (pgBaseRoutine == null) {
            return super.describeRoutine(r, context);
        }
        PgBaseRoutine routine2 = pgBaseRoutine;
        switch (PgBaseDescriptionService$WhenMappings.$EnumSwitchMapping$0[routine2.getPgRoutineKind().ordinal()]) {
            case 1: {
                string = "function";
                break;
            }
            case 2: {
                string = "procedure";
                break;
            }
            case 3: {
                string = "trigger function";
                break;
            }
            case 4: {
                string = "event trigger function";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }
}

