/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFlakeDialect
extends AbstractDatabaseDialect {
    protected SFlakeDialect() {
        super(new TypeHelper.SFlakeTypeHelper());
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            SFlakeDialect.$$$reportNull$$$0(0);
        }
        if (qualifier == null) {
            SFlakeDialect.$$$reportNull$$$0(1);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), catalog, DasUtil.getName((DasObject)catalog), null, null);
        if (ddlBuilder == null) {
            SFlakeDialect.$$$reportNull$$$0(2);
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            SFlakeDialect.$$$reportNull$$$0(3);
        }
        if (sequence == null) {
            SFlakeDialect.$$$reportNull$$$0(4);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL((DdlBuilder)builder, (DasObject)sequence, (Boolean)cascade);
        if (ddlBuilder == null) {
            SFlakeDialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        String schema;
        if (element == null) {
            SFlakeDialect.$$$reportNull$$$0(6);
        }
        if ("INFORMATION_SCHEMA".equals(schema = DasUtil.getSchema((DasObject)element))) {
            return null;
        }
        return Pair.create((Object)("select get_ddl('VIEW', '" + new DdlBuilder().withDialect((DatabaseDialectEx)this).qualifiedRef(element).getStatement().replace("'", "''") + "')"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
    }

    @NotNull
    public Pair<String, DbImplUtilCore.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            SFlakeDialect.$$$reportNull$$$0(7);
        }
        DdlBuilder builder = new DdlBuilder().withDialect((DatabaseDialectEx)this).qualifiedRef((DasObject)element);
        builder.plain("(");
        int length = builder.length();
        for (DasArgument argument : element.getArguments()) {
            if (builder.length() != length) {
                builder.plain(", ");
            }
            builder.type(argument.getDataType());
        }
        builder.plain(")");
        Pair pair = Pair.create((Object)("select get_ddl('FUNCTION', '" + builder.getStatement().replace("'", "''") + "')"), (Object)DbImplUtilCore.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            SFlakeDialect.$$$reportNull$$$0(8);
        }
        return pair;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SNOWFLAKE;
        if (dbms == null) {
            SFlakeDialect.$$$reportNull$$$0(9);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Snowflake";
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        boolean isDb;
        if (path == null) {
            SFlakeDialect.$$$reportNull$$$0(10);
        }
        ObjectPath cur = path.getCurrent();
        boolean bl = isDb = cur.kind == ObjectKind.DATABASE;
        if (!isDb && cur.kind != ObjectKind.SCHEMA) {
            return null;
        }
        DdlBuilder builder = new DdlBuilder().withDialect((DatabaseDialectEx)this).quoteIdentifiers(true);
        builder.keywords(new String[]{"use", isDb ? "database" : "schema"}).space();
        if (!isDb && cur.parent != null) {
            builder.identifier(cur.parent.name).symbol(".");
        }
        builder.identifier(cur.name);
        return builder.getStatement();
    }

    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnectionCore connection) throws SQLException {
        String schema;
        String db;
        if (system == null) {
            SFlakeDialect.$$$reportNull$$$0(11);
        }
        if (connection == null) {
            SFlakeDialect.$$$reportNull$$$0(12);
        }
        try {
            db = connection.getRemoteConnection().getCatalog();
            schema = connection.getRemoteConnection().getSchema();
        }
        catch (RemoteException e2) {
            ExceptionUtil.rethrow((Throwable)RemoteUtil.unwrap((Throwable)e2));
            return null;
        }
        if (StringUtil.isEmpty((String)db)) {
            return null;
        }
        ObjectPath dbPath = ObjectPath.create((String)db, (ObjectKind)ObjectKind.DATABASE);
        if (StringUtil.isEmpty((String)schema)) {
            return SearchPath.of((ObjectPath)dbPath);
        }
        ObjectPath scPath = dbPath.append(schema, ObjectKind.SCHEMA);
        if ("PUBLIC".equals(schema)) {
            return SearchPath.of((ObjectPath)scPath);
        }
        return SearchPath.of(Arrays.asList(scPath, dbPath.append("PUBLIC", ObjectKind.SCHEMA)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

