/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.db2;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.db2.Db2DdlParsing;
import com.intellij.sql.dialects.db2.Db2DmlParsing;
import com.intellij.sql.dialects.db2.Db2ExpressionParsing;
import com.intellij.sql.dialects.db2.Db2GeneratedParser;
import com.intellij.sql.dialects.db2.Db2PlParsing;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlCommonTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Db2ParserBase
extends SqlParser {
    private final SqlSuggestedInjection myInjection;

    public Db2ParserBase(@NotNull SqlLanguageDialectEx language) {
        if (language == null) {
            Db2ParserBase.$$$reportNull$$$0(0);
        }
        super(language);
        this.myInjection = new SqlSuggestedInjection(language.getID());
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return Db2GeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return Db2GeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return Db2DmlParsing.query_expression(builder, level, -1);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return Db2GeneratedParser.parse_root_(root2, builder, level);
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, Db2DmlParsing::parenthesized_aliased_join_expression, Db2DmlParsing::top_query_expression, Db2ParserBase::parseTopQueryExpressionTail, Db2ParserBase::parseNonAtomJoin, (b, l) -> Db2DmlParsing.join_expression_0(b, l, -1));
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, Db2ExpressionParsing::parenthesized_values_expr, Db2DmlParsing::top_query_expression, Db2ParserBase::parseTopQueryExpressionTail, Db2ExpressionParsing::row_element_list, (b, l) -> Db2ExpressionParsing.root_expr_0(b, l, -1) && Db2ExpressionParsing.row_element_list_separator(b, l) && Db2ExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = Db2ExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, Db2ExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return Db2PlParsing.table_type_element(builder, level) || Db2DdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        Db2GeneratedParser.aggregate_clause(builder, level);
        Db2GeneratedParser.keep_clause(builder, level);
        Db2GeneratedParser.analytic_clause(builder, level);
        return true;
    }

    @Override
    public boolean canBeCalled(IElementType type) {
        return super.canBeCalled(type) || type == SQL_METHOD_REFERENCE || type == SQL_PROCEDURE_REFERENCE;
    }

    @Override
    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return this.myInjection;
    }

    @Override
    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return Db2GeneratedParser.table_opt_column_list(builder, level);
    }

    @Override
    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        return this.parseNamedFunctionArgumentPrefixImpl(builder, (IElementType)SqlCommonTokens.ORA_OP_NAMED_PARAM_BINDING);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        Db2DmlParsing.query_expression_0(builder, level, -1);
        return Db2DmlParsing.left_inner_table_op_tail(builder, level);
    }

    public static boolean parseNonAtomJoin(PsiBuilder builder, int level) {
        if (!Db2DmlParsing.atom_join_expression(builder, level)) {
            return false;
        }
        int offset = builder.getCurrentOffset();
        Db2DmlParsing.join_expression_0(builder, level, -1);
        GeneratedParserUtilBase.report_error_((PsiBuilder)builder, (offset != builder.getCurrentOffset() ? 1 : 0) != 0);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/sql/dialects/db2/Db2ParserBase", "<init>"));
    }
}

